/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecDSSDataAttributes;
import hec.heclib.dss.HecDSSFileAccess;
import hec.heclib.dss.HecDSSRecordData;
import hec.heclib.dss.HecDSSRecordInfo;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.util.HecTime;
import hec.heclib.util.Heclib;
import hec.heclib.util.StringArrayContainer;
import hec.heclib.util.doubleArrayContainer;
import hec.heclib.util.intContainer;
import hec.heclib.util.stringContainer;
import hec.io.DataContainer;
import hec.util.TextDialog;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;

public class HecDataManager
extends HecDSSDataAttributes {
    protected HecDSSRecordData _recordData;
    protected static int messageUnit = -1;
    protected static String logFileName = null;

    public HecDataManager() {
    }

    public HecDataManager(String DssFileName) {
        this.setDSSFileName(DssFileName);
    }

    public HecDataManager(String DssFileName, int version) {
        this.setDSSFileName(DssFileName, version);
    }

    protected void release() {
        this.release(false);
    }

    protected void release(boolean closeFileIfNotUsed) {
        this._fileData.releaseFile(closeFileIfNotUsed);
    }

    @Override
    public void done() {
        if (this._recordData != null) {
            this._recordData.myThis = null;
            this._recordData = null;
        }
        this.release(false);
        this._dirty = true;
        this._recordType = 0;
        this._localUnitSystem = 0;
    }

    public void clear() {
        if (this._recordData != null) {
            this._recordData.arrayX = null;
            this._recordData.arrayY = null;
            this._recordData.times = null;
            this._recordData.flags = null;
            this._recordData.arraySize = 0;
            this._recordData.numberCurves = 0;
            this._recordData.labelsUsed = false;
            this._recordData.timeOffset = 0;
            this._recordData.unitsX = "";
            this._recordData.typeX = "";
            this._recordData.unitsY = "";
            this._recordData.typeY = "";
            this._recordData.precision = 0;
            this._recordData.containsData = false;
            this._recordData.dataSavedToDisk = false;
        }
    }

    public static int setLogFile(String programName) {
        String name = programName.startsWith("/") || programName.charAt(1) == ':' ? programName : HecDataManager.generateLogFileName(programName);
        int status = HecDataManager.setMessageFile(name);
        logFileName = status == 0 ? name : null;
        return status;
    }

    public static String getLogFileName() {
        return logFileName;
    }

    public static TextDialog displayLogFile(Component parent) {
        if (logFileName == null) {
            return null;
        }
        HecDataManager.flushMessageFile();
        TextDialog textDialog = new TextDialog(parent);
        try {
            textDialog.initialize(logFileName, false);
            textDialog.setLocation(20, 20);
            textDialog.setSize(700, 500);
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
        return textDialog;
    }

    public static void closeLogFile() {
        HecDataManager.closeMessageFile();
    }

    protected static String generateLogFileName(String programName) {
        String name;
        File f;
        String pathSeparator = System.getProperty("file.separator");
        Object tempDirectory = System.getProperty("java.io.tmpdir");
        if (!((String)tempDirectory).endsWith(pathSeparator)) {
            tempDirectory = (String)tempDirectory + pathSeparator;
        }
        if (!(f = new File((String)tempDirectory)).isDirectory()) {
            f.mkdirs();
        }
        if ((f = new File(name = (String)tempDirectory + programName + "_dss.log")).exists() && !f.delete()) {
            for (int i = 0; i < 100; ++i) {
                String tryName = (String)tempDirectory + programName + "_dss_" + Integer.toString(i) + ".log";
                f = new File(tryName);
                if (f.exists()) {
                    if (!f.delete()) continue;
                    name = tryName;
                    break;
                }
                name = tryName;
                break;
            }
        }
        return name;
    }

    public static int setMessageFile(String filename) {
        messageUnit = 15;
        int status = Heclib.fortranOpen(filename, messageUnit);
        if (status == 0) {
            HecDataManager.zset("MUNIT", " ", messageUnit);
        } else {
            messageUnit = -1;
        }
        return status;
    }

    public static void flushMessageFile() {
        if (messageUnit >= 0) {
            Heclib.fortranFlush(messageUnit);
        }
    }

    public static void closeMessageFile() {
        HecDataManager.zset("MUNIT", " ", 6);
        if (messageUnit > 0) {
            Heclib.fortranClose(messageUnit);
            messageUnit = -1;
        }
    }

    public static void setProgramName(String programName) {
        HecDSSFileAccess.zset("PROG", programName, 0);
    }

    public int addAlias(String aliasPathname) {
        return this.addAlias(this.pathname(), aliasPathname);
    }

    public int addAlias(String primaryPathname, String aliasPathname) {
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        int status = Heclib.zaliasAdd(dssTable, primaryPathname, aliasPathname);
        this.checkForSevereError(dssTable);
        this._fileData.releaseAccess(lockThreadToken);
        if (HecDataManager.checkForSevereError()) {
            return -1;
        }
        return status;
    }

    public int addAlias(CondensedReference primary, DSSPathname aliasPart) {
        int status = 0;
        DSSPathname path = new DSSPathname();
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        String[] list = primary.pathnameList;
        for (int i = 0; i < list.length; ++i) {
            DSSPathname primaryPathname = new DSSPathname(list[i]);
            DSSPathname aliasPathname = new DSSPathname(list[i]);
            if (aliasPart.aPart().length() > 0) {
                aliasPathname.setAPart(aliasPart.aPart());
            }
            if (aliasPart.bPart().length() > 0) {
                aliasPathname.setBPart(aliasPart.bPart());
            }
            if (aliasPart.cPart().length() > 0) {
                aliasPathname.setCPart(aliasPart.cPart());
            }
            if (aliasPart.dPart().length() > 0) {
                aliasPathname.setDPart(aliasPart.dPart());
            }
            if (aliasPart.ePart().length() > 0) {
                aliasPathname.setEPart(aliasPart.ePart());
            }
            if (aliasPart.fPart().length() > 0) {
                aliasPathname.setFPart(aliasPart.fPart());
            }
            if (primaryPathname.isSamePathname(aliasPathname.pathname(), false) || (status = Heclib.zaliasAdd(dssTable, primaryPathname.pathname(), aliasPathname.pathname())) < 0) break;
        }
        this.checkForSevereError(dssTable);
        this._fileData.releaseAccess(lockThreadToken);
        if (HecDataManager.checkForSevereError()) {
            return -1;
        }
        return status;
    }

    public int addAliasList(String[] primaryPathnameList, String[] aliasPathnameList) {
        int status = 0;
        if (primaryPathnameList.length != aliasPathnameList.length) {
            return -1;
        }
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        for (int i = 0; i < primaryPathnameList.length && (status = Heclib.zaliasAdd(dssTable, primaryPathnameList[i], aliasPathnameList[i])) >= 0; ++i) {
        }
        this.checkForSevereError(dssTable);
        this._fileData.releaseAccess(lockThreadToken);
        if (HecDataManager.checkForSevereError()) {
            return -1;
        }
        return status;
    }

    public String aliasGetPrimary() {
        return this.aliasGetPrimary(this.pathname());
    }

    public String aliasGetPrimary(String aliasPathname) {
        stringContainer primaryPathname = new stringContainer();
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return null;
        }
        int status = Heclib.zaliasGetPrimary(dssTable, aliasPathname, primaryPathname);
        this.checkForSevereError(dssTable);
        this._fileData.releaseAccess(lockThreadToken);
        if (HecDataManager.checkForSevereError()) {
            return null;
        }
        if (status >= 0) {
            return primaryPathname.string;
        }
        return null;
    }

    public int aliasRemove(boolean removeAll) {
        return this.aliasRemove(this.pathname(), removeAll);
    }

    public int aliasRemove(String aliasPathname, boolean removeAll) {
        stringContainer primaryPathname = new stringContainer();
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        int status = Heclib.zaliasRemove(dssTable, aliasPathname, removeAll);
        this.checkForSevereError(dssTable);
        this._fileData.releaseAccess(lockThreadToken);
        if (HecDataManager.checkForSevereError()) {
            return -1;
        }
        return status;
    }

    public int aliasRemoveList(String[] aliasPathnameList) {
        int status = 0;
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        for (int i = 0; i < aliasPathnameList.length && (status = Heclib.zaliasRemove(dssTable, aliasPathnameList[i], false)) >= 0; ++i) {
        }
        this.checkForSevereError(dssTable);
        this._fileData.releaseAccess(lockThreadToken);
        if (HecDataManager.checkForSevereError()) {
            return -1;
        }
        return status;
    }

    public String[] aliasList() {
        return this.aliasList(this.pathname());
    }

    public String[] aliasList(String aliasPathname) {
        StringArrayContainer pathList = new StringArrayContainer();
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return new String[0];
        }
        int status = Heclib.zaliasList(dssTable, aliasPathname, pathList);
        this.checkForSevereError(dssTable);
        this._fileData.releaseAccess(lockThreadToken);
        if (HecDataManager.checkForSevereError()) {
            return new String[0];
        }
        if (status > 0 && pathList.stringArray != null) {
            return pathList.stringArray;
        }
        return new String[0];
    }

    public int zlocationRetrieve(DataContainer dataContainer) {
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        int status = Heclib.zlocationRetrieve(dssTable, dataContainer);
        this.checkForSevereError(dssTable);
        this._fileData.releaseAccess(lockThreadToken);
        if (HecDataManager.checkForSevereError()) {
            return -1;
        }
        return status;
    }

    public int zlocationStore(DataContainer dataContainer) {
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        int status = Heclib.zlocationStore(dssTable, dataContainer);
        this.checkForSevereError(dssTable);
        this._fileData.releaseAccess(lockThreadToken);
        if (HecDataManager.checkForSevereError()) {
            return -1;
        }
        return status;
    }

    public int numberArray() {
        if (this._recordData != null) {
            return this._recordData.arraySize;
        }
        return 0;
    }

    public void Xarray(doubleArrayContainer X) {
        if (this._recordData != null) {
            X.array = this._recordData.arrayX;
            X.length = this._recordData.arraySize;
        } else {
            X.array = null;
            X.length = 0;
        }
    }

    public void Yarray(doubleArrayContainer[] Y) {
        if (this._recordData != null) {
            for (int i = 0; i < this._recordData.numberCurves; ++i) {
                Y[i].array = this._recordData.arrayY[i];
                Y[i].length = this._recordData.arraySize;
            }
        } else {
            Y[0].array = null;
            Y[0].length = 0;
        }
    }

    public void Yarray(doubleArrayContainer Y) {
        if (this._recordData != null) {
            Y.array = this._recordData.arrayY[0];
            Y.length = this._recordData.arraySize;
        } else {
            Y.array = null;
            Y.length = 0;
        }
    }

    public int convertUnitSystem(int unitSystem) {
        int status;
        if (unitSystem == 0) {
            return 0;
        }
        if (unitSystem == this._localUnitSystem) {
            return 0;
        }
        if (this._recordData == null) {
            return -2;
        }
        if (!this._recordData.containsData || this._recordData.arraySize == 0) {
            return -1;
        }
        if (this._localUnitSystem == 0) {
            this.localUnitSystem();
        }
        if (this._localUnitSystem == 0) {
            return -2;
        }
        stringContainer units = new stringContainer();
        if (this._recordData.arrayX != null) {
            units.string = this._recordData.unitsX.toLowerCase();
            status = HecDataManager.convertUnits(this._recordData.arrayX, this._recordData.arraySize, this._localUnitSystem, unitSystem, units);
            this._recordData.unitsX = units.string;
            this._unitsX = units.string;
            if (status != 0) {
                return status;
            }
        }
        if (this._recordData.arrayY != null) {
            status = 0;
            for (int i = 0; i < this._recordData.numberCurves; ++i) {
                status = HecDataManager.convertUnits(this._recordData.arrayY[i], this._recordData.arraySize, this._localUnitSystem, unitSystem, units);
            }
            this._recordData.unitsY = units.string;
            if (status != 0) {
                return status;
            }
        }
        this._localUnitSystem = unitSystem;
        return 0;
    }

    @Override
    public void status() {
        super.status();
        if (this._recordData != null) {
            this._recordData.status();
        }
    }

    protected void copyRecordDataToContainer(DataContainer dataContainer) {
        dataContainer.fileName = this.DSSFileName();
        dataContainer.fullName = this.pathname();
        dataContainer.watershed = this.aPart();
        dataContainer.location = this.bPart();
        dataContainer.version = this.fPart();
        dataContainer.subVersion = "";
        dataContainer.supplementalInfo = this._recordData.supplementalInfo;
        dataContainer.storedAsdoubles = this._recordData.storeDoubles;
        if (this._recordData.ordinates != null) {
            dataContainer.xOrdinate = this._recordData.ordinates.length >= 1 ? this._recordData.ordinates[0] : 0.0;
            dataContainer.yOrdinate = this._recordData.ordinates.length >= 2 ? this._recordData.ordinates[1] : 0.0;
            dataContainer.zOrdinate = this._recordData.ordinates.length >= 3 ? this._recordData.ordinates[2] : 0.0;
        } else {
            dataContainer.xOrdinate = 0.0;
            dataContainer.yOrdinate = 0.0;
            dataContainer.zOrdinate = 0.0;
        }
        if (this._recordData.ordinateDescription != null) {
            if (this._recordData.ordinateDescription.length >= 1) {
                dataContainer.coordinateSystem = this._recordData.ordinateDescription[0];
            }
            if (this._recordData.ordinateDescription.length >= 2) {
                dataContainer.coordinateID = this._recordData.ordinateDescription[1];
            }
            if (this._recordData.ordinateDescription.length >= 3) {
                dataContainer.horizontalUnits = this._recordData.ordinateDescription[2];
            }
            if (this._recordData.ordinateDescription.length >= 4) {
                dataContainer.horizontalDatum = this._recordData.ordinateDescription[3];
            }
            if (this._recordData.ordinateDescription.length >= 5) {
                dataContainer.verticalUnits = this._recordData.ordinateDescription[4];
            }
            if (this._recordData.ordinateDescription.length >= 6) {
                dataContainer.verticalDatum = this._recordData.ordinateDescription[5];
            }
        }
    }

    public int copyContainerToRecordData(DataContainer dataContainer) {
        int status = 0;
        if (dataContainer.fileName != null && dataContainer.fileName.length() > 0 && (status = this.setDSSFileName(dataContainer.fileName)) < 0) {
            return status;
        }
        status = this.setPathname(dataContainer.fullName);
        if (status < 0) {
            return status;
        }
        this._recordData.supplementalInfo = dataContainer.supplementalInfo;
        if (dataContainer.xOrdinate != 0.0 || dataContainer.yOrdinate != 0.0 || dataContainer.zOrdinate != 0.0) {
            this._recordData.ordinates = new double[3];
            this._recordData.ordinates[0] = dataContainer.xOrdinate;
            this._recordData.ordinates[1] = dataContainer.yOrdinate;
            this._recordData.ordinates[2] = dataContainer.zOrdinate;
            this._recordData.ordinateDescription = new int[6];
            this._recordData.ordinateDescription[0] = dataContainer.coordinateSystem;
            this._recordData.ordinateDescription[1] = dataContainer.coordinateID;
            this._recordData.ordinateDescription[2] = dataContainer.horizontalUnits;
            this._recordData.ordinateDescription[3] = dataContainer.horizontalDatum;
            this._recordData.ordinateDescription[4] = dataContainer.verticalUnits;
            this._recordData.ordinateDescription[5] = dataContainer.verticalDatum;
        } else {
            this._recordData.ordinates = null;
        }
        return status;
    }

    public HecDSSRecordInfo getRecordInfo() {
        HecDSSRecordInfo recordInfo = new HecDSSRecordInfo();
        this.getRecordInfo(recordInfo);
        return recordInfo;
    }

    public HecDSSRecordInfo getRecordInfo(String pathname) {
        HecDSSRecordInfo recordInfo = new HecDSSRecordInfo();
        recordInfo.pathname = pathname;
        this.getRecordInfo(recordInfo);
        return recordInfo;
    }

    public boolean getRecordInfo(HecDSSRecordInfo recordInfo) {
        String temp = recordInfo.pathname;
        recordInfo.init();
        recordInfo.pathname = temp;
        if (recordInfo.pathname == null || recordInfo.pathname.trim().length() < 5) {
            recordInfo.pathname = this.pathname();
        }
        recordInfo.exists = false;
        recordInfo.dssFilename = this.DSSFileName();
        if (recordInfo.dssFilename == null || recordInfo.dssFilename.length() == 0) {
            return false;
        }
        if (recordInfo.pathname == null || recordInfo.pathname.length() == 0) {
            return false;
        }
        recordInfo.pathname = HecTimeSeries.getStandardPathDate(recordInfo.pathname);
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
            this.open();
        }
        if (this.getDssFileVersion() == 7) {
            String nada = "";
            intContainer lockThreadToken = new intContainer();
            int[] dssTable = this._fileData.requestAccess(lockThreadToken);
            if (dssTable == null) {
                return false;
            }
            int status = Heclib.zrecInfo(dssTable, recordInfo, nada, nada, nada, nada);
            this._fileData.releaseAccess(lockThreadToken);
            if (status >= 0) {
                recordInfo.lastWrittenTime = new HecTime(10);
                recordInfo.lastWrittenTime.set((int)recordInfo.lastWriteTimeValue);
            }
        } else {
            int[] lexists = new int[1];
            int[] recordType = new int[1];
            int[] ldoubles = new int[1];
            int[] lquality = new int[1];
            int[] precision = new int[1];
            int[] version = new int[1];
            int[] numberData = new int[1];
            int[] spaceAllocated = new int[1];
            int[] timeSeriesCompression = new int[1];
            int[] lpasswordProtected = new int[1];
            long[] internals = new long[10];
            Arrays.fill(internals, 0L);
            stringContainer recordTypeDescription = new stringContainer();
            stringContainer lastWrittenTime = new stringContainer();
            stringContainer lastWrittenDate = new stringContainer();
            stringContainer recordTag = new stringContainer();
            stringContainer programName = new stringContainer();
            intContainer lockThreadToken = new intContainer();
            int[] dssTable = this._fileData.requestAccess(lockThreadToken);
            if (dssTable == null) {
                return false;
            }
            Heclib.zrinfo(dssTable, recordInfo.pathname, lexists, recordType, recordTypeDescription, ldoubles, lquality, precision, recordTag, lastWrittenDate, lastWrittenTime, programName, version, numberData, spaceAllocated, timeSeriesCompression, lpasswordProtected);
            Heclib.zrecadd(dssTable, recordInfo.pathname, internals);
            this._fileData.releaseAccess(lockThreadToken);
            if (lexists[0] != 0) {
                recordInfo.exists = true;
            }
            recordInfo.recordType = recordType[0];
            recordInfo.recordTypeDescription = recordTypeDescription.string;
            if (ldoubles[0] != 0) {
                recordInfo.doubles = true;
            }
            if (lquality[0] != 0) {
                recordInfo.quality = true;
            }
            recordInfo.precision = precision[0];
            recordInfo.recordTag = recordTag.string;
            recordInfo.setLastWrittenTime(lastWrittenDate.string, lastWrittenTime.string);
            recordInfo.programName = programName.string;
            recordInfo.version = version[0];
            recordInfo.numberData = numberData[0];
            recordInfo.spaceAllocated = spaceAllocated[0];
            recordInfo.timeSeriesCompression = timeSeriesCompression[0];
            if (lpasswordProtected[0] != 0) {
                recordInfo.passwordProtected = true;
            }
            recordInfo.setInternals(internals);
        }
        return true;
    }

    public int getTSRecordInfo(HecTime start, HecTime end, stringContainer units, stringContainer type) {
        return this.getTSRecordInfo(this._dssPathname.pathname(), start, end, units, type);
    }
}

