/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSErrorMessage;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.DssDataManager;
import hec.heclib.dss.HecDataManager;
import hec.heclib.dss.LocalDssDataManager;
import hec.heclib.dss.RemoteDssDataManagerProvider;
import hec.heclib.util.HecTime;
import hec.heclib.util.stringContainer;
import hec.hecmath.DSSFile;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.DataContainerTransformer;
import hec.io.DssFileContainer;
import hec.io.GridContainer;
import hec.io.PairedDataContainer;
import hec.io.PairedDataContainerVertDatum;
import hec.io.TextContainer;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerVertDatum;
import hec.io.TinContainer;
import hec.lang.ClientAppCheck;
import hec.lang.annotation.Scriptable;
import hec.util.PhotoViewerInfo;
import hec.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import mil.army.usace.hec.metadata.VerticalDatumContainer;

@Scriptable
public class HecDss
extends DSSFile {
    public HecDss(DssDataManager dataManager) {
        super(dataManager);
    }

    @Scriptable
    public static HecDss open(String dssFileName) throws Exception {
        return HecDss.open(dssFileName, false);
    }

    @Scriptable
    public static HecDss open(String dssFileName, int dssVersion) throws Exception {
        return HecDss.open(dssFileName, false, false, dssVersion);
    }

    @Scriptable
    public static HecDss open(String dssFileName, String timeWindow) throws Exception {
        HecDss hecDss = HecDss.open(dssFileName, false);
        hecDss.setTimeWindow(timeWindow);
        return hecDss;
    }

    @Scriptable
    public static HecDss open(String dssFileName, String startTime, String endTime) throws Exception {
        HecDss hecDss = HecDss.open(dssFileName, false);
        hecDss.setTimeWindow(startTime, endTime);
        return hecDss;
    }

    @Scriptable
    public static HecDss open(String dssFileName, boolean mustExist) throws Exception {
        boolean useRemote = ClientAppCheck.isNetworked();
        return HecDss.open(dssFileName, mustExist, useRemote, 0);
    }

    @Scriptable
    public static HecDss open(String dssFileName, boolean mustExist, boolean isRemote) throws Exception {
        return HecDss.open(dssFileName, mustExist, isRemote, 0);
    }

    @Scriptable
    public static HecDss open(String dssFileName, boolean mustExist, boolean isRemote, int dssVersion) throws Exception {
        HecDataManager.catchSevereErrors();
        DssDataManager dataManager = null;
        dataManager = isRemote ? RemoteDssDataManagerProvider.newRemoteDssDataManager() : new LocalDssDataManager();
        int status = dataManager.setDSSFileName(dssFileName, mustExist, dssVersion);
        if (status != 0) {
            if (mustExist) {
                throw new Exception("Unable to create HEC-DSS file " + dssFileName);
            }
            throw new Exception("Unable to access HEC-DSS file " + dssFileName);
        }
        HecDss hecDss = new HecDss(dataManager);
        hecDss.setFilename(dssFileName);
        boolean error = HecDataManager.checkForSevereError();
        if (error) {
            if (hecDss != null) {
                hecDss.checkForError();
            }
            throw new Exception("Unable to access HEC-DSS file " + dssFileName);
        }
        return hecDss;
    }

    @Scriptable
    public static boolean getDssFilename(String inputFilename, stringContainer outputFilename, boolean alwaysGetCanonical) throws IOException {
        File outfile = new File((String)((inputFilename = inputFilename.replaceAll("^\"(.+)\"$", "$1")).toUpperCase().endsWith(".DSS") ? inputFilename : inputFilename + ".dss"));
        outputFilename.string = outfile.exists() || alwaysGetCanonical ? outfile.getCanonicalPath() : outfile.toString();
        return outfile.exists();
    }

    @Scriptable
    public boolean isOpened() {
        if (this._dataManager == null) {
            return false;
        }
        if (this._dataManager.DSSFileName() == null) {
            return false;
        }
        if (this._dataManager.DSSFileName().length() == 0) {
            return false;
        }
        return this._dataManager.fileOpened();
    }

    @Scriptable
    public DataContainer get(String pathname) throws Exception {
        if (this._startTime != null && this._startTime.length() > 0 && this._endTime != null && this._endTime.length() > 0) {
            DSSIdentifier dssId = new DSSIdentifier();
            dssId.setDSSPath(pathname);
            HecTime start = new HecTime(this._startTime);
            HecTime end = new HecTime(this._endTime);
            dssId.setTimeWindow(start, end);
            return this.get(dssId);
        }
        return this.get(pathname, false);
    }

    @Scriptable
    public DataContainer get(String pathname, String startTime, String endTime) throws Exception {
        if (startTime != null && startTime.length() > 0 && endTime != null && endTime.length() > 0) {
            DSSIdentifier dssId = new DSSIdentifier();
            dssId.setDSSPath(pathname);
            HecTime start = new HecTime(startTime);
            HecTime end = new HecTime(endTime);
            dssId.setTimeWindow(start, end);
            return this.get(dssId);
        }
        return this.get(pathname, false);
    }

    @Scriptable
    public DataContainer get(String pathname, boolean readEntireSet) throws Exception {
        DataReference dataSet = null;
        if (readEntireSet) {
            int type = this._dataManager.recordType(pathname);
            if (type >= 100 && type < 200 && readEntireSet) {
                HecTime start = new HecTime();
                HecTime end = new HecTime();
                boolean found = this._dataManager.getTimeSeriesExtents(pathname, start, end);
                if (!found) {
                    return new TimeSeriesContainer();
                }
                String timeWindow = start.toString(4) + ",   " + end.toString(4);
                dataSet = new DataReference(pathname, this._dataManager.DSSFileName(), timeWindow);
            } else {
                dataSet = new DataReference(pathname, this._dataManager.DSSFileName());
            }
        } else {
            dataSet = new DataReference(pathname, this._dataManager.DSSFileName());
        }
        return this.get(dataSet);
    }

    @Scriptable
    public DataContainer get(DSSIdentifier dssId) throws Exception {
        DataReference dataSet = new DataReference(dssId);
        return this.get(dataSet);
    }

    @Scriptable
    protected DataContainer get(DataReference dataSet) throws Exception {
        String verticalDatumInfo = null;
        String currentVerticalDatum = null;
        ArrayList<String> infoParts = null;
        int type = this._dataManager.recordType(dataSet.getPath());
        if (type >= 100 && type < 200) {
            TimeSeriesContainer timeSeriesContainer = new TimeSeriesContainer();
            int status = this._dataManager.readData(dataSet, timeSeriesContainer, this._trimMissing);
            if (status <= -3) {
                this.checkForError();
                throw new Exception("Unable to access record " + dataSet.getPath());
            }
            if (timeSeriesContainer.supplementalInfo != null) {
                infoParts = new ArrayList<String>();
                StringTokenizer tok = new StringTokenizer(timeSeriesContainer.supplementalInfo, ";");
                while (tok.hasMoreTokens()) {
                    String item = tok.nextToken();
                    String[] parts = TextUtil.split(item, ":");
                    if (parts.length == 2 && parts[0].equals("verticalDatumInfo")) {
                        verticalDatumInfo = TextUtil.uncompress(parts[1], "base64");
                        continue;
                    }
                    if (parts.length == 2 && parts[0].equals("verticalDatum")) {
                        currentVerticalDatum = parts[1];
                        continue;
                    }
                    infoParts.add(item);
                }
            }
            if (verticalDatumInfo != null) {
                TimeSeriesContainerVertDatum timeSeriesContainerVertDatum = new TimeSeriesContainerVertDatum(timeSeriesContainer, new VerticalDatumContainer(verticalDatumInfo));
                if (currentVerticalDatum != null) {
                    timeSeriesContainerVertDatum.forceVerticalDatum(currentVerticalDatum);
                    timeSeriesContainerVertDatum.supplementalInfo = TextUtil.join(";", infoParts.toArray(new String[infoParts.size()]));
                    return timeSeriesContainerVertDatum;
                }
            }
            return timeSeriesContainer;
        }
        if (type >= 200 && type < 300) {
            PairedDataContainer pairedDataContainer = new PairedDataContainer();
            int status = this._dataManager.readData(dataSet, pairedDataContainer);
            if (status != 0) {
                this.checkForError();
                throw new Exception("Unable to access record " + dataSet.getPath());
            }
            if (pairedDataContainer.supplementalInfo != null) {
                infoParts = new ArrayList();
                StringTokenizer tok = new StringTokenizer(pairedDataContainer.supplementalInfo, ";");
                while (tok.hasMoreTokens()) {
                    String item = tok.nextToken();
                    String[] parts = TextUtil.split(item, ":");
                    if (parts.length == 2 && parts[0].equals("verticalDatumInfo")) {
                        verticalDatumInfo = TextUtil.uncompress(parts[1], "base64");
                        continue;
                    }
                    if (parts.length == 2 && parts[0].equals("verticalDatum")) {
                        currentVerticalDatum = parts[1];
                        continue;
                    }
                    infoParts.add(item);
                }
            }
            if (verticalDatumInfo != null) {
                PairedDataContainerVertDatum pairedDatumContainerVertDatum = new PairedDataContainerVertDatum(pairedDataContainer, new VerticalDatumContainer(verticalDatumInfo));
                if (currentVerticalDatum != null) {
                    pairedDatumContainerVertDatum.forceVerticalDatum(currentVerticalDatum);
                }
                pairedDatumContainerVertDatum.supplementalInfo = TextUtil.join(";", infoParts.toArray(new String[infoParts.size()]));
                return pairedDatumContainerVertDatum;
            }
            return pairedDataContainer;
        }
        if (type >= 300 && type < 400) {
            TextContainer textContainer = new TextContainer();
            int status = this._dataManager.readData(dataSet, textContainer);
            if (status < 0) {
                this.checkForError();
                throw new Exception("Unable to access record " + dataSet.getPath());
            }
            return textContainer;
        }
        if (type == 450) {
            TinContainer tinContainer = new TinContainer();
            int status = this._dataManager.readData(dataSet, tinContainer);
            if (status < 0) {
                this.checkForError();
                throw new Exception("Unable to access record " + dataSet.getPath());
            }
            return tinContainer;
        }
        if (type >= 400 && type < 500) {
            GridContainer gridContainer = new GridContainer();
            int status = this._dataManager.readData(dataSet, gridContainer);
            if (status < 0) {
                this.checkForError();
                throw new Exception("Unable to access record " + dataSet.getPath());
            }
            return gridContainer;
        }
        if (type == 610) {
            PhotoViewerInfo info = new PhotoViewerInfo();
            int status = this._dataManager.readImage(dataSet, info);
            if (status != 0) {
                this.checkForError();
                throw new Exception("Unable to access record " + dataSet.getPath());
            }
            return info;
        }
        if (type == 600) {
            DssFileContainer FileContainer = new DssFileContainer();
            int status = this._dataManager.readData(dataSet, FileContainer);
            if (status != 0) {
                this.checkForError();
                throw new Exception("Unable to access record " + dataSet.getPath());
            }
            return FileContainer;
        }
        throw new Exception("Unable to recognize record " + dataSet.getPath());
    }

    @Scriptable
    public void put(DataContainer dataContainer) throws Exception {
        int status = dataContainer instanceof TimeSeriesContainer ? this._dataManager.writeData((TimeSeriesContainer)dataContainer, this._regularStoreMethod, this._irregularStoreMethod) : this._dataManager.writeData(dataContainer);
        this.checkForError();
        if (status < 0) {
            throw new Exception("Unable to store record " + dataContainer.fullName + "\nStatus: " + status);
        }
    }

    @Scriptable
    public void put(DataContainerTransformer rsc) throws Exception {
        this.put(rsc.toDataContainer());
    }

    @Scriptable
    public boolean getTimeSeriesExtents(String pathname, HecTime start, HecTime end) {
        return this._dataManager.getTimeSeriesExtents(pathname, start, end);
    }

    @Override
    public boolean recordExists(String pathname) {
        return this._dataManager.recordExists(pathname);
    }

    @Scriptable
    public Vector getPathnameList() {
        String[] paths = this._dataManager.getPathnameList(false);
        Vector<String> pathnames = new Vector<String>(paths.length);
        pathnames.addAll(Arrays.asList(paths));
        return pathnames;
    }

    @Scriptable
    public List<CondensedReference> getCondensedCatalog() {
        return this._dataManager.getCondensedCatalog();
    }

    protected void checkForError() throws Exception {
        boolean error = HecDataManager.checkForSevereError();
        if (error) {
            DSSErrorMessage mess = this._dataManager.lastSevereErrorMessage();
            mess.printMessage();
            throw new Exception("Error accessing HEC-DSS\n" + mess.message());
        }
    }
}

