/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.event.HecDssEventType;
import hec.event.HecDssListener;
import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DssPathnameMatcher;
import hec.heclib.dss.DssPathnameMatcherException;
import hec.heclib.dss.HecDSSFileAccess;
import hec.heclib.dss.HecDSSFileDataManager;
import hec.heclib.dss.HecDSSRecordBasics;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.util.HecTime;
import hec.heclib.util.Heclib;
import hec.heclib.util.intArrayContainer;
import hec.heclib.util.intContainer;
import hec.heclib.util.stringContainer;
import hec.util.ElapsedTime;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.event.EventListenerList;

public class HecDssCatalog
extends HecDSSFileAccess
implements HecDssListener,
Cloneable {
    private static final Logger LOGGER = Logger.getLogger(HecDssCatalog.class.getName());
    protected String[] pathnameList;
    protected String pathnameWithWild;
    protected boolean listIsComplete;
    protected boolean listIsSorted;
    protected boolean listIsCollection = false;
    protected boolean _useCollectionGroups = false;
    protected static boolean _forceNewCatalog = false;
    protected EventListenerList _listenerList = new EventListenerList();
    protected Hashtable<HecDssListener, Thread> _observerThreads = null;
    private static final Pattern PART_SPEC_PATTERN = Pattern.compile("[ABCDEF]\\s*=");
    @Deprecated
    protected String _catalogName;
    protected int statusWanted;
    protected int statusRead;
    protected int maxNumberToRetrieve;
    protected int dataTypeStart;
    protected int dataTypeEnd;
    protected int[] startDates;
    protected int[] endDates;
    protected long[] pathnameHash;
    protected long[] lastWriteTimeRecord;
    protected int[] crcValues;
    protected long lastWriteTimeFile;
    protected long[] pathnameAddresses;

    public HecDssCatalog(String dssFileName) {
        this();
        this.setDSSFileName(dssFileName, true);
    }

    public HecDssCatalog() {
        this.clearList();
    }

    public String pathname() {
        return null;
    }

    public String[] getCatalog(boolean sorted, String pathnameFilter) {
        if (this.numberRecords() == 0) {
            this.pathnameList = new String[0];
            _forceNewCatalog = false;
            return this.pathnameList;
        }
        if (_forceNewCatalog) {
            this.listIsComplete = false;
        }
        if (this.pathnameList == null) {
            this.listIsComplete = false;
        }
        if (this.listIsComplete && this.numberRecords() != this.pathnameList.length) {
            this.listIsComplete = false;
        }
        if (this.listIsComplete && pathnameFilter == null) {
            if (sorted && !this.listIsSorted) {
                this.sortCatalog(pathnameFilter);
            }
            return this.pathnameList;
        }
        this.callCatalog(pathnameFilter);
        if (sorted) {
            this.sortCatalog(pathnameFilter);
        }
        _forceNewCatalog = false;
        return this.pathnameList;
    }

    public String[] getCatalog(boolean sorted) {
        return this.getCatalog(sorted, null);
    }

    public String[] getCatalog(boolean sorted, String pathnameFilter, int matcherType, boolean ignoreCase) {
        if (this.numberRecords() == 0) {
            this.pathnameList = new String[0];
            _forceNewCatalog = false;
            return this.pathnameList;
        }
        if (_forceNewCatalog) {
            this.listIsComplete = false;
        }
        if (this.pathnameList == null) {
            this.listIsComplete = false;
        }
        if (this.listIsComplete && this.numberRecords() != this.pathnameList.length) {
            this.listIsComplete = false;
        }
        if (this.listIsComplete && pathnameFilter == null) {
            if (sorted && !this.listIsSorted) {
                this.sortCatalog(pathnameFilter);
            }
            return this.pathnameList;
        }
        this.callCatalog(pathnameFilter, matcherType, ignoreCase);
        if (sorted) {
            this.sortCatalog(pathnameFilter);
        }
        _forceNewCatalog = false;
        return this.pathnameList;
    }

    public CondensedReference[] getCondensedCatalog(String pathnameFilter) {
        String[] paths = this.getCatalog(true, pathnameFilter);
        Vector<CondensedReference> condensedList = new Vector<CondensedReference>();
        this.buildCondensedList(condensedList);
        CondensedReference[] condensedPaths = condensedList.toArray(new CondensedReference[0]);
        return condensedPaths;
    }

    public CondensedReference[] getCondensedCatalog(String pathnameFilter, int matcherType, boolean ignoreCase) {
        String[] paths = this.getCatalog(true, pathnameFilter, matcherType, ignoreCase);
        Vector<CondensedReference> condensedList = new Vector<CondensedReference>();
        this.buildCondensedList(condensedList);
        CondensedReference[] condensedPaths = condensedList.toArray(new CondensedReference[0]);
        return condensedPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int catalogFile(String catalogName, boolean sorted, String pathWithWildChars) {
        int status = 0;
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -4;
        }
        try {
            status = Heclib.zcatalogFile(dssTable, catalogName, sorted, pathWithWildChars);
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        return status;
    }

    public void setPathWithWildChars(String pathWithWildChars, boolean getCollection) {
        this.pathnameWithWild = pathWithWildChars;
        this.listIsCollection = getCollection;
    }

    public void setStatusWanted(int status) {
        this.statusWanted = status;
    }

    public int getStatusRead() {
        return this.statusRead;
    }

    public void setMaxNumberToRetrieve(int maxNumber) {
        this.maxNumberToRetrieve = maxNumber;
    }

    public int[] getStartDates() {
        return this.startDates;
    }

    public int[] getEndDates() {
        return this.endDates;
    }

    public String[] getPathnames() {
        return this.pathnameList;
    }

    public void setTypeWanted(int typeStart, int typeEnd) {
        this.dataTypeStart = typeStart;
        this.dataTypeEnd = typeEnd;
    }

    public void setForceNewCatalog(boolean forceNewCatalog) {
        _forceNewCatalog = forceNewCatalog;
    }

    public void setUseCollectionGroups(boolean useCollectionGroups) {
        this._useCollectionGroups = useCollectionGroups;
    }

    public boolean getUseCollectionGroups() {
        return this._useCollectionGroups;
    }

    protected String wildCharsToRegex(String pathnameWithWild) {
        if (this.isPathnamePartsString(pathnameWithWild)) {
            return this.pathNamePartsToRegex(pathnameWithWild);
        }
        return String.format("^%s$", pathnameWithWild.replaceAll("[.]", "[.]").replaceAll("\\*", ".*").replaceAll("\\?", ".?"));
    }

    protected boolean isPathnamePartsString(String maybePathnameParts) {
        return PART_SPEC_PATTERN.matcher(maybePathnameParts).find();
    }

    protected String pathNamePartsToRegex(String pathnameParts) {
        HashMap<String, int[]> matchPositions = new HashMap<String, int[]>();
        Matcher m = PART_SPEC_PATTERN.matcher(pathnameParts);
        while (m.find()) {
            matchPositions.put(m.group().substring(0, 1), new int[]{m.start(), m.end()});
        }
        if (matchPositions.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder("/");
        String[] keys = new String[]{"A", "B", "C", "D", "E", "F"};
        for (int i = 0; i < keys.length; ++i) {
            if (matchPositions.containsKey(keys[i])) {
                int endPos = pathnameParts.length();
                for (int j = i + 1; j < keys.length; ++j) {
                    if (!matchPositions.containsKey(keys[j])) continue;
                    endPos = Math.min(endPos, ((int[])matchPositions.get(keys[j]))[0]);
                }
                String partFilter = pathnameParts.substring(((int[])matchPositions.get(keys[i]))[1], endPos).trim();
                if (partFilter.charAt(0) == '\"' && partFilter.charAt(partFilter.length() - 1) == '\"') {
                    sb.append(partFilter.substring(1, partFilter.length() - 1));
                    continue;
                }
                sb.append(partFilter).append("/");
                continue;
            }
            sb.append("*/");
        }
        return this.wildCharsToRegex(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int callCatalogOriginal(String pathWithWildChars) {
        this.pathnameWithWild = pathWithWildChars;
        int status = 0;
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -4;
        }
        try {
            status = Heclib.zcatalog(dssTable, this);
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        this.listIsSorted = false;
        this.listIsComplete = this.pathnameWithWild == null;
        return status;
    }

    protected int callCatalog(String pathnameFilter) {
        return this.callCatalog(pathnameFilter, 1, true);
    }

    protected int callCatalog(String pathnameFilter, int matcherType, boolean ignoreCase) {
        int status = 0;
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -4;
        }
        try {
            this.pathnameWithWild = null;
            status = Heclib.zcatalog(dssTable, this);
            if (pathnameFilter != null) {
                DssPathnameMatcher m = new DssPathnameMatcher(pathnameFilter, matcherType, ignoreCase);
                this.pathnameList = m.getMatching(this.pathnameList);
                this.pathnameWithWild = m.getMatcherString();
            }
            this.listIsSorted = false;
            this.listIsComplete = this.pathnameWithWild == null;
            int m = status;
            return m;
        }
        catch (DssPathnameMatcherException e) {
            throw new RuntimeException(e);
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int callCatalog(Pattern pattern) {
        int status = 0;
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -4;
        }
        try {
            this.pathnameWithWild = null;
            status = Heclib.zcatalog(dssTable, this);
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        if (pattern != null) {
            String[] filteredList = Arrays.asList(this.pathnameList).stream().filter(pattern.asPredicate()).collect(Collectors.toList()).toArray(new String[0]);
            this.pathnameList = filteredList;
            this.pathnameWithWild = String.format("%s (flags=%d)", pattern.pattern(), pattern.flags());
        }
        this.listIsSorted = false;
        this.listIsComplete = pattern == null;
        return status;
    }

    protected void clearList() {
        this.pathnameList = null;
        this.pathnameWithWild = null;
        this.listIsComplete = false;
        this.listIsSorted = false;
        this.maxNumberToRetrieve = 0;
        this.statusWanted = 0;
        this.statusRead = 0;
        this.dataTypeStart = 0;
        this.dataTypeEnd = 0;
        this.startDates = null;
        this.endDates = null;
        this.pathnameAddresses = null;
        this.pathnameHash = null;
        this.lastWriteTimeRecord = null;
        this.crcValues = null;
        this.lastWriteTimeFile = 0L;
    }

    public int whatChangedSetStart() {
        return this.whatChangedSetStart(this, null, false);
    }

    public int whatChangedSetStart(String pathnameWithWildChars, boolean useCRCforData) {
        return this.whatChangedSetStart(this, pathnameWithWildChars, useCRCforData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int whatChangedSetStart(HecDssCatalog catalog, String pathnameWithWildChars, boolean useCRCforData) {
        int status = 0;
        this.clearList();
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -4;
        }
        try {
            status = Heclib.zwhatChangedSetStart(dssTable, catalog, pathnameWithWildChars, useCRCforData);
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        return status;
    }

    public String[] whatChanged() {
        boolean boolUseCRC = false;
        if (this.crcValues != null) {
            boolUseCRC = true;
        }
        HecDssCatalog dssCatalogBefore = (HecDssCatalog)this.clone();
        return this.whatChangedCompare(dssCatalogBefore, dssCatalogBefore.pathnameWithWild, boolUseCRC);
    }

    public String[] whatChanged(String pathWithWild) {
        boolean boolUseCRC = false;
        if (this.crcValues != null) {
            boolUseCRC = true;
        }
        HecDssCatalog dssCatalogBefore = (HecDssCatalog)this.clone();
        return this.whatChangedCompare(dssCatalogBefore, pathWithWild, boolUseCRC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] whatChangedCompare(HecDssCatalog dssCatalogBefore, String pathWithWild, boolean boolUseCRC) {
        int status = 0;
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return null;
        }
        try {
            status = Heclib.zwhatChangedCompare(dssTable, dssCatalogBefore, this, pathWithWild, boolUseCRC);
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        if (status >= 0) {
            return this.pathnameList;
        }
        return null;
    }

    public int sortCatalog(String pathWithWildChar) {
        if (this.pathnameList == null) {
            this.callCatalog(pathWithWildChar);
        }
        if (this.pathnameList == null) {
            return -1;
        }
        int sortListStatus = _forceNewCatalog ? 3 : (this.getDssFileVersion() == 6 ? 0 : this.zinqir("cats"));
        int numberRecords = this.zinqir("nrec");
        this.listIsComplete = numberRecords == this.pathnameList.length;
        long[] sortedPathnameAddresses = null;
        if (sortListStatus == 1 || sortListStatus == 2) {
            String[] sortedPaths = new String[this.pathnameList.length];
            sortedPathnameAddresses = this.getCatalogSortAddresses();
            if (sortedPathnameAddresses != null && sortedPathnameAddresses.length > 2) {
                for (int i = 0; i < sortedPathnameAddresses.length; ++i) {
                    if (sortedPathnameAddresses[i] >= 1L) continue;
                    sortListStatus = 0;
                    break;
                }
            } else {
                sortListStatus = 0;
            }
            if (sortListStatus == 1 || sortListStatus == 2) {
                int i;
                int[] sortedStartDates = new int[this.pathnameList.length];
                int[] sortedEndDates = new int[this.pathnameList.length];
                int icount = 0;
                HashMap<Long, Integer> hm = new HashMap<Long, Integer>(this.pathnameAddresses.length);
                for (int i2 = 0; i2 < this.pathnameAddresses.length; ++i2) {
                    hm.put(this.pathnameAddresses[i2], i2);
                }
                for (i = 0; i < sortedPathnameAddresses.length; ++i) {
                    int ipos;
                    if (!hm.containsKey(sortedPathnameAddresses[i]) || (ipos = ((Integer)hm.get(sortedPathnameAddresses[i])).intValue()) <= -1 || ipos >= this.pathnameList.length) continue;
                    sortedPaths[icount] = this.pathnameList[ipos];
                    if (this.startDates != null && this.endDates != null) {
                        sortedStartDates[icount] = this.startDates[ipos];
                        sortedEndDates[icount] = this.endDates[ipos];
                    }
                    ++icount;
                }
                if (sortListStatus == 1) {
                    this.pathnameList = sortedPaths;
                    this.pathnameAddresses = sortedPathnameAddresses;
                    if (this.startDates != null && this.endDates != null) {
                        this.startDates = sortedStartDates;
                        this.endDates = sortedEndDates;
                    }
                    this.listIsSorted = true;
                    return this.pathnameList.length;
                }
                if (icount != this.pathnameList.length) {
                    for (i = 0; i < this.pathnameAddresses.length; ++i) {
                        if (this.pathnameAddresses[i] == 0L) continue;
                        sortedPaths[icount] = this.pathnameList[i];
                    }
                }
                this.pathnameList = sortedPaths;
                if (this.startDates != null && this.endDates != null) {
                    this.startDates = sortedStartDates;
                    this.endDates = sortedEndDates;
                }
            }
        }
        this.sort();
        return this.pathnameList.length;
    }

    public String[] sort() {
        int[] sortedEndDates;
        int[] sortedStartDates;
        String index;
        int maxPartLen;
        if (this.pathnameList == null) {
            return new String[0];
        }
        long[] sortedPathnameAddresses = null;
        sortedPathnameAddresses = !this.listIsComplete ? null : new long[this.pathnameList.length];
        int[] maxPartLengths = this.getMaximumPartLengths();
        if (maxPartLengths[3] < 12) {
            maxPartLengths[3] = 12;
        }
        if (maxPartLengths[4] < 9) {
            maxPartLengths[4] = 9;
        }
        if (maxPartLengths[4] > (maxPartLen = maxPartLengths[3])) {
            maxPartLen = maxPartLengths[4];
        }
        if (maxPartLengths[5] > maxPartLen) {
            maxPartLen = maxPartLengths[5];
        }
        if (maxPartLen > maxPartLengths[3]) {
            maxPartLengths[3] = maxPartLen;
        }
        if (maxPartLen > maxPartLengths[4]) {
            maxPartLengths[4] = maxPartLen;
        }
        if (maxPartLen > maxPartLengths[5]) {
            maxPartLengths[5] = maxPartLen;
        }
        int[] maxPartPositions = new int[7];
        int[] partPositions = new int[7];
        int maxLen = 0;
        for (int i = 0; i < 6; ++i) {
            maxPartPositions[i] = maxLen;
            maxLen += maxPartLengths[i];
        }
        maxPartPositions[6] = maxLen;
        maxLen += 8;
        maxLen += 8;
        HecTime date = new HecTime();
        DecimalFormat df = new DecimalFormat("00000000000");
        long add = 5000000L;
        Object[] sortList = new String[this.pathnameList.length];
        for (int i = 0; i < this.pathnameList.length; ++i) {
            boolean timeSeries = false;
            boolean gridded = false;
            StringBuilder sb = new StringBuilder(maxLen + 1);
            sb.setLength(maxLen);
            for (int j = 0; j < maxLen; ++j) {
                sb.setCharAt(j, ' ');
            }
            String pathname = this.pathnameList[i];
            int stat = DSSPathname.parsePathname(pathname, partPositions);
            for (int j = 0; j < 6; ++j) {
                long days;
                int partLen = partPositions[j + 1] - partPositions[j] - 1;
                if (partLen <= 0) continue;
                int end = maxPartPositions[j] + partLen;
                Object part = pathname.substring(partPositions[j], partPositions[j + 1] - 1);
                if (j == 3) {
                    stat = date.setDate((String)part);
                    if (stat == 0) {
                        days = (long)date.julian() + add;
                        part = df.format(days);
                        timeSeries = true;
                    } else {
                        stat = date.set((String)part);
                        if (stat == 0) {
                            days = (long)date.julian() + add;
                            days *= 10000L;
                            part = df.format(days += (long)date.minutesSinceMidnight());
                            gridded = true;
                        }
                    }
                }
                if (j == 4) {
                    if (timeSeries) {
                        int interval = HecTimeSeriesBase.getIntervalFromEPart((String)part);
                        if (interval != -3) {
                            part = df.format(interval += 100);
                            end = maxPartPositions[j] + ((String)part).length();
                        }
                    } else if (gridded && (stat = date.set((String)part)) == 0) {
                        days = (long)date.julian() + add;
                        days *= 10000L;
                        part = df.format(days += (long)date.minutesSinceMidnight());
                    }
                }
                if (j == 5 && timeSeries && partLen > 8 && ((String)part).indexOf("|") == 8 && ((String)part).startsWith("C:")) {
                    part = ((String)part).substring(9) + ((String)part).substring(0, 9);
                }
                if (j < 3 || !timeSeries && !gridded) {
                    sb.replace(maxPartPositions[j], end, (String)part);
                    continue;
                }
                if (timeSeries) {
                    if (j == 3) {
                        end = maxPartPositions[5] + ((String)part).length();
                        sb.replace(maxPartPositions[5], end, (String)part);
                        continue;
                    }
                    if (j == 4) {
                        end = maxPartPositions[4] + ((String)part).length();
                        sb.replace(maxPartPositions[4], end, (String)part);
                        continue;
                    }
                    end = maxPartPositions[3] + ((String)part).length();
                    sb.replace(maxPartPositions[3], end, (String)part);
                    continue;
                }
                if (j == 3) {
                    end = maxPartPositions[4] + ((String)part).length();
                    sb.replace(maxPartPositions[4], end, (String)part);
                    continue;
                }
                if (j == 4) {
                    end = maxPartPositions[5] + ((String)part).length();
                    sb.replace(maxPartPositions[5], end, (String)part);
                    continue;
                }
                end = maxPartPositions[3] + ((String)part).length();
                sb.replace(maxPartPositions[3], end, (String)part);
            }
            index = Integer.toString(i);
            int end = maxPartPositions[6] + index.length();
            sb.replace(maxPartPositions[6], end, index);
            sortList[i] = sb.toString();
        }
        Arrays.sort(sortList);
        int[] sortOrder = new int[sortList.length];
        if (this.startDates != null && this.endDates != null) {
            sortedStartDates = new int[this.startDates.length];
            sortedEndDates = new int[this.endDates.length];
        } else {
            sortedStartDates = null;
            sortedEndDates = null;
        }
        String[] sortedPaths = new String[this.pathnameList.length];
        for (int i = 0; i < sortList.length; ++i) {
            int idx;
            Object line = sortList[i];
            index = ((String)line).substring(maxPartPositions[6]).trim();
            try {
                idx = Integer.parseInt(index);
            }
            catch (Exception e) {
                idx = -1;
            }
            if (idx <= -1 || idx >= this.pathnameList.length) continue;
            sortedPaths[i] = this.pathnameList[idx];
            if (sortedPathnameAddresses != null && this.pathnameAddresses != null && idx < this.pathnameAddresses.length) {
                sortedPathnameAddresses[i] = this.pathnameAddresses[idx];
            }
            if (this.startDates == null || this.endDates == null) continue;
            sortedStartDates[i] = this.startDates[idx];
            sortedEndDates[i] = this.endDates[idx];
        }
        this.pathnameList = sortedPaths;
        this.pathnameAddresses = sortedPathnameAddresses;
        this.startDates = sortedStartDates;
        this.endDates = sortedEndDates;
        this.listIsSorted = true;
        if (this.listIsComplete && this.pathnameAddresses != null && this.getDssFileVersion() != 6) {
            this.setCatalogSortAddresses(this.pathnameAddresses);
        }
        return this.pathnameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long[] getCatalogSortAddresses() {
        int numberRecords = this.numberRecords();
        long[] sortAddresses = new long[numberRecords];
        int status = 0;
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return null;
        }
        try {
            status = Heclib.zgetCatalogSortAddresses(dssTable, sortAddresses, numberRecords);
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        if (status != 0) {
            return null;
        }
        return sortAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCatalogSortAddresses(long[] sortAddresses) {
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return;
        }
        try {
            Heclib.zsetCatalogSortAddresses(dssTable, sortAddresses, sortAddresses.length);
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
    }

    protected void buildCondensedList(Vector<CondensedReference> condensedList) {
        boolean get6Dates = true;
        condensedList.removeAllElements();
        if (this.pathnameList == null || this.pathnameList.length == 0) {
            return;
        }
        String lastPathname = new String(" ");
        CondensedReference condensedPathname = null;
        Vector<String> pathnames = null;
        for (int i = 0; i < this.pathnameList.length; ++i) {
            String currentPathname = this.pathnameList[i];
            if (!HecDssCatalog.compareCondensedPaths(lastPathname, currentPathname)) {
                if (condensedPathname != null) {
                    if (this.endDates != null) {
                        condensedPathname.setJulianEnd(this.endDates[i - 1]);
                    }
                    String[] paths = pathnames.toArray(new String[0]);
                    condensedPathname.complete(this, paths, paths.length, true);
                }
                condensedPathname = new CondensedReference();
                pathnames = new Vector<String>();
                if (this.startDates != null && this.startDates.length > i) {
                    condensedPathname.setJulianStart(this.startDates[i]);
                }
                condensedList.addElement(condensedPathname);
            }
            if (condensedPathname != null) {
                pathnames.add(currentPathname);
            }
            lastPathname = currentPathname;
        }
        if (condensedPathname != null) {
            if (this.endDates != null && this.endDates.length == this.pathnameList.length) {
                condensedPathname.setJulianEnd(this.endDates[this.pathnameList.length - 1]);
            }
            String[] paths = pathnames.toArray(new String[0]);
            condensedPathname.complete(null, paths, paths.length, true);
        }
        if (this._useCollectionGroups) {
            boolean haveCollections = false;
            int number = condensedList.size();
            for (int i = 0; i < number; ++i) {
                String path = condensedList.get(i).toString();
                if (!DSSPathname.isaCollectionPath(path)) continue;
                haveCollections = true;
                break;
            }
            if (haveCollections) {
                Vector<CondensedReference> condensed = new Vector<CondensedReference>(number);
                Vector<CondensedReference> collection = new Vector<CondensedReference>();
                lastPathname = "";
                for (int i = 0; i < number; ++i) {
                    CondensedReference cr;
                    String path = condensedList.get(i).toString();
                    if (DSSPathname.isaCollectionPath(path)) {
                        if (DSSPathname.isSameCollection(path, lastPathname)) {
                            collection.add(condensedList.get(i));
                            continue;
                        }
                        if (collection.size() == 1) {
                            condensed.add(collection.get(0));
                            collection.removeAllElements();
                        } else if (collection.size() > 1) {
                            cr = new CondensedReference();
                            cr.setCollection(collection);
                            condensed.add(cr);
                            collection.removeAllElements();
                        }
                        collection.add(condensedList.get(i));
                        lastPathname = path;
                        continue;
                    }
                    if (collection.size() == 1) {
                        condensed.add(collection.get(0));
                        collection.removeAllElements();
                        lastPathname = "";
                    } else if (collection.size() > 1) {
                        cr = new CondensedReference();
                        cr.setCollection(collection);
                        condensed.add(cr);
                        collection.removeAllElements();
                        lastPathname = "";
                    }
                    condensed.add(condensedList.get(i));
                }
                if (collection.size() == 1) {
                    condensed.add((CondensedReference)collection.get(0));
                } else if (collection.size() > 1) {
                    CondensedReference cr = new CondensedReference();
                    cr.setCollection(collection);
                    condensed.add(cr);
                }
                condensedList = condensed;
            }
        }
        _forceNewCatalog = false;
    }

    public static boolean compareCondensedPaths(String pathname1, String pathname2) {
        int[] partLocs1 = new int[2];
        int[] partLocs2 = new int[2];
        if (pathname1 == null) {
            return false;
        }
        if (pathname1.length() < 10) {
            return false;
        }
        HecDssCatalog.getEPartLoc(pathname1, partLocs1);
        if (partLocs1[0] < 5) {
            return false;
        }
        if (partLocs1[1] < 5) {
            return false;
        }
        HecDssCatalog.getEPartLoc(pathname2, partLocs2);
        if (partLocs2[0] < 5) {
            return false;
        }
        if (partLocs2[1] < 5) {
            return false;
        }
        if (pathname1.substring(0, partLocs1[0]).compareTo(pathname2.substring(0, partLocs2[0])) != 0) {
            return false;
        }
        int len1 = pathname1.length();
        int len2 = pathname2.length();
        if (pathname1.substring(partLocs1[1], len1).compareTo(pathname2.substring(partLocs2[1], len2)) != 0) {
            return false;
        }
        int n = partLocs1[1] - partLocs1[0];
        if (n < 5) {
            return false;
        }
        HecTime htime = new HecTime();
        int stat = htime.setDate(pathname1.substring(partLocs1[0] + 1, partLocs1[1]));
        if (stat != 0) {
            return false;
        }
        int eslash = pathname1.indexOf(47, partLocs1[1] + 1);
        return eslash - partLocs1[1] >= 4;
    }

    protected static void getEPartLoc(String pathname, int[] partLocs) {
        int slash = 0;
        for (int i = 0; i < 3; ++i) {
            slash = pathname.indexOf(47, slash + 1);
        }
        partLocs[0] = slash;
        partLocs[1] = pathname.indexOf(47, slash + 1);
    }

    @Override
    @Deprecated
    public String[] getPathnameList(boolean forceUpdate) {
        return this.getCatalog(true, null);
    }

    @Deprecated
    public String[] getSortedPathnameList(intArrayContainer startDatesContainer, intArrayContainer endDatesContainer, boolean forceUpdate) {
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
            this.open();
        }
        if (!this.fileAccessible()) {
            System.out.println("HecDataManager:  DSS file not opened!");
            return null;
        }
        if (this.getDssFileVersion() == 6) {
            return this.getPathnameList(forceUpdate);
        }
        if (this.numberRecords() == 0) {
            return null;
        }
        return this.getCatalog(true, null);
    }

    @Deprecated
    public String[] getPathnameListAndDates(intArrayContainer startDatesContainer, intArrayContainer endDatesContainer) {
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
            this.open();
        }
        if (!this.fileAccessible()) {
            System.out.println("HecDataManager:  DSS file not opened!");
            return null;
        }
        if (this.numberRecords() == 0) {
            this.pathnameList = new String[0];
            _forceNewCatalog = false;
            return this.pathnameList;
        }
        int numberPaths = this.callCatalog((String)null);
        if (numberPaths < 0) {
            return null;
        }
        if (startDatesContainer != null && this.startDates != null && this.startDates.length > 0) {
            startDatesContainer.array = Arrays.copyOf(this.startDates, this.startDates.length);
            startDatesContainer.length = startDatesContainer.array.length;
        }
        if (endDatesContainer != null && this.endDates != null && this.endDates.length > 0) {
            endDatesContainer.array = Arrays.copyOf(this.endDates, this.endDates.length);
            endDatesContainer.length = endDatesContainer.array.length;
        }
        return Arrays.copyOf(this.pathnameList, this.pathnameList.length);
    }

    @Deprecated
    public String[] getPathnameListType(int statusWantedForList, int typeWantedStart, int typeWantedEnd) {
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
            this.open();
        }
        if (this.numberRecords() == 0) {
            this.pathnameList = new String[0];
            _forceNewCatalog = false;
            return this.pathnameList;
        }
        this.dataTypeStart = typeWantedStart;
        this.dataTypeEnd = typeWantedEnd;
        this.statusWanted = statusWantedForList;
        int numberPaths = this.callCatalog((String)null);
        if (numberPaths < 0) {
            return null;
        }
        this.dataTypeStart = 0;
        this.dataTypeEnd = 0;
        this.statusWanted = 0;
        return Arrays.copyOf(this.pathnameList, this.pathnameList.length);
    }

    public void setPathnameList(List<String> pathnames) {
        this.pathnameList = new String[pathnames.size()];
        pathnames.toArray(this.pathnameList);
    }

    public void setPathnameList(String[] pathnames) {
        this.pathnameList = Arrays.copyOf(this.pathnameList, this.pathnameList.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public synchronized int numberCatalogedRecords() {
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
        }
        int[] numberFound = new int[1];
        int[] catalogUnit = new int[1];
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return 0;
        }
        try {
            Heclib.makedsscatalog(this._fileData.dssFileName(), dssTable, "?", numberFound, catalogUnit);
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        return numberFound[0];
    }

    @Deprecated
    public int searchDSSPaths(String aPart, String bPart, String cPart, String dPart, String ePart, String fPart, Vector pathnameList) {
        String instructions = this.processSearchParts(aPart, bPart, cPart, dPart, ePart, fPart);
        return this.getPathnameList(instructions, pathnameList);
    }

    @Deprecated
    public int searchDSSCatalog(String aPart, String bPart, String cPart, String dPart, String ePart, String fPart, Vector pathnameList) {
        String instructions = this.processSearchParts(aPart, bPart, cPart, dPart, ePart, fPart);
        return this.getPathnameList(instructions, pathnameList);
    }

    @Deprecated
    public int searchDSSPaths(String scanString, List<String> pathnameList) {
        StringBuffer catInstr = new StringBuffer(60);
        if (scanString.length() > 0) {
            if (!(scanString.regionMatches(1, "=", 0, 1) || scanString.equalsIgnoreCase("DELETE") || scanString.equalsIgnoreCase("RENAME"))) {
                catInstr.append(" S=").append(scanString);
            } else {
                catInstr.append(scanString);
            }
        }
        catInstr.append(" ");
        return this.getPathnameList(catInstr.toString(), pathnameList);
    }

    @Deprecated
    public int searchDSSCatalog(String scanString, List<String> pathnameList) {
        StringBuffer catInstr = new StringBuffer(60);
        if (scanString.length() > 0) {
            if (!scanString.regionMatches(1, "=", 0, 1)) {
                catInstr.append(" S=").append(scanString);
            } else {
                catInstr.append(scanString);
            }
        }
        catInstr.append(" ");
        return this.getPathnameList(catInstr.toString(), pathnameList);
    }

    @Deprecated
    protected String processSearchParts(String aPart, String bPart, String cPart, String dPart, String ePart, String fPart) {
        int length;
        StringBuffer catInstr = new StringBuffer(80);
        StringBuffer part = new StringBuffer(80);
        if (aPart.length() > 0 && !aPart.equals("*") && (length = this.cleanCatalogPart(aPart, part)) > 0) {
            catInstr.append(" A=").append(part);
        }
        if (bPart.length() > 0 && !bPart.equals("*") && (length = this.cleanCatalogPart(bPart, part)) > 0) {
            catInstr.append(" B=").append(part);
        }
        if (cPart.length() > 0 && !cPart.equals("*") && (length = this.cleanCatalogPart(cPart, part)) > 0) {
            catInstr.append(" C=").append(part);
        }
        if (dPart.length() > 0 && !dPart.equals("*") && (length = this.cleanCatalogPart(dPart, part)) > 0) {
            catInstr.append(" D=").append(part);
        }
        if (ePart.length() > 0 && !ePart.equals("*") && (length = this.cleanCatalogPart(ePart, part)) > 0) {
            catInstr.append(" E=").append(part);
        }
        if (fPart.length() > 0 && !fPart.equals("*") && (length = this.cleanCatalogPart(fPart, part)) > 0) {
            catInstr.append(" F=").append(part);
        }
        catInstr.append(" ");
        return catInstr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int[] getMaximumPartLengths() {
        int[] maxParts = new int[6];
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return null;
        }
        try {
            Heclib.zmaxpart(dssTable, maxParts);
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        return maxParts;
    }

    protected synchronized int[] getMaximumPartLengths(String[] paths) {
        int[] maxParts = this.getMaximumPartLengths();
        for (int i = 0; i < maxParts.length; ++i) {
            if (maxParts[i] <= 0) continue;
            return maxParts;
        }
        int[] partPositions = new int[7];
        for (int i = 0; i < paths.length; ++i) {
            int stat = DSSPathname.parsePathname(paths[i], partPositions);
            for (int j = 0; j < 6; ++j) {
                int partLen = partPositions[j + 1] - partPositions[j] - 1;
                if (partLen <= maxParts[j]) continue;
                maxParts[j] = partLen;
            }
        }
        return maxParts;
    }

    public String[] buildSortedCatalog() {
        String index;
        if (this.zinqir("VERS") == 7) {
            return this.getCatalog(true, null);
        }
        ElapsedTime.startElapsedTime();
        int numberRecords = this.numberRecords();
        if (numberRecords <= 0) {
            return new String[0];
        }
        Vector<String> paths = new Vector<String>(numberRecords);
        this.searchDSSPaths("", paths);
        String[] list = paths.toArray(new String[0]);
        System.out.println(ElapsedTime.elapsedTimeDescription(false));
        int[] maxPartLengths = this.getMaximumPartLengths(list);
        if (maxPartLengths[4] < 9) {
            maxPartLengths[4] = 9;
        }
        int[] maxPartPositions = new int[7];
        int[] partPositions = new int[7];
        int maxLen = 0;
        for (int i = 0; i < 6; ++i) {
            maxPartPositions[i] = maxLen;
            maxLen += maxPartLengths[i];
        }
        maxPartPositions[6] = maxLen;
        maxLen += 8;
        if (this.zinqir("COLL") == 0) {
            maxPartPositions[5] = maxPartPositions[3];
            maxPartPositions[4] = maxPartPositions[5] + maxPartLengths[5];
            maxPartPositions[3] = maxPartPositions[4] + maxPartLengths[4];
        } else {
            maxPartPositions[4] = maxPartPositions[3];
            maxPartPositions[5] = maxPartPositions[4] + maxPartLengths[4];
            maxPartPositions[3] = maxPartPositions[5] + maxPartLengths[5];
        }
        Object[] sortList = new String[list.length];
        StringBuilder sb = new StringBuilder(maxLen);
        sb.setLength(maxLen);
        HecTime date = new HecTime();
        DecimalFormat df = new DecimalFormat("000000000");
        long add = 500000000L;
        boolean timeSeries = false;
        for (int i = 0; i < list.length; ++i) {
            timeSeries = false;
            for (int j = 0; j < maxLen; ++j) {
                sb.setCharAt(j, ' ');
            }
            String pathname = list[i];
            int stat = DSSPathname.parsePathname(pathname, partPositions);
            for (int j = 0; j < 6; ++j) {
                int interval;
                int partLen = partPositions[j + 1] - partPositions[j] - 1;
                if (partLen <= 0) continue;
                int end = maxPartPositions[j] + partLen;
                Object part = pathname.substring(partPositions[j], partPositions[j + 1] - 1);
                if (j == 3 && ((String)part).length() == 9 && (stat = date.setDate((String)part)) == 0) {
                    long days = (long)date.julian() + add;
                    part = df.format(days);
                    timeSeries = true;
                }
                if (j == 4 && timeSeries && (interval = HecTimeSeriesBase.zgintlFromEPart((String)part)) != 0) {
                    part = df.format(interval += 100);
                    end = maxPartPositions[j] + ((String)part).length();
                }
                if (j == 5 && timeSeries && partLen > 8 && ((String)part).indexOf("|") == 8 && ((String)part).startsWith("C:")) {
                    part = ((String)part).substring(9) + ((String)part).substring(0, 9);
                }
                sb.replace(maxPartPositions[j], end, (String)part);
            }
            index = Integer.toString(i);
            int end = maxPartPositions[6] + index.length();
            sb.replace(maxPartPositions[6], end, index);
            sortList[i] = sb.toString();
        }
        Arrays.sort(sortList);
        String[] sortedPaths = new String[sortList.length];
        for (int i = 0; i < sortList.length; ++i) {
            int idx;
            Object line = sortList[i];
            index = ((String)line).substring(maxPartPositions[6]).trim();
            try {
                idx = Integer.parseInt(index);
            }
            catch (Exception e) {
                idx = -1;
            }
            if (idx <= -1) continue;
            sortedPaths[i] = list[idx];
        }
        return sortedPaths;
    }

    protected synchronized int getPathnameList(String instructions, List<String> pathnameList) {
        return this.getPathnameList7(instructions, pathnameList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int getPathnameList7(String instructions, List<String> pathnameList) {
        int number = -1;
        pathnameList.clear();
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
            this.open();
        }
        HecDssCatalog.zset("PSEUDO", "ON", 0);
        this._interrupt = false;
        this._currentRec = 0;
        this._numberRecs = this.numberRecords();
        int[] filePos = new int[]{0};
        stringContainer pathnameContainer = new stringContainer();
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        try {
            int status;
            while ((status = Heclib.zplist(dssTable, instructions, filePos, pathnameContainer)) == 0) {
                pathnameList.add(pathnameContainer.string);
                ++this._currentRec;
                if (!this._interrupt) continue;
                break;
            }
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        if ((number = pathnameList.size()) < 0) {
            System.out.println("Error occurred during pathname inventory");
        }
        return number;
    }

    public String getCatalogName(int catalogType) {
        String name = this.DSSFileName();
        if (name == null || name.length() < 2) {
            return "";
        }
        int len = name.length() - 1;
        String append = catalogType == 0 ? "d" : "c";
        return name.substring(0, len) + append;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int createNewCatalog(int catalogType) {
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
        }
        StringBuffer catInstr = new StringBuffer();
        catInstr.append("NEW");
        int[] numberFound = new int[]{-1};
        _forceNewCatalog = false;
        if (catalogType == 0) {
            catInstr.append(" COND");
        } else if (catalogType == 2) {
            catInstr.append(" FULL");
        }
        HecDssCatalog.zset("PSEUDO", "ON", 0);
        int[] catalogUnit = new int[1];
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        try {
            Heclib.makedsscatalog(this._fileData.dssFileName(), dssTable, catInstr.toString(), numberFound, catalogUnit);
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        Heclib.closescratchdsscatalog(catalogUnit);
        return numberFound[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCatalogValid() {
        int numberRecords = this.numberRecords();
        String catalogName = this.getCatalogName(1);
        File file = new File(catalogName);
        if (!file.exists()) {
            return false;
        }
        if (!file.canRead()) {
            return false;
        }
        boolean valid = true;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            int count = 0;
            while ((line = reader.readLine()) != null && valid) {
                if (++count == 2) {
                    if (line.indexOf("HECDSS") != -1) continue;
                    valid = false;
                    continue;
                }
                if (count == 5) {
                    int numb;
                    if (line.indexOf("Number of Records:") == -1) {
                        valid = false;
                        continue;
                    }
                    int loc = line.indexOf(":");
                    String s = line.substring(loc + 1, loc + 12).trim();
                    try {
                        numb = Integer.parseInt(s);
                    }
                    catch (Exception e) {
                        numb = -1;
                    }
                    if (numb == numberRecords) continue;
                    valid = false;
                    continue;
                }
                if (count == 6) {
                    if (line.indexOf("ABCFED") != -1) continue;
                    valid = false;
                    continue;
                }
                if (count != 11) continue;
                if (line.indexOf("/") == -1) {
                    valid = false;
                }
                break;
            }
        }
        catch (Exception e) {
            valid = false;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] readCatalog() {
        int numberRecords = this.numberRecords();
        String catalogName = this.getCatalogName(1);
        File file = new File(catalogName);
        if (!file.exists()) {
            return null;
        }
        if (!file.canRead()) {
            return null;
        }
        Vector<String> paths = new Vector<String>(numberRecords);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf("/");
                if (idx <= -1 || idx >= 50) continue;
                paths.add(line.substring(idx).trim());
            }
        }
        catch (Exception line) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception line) {}
            }
        }
        if (paths.size() > 0) {
            String[] pathnames = paths.toArray(new String[0]);
            return pathnames;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeCatalog(String dssFileName, String catalogName, String[] pathnames) {
        boolean valid = true;
        File file = new File(catalogName);
        PrintWriter out = null;
        try {
            file.createNewFile();
            if (!file.canWrite()) {
                boolean bl = false;
                return bl;
            }
            HecTime time = new HecTime();
            time.setCurrent();
            DecimalFormat df = new DecimalFormat("0000000");
            out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            out.println();
            out.println("     HECDSS Complete Catalog of Record Pathnames in File " + dssFileName);
            out.println();
            out.println("     Catalog Created on " + time.toString(1));
            out.println("     Number of Records:" + df.format(pathnames.length) + "                   DSS ");
            out.println("     Sort Order: ABCFED");
            out.println();
            out.println("  Ref.");
            out.println(" Number   Tag           Record Pathname");
            out.println();
            int count = 0;
            for (int i = 0; i < pathnames.length; ++i) {
                out.println(df.format(count + 1) + "           " + pathnames[count++]);
            }
        }
        catch (Exception e) {
            valid = false;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        return valid;
    }

    protected int cleanCatalogPart(String inPart, StringBuffer outPart) {
        int len;
        outPart.setLength(0);
        if (inPart.length() == 0) {
            return 0;
        }
        outPart.append(inPart.trim());
        if (outPart.equals("*")) {
            outPart.setLength(0);
        }
        if (outPart.length() == 0) {
            return 0;
        }
        if (outPart.charAt(0) == '*') {
            outPart.setCharAt(0, '@');
        }
        if (outPart.charAt(len = outPart.length() - 1) == '*') {
            outPart.setCharAt(len, '@');
        }
        return outPart.length();
    }

    public String[] expandPathname(String pathWithWild) {
        int interval;
        String[] paths = null;
        String[] tspaths = null;
        boolean hasWild = pathWithWild.indexOf(42) > 0 || pathWithWild.indexOf(63) > 0;
        DSSPathname path = new DSSPathname(pathWithWild);
        if (path.dPart().length() > 8 && path.ePart().length() > 3 && (interval = HecTimeSeriesBase.zgintlFromEPart(path.ePart())) != 0) {
            CondensedReference cr = new CondensedReference(pathWithWild);
            tspaths = cr.getPathnameList();
        }
        if (!hasWild) {
            if (tspaths != null) {
                return tspaths;
            }
            paths = new String[]{pathWithWild};
            return paths;
        }
        if (tspaths != null && tspaths.length == 1) {
            pathWithWild = tspaths[0];
            tspaths = null;
        }
        if (tspaths == null) {
            HecDssCatalog cat = new HecDssCatalog(this.DSSFileName());
            paths = cat.getCatalog(false, pathWithWild);
            return paths;
        }
        HecDssCatalog cat = new HecDssCatalog(this.DSSFileName());
        Vector<String[]> v = new Vector<String[]>();
        for (int i = 0; i < tspaths.length; ++i) {
            String[] names = cat.getCatalog(false, tspaths[i]);
            v.add(names);
        }
        int total = 0;
        for (int i = 0; i < v.size(); ++i) {
            String[] names = (String[])v.get(i);
            total += names.length;
        }
        int count = 0;
        paths = new String[total];
        for (int i = 0; i < v.size(); ++i) {
            String[] names = (String[])v.get(i);
            for (int j = 0; j < names.length; ++j) {
                paths[count++] = names[j];
            }
        }
        return paths;
    }

    @Override
    public Object clone() {
        HecDssCatalog catalog = (HecDssCatalog)super.clone();
        catalog._fileData = (HecDSSFileDataManager)this._fileData.clone();
        catalog._catalogName = this._catalogName;
        catalog.listIsComplete = this.listIsComplete;
        catalog.listIsSorted = this.listIsSorted;
        catalog.listIsCollection = this.listIsCollection;
        catalog._useCollectionGroups = this._useCollectionGroups;
        catalog.lastWriteTimeFile = this.lastWriteTimeFile;
        catalog.statusWanted = this.statusWanted;
        catalog.maxNumberToRetrieve = this.maxNumberToRetrieve;
        catalog.statusRead = this.statusRead;
        catalog.dataTypeStart = this.dataTypeStart;
        catalog.dataTypeEnd = this.dataTypeEnd;
        catalog.pathnameList = this.pathnameList != null ? Arrays.copyOf(this.pathnameList, this.pathnameList.length) : null;
        catalog.startDates = (int[])(this.startDates != null ? Arrays.copyOf(this.startDates, this.startDates.length) : null);
        catalog.endDates = (int[])(this.endDates != null ? Arrays.copyOf(this.endDates, this.endDates.length) : null);
        catalog.pathnameHash = (long[])(this.pathnameHash != null ? Arrays.copyOf(this.pathnameHash, this.pathnameHash.length) : null);
        catalog.lastWriteTimeRecord = (long[])(this.lastWriteTimeRecord != null ? Arrays.copyOf(this.lastWriteTimeRecord, this.lastWriteTimeRecord.length) : null);
        catalog.crcValues = (int[])(this.crcValues != null ? Arrays.copyOf(this.crcValues, this.crcValues.length) : null);
        catalog.pathnameAddresses = (long[])(this.pathnameAddresses != null ? Arrays.copyOf(this.pathnameAddresses, this.pathnameAddresses.length) : null);
        return catalog;
    }

    protected void fireHecDssEvent(HecDssEventType event) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != HecDssListener.class) continue;
            ((HecDssListener)listeners[i + 1]).hecDssEventPerformed(event);
        }
    }

    public void addHecDssListener(HecDssListener listener) {
        this.addHecDssListener(listener, HecDssEventType.Undefined);
    }

    public void addHecDssListener(HecDssListener listener, HecDssEventType requestedChangeType) {
        Object pathnames = null;
        if (requestedChangeType != HecDssEventType.FileChanged) {
            String path = this.pathname();
            pathnames = path != null && path.length() > 7 ? this.expandPathname(path) : (this.pathnameWithWild != null ? this.expandPathname(this.pathnameWithWild) : (this.pathnameList != null ? this.pathnameList : null));
        }
        this.addHecDssListener(listener, (String[])pathnames, requestedChangeType);
    }

    public void addHecDssListener(HecDssListener listener, String pathWithWild) {
        this.addHecDssListener(listener, pathWithWild, HecDssEventType.Undefined);
    }

    public void addHecDssListener(HecDssListener listener, String[] pathnames) {
        this.addHecDssListener(listener, pathnames, HecDssEventType.Undefined);
    }

    public void addHecDssListener(HecDssListener listener, String[] pathnames, HecDssEventType requestedEventType) {
        this.addHecDssListener(listener, null, pathnames, requestedEventType);
    }

    public void addHecDssListener(HecDssListener listener, String pathWithWild, HecDssEventType requestedEventType) {
        this.addHecDssListener(listener, pathWithWild, null, requestedEventType);
    }

    protected synchronized void addHecDssListener(HecDssListener listener, String pathWithWild, String[] pathnames, HecDssEventType requestedEventType) {
        this.lastWriteTimeFile = this.getFileLastWriteTimeMillis();
        this._listenerList.add(HecDssListener.class, listener);
        Thread thread = this.startObserverThread(pathWithWild, pathnames, requestedEventType);
        if (this._observerThreads == null) {
            this._observerThreads = new Hashtable();
        }
        this._observerThreads.put(listener, thread);
        thread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (HecDssCatalog.this._observerThreads != null) {
                    Set<HecDssListener> listenerKeys = HecDssCatalog.this._observerThreads.keySet();
                    for (HecDssListener listenerKey : listenerKeys) {
                        HecDssCatalog.this.removeHecDssListener(listenerKey);
                    }
                }
            }
        });
    }

    public synchronized void removeHecDssListener(HecDssListener listener) {
        Thread thread = this._observerThreads.get(listener);
        if (thread != null) {
            thread.interrupt();
            this._observerThreads.remove(listener);
        }
        this._listenerList.remove(HecDssListener.class, listener);
    }

    @Override
    public void hecDssEventPerformed(HecDssEventType source) {
    }

    protected Thread startObserverThread(String pathWithWildChars, String[] pathnameList, HecDssEventType requestedEventType) {
        long waitTime = 2000L;
        final HecDssCatalog catalog = this;
        final HecDssCatalog catalogBefore = (HecDssCatalog)this.clone();
        final String[] pathList = pathnameList;
        final String pathWithWild = pathWithWildChars;
        final HecDssEventType _requestedChangeType = requestedEventType;
        String name = "HecDSS Listener thread for file: " + this.DSSFileName();
        if (pathWithWildChars != null && pathWithWildChars.length() > 4) {
            name = name + ", for pathname " + pathWithWildChars;
        }
        Thread runner = new Thread(null, null, name){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                lastWriteTimeRecords = pathList != null ? new long[pathList.length] : null;
                try {
                    lockThreadToken = new intContainer();
                    dssTable = HecDssCatalog.this._fileData.requestAccess(lockThreadToken);
                    if (dssTable == null) {
                        throw new IOException("The dssFile " + HecDssCatalog.this.DSSFileName() + " could not be opened, or may not be exist");
                    }
                    try {
                        numberRecordsInFile = (int)Heclib.zinquire(dssTable, "nrecs");
                        catalogBefore.lastWriteTimeFile = lastWriteTimeFile = Heclib.zlastWriteTimeFile(dssTable);
                        if (pathList != null) {
                            for (i = 0; i < pathList.length; ++i) {
                                lastWriteTimeRecords[i] = Heclib.zlastWriteTime(dssTable, pathList[i]);
                            }
                        }
                    }
                    finally {
                        HecDssCatalog.this._fileData.releaseAccess(lockThreadToken);
                    }
                    while (!Thread.currentThread().isInterrupted()) {
                        Thread.sleep(2000L);
                        time = catalog.getFileLastWriteTimeMillis();
                        event = HecDssEventType.Undefined;
                        if (time == lastWriteTimeFile) continue;
                        lastWriteTimeFile = time;
                        if (_requestedChangeType == HecDssEventType.FileChanged) {
                            event = HecDssEventType.FileChanged;
                        } else if (pathWithWild != null) {
                            try {
                                dssTable = HecDssCatalog.this._fileData.requestAccess(lockThreadToken);
                                if (dssTable == null) {
                                    throw new IOException("The dssFile " + HecDssCatalog.this.DSSFileName() + " could not be opened, or may not be exist");
                                }
                                catalog.pathnameList = null;
                                Heclib.zwhatChangedCompare(dssTable, catalogBefore, catalog, pathWithWild, false);
                                if (catalog.pathnameList == null) ** GOTO lbl87
                                if (_requestedChangeType == HecDssEventType.RecordsAdded) {
                                    v = new Vector<String>();
                                    for (i = 0; i < catalog.pathnameList.length; ++i) {
                                        recordBasics = new HecDSSRecordBasics(catalog.pathnameList[i]);
                                        Heclib.zgetRecordBasics(dssTable, recordBasics);
                                        if (recordBasics.version != 1) continue;
                                        v.add(catalog.pathnameList[i]);
                                    }
                                    catalog.pathnameList = v.toArray(new String[0]);
                                    event = HecDssEventType.RecordsAdded;
                                }
                                event = HecDssEventType.RecordsChanged;
                            }
                            finally {
                                HecDssCatalog.this._fileData.releaseAccess(lockThreadToken);
                            }
                        } else if (pathList != null) {
                            dssTable = HecDssCatalog.this._fileData.requestAccess(lockThreadToken);
                            if (dssTable == null) {
                                throw new IOException("The dssFile " + HecDssCatalog.this.DSSFileName() + " could not be opened, or may not be exist");
                            }
                            try {
                                for (i = 0; i < pathList.length; ++i) {
                                    recordTime = Heclib.zlastWriteTime(dssTable, pathList[i]);
                                    if (recordTime == lastWriteTimeRecords[i]) continue;
                                    if (lastWriteTimeRecords[i] <= 0L) {
                                        if (_requestedChangeType == HecDssEventType.Undefined || _requestedChangeType == HecDssEventType.RecordsAdded) {
                                            event = HecDssEventType.RecordsAdded;
                                        }
                                    } else if (recordTime <= 0L) {
                                        if (!(_requestedChangeType != HecDssEventType.Undefined && _requestedChangeType != HecDssEventType.RecordsDeleted || event != HecDssEventType.Undefined && event != HecDssEventType.RecordsChanged)) {
                                            event = HecDssEventType.RecordsDeleted;
                                        }
                                    } else if ((_requestedChangeType == HecDssEventType.Undefined || _requestedChangeType == HecDssEventType.RecordsChanged) && event == HecDssEventType.Undefined) {
                                        event = HecDssEventType.RecordsChanged;
                                    }
                                    lastWriteTimeRecords[i] = recordTime;
                                }
                            }
                            finally {
                                HecDssCatalog.this._fileData.releaseAccess(lockThreadToken);
                            }
                        } else if (_requestedChangeType == HecDssEventType.RecordsAdded || _requestedChangeType == HecDssEventType.RecordsDeleted) {
                            numberRecords = (int)Heclib.zinquire(dssTable, "nrecs");
                            if (numberRecordsInFile != numberRecords) {
                                event = numberRecords > numberRecordsInFile ? HecDssEventType.RecordsAdded : HecDssEventType.RecordsDeleted;
                                numberRecordsInFile = numberRecords;
                            }
                        } else if (_requestedChangeType == HecDssEventType.Undefined) {
                            event = HecDssEventType.FileChanged;
                        }
lbl87:
                        // 9 sources

                        if (event == HecDssEventType.Undefined) continue;
                        HecDssCatalog.this.fireHecDssEvent(event);
                    }
                }
                catch (InterruptedException lockThreadToken) {
                }
                catch (IOException e) {
                    HecDssCatalog.LOGGER.log(Level.SEVERE, "DSS Observer Thread terminated abnormally", e);
                }
            }
        };
        return runner;
    }

    @Deprecated
    protected class WriteCatalogFileRunnable
    implements Runnable {
        protected WriteCatalogFileRunnable() {
        }

        @Override
        public void run() {
            String dssName = HecDssCatalog.this.DSSFileName();
            HecDssCatalog.this.writeCatalog(dssName, HecDssCatalog.this._catalogName, HecDssCatalog.this.pathnameList);
        }
    }
}

