/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecDataManager;
import hec.heclib.util.Heclib;
import hec.heclib.util.intContainer;
import hec.heclib.util.stringContainer;
import hec.io.DssFileContainer;
import hec.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import rma.util.RMAFilenameFilter;

public class HecDssFileStore
extends HecDataManager {
    public HecDssFileStore(String DssFileName) {
        super(DssFileName);
    }

    public HecDssFileStore() {
    }

    public int write(File file, DSSPathname pathname) throws Exception {
        this.setPathname(pathname.pathname());
        return this.write(file);
    }

    public int write(File file) throws Exception {
        String extension = RMAFilenameFilter.getExtension(file);
        if (this.cPart().length() == 0) {
            this.setCPart(file.getName());
        }
        this.setDPart("FILE");
        this.setEPart(extension);
        byte[] fileArray = this.readDiskFile(file);
        int status = this.write(fileArray, 600, extension, file.lastModified(), file.getName(), file.getName(), -1, -1, -1, -1);
        return status;
    }

    public DssFileContainer getFileContainer(File file) throws Exception {
        DssFileContainer fileContainer = new DssFileContainer();
        fileContainer.extension = RMAFilenameFilter.getExtension(file);
        if (this.cPart().length() == 0) {
            this.setCPart(file.getName());
        }
        this.setDPart("FILE");
        this.setEPart(fileContainer.extension);
        fileContainer.fileArray = this.readDiskFile(file);
        fileContainer.lastModTime = file.lastModified();
        fileContainer.dataType = 600;
        fileContainer.displayName = file.getName();
        fileContainer.imageFileName = file.getName();
        fileContainer.fullName = this.pathname();
        fileContainer.fileName = this.DSSFileName();
        return fileContainer;
    }

    public int exportToDirectory(String directory) throws Exception {
        return this.export(null, directory);
    }

    public int exportToFile(File file) throws Exception {
        return this.export(file, "");
    }

    public int export(File exportFile, String directory) throws Exception {
        DssFileContainer fileContainer = new DssFileContainer();
        int status = this.read(fileContainer);
        if (status < 0) {
            return status;
        }
        HecDssFileStore.export(fileContainer, exportFile, directory);
        return 0;
    }

    public static void export(DssFileContainer fileContainer, File exportFile, String directory) throws Exception {
        if (exportFile == null) {
            String name = directory + File.separator + fileContainer.imageFileName;
            exportFile = new File(name);
        }
        if (!exportFile.exists()) {
            exportFile.createNewFile();
        }
        if (!exportFile.canWrite()) {
            throw new Exception("Cannot write to file " + exportFile.getAbsolutePath());
        }
        FileOutputStream file_output = new FileOutputStream(exportFile);
        DataOutputStream data_out = new DataOutputStream(file_output);
        data_out.write(fileContainer.fileArray, 0, fileContainer.fileArray.length);
        if (fileContainer.lastModTime > 0L) {
            exportFile.setLastModified(fileContainer.lastModTime);
        }
        data_out.close();
    }

    public void runProcess() throws Exception {
        String cpart = this.cPart();
        String name = cpart.substring(0, cpart.lastIndexOf("."));
        File file = File.createTempFile(name, "." + this.ePart());
        file.deleteOnExit();
        int status = this.exportToFile(file);
        if (status != 0) {
            throw new Exception("Error in retrieving  " + this.pathname() + ",  " + status);
        }
        Util.runProcess(file.getAbsolutePath());
    }

    public static void runProcess(DssFileContainer fileContainer) throws Exception {
        String name = fileContainer.displayName.replaceAll(" ", "_");
        File file = File.createTempFile(name, "." + fileContainer.extension);
        file.deleteOnExit();
        HecDssFileStore.export(fileContainer, file, "");
        Util.runProcess(file.getAbsolutePath());
    }

    public static void runProcess(String dssFileAndPath) throws Exception {
        int indx = dssFileAndPath.indexOf(".dss:/");
        if (indx > 0) {
            HecDssFileStore dssFileStore = new HecDssFileStore();
            dssFileStore.setDSSFileName(dssFileAndPath.substring(0, indx + 4));
            dssFileStore.setPathname(dssFileAndPath.substring(indx + 5));
            dssFileStore.runProcess();
        }
    }

    protected byte[] readDiskFile(File file) throws Exception {
        FileInputStream file_input = new FileInputStream(file);
        DataInputStream data_in = new DataInputStream(file_input);
        int numberBytes = HecDssFileStore.roundUpNumberOfBytes(file.length(), 4);
        byte[] fileArray = new byte[numberBytes];
        fileArray[numberBytes - 4] = 0;
        fileArray[numberBytes - 3] = 0;
        fileArray[numberBytes - 2] = 0;
        fileArray[numberBytes - 1] = 0;
        data_in.read(fileArray, 0, (int)file.length());
        file_input.close();
        return fileArray;
    }

    public int write(DssFileContainer fileContainer) {
        if (fileContainer.fileName != null && fileContainer.fileName.length() > 0) {
            this.setDSSFileName(fileContainer.fileName);
        }
        if (fileContainer.fullName != null && fileContainer.fullName.length() > 0) {
            this.setPathname(fileContainer.fullName);
        }
        return this.write(fileContainer.fileArray, fileContainer.dataType, fileContainer.extension, fileContainer.lastModTime, fileContainer.fileName, fileContainer.displayName, fileContainer.actualWidth, fileContainer.actualHeight, fileContainer.preferredWidth, fileContainer.preferredHeight);
    }

    protected int write(byte[] fileArray, int dataType, String extension, long lastModTime, String fileName, String displayName, int actualWidth, int actualHeight, int preferredWidth, int preferredHeight) {
        int i;
        int[] status = new int[1];
        String path = this.pathname();
        int[] compheader = new int[1];
        int[] userheader = new int[1];
        int[] found = new int[1];
        int ndata = HecDssFileStore.numDssWords(fileArray.length, 4);
        int len = ndata * 4;
        byte[] array = len != fileArray.length ? Arrays.copyOf(fileArray, len) : fileArray;
        int lenFileName = HecDssFileStore.numDssWords(fileName.length(), 4);
        int lenDisplayName = HecDssFileStore.numDssWords(displayName.length(), 4);
        int nintheader = 8 + lenFileName + lenFileName;
        int[] intheader = new int[nintheader];
        Heclib.StringHol(extension + "   ", 4, intheader);
        intheader[1] = (int)lastModTime;
        intheader[2] = actualWidth;
        intheader[3] = actualHeight;
        intheader[4] = preferredWidth;
        intheader[5] = preferredHeight;
        intheader[6] = lenFileName;
        intheader[7] = lenDisplayName;
        int[] tmp = new int[lenFileName];
        Heclib.StringHol(fileName + "   ", lenFileName * 4, tmp);
        for (i = 0; i < lenFileName; ++i) {
            intheader[i + 8] = tmp[i];
        }
        tmp = new int[lenDisplayName];
        Heclib.StringHol(displayName + "   ", lenDisplayName * 4, tmp);
        for (i = 0; i < lenDisplayName; ++i) {
            intheader[i + lenFileName + 8] = tmp[i];
        }
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -4;
        }
        Heclib.zwritxBytes(dssTable, path, path.length(), intheader, nintheader, compheader, 0, userheader, 0, array, ndata, dataType, 0, status, found);
        this._fileData.releaseAccess(lockThreadToken);
        return status[0];
    }

    public int read(DssFileContainer fileContainer) {
        stringContainer extension = new stringContainer();
        stringContainer fileName = new stringContainer();
        stringContainer displayName = new stringContainer();
        int[] status = new int[1];
        long[] lastModTime = new long[1];
        int[] actualWidth = new int[1];
        int[] actualHeight = new int[1];
        int[] preferredWidth = new int[1];
        int[] preferredHeight = new int[1];
        byte[] fileArray = this.read(extension, lastModTime, fileName, displayName, actualWidth, actualHeight, preferredWidth, preferredHeight, status);
        fileContainer.fullName = this.pathname();
        fileContainer.fileName = this.DSSFileName();
        fileContainer.dataType = this.recordType();
        fileContainer.fileArray = fileArray;
        fileContainer.extension = extension.string;
        fileContainer.lastModTime = lastModTime[0];
        fileContainer.imageFileName = fileName.string;
        fileContainer.displayName = displayName.string;
        fileContainer.actualWidth = actualWidth[0];
        fileContainer.actualHeight = actualHeight[0];
        fileContainer.preferredWidth = preferredWidth[0];
        fileContainer.preferredHeight = preferredHeight[0];
        return status[0];
    }

    protected byte[] read(stringContainer extension, long[] lastModTime, stringContainer fileName, stringContainer displayName, int[] actualWidth, int[] actualHeight, int[] preferredWidth, int[] preferredHeight, int[] stat) {
        byte[] byteArray = null;
        String path = this.pathname();
        int kintheader = 200;
        int[] intheader = new int[kintheader];
        int[] compheader = new int[1];
        int[] userheader = new int[1];
        int[] idummy = new int[1];
        int[] found = new int[1];
        this.recordExists(path);
        if (this._dataLengthInts <= 0) {
            System.out.println("Record does not exist: " + path);
            stat[0] = -1;
            return null;
        }
        byteArray = new byte[this._dataLengthInts * 4];
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            stat[0] = -4;
            return null;
        }
        Heclib.zreadxBytes(dssTable, path, intheader, kintheader, idummy, compheader, 0, idummy, userheader, 0, idummy, byteArray, this._dataLengthInts, idummy, 1, found);
        this._fileData.releaseAccess(lockThreadToken);
        if (found[0] == 0) {
            stat[0] = -1;
            return null;
        }
        extension.string = Heclib.holString(intheader, 4);
        lastModTime[0] = intheader[1];
        actualWidth[0] = intheader[2];
        actualHeight[0] = intheader[3];
        preferredWidth[0] = intheader[4];
        preferredHeight[0] = intheader[5];
        int lenFileName = intheader[6];
        int[] tmp = new int[lenFileName];
        for (int i = 0; i < lenFileName; ++i) {
            tmp[i] = intheader[i + 8];
        }
        fileName.string = Heclib.holString(tmp, lenFileName * 4).trim();
        int lenDisplayName = intheader[7];
        tmp = new int[lenDisplayName];
        for (int i = 0; i < lenDisplayName; ++i) {
            tmp[i] = intheader[i + lenFileName + 8];
        }
        displayName.string = Heclib.holString(tmp, lenDisplayName * 4).trim();
        return byteArray;
    }

    private static int roundUpNumberOfBytes(long num, int multiple) {
        int numberBytes = (int)((num - 1L) / (long)multiple + 1L) * multiple;
        return numberBytes;
    }

    private static int numDssWords(int length, int bytesPerWord) {
        return (length - 1) / bytesPerWord + 1;
    }
}

