/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.HecDssFileStore;
import hec.io.DssFileContainer;
import hec.util.PhotoViewerInfo;
import java.io.File;
import rma.util.RMAFilenameFilter;

public class HecDssImage
extends HecDssFileStore {
    public HecDssImage() {
    }

    public HecDssImage(String DssFileName) {
        super(DssFileName);
    }

    @Override
    public int write(File file) throws Exception {
        String extension = RMAFilenameFilter.getExtension(file);
        if (this.cPart().length() == 0) {
            this.setCPart(file.getName());
        }
        this.setDPart("IMAGE");
        this.setEPart(extension);
        byte[] fileArray = this.readDiskFile(file);
        int status = this.write(fileArray, 610, extension, file.lastModified(), file.getName(), file.getName(), -1, -1, -1, -1);
        return status;
    }

    @Override
    public DssFileContainer getFileContainer(File file) throws Exception {
        DssFileContainer fileContainer = new DssFileContainer();
        fileContainer.extension = RMAFilenameFilter.getExtension(file);
        if (this.cPart().length() == 0) {
            this.setCPart(file.getName());
        }
        this.setDPart("IMAGE");
        this.setEPart(fileContainer.extension);
        fileContainer.fileArray = this.readDiskFile(file);
        fileContainer.lastModTime = file.lastModified();
        fileContainer.dataType = 610;
        fileContainer.displayName = file.getName();
        fileContainer.imageFileName = file.getName();
        fileContainer.fullName = this.pathname();
        fileContainer.fileName = this.DSSFileName();
        return fileContainer;
    }

    public int read(PhotoViewerInfo info) {
        DssFileContainer fileContainer = new DssFileContainer();
        int status = this.read(fileContainer);
        if (status < 0) {
            return status;
        }
        return this.loadImage(info, fileContainer);
    }

    public int loadImage(PhotoViewerInfo info, DssFileContainer fileContainer) {
        info.name = fileContainer.displayName;
        info.url = fileContainer.imageFileName;
        if (fileContainer.preferredWidth > 0) {
            info.xSize = fileContainer.preferredWidth;
        }
        if (fileContainer.preferredHeight > 0) {
            info.ySize = fileContainer.preferredHeight;
        }
        try {
            info.loadFromMemory(fileContainer.fileArray);
        }
        catch (Exception e) {
            return -3;
        }
        return 0;
    }

    public static int readDSSImage(PhotoViewerInfo info) {
        int stat = -1;
        String tmp = info.url.toLowerCase();
        int indx = tmp.indexOf(".dss:/");
        if (indx > 0) {
            HecDssImage dssImage = new HecDssImage();
            dssImage.setDSSFileName(info.url.substring(0, indx + 4));
            dssImage.setPathname(info.url.substring(indx + 5));
            PhotoViewerInfo rinfo = new PhotoViewerInfo();
            stat = dssImage.read(rinfo);
            if (stat == 0) {
                info.bufferedImage = rinfo.bufferedImage;
                if (info.name.length() == 0) {
                    info.name = rinfo.name;
                }
            }
        }
        return stat;
    }
}

