/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.HecDSSRecordData;
import hec.heclib.dss.HecDataManager;
import hec.heclib.util.Heclib;
import hec.heclib.util.intContainer;
import hec.io.TinContainer;

public class HecDssTin
extends HecDataManager {
    public HecDssTin() {
        this._recordData = new HecDSSRecordData();
    }

    public HecDssTin(String DssFileName) {
        super(DssFileName);
        this._recordData = new HecDSSRecordData();
    }

    public int read(TinContainer tinContainer, boolean retrieveData) {
        if (tinContainer.fullName == null || tinContainer.fullName.length() < 3) {
            if (this.dirty()) {
                this.recordType();
            }
            tinContainer.fullName = this._dssPathname.pathname();
        }
        if (this.getDssFileVersion() == 7) {
            intContainer lockThreadToken;
            int[] dssTable;
            if (tinContainer.fullName == null || tinContainer.fullName.length() < 3) {
                tinContainer.fullName = this._dssPathname.pathname();
            }
            if ((dssTable = this._fileData.requestAccess(lockThreadToken = new intContainer())) == null) {
                return -4;
            }
            int status = Heclib.ztinRetrieve(dssTable, tinContainer, retrieveData);
            this._fileData.releaseAccess(lockThreadToken);
            if (status != 0) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public int write(TinContainer tinContainer) {
        if (tinContainer.fullName == null || tinContainer.fullName.length() < 3) {
            if (this.dirty()) {
                this.recordType();
            }
            tinContainer.fullName = this._dssPathname.pathname();
        }
        tinContainer.updateStatistics();
        if (this.getDssFileVersion() == 7) {
            intContainer lockThreadToken = new intContainer();
            int[] dssTable = this._fileData.requestAccess(lockThreadToken);
            if (dssTable == null) {
                return -4;
            }
            int status = Heclib.ztinStore(dssTable, tinContainer);
            this._fileData.releaseAccess(lockThreadToken);
            if (status == 0) {
                return 0;
            }
            return -1;
        }
        return -1;
    }
}

