/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.HecDSSRecordData;
import hec.heclib.dss.HecDSSRecordInfo;
import hec.heclib.dss.HecDataManager;
import hec.heclib.util.HecDoubleArray;
import hec.heclib.util.Heclib;
import hec.heclib.util.booleanContainer;
import hec.heclib.util.doubleArrayContainer;
import hec.heclib.util.intContainer;
import hec.heclib.util.stringContainer;
import hec.io.PairedDataContainer;
import hec.io.PairedDataContainerVertDatum;
import hec.util.TextUtil;
import java.util.HashMap;
import java.util.Vector;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;

public class HecPairedData
extends HecDataManager {
    String[] clabel = new String[1000];
    int klabel = 1000;
    boolean _storeDoubles = true;

    public HecPairedData() {
        this._recordData = new HecDSSRecordData();
    }

    public HecPairedData(String DSSfilename) {
        super(DSSfilename);
        this._recordData = new HecDSSRecordData();
    }

    public void setXUnits(String xUnits) {
        this._recordData.unitsX = xUnits;
        this._unitsX = xUnits;
    }

    public void setYUnits(String yUnits) {
        this._recordData.unitsY = yUnits;
    }

    public void setXType(String xType) {
        this._recordData.typeX = xType;
        this._typeX = xType;
    }

    public void setYType(String yType) {
        this._recordData.typeY = yType;
    }

    public String unitsX() {
        if (!this.checkRead()) {
            return "";
        }
        return this._recordData.unitsX;
    }

    public String unitsY() {
        if (!this.checkRead()) {
            return "";
        }
        return this._recordData.unitsY;
    }

    public String typeX() {
        if (!this.checkRead()) {
            return "";
        }
        return this._recordData.typeX;
    }

    public String typeY() {
        if (!this.checkRead()) {
            return "";
        }
        return this._recordData.typeY;
    }

    public void setStoreDoubles(boolean storeDoubles) {
        this._storeDoubles = storeDoubles;
    }

    public boolean getStoreDoubles() {
        return this._storeDoubles;
    }

    public String DSSFileName(boolean useDefault) {
        String filename = "";
        filename = useDefault ? this.DSSFileName() : this._fileData.dssFilename();
        return filename;
    }

    public double minimumX() {
        if (!this.checkRead()) {
            return -3.4028234663852886E38;
        }
        double minimum = this._recordData.arrayX[0];
        for (int i = 1; i < this._recordData.arraySize; ++i) {
            if (!(minimum > this._recordData.arrayX[i])) continue;
            minimum = this._recordData.arrayX[i];
        }
        return minimum;
    }

    public double minimumY(int curveNumber) {
        if (this.numberOfCurves() - 1 < curveNumber) {
            return -3.4028234663852886E38;
        }
        if (!this.checkRead()) {
            return -3.4028234663852886E38;
        }
        double minimum = this._recordData.arrayY[curveNumber][0];
        for (int i = 1; i < this._recordData.arraySize; ++i) {
            if (!(minimum > this._recordData.arrayY[curveNumber][i])) continue;
            minimum = this._recordData.arrayY[curveNumber][i];
        }
        return minimum;
    }

    public double minimumY() {
        return this.minimumY(0);
    }

    public double maximumX() {
        if (!this.checkRead()) {
            return -3.4028234663852886E38;
        }
        double maximum = this._recordData.arrayX[0];
        for (int i = 1; i < this._recordData.arraySize; ++i) {
            if (!(maximum < this._recordData.arrayX[i])) continue;
            maximum = this._recordData.arrayX[i];
        }
        return maximum;
    }

    public double maximumY(int curveNumber) {
        if (this.numberOfCurves() - 1 < curveNumber) {
            return -3.4028234663852886E38;
        }
        if (!this.checkRead()) {
            return -3.4028234663852886E38;
        }
        double maximum = this._recordData.arrayY[curveNumber][0];
        for (int i = 1; i < this._recordData.arraySize; ++i) {
            if (!(maximum < this._recordData.arrayY[curveNumber][i])) continue;
            maximum = this._recordData.arrayY[curveNumber][i];
        }
        return maximum;
    }

    public double maximumY() {
        return this.maximumY(0);
    }

    public double averageX() {
        if (!this.checkRead()) {
            return -3.4028234663852886E38;
        }
        double sum = 0.0;
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            sum += this._recordData.arrayX[i];
        }
        return sum / (double)this._recordData.arraySize;
    }

    public double averageY(int curveNumber) {
        if (this.numberOfCurves() - 1 < curveNumber) {
            return -3.4028234663852886E38;
        }
        if (!this.checkRead()) {
            return -3.4028234663852886E38;
        }
        double sum = 0.0;
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            sum += this._recordData.arrayY[curveNumber][i];
        }
        return sum / (double)this._recordData.arraySize;
    }

    public double averageY() {
        return this.averageY(0);
    }

    public int numberOfCurves() {
        return this._recordData.numberCurves;
    }

    public int read(HecDoubleArray xArray, HecDoubleArray yArray) {
        int numberOrdinates = this.retrieveData();
        xArray.setSize(numberOrdinates);
        yArray.setSize(numberOrdinates);
        for (int i = 0; i < numberOrdinates; ++i) {
            xArray.set(i, this._recordData.arrayX[i]);
            yArray.set(i, this._recordData.arrayY[0][i]);
        }
        if (this._recordData.precision < 0) {
            xArray.setPrecision(-1);
            yArray.setPrecision(-1);
        } else {
            int xprec = this._recordData.precision / 10;
            int yprec = this._recordData.precision - xprec * 10;
            xArray.setPrecision(xprec);
            yArray.setPrecision(yprec);
        }
        return numberOrdinates;
    }

    public int read(doubleArrayContainer xArray, doubleArrayContainer yArray) {
        int numberOrdinates = this.retrieveData();
        xArray.array = this._recordData.arrayX;
        yArray.array = this._recordData.arrayY[0];
        return numberOrdinates;
    }

    public int read(HecDoubleArray xArray, Vector vector) {
        int i;
        int numberOrdinates = this.retrieveData();
        int xprec = -1;
        int yprec = -1;
        if (this._recordData.precision >= 0) {
            xprec = this._recordData.precision / 10;
            yprec = this._recordData.precision - xprec * 10;
        }
        xArray.setSize(numberOrdinates);
        for (i = 0; i < numberOrdinates; ++i) {
            xArray.set(i, this._recordData.arrayX[i]);
        }
        xArray.setPrecision(xprec);
        for (i = 0; i < this._recordData.numberCurves; ++i) {
            HecDoubleArray y = new HecDoubleArray(numberOrdinates);
            for (int j = 0; j < numberOrdinates; ++j) {
                y.set(j, this._recordData.arrayY[i][j]);
            }
            y.setPrecision(yprec);
            vector.addElement(y);
        }
        return numberOrdinates;
    }

    public int read(doubleArrayContainer xArray, Vector vector) {
        int numberOrdinates = this.retrieveData();
        xArray.array = this._recordData.arrayX;
        xArray.length = this._recordData.arraySize;
        doubleArrayContainer[] dac = new doubleArrayContainer[this._recordData.arrayY.length];
        for (int i = 0; i < this._recordData.numberCurves; ++i) {
            dac[i] = new doubleArrayContainer();
            dac[i].array = this._recordData.arrayY[i];
            dac[i].length = this._recordData.arrayY[i].length;
            vector.addElement(dac[i]);
        }
        return numberOrdinates;
    }

    public int read(PairedDataContainer pairedDataContainer) {
        int status;
        if (pairedDataContainer.fullName != null && pairedDataContainer.fullName.length() > 7) {
            this.setPathname(pairedDataContainer.fullName);
            if (pairedDataContainer.fileName != null && pairedDataContainer.fileName.length() > 0) {
                this.setDSSFileName(pairedDataContainer.fileName, true);
            }
        } else {
            pairedDataContainer.fullName = this.pathname();
            pairedDataContainer.fileName = this.DSSFileName();
        }
        if (this.getDssFileVersion() == 7) {
            intContainer lockThreadToken = new intContainer();
            int[] dssTable = this._fileData.requestAccess(lockThreadToken);
            if (dssTable == null) {
                return -3;
            }
            int status2 = Heclib.zpdRetrieve(dssTable, pairedDataContainer);
            this.checkForSevereError(dssTable);
            this._fileData.releaseAccess(lockThreadToken);
            if (HecPairedData.checkForSevereError()) {
                return -4;
            }
            this.readRecordInfo(pairedDataContainer);
            HashMap<String, String> si = pairedDataContainer.getSupplementalInfo();
            if (si.containsKey("datum")) {
                pairedDataContainer.datum = Double.valueOf(si.get("datum"));
                si.remove("datum");
            }
            if (si.containsKey("shift")) {
                pairedDataContainer.shift = Double.valueOf(si.get("shift"));
                si.remove("shift");
            }
            if (si.containsKey("offset")) {
                pairedDataContainer.offset = Double.valueOf(si.get("offset"));
                si.remove("offset");
            }
            if (si.containsKey("transformType")) {
                switch (si.get("transformType")) {
                    case "LINLIN": {
                        pairedDataContainer.transformType = 1;
                        break;
                    }
                    case "LOGLOG": {
                        pairedDataContainer.transformType = 2;
                    }
                }
                si.remove("transformType");
            }
            if (pairedDataContainer instanceof PairedDataContainerVertDatum) {
                PairedDataContainerVertDatum pdcvd = (PairedDataContainerVertDatum)pairedDataContainer;
                if (si.containsKey("verticalDatumInfo")) {
                    String compressed = si.get("verticalDatumInfo");
                    try {
                        String xml = TextUtil.uncompress(compressed, "base64");
                        pdcvd.setVerticalDatumContainer(new VerticalDatumContainer(xml));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    si.remove("verticalDatumInfo");
                    if (si.containsKey("verticalDatum")) {
                        String currentVerticalDatum = si.get("verticalDatum");
                        try {
                            pdcvd.forceVerticalDatum(currentVerticalDatum);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        si.remove("verticalDatum");
                    }
                }
                pdcvd.setSupplementalInfo(si);
            }
            return status2;
        }
        if (this.pathname().length() < 8) {
            this.setPathname(pairedDataContainer.fullName);
        }
        if ((status = this.retrieveData()) <= 0) {
            return -1;
        }
        this.readRecordInfo(pairedDataContainer);
        super.copyRecordDataToContainer(pairedDataContainer);
        pairedDataContainer.supplementalInfo = this._recordData.supplementalInfo;
        pairedDataContainer.numberOrdinates = this._recordData.arraySize;
        pairedDataContainer.numberCurves = this._recordData.numberCurves;
        pairedDataContainer.xOrdinates = this._recordData.arrayX;
        pairedDataContainer.labelsUsed = this._recordData.labelsUsed;
        if (this._recordData.labelsUsed) {
            pairedDataContainer.labels = new String[this._recordData.numberCurves];
        }
        pairedDataContainer.yOrdinates = new double[pairedDataContainer.numberCurves][pairedDataContainer.numberOrdinates];
        for (int i = 0; i < this._recordData.numberCurves; ++i) {
            for (int j = 0; j < this._recordData.arraySize; ++j) {
                pairedDataContainer.yOrdinates[i][j] = this._recordData.arrayY[i][j];
            }
            if (!this._recordData.labelsUsed || this._recordData.curveLabels == null) continue;
            pairedDataContainer.labels[i] = this._recordData.curveLabels[i];
        }
        pairedDataContainer.switchXyAxis = this._recordData.horizontalAxis == 2;
        if (this._recordData.precision < 0) {
            pairedDataContainer.xprecision = -1;
            pairedDataContainer.yprecision = -1;
        } else {
            pairedDataContainer.xprecision = this._recordData.precision / 10;
            pairedDataContainer.yprecision = this._recordData.precision - pairedDataContainer.xprecision * 10;
        }
        pairedDataContainer.dataType = this._recordData.recordType;
        pairedDataContainer.storedAsdoubles = this._recordData.storeDoubles;
        if (this._recordData.ratingInfo != null && this._recordData.ratingInfo.length == 4) {
            pairedDataContainer.offset = this._recordData.ratingInfo[0];
            pairedDataContainer.shift = this._recordData.ratingInfo[1];
            pairedDataContainer.datum = this._recordData.ratingInfo[2];
            if (this._recordData.ratingInfo[3] == 1.0) {
                pairedDataContainer.transformType = 1;
            } else if (this._recordData.ratingInfo[3] == 2.0) {
                pairedDataContainer.transformType = 2;
            }
        }
        pairedDataContainer.xunits = this._recordData.unitsX;
        pairedDataContainer.yunits = this._recordData.unitsY;
        pairedDataContainer.xtype = this._recordData.typeX;
        pairedDataContainer.ytype = this._recordData.typeY;
        pairedDataContainer.xparameter = this.cPart();
        pairedDataContainer.other = this.dPart();
        pairedDataContainer.date = this.ePart();
        String c2 = this.cPart();
        int dash = c2.indexOf("-");
        if (dash <= 0 || dash == c2.length()) {
            pairedDataContainer.xparameter = c2;
            pairedDataContainer.yparameter = "";
        } else {
            pairedDataContainer.xparameter = c2.substring(0, dash);
            pairedDataContainer.yparameter = c2.substring(dash + 1);
        }
        if (pairedDataContainer instanceof PairedDataContainerVertDatum) {
            PairedDataContainerVertDatum pdcvd = (PairedDataContainerVertDatum)pairedDataContainer;
            HashMap<String, String> si = pdcvd.getSupplementalInfo();
            if (si.containsKey("verticalDatumInfo")) {
                String compressed = si.get("verticalDatumInfo");
                try {
                    String xml = TextUtil.uncompress(compressed, "base64");
                    pdcvd.setVerticalDatumContainer(new VerticalDatumContainer(xml));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                si.remove("verticalDatumInfo");
                if (si.containsKey("verticalDatum")) {
                    String currentVerticalDatum = si.get("verticalDatum");
                    try {
                        pdcvd.forceVerticalDatum(currentVerticalDatum);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    si.remove("verticalDatum");
                }
            }
            pdcvd.setSupplementalInfo(si);
        }
        return 0;
    }

    private void readRecordInfo(PairedDataContainer pairedDataContainer) {
        if (pairedDataContainer.otherInfo != null && pairedDataContainer.otherInfo instanceof HecDSSRecordInfo) {
            this.getRecordInfo((HecDSSRecordInfo)pairedDataContainer.otherInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int retrieveData() {
        if (!this.fileAccessible()) {
            this.setDSSFileName(this.DSSFileName());
            this.open();
        }
        int[] numberOfCurves = new int[1];
        int numberOrdinates = 0;
        int precision = -1;
        String pathname = null;
        if (this.dirty() && this.recordType() == 0 && this.recordType(pathname = this._dssPathname.getRetrievePath()) == 0) {
            System.out.println("Cannot Retrieve Data for Record: " + pathname);
            return -1;
        }
        if (pathname == null) {
            pathname = this._dssPathname.pathname();
        }
        if (this._checkedNumber <= 0) {
            this.recordType(pathname);
        }
        if (this._checkedNumber <= 0) {
            System.out.println("Record does not exist: " + pathname);
            return -1;
        }
        this._desiredArraySize = this._checkedNumber / 2;
        int klabel = 100;
        double[] values = new double[this._checkedNumber];
        int[] nord = new int[1];
        int[] ihoriz = new int[1];
        stringContainer unitsX = new stringContainer();
        stringContainer typeX = new stringContainer();
        stringContainer unitsY = new stringContainer();
        stringContainer typeY = new stringContainer();
        int[] numberOfValues = new int[1];
        booleanContainer labelsExist = new booleanContainer();
        int[] nhead = new int[1];
        int khead = 200;
        float[] head = new float[khead];
        int[] status = new int[1];
        stringContainer dataTypeName = new stringContainer();
        int[] dataTypeNumber = new int[1];
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -3;
        }
        try {
            Heclib.zrpdd(dssTable, pathname, nord, numberOfCurves, ihoriz, unitsX, typeX, unitsY, typeY, values, this._checkedNumber, numberOfValues, this.clabel, klabel, labelsExist, head, khead, nhead, status);
            this.checkForSevereError(dssTable);
            Heclib.zinqir(dssTable, "TYPE", dataTypeName, dataTypeNumber);
            stringContainer tmp = new stringContainer();
            int[] prec = new int[1];
            Heclib.zinqir(dssTable, "PREC", tmp, prec);
            precision = prec[0];
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        if (HecPairedData.checkForSevereError()) {
            return -4;
        }
        this._storeDoubles = dataTypeNumber[0] == 205;
        if (status[0] == 0) {
            int i;
            numberOrdinates = nord[0];
            this._recordData.numberCurves = numberOfCurves[0];
            this._unitsX = unitsX.string;
            this._typeX = typeX.string;
            String cunitsX = unitsX.string;
            String cunitsY = unitsY.string;
            String ctypeX = typeX.string;
            String ctypeY = typeY.string;
            this._recordData.labelsUsed = labelsExist.value;
            if (this._recordData.labelsUsed) {
                this._recordData.curveLabels = new String[numberOfCurves[0]];
                for (int i2 = 0; i2 < numberOfCurves[0]; ++i2) {
                    this._recordData.curveLabels[i2] = this.clabel[i2] != null ? this.clabel[i2].trim() : "";
                }
            }
            this._recordData.horizontalAxis = ihoriz[0];
            this._recordData.unitsX = cunitsX;
            this._recordData.unitsY = cunitsY;
            this._recordData.typeX = ctypeX;
            this._recordData.typeY = ctypeY;
            this._recordData.containsData = true;
            this._recordData.dataSavedToDisk = true;
            this._recordData.precision = precision;
            this._recordData.storeDoubles = this._storeDoubles;
            this._recordData.recordType = dataTypeNumber[0];
            if (this._recordData.precision <= 0) {
                this._recordData.precision = -1;
            } else if (this._recordData.precision < 10 && this._recordData.precision > 0) {
                this._recordData.precision += this._recordData.precision * 10;
            }
            if (this._recordData.arraySize != numberOrdinates) {
                this._recordData.arrayX = null;
                this._recordData.arrayY = null;
            }
            this._recordData.arrayX = new double[numberOrdinates];
            this._recordData.arrayY = new double[numberOfCurves[0]][numberOrdinates];
            this._recordData.arraySize = numberOrdinates;
            for (i = 0; i < numberOrdinates; ++i) {
                this._recordData.arrayX[i] = values[i];
            }
            for (i = 0; i < numberOfCurves[0]; ++i) {
                for (int j = 0; j < numberOrdinates; ++j) {
                    this._recordData.arrayY[i][j] = values[numberOrdinates * (i + 1) + j];
                }
            }
            if (nhead[0] > 0) {
                String[] item = new String[4];
                String[] label = new String[]{"OFFSET", "SHIFT", "DATUM", "TRANSFORM"};
                int nitems = 4;
                int[] ipos = new int[]{0};
                int[] ierr = new int[]{0};
                boolean foundOne = false;
                Heclib.zustfh(label, item, nitems, ipos, head, nhead[0], ierr);
                this._recordData.ratingInfo = new double[4];
                for (int i3 = 0; i3 < 4; ++i3) {
                    double val = -3.4028234663852886E38;
                    if (item[i3] != null && item[i3].trim().length() > 0) {
                        foundOne = true;
                        String trimed = item[i3].trim();
                        if (i3 < 3) {
                            try {
                                val = Double.valueOf(trimed);
                            }
                            catch (Exception exception) {}
                        } else if (trimed.equalsIgnoreCase("LINLIN")) {
                            val = 1.0;
                        } else if (trimed.equalsIgnoreCase("LOGLOG")) {
                            val = 2.0;
                        }
                    }
                    this._recordData.ratingInfo[i3] = val;
                }
                if (!foundOne) {
                    int len = nhead[0] * 4;
                    this._recordData.supplementalInfo = Heclib.holString(head, len);
                }
            }
            this._dirty = false;
        }
        if (status[0] != 0) {
            return -1;
        }
        return numberOrdinates;
    }

    public int write(double[] xBuffer, double[] yBuffer, int numberOrdinates, boolean writeToDisk) {
        this._recordData.arraySize = numberOrdinates;
        this._recordData.numberCurves = 1;
        this._recordData.arrayX = new double[numberOrdinates];
        this._recordData.arrayY = new double[1][numberOrdinates];
        for (int i = 0; i < numberOrdinates; ++i) {
            this._recordData.arrayX[i] = xBuffer[i];
            this._recordData.arrayY[0][i] = yBuffer[i];
        }
        this._recordData.precision = 0;
        int status = this.storeData(writeToDisk);
        return status;
    }

    public int write(HecDoubleArray xBuffer, HecDoubleArray yBuffer, boolean writeToDisk) {
        this._recordData.arraySize = xBuffer.numberElements();
        this._recordData.numberCurves = 1;
        this._recordData.arrayX = new double[this._recordData.arraySize];
        this._recordData.arrayY = new double[1][this._recordData.arraySize];
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            this._recordData.arrayX[i] = xBuffer.element(i).value();
            this._recordData.arrayY[0][i] = yBuffer.element(i).value();
        }
        int precision = 0;
        int prec = xBuffer.precision();
        if (prec >= 0) {
            if (prec == 0) {
                prec = 1;
            }
            precision = prec * 10;
        }
        if ((prec = yBuffer.precision()) >= 0) {
            if (prec == 0) {
                prec = 1;
            }
            precision += prec;
        }
        this._recordData.precision = precision;
        int status = this.storeData(writeToDisk);
        return status;
    }

    public int write(double[] xBuffer, double[][] yBuffer, int numberOrdinates, int numberCurves, boolean writeToDisk) {
        this._recordData.arraySize = numberOrdinates;
        this._recordData.numberCurves = numberCurves;
        this._recordData.arrayX = new double[numberOrdinates];
        this._recordData.arrayY = new double[this._recordData.numberCurves][numberOrdinates];
        for (int i = 0; i < numberOrdinates; ++i) {
            this._recordData.arrayX[i] = xBuffer[i];
            for (int j = 0; j < this._recordData.numberCurves; ++j) {
                this._recordData.arrayY[j][i] = yBuffer[j][i];
            }
        }
        this._recordData.precision = 0;
        int status = this.storeData(writeToDisk);
        return status;
    }

    public int write(double[] xBuffer, Vector yBuffer, int numberOrdinates, boolean writeToDisk) {
        this._recordData.arraySize = numberOrdinates;
        this._recordData.numberCurves = yBuffer.size();
        this._recordData.arrayX = new double[numberOrdinates];
        this._recordData.arrayY = new double[this._recordData.numberCurves][numberOrdinates];
        for (int i = 0; i < numberOrdinates; ++i) {
            this._recordData.arrayX[i] = xBuffer[i];
            for (int j = 0; j < this._recordData.numberCurves; ++j) {
                this._recordData.arrayY[j][i] = ((double[])yBuffer.elementAt(j))[i];
            }
        }
        this._recordData.precision = 0;
        int status = this.storeData(writeToDisk);
        return status;
    }

    public int write(HecDoubleArray xBuffer, Vector yBuffer, boolean writeToDisk) {
        this._recordData.arraySize = xBuffer.numberElements();
        this._recordData.numberCurves = yBuffer.size();
        this._recordData.arrayX = new double[this._recordData.arraySize];
        this._recordData.arrayY = new double[this._recordData.numberCurves][this._recordData.arraySize];
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            this._recordData.arrayX[i] = xBuffer.element(i).value();
            for (int j = 0; j < this._recordData.numberCurves; ++j) {
                this._recordData.arrayY[j][i] = ((HecDoubleArray)yBuffer.elementAt(j)).element(i).value();
            }
        }
        int precision = 0;
        int prec = xBuffer.precision();
        if (prec >= 0) {
            if (prec == 0) {
                prec = 1;
            }
            precision = prec * 10;
        }
        if ((prec = ((HecDoubleArray)yBuffer.elementAt(0)).precision()) >= 0) {
            if (prec == 0) {
                prec = 1;
            }
            precision += prec;
        }
        this._recordData.precision = precision;
        int status = this.storeData(writeToDisk);
        return status;
    }

    public int write(PairedDataContainer pairedDataContainer) {
        int stat;
        this._recordData.plan = pairedDataContainer.writeMethod;
        if (!(pairedDataContainer.fileName != null && pairedDataContainer.fileName.length() != 0 || this.fileOpened() || (stat = this.open()) == 0)) {
            return stat;
        }
        if (pairedDataContainer instanceof VerticalDatum) {
            PairedDataContainer clone = new PairedDataContainer();
            pairedDataContainer.clone(clone);
            try {
                clone.insertVerticalDatum(((VerticalDatum)pairedDataContainer).getVerticalDatumContainer());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.write(clone);
        }
        if (this.getDssFileVersion() == 7) {
            if (pairedDataContainer.datum != -3.4028234663852886E38 || pairedDataContainer.shift != -3.4028234663852886E38 || pairedDataContainer.offset != -3.4028234663852886E38 || pairedDataContainer.transformType != Integer.MIN_VALUE) {
                PairedDataContainer clone = new PairedDataContainer();
                pairedDataContainer.clone(clone);
                HashMap<String, String> si = clone.getSupplementalInfo();
                if (pairedDataContainer.datum != -3.4028234663852886E38) {
                    si.put("datum", Double.toString(pairedDataContainer.datum));
                }
                if (pairedDataContainer.shift != -3.4028234663852886E38) {
                    si.put("shift", Double.toString(pairedDataContainer.shift));
                }
                if (pairedDataContainer.offset != -3.4028234663852886E38) {
                    si.put("offset", Double.toString(pairedDataContainer.offset));
                }
                switch (pairedDataContainer.transformType) {
                    case 1: {
                        si.put("transformType", "LINLIN");
                        break;
                    }
                    case 2: {
                        si.put("transformType", "LOGLOG");
                    }
                }
                clone.datum = -3.4028234663852886E38;
                clone.shift = -3.4028234663852886E38;
                clone.offset = -3.4028234663852886E38;
                clone.transformType = Integer.MIN_VALUE;
                clone.setSupplementalInfo(si);
                return this.write(clone);
            }
            intContainer lockThreadToken = new intContainer();
            int[] dssTable = this._fileData.requestAccess(lockThreadToken);
            if (dssTable == null) {
                return -3;
            }
            int status = Heclib.zpdStore(dssTable, pairedDataContainer);
            this.checkForSevereError(dssTable);
            this._fileData.releaseAccess(lockThreadToken);
            if (HecPairedData.checkForSevereError()) {
                return -4;
            }
            return status;
        }
        int status = super.copyContainerToRecordData(pairedDataContainer);
        if (status < 0) {
            return status;
        }
        if (pairedDataContainer.writeMethod != 11) {
            int i;
            this._recordData.arraySize = pairedDataContainer.numberOrdinates;
            this._recordData.numberCurves = pairedDataContainer.numberCurves;
            this._recordData.arrayX = new double[this._recordData.arraySize];
            for (i = 0; i < this._recordData.arraySize; ++i) {
                this._recordData.arrayX[i] = pairedDataContainer.xOrdinates[i];
            }
            if (pairedDataContainer.writeMethod == 0) {
                if (pairedDataContainer.xOrdinates.length < pairedDataContainer.numberOrdinates) {
                    System.out.println("Number ordinates to write is more than number supplied");
                    System.out.println("Number to write " + pairedDataContainer.numberOrdinates + ",  number supplied: " + pairedDataContainer.xOrdinates.length);
                    return -10;
                }
                this._recordData.arrayY = new double[this._recordData.numberCurves][this._recordData.arraySize];
                for (i = 0; i < this._recordData.arraySize; ++i) {
                    for (int j = 0; j < this._recordData.numberCurves; ++j) {
                        this._recordData.arrayY[j][i] = pairedDataContainer.yOrdinates[j][i];
                    }
                }
                if (pairedDataContainer.labelsUsed) {
                    this._recordData.curveLabels = new String[pairedDataContainer.numberCurves];
                    this._recordData.labelsUsed = true;
                    for (i = 0; i < pairedDataContainer.numberCurves; ++i) {
                        this._recordData.curveLabels[i] = pairedDataContainer.labels[i];
                    }
                } else {
                    this._recordData.labelsUsed = false;
                }
            } else {
                this._recordData.labelsUsed = pairedDataContainer.labelsUsed;
                if (this._recordData.labelsUsed) {
                    this._recordData.curveLabels = new String[1];
                    this._recordData.curveLabels[0] = pairedDataContainer.labels[0];
                }
            }
            this._recordData.unitsX = pairedDataContainer.xunits;
            this._recordData.unitsY = pairedDataContainer.yunits;
            this._recordData.typeX = pairedDataContainer.xtype;
            this._recordData.typeY = pairedDataContainer.ytype;
            this._recordData.horizontalAxis = pairedDataContainer.switchXyAxis ? 2 : 1;
            this._recordData.precision = pairedDataContainer.xprecision <= -1 ? -1 : (pairedDataContainer.xprecision == 0 ? 10 + pairedDataContainer.yprecision : pairedDataContainer.xprecision * 10 + pairedDataContainer.yprecision);
            if (pairedDataContainer.datum != -3.4028234663852886E38 || pairedDataContainer.transformType != Integer.MIN_VALUE) {
                this._recordData.ratingInfo = new double[4];
                this._recordData.ratingInfo[0] = pairedDataContainer.offset;
                this._recordData.ratingInfo[1] = pairedDataContainer.shift;
                this._recordData.ratingInfo[2] = pairedDataContainer.datum;
                this._recordData.ratingInfo[3] = pairedDataContainer.transformType;
            } else {
                this._recordData.ratingInfo = null;
            }
        } else {
            this._recordData.arraySize = pairedDataContainer.numberOrdinates;
            this._recordData.numberCurves = pairedDataContainer.numberCurves;
            this._recordData.arrayY = new double[1][this._recordData.arraySize];
            for (int i = 0; i < this._recordData.arraySize; ++i) {
                this._recordData.arrayY[0][i] = pairedDataContainer.yOrdinates[0][i];
            }
            this._recordData.labelsUsed = pairedDataContainer.labelsUsed;
            if (this._recordData.labelsUsed) {
                this._recordData.curveLabels = new String[1];
                this._recordData.curveLabels[0] = pairedDataContainer.labels[0];
            }
        }
        this._recordData.storeDoubles = this._storeDoubles = pairedDataContainer.storedAsdoubles;
        status = this.storeData(true);
        return status;
    }

    public int saveDataToDisk() {
        return this.storeData(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int storeData(boolean writeToDisk) {
        if (this._dssPathname.dirty() || this.dirty()) {
            this.recordType();
        }
        int[] istat = new int[1];
        if (writeToDisk) {
            intContainer lockThreadToken;
            int i;
            int[] dssTable;
            Object[] buff;
            String[] labels;
            boolean labelsUsed = false;
            int headMax = 200;
            float[] head = new float[headMax];
            int[] nhead = new int[]{0};
            int iplan = this._recordData.plan;
            if (this._recordData.curveLabels != null && this._recordData.labelsUsed) {
                labels = this._recordData.curveLabels;
                labelsUsed = true;
            } else {
                labels = new String[1];
                labelsUsed = false;
            }
            if (this._recordData.precision > 0) {
                if (this._recordData.precision < 10) {
                    this._recordData.precision += this._recordData.precision * 10;
                }
                HecPairedData.zset("PREC", "", this._recordData.precision);
            }
            if (this._recordData.ratingInfo != null) {
                int[] ierr = new int[1];
                String[] item = new String[4];
                String[] label = new String[4];
                int nitems = 0;
                if (this._recordData.ratingInfo[0] != -3.4028234663852886E38) {
                    item[nitems] = new Double(this._recordData.ratingInfo[0]).toString();
                    label[nitems] = "OFFSET";
                    ++nitems;
                }
                if (this._recordData.ratingInfo[1] != -3.4028234663852886E38) {
                    item[nitems] = new Double(this._recordData.ratingInfo[1]).toString();
                    label[nitems] = "SHIFT";
                    ++nitems;
                }
                if (this._recordData.ratingInfo[2] != -3.4028234663852886E38) {
                    item[nitems] = new Double(this._recordData.ratingInfo[2]).toString();
                    label[nitems] = "DATUM";
                    ++nitems;
                }
                if (this._recordData.ratingInfo[3] == 1.0) {
                    item[nitems] = "LINLIN";
                    label[nitems] = "TRANSFORM";
                    ++nitems;
                } else if (this._recordData.ratingInfo[3] == 2.0) {
                    item[nitems] = "LOGLOG";
                    label[nitems] = "TRANSFORM";
                    ++nitems;
                }
                if (nitems > 0) {
                    Heclib.zstfh(label, item, nitems, head, headMax, nhead, ierr);
                }
            } else if (this._recordData.supplementalInfo != null) {
                for (int k = 0; k < headMax; ++k) {
                    head[k] = 0.0f;
                }
                int len = this._recordData.supplementalInfo.length();
                if (len > 0) {
                    int len2 = headMax * 4;
                    if (len > len2) {
                        len = len2;
                    }
                    Heclib.StringHol(this._recordData.supplementalInfo, len, head);
                    nhead[0] = (len - 1) / 4 + 1;
                }
            }
            if (!this._storeDoubles) {
                intContainer lockThreadToken2;
                int i2;
                if (iplan == 0) {
                    buff = new float[this._recordData.arraySize * (this._recordData.numberCurves + 1)];
                    for (i2 = 0; i2 < this._recordData.arraySize; ++i2) {
                        buff[i2] = (float)this._recordData.arrayX[i2];
                    }
                    for (i2 = 0; i2 < this._recordData.numberCurves; ++i2) {
                        for (int j = 0; j < this._recordData.arraySize; ++j) {
                            buff[this._recordData.arraySize + i2 * this._recordData.arraySize + j] = (float)this._recordData.arrayY[i2][j];
                        }
                    }
                } else if (iplan == 10) {
                    buff = new float[this._recordData.arraySize];
                    for (i2 = 0; i2 < this._recordData.arraySize; ++i2) {
                        buff[i2] = (float)this._recordData.arrayX[i2];
                    }
                } else {
                    buff = new float[this._recordData.arraySize];
                    for (i2 = 0; i2 < this._recordData.arraySize; ++i2) {
                        buff[i2] = (float)this._recordData.arrayY[0][i2];
                    }
                }
                if ((dssTable = this._fileData.requestAccess(lockThreadToken2 = new intContainer())) == null) {
                    return -3;
                }
                try {
                    Heclib.zspd(dssTable, this._dssPathname.pathname(), this._recordData.arraySize, this._recordData.numberCurves, this._recordData.horizontalAxis, this._recordData.unitsX, this._recordData.typeX, this._recordData.unitsY, this._recordData.typeY, buff, labels, labelsUsed, head, nhead[0], iplan, istat);
                    this.checkForSevereError(dssTable);
                }
                finally {
                    this._fileData.releaseAccess(lockThreadToken2);
                }
            }
            if (iplan == 0) {
                buff = new double[this._recordData.arraySize * (this._recordData.numberCurves + 1)];
                for (i = 0; i < this._recordData.arraySize; ++i) {
                    buff[i] = (float)this._recordData.arrayX[i];
                }
                for (i = 0; i < this._recordData.numberCurves; ++i) {
                    for (int j = 0; j < this._recordData.arraySize; ++j) {
                        buff[this._recordData.arraySize + i * this._recordData.arraySize + j] = (float)this._recordData.arrayY[i][j];
                    }
                }
            } else if (iplan == 10) {
                buff = new double[this._recordData.arraySize];
                for (i = 0; i < this._recordData.arraySize; ++i) {
                    buff[i] = (float)this._recordData.arrayX[i];
                }
            } else {
                buff = new double[this._recordData.arraySize];
                for (i = 0; i < this._recordData.arraySize; ++i) {
                    buff[i] = (float)this._recordData.arrayY[0][i];
                }
            }
            if ((dssTable = this._fileData.requestAccess(lockThreadToken = new intContainer())) == null) {
                return -3;
            }
            try {
                Heclib.zspdd(dssTable, this._dssPathname.pathname(), this._recordData.arraySize, this._recordData.numberCurves, this._recordData.horizontalAxis, this._recordData.unitsX, this._recordData.typeX, this._recordData.unitsY, this._recordData.typeY, buff, labels, labelsUsed, head, nhead[0], iplan, istat);
                this.checkForSevereError(dssTable);
            }
            finally {
                this._fileData.releaseAccess(lockThreadToken);
            }
            if (HecPairedData.checkForSevereError()) {
                return -4;
            }
            this._checkedNumber = 0;
            if (istat[0] > 0) {
                return -3;
            }
            this._recordData.dataSavedToDisk = true;
        } else {
            this._recordData.dataSavedToDisk = false;
            istat[0] = 0;
        }
        if (istat[0] != 0) {
            System.out.println("Cannot Store Data for Record: " + this._dssPathname.pathname());
        }
        return istat[0];
    }

    public boolean checkRead() {
        HecDoubleArray x = new HecDoubleArray();
        HecDoubleArray y = new HecDoubleArray();
        if (!this._recordData.containsData) {
            this.read(x, y);
        }
        return this._recordData.containsData && this._recordData.arraySize > 0;
    }

    public String label() {
        if (this._recordData.curveLabels != null && this._recordData.labelsUsed) {
            return this._recordData.curveLabels[0];
        }
        return null;
    }

    public Vector labels() {
        Vector<String> curveLabels = new Vector<String>();
        if (this._recordData.curveLabels != null && this._recordData.labelsUsed) {
            int size;
            int number = this.numberOfCurves();
            if (number > (size = this._recordData.curveLabels.length)) {
                number = size;
            }
            for (int i = 0; i < number; ++i) {
                curveLabels.addElement(this._recordData.curveLabels[i]);
            }
        }
        return curveLabels;
    }

    public int setLabel(String label) {
        int labelSize = Math.max(1, this._recordData.numberCurves);
        this._recordData.curveLabels = new String[labelSize];
        this._recordData.curveLabels[0] = label;
        this._recordData.labelsUsed = true;
        return 0;
    }

    public void setLabels(Vector labels) {
        int labelSize = Math.max(labels.size(), this._recordData.numberCurves);
        this._recordData.curveLabels = new String[labelSize];
        this._recordData.labelsUsed = true;
        for (int i = 0; i < labelSize; ++i) {
            this._recordData.curveLabels[i] = i < labels.size() ? (String)labels.elementAt(i) : "            ";
        }
    }
}

