/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecDSSRecordInfo;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.dss.HecTimeSeriesMath;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecDoubleArray;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.heclib.util.Heclib;
import hec.heclib.util.doubleArrayContainer;
import hec.heclib.util.doubleContainer;
import hec.heclib.util.intArrayContainer;
import hec.heclib.util.intContainer;
import hec.heclib.util.stringContainer;
import hec.io.TimeSeriesCollectionContainer;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerVertDatum;
import hec.util.TextUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;

public class HecTimeSeries
extends HecTimeSeriesBase
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(HecTimeSeries.class.getName());
    int _retrieveUnitSystem = 0;
    private boolean _storeDoubles = true;
    private int readFlag = 0;
    private int _regularStorePlan = 3;
    private int _irregularInFlag = 1;
    protected TimeZone _timeZone = null;

    public HecTimeSeries() {
    }

    public HecTimeSeries(String DssFileName) {
        super(DssFileName);
    }

    public int ztsRetrieve(TimeSeriesContainer tsc, String pathname, HecTime startDateTime, HecTime endDateTime, boolean retrieveQualityAndNotes, int retrieveFlag) {
        if (!this.fileAccessible()) {
            this.open();
        }
        if (!this.fileAccessible()) {
            System.out.println("***   Unable to access DSS file   ***");
            System.out.println("DSS File name: " + this.DSSFileName());
            return -1;
        }
        String startDate = startDateTime.date(4);
        String startTime = startDateTime.hourMinutes();
        String endDate = endDateTime.date(4);
        String endTime = endDateTime.hourMinutes();
        tsc.fullName = pathname;
        if (tsc.fileName == null || tsc.fileName.length() < 2) {
            tsc.fileName = this._fileData.dssFilename();
        }
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        int status = Heclib.ztsRetrieve(dssTable, tsc, startDate, startTime, endDate, endTime, retrieveFlag);
        this._fileData.releaseAccess(lockThreadToken);
        if (status == 0) {
            if (tsc.times == null) {
                this.computeTimes(tsc);
            }
            if (tsc.values != null) {
                for (int i = 0; i < tsc.values.length; ++i) {
                    if (tsc.values[i] == -901.0) {
                        tsc.values[i] = -3.4028234663852886E38;
                    }
                    if (tsc.values[i] != -902.0) continue;
                    tsc.values[i] = -3.4028234663852886E38;
                }
            }
            if (tsc.otherInfo != null && tsc.otherInfo instanceof HecDSSRecordInfo) {
                this.getRecordInfo((HecDSSRecordInfo)tsc.otherInfo);
            }
        }
        return status;
    }

    protected void computeTimes(TimeSeriesContainer tsc) {
        block8: {
            int timeGranularitySeconds = tsc.timeGranularitySeconds;
            if (timeGranularitySeconds == 0) {
                timeGranularitySeconds = 60;
            }
            if (tsc.interval <= 0 || tsc.times != null) break block8;
            tsc.times = new int[tsc.numberValues];
            if (timeGranularitySeconds == 1) {
                for (int i = 0; i < tsc.numberValues; ++i) {
                    tsc.times[i] = tsc.startTime + tsc.interval * i;
                }
            } else {
                int timeMultiplier = 86400 / timeGranularitySeconds;
                int startJulianDate = tsc.startTime / timeMultiplier;
                int startTimeSeconds = tsc.startTime - startJulianDate * timeMultiplier;
                int minutesSinceMidnight = startTimeSeconds / 60;
                HecTime htime = new HecTime();
                htime.setJulian(startJulianDate += tsc.julianBaseDate, minutesSinceMidnight);
                if (tsc.interval <= 1440) {
                    for (int i = 0; i < tsc.numberValues; ++i) {
                        tsc.times[i] = htime.value();
                        htime.addMinutes(tsc.interval);
                    }
                } else {
                    int[] julian = new int[1];
                    int[] minutes = new int[1];
                    int[] offset = new int[1];
                    julian[0] = htime.julian();
                    minutes[0] = htime.minutesSinceMidnight();
                    offset[0] = this._recordData.timeOffset;
                    int[] jul = new int[1];
                    int[] min = new int[1];
                    for (int i = 0; i < tsc.numberValues; ++i) {
                        HecTime.inctim(tsc.interval, i, julian[0], minutes[0], jul, min);
                        tsc.times[i] = jul[0] * 1440 + min[0];
                    }
                }
            }
        }
    }

    public int ztsStore(TimeSeriesContainer tsc) {
        int interval;
        DSSPathname path;
        String ePart;
        int storageFlag = this._regularStorePlan;
        if (tsc.interval == 0 && ((ePart = (path = new DSSPathname(tsc.fullName)).ePart()) != null || ePart.length() > 3) && (interval = this.getInterval(ePart)) <= 0) {
            storageFlag = this._irregularInFlag;
        }
        return this.ztsStore(tsc, storageFlag);
    }

    public int ztsStore(TimeSeriesContainer tsc, int storageFlag) {
        int stat;
        if (!this.fileOpened() && (stat = this.open()) != 0) {
            return stat;
        }
        if (!this.fileAccessible()) {
            System.out.println("***   Unable to access DSS file   ***");
            System.out.println("DSS File name: " + this.DSSFileName());
            return -1;
        }
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        int status = Heclib.ztsStore(dssTable, tsc.collapseVerticalDatum(), storageFlag);
        this._fileData.releaseAccess(lockThreadToken);
        return status;
    }

    public static Vector<TimeSeriesContainer> expandProfileContainer(TimeSeriesContainer profileContainer) {
        Vector<TimeSeriesContainer> containers = new Vector<TimeSeriesContainer>();
        if (!profileContainer.hasValidProfileData()) {
            return containers;
        }
        double[][] profileValues = profileContainer.profileValues;
        profileContainer.profileValues = null;
        DSSPathname path = new DSSPathname(profileContainer.fullName);
        String origF = path.fPart();
        for (int i = 0; i < profileContainer.numberDepths; ++i) {
            TimeSeriesContainer tsc = new TimeSeriesContainer();
            profileContainer.clone(tsc);
            tsc.profileValues = null;
            tsc.values = new double[tsc.numberValues];
            for (int k = 0; k < tsc.numberValues; ++k) {
                tsc.values[k] = profileValues[k][i];
            }
            HecDouble d = new HecDouble(profileContainer.profileDepths[i]);
            tsc.profileLabel = d + " " + profileContainer.unitsProfileDepths;
            path.setFPart(origF + " " + tsc.profileLabel);
            tsc.fullName = path.getPathname();
            tsc.units = profileContainer.getProfileValuesUnits();
            tsc.type = profileContainer.getType();
            tsc.interval = -1;
            containers.add(tsc);
        }
        profileContainer.profileValues = profileValues;
        profileValues = null;
        return containers;
    }

    public static TimeSeriesContainer contractProfileContainer(Vector<TimeSeriesContainer> containers) {
        TimeSeriesContainer profileContainer = new TimeSeriesContainer();
        containers.get(0).clone(profileContainer);
        profileContainer.profileValues = new double[profileContainer.numberValues][profileContainer.numberDepths];
        profileContainer.values = null;
        for (int i = 0; i < profileContainer.numberDepths; ++i) {
            TimeSeriesContainer tsc = containers.get(i);
            for (int k = 0; k < profileContainer.numberValues; ++k) {
                profileContainer.profileValues[k][i] = tsc.values[k];
            }
        }
        return profileContainer;
    }

    public void setRetrieveAllTimes(boolean retrieveAllTimes) {
        this._retrieveAllTimes = retrieveAllTimes;
    }

    public void setRegularIntervalStorePlan(int regularStorePlan) {
        this._regularStorePlan = regularStorePlan;
    }

    public void setIrregularIntervalInFlag(int inFlag) {
        this._irregularInFlag = inFlag;
    }

    public void setStoreDoubles(boolean storeDoubles) {
        this._storeDoubles = storeDoubles;
    }

    public boolean getStoreDoubles() {
        return this._storeDoubles;
    }

    public String getSupplementalInfo() {
        return this._recordData.supplementalInfo;
    }

    public int read() {
        return this.retrieveData(this._retrieveUnitSystem);
    }

    public void setReadPreviousSubsquent(boolean readPrevious, boolean readSubsequent) {
        this.readFlag = readPrevious ? 1 : 0;
        if (readSubsequent) {
            this.readFlag += 2;
        }
    }

    public int getData(doubleArrayContainer values) {
        if (!this._recordData.containsData || this._dirty) {
            this.read();
        }
        values.setSize(this._recordData.arraySize);
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            values.array[i] = this._recordData.arrayX[i];
        }
        return this._recordData.arraySize;
    }

    public int getData(HecDoubleArray values) {
        if (!this._recordData.containsData || this._dirty) {
            this.read();
        }
        values.setSize(this._recordData.arraySize);
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            values.set(i, this._recordData.arrayX[i]);
        }
        values.setPrecision(this._recordData.precision);
        return this._recordData.arraySize;
    }

    public int getTimes(intArrayContainer timesAsInts) {
        block5: {
            if (!this._recordData.containsData || this._dirty) {
                this.read();
            }
            timesAsInts.setSize(this._recordData.arraySize);
            if (this._recordData.arraySize <= 0) break block5;
            if (this._recordData.times != null && this._recordData.times.length == this._recordData.arraySize) {
                for (int i = 0; i < this._recordData.arraySize; ++i) {
                    timesAsInts.array[i] = this._recordData.times[i];
                }
            } else {
                int interval = this.interval();
                int[] julian = new int[1];
                int[] minutes = new int[1];
                int[] offset = new int[1];
                HecTime hecTime = new HecTime();
                hecTime.setMinutes(this._recordData.startTime);
                julian[0] = hecTime.julian();
                minutes[0] = hecTime.minutesSinceMidnight();
                offset[0] = this._recordData.timeOffset;
                Heclib.zofset(julian, minutes, interval, 2, offset);
                int[] jul = new int[1];
                int[] min = new int[1];
                for (int i = 0; i < this._recordData.arraySize; ++i) {
                    HecTime.inctim(interval, i, julian[0], minutes[0], jul, min);
                    timesAsInts.array[i] = jul[0] * 1440 + min[0];
                }
            }
        }
        return this._recordData.arraySize;
    }

    public int getTimes(HecTimeArray timeArray) {
        if (!this._recordData.containsData || this._dirty) {
            this.read();
        }
        timeArray.setSize(this._recordData.arraySize);
        if (this._recordData.arraySize > 0) {
            if (this._recordData.times != null && this._recordData.times.length == this._recordData.arraySize) {
                for (int i = 0; i < this._recordData.arraySize; ++i) {
                    timeArray.elementAt(i).setMinutes(this._recordData.times[i]);
                }
            } else {
                this._recordData.times = new int[this._recordData.arraySize];
                int interval = this.interval();
                int[] julian = new int[1];
                int[] minutes = new int[1];
                int[] offset = new int[1];
                HecTime hecTime = new HecTime();
                hecTime.setMinutes(this._recordData.startTime);
                julian[0] = hecTime.julian();
                minutes[0] = hecTime.minutesSinceMidnight();
                offset[0] = this._recordData.timeOffset;
                Heclib.zofset(julian, minutes, interval, 2, offset);
                int[] jul = new int[1];
                int[] min = new int[1];
                for (int i = 0; i < this._recordData.arraySize; ++i) {
                    HecTime.inctim(interval, i, julian[0], minutes[0], jul, min);
                    timeArray.elementAt(i).setJulian(jul[0], min[0]);
                    this._recordData.times[i] = timeArray.element(i).value();
                }
            }
            timeArray.setTimeZone(this._timeZone);
        }
        return this._recordData.arraySize;
    }

    public int getFlags(intArrayContainer flags) {
        if (!this._recordData.containsData || this._dirty) {
            this.read();
        }
        if (this._recordData.flags == null) {
            flags.setSize(0);
            return 0;
        }
        flags.setSize(this._recordData.flags.length);
        for (int i = 0; i < this._recordData.flags.length; ++i) {
            flags.array[i] = this._recordData.flags[i];
        }
        return this._recordData.flags.length;
    }

    public int read(doubleArrayContainer values) {
        int number = this.read();
        this.getData(values);
        return number;
    }

    public int read(doubleArrayContainer values, int unitSystem) {
        this._retrieveUnitSystem = unitSystem;
        int number = this.read();
        this.getData(values);
        return number;
    }

    public int read(HecTimeArray timeArray, doubleArrayContainer values) {
        int number = this.read();
        this.getData(values);
        this.getTimes(timeArray);
        return number;
    }

    public int read(HecTimeArray timeArray, doubleArrayContainer values, int unitSystem) {
        this._retrieveUnitSystem = unitSystem;
        int number = this.read();
        this.getData(values);
        this.getTimes(timeArray);
        return number;
    }

    public int read(HecTimeArray timeArray, HecDoubleArray values) {
        int number = this.read();
        this.getData(values);
        this.getTimes(timeArray);
        return number;
    }

    public int read(HecDoubleArray values) {
        int number = this.read();
        this.getData(values);
        return number;
    }

    public int read(HecTimeArray timeArray, HecDoubleArray values, int unitSystem) {
        this._retrieveUnitSystem = unitSystem;
        int number = this.read();
        this.getData(values);
        this.getTimes(timeArray);
        return number;
    }

    public int read(intArrayContainer timeArray, doubleArrayContainer values) {
        int number = this.read();
        this.getData(values);
        this.getTimes(timeArray);
        return number;
    }

    public int read(intArrayContainer timeArray, doubleArrayContainer values, int unitSystem) {
        this._retrieveUnitSystem = unitSystem;
        int number = this.read();
        this.getData(values);
        this.getTimes(timeArray);
        return number;
    }

    public int read(TimeSeriesContainer timeSeriesContainer, boolean removeMissing) {
        int success;
        int status = 0;
        if (timeSeriesContainer.fullName != null && timeSeriesContainer.fullName.length() > 7) {
            this.setPathname(timeSeriesContainer.fullName);
            if (timeSeriesContainer.fileName != null && timeSeriesContainer.fileName.length() > 0) {
                this.setDSSFileName(timeSeriesContainer.fileName, true);
            }
            if (timeSeriesContainer.getStartTime().isDefined() && timeSeriesContainer.getEndTime().isDefined()) {
                this.setTimeWindow(timeSeriesContainer.getStartTime(), timeSeriesContainer.getEndTime());
            } else if (timeSeriesContainer.startTime != 0 && timeSeriesContainer.endTime != 0) {
                HecTime start = new HecTime();
                start.set(timeSeriesContainer.startTime);
                HecTime end = new HecTime();
                end.set(timeSeriesContainer.endTime);
                this.setTimeWindow(start, end);
            }
        }
        HecTime originalStartTime = new HecTime(this.startTime());
        HecTime originalEndTime = new HecTime(this.endTime());
        boolean observerTimeZone = false;
        String requestedTimeZoneID = timeSeriesContainer.timeZoneID;
        if (timeSeriesContainer.timeZoneID != null && timeSeriesContainer.timeZoneID.length() > 2 && originalStartTime.isDefined() && originalEndTime.isDefined()) {
            observerTimeZone = true;
            HecTime newStartTime = new HecTime(originalStartTime);
            newStartTime.subtractHours(12);
            this.setStartTime(newStartTime);
            HecTime newEndTime = new HecTime(originalEndTime);
            newEndTime.addHours(12);
            this.setEndTime(newEndTime);
        }
        if (this._retrieveAllTimes) {
            timeSeriesContainer.retrieveAllTimes = true;
        }
        int retrieveFlag = this.readFlag;
        if (removeMissing) {
            retrieveFlag = -1;
        }
        timeSeriesContainer.timeZoneID = null;
        timeSeriesContainer.timeZoneRawOffset = 0;
        status = this.ztsRetrieve(timeSeriesContainer, this.pathname(), this.startTime(), this.endTime(), true, retrieveFlag);
        if (status == -1) {
            return -2;
        }
        if (status != 0) {
            return status;
        }
        timeSeriesContainer.units = timeSeriesContainer.units.trim();
        if (timeSeriesContainer.otherInfo instanceof HecDSSRecordInfo) {
            this.getRecordInfo((HecDSSRecordInfo)timeSeriesContainer.otherInfo);
        }
        if (timeSeriesContainer.times == null) {
            intArrayContainer timeOfData = new intArrayContainer();
            this.getTimes(timeOfData);
            timeSeriesContainer.times = timeOfData.array;
        }
        timeSeriesContainer.subLocation = "";
        timeSeriesContainer.parameter = this.cPart();
        timeSeriesContainer.subParameter = "";
        if (timeSeriesContainer.timeZoneID != null) {
            this._timeZone = TimeZone.getTimeZone(timeSeriesContainer.timeZoneID);
            timeSeriesContainer.timeZoneRawOffset = this._timeZone.getRawOffset();
        } else {
            this._timeZone = null;
        }
        if (timeSeriesContainer instanceof TimeSeriesContainerVertDatum) {
            TimeSeriesContainerVertDatum tscvd = (TimeSeriesContainerVertDatum)timeSeriesContainer;
            HashMap<String, String> si = tscvd.getSupplementalInfo();
            if (si.containsKey("verticalDatumInfo")) {
                String compressed = si.get("verticalDatumInfo");
                try {
                    String xml = TextUtil.uncompress(compressed, "base64");
                    tscvd.setVerticalDatumContainer(new VerticalDatumContainer(xml));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                si.remove("verticalDatumInfo");
                if (si.containsKey("verticalDatum")) {
                    String currentVerticalDatum = si.get("verticalDatum");
                    try {
                        tscvd.forceVerticalDatum(currentVerticalDatum);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    si.remove("verticalDatum");
                }
            }
            tscvd.setSupplementalInfo(si);
        }
        if (timeSeriesContainer.timeGranularitySeconds == 0) {
            timeSeriesContainer.timeGranularitySeconds = 60;
        }
        if (observerTimeZone && (success = this.applyObserverTimeZone(timeSeriesContainer, requestedTimeZoneID, originalStartTime, originalEndTime)) != 0) {
            return success;
        }
        timeSeriesContainer = timeSeriesContainer.expandVerticalDatum();
        return 0;
    }

    int applyObserverTimeZone(TimeSeriesContainer timeSeriesContainer, String requestedTimeZoneID, HecTime originalStartTime, HecTime originalEndTime) {
        String timeZoneId = timeSeriesContainer.getTimeZoneID();
        if (timeZoneId != null && !timeZoneId.isBlank()) {
            TimeZone tz = TimeZone.getTimeZone(timeZoneId);
            originalStartTime = HecTime.convertToTimeZone(originalStartTime, TimeZone.getTimeZone(requestedTimeZoneID), tz);
            originalEndTime = HecTime.convertToTimeZone(originalEndTime, TimeZone.getTimeZone(requestedTimeZoneID), tz);
        }
        int first = -1;
        HecTimeArray timeArray = timeSeriesContainer.getTimes();
        for (int i = 0; i < timeArray.numberElements(); ++i) {
            if (!originalStartTime.lessThan(timeArray.element(i))) continue;
            first = i - 1;
            if (first >= 0) break;
            first = 0;
            break;
        }
        int last = -1;
        for (int i = timeArray.numberElements() - 1; i >= 0; --i) {
            if (!originalEndTime.greaterThan(timeArray.element(i))) continue;
            last = i + 1;
            if (last != timeArray.numberElements()) break;
            --last;
            break;
        }
        if (first == -1) {
            return -2;
        }
        int size = last - first + 1;
        if (size <= 0) {
            return -2;
        }
        timeSeriesContainer.times = Arrays.copyOfRange(timeSeriesContainer.times, first, last + 1);
        timeSeriesContainer.setValues(Arrays.copyOfRange(timeSeriesContainer.getValues(), first, last + 1));
        if (timeSeriesContainer.getQuality() != null) {
            timeSeriesContainer.setQuality(Arrays.copyOfRange(timeSeriesContainer.getQuality(), first, last + 1));
        }
        originalStartTime.set(timeSeriesContainer.times[0]);
        originalEndTime.set(timeSeriesContainer.times[timeSeriesContainer.times.length - 1]);
        timeSeriesContainer.setStartTime(originalStartTime);
        timeSeriesContainer.setEndTime(originalEndTime);
        return 0;
    }

    public int read(TimeSeriesCollectionContainer timeSeriesCollectionContainer, boolean removeMissing) {
        return this.read(timeSeriesCollectionContainer, removeMissing, true);
    }

    public int read(TimeSeriesCollectionContainer timeSeriesCollectionContainer, boolean removeMissing, boolean getCollectionTimes) {
        String pathname;
        if (timeSeriesCollectionContainer.fullName != null && timeSeriesCollectionContainer.fullName.length() > 7) {
            this.setPathname(timeSeriesCollectionContainer.fullName);
            if (timeSeriesCollectionContainer.fileName != null && timeSeriesCollectionContainer.fileName.length() > 0) {
                this.setDSSFileName(timeSeriesCollectionContainer.fileName, true);
            }
        }
        if (!DSSPathname.isaCollectionPath(pathname = this.pathname())) {
            return -4;
        }
        String[] pathnameList = this.getCollectionList(pathname);
        if (pathnameList == null || pathnameList.length == 0) {
            return -3;
        }
        TimeSeriesContainer[] tscs = new TimeSeriesContainer[pathnameList.length];
        for (int i = 0; i < pathnameList.length; ++i) {
            this.clear();
            this.setPathname(pathnameList[i]);
            if (this._retrieveAllTimes) {
                HecTime undefined = new HecTime();
                undefined.setUndefined();
                this.setTimeWindow(undefined, undefined);
            }
            TimeSeriesContainer tsc = null;
            tsc = new TimeSeriesContainer();
            this.read(tsc, removeMissing);
            if (HecTimeSeries.checkForSevereError()) {
                return -10;
            }
            tscs[i] = tsc;
        }
        this.reset();
        this.setPathname(pathname);
        timeSeriesCollectionContainer.set(tscs);
        if (getCollectionTimes) {
            timeSeriesCollectionContainer.getTimes();
        }
        return 0;
    }

    public synchronized void setData(double[] values, int numberToWrite) {
        if (values == null) {
            this._recordData.arrayX = null;
            this._recordData.arraySize = 0;
            return;
        }
        this._recordData.arraySize = numberToWrite;
        this._recordData.arrayX = new double[this._recordData.arraySize];
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            this._recordData.arrayX[i] = values[i];
        }
        this._recordData.containsData = true;
    }

    public void setData(double[] values) {
        this.setData(values, values.length);
    }

    public synchronized void setData(HecDoubleArray values) {
        if (values == null) {
            this._recordData.arrayX = null;
            this._recordData.arraySize = 0;
            return;
        }
        this._recordData.arraySize = values.numberElements();
        this._recordData.arrayX = new double[this._recordData.arraySize];
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            this._recordData.arrayX[i] = values.element(i).value();
        }
        this._recordData.containsData = true;
        this._recordData.precision = values.precision();
        if (this._recordData.precision == 0) {
            this._recordData.precision = 1;
        }
    }

    public synchronized int setTimes(int[] times) {
        return this.setTimes(times, times.length);
    }

    public synchronized int setTimes(int[] times, int ntimes) {
        if (times == null) {
            this._recordData.times = null;
            return 0;
        }
        if (this._recordData.arraySize == 0) {
            this._recordData.arraySize = ntimes;
        }
        if (this._recordData.arraySize > ntimes) {
            return -2;
        }
        this._recordData.times = new int[this._recordData.arraySize];
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            this._recordData.times[i] = times[i];
        }
        if (this.recordType() == 100) {
            this._startTime = new HecTime(times[0], 1);
            this._endTime.setUndefined();
        }
        return 0;
    }

    public synchronized int setTimes(HecTimeArray times) {
        if (times == null) {
            this._recordData.times = null;
            return 0;
        }
        if (this._recordData.arraySize == 0) {
            this._recordData.arraySize = times.numberElements();
        }
        if (this._recordData.arraySize > times.numberElements()) {
            return -2;
        }
        this.setTimeZone(times.getTimeZone());
        this._recordData.times = new int[this._recordData.arraySize];
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            this._recordData.times[i] = times.element(i).value();
        }
        if (this.recordType() == 100) {
            this._startTime = new HecTime(times.element(0));
            this._endTime.setUndefined();
        }
        return 0;
    }

    public synchronized int setFlags(int[] flags) {
        return this.setFlags(flags, flags.length);
    }

    public synchronized int setFlags(int[] flags, int nflags) {
        if (flags == null) {
            this._recordData.flags = null;
            return 0;
        }
        if (this._recordData.arraySize == 0) {
            this._recordData.arraySize = nflags;
        }
        if (this._recordData.arraySize > nflags) {
            return -2;
        }
        int number = nflags;
        if (flags.length > number) {
            number = flags.length;
        }
        if (this._recordData.arraySize > number) {
            number = this._recordData.arraySize;
        }
        this._recordData.flags = new int[number];
        int n = nflags;
        if (flags.length < n) {
            n = flags.length;
        }
        for (int i = 0; i < n; ++i) {
            this._recordData.flags[i] = flags[i];
        }
        return 0;
    }

    public int write() {
        return this.write(true);
    }

    public int write(boolean writeToDisk) {
        int status = this.prepareForWrite();
        if (status < 0) {
            return status;
        }
        if (writeToDisk) {
            status = this.flushToDisk();
        }
        return status;
    }

    public int write(double[] values, int numberToWrite, boolean writeToDisk) {
        this.setData(values, numberToWrite);
        return this.write(writeToDisk);
    }

    public int write(int[] times, double[] values, int numberToWrite, boolean writeToDisk) {
        this.setData(values, numberToWrite);
        int status = this.setTimes(times);
        if (status < 0) {
            return status;
        }
        return this.write(writeToDisk);
    }

    public int write(HecDoubleArray values, boolean writeToDisk) {
        this.setData(values);
        return this.write(writeToDisk);
    }

    public int write(HecTimeArray times, double[] values, boolean writeToDisk) {
        int status = this.setTimes(times);
        if (status < 0) {
            return status;
        }
        this.setData(values);
        return this.write(writeToDisk);
    }

    public int write(TimeSeriesContainer timeSeriesContainer) {
        int status;
        if (timeSeriesContainer.fileName == null || timeSeriesContainer.fileName.length() == 0) {
            int stat;
            if (!this.fileOpened() && (stat = this.open()) != 0) {
                return stat;
            }
        } else {
            status = this.setDSSFileName(timeSeriesContainer.fileName);
            if (status != 0) {
                return status;
            }
        }
        if (this.getDssFileVersion() == 7) {
            if (timeSeriesContainer.startTime != 0 && timeSeriesContainer.startHecTime != null && timeSeriesContainer.startHecTime.isDefined() && timeSeriesContainer.startTime != timeSeriesContainer.startHecTime.value()) {
                LOGGER.warning("The TimeSeriesContainer being saved has inconsistent startTime and startHecTime ");
            }
            return this.ztsStore(timeSeriesContainer);
        }
        if (timeSeriesContainer.profileDepths != null || timeSeriesContainer.profileValues != null) {
            System.out.println("Cannot store profile data in HEC-DSS Version 6.  You must access a version 7 file.");
            return -1;
        }
        status = super.copyContainerToRecordData(timeSeriesContainer);
        if (status < 0) {
            return status;
        }
        if (timeSeriesContainer.startTime != 0) {
            HecTime start = new HecTime();
            start.set(timeSeriesContainer.startTime);
            this.setStartTime(start);
            this._recordData.startTime = start.value();
        }
        if (timeSeriesContainer.endTime != 0) {
            HecTime end = new HecTime();
            end.set(timeSeriesContainer.endTime);
            this.setEndTime(end);
            this._recordData.endTime = end.value();
        }
        if ((status = this.setTimes(timeSeriesContainer.times, timeSeriesContainer.numberValues)) < 0) {
            return status;
        }
        this.setData(timeSeriesContainer.values, timeSeriesContainer.numberValues);
        if (timeSeriesContainer.quality != null) {
            this.setFlags(timeSeriesContainer.quality);
        }
        this.setUnits(timeSeriesContainer.units);
        this.setType(timeSeriesContainer.type);
        this.setPrecision(timeSeriesContainer.precision);
        this._storeDoubles = timeSeriesContainer.storedAsdoubles;
        if (timeSeriesContainer.timeZoneID != null) {
            this._timeZone = TimeZone.getTimeZone(timeSeriesContainer.timeZoneID);
            if (this._timeZone != null) {
                this._timeZone.setRawOffset(timeSeriesContainer.timeZoneRawOffset);
                if (!timeSeriesContainer.timeZoneID.equals(this._timeZone.getID())) {
                    this._timeZone.setID(timeSeriesContainer.timeZoneID);
                }
            }
        } else {
            this._timeZone = null;
        }
        if (timeSeriesContainer.xOrdinate != 0.0 && timeSeriesContainer.yOrdinate != 0.0 && timeSeriesContainer.zOrdinate != 0.0) {
            this._recordData.ordinates = new double[3];
            this._recordData.ordinates[0] = timeSeriesContainer.xOrdinate;
            this._recordData.ordinates[1] = timeSeriesContainer.yOrdinate;
            this._recordData.ordinates[2] = timeSeriesContainer.zOrdinate;
            this._recordData.ordinateDescription = new int[6];
            this._recordData.ordinateDescription[0] = timeSeriesContainer.coordinateSystem;
            this._recordData.ordinateDescription[1] = timeSeriesContainer.coordinateID;
            this._recordData.ordinateDescription[2] = timeSeriesContainer.horizontalUnits;
            this._recordData.ordinateDescription[3] = timeSeriesContainer.horizontalDatum;
            this._recordData.ordinateDescription[4] = timeSeriesContainer.verticalUnits;
            this._recordData.ordinateDescription[5] = timeSeriesContainer.verticalDatum;
        }
        if (timeSeriesContainer instanceof VerticalDatum) {
            try {
                String verticalDatumInfo = TextUtil.compress(((TimeSeriesContainerVertDatum)timeSeriesContainer).getVerticalDatumInfo(), "base64");
                if (this._recordData.supplementalInfo == null) {
                    this._recordData.supplementalInfo = "verticalDatumInfo:" + verticalDatumInfo + ";";
                } else {
                    int len = this._recordData.supplementalInfo.length();
                    if (len > 0 && this._recordData.supplementalInfo.charAt(len - 1) != ';') {
                        this._recordData.supplementalInfo = this._recordData.supplementalInfo + ";";
                    }
                    this._recordData.supplementalInfo = this._recordData.supplementalInfo + "verticalDatumInfo:" + verticalDatumInfo + ";";
                }
                String currentVerticalDatum = ((TimeSeriesContainerVertDatum)timeSeriesContainer).getCurrentVerticalDatum();
                this._recordData.supplementalInfo = this._recordData.supplementalInfo + "verticalDatum:" + currentVerticalDatum + ";";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        status = this.write(true);
        return status;
    }

    public int write(TimeSeriesCollectionContainer timeSeriesCollectionContainer) {
        if (timeSeriesCollectionContainer.fullName != null && timeSeriesCollectionContainer.fullName.length() > 7) {
            this.setPathname(timeSeriesCollectionContainer.fullName);
            if (timeSeriesCollectionContainer.fileName != null && timeSeriesCollectionContainer.fileName.length() > 0) {
                this.setDSSFileName(timeSeriesCollectionContainer.fileName, true);
            }
        }
        int status = 0;
        for (int i = 0; i < timeSeriesCollectionContainer.size(); ++i) {
            this.clear();
            TimeSeriesContainer tsc = timeSeriesCollectionContainer.get(i);
            status = this.write(tsc);
            if (status < -5) {
                return status;
            }
            if (!HecTimeSeries.checkForSevereError()) continue;
            return -10;
        }
        this.reset();
        return status;
    }

    public int saveDataToDisk() {
        if (!this._recordData.containsData) {
            return -1;
        }
        if (this._recordData.arrayX == null) {
            return -1;
        }
        return this.write(true);
    }

    public String DSSFileName(boolean useDefault) {
        String filename = "";
        filename = useDefault ? this.DSSFileName() : this._fileData.dssFilename();
        return filename;
    }

    public int timeWindowNumber() {
        int timeWindowNumber = this._interval > 0 ? (this.endTime().value() - this.startTime().value()) / this._interval + 1 : (_defaultInterval > 0 ? (this.endTime().value() - this.startTime().value()) / _defaultInterval + 1 : 0);
        return timeWindowNumber;
    }

    public static int removeLeadingTrailingMissing(HecTimeArray timeArray, HecDoubleArray arrayX) {
        int numberValid;
        int first = arrayX.firstDefined();
        if (first < 0) {
            timeArray.setSize(0);
            arrayX.setSize(0);
            return 0;
        }
        int last = arrayX.lastDefined();
        int length = arrayX.numberElements();
        if (length == (numberValid = last - first + 1)) {
            return numberValid;
        }
        timeArray.resize(numberValid, first, 0);
        arrayX.resize(numberValid, first, 0);
        return numberValid;
    }

    public static int getCoincidentTimes(List<TimeSeriesContainer> timeSeriesContainers) {
        TimeSeriesContainer tsc;
        int j;
        int i;
        if (timeSeriesContainers.size() < 2) {
            return -1;
        }
        for (int i2 = 0; i2 < timeSeriesContainers.size(); ++i2) {
            TimeSeriesContainer obj = timeSeriesContainers.get(i2);
            if (obj instanceof TimeSeriesContainer) continue;
            return -1;
        }
        int count = 0;
        TimeSeriesContainer prime = timeSeriesContainers.get(0);
        boolean[] found = new boolean[prime.times.length];
        for (i = 0; i < found.length; ++i) {
            found[i] = true;
        }
        for (int j2 = 1; j2 < timeSeriesContainers.size(); ++j2) {
            TimeSeriesContainer tsc2 = timeSeriesContainers.get(j2);
            for (int i3 = 0; i3 < prime.times.length; ++i3) {
                int time = prime.times[i3];
                int idx = HecTimeSeries.intIndex(tsc2.times, time);
                if (idx != -1) continue;
                found[i3] = false;
            }
        }
        for (i = 0; i < found.length; ++i) {
            if (!found[i]) continue;
            ++count;
        }
        if (count == 0) {
            return count;
        }
        if (count == prime.times.length) {
            boolean allSame = true;
            for (int j3 = 1; j3 < timeSeriesContainers.size(); ++j3) {
                TimeSeriesContainer tsc3 = timeSeriesContainers.get(j3);
                if (tsc3.times.length == count) continue;
                allSame = false;
            }
            if (allSame) {
                return count;
            }
        }
        int[][] ntimes = new int[timeSeriesContainers.size()][count];
        double[][] nvalues = new double[timeSeriesContainers.size()][count];
        int[][] nqual = new int[timeSeriesContainers.size()][count];
        int ncount = 0;
        for (int i4 = 0; i4 < found.length; ++i4) {
            if (!found[i4]) continue;
            ntimes[0][ncount] = prime.times[i4];
            nvalues[0][ncount] = prime.values[i4];
            if (prime.quality != null && prime.quality.length > 0) {
                nqual[0][ncount] = prime.quality[i4];
            }
            ++ncount;
        }
        for (j = 1; j < timeSeriesContainers.size(); ++j) {
            tsc = timeSeriesContainers.get(j);
            ncount = 0;
            for (int i5 = 0; i5 < found.length; ++i5) {
                int itime;
                int idx;
                if (!found[i5] || (idx = HecTimeSeries.intIndex(tsc.times, itime = prime.times[i5])) <= -1) continue;
                ntimes[j][ncount] = itime;
                nvalues[j][ncount] = tsc.values[idx];
                if (tsc.quality != null && tsc.quality.length > 0) {
                    nqual[j][ncount] = tsc.quality[idx];
                }
                ++ncount;
            }
        }
        for (j = 0; j < timeSeriesContainers.size(); ++j) {
            tsc = timeSeriesContainers.get(j);
            tsc.times = ntimes[j];
            tsc.values = nvalues[j];
            if (tsc.quality != null && tsc.quality.length > 0) {
                tsc.quality = nqual[j];
            }
            tsc.numberValues = count;
            tsc.startTime = tsc.times[0];
            tsc.endTime = tsc.times[count - 1];
        }
        return count;
    }

    protected static int intIndex(int[] intArray, int intValue) {
        for (int i = 0; i < intArray.length; ++i) {
            if (intArray[i] != intValue) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void status() {
        super.status();
        System.out.println("Array start time: " + this._arrayStartTime);
        System.out.println("Array end time:   " + this._arrayEndTime);
    }

    public int getStatistics(doubleContainer minimum, HecTime minimumTime, doubleContainer maximum, HecTime maximumTime, doubleContainer average, intContainer totalNumberValues, intContainer numberMissing) {
        minimum.value = -3.4028234663852886E38;
        maximum.value = -3.4028234663852886E38;
        average.value = 0.0;
        numberMissing.value = 0;
        if (this.dirty() || this._recordData == null) {
            doubleArrayContainer data = new doubleArrayContainer();
            int number = this.read(data);
            if (number <= -3) {
                if (this._recordData != null) {
                    numberMissing.value = this._recordData.arraySize;
                }
                return number;
            }
            if (this._recordData == null) {
                return -3;
            }
        }
        if (!this._recordData.containsData) {
            return -2;
        }
        totalNumberValues.value = this._recordData.arraySize;
        int maximumPosition = 0;
        int minimumPosition = 0;
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            if (this._recordData.arrayX[i] == -3.4028234663852886E38) continue;
            maximum.value = this._recordData.arrayX[i];
            minimum.value = this._recordData.arrayX[i];
            maximumPosition = i;
            minimumPosition = i;
            break;
        }
        if (maximum.value == -3.4028234663852886E38) {
            return -2;
        }
        double sum = 0.0;
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            if (this._recordData.arrayX[i] != -3.4028234663852886E38) {
                if (maximum.value < this._recordData.arrayX[i]) {
                    maximum.value = this._recordData.arrayX[i];
                    maximumPosition = i;
                }
                if (minimum.value > this._recordData.arrayX[i]) {
                    minimum.value = this._recordData.arrayX[i];
                    minimumPosition = i;
                }
                sum += this._recordData.arrayX[i];
                continue;
            }
            ++numberMissing.value;
        }
        average.value = sum / (double)(totalNumberValues.value - numberMissing.value);
        if (this._recordType == 100) {
            maximumTime.setMinutes(this._recordData.startTime);
            maximumTime.add(maximumPosition * this.interval());
            minimumTime.setMinutes(this._recordData.startTime);
            minimumTime.add(minimumPosition * this.interval());
        } else if (this._recordData.times != null) {
            minimumTime.setMinutes(this._recordData.times[0]);
            maximumTime.setMinutes(this._recordData.times[this._recordData.arraySize - 1]);
        } else {
            minimumTime.setUndefined();
            maximumTime.setUndefined();
        }
        return 0;
    }

    public double value(HecTime newTime, intContainer status) {
        if (this._fileData == null) {
            status.value = -3;
            return -3.4028234663852886E38;
        }
        if (!this.fileAccessible()) {
            this.open();
        }
        if (!this.fileAccessible()) {
            status.value = -3;
            return -3.4028234663852886E38;
        }
        doubleArrayContainer arrayX = new doubleArrayContainer();
        HecTimeArray times = new HecTimeArray();
        if (this._recordData == null) {
            this.resetArrayTime();
            int number = this.read(times, arrayX);
            if (number < 0) {
                status.value = -1;
                return -3.4028234663852886E38;
            }
        } else {
            this.getTimes(times);
            this.getData(arrayX);
        }
        if (newTime.lessThan(this._arrayStartTime)) {
            this.resetArrayTime();
        }
        if (newTime.lessThan(this._arrayStartTime)) {
            status.value = -1;
            return -3.4028234663852886E38;
        }
        int interval = 0;
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            if (!times.element(i).greaterThanEqualTo(newTime)) continue;
            interval = times.element(i).value() - times.element(i - 1).value();
            break;
        }
        if (interval == 0) {
            status.value = -1;
            return -3.4028234663852886E38;
        }
        HecTimeArray timeArrayOut = new HecTimeArray(2);
        timeArrayOut.elementAt(0).setMinutes(newTime.value() - interval);
        timeArrayOut.elementAt(1).set(newTime);
        doubleArrayContainer valuesOut = new doubleArrayContainer(2);
        HecTimeSeriesMath tm = new HecTimeSeriesMath();
        tm.convert(times, arrayX.array, timeArrayOut, valuesOut, this.type(), this.interval());
        status.value = valuesOut.array[1] == -3.4028234663852886E38 ? -1 : 0;
        return valuesOut.array[1];
    }

    public double incrementalValue(HecTime valueStartTime, HecTime valueEndTime, intContainer status) {
        String type;
        if (this._fileData == null) {
            status.value = -3;
            return -3.4028234663852886E38;
        }
        if (!this.fileAccessible()) {
            this.open();
        }
        if (!this.fileAccessible()) {
            status.value = -3;
            return -3.4028234663852886E38;
        }
        HecTimeArray times = new HecTimeArray();
        doubleArrayContainer arrayX = new doubleArrayContainer();
        if (this.dirty() || this._recordData == null || this._recordData.times == null) {
            this.resetArrayTime();
            int number = this.read(times, arrayX);
            if (number < -1) {
                status.value = -1;
                return -3.4028234663852886E38;
            }
        }
        if ((type = this.type()).compareTo("PER-CUM") != 0 && type.compareTo("PER-AVER") != 0 && type.compareTo("INST-VAL") != 0 && type.compareTo("INST-CUM") != 0) {
            return -3.4028234663852886E38;
        }
        int[] timeArrayOut = new int[]{valueStartTime.value(), valueEndTime.value()};
        doubleArrayContainer valuesOut = new doubleArrayContainer(2);
        HecTimeSeriesMath tm = new HecTimeSeriesMath();
        tm.convert(times.getIntArray(), arrayX.array, timeArrayOut, valuesOut, this.type(), this.interval());
        status.value = valuesOut.array[1] == -3.4028234663852886E38 ? -1 : 0;
        double incValue = valuesOut.array[1];
        if (this.type().equalsIgnoreCase("INST-CUM") && valuesOut.array[0] != -3.4028234663852886E38 && valuesOut.array[1] != -3.4028234663852886E38) {
            incValue = valuesOut.array[1] - valuesOut.array[0];
        }
        return incValue;
    }

    public int getSeriesPathnameRange(stringContainer firstPath, stringContainer lastPath, int searchOption) {
        int type;
        if (this.dirty() && (type = this.recordType()) == -1) {
            return -1;
        }
        int[] numberFound = new int[1];
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        Heclib.ztsrange(dssTable, this._dssPathname.pathname(), searchOption, firstPath, lastPath, numberFound);
        this.checkForSevereError(dssTable);
        this._fileData.releaseAccess(lockThreadToken);
        if (HecTimeSeries.checkForSevereError()) {
            return -4;
        }
        return numberFound[0];
    }

    public static String getStandardPathDate(String pathname) {
        int intl;
        DSSPathname dssPath = new DSSPathname(pathname);
        if (dssPath.dPart().length() >= 9 && (intl = HecTimeSeries.getIntervalFromEPart(dssPath.ePart())) >= 0) {
            String datePart = dssPath.dPart();
            HecTime time = new HecTime();
            time.setDate(datePart);
            if (time.isDateDefined() && !(datePart = HecTimeSeries.getDpartFromTime(time, dssPath.ePart())).startsWith("U")) {
                dssPath.setDPart(datePart);
                pathname = dssPath.getPathname();
            }
        }
        return pathname;
    }

    public int getSeriesTimeRange(HecTime startRange, HecTime endRange, int searchOption) {
        int type;
        if (this.dirty() && (type = this.recordType()) == -1) {
            return -1;
        }
        String path = HecTimeSeries.getStandardPathDate(this._dssPathname.getPathname());
        if (!DSSPathname.areSamePathnames(this._dssPathname.getPathname(), path, true) && searchOption == 0) {
            searchOption = 5;
        }
        int[] startJulian = new int[1];
        int[] startMinutes = new int[1];
        int[] endJulian = new int[1];
        int[] endMinutes = new int[1];
        int[] found = new int[1];
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            return -1;
        }
        Heclib.ztsends(dssTable, path, searchOption, startJulian, startMinutes, endJulian, endMinutes, found);
        this.checkForSevereError(dssTable);
        this._fileData.releaseAccess(lockThreadToken);
        if (HecTimeSeries.checkForSevereError()) {
            return -4;
        }
        if (found[0] == 0) {
            startRange.setUndefined();
            endRange.setUndefined();
            return -1;
        }
        startRange.setJulian(startJulian[0], startMinutes[0]);
        endRange.setJulian(endJulian[0], endMinutes[0]);
        return 0;
    }

    public void reset() {
        this.resetArrayTime();
    }

    @Override
    public void clear() {
        super.clear();
        this.reset();
    }

    public void resetArrayTime() {
        this._arrayStartTime.setUndefined();
        this._arrayEndTime.setUndefined();
        this._dirty = true;
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public boolean hasTimeZone() {
        return this._timeZone != null;
    }

    public void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
    }

    public void removeTimeZone() {
        this._timeZone = null;
    }

    @Override
    public synchronized String[] getCollectionList(String seedPathname) {
        DSSPathname path = new DSSPathname(seedPathname);
        if (path.dPart().length() != 9) {
            if (this._startTime.isDateDefined()) {
                int[] iblock = new int[1];
                int[] iyr = new int[1];
                int[] imon = new int[1];
                int[] iday = new int[1];
                int ver = 7500;
                int jul = this._startTime.julian();
                int interval = HecTimeSeries.getIntervalFromEPart(path.ePart());
                Heclib.zbegdt(jul, interval, iyr, imon, iday, iblock, ver);
                HecTime hecTime = new HecTime();
                hecTime.setYearMonthDay(iyr[0], imon[0], iday[0], 1);
                path.setDPart(hecTime.date(104));
            }
            return super.getCollectionList(path.pathname());
        }
        return super.getCollectionList(seedPathname);
    }

    protected boolean arraySizeOk(int arraySize) {
        if (arraySize <= 0) {
            System.out.println("Invalid Time Window");
            return false;
        }
        if (arraySize > 4000000) {
            System.out.println("Too many data values requested: " + arraySize);
            System.out.println("Invalid Time Window?");
            System.out.println("Start Time: " + this._arrayStartTime);
            System.out.println("End Time:   " + this._arrayEndTime);
            return false;
        }
        return true;
    }

    protected synchronized int retrieveData(int unitSystem) {
        int status = 0;
        if (this.dirty()) {
            if (this._recordData != null) {
                this._recordData.containsData = false;
            }
            this.recordType();
        }
        if (this.checkTimeWindow(true) != 0) {
            return -3;
        }
        int _arraySize = this.getDesiredArraySize();
        if (_arraySize == 0) {
            return -2;
        }
        if (!this.arraySizeOk(_arraySize)) {
            return -3;
        }
        if (this._recordData == null) {
            return -3;
        }
        if (this._recordData.containsData) {
            int numberMissing = 0;
            for (int j = 0; j < this._recordData.arraySize; ++j) {
                if (this._recordData.arrayX[j] != -3.4028234663852886E38) continue;
                ++numberMissing;
            }
            this._dirty = false;
            status = numberMissing == 0 ? this._recordData.arraySize : (numberMissing == this._recordData.arraySize ? -2 : -1);
            if (unitSystem != 0 && status >= -1) {
                this.convertUnitSystem(unitSystem);
            }
            this._storeDoubles = this._recordData.storeDoubles;
            return status;
        }
        int[] istat = new int[1];
        stringContainer units = new stringContainer();
        stringContainer type = new stringContainer();
        stringContainer timeZoneName = new stringContainer();
        int[] zoneOffset = new int[1];
        stringContainer dataTypeName = new stringContainer();
        int[] dataTypeNumber = new int[1];
        stringContainer tmp = new stringContainer();
        int[] prec = new int[1];
        int precision = 0;
        double[] buff = new double[_arraySize];
        this._recordData.flags = new int[_arraySize];
        int readFlags = 1;
        int[] flagsRead = new int[1];
        int[] compression = new int[1];
        int[] iofset = new int[1];
        int getDoubles = 1;
        int[] doublesRead = new int[1];
        int[] numberRead = new int[1];
        float[] fbuff = new float[1];
        stringContainer supplementalInfo = new stringContainer();
        double[] coordinates = new double[3];
        int[] coordinateDescription = new int[6];
        int[] coordinatesUsed = new int[1];
        if (this._recordType == 100 || this._recordType == 101) {
            intContainer lockThreadToken = new intContainer();
            int[] dssTable = this._fileData.requestAccess(lockThreadToken);
            if (dssTable == null) {
                return -4;
            }
            Heclib.zrrtsc(dssTable, this._dssPathname.pathname(), this._arrayStartTime.date(), this._arrayStartTime.hourMinutes(), _arraySize, numberRead, getDoubles, doublesRead, fbuff, buff, this._recordData.flags, readFlags, flagsRead, units, type, supplementalInfo, iofset, compression, zoneOffset, timeZoneName, coordinates, coordinateDescription, coordinatesUsed, istat);
            this.checkForSevereError(dssTable);
            Heclib.zinqir(dssTable, "TYPE", dataTypeName, dataTypeNumber);
            Heclib.zinqir(dssTable, "PREC", tmp, prec);
            precision = prec[0];
            this._fileData.releaseAccess(lockThreadToken);
            if (HecTimeSeries.checkForSevereError()) {
                return -4;
            }
            status = istat[0];
            this._storeDoubles = dataTypeNumber[0] == 105;
            if (flagsRead[0] == 0) {
                this._recordData.flags = null;
            }
            if (status > 5) {
                System.out.println("Error in reading data: " + this._dssPathname.pathname());
                this.checkSystemError();
                buff = null;
                this._recordData.arraySize = 0;
                this._recordData.arrayX = null;
                this._recordData.containsData = false;
                return -3;
            }
            if (_arraySize != this._recordData.arraySize) {
                this._recordData.arrayX = null;
                this._recordData.times = null;
            }
            if (this._recordData.arrayX == null) {
                this._recordData.arrayX = new double[_arraySize];
            }
            for (int i = 0; i < _arraySize; ++i) {
                this._recordData.arrayX[i] = buff[i] == -901.0 || buff[i] == -902.0 || Double.isNaN(buff[i]) ? -3.4028234663852886E38 : buff[i];
            }
            buff = null;
            this._recordData.timeOffset = iofset[0];
        } else if (this._recordType == 110 || this._recordType == 111) {
            int[] timeBuff = new int[_arraySize];
            int[] beginDate = new int[1];
            intContainer lockThreadToken = new intContainer();
            int[] dssTable = this._fileData.requestAccess(lockThreadToken);
            if (dssTable == null) {
                return -4;
            }
            while (true) {
                Heclib.zritsc(dssTable, this._dssPathname.pathname(), this._arrayStartTime.julian(), this._arrayStartTime.minutesSinceMidnight(), this._arrayEndTime.julian(), this._arrayEndTime.minutesSinceMidnight(), getDoubles, doublesRead, timeBuff, fbuff, buff, _arraySize, numberRead, beginDate, this._recordData.flags, readFlags, flagsRead, units, type, supplementalInfo, zoneOffset, timeZoneName, coordinates, coordinateDescription, coordinatesUsed, this.readFlag, istat);
                if (istat[0] != 1) break;
                if (!this.arraySizeOk(_arraySize *= 2)) {
                    return -3;
                }
                buff = new double[_arraySize];
                timeBuff = new int[_arraySize];
                this._recordData.flags = new int[_arraySize];
            }
            this.checkForSevereError(dssTable);
            Heclib.zinqir(dssTable, "TYPE", dataTypeName, dataTypeNumber);
            Heclib.zinqir(dssTable, "PREC", tmp, prec);
            precision = prec[0];
            this._fileData.releaseAccess(lockThreadToken);
            if (HecTimeSeries.checkForSevereError()) {
                return -4;
            }
            status = istat[0];
            this._storeDoubles = dataTypeNumber[0] == 115;
            if (flagsRead[0] == 0) {
                this._recordData.flags = null;
            }
            if (status > 5) {
                System.out.println("Error in reading data: " + this._dssPathname.pathname() + " - " + this.DSSFileName());
                this.checkSystemError();
                buff = null;
                this._recordData.arraySize = 0;
                this._recordData.arrayX = null;
                this._recordData.containsData = false;
                return -3;
            }
            if (numberRead[0] == 0) {
                this._recordData.arraySize = 0;
                buff = null;
                timeBuff = null;
                if (this.getMessageLevel() > 0 && this._arrayStartTime.equalTo(this.startTime())) {
                    System.out.println("No data available for: " + this._dssPathname.pathname() + " - " + this.DSSFileName());
                    return -2;
                }
                return 0;
            }
            _arraySize = numberRead[0];
            this._recordData.arrayX = new double[_arraySize];
            this._recordData.times = new int[_arraySize];
            int beginTime = beginDate[0] * 1440;
            for (int i = 0; i < _arraySize; ++i) {
                this._recordData.times[i] = timeBuff[i] + beginTime;
                this._recordData.arrayX[i] = buff[i] == -901.0 || buff[i] == -902.0 || Double.isNaN(buff[i]) ? -3.4028234663852886E38 : buff[i];
            }
            buff = null;
            timeBuff = null;
            if (status == 1) {
                this._arrayEndTime.setMinutes(this._recordData.times[_arraySize - 1]);
            }
        } else {
            System.out.println("Unknown data type: " + this._dssPathname.pathname());
            buff = null;
            this._recordData.arraySize = 0;
            this._recordData.arrayX = null;
            this._recordData.containsData = false;
            return -3;
        }
        this._unitsX = units.string;
        this._typeX = type.string;
        this._recordData.precision = precision;
        if (this._recordData.precision == 0) {
            this._recordData.precision = -1;
        }
        this._recordData.unitsX = this._unitsX;
        this._recordData.typeX = this._typeX;
        this._recordData.startTime = this._arrayStartTime.value();
        this._recordData.endTime = this._arrayEndTime.value();
        this._recordData.arraySize = _arraySize;
        this._recordData.containsData = true;
        this._recordData.dataSavedToDisk = true;
        this._recordData.storeDoubles = this._storeDoubles;
        this.localUnitSystem();
        if (zoneOffset[0] != -1 && timeZoneName.string != null && timeZoneName.string.length() > 0) {
            this._timeZone = TimeZone.getTimeZone(timeZoneName.string);
            if (this._timeZone != null && !timeZoneName.string.equals(this._timeZone.getID())) {
                this._timeZone.setID(timeZoneName.string);
            }
        } else {
            this._timeZone = null;
        }
        this._recordData.supplementalInfo = supplementalInfo.string != null && supplementalInfo.string.length() > 1 ? supplementalInfo.string : null;
        if (coordinatesUsed[0] != 0) {
            this._recordData.ordinates = coordinates;
            this._recordData.ordinateDescription = coordinateDescription;
        } else {
            this._recordData.ordinates = null;
            this._recordData.ordinateDescription = null;
        }
        this._dirty = false;
        if (unitSystem != 0 && status >= 0) {
            this.convertUnitSystem(unitSystem);
        }
        if (status == 0) {
            return this._recordData.arraySize;
        }
        if (status > 0 && status < 4) {
            return -1;
        }
        if (status > 3 && status < 6) {
            return -2;
        }
        return -3;
    }

    protected int prepareForWrite() {
        if (this._recordData.arraySize <= 0) {
            System.out.println("\nNo data specified to store for " + this._dssPathname.pathname());
            return -3;
        }
        if (this.dirty()) {
            this.recordType();
        }
        if (this._recordType < 100 || this._recordType > 199) {
            System.out.println("Error on time series write:  Invalid Pathname");
            System.out.println("Pathname: " + this._dssPathname.pathname());
            System.out.println("Record type: " + this._recordType);
            return -1;
        }
        this._recordData.pathname = this._dssPathname.pathname();
        this._recordData.recordType = this._recordType;
        this._recordData.myThis = this;
        if (this._recordType == 100 || this._recordType == 101) {
            if (this.checkTimeWindow(false) != 0) {
                System.out.println("\nInvalid start time for " + this._recordData.pathname);
                return -2;
            }
            this.updateArrayTime(this._recordData.arraySize);
        } else {
            if (this._recordData.times == null) {
                System.out.println("\nNo times for " + this._recordData.pathname);
                return -2;
            }
            if (this._recordData.startTime != 0) {
                this._arrayStartTime.setMinutes(this._recordData.startTime);
            } else {
                this._arrayStartTime.setMinutes(this._recordData.times[0]);
            }
            if (this._recordData.endTime != 0) {
                this._arrayEndTime.setMinutes(this._recordData.endTime);
            } else {
                this._arrayEndTime.setMinutes(this._recordData.times[this._recordData.arraySize - 1]);
            }
        }
        if (this._unitsX.length() == 0 || this._typeX.length() == 0) {
            stringContainer units = new stringContainer();
            stringContainer type = new stringContainer();
            this.getDefaultUnitsType(units, type);
            if (this._unitsX.length() == 0) {
                this._unitsX = units.string;
            }
            if (this._typeX.length() == 0) {
                this._typeX = type.string;
            }
        }
        this._recordData.startTime = this._arrayStartTime.value();
        this._recordData.endTime = this._arrayEndTime.value();
        this._recordData.unitsX = this._unitsX;
        this._recordData.typeX = this._typeX;
        this._recordData.containsData = true;
        this._recordData.dataSavedToDisk = false;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int flushToDisk() {
        int i;
        double[] doubleBuff;
        float[] buff;
        int storeDoubles;
        String supplementalInfo;
        int[] coordInfo;
        int zoneOffset;
        String zoneName;
        int storeFlags;
        int[] flags;
        if (this._recordData.precision >= 0) {
            HecTimeSeries.zset("PREC", "", this._recordData.precision);
        }
        int[] userHead = new int[1];
        boolean numberHead = false;
        int[] status = new int[1];
        if (this._recordData.flags == null) {
            flags = new int[1];
            storeFlags = 0;
        } else {
            flags = this._recordData.flags;
            storeFlags = 1;
        }
        if (this._timeZone != null) {
            zoneName = this._timeZone.getID();
            zoneOffset = this._timeZone.getRawOffset() / 60000;
        } else {
            zoneName = "";
            zoneOffset = 0;
        }
        double[] coordinates = this._recordData.ordinates;
        if (coordinates == null) {
            coordinates = new double[]{};
        }
        if ((coordInfo = this._recordData.ordinateDescription) == null) {
            coordInfo = new int[]{};
        }
        if ((supplementalInfo = this._recordData.supplementalInfo) == null) {
            supplementalInfo = "";
        }
        if (this._storeDoubles) {
            storeDoubles = 1;
            buff = new float[]{};
            doubleBuff = new double[this._recordData.arraySize];
            for (i = 0; i < this._recordData.arraySize; ++i) {
                doubleBuff[i] = this._recordData.arrayX[i] == -3.4028234663852886E38 || Double.isNaN(this._recordData.arrayX[i]) ? -901.0 : this._recordData.arrayX[i];
            }
        } else {
            storeDoubles = 0;
            doubleBuff = new double[]{};
            buff = new float[this._recordData.arraySize];
            for (i = 0; i < this._recordData.arraySize; ++i) {
                buff[i] = this._recordData.arrayX[i] == -3.4028234663852886E38 || Double.isNaN(this._recordData.arrayX[i]) ? -901.0f : (float)this._recordData.arrayX[i];
            }
        }
        if (this._recordType == 100 || this._recordType == 101) {
            intContainer lockThreadToken = new intContainer();
            int[] dssTable = this._fileData.requestAccess(lockThreadToken);
            if (dssTable == null) {
                return -3;
            }
            try {
                Heclib.zsrtsc(dssTable, this._dssPathname.pathname(), this._arrayStartTime.date(), this._arrayStartTime.hourMinutes(), this._recordData.arraySize, storeDoubles, buff, doubleBuff, flags, storeFlags, this._recordData.unitsX, this._recordData.typeX, coordinates, coordinates.length, coordInfo, coordInfo.length, supplementalInfo, zoneOffset, zoneName, this._regularStorePlan, 0, 0.0f, 0, 0, 0, status);
            }
            finally {
                this.checkForSevereError(dssTable);
                this._fileData.releaseAccess(lockThreadToken);
            }
        }
        if (this._recordType == 110 || this._recordType == 111) {
            if (this._recordData.times == null) {
                System.out.print("No times set to write");
                System.out.print(" irregular interval data");
                System.out.println(" to dss.  Path: " + this._dssPathname.pathname());
                return -2;
            }
            int startDate = 0;
            if (this._recordData.startTime < this._recordData.times[0] || this._recordData.endTime > this._recordData.times[this._recordData.arraySize - 1]) {
                intContainer lockThreadToken;
                int[] dssTable;
                int i2;
                boolean lbefore = false;
                boolean lafter = false;
                if (this._recordData.startTime < this._recordData.times[0]) {
                    lbefore = true;
                }
                if (this._recordData.endTime > this._recordData.times[this._recordData.arraySize - 1]) {
                    lafter = true;
                }
                int nstart = 0;
                int ncount = this._recordData.arraySize;
                if (lbefore) {
                    ++ncount;
                    nstart = 1;
                }
                if (lafter) {
                    ++ncount;
                }
                int[] timeArray = new int[ncount];
                if (lbefore) {
                    timeArray[0] = this._recordData.startTime;
                }
                if (lafter) {
                    timeArray[ncount - 1] = this._recordData.endTime;
                }
                if (this._storeDoubles) {
                    doubleBuff = new double[ncount];
                    if (lbefore) {
                        doubleBuff[0] = -902.0;
                    }
                    if (lafter) {
                        doubleBuff[ncount - 1] = -902.0;
                    }
                    for (i2 = 0; i2 < this._recordData.arraySize; ++i2) {
                        timeArray[i2 + nstart] = this._recordData.times[i2];
                        doubleBuff[i2 + nstart] = this._recordData.arrayX[i2] == -3.4028234663852886E38 || Double.isNaN(this._recordData.arrayX[i2]) ? -901.0 : this._recordData.arrayX[i2];
                    }
                } else {
                    buff = new float[ncount];
                    if (lbefore) {
                        buff[0] = -902.0f;
                    }
                    if (lafter) {
                        buff[ncount - 1] = -902.0f;
                    }
                    for (i2 = 0; i2 < this._recordData.arraySize; ++i2) {
                        timeArray[i2 + nstart] = this._recordData.times[i2];
                        buff[i2 + nstart] = this._recordData.arrayX[i2] == -3.4028234663852886E38 || Double.isNaN(this._recordData.arrayX[i2]) ? -901.0f : (float)this._recordData.arrayX[i2];
                    }
                }
                if ((dssTable = this._fileData.requestAccess(lockThreadToken = new intContainer())) == null) {
                    return -3;
                }
                try {
                    Heclib.zsitsc(dssTable, this._dssPathname.pathname(), timeArray, buff, doubleBuff, storeDoubles, ncount, startDate, flags, storeFlags, this._recordData.unitsX, this._recordData.typeX, coordinates, coordinates.length, coordInfo, coordInfo.length, supplementalInfo, zoneOffset, zoneName, this._irregularInFlag, status);
                }
                finally {
                    this.checkForSevereError(dssTable);
                    this._fileData.releaseAccess(lockThreadToken);
                }
            }
            intContainer lockThreadToken = new intContainer();
            int[] dssTable = this._fileData.requestAccess(lockThreadToken);
            if (dssTable == null) {
                return -3;
            }
            try {
                Heclib.zsitsc(dssTable, this._dssPathname.pathname(), this._recordData.times, buff, doubleBuff, storeDoubles, this._recordData.arraySize, startDate, flags, storeFlags, this._recordData.unitsX, this._recordData.typeX, coordinates, coordinates.length, coordInfo, coordInfo.length, supplementalInfo, zoneOffset, zoneName, this._irregularInFlag, status);
            }
            finally {
                this.checkForSevereError(dssTable);
                this._fileData.releaseAccess(lockThreadToken);
            }
        }
        if (HecTimeSeries.checkForSevereError()) {
            return -4;
        }
        flags = null;
        this._recordData.dataSavedToDisk = true;
        return status[0];
    }

    protected int updateArrayTime(int number) {
        if (this._recordType == 100 || this._recordType == 101) {
            this._arrayEndTime.setMinutes(this._arrayStartTime.value() + (number - 1) * this.interval());
        }
        return number;
    }

    protected int getInterval(String ePart) {
        int[] nvals = new int[1];
        int[] interval = new int[1];
        int[] istat = new int[]{1};
        Heclib.zgintl(interval, ePart, nvals, istat);
        if (istat[0] == -1) {
            stringContainer alpha = new stringContainer();
            int ivers = HecTimeSeries.zquery("vers", alpha);
            if (ivers > 6) {
                istat[0] = 1;
            }
            if (istat[0] == -1) {
                return -1;
            }
        }
        if (istat[0] == 1) {
            return 0;
        }
        return interval[0];
    }

    protected int checkTimeWindow(boolean readData) {
        String ePart;
        if (this._recordData == null) {
            System.out.println("Error, destructor done() called on re-used object");
            System.out.println(this._recordData.pathname);
        }
        if (this.interval() == Integer.MIN_VALUE && (ePart = this._dssPathname.ePart()).length() > 0) {
            this._interval = this.getInterval(ePart);
            if (this._interval == -1) {
                return -1;
            }
        }
        if (this._retrieveAllTimes && readData && !this.startTime().isDefined() && !this.endTime().isDefined()) {
            HecTime start = new HecTime();
            HecTime end = new HecTime();
            boolean found = this.getTimeSeriesExtents(this._dssPathname.getPathname(), start, end);
            if (found && start.isDefined()) {
                this.setStartTime(start);
                this.setEndTime(end);
            }
        }
        if (this._recordData.times != null && !this.startTime().isDefined()) {
            HecTime sTime = new HecTime();
            sTime.setMinutes(this._recordData.times[0]);
            HecTime eTime = new HecTime();
            eTime.setMinutes(this._recordData.times[this._recordData.arraySize - 1]);
            this.setStartTime(sTime);
            this.setEndTime(eTime);
        }
        this._arrayStartTime = new HecTime(this.startTime());
        this._arrayEndTime = new HecTime(this.endTime());
        if (this._arrayStartTime.isDefined() && this._arrayEndTime.isDefined() && this.interval() > 0) {
            return 0;
        }
        if (!this._arrayStartTime.isDefined() || !this._arrayEndTime.isDefined()) {
            if (this._dssPathname.dPart().length() > 6 && !this._arrayStartTime.isDefined()) {
                this._arrayStartTime.set(this._dssPathname.dPart(), "0001");
                if (!this._arrayStartTime.isDefined()) {
                    if (this._dssPathname.dPart().startsWith("TS-")) {
                        return 0;
                    }
                    return -2;
                }
                int dataInterval = this.interval();
                if (dataInterval > 0) {
                    int[] julian = new int[1];
                    int[] mins = new int[1];
                    int one = 1;
                    int[] iofset = new int[1];
                    julian[0] = this._arrayStartTime.julian();
                    mins[0] = this._arrayStartTime.minutesSinceMidnight();
                    Heclib.zofset(julian, mins, dataInterval, one, iofset);
                    this._arrayStartTime.setJulian(julian[0], mins[0], 0);
                }
            }
            if (!this._arrayStartTime.isDefined()) {
                return -3;
            }
            if (!this._arrayEndTime.isDefined()) {
                int[] jul = new int[1];
                int[] iblock = new int[1];
                int[] iyr = new int[1];
                int[] imon = new int[1];
                int[] iday = new int[1];
                jul[0] = this._arrayStartTime.julian();
                int istat = this.getBlockStartDate(jul[0], iblock, iyr, imon, iday);
                if (istat != 0) {
                    return istat;
                }
                Heclib.zincbk(iblock, jul, iyr, imon, iday);
                this._arrayEndTime.setJulian(jul[0], 0, 0);
            }
        }
        if (!this._arrayStartTime.isDefined()) {
            return -3;
        }
        if (!this._arrayEndTime.isDefined()) {
            return -3;
        }
        if (this.interval() == Integer.MIN_VALUE) {
            return -3;
        }
        return 0;
    }

    protected int getBlockStartDate(int jul, int[] block, int[] year, int[] month, int[] day) {
        int ver;
        this.recordType();
        if ((this._recordType == 100 || this._recordType == 101) && this.interval() > 0) {
            ver = 0;
            stringContainer s = new stringContainer();
            this.zinqir("FVER", s, new int[]{ver});
            try {
                if (!s.string.startsWith("6-")) {
                    throw new Exception("");
                }
                ver = 100 * s.string.charAt(2) + s.string.charAt(3);
            }
            catch (Throwable t) {
                ver = 9999;
            }
        } else {
            if (this._recordType == 110 || this._recordType == 111) {
                return HecTimeSeries.getIrregBeginningDate(this._dssPathname.ePart(), jul, year, month, day, block);
            }
            return -3;
        }
        Heclib.zbegdt(jul, this.interval(), year, month, day, block, ver);
        return 0;
    }

    protected int getDesiredArraySize() {
        if (this._recordType == 0) {
            this._desiredArraySize = -1;
        } else if (this._recordType == 100 || this._recordType == 101) {
            if (this.interval() <= 0) {
                System.out.println("HecTimeSeries:  Invalid time interval: " + this.interval());
                return -1;
            }
            if (this._recordType == 101) {
                this._desiredArraySize = this._checkedNumber;
                this._arrayStartTime.setDate("01Jan3000");
                this._arrayStartTime.add(this.interval());
            } else {
                HecTime start = new HecTime(this._arrayStartTime);
                start.adjustToIntervalOffset(this.interval(), 0);
                HecTime end = new HecTime(this._arrayEndTime);
                end.adjustToIntervalOffset(this.interval(), 0);
                this._desiredArraySize = start.computeNumberIntervals(end, this.interval()) + 1;
                if (this._desiredArraySize <= 0) {
                    this._desiredArraySize = (start.value() - end.value()) / this.interval() + 1;
                }
                if (this._desiredArraySize <= 0) {
                    System.out.println("HecTimeSeries:  Invalid start / end time; Start " + this._arrayStartTime.toString() + "  End " + this._arrayEndTime.toString());
                }
            }
        } else if ((this._recordType == 110 || this._recordType == 111) && this._desiredArraySize <= 0) {
            this._desiredArraySize = this.getNumberValuesForArraySize();
        }
        return this._desiredArraySize;
    }
}

