/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecDSSRecordData;
import hec.heclib.dss.HecDataManager;
import hec.heclib.util.HecTime;
import hec.heclib.util.Heclib;
import hec.heclib.util.intContainer;
import hec.heclib.util.stringContainer;
import java.util.Comparator;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalFactory;

public class HecTimeSeriesBase
extends HecDataManager {
    protected static int _defaultInterval = Integer.MIN_VALUE;
    protected boolean _retrieveAllTimes = false;
    protected int _interval = Integer.MIN_VALUE;

    public HecTimeSeriesBase() {
        this._recordData = new HecDSSRecordData();
    }

    public HecTimeSeriesBase(String DssFileName) {
        super(DssFileName);
        this._recordData = new HecDSSRecordData();
    }

    public int precision() {
        return this._recordData.precision;
    }

    public void setPrecision(int precision) {
        this._recordData.precision = precision;
    }

    public static int getIntervalFromEPart(String ePart) {
        String temp = ePart.toLowerCase();
        if (!temp.startsWith("ir-") && !temp.startsWith("~")) {
            int[] n = new int[1];
            int[] interval = new int[1];
            int[] istat = new int[]{1};
            Heclib.zgintl(interval, ePart, n, istat);
            if (istat[0] != 0) {
                return -3;
            }
            return interval[0];
        }
        return 0;
    }

    public static int zgintlFromEPart(String ePart) {
        int[] n = new int[1];
        int[] interval = new int[1];
        int[] istat = new int[]{1};
        Heclib.zgintl(interval, ePart, n, istat);
        if (istat[0] < 0) {
            return 0;
        }
        return interval[0];
    }

    public static String getEPartFromInterval(int interval) {
        int[] status = new int[]{0};
        return Heclib.getDSSEPartFromInterval(interval, status);
    }

    public static Vector<String> getListOfEParts() {
        Stream s1 = IntervalFactory.findAllDss7(i -> i.isIrregular() && !i.toString().startsWith("~")).stream();
        Stream<Interval> s2 = IntervalFactory.findAllDss7(i -> i.getMinutes() >= 1).stream().sorted(Comparator.comparingInt(i -> i.getMinutes()));
        return Stream.concat(s1, s2).map(Object::toString).collect(Collectors.toCollection(Vector::new));
    }

    public static String getAppropriateIrregularBlock(int[] times) {
        if (times.length == 0) {
            return "";
        }
        int intl = HecTimeSeriesBase.getMostCommonInterval(times);
        if (intl < 1) {
            intl = (times[times.length - 1] - times[0]) / times.length;
        }
        if (intl < 21) {
            return "IR-Day";
        }
        if (intl < 61) {
            return "IR-Month";
        }
        if (intl < 1441) {
            return "IR-Year";
        }
        if (intl < 44641) {
            return "IR-Decade";
        }
        return "IR-Century";
    }

    public static String getAppropriateRegularEPart(int[] times) {
        if (times.length == 0) {
            return "";
        }
        int intl = HecTimeSeriesBase.getMostCommonInterval(times);
        if (intl > 0) {
            int[] status = new int[]{0};
            String ePart = Heclib.getDSSEPartFromInterval(intl, status);
            if (status[0] == 0) {
                return ePart;
            }
        }
        if ((intl = times[times.length - 1] / times[0] / times.length) < 44641) {
            return "1Month";
        }
        return "1Year";
    }

    public static String getAppropriateEPart(int[] times) {
        if (times.length == 0) {
            return "";
        }
        if (HecTimeSeriesBase.isRegular(times)) {
            return HecTimeSeriesBase.getAppropriateRegularEPart(times);
        }
        return HecTimeSeriesBase.getAppropriateIrregularBlock(times);
    }

    public static boolean isRegular(int[] times) {
        int interval = 0;
        if (times.length > 2) {
            interval = times[1] - times[0];
            if (interval < 3000) {
                for (int i = 2; i < times.length; ++i) {
                    if (times[i - 1] - times[i - 2] == times[i] - times[i - 1]) continue;
                    return false;
                }
            } else {
                HecTime time = new HecTime();
                for (int i = 2; i < times.length; ++i) {
                    time.set(times[0]);
                    time.increment(i, interval);
                    int val = time.value();
                    if (val == times[i]) continue;
                    return false;
                }
                return true;
            }
        }
        int[] status = new int[]{0};
        Heclib.getEPartFromInterval(interval, status);
        return status[0] == 0;
    }

    public static int getMostCommonInterval(int[] times) {
        int[] intls = new int[]{5, 10, 15, 30, 60, 120, 180, 240, 720, 1440, -1};
        int[] numbers = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        for (int i = 1; i < times.length; ++i) {
            if (times[i] == 0) continue;
            boolean found = false;
            int diff = times[i] - times[i - 1];
            for (int j = 0; j < intls.length; ++j) {
                if (diff != intls[j]) continue;
                int n = j;
                numbers[n] = numbers[n] + 1;
                found = true;
                break;
            }
            if (found || diff <= 1440) continue;
            int n = numbers.length - 1;
            numbers[n] = numbers[n] + 1;
        }
        int max = 0;
        int dataIntervalMinutes = 0;
        for (int i = 0; i < numbers.length; ++i) {
            if (numbers[i] <= max) continue;
            dataIntervalMinutes = intls[i];
            max = numbers[i];
        }
        return dataIntervalMinutes;
    }

    public static String getDpartFromTime(HecTime startTime, String ePart) {
        if (!startTime.isDateDefined()) {
            return null;
        }
        ePart = ePart.toUpperCase();
        int interval = HecTimeSeriesBase.getIntervalFromEPart(ePart);
        HecTime time = new HecTime(3);
        if (interval > 0) {
            int julianStart = startTime.julian();
            int[] year = new int[1];
            int[] month = new int[1];
            int[] day = new int[1];
            int[] block = new int[1];
            Heclib.zbegdt(julianStart, interval, year, month, day, block, 7500);
            time.setYearMonthDay(year[0], month[0], day[0]);
        } else {
            intContainer year = new intContainer();
            intContainer month = new intContainer();
            intContainer day = new intContainer();
            startTime.yearMonthDay(year, month, day);
            if (!ePart.equals("IR-Day")) {
                if (ePart.equals("IR-Month")) {
                    day.value = 1;
                } else if (ePart.equals("IR-Year")) {
                    day.value = 1;
                    month.value = 1;
                } else if (ePart.equals("IR-Decade")) {
                    day.value = 1;
                    month.value = 1;
                    year.value = year.value / 10 * 10;
                } else if (ePart.equals("IR-Century")) {
                    day.value = 1;
                    month.value = 1;
                    year.value = year.value / 100 * 100;
                }
            }
            time.setYearMonthDay(year.value, month.value, day.value);
        }
        return time.date(104);
    }

    public int setInterval(int interval) {
        int[] status = new int[1];
        this._dssPathname.setEPart(Heclib.getEPartFromInterval(interval, status));
        if (status[0] != 0) {
            return -3;
        }
        this._interval = interval;
        this._desiredArraySize = -1;
        return 0;
    }

    public int interval() {
        if (this._interval == Integer.MIN_VALUE) {
            return _defaultInterval;
        }
        return this._interval;
    }

    @Override
    public int setEPart(String ePart) {
        this._recordType = 0;
        String temp = ePart.toLowerCase();
        if (temp.startsWith("ir-") || temp.startsWith("~")) {
            this._interval = Integer.MIN_VALUE;
            this._desiredArraySize = -1;
        } else {
            int[] nvals = new int[1];
            int[] intl = new int[1];
            int[] istat = new int[]{1};
            Heclib.zgintl(intl, ePart, nvals, istat);
            if (istat[0] < 0) {
                return -3;
            }
            this._interval = intl[0];
        }
        super.setEPart(ePart);
        return 0;
    }

    @Override
    public int setPathname(String pathname) {
        int status = super.setPathname(pathname);
        if (status != 0) {
            return status;
        }
        if (this._dssPathname.ePart().length() > 2) {
            String ePart = new String(this._dssPathname.ePart());
            status = this.setEPart(ePart);
        }
        if (!this.startTime().isDefined() && !this.endTime().isDefined()) {
            HecTime start = new HecTime();
            HecTime end = new HecTime();
            boolean hasTW = HecTimeSeriesBase.getTimeWindowFromPath(this, this._dssPathname, start, end);
            if (hasTW) {
                this.setStartTime(start);
                this.setEndTime(end);
            } else if (this._dssPathname.dPart().equals("*")) {
                this._retrieveAllTimes = true;
            }
        }
        return status;
    }

    public static boolean getTimeWindowFromPath(HecDataManager dataManager, DSSPathname path, HecTime startTime, HecTime endTime) {
        if (path.dPart().length() == 21) {
            if (path.dPart().indexOf(" - ") == 9) {
                startTime.setDate(path.dPart().substring(0, 9));
                startTime.setTime("0001");
                endTime.setDate(path.dPart().substring(12));
                endTime.setTime("2400");
            }
        } else if (path.dPart().length() == 9) {
            startTime.setDate(path.dPart());
            startTime.setTime("0001");
            HecTime end = CondensedReference.getNextBlockDate(dataManager, startTime, path.ePart());
            if (end.isDefined()) {
                end.subtractMinutes(1);
                endTime.set(end);
            }
        } else {
            return false;
        }
        return startTime.isDefined() && endTime.isDefined();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNumberValuesForArraySize() {
        boolean gotTW;
        HecTime startTime = new HecTime();
        HecTime endTime = new HecTime();
        if (this.startTime().isDefined()) {
            startTime.set(this.startTime());
        }
        if (this.endTime().isDefined()) {
            endTime.set(this.endTime());
        }
        if (!(startTime.isDefined() && endTime.isDefined() || (gotTW = HecTimeSeriesBase.getTimeWindowFromPath(this, this._dssPathname, startTime, endTime)))) {
            return -1;
        }
        int number = 0;
        if (this._interval > 0) {
            number = HecTime.nopers(this._interval, startTime.julian(), startTime.minutesSinceMidnight(), endTime.julian(), endTime.minutesSinceMidnight());
            ++number;
        } else {
            HecTime htime = new HecTime();
            DSSPathname path = new DSSPathname(this._dssPathname.pathname());
            int[] jul = new int[1];
            int[] iblock = new int[1];
            int[] iyr = new int[1];
            int[] imon = new int[1];
            int[] iday = new int[1];
            int[] checkedNumber = new int[]{0};
            int[] exists = new int[]{0};
            int[] dataType = new int[]{0};
            stringContainer type = new stringContainer();
            int stat = HecTimeSeriesBase.getIrregBeginningDate(this._dssPathname.ePart(), startTime.julian(), iyr, imon, iday, iblock);
            if (stat != 0) {
                return -1;
            }
            htime.setYearMonthDay(iyr[0], imon[0], iday[0], 1440);
            intContainer lockThreadToken = new intContainer();
            int[] dssTable = this._fileData.requestAccess(lockThreadToken);
            if (dssTable == null) {
                return -1;
            }
            try {
                do {
                    path.setDPart(htime.date(104));
                    String pathname = path.pathname();
                    Heclib.zdtype(dssTable, pathname, checkedNumber, exists, type, dataType);
                    if (exists[0] != 0) {
                        number += checkedNumber[0];
                        if (this._dataType < 1) {
                            this._dataType = dataType[0];
                        }
                    }
                    Heclib.zincbk(iblock, jul, iyr, imon, iday);
                    htime.setJulian(jul[0], 1, 0);
                } while (!htime.greaterThan(endTime));
            }
            finally {
                this._fileData.releaseAccess(lockThreadToken);
            }
            if (this.getDssFileVersion() == 6) {
                number /= 2;
            }
            number += 2;
        }
        return number;
    }

    @Override
    public int setPathnameParts(String pathnameParts) {
        String tempEPart = this._dssPathname.ePart();
        int status = super.setPathnameParts(pathnameParts);
        if (status != 0) {
            this._dssPathname.setEPart(tempEPart);
            return -3;
        }
        if (!tempEPart.equals(this._dssPathname.ePart())) {
            status = this.setEPart(this._dssPathname.ePart());
        }
        return status;
    }

    public void setUnits(String units) {
        this._unitsX = units;
    }

    public void setType(String type) {
        this._typeX = type;
    }

    public String units() {
        return this._unitsX;
    }

    public String type() {
        return this._typeX;
    }

    @Override
    public void status() {
        System.out.println("HecTimeSeriesBase.status ()");
        super.status();
        System.out.println(" Interval: " + this._interval);
        System.out.println(" Units: " + this._unitsX);
        System.out.println(" Type: " + this._typeX);
        String temp = this._localUnitSystem == 0 ? "Undefined" : (this._localUnitSystem == 1 ? "English" : "SI (metric)");
        System.out.println("  Unit system: " + temp);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getDefaultUnitsType(stringContainer units, stringContainer type) {
        int localUnitSystem = this._localUnitSystem;
        String cPart = this._dssPathname.cPart();
        if (localUnitSystem == 2) {
            if (cPart.indexOf("PRECIP") != -1) {
                type.string = "PER-CUM ";
                units.string = "MM      ";
                return 0;
            }
            if (cPart.indexOf("STORAGE") != -1) {
                type.string = "INST-VAL";
                units.string = "THOU M3 ";
                return 0;
            }
            if (cPart.indexOf("AREA") != -1) {
                type.string = "INST-VAL";
                units.string = "THOU M2 ";
                return 0;
            }
            if (cPart.indexOf("ELEV") != -1) {
                type.string = "INST-VAL";
                units.string = "METERS  ";
                return 0;
            }
            if (cPart.indexOf("FLOW") != -1) {
                type.string = "INST-VAL";
                units.string = "M3/S    ";
                return 0;
            }
            if (cPart.indexOf("MOISTURE DEFICIT") != -1) {
                type.string = "INST-VAL";
                units.string = "MM      ";
                return 0;
            }
            type.string = "INST-VAL";
            units.string = "UNSPECIF";
            return -3;
        }
        if (cPart.indexOf("PRECIP") != -1) {
            type.string = "PER-CUM ";
            units.string = "INCHES  ";
            return 0;
        }
        if (cPart.indexOf("STORAGE") != -1) {
            type.string = "INST-VAL";
            units.string = "ACFT    ";
            return 0;
        }
        if (cPart.indexOf("AREA") != -1) {
            type.string = "INST-VAL";
            units.string = "ACRES   ";
            return 0;
        }
        if (cPart.indexOf("ELEV") != -1) {
            type.string = "INST-VAL";
            units.string = "FEET    ";
            return 0;
        }
        if (cPart.indexOf("FLOW") != -1) {
            type.string = "INST-VAL";
            units.string = "CFS     ";
            return 0;
        }
        if (cPart.indexOf("MOISTURE DEFICIT") != -1) {
            type.string = "INST-VAL";
            units.string = "INCHES  ";
            return 0;
        }
        type.string = "INST-VAL";
        units.string = "UNSPECIF";
        return -3;
    }

    public int numberValues() {
        if (this._recordData == null) {
            return 0;
        }
        return this._recordData.arraySize;
    }

    @Override
    public void setStartTime(HecTime startTime) {
        if (!this._startTime.equalTo(startTime)) {
            this._recordData.times = null;
        }
        super.setStartTime(startTime);
    }
}

