/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.heclib.dss.HecTimeSeries;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.heclib.util.doubleArrayContainer;

public class HecTimeSeriesMath
extends HecTimeSeries {
    public HecTimeSeriesMath() {
    }

    public HecTimeSeriesMath(String DssFileName) {
        super(DssFileName);
    }

    public void convertToRegularInterval(int newInterval) {
        HecTimeArray timeArrayIn = new HecTimeArray();
        doubleArrayContainer valuesIn = new doubleArrayContainer();
        this.read(timeArrayIn, valuesIn);
        if (timeArrayIn.element(1) == null || timeArrayIn.element(0) == null) {
            return;
        }
        int zeroInterval = timeArrayIn.element(1).value() - timeArrayIn.element(0).value();
        HecTime oldTimeStart = this.arrayStartTime();
        oldTimeStart.subtract(zeroInterval);
        HecTime dataStart = new HecTime(oldTimeStart);
        dataStart.add(newInterval);
        int end = this.arrayEndTime().value();
        int start = this.arrayStartTime().value();
        int newArraySize = (end - start) / newInterval;
        HecTimeArray timeArrayOut = new HecTimeArray(newArraySize);
        doubleArrayContainer valuesOut = new doubleArrayContainer(newArraySize);
        HecTime tempTime = new HecTime(dataStart);
        for (int i = 0; i < newArraySize; ++i) {
            timeArrayOut.set(i, tempTime);
            tempTime.add(newInterval);
        }
        String dataType = new String(this.type());
        this.convert(timeArrayIn, valuesIn.array, timeArrayOut, valuesOut, dataType, zeroInterval);
        int[] times = new int[valuesOut.length];
        for (int i = 0; i < valuesOut.length; ++i) {
            times[i] = timeArrayOut.element(i).value();
        }
        this.setInterval(newInterval);
        this.write(times, valuesOut.array, valuesOut.length, false);
    }

    public void convert(HecTimeArray timeArrayIn, double[] valuesIn, HecTimeArray timeArrayOut, doubleArrayContainer valuesOut, String dataType, int zeroInterval) {
        int[] intTimeIn = timeArrayIn.getIntArray();
        int[] intTimeOut = timeArrayOut.getIntArray();
        this.convert(intTimeIn, valuesIn, intTimeOut, valuesOut, dataType, zeroInterval);
    }

    public void convert(int[] timeArrayIn, double[] valuesIn, int[] timeArrayOut, doubleArrayContainer valuesOut, String dataType, int zeroInterval) {
        int newEndTime;
        int i;
        if (dataType.equalsIgnoreCase("INST-VAL") || dataType.equalsIgnoreCase("INST-CUM")) {
            int numberValuesIn = timeArrayIn.length;
            int numberValuesOut = timeArrayOut.length;
            int lastMatch = 0;
            block0: for (i = 0; i < numberValuesOut; ++i) {
                int newTime = timeArrayOut[i];
                if (newTime < timeArrayIn[0] || newTime > timeArrayIn[numberValuesIn - 1]) {
                    valuesOut.array[i] = -3.4028234663852886E38;
                    continue;
                }
                for (int j = lastMatch; j < numberValuesIn; ++j) {
                    int highTimeIn = timeArrayIn[j];
                    double highValueIn = valuesIn[j];
                    if (highTimeIn == newTime) {
                        valuesOut.array[i] = highValueIn;
                        lastMatch = j;
                        continue block0;
                    }
                    if (highTimeIn <= newTime) continue;
                    int lowTimeIn = timeArrayIn[j - 1];
                    double lowValueIn = valuesIn[j - 1];
                    if (highValueIn == -3.4028234663852886E38 || lowValueIn == -3.4028234663852886E38) {
                        valuesOut.array[i] = -3.4028234663852886E38;
                        lastMatch = j;
                        continue block0;
                    }
                    double deltaValue = highValueIn - lowValueIn;
                    int deltaTime = highTimeIn - lowTimeIn;
                    int newDelta = highTimeIn - newTime;
                    valuesOut.array[i] = highValueIn - deltaValue / (double)deltaTime * (double)newDelta;
                    lastMatch = j;
                    continue block0;
                }
            }
        }
        if (dataType.equals("PER-AVER")) {
            int lastMatch = 0;
            int newZeroInterval = timeArrayOut[1] - timeArrayOut[0];
            int numberValuesIn = timeArrayIn.length;
            int numberValuesOut = timeArrayOut.length;
            int lowestTimeIn = timeArrayIn[0];
            int highestTimeIn = timeArrayIn[numberValuesIn - 1];
            for (i = 0; i < numberValuesOut; ++i) {
                boolean isDefined = true;
                int newTime = timeArrayOut[i];
                if (newTime > highestTimeIn) {
                    valuesOut.array[i] = -3.4028234663852886E38;
                    continue;
                }
                if (newTime - newZeroInterval < lowestTimeIn - zeroInterval) {
                    valuesOut.array[i] = -3.4028234663852886E38;
                    continue;
                }
                newEndTime = newTime;
                int newStartTime = i == 0 ? newEndTime - newZeroInterval : timeArrayOut[i - 1];
                double area = 0.0;
                for (int j = lastMatch; j < numberValuesIn; ++j) {
                    int deltaTime;
                    int oldTime = timeArrayIn[j];
                    if (oldTime <= newStartTime) continue;
                    if (j > 0) {
                        lastMatch = j - 1;
                    }
                    if (oldTime >= newEndTime) {
                        if (valuesIn[j] == -3.4028234663852886E38) {
                            isDefined = false;
                            break;
                        }
                        deltaTime = j > 0 ? newEndTime - timeArrayIn[j - 1] : zeroInterval;
                        if (newEndTime - newStartTime < deltaTime) {
                            deltaTime = newEndTime - newStartTime;
                        }
                        area += (double)deltaTime * valuesIn[j];
                        break;
                    }
                    if (valuesIn[j] == -3.4028234663852886E38) {
                        isDefined = false;
                        break;
                    }
                    deltaTime = j > 0 ? oldTime - timeArrayIn[j - 1] : zeroInterval;
                    if (oldTime - newStartTime < deltaTime) {
                        deltaTime = oldTime - newStartTime;
                    }
                    area += (double)deltaTime * valuesIn[j];
                }
                valuesOut.array[i] = isDefined ? area / (double)(newEndTime - newStartTime) : -3.4028234663852886E38;
            }
        }
        if (dataType.equals("PER-CUM")) {
            boolean isDefined = true;
            int lastMatch = 0;
            int newZeroInterval = timeArrayOut[1] - timeArrayOut[0];
            int numberValuesIn = timeArrayIn.length;
            int numberValuesOut = timeArrayOut.length;
            int lowestTimeIn = timeArrayIn[0];
            int highestTimeIn = timeArrayIn[numberValuesIn - 1];
            for (int i2 = 0; i2 < numberValuesOut; ++i2) {
                isDefined = true;
                newEndTime = timeArrayOut[i2];
                if (newEndTime > highestTimeIn) {
                    valuesOut.array[i2] = -3.4028234663852886E38;
                    continue;
                }
                if (newEndTime - newZeroInterval < lowestTimeIn - zeroInterval) {
                    valuesOut.array[i2] = -3.4028234663852886E38;
                    continue;
                }
                int newStartTime = i2 == 0 ? newEndTime - newZeroInterval : timeArrayOut[i2 - 1];
                double area = 0.0;
                for (int j = lastMatch; j < numberValuesIn; ++j) {
                    int lowAreaTime;
                    int lastIn;
                    int oldTime = timeArrayIn[j];
                    if (j == 0) {
                        lastIn = oldTime - zeroInterval;
                    } else {
                        lastMatch = j - 1;
                        lastIn = timeArrayIn[j - 1];
                    }
                    if (oldTime <= newStartTime) continue;
                    double valueIn = valuesIn[j];
                    if (oldTime >= newEndTime) {
                        lowAreaTime = lastIn;
                        if (newStartTime > lowAreaTime) {
                            lowAreaTime = newStartTime;
                        }
                        double ratio = (double)(newEndTime - lastIn) / (double)(oldTime - lastIn);
                        double highValue = ratio * valueIn;
                        ratio = (double)(lowAreaTime - lastIn) / (double)(oldTime - lastIn);
                        double lowValue = ratio * valueIn;
                        if (valueIn == -3.4028234663852886E38) {
                            isDefined = false;
                            break;
                        }
                        area += highValue - lowValue;
                        break;
                    }
                    lowAreaTime = lastIn;
                    if (newStartTime > lowAreaTime) {
                        lowAreaTime = newStartTime;
                    }
                    double highValue = valueIn;
                    double ratio = 1.0 - (double)(oldTime - lowAreaTime) / (double)(oldTime - lastIn);
                    double lowValue = ratio * valueIn;
                    if (valuesIn[j] == -3.4028234663852886E38) {
                        isDefined = false;
                        break;
                    }
                    area += highValue - lowValue;
                }
                valuesOut.array[i2] = isDefined ? area : -3.4028234663852886E38;
            }
        }
    }

    public void changeInterval(int newInterval) {
        int i;
        int zeroInterval;
        if (this._recordData == null || this._recordData.arrayX == null) {
            this.retrieveData(0);
        }
        if ((zeroInterval = this.interval()) == Integer.MIN_VALUE) {
            zeroInterval = this._recordData.times[1] - this._recordData.times[0];
        }
        HecTimeArray timeArrayIn = new HecTimeArray(this._recordData.arraySize);
        double[] valuesIn = new double[this._recordData.arraySize];
        if (this._recordData.times == null) {
            HecTime tempTime = new HecTime();
            tempTime.setMinutes(this._recordData.startTime);
            tempTime.subtract(zeroInterval);
            tempTime.add(this.interval());
            for (int i2 = 0; i2 < this._recordData.arraySize; ++i2) {
                timeArrayIn.set(i2, tempTime);
                tempTime.add(this.interval());
            }
        } else {
            for (int i3 = 0; i3 < this._recordData.arraySize; ++i3) {
                timeArrayIn.elementAt(i3).setMinutes(this._recordData.times[i3]);
            }
        }
        HecTime oldTimeStart = new HecTime();
        oldTimeStart.setMinutes(this._recordData.startTime);
        oldTimeStart.subtract(zeroInterval);
        HecTime dataStart = new HecTime(oldTimeStart);
        dataStart.add(newInterval);
        int end = this.arrayEndTime().value();
        int start = this.arrayStartTime().value();
        int newArraySize = (end - start) / newInterval;
        HecTimeArray timeArrayOut = new HecTimeArray(newArraySize);
        doubleArrayContainer valuesOut = new doubleArrayContainer(newArraySize);
        HecTime tempTime = new HecTime(dataStart);
        for (i = 0; i < newArraySize; ++i) {
            timeArrayOut.set(i, tempTime);
            tempTime.add(newInterval);
        }
        for (i = 0; i < this._recordData.arraySize; ++i) {
            valuesIn[i] = this._recordData.arrayX[i];
        }
        this.convert(timeArrayIn, valuesIn, timeArrayOut, valuesOut, this.type(), newInterval);
        this._recordData.arraySize = valuesOut.length;
        this._recordData.times = new int[this._recordData.arraySize];
        this._recordData.arrayX = new double[this._recordData.arraySize];
        for (i = 0; i < this._recordData.arraySize; ++i) {
            this._recordData.times[i] = timeArrayOut.element(i).value();
            this._recordData.arrayX[i] = valuesOut.array[i];
        }
        this.setInterval(newInterval);
    }

    public void addConstant(double constant) {
        if (this._recordData == null || this._recordData.arrayX == null) {
            this.retrieveData(0);
        }
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            if (this._recordData.arrayX[i] == -3.4028234663852886E38) continue;
            int n = i;
            this._recordData.arrayX[n] = this._recordData.arrayX[n] + constant;
        }
    }

    public void subtractConstant(double constant) {
        if (this._recordData == null || this._recordData.arrayX == null) {
            this.retrieveData(0);
        }
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            if (this._recordData.arrayX[i] == -3.4028234663852886E38) continue;
            int n = i;
            this._recordData.arrayX[n] = this._recordData.arrayX[n] - constant;
        }
    }

    public void multiplyConstant(double constant) {
        if (this._recordData == null || this._recordData.arrayX == null) {
            this.retrieveData(0);
        }
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            if (this._recordData.arrayX[i] == -3.4028234663852886E38) continue;
            int n = i;
            this._recordData.arrayX[n] = this._recordData.arrayX[n] * constant;
        }
    }

    public void divideConstant(double constant) {
        if (constant == 0.0) {
            return;
        }
        if (this._recordData == null || this._recordData.arrayX == null) {
            this.retrieveData(0);
        }
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            if (this._recordData.arrayX[i] == -3.4028234663852886E38) continue;
            int n = i;
            this._recordData.arrayX[n] = this._recordData.arrayX[n] / constant;
        }
    }

    public double computeSum() {
        if (this._recordData == null || this._recordData.arrayX == null) {
            this.retrieveData(0);
        }
        double sum = 0.0;
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            if (this._recordData.arrayX[i] == -3.4028234663852886E38) continue;
            sum += this._recordData.arrayX[i];
        }
        return sum;
    }

    public int numberValidValues() {
        if (this._recordData == null || this._recordData.arrayX == null) {
            this.retrieveData(0);
        }
        int number = 0;
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            if (this._recordData.arrayX[i] == -3.4028234663852886E38) continue;
            ++number;
        }
        return number;
    }

    public double computeAverage() {
        double sum = this.computeSum();
        if (sum == -3.4028234663852886E38) {
            return -3.4028234663852886E38;
        }
        double number = this.numberValidValues();
        if (number == 0.0) {
            return -3.4028234663852886E38;
        }
        return sum / number;
    }

    public double maximum() {
        double maximum = -3.4028234663852886E38;
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            if (!(this._recordData.arrayX[i] > maximum)) continue;
            maximum = this._recordData.arrayX[i];
        }
        return maximum;
    }

    public double minimum() {
        double minimum = -3.4028234663852886E38;
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            if (this._recordData.arrayX[i] == -3.4028234663852886E38) continue;
            minimum = this._recordData.arrayX[i];
            break;
        }
        for (int j = i; j < this._recordData.arraySize; ++j) {
            if (this._recordData.arrayX[j] == -3.4028234663852886E38 || !(this._recordData.arrayX[j] < minimum)) continue;
            minimum = this._recordData.arrayX[j];
        }
        return minimum;
    }

    public int convertToMetric() {
        return this.convertUnitSystem(2);
    }

    public int convertToEnglish() {
        return this.convertUnitSystem(1);
    }

    public int addCurve(double[] value) {
        if (this._recordData == null || this._recordData.arrayX == null) {
            this.retrieveData(0);
        }
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            if (i >= value.length) {
                this._recordData.arrayX[i] = -3.4028234663852886E38;
                continue;
            }
            if (this._recordData.arrayX[i] == -3.4028234663852886E38 || value[i] == -3.4028234663852886E38) {
                this._recordData.arrayX[i] = -3.4028234663852886E38;
                continue;
            }
            int n = i;
            this._recordData.arrayX[n] = this._recordData.arrayX[n] + value[i];
        }
        if (value.length < this._recordData.arraySize) {
            return -1;
        }
        if (value.length > this._recordData.arraySize) {
            return -2;
        }
        return 0;
    }

    public int subtractCurve(double[] value) {
        if (this._recordData == null || this._recordData.arrayX == null) {
            this.retrieveData(0);
        }
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            if (i >= value.length) {
                this._recordData.arrayX[i] = -3.4028234663852886E38;
                continue;
            }
            if (this._recordData.arrayX[i] == -3.4028234663852886E38 || value[i] == -3.4028234663852886E38) {
                this._recordData.arrayX[i] = -3.4028234663852886E38;
                continue;
            }
            int n = i;
            this._recordData.arrayX[n] = this._recordData.arrayX[n] - value[i];
        }
        if (value.length < this._recordData.arraySize) {
            return -1;
        }
        if (value.length > this._recordData.arraySize) {
            return -2;
        }
        return 0;
    }

    public int multiplyCurve(double[] value) {
        if (this._recordData == null || this._recordData.arrayX == null) {
            this.retrieveData(0);
        }
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            if (i >= value.length) {
                this._recordData.arrayX[i] = -3.4028234663852886E38;
                continue;
            }
            if (this._recordData.arrayX[i] == -3.4028234663852886E38 || value[i] == -3.4028234663852886E38) {
                this._recordData.arrayX[i] = -3.4028234663852886E38;
                continue;
            }
            int n = i;
            this._recordData.arrayX[n] = this._recordData.arrayX[n] * value[i];
        }
        if (value.length < this._recordData.arraySize) {
            return -1;
        }
        if (value.length > this._recordData.arraySize) {
            return -2;
        }
        return 0;
    }

    public int divideCurve(double[] value) {
        if (this._recordData == null || this._recordData.arrayX == null) {
            this.retrieveData(0);
        }
        for (int i = 0; i < this._recordData.arraySize; ++i) {
            if (i >= value.length) {
                this._recordData.arrayX[i] = -3.4028234663852886E38;
                continue;
            }
            if (value[i] == 0.0) {
                this._recordData.arrayX[i] = -3.4028234663852886E38;
                continue;
            }
            if (this._recordData.arrayX[i] == -3.4028234663852886E38 || value[i] == -3.4028234663852886E38) {
                this._recordData.arrayX[i] = -3.4028234663852886E38;
                continue;
            }
            int n = i;
            this._recordData.arrayX[n] = this._recordData.arrayX[n] / value[i];
        }
        if (value.length < this._recordData.arraySize) {
            return -1;
        }
        if (value.length > this._recordData.arraySize) {
            return -2;
        }
        return 0;
    }
}

