/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.dss;

import hec.data.Units;
import hec.heclib.dss.AbstractDssDataManager;
import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSErrorMessage;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.DssDataManager;
import hec.heclib.dss.HecDSSFileData;
import hec.heclib.dss.HecDSSFileDataManager;
import hec.heclib.dss.HecDSSRecordInfo;
import hec.heclib.dss.HecDSSUtilities;
import hec.heclib.dss.HecDataManager;
import hec.heclib.dss.HecDssArray;
import hec.heclib.dss.HecDssFileStore;
import hec.heclib.dss.HecDssImage;
import hec.heclib.dss.HecDssText;
import hec.heclib.dss.HecDssTin;
import hec.heclib.dss.HecPairedData;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.grid.GridData;
import hec.heclib.grid.GridInfo;
import hec.heclib.grid.GriddedData;
import hec.heclib.util.HecTime;
import hec.heclib.util.Heclib;
import hec.heclib.util.stringContainer;
import hec.io.ArrayContainer;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.DssFileContainer;
import hec.io.GridContainer;
import hec.io.PairedDataContainer;
import hec.io.TextContainer;
import hec.io.TimeSeriesCollectionContainer;
import hec.io.TimeSeriesContainer;
import hec.io.TinContainer;
import hec.util.PhotoViewerInfo;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;

public class LocalDssDataManager
extends AbstractDssDataManager {
    public LocalDssDataManager() {
        super(new HecDSSUtilities());
    }

    @Override
    public void setMessageLevel(int level) {
        HecDataManager.setMessageLevel(level);
    }

    @Override
    public int getMessageLevel() {
        return HecDataManager.getMessageLevel();
    }

    @Override
    public void setUnit(int unit) {
        HecDSSUtilities.setUnit(unit);
    }

    @Override
    public int fileAccessInfo(int[] accessMode, int[] numberAccesses, int[] numberWrites, int[] pidsArray, int[] modesArray, int[] numberPids) {
        return this.dataManager().fileAccessInfo(accessMode, numberAccesses, numberWrites, pidsArray, modesArray, numberPids);
    }

    @Override
    public List<String> getLastDeletePathnames() {
        return this.dataManager().getLastDeletePathnames();
    }

    @Override
    public HecDSSUtilities dataManager() {
        return (HecDSSUtilities)super.dataManager();
    }

    @Override
    public List<HecDSSFileData> DssFileManagerStatus() {
        ArrayList<HecDSSFileData> output = new ArrayList<HecDSSFileData>();
        HecDSSFileDataManager.DssFileManagerStatus(output);
        return output;
    }

    @Override
    public int recordsUpdated(long startTime, List<String> pathnames, List<Long> updateTimes, List<Integer> recordTypes) {
        return this.dataManager().recordsUpdated(startTime, pathnames, updateTimes, recordTypes);
    }

    @Override
    public int checkForError() {
        if (this.getDssFileVersion() == 7) {
            return this.dataManager().checkForError();
        }
        boolean err = this.dataManager().checkForSevereDssError();
        if (err) {
            return 4;
        }
        return 0;
    }

    @Override
    public void clearSevereError() {
        if (this.getDssFileVersion() == 7) {
            this.dataManager().clearError();
        }
        this.dataManager().clearSevereError();
    }

    @Override
    public DSSErrorMessage lastErrorMessage() {
        DSSErrorMessage errorMessage = null;
        if (this.dataManager().getDssFileVersion() == 7) {
            errorMessage = new DSSErrorMessage();
            Heclib.zerrorGet(errorMessage);
        } else if (this.dataManager().getDssFileVersion() == 6) {
            errorMessage = this.dataManager().lastSevereErrorMessage();
        } else {
            errorMessage = new DSSErrorMessage();
            Heclib.zerrorGet(errorMessage);
            if (errorMessage.severity > 0) {
                return errorMessage;
            }
        }
        return errorMessage;
    }

    @Override
    public void getProcessStatus(int[] numberRecs, int[] currentRec) {
        this.dataManager().getProcessStatus(numberRecs, currentRec);
    }

    @Override
    public boolean cleanDSSFileName(String inName, stringContainer outName) {
        return HecDSSUtilities.cleanDSSFileName(inName, outName);
    }

    @Override
    public int copyFile(DssDataManager dataManager, String secondDSSFilename) {
        if (dataManager instanceof LocalDssDataManager) {
            LocalDssDataManager combinedDataManager = (LocalDssDataManager)dataManager;
            return this.dataManager().copyFile(combinedDataManager.dataManager());
        }
        return -1;
    }

    @Override
    public int copyRecordsFrom(DssDataManager toDataManager, String toDSSFilename, List<String> pathnameList) {
        return this.dataManager().copyRecordsFrom(((LocalDssDataManager)toDataManager).dataManager(), pathnameList);
    }

    @Override
    public int copyRecordsInto(DssDataManager fromDataManager, String fromDSSFilename, List<String> pathnameList) {
        return this.dataManager().copyRecordsInto(((LocalDssDataManager)fromDataManager).dataManager(), pathnameList);
    }

    @Override
    public int delete(List<String> pathnameList) {
        return this.dataManager().delete(pathnameList);
    }

    @Override
    public boolean doesDSSFileExist(String DSSFileName) {
        return HecDSSUtilities.doesDSSFileExist(DSSFileName);
    }

    @Override
    public int readData(DataReference dataReference, TimeSeriesContainer timeSeriesContainer, boolean trimMissing) {
        HecTime start = new HecTime();
        HecTime end = new HecTime();
        TimeZone timeZone = this.getTimeZone();
        if (timeZone != null) {
            timeSeriesContainer.timeZoneID = timeZone.getID();
            timeSeriesContainer.timeZoneRawOffset = timeZone.getRawOffset();
        }
        int status = 0;
        HecTimeSeries object = this.dataManager().createTimeSeriesObject(dataReference.getPath());
        if (object != null) {
            dataReference.getTimeWindow(object, start, end);
            object.setTimeWindow(start, end);
            timeSeriesContainer.fullName = dataReference.pathname(0);
            status = object.read(timeSeriesContainer, trimMissing);
            if (timeSeriesContainer.timeZoneID != null) {
                timeSeriesContainer.timeZoneID = timeSeriesContainer.timeZoneID.trim();
                if (timeSeriesContainer.timeZoneID.isEmpty()) {
                    timeSeriesContainer.timeZoneID = null;
                }
            }
        } else {
            status = -2;
        }
        if (status == 0) {
            if (timeSeriesContainer.numberValues <= 0) {
                status = -1;
            }
            if (this.getDisplayUnitSystem() != 3) {
                Units.convertUnits(timeSeriesContainer, this.getDisplayUnitSystem());
            }
        }
        return status;
    }

    @Override
    public int readData(DataReference dataReference, TimeSeriesCollectionContainer timeSeriesCollectionContainer, boolean trimMissing) {
        HecTime start = new HecTime();
        HecTime end = new HecTime();
        int status = 0;
        HecTimeSeries object = this.dataManager().createTimeSeriesObject(dataReference.getPath());
        if (object != null) {
            dataReference.getTimeWindow(object, start, end);
            timeSeriesCollectionContainer.fileName = dataReference.getFilename();
            object.setTimeWindow(start, end);
            timeSeriesCollectionContainer.fullName = dataReference.pathname(0);
            status = object.read(timeSeriesCollectionContainer, trimMissing);
        } else {
            status = -2;
        }
        if (status == 0 && this.getDisplayUnitSystem() != 3) {
            for (TimeSeriesContainer tsCont : timeSeriesCollectionContainer.get()) {
                Units.convertUnits(tsCont, this.getDisplayUnitSystem());
            }
        }
        return status;
    }

    @Override
    public int readData(DataReference dataReference, PairedDataContainer pairedDataContainer) {
        int status = 0;
        HecPairedData object = this.dataManager().createPairedDataObject(dataReference.getPath());
        status = object != null ? object.read(pairedDataContainer) : -2;
        if (status == 0) {
            if (pairedDataContainer.numberOrdinates <= 0) {
                status = -1;
            }
            if (this.getDisplayUnitSystem() != 3) {
                Units.convertUnits(pairedDataContainer, this.getDisplayUnitSystem());
            }
        }
        return status;
    }

    @Override
    public int readData(DataReference dataReference, TextContainer textContainer) {
        HecDssText object = this.dataManager().createTextObject(dataReference.getPath());
        if (object != null) {
            int status = object.read(textContainer);
            return status;
        }
        return -1;
    }

    @Override
    public int readData(DataReference dataReference, ArrayContainer arrayContainer) {
        HecDssArray object = this.dataManager().createArrayObject(dataReference.getPath());
        if (object != null) {
            int status = object.read(arrayContainer);
            if (status == 0) {
                return 1;
            }
            return status;
        }
        return -1;
    }

    @Override
    public int readData(DataReference dataReference, DssFileContainer fileContainer) {
        HecDssFileStore dataManager = new HecDssFileStore();
        if (dataReference.getFilename().length() == 0) {
            dataManager.setDSSFileName(this.dataManager().DSSFileName());
        } else {
            dataManager.setDSSFileName(dataReference.getFilename());
        }
        dataManager.setPathname(dataReference.getPathname());
        int istat = dataManager.read(fileContainer);
        return istat;
    }

    @Override
    public boolean getRecordInfo(DataReference dataReference, HecDSSRecordInfo recordInfo) {
        String path = dataReference.pathname(0);
        String filename = dataReference.getFilename();
        this.dataManager().setPathname(path);
        this.dataManager().setDSSFileName(filename);
        return this.dataManager().getRecordInfo(recordInfo);
    }

    @Override
    public int writeData(TextContainer textContainer) {
        HecDssText object = this.dataManager().createTextObject(textContainer.fullName);
        int status = object != null ? object.write(textContainer) : -1;
        if (status >= 0) {
            textContainer.modified = false;
        }
        return status;
    }

    @Override
    public List readGriddedData(DSSIdentifier dssId) {
        if (dssId == null) {
            return null;
        }
        DSSPathname pathName = new DSSPathname(dssId.getDSSPath());
        HecTime time = new HecTime(pathName.dPart());
        dssId.setStartTime(time);
        time = new HecTime(pathName.ePart());
        dssId.setEndTime(time);
        List gridVector = null;
        gridVector = this.getGriddedDataLocal(dssId);
        if (gridVector == null) {
            return null;
        }
        gridVector.add(pathName);
        return gridVector;
    }

    @Override
    protected List readTinData(DSSIdentifier dssId, TinContainer tinContainer) {
        if (dssId == null) {
            return null;
        }
        DSSPathname pathName = new DSSPathname(dssId.getDSSPath());
        Vector<DSSPathname> tinVector = null;
        HecDssTin tinMgr = new HecDssTin();
        tinMgr.setDSSFileName(dssId.getFileName());
        tinMgr.setPathname(pathName.pathname());
        if (tinMgr.read(tinContainer, true) == 0) {
            tinVector = new Vector<DSSPathname>();
            tinVector.addElement((DSSPathname)((Object)tinContainer));
        }
        if (tinVector == null) {
            return null;
        }
        tinVector.addElement(pathName);
        return tinVector;
    }

    protected List getGriddedDataLocal(DSSIdentifier dssId) {
        if (dssId == null) {
            return null;
        }
        String gridFile = dssId.getFileName();
        GriddedData gd = new GriddedData();
        gd.setDSSFileName(gridFile);
        String pathName = dssId.getDSSPath();
        if (pathName.contains("/")) {
            gd.setPathname(pathName);
        } else {
            gd.setPathnameParts(pathName);
        }
        GridData gridData = new GridData();
        int[] stat = new int[1];
        GridInfo gridInfo = gd.retrieveGriddedData(true, gridData, stat);
        gd.done();
        if (stat[0] < 0 || gridInfo == null) {
            System.out.println("Error in Retrieving Gridded Data");
            System.out.println("Trying to read file: " + dssId.getFileName());
            System.out.println("Trying to read Pathname: " + dssId.getDSSPath());
            return null;
        }
        Vector<Serializable> results = new Vector<Serializable>(2);
        results.addElement(gridInfo);
        results.addElement(gridData);
        return results;
    }

    @Override
    public String[] getCatalog(boolean sorted, String pathWithWildChars) {
        return this.dataManager().getCatalog(sorted, pathWithWildChars);
    }

    @Override
    public CondensedReference[] getCondensedCatalog(String pathWithWildChars) {
        return this.dataManager().getCondensedCatalog(pathWithWildChars);
    }

    @Override
    public int convertVersion(String convertFileName) {
        return this.dataManager().convertVersion(convertFileName);
    }

    @Override
    public int undelete(List<String> pathnames) {
        return this.dataManager().undelete(pathnames);
    }

    @Override
    public int undoLastDelete() {
        return this.dataManager().undoLastDelete();
    }

    @Override
    public int writeData(PairedDataContainer pairedDataContainer) {
        int status;
        if (pairedDataContainer.dataType >= 90 && pairedDataContainer.dataType <= 92) {
            HecDssArray arrayData = new HecDssArray();
            arrayData.setDSSFileName(this.dataManager().DSSFileName());
            status = arrayData.write(pairedDataContainer);
        } else {
            HecPairedData pairedData = new HecPairedData();
            pairedData.setDSSFileName(this.dataManager().DSSFileName());
            status = pairedData.write(pairedDataContainer);
        }
        if (status >= 0) {
            pairedDataContainer.modified = false;
        }
        return status;
    }

    @Override
    public int writeData(GridContainer gridContainer) {
        int status = -1;
        GridData gridData = gridContainer.getGridData();
        GridInfo gridInfo = gridData.getGridInfo();
        HecTime startTime = new HecTime();
        HecTime endTime = new HecTime();
        startTime.set(gridInfo.getStartTime());
        endTime.set(gridInfo.getEndTime());
        GriddedData griddedData = new GriddedData();
        griddedData.setDSSFileName(this.dataManager().DSSFileName());
        griddedData.setPathname(gridContainer.fullName);
        griddedData.setTimeWindow(startTime, endTime);
        status = griddedData.storeGriddedData(gridInfo, gridData);
        return status;
    }

    @Override
    public int writeLocation(DataContainer dataContainer) {
        return this.dataManager().zlocationStore(dataContainer);
    }

    @Override
    public int writeData(TimeSeriesContainer timeSeriesContainer, int regularStoreMethod, int irregularStoreMethod) {
        HecTimeSeries timeSeries = new HecTimeSeries();
        timeSeries.setDSSFileName(this.dataManager().DSSFileName());
        timeSeries.setRegularIntervalStorePlan(regularStoreMethod);
        timeSeries.setIrregularIntervalInFlag(irregularStoreMethod);
        int status = timeSeries.write(timeSeriesContainer);
        timeSeries.done();
        if (status >= 0) {
            timeSeriesContainer.modified = false;
        }
        return status;
    }

    @Override
    public int writeFile(File file, DSSPathname pathname, boolean imageFile) throws Exception {
        HecDssFileStore fileStore = imageFile ? new HecDssImage() : new HecDssFileStore();
        fileStore.setDSSFileName(this.dataManager().DSSFileName());
        int status = fileStore.write(file, pathname);
        return status;
    }

    @Override
    public int exportFile(String pathname, File file, String directory) throws Exception {
        HecDssFileStore fileStore = new HecDssFileStore();
        fileStore.setDSSFileName(this.dataManager().DSSFileName());
        fileStore.setPathname(pathname);
        int status = fileStore.export(file, directory);
        return status;
    }

    @Override
    public int readImage(DataReference dataSet, PhotoViewerInfo info) throws Exception {
        HecDssImage dssImage = new HecDssImage();
        dssImage.setDSSFileName(this.dataManager().DSSFileName());
        dssImage.setPathname(dataSet.getPathname());
        return dssImage.read(info);
    }

    @Override
    public int readLocation(DataContainer dataContainer) throws Exception {
        return this.dataManager().zlocationRetrieve(dataContainer);
    }
}

