/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.grid;

import hec.heclib.grid.AlbersInfoFlat;
import hec.heclib.grid.GridInfo;
import hec.heclib.grid.GridInfoFlat;
import hec.heclib.util.Heclib;
import java.io.BufferedWriter;
import java.io.Serializable;
import rma.util.RMAIO;

public class AlbersInfo
extends GridInfo
implements Serializable {
    int _projectionDatum;
    String _projectionUnits = new String();
    float _firstStandardParallel;
    float _secondStandardParallel;
    float _centralMeridian;
    float _latitudeOfProjectionOrigin;
    float _falseEasting;
    float _falseNorthing;
    float _xCoordOfGridCellZero;
    float _yCoordOfGridCellZero;

    public AlbersInfo() {
        this._gridType = 420;
        this._infoSize = this._gridInfoSize + 40;
        this._projectionDatum = 0;
        this._firstStandardParallel = -3.4028235E38f;
        this._secondStandardParallel = -3.4028235E38f;
        this._centralMeridian = -3.4028235E38f;
        this._latitudeOfProjectionOrigin = -3.4028235E38f;
        this._falseEasting = -3.4028235E38f;
        this._falseNorthing = -3.4028235E38f;
        this._xCoordOfGridCellZero = -3.4028235E38f;
        this._yCoordOfGridCellZero = -3.4028235E38f;
    }

    public AlbersInfo(AlbersInfo ai) {
        super(ai);
        this._infoSize = this._gridInfoSize + 40;
        this._projectionDatum = ai._projectionDatum;
        this._projectionUnits = ai._projectionUnits;
        this._firstStandardParallel = ai._firstStandardParallel;
        this._secondStandardParallel = ai._secondStandardParallel;
        this._centralMeridian = ai._centralMeridian;
        this._latitudeOfProjectionOrigin = ai._latitudeOfProjectionOrigin;
        this._falseEasting = ai._falseEasting;
        this._falseNorthing = ai._falseNorthing;
        this._xCoordOfGridCellZero = ai._xCoordOfGridCellZero;
        this._yCoordOfGridCellZero = ai._yCoordOfGridCellZero;
    }

    public int getProjectionDatum() {
        return this._projectionDatum;
    }

    public void setProjectionDatum(int projectionDatum) {
        this._projectionDatum = projectionDatum;
    }

    public String getProjectionUnits() {
        return this._projectionUnits;
    }

    public void setProjectionUnits(String units) {
        this._projectionUnits = units;
    }

    public float getFirstStandardParallel() {
        return this._firstStandardParallel;
    }

    public float getSecondStandardParallel() {
        return this._secondStandardParallel;
    }

    public void setStandardParallels(float first, float second) {
        this._firstStandardParallel = first;
        this._secondStandardParallel = second;
    }

    public float getCentralMeridian() {
        return this._centralMeridian;
    }

    public void setCentralMeridian(float meridian) {
        this._centralMeridian = meridian;
    }

    public float getLatitudeOfProjectionOrigin() {
        return this._latitudeOfProjectionOrigin;
    }

    public void setLatitudeOfProjectionOrigin(float latitude) {
        this._latitudeOfProjectionOrigin = latitude;
    }

    public float getFalseEasting() {
        return this._falseEasting;
    }

    public float getFalseNorthing() {
        return this._falseNorthing;
    }

    public void setFalseEastingAndNorthing(float falseEasting, float falseNorthing) {
        this._falseEasting = falseEasting;
        this._falseNorthing = falseNorthing;
    }

    public float getXCoordOfGridCellZero() {
        return this._xCoordOfGridCellZero;
    }

    public float getYCoordOfGridCellZero() {
        return this._yCoordOfGridCellZero;
    }

    public void setCoordOfGridCellZero(float x, float y) {
        this._xCoordOfGridCellZero = x;
        this._yCoordOfGridCellZero = y;
    }

    @Override
    public String toString() {
        Object theString = "\n = = = AlbersInfo = = =\n";
        boolean isSHG = false;
        if (this._projectionDatum == 2 && AlbersInfo.isMeters(this._projectionUnits) && this._firstStandardParallel == 29.5f && this._secondStandardParallel == 45.5f && this._centralMeridian == -96.0f && this._latitudeOfProjectionOrigin == 23.0f && this._falseEasting == 0.0f && this._falseNorthing == 0.0f && (double)this._xCoordOfGridCellZero == 0.0 && this._yCoordOfGridCellZero == 0.0f) {
            isSHG = true;
        }
        if (isSHG) {
            theString = (String)theString + "Standard Hydrologic Grid Spatial Reference\n";
        }
        if (!isSHG || this._verbose) {
            String temp;
            switch (this._projectionDatum) {
                case 2: {
                    temp = "NAD 83";
                    break;
                }
                case 1: {
                    temp = "NAD 27";
                    break;
                }
                default: {
                    temp = "UNDEFINED DATUM";
                }
            }
            theString = (String)theString + "Projection Datum: " + temp;
            if (this._verbose) {
                theString = (String)theString + " (" + this._projectionDatum + ")";
            }
            theString = (String)theString + "\n";
            theString = (String)theString + "Projection Units: " + this._projectionUnits + "\n";
            theString = (String)theString + "First Standard Parallel: " + this._firstStandardParallel + "\n";
            theString = (String)theString + "Second Standard Parallel: " + this._secondStandardParallel + "\n";
            theString = (String)theString + "Central Meridian: " + this._centralMeridian + "\n";
            theString = (String)theString + "Latitude Of ProjectionOrigin: " + this._latitudeOfProjectionOrigin + "\n";
            theString = (String)theString + "False Easting: " + this._falseEasting + "\n";
            theString = (String)theString + "False Northing: " + this._falseNorthing + "\n";
            theString = (String)theString + "XCoord Of Grid Cell Zero: " + this._xCoordOfGridCellZero + "\n";
            theString = (String)theString + "YCoord Of Grid Cell Zero: " + this._yCoordOfGridCellZero + "\n";
        }
        theString = (String)theString + "=========================================================";
        return super.toString() + (String)theString;
    }

    @Override
    public void show(BufferedWriter out) {
        RMAIO.fout(out, " = = = AlbersInfo = = =");
        RMAIO.fout(out, "Projection Datum: " + this._projectionDatum);
        RMAIO.fout(out, "Projection Units: " + this._projectionUnits);
        RMAIO.fout(out, "First Standard Parallel: " + this._firstStandardParallel);
        RMAIO.fout(out, "Second Standard Parallel: " + this._secondStandardParallel);
        RMAIO.fout(out, "Central Meridian: " + this._centralMeridian);
        RMAIO.fout(out, "Latitude Of ProjectionOrigin: " + this._latitudeOfProjectionOrigin);
        RMAIO.fout(out, "False Easting: " + this._falseEasting);
        RMAIO.fout(out, "False Northing: " + this._falseNorthing);
        RMAIO.fout(out, "XCoord Of Grid Cell Zero: " + this._xCoordOfGridCellZero);
        RMAIO.fout(out, "YCoord Of Grid Cell Zero: " + this._yCoordOfGridCellZero);
        RMAIO.fout(out, "=========================================================");
        super.show(out);
    }

    @Override
    public String getSpatialReferenceSystem() {
        boolean isSHG = false;
        boolean isMeters = AlbersInfo.isMeters(this._projectionUnits);
        if (this._projectionDatum == 2 && isMeters && this._firstStandardParallel == 29.5f && this._secondStandardParallel == 45.5f && this._centralMeridian == -96.0f && this._latitudeOfProjectionOrigin == 23.0f && this._falseEasting == 0.0f && this._falseNorthing == 0.0f && (double)this._xCoordOfGridCellZero == 0.0 && this._yCoordOfGridCellZero == 0.0f) {
            isSHG = true;
        }
        if (isSHG) {
            return "PROJCS[\"USA_Contiguous_Albers_Equal_Area_Conic_USGS_version\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-96.0],PARAMETER[\"Standard_Parallel_1\",29.5],PARAMETER[\"Standard_Parallel_2\",45.5],PARAMETER[\"Latitude_Of_Origin\",23.0],UNIT[\"Meter\",1.0]]";
        }
        return "";
    }

    private static boolean isMeters(String _projectionUnits) {
        String projectionUnits = _projectionUnits.toLowerCase();
        return projectionUnits.equals("meters") || projectionUnits.equals("meter") || projectionUnits.equals("m") || projectionUnits.equals("metres") || projectionUnits.equals("metre");
    }

    public int setProjectionInfo(int projectionDatum, String projectionUnits, float firstStandardParallel, float secondStandardParallel, float centralMeridian, float latitudeOfProjectionOrigin, float falseEasting, float falseNorthing, float xCoordOfGridCellZero, float yCoordOfGridCellZero) {
        this._projectionDatum = projectionDatum;
        this._projectionUnits = projectionUnits;
        this._firstStandardParallel = firstStandardParallel;
        this._secondStandardParallel = secondStandardParallel;
        this._centralMeridian = centralMeridian;
        this._latitudeOfProjectionOrigin = latitudeOfProjectionOrigin;
        this._falseEasting = falseEasting;
        this._falseNorthing = falseNorthing;
        this._xCoordOfGridCellZero = xCoordOfGridCellZero;
        this._yCoordOfGridCellZero = yCoordOfGridCellZero;
        return 0;
    }

    public void makeGridInfoFlat(AlbersInfoFlat a) {
        super.loadFlatData(a);
        this.loadFlatData(a);
    }

    public int loadFlatData(AlbersInfoFlat a) {
        a._projectionDatum = this._projectionDatum;
        Heclib.StringHol(this._projectionUnits, this._projectionUnits.length(), a._projectionUnits);
        a._firstStandardParallel = this._firstStandardParallel;
        a._secondStandardParallel = this._secondStandardParallel;
        a._centralMeridian = this._centralMeridian;
        a._latitudeOfProjectionOrigin = this._latitudeOfProjectionOrigin;
        a._falseEasting = this._falseEasting;
        a._falseNorthing = this._falseNorthing;
        a._xCoordOfGridCellZero = this._xCoordOfGridCellZero;
        a._yCoordOfGridCellZero = this._yCoordOfGridCellZero;
        return 0;
    }

    @Override
    public int convertToGridInfo(GridInfoFlat a1) {
        if (a1.getClass() == AlbersInfoFlat.class) {
            return this.convertToGridInfo((AlbersInfoFlat)a1);
        }
        return super.convertToGridInfo(a1);
    }

    public int convertToGridInfo(AlbersInfoFlat a1) {
        super.convertToGridInfo(a1);
        this._infoSize = this._gridInfoSize + 40;
        this._projectionDatum = a1._projectionDatum;
        this._projectionUnits = Heclib.holString(a1._projectionUnits, 12);
        this._firstStandardParallel = a1._firstStandardParallel;
        this._secondStandardParallel = a1._secondStandardParallel;
        this._centralMeridian = a1._centralMeridian;
        this._latitudeOfProjectionOrigin = a1._latitudeOfProjectionOrigin;
        this._falseEasting = a1._falseEasting;
        this._falseNorthing = a1._falseNorthing;
        this._xCoordOfGridCellZero = a1._xCoordOfGridCellZero;
        this._yCoordOfGridCellZero = a1._yCoordOfGridCellZero;
        return 0;
    }

    public int convertToAlbersInfo(AlbersInfoFlat a1) {
        super.convertToGridInfo(a1);
        this._infoSize = this._gridInfoSize + 40;
        this._projectionDatum = a1._projectionDatum;
        this._projectionUnits = Heclib.holString(a1._projectionUnits, 12);
        this._firstStandardParallel = a1._firstStandardParallel;
        this._secondStandardParallel = a1._secondStandardParallel;
        this._centralMeridian = a1._centralMeridian;
        this._latitudeOfProjectionOrigin = a1._latitudeOfProjectionOrigin;
        this._falseEasting = a1._falseEasting;
        this._falseNorthing = a1._falseNorthing;
        this._xCoordOfGridCellZero = a1._xCoordOfGridCellZero;
        this._yCoordOfGridCellZero = a1._yCoordOfGridCellZero;
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AlbersInfo)) {
            return false;
        }
        AlbersInfo ai = (AlbersInfo)obj;
        return this._projectionDatum == ai._projectionDatum && this._projectionUnits.equals(ai._projectionUnits) && this._firstStandardParallel == ai._firstStandardParallel && this._secondStandardParallel == ai._secondStandardParallel && this._centralMeridian == ai._centralMeridian && this._latitudeOfProjectionOrigin == ai._latitudeOfProjectionOrigin && this._falseEasting == ai._falseEasting && this._falseNorthing == ai._falseNorthing && this._xCoordOfGridCellZero == ai._xCoordOfGridCellZero && this._yCoordOfGridCellZero == ai._yCoordOfGridCellZero;
    }

    public void set(AlbersInfo ai) {
        super.set(ai);
        this._projectionDatum = ai._projectionDatum;
        this._projectionUnits = ai._projectionUnits;
        this._firstStandardParallel = ai._firstStandardParallel;
        this._secondStandardParallel = ai._secondStandardParallel;
        this._centralMeridian = ai._centralMeridian;
        this._latitudeOfProjectionOrigin = ai._latitudeOfProjectionOrigin;
        this._falseEasting = ai._falseEasting;
        this._falseNorthing = ai._falseNorthing;
        this._xCoordOfGridCellZero = ai._xCoordOfGridCellZero;
        this._yCoordOfGridCellZero = ai._yCoordOfGridCellZero;
    }
}

