/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.grid;

import hec.heclib.grid.GridInfoFlat;

public class AlbersInfoFlat
extends GridInfoFlat {
    int _projectionDatum;
    int[] _projectionUnits = new int[3];
    float _firstStandardParallel = -3.4028235E38f;
    float _secondStandardParallel = -3.4028235E38f;
    float _centralMeridian = -3.4028235E38f;
    float _latitudeOfProjectionOrigin = -3.4028235E38f;
    float _falseEasting = -3.4028235E38f;
    float _falseNorthing = -3.4028235E38f;
    float _xCoordOfGridCellZero = -3.4028235E38f;
    float _yCoordOfGridCellZero = -3.4028235E38f;

    public AlbersInfoFlat() {
        this._projectionDatum = Integer.MIN_VALUE;
        for (int i = 0; i < 3; ++i) {
            this._projectionUnits[i] = 0;
        }
        this._infoFlatSize = this.size();
    }

    @Override
    public int size() {
        return super.size() + 48;
    }

    @Override
    public void flatten(int[] array) {
        super.flatten(array);
        int pos = super.size() / 4;
        array[pos++] = this._projectionDatum;
        array[pos++] = this._projectionUnits[0];
        array[pos++] = this._projectionUnits[1];
        array[pos++] = this._projectionUnits[2];
        array[pos++] = Float.floatToIntBits(this._firstStandardParallel);
        array[pos++] = Float.floatToIntBits(this._secondStandardParallel);
        array[pos++] = Float.floatToIntBits(this._centralMeridian);
        array[pos++] = Float.floatToIntBits(this._latitudeOfProjectionOrigin);
        array[pos++] = Float.floatToIntBits(this._falseEasting);
        array[pos++] = Float.floatToIntBits(this._falseNorthing);
        array[pos++] = Float.floatToIntBits(this._xCoordOfGridCellZero);
        array[pos++] = Float.floatToIntBits(this._yCoordOfGridCellZero);
    }

    @Override
    public boolean unflatten(int[] array) {
        boolean ok = super.unflatten(array);
        if (!ok) {
            return false;
        }
        int pos = super.size() / 4;
        if (pos + 11 >= array.length) {
            return false;
        }
        pos = array.length - 12;
        this._projectionDatum = array[pos++];
        this._projectionUnits[0] = array[pos++];
        this._projectionUnits[1] = array[pos++];
        this._projectionUnits[2] = array[pos++];
        this._firstStandardParallel = Float.intBitsToFloat(array[pos++]);
        this._secondStandardParallel = Float.intBitsToFloat(array[pos++]);
        this._centralMeridian = Float.intBitsToFloat(array[pos++]);
        this._latitudeOfProjectionOrigin = Float.intBitsToFloat(array[pos++]);
        this._falseEasting = Float.intBitsToFloat(array[pos++]);
        this._falseNorthing = Float.intBitsToFloat(array[pos++]);
        this._xCoordOfGridCellZero = Float.intBitsToFloat(array[pos++]);
        this._yCoordOfGridCellZero = Float.intBitsToFloat(array[pos++]);
        return true;
    }

    @Override
    public void show() {
    }
}

