/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.grid;

import hec.heclib.util.shortArrayContainer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import rma.util.ByteConversion;

public class DataCompression {
    public boolean DEBUG = false;

    public int compress(float[] arrayin, int sizein, float compressionScaleFactor, float compressionBase, short[] arrayout, int[] sizeout) {
        int count;
        short[] shortval = new short[sizein];
        int newcount = 0;
        int totalzeros = 0;
        int totalones = 0;
        int totalvals = 0;
        for (count = 0; count < sizein; ++count) {
            int longval;
            shortval[count] = arrayin[count] < compressionBase ? -1 : ((longval = (int)((double)((arrayin[count] - compressionBase) * compressionScaleFactor) + 0.5)) > 32768 ? -1 : (short)longval);
        }
        count = 0;
        while (count < sizein) {
            int repeatvals;
            if (shortval[count] == 0) {
                repeatvals = 0;
                while (count < sizein && shortval[count] == 0) {
                    ++repeatvals;
                    ++count;
                }
                if (repeatvals < 16000) {
                    totalzeros += repeatvals;
                    arrayout[newcount] = (short)(repeatvals | 0x8000);
                } else {
                    while (repeatvals >= 16000) {
                        totalzeros += 16000;
                        arrayout[newcount] = -16768;
                        ++newcount;
                        repeatvals -= 16000;
                    }
                    totalzeros += repeatvals;
                    arrayout[newcount] = (short)(repeatvals | 0x8000);
                }
            } else if (shortval[count] == -1) {
                repeatvals = 0;
                while (count < sizein && shortval[count] == -1) {
                    ++repeatvals;
                    ++count;
                }
                if (repeatvals < 16000) {
                    totalones += repeatvals;
                    arrayout[newcount] = (short)(repeatvals | 0xC000);
                } else {
                    while (repeatvals >= 16000) {
                        totalones += 16000;
                        arrayout[newcount] = -384;
                        ++newcount;
                        repeatvals -= 16000;
                    }
                    totalones += repeatvals;
                    arrayout[newcount] = (short)(repeatvals | 0xC000);
                }
            } else {
                arrayout[newcount] = shortval[count];
                ++count;
                ++totalvals;
            }
            ++newcount;
        }
        sizeout[0] = newcount * 2;
        int totalsize = totalzeros + totalones + totalvals;
        return 0;
    }

    public int uncompress(short[] arrayin, int bytesin, double compressionScaleFactor, double compressionBase, float[] arrayout, int[] sizeout) {
        int count;
        int totalzeros = 0;
        int totalones = 0;
        int totalvals = 0;
        int newcount = 0;
        int sizein = bytesin / 2;
        for (count = 0; count < sizein; ++count) {
            int k;
            short repeatvals;
            if ((arrayin[count] & 0x8000) == 0) {
                arrayout[newcount] = arrayin[count];
                ++totalvals;
                ++newcount;
                continue;
            }
            if ((arrayin[count] & 0xC000) == 49152) {
                repeatvals = (short)(arrayin[count] & 0x3FFF);
                totalones += repeatvals;
                for (k = newcount; k < newcount + repeatvals; ++k) {
                    arrayout[k] = -1.0f;
                }
                newcount += repeatvals;
                continue;
            }
            if ((arrayin[count] & 0xC000) != 32768) continue;
            repeatvals = (short)(arrayin[count] & 0x3FFF);
            totalzeros += repeatvals;
            for (k = newcount; k < newcount + repeatvals; ++k) {
                arrayout[k] = 0.0f;
            }
            newcount += repeatvals;
        }
        sizeout[0] = newcount;
        int totalsize = totalzeros + totalones + totalvals;
        for (count = 0; count < newcount; ++count) {
            arrayout[count] = arrayout[count] < 0.0f ? -3.4028235E38f : (float)((double)arrayout[count] / compressionScaleFactor + compressionBase);
        }
        int istat = 0;
        return istat;
    }

    public byte[] switchEndianByteArray(byte[] B, int byteSize) {
        byte[] tempByte = new byte[byteSize];
        for (int i = 0; i < B.length; i += byteSize) {
            int j;
            for (j = 0; j < byteSize; ++j) {
                tempByte[j] = B[i + j];
            }
            for (j = 0; j < byteSize; ++j) {
                B[i + j] = tempByte[byteSize - j - 1];
            }
        }
        return B;
    }

    public float byteArrayToFloat(byte[] B) {
        ByteBuffer b = ByteBuffer.wrap(B);
        float f = b.getFloat();
        return f;
    }

    public float[] byteArrayToFloatArray(byte[] B) {
        float[] F = new float[B.length / 4];
        byte[] b = new byte[4];
        for (int i = 0; i < B.length; i += 4) {
            float f;
            for (int j = 0; j < 4; ++j) {
                b[j] = B[i + j];
            }
            F[i / 4] = f = this.byteArrayToFloat(b);
        }
        return F;
    }

    public byte[] floatArrayToByteArray(float[] F) {
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        DataOutputStream doutstream = new DataOutputStream(bytestream);
        for (int i = 0; i < F.length; ++i) {
            float outValue = F[i];
            if (outValue == -3.4028235E38f) {
                outValue = -1.0E38f;
            }
            try {
                doutstream.writeFloat(outValue);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            doutstream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] B = bytestream.toByteArray();
        return B;
    }

    public float switchEndian(float x) {
        ByteBuffer bbuf = ByteBuffer.allocate(32);
        bbuf.order(ByteOrder.LITTLE_ENDIAN);
        bbuf.putFloat(x);
        bbuf.order(ByteOrder.BIG_ENDIAN);
        float y = bbuf.getFloat(0);
        return y;
    }

    public short switchEndian(short x) {
        ByteBuffer bbuf = ByteBuffer.allocate(16);
        bbuf.order(ByteOrder.LITTLE_ENDIAN);
        bbuf.putShort(x);
        bbuf.order(ByteOrder.BIG_ENDIAN);
        short y = bbuf.getShort(0);
        return y;
    }

    public float[] switchEndianArray(float[] X) {
        for (int i = 0; i < X.length; ++i) {
            X[i] = this.switchEndian(X[i]);
        }
        return X;
    }

    public byte[] jCompress(byte[] uncompressedData) {
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(uncompressedData);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(uncompressedData.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] compressedData = bos.toByteArray();
        return compressedData;
    }

    public byte[] jUncompress(byte[] compressedData) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedData);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(compressedData.length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
                if (count != 0) continue;
                break;
            }
            catch (DataFormatException e) {
                e.printStackTrace();
                break;
            }
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] decompressedData = bos.toByteArray();
        return decompressedData;
    }

    public int zcompress(float[] arrayin, int sizein, shortArrayContainer arrayoutcontainer, int[] sizeout) {
        byte[] compressedBytesOutPadded;
        for (int i = 0; i < arrayin.length; ++i) {
            if (arrayin[i] != -3.4028235E38f) continue;
            arrayin[i] = -1.0E38f;
        }
        if (this.DEBUG) {
            System.out.println("Converting floats to bytes...");
        }
        byte[] B = this.floatArrayToByteArray(arrayin);
        B = this.switchEndianByteArray(B, 4);
        if (this.DEBUG) {
            System.out.println("Compressing data...");
        }
        byte[] compressedBytesOut = this.jCompress(B);
        int numbytes = compressedBytesOut.length;
        if (this.DEBUG) {
            System.out.println("Padding compressed array...");
        }
        int numbytesPadded = numbytes;
        while (numbytesPadded % 4 != 0) {
            ++numbytesPadded;
        }
        if (numbytesPadded > numbytes) {
            compressedBytesOutPadded = new byte[numbytesPadded];
            for (int i = 0; i < numbytes; ++i) {
                compressedBytesOutPadded[i] = compressedBytesOut[i];
            }
        } else {
            compressedBytesOutPadded = compressedBytesOut;
        }
        if (this.DEBUG) {
            System.out.println("Byte swapping...");
        }
        compressedBytesOutPadded = this.switchEndianByteArray(compressedBytesOutPadded, 4);
        if (this.DEBUG) {
            System.out.println("Converting bytes to short integers");
        }
        int arrayOutSize = numbytesPadded / 2;
        short[] arrayout = new short[arrayOutSize];
        sizeout[0] = numbytes;
        if (this.DEBUG) {
            System.out.println("Converting bytes to short integers...");
        }
        for (int i = 0; i < numbytesPadded; i += 2) {
            arrayout[i / 2] = ByteConversion.bytes2short(compressedBytesOutPadded, i);
        }
        arrayoutcontainer.array = arrayout;
        return 0;
    }

    public float[] zuncompress(short[] arrayin, int sizein, float[] arrayout, int sizeXY) {
        int tempBytesInLength = arrayin.length * 2;
        byte[] bytesInPadded = new byte[tempBytesInLength];
        if (this.DEBUG) {
            System.out.println("Converting bytes to short integers");
        }
        for (int i = 0; i < tempBytesInLength; i += 2) {
            ByteConversion.short2bytes(arrayin[i / 2], bytesInPadded, i);
        }
        if (this.DEBUG) {
            System.out.println("Byte swapping...");
        }
        bytesInPadded = this.switchEndianByteArray(bytesInPadded, 4);
        if (this.DEBUG) {
            System.out.println("Removing padding from compressed array...");
        }
        byte[] compressedBytes = new byte[sizein];
        for (int i = 0; i < sizein; ++i) {
            compressedBytes[i] = bytesInPadded[i];
        }
        if (this.DEBUG) {
            System.out.println("Decompressing data...");
        }
        byte[] uncompressedBytes = this.jUncompress(compressedBytes);
        if (this.DEBUG) {
            System.out.println("Converting bytes to floats...");
        }
        arrayout = this.byteArrayToFloatArray(uncompressedBytes);
        arrayout = this.switchEndianArray(arrayout);
        for (int i = 0; i < arrayout.length; ++i) {
            if (!(arrayout[i] <= -1.0E38f)) continue;
            arrayout[i] = -3.4028235E38f;
        }
        return arrayout;
    }
}

