/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.grid;

import hec.heclib.grid.FlatGrid;
import hec.heclib.grid.GridData;
import hec.heclib.grid.GridInfo;
import hec.heclib.grid.GriddedData;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;

public class Dss2FltGrid {
    String _outFileName = "";
    String _dssFileName = "";
    String _dssPathName = "";
    boolean _verbose_mode = false;
    boolean _noErrorsYet = true;
    private String _message = "";
    private String _Apart;
    private String _Bpart;
    private String _Cpart;
    private String _Dpart;
    private String _Epart;
    private String _Fpart;
    private HecTime _startTime = new HecTime();
    private HecTime _endTime = new HecTime();

    public Dss2FltGrid() {
    }

    public Dss2FltGrid(String outFileName, DSSIdentifier dssId, HecTime startDate, HecTime endDate, String gridTypeName) {
        this();
        this._outFileName = outFileName;
        this._dssFileName = dssId.getFileName();
        this._dssPathName = dssId.getDSSPath();
        this._startTime = startDate;
        this._endTime = endDate;
        if (!this._outFileName.endsWith(".flt")) {
            this._outFileName = this._outFileName + ".flt";
        }
    }

    public Dss2FltGrid(String[] args) {
        this();
        this.parseArgs(args);
        if (this._noErrorsYet) {
            this.checkArgs();
        }
        if (this._noErrorsYet) {
            this.printArgs();
            System.out.println(this._message);
            this._message = "";
        }
    }

    private String checkDssPath(String pathPart, String name) {
        String message = pathPart.equals("") ? name + " Part: -NULL-" : name + " Part: " + pathPart;
        return message;
    }

    private void checkArgs() {
        int errcnt = 0;
        if (this._outFileName.equals("")) {
            this._message = this._message + "Error: you must specify an output FLOAT file (OUTPUT).\n";
            ++errcnt;
        }
        if (this._dssFileName.equals("")) {
            this._message = this._message + "Error: you must specify a DSS file (DSSFILE)\n";
            ++errcnt;
        }
        int slashCnt = 0;
        for (int i = 0; i < this._dssPathName.length(); ++i) {
            if (this._dssPathName.charAt(i) != '/') continue;
            ++slashCnt;
        }
        if (slashCnt != 7) {
            this._message = this._message + "Error: you must specify a DSS path (PATHNAME) in the form /A/B/C/D/E/F/.\n";
            ++errcnt;
        }
        if (errcnt > 0) {
            this._noErrorsYet = false;
        }
    }

    public void printArgs() {
        Object localMessage = "";
        localMessage = (String)localMessage + "\nOUTPUT:\t\t" + this._outFileName + "\n";
        localMessage = (String)localMessage + "DSSFILE:\t" + this._dssFileName + "\n";
        localMessage = (String)localMessage + "PATHNAME:\t" + this._dssPathName + "\n";
        this._message = (String)localMessage + this._message;
    }

    int grid2inch(GridInfo gi, GridData gd) {
        if (gi.getDataUnits().equals("mm")) {
            int i = gi.getNumberOfCellsX();
            int j = gi.getNumberOfCellsY();
            int ij = i * j;
            float[] dataArray = gd.getData();
            for (int it = 0; it < ij; ++it) {
                if (dataArray[it] == -3.4028235E38f) continue;
                dataArray[it] = dataArray[it] / 25.4f;
            }
            gi.setParameterInfo("inches", gi.getDataType());
            gd.updateStatistics();
        }
        return 0;
    }

    private void setDateTimeFromString(HecTime dtime, String part) {
        if (!part.equals("")) {
            String[] dtArray = part.split(":");
            if (dtArray.length == 2) {
                dtime.set(dtArray[0], dtArray[1]);
            } else {
                this._message = this._message + "Error: DSS path must include date and time, separated by a colon.\n";
                this._noErrorsYet = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        BufferedOutputStream fltOutputStream;
        boolean isTimeStep = true;
        GriddedData inGrid = new GriddedData();
        GridData inData = new GridData();
        GridInfo inInfo = null;
        if (this._startTime == null) {
            this._startTime = new HecTime();
        }
        if (this._endTime == null) {
            this._endTime = new HecTime();
        }
        if (inGrid.setDSSFileName(this._dssFileName, true) != 0) {
            this._message = this._message + "Cannot open DSS file " + this._dssFileName + " for input.\n";
            this._noErrorsYet = false;
            return;
        }
        inGrid.setGriddedPathnameParts(this._Apart, this._Bpart, this._Cpart, this._Fpart);
        this.setDateTimeFromString(this._startTime, this._Dpart);
        this.setDateTimeFromString(this._endTime, this._Epart);
        if (!this._startTime.isDefined() || !this._endTime.isDateDefined()) {
            isTimeStep = false;
        }
        if (isTimeStep) {
            inGrid.setGriddedTimeWindow(this._startTime, this._endTime);
        } else if (!this._endTime.isDefined()) {
            inGrid.setGridTime(this._startTime);
            inGrid.setEPart("");
        }
        int[] stat = new int[1];
        inInfo = inGrid.retrieveGriddedData(true, inData, stat);
        if (inInfo == null || stat[0] != 0) {
            this._message = this._message + "Could not retrieve record /" + this._Apart + "/" + this._Bpart + "/" + this._Cpart + "/ / /_Fpart\nfor interval from " + this._startTime.date() + " at " + this._startTime.time() + "\n               to " + this._endTime.date() + " at " + this._endTime.time();
            this._noErrorsYet = false;
            return;
        }
        inInfo.show();
        if (!this._outFileName.endsWith(".flt")) {
            this._outFileName = this._outFileName + ".flt";
        }
        File hdrFile = new File(this._outFileName.substring(0, this._outFileName.lastIndexOf(46)) + ".hdr");
        File prjFile = new File(this._outFileName.substring(0, this._outFileName.lastIndexOf(46)) + ".prj");
        File fltFile = new File(this._outFileName);
        BufferedWriter hdrFileWriter = null;
        BufferedWriter prjFileWriter = null;
        if (hdrFile.exists() && !hdrFile.canWrite()) {
            this._message = this._message + "Cannot open " + hdrFile + " for output.\n";
            this._noErrorsYet = false;
            return;
        }
        if (prjFile.exists() && !prjFile.canWrite()) {
            this._message = this._message + "Cannot open " + prjFile + " for output.\n";
            this._noErrorsYet = false;
            return;
        }
        try {
            fltOutputStream = new BufferedOutputStream(new FileOutputStream(fltFile));
        }
        catch (IOException ioe) {
            this._message = "Cannot open " + fltFile + " for input.";
            this._noErrorsYet = false;
            return;
        }
        try {
            hdrFileWriter = new BufferedWriter(new FileWriter(hdrFile));
            prjFileWriter = new BufferedWriter(new FileWriter(prjFile));
            FlatGrid theGrid = new FlatGrid();
            theGrid.fromDssGrid(inInfo, inData);
            theGrid.toFlt(hdrFileWriter, fltOutputStream);
            prjFileWriter.write(inInfo.getSpatialReferenceSystem());
            inGrid.closeAndClear();
        }
        catch (IOException ioe) {
            this._message = this._message + "IOError writing to output " + this._outFileName + " error " + ioe;
            this._noErrorsYet = false;
            return;
        }
        finally {
            try {
                if (fltOutputStream != null) {
                    fltOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (hdrFileWriter != null) {
                    hdrFileWriter.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (prjFileWriter != null) {
                    prjFileWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String[] argArray = args[i].split("=");
            String var = argArray[0];
            Object val = argArray[1];
            if ((var = var.toUpperCase()).startsWith("DSS")) {
                if (!((String)val).toUpperCase().endsWith(".DSS")) {
                    val = (String)val + ".dss";
                }
                this._dssFileName = val;
                continue;
            }
            if (var.startsWith("OUT")) {
                this._outFileName = val;
                continue;
            }
            if (var.startsWith("PATH")) {
                this._dssPathName = val;
                this.parseDssPath(this._dssPathName);
                continue;
            }
            if (var.startsWith("V")) {
                this._verbose_mode = true;
                continue;
            }
            this._message = this._message + "ERROR: Argument not recognized!\n";
            this._message = this._message + "  Argument" + var + "\n";
            this._noErrorsYet = false;
        }
    }

    private void parseDssPath(String dssPathName) {
        String[] pathArray = dssPathName.split("/");
        if (pathArray.length != 7) {
            System.out.println("Path parts given::");
            for (String p : pathArray) {
                System.out.println(p);
            }
            this._message = this._message + "Error: DSSPATH must contain six elements formatted as /Apart/Bpart/Cpart/Dpart/Epart/Fpart/\n";
            this._noErrorsYet = false;
            return;
        }
        this._Apart = pathArray[1].toUpperCase();
        this._Bpart = pathArray[2].toUpperCase();
        this._Cpart = pathArray[3].toUpperCase();
        this._Dpart = pathArray[4].toUpperCase();
        this._Epart = pathArray[5].toUpperCase();
        this._Fpart = pathArray[6].toUpperCase();
        this._message = this._message + "DSS Path Parts:\n";
        this._message = this._message + this.checkDssPath(this._Apart, "A") + "\n";
        this._message = this._message + this.checkDssPath(this._Bpart, "B") + "\n";
        this._message = this._message + this.checkDssPath(this._Cpart, "C") + "\n";
        this._message = this._message + this.checkDssPath(this._Dpart, "D") + "\n";
        this._message = this._message + this.checkDssPath(this._Epart, "E") + "\n";
        this._message = this._message + this.checkDssPath(this._Fpart, "F") + "\n";
    }

    public int getStatus() {
        if (this._noErrorsYet) {
            return 0;
        }
        return -1;
    }

    public static void main(String[] args) {
        Dss2FltGrid d2a = new Dss2FltGrid(args);
        if (d2a._noErrorsYet) {
            d2a.dump();
        }
        if (d2a._noErrorsYet) {
            System.out.println(d2a._message + "\nSuccessful dump of DSS grid to .flt file: " + d2a._outFileName + "\n");
        } else {
            System.out.println("Dss2ascGrid failed.  Details follow. \n" + d2a._message + "\n");
        }
    }
}

