/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.grid;

import hec.heclib.grid.GridData;
import hec.heclib.grid.GridInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import rma.util.RMAIO;

public class FlatGrid {
    private int _nrows;
    private int _ncols;
    private int _minXindex = 0;
    private int _minYindex = 0;
    private double _cellSize = -3.4028234663852886E38;
    private double _llXcoord = -3.4028234663852886E38;
    private double _llYcoord = -3.4028234663852886E38;
    private double[] _data;
    int _startIdx = 0;
    int _endIdx = 0;
    String _tokenLine;

    public FlatGrid() {
    }

    public FlatGrid(int ncols, int nrows) {
        this();
        this._nrows = nrows;
        this._ncols = ncols;
        int ncells = nrows * ncols;
        if (ncells != 0) {
            this._data = new double[ncells];
        }
    }

    public int fromAscii(BufferedReader inFile) {
        String line;
        double arcNoDataValue = -9999.0;
        double llCellCenterX = -3.4028234663852886E38;
        double llCellCenterY = -3.4028234663852886E38;
        boolean noValueAssigned = true;
        try {
            line = inFile.readLine().trim();
            if (line == null) {
                return -1;
            }
        }
        catch (IOException ioe) {
            System.out.println("fromAscii: IO Error reading file " + ioe);
            return -1;
        }
        String inToken = RMAIO.getType(line, " ");
        while (this.isHeaderLine(inToken)) {
            String value = RMAIO.getParam(line, " ");
            if (inToken.equalsIgnoreCase("ncols")) {
                this._ncols = RMAIO.parseInt(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("nrows")) {
                this._nrows = RMAIO.parseInt(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("xllcorner")) {
                this._llXcoord = RMAIO.parseDouble(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("yllcorner")) {
                this._llYcoord = RMAIO.parseDouble(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("xllcenter")) {
                llCellCenterX = RMAIO.parseDouble(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("yllcenter")) {
                llCellCenterY = RMAIO.parseDouble(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("cellsize")) {
                this._cellSize = RMAIO.parseDouble(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("nodata_value")) {
                arcNoDataValue = RMAIO.parseDouble(value);
                noValueAssigned = false;
            }
            if (noValueAssigned) {
                System.out.println("Unknown ASCII grid header line encountered:\n");
                System.out.println(inToken + "\t" + value);
            }
            noValueAssigned = true;
            try {
                line = inFile.readLine().trim();
                if (line == null) {
                    return -1;
                }
                inToken = RMAIO.getType(line, " ");
            }
            catch (IOException ioe) {
                System.out.println("fromAscii: error reading file " + ioe);
                return -1;
            }
        }
        System.out.println("fromAscii: rows=" + this._nrows + " cols=" + this._ncols);
        System.out.println(" minXindex=" + this._minXindex + " minYIndex=" + this._minYindex);
        System.out.println(" cellsize=" + this._cellSize + " llXCoord=" + this._llXcoord + " llYCoord=" + this._llYcoord);
        System.out.println(" noDataVal=" + arcNoDataValue);
        if (this._cellSize == -3.4028234663852886E38 || this._nrows == 0 || this._ncols == 0) {
            this._ncols = 0;
            this._nrows = 0;
            this._cellSize = -3.4028234663852886E38;
            System.out.println("fromAscii: not enough info to define grid");
            return 1;
        }
        if (this._llXcoord == -3.4028234663852886E38 && llCellCenterX != -3.4028234663852886E38) {
            this._llXcoord = llCellCenterX - this._cellSize / 2.0;
        }
        if (this._llYcoord == -3.4028234663852886E38 && llCellCenterY != -3.4028234663852886E38) {
            this._llYcoord = llCellCenterY - this._cellSize / 2.0;
        }
        this._data = new double[this._nrows * this._ncols];
        this.newToken(line);
        int dataLinesProcessed = 0;
        int dataValuesProcessed = 0;
        for (int j = this._nrows; j >= 1; --j) {
            for (int i = 1; i <= this._ncols; ++i) {
                inToken = this.nextToken();
                if (inToken == null) {
                    System.out.println("fromArc: unexpected end of data for row " + j + " at col " + i);
                    break;
                }
                double inVal = RMAIO.parseDouble(inToken);
                if (inVal == arcNoDataValue) {
                    this.setCellValue(i, j, -3.4028234663852886E38);
                    ++dataValuesProcessed;
                    continue;
                }
                this.setCellValue(i, j, inVal);
                ++dataValuesProcessed;
            }
            ++dataLinesProcessed;
            try {
                line = inFile.readLine();
                if (line == null) {
                    if (dataLinesProcessed == this._nrows) break;
                    System.out.println("fromArc: unexpected end of file. Rows remaining " + j);
                    break;
                }
                this.newToken(line);
                continue;
            }
            catch (IOException ioe) {
                if (dataLinesProcessed == this._nrows - 1) break;
                System.out.println("fromArc: Error reading file " + ioe);
                return -1;
            }
        }
        System.out.println("processed " + dataLinesProcessed + " lines of data");
        System.out.println("processed " + dataValuesProcessed + " values");
        return 0;
    }

    public int fromFlt(BufferedReader hdrReader, BufferedInputStream fltStream) {
        String line;
        double arcNoDataValue = -9999.0;
        double llCellCenterX = -3.4028234663852886E38;
        double llCellCenterY = -3.4028234663852886E38;
        boolean LSBFIRST = true;
        boolean readingHeader = true;
        boolean noValueAssigned = true;
        try {
            line = hdrReader.readLine();
            line = line.trim();
            if (line == null) {
                return -1;
            }
        }
        catch (IOException ioe) {
            System.out.println("fromFlt: IO Error reading file " + ioe);
            return -1;
        }
        String inToken = RMAIO.getType(line, " ");
        while (readingHeader && this.isHeaderLine(inToken)) {
            String value = RMAIO.getParam(line, " ");
            if (inToken.equalsIgnoreCase("layout") || inToken.equalsIgnoreCase("nbands") || inToken.equalsIgnoreCase("nbits") || inToken.equalsIgnoreCase("bandrowbytes") || inToken.equalsIgnoreCase("totalrowbytes") || inToken.equalsIgnoreCase("pixeltype") || inToken.equalsIgnoreCase("ulxmap") || inToken.equalsIgnoreCase("ulymap") || inToken.equalsIgnoreCase("xdim") || inToken.equalsIgnoreCase("ydim")) {
                System.out.println("BIL-type header line encountered:");
                System.out.println(inToken + "\t" + value + "\n");
                return 1;
            }
            if (inToken.equalsIgnoreCase("ncols")) {
                this._ncols = RMAIO.parseInt(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("nrows")) {
                this._nrows = RMAIO.parseInt(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("xllcorner")) {
                this._llXcoord = RMAIO.parseDouble(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("yllcorner")) {
                this._llYcoord = RMAIO.parseDouble(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("xllcenter")) {
                llCellCenterX = RMAIO.parseDouble(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("yllcenter")) {
                llCellCenterY = RMAIO.parseDouble(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("cellsize")) {
                this._cellSize = RMAIO.parseDouble(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("nodata_value")) {
                arcNoDataValue = RMAIO.parseDouble(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("byteorder")) {
                if (value.equalsIgnoreCase("MSBFIRST")) {
                    LSBFIRST = false;
                }
                noValueAssigned = false;
            }
            if (noValueAssigned && !value.trim().equals("")) {
                System.out.println("Unknown float grid header line encountered:");
                System.out.println(inToken + "\t" + value + "\n");
            }
            noValueAssigned = true;
            try {
                line = hdrReader.readLine();
                if (line == null) {
                    readingHeader = false;
                    continue;
                }
                line = line.trim();
                inToken = RMAIO.getType(line, " ");
            }
            catch (IOException ioe) {
                System.out.println("fromFlt: error reading file " + ioe);
                return -1;
            }
        }
        System.out.println("fromFlt: rows=" + this._nrows + " cols=" + this._ncols);
        System.out.println(" minXindex=" + this._minXindex + " minYIndex=" + this._minYindex);
        System.out.println(" cellsize=" + this._cellSize + " llXCoord=" + this._llXcoord + " llYCoord=" + this._llYcoord);
        System.out.println(" noDataVal=" + arcNoDataValue);
        if (this._cellSize == -3.4028234663852886E38 || this._nrows == 0 || this._ncols == 0) {
            this._ncols = 0;
            this._nrows = 0;
            this._cellSize = -3.4028234663852886E38;
            System.out.println("fromFlt: not enough info to define grid");
            return 1;
        }
        if (this._llXcoord == -3.4028234663852886E38 && llCellCenterX != -3.4028234663852886E38) {
            this._llXcoord = llCellCenterX - this._cellSize / 2.0;
        }
        if (this._llYcoord == -3.4028234663852886E38 && llCellCenterY != -3.4028234663852886E38) {
            this._llYcoord = llCellCenterY - this._cellSize / 2.0;
        }
        this._data = new double[this._nrows * this._ncols];
        DataInputStream fltData = new DataInputStream(fltStream);
        int dataValuesProcessed = 0;
        for (int j = this._nrows; j >= 1; --j) {
            for (int i = 1; i <= this._ncols; ++i) {
                float inVal;
                int inBytes;
                try {
                    inBytes = fltData.readInt();
                }
                catch (IOException ioe) {
                    System.out.println("fromFlt: error reading file " + ioe);
                    return -1;
                }
                if (LSBFIRST) {
                    inBytes = this.switchEndian(inBytes);
                }
                if ((double)(inVal = Float.intBitsToFloat(inBytes)) == arcNoDataValue) {
                    this.setCellValue(i, j, -3.4028234663852886E38);
                    ++dataValuesProcessed;
                    continue;
                }
                this.setCellValue(i, j, inVal);
                ++dataValuesProcessed;
            }
        }
        System.out.println("processed " + dataValuesProcessed + " values");
        return 0;
    }

    public int fromBil(BufferedReader hdrReader, BufferedInputStream fltStream) {
        String line;
        double arcNoDataValue = -9999.0;
        double ulCellCenterX = -3.4028234663852886E38;
        double ulCellCenterY = -3.4028234663852886E38;
        boolean LSBFIRST = true;
        boolean readingHeader = true;
        String pixelType = "FLOAT";
        String layoutType = "BIL";
        int iValue = 0;
        boolean noValueAssigned = true;
        try {
            line = hdrReader.readLine();
            line = line.trim();
            if (line == null) {
                return -1;
            }
        }
        catch (IOException ioe) {
            System.out.println("fromBil: IO Error reading file " + ioe);
            return -1;
        }
        String inToken = RMAIO.getType(line, " ");
        while (readingHeader && this.isHeaderLine(inToken)) {
            String value = RMAIO.getParam(line, " ");
            if (inToken.equalsIgnoreCase("xllcorner") || inToken.equalsIgnoreCase("yllcorner") || inToken.equalsIgnoreCase("xllcenter") || inToken.equalsIgnoreCase("yllcenter")) {
                System.out.println("FLT-type header line encountered:");
                System.out.println(inToken + "\t" + value + "\n");
                return 1;
            }
            if (inToken.equalsIgnoreCase("byteorder")) {
                if (value.equalsIgnoreCase("M")) {
                    LSBFIRST = false;
                }
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("layout")) {
                if (!value.equalsIgnoreCase("bil")) {
                    System.out.println("fromBil: Unsupported layout type " + value);
                    return 2;
                }
                layoutType = value;
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("pixeltype")) {
                if (!value.equalsIgnoreCase("float")) {
                    System.out.println("fromBil: Unsupported pixel type " + value);
                    return 2;
                }
                pixelType = value;
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("ncols")) {
                this._ncols = RMAIO.parseInt(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("nrows")) {
                this._nrows = RMAIO.parseInt(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("nbands") || inToken.equalsIgnoreCase("nbits") || inToken.equalsIgnoreCase("bandrowbytes") || inToken.equalsIgnoreCase("totalrowbytes")) {
                iValue = RMAIO.parseInt(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("ulxmap")) {
                ulCellCenterX = RMAIO.parseDouble(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("ulymap")) {
                ulCellCenterY = RMAIO.parseDouble(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("xdim") || inToken.equalsIgnoreCase("ydim")) {
                this._cellSize = RMAIO.parseDouble(value);
                noValueAssigned = false;
            } else if (inToken.equalsIgnoreCase("nodata")) {
                arcNoDataValue = RMAIO.parseDouble(value);
                noValueAssigned = false;
            }
            if (noValueAssigned) {
                System.out.println("Unknown BIL grid header line encountered:");
                System.out.println(inToken + "\t" + value + "\n");
            }
            noValueAssigned = true;
            try {
                line = hdrReader.readLine();
                if (line == null) {
                    readingHeader = false;
                    continue;
                }
                line = line.trim();
                inToken = RMAIO.getType(line, " ");
            }
            catch (IOException ioe) {
                System.out.println("fromBil: error reading file " + ioe);
                return -1;
            }
        }
        if (this._cellSize == -3.4028234663852886E38 || this._nrows == 0 || this._ncols == 0) {
            this._ncols = 0;
            this._nrows = 0;
            this._cellSize = -3.4028234663852886E38;
            System.out.println("fromBil: not enough info to define grid");
            return 1;
        }
        this._llXcoord = ulCellCenterX - this._cellSize / 2.0;
        this._llYcoord = ulCellCenterY - this._cellSize / 2.0 - (double)(this._nrows - 1) * this._cellSize;
        System.out.println("fromBil: rows=" + this._nrows + " cols=" + this._ncols);
        System.out.println(" minXindex=" + this._minXindex + " minYIndex=" + this._minYindex);
        System.out.println(" cellsize=" + this._cellSize + " llXCoord=" + this._llXcoord + " llYCoord=" + this._llYcoord);
        System.out.println(" noDataVal=" + arcNoDataValue);
        this._data = new double[this._nrows * this._ncols];
        DataInputStream fltData = new DataInputStream(fltStream);
        int dataValuesProcessed = 0;
        for (int j = this._nrows; j >= 1; --j) {
            for (int i = 1; i <= this._ncols; ++i) {
                float inVal;
                int inBytes;
                try {
                    inBytes = fltData.readInt();
                }
                catch (IOException ioe) {
                    System.out.println("fromBil: error reading file " + ioe);
                    return -1;
                }
                if (LSBFIRST) {
                    inBytes = this.switchEndian(inBytes);
                }
                if ((double)(inVal = Float.intBitsToFloat(inBytes)) == arcNoDataValue) {
                    this.setCellValue(i, j, -3.4028234663852886E38);
                    ++dataValuesProcessed;
                    continue;
                }
                this.setCellValue(i, j, inVal);
                ++dataValuesProcessed;
            }
        }
        System.out.println("processed " + dataValuesProcessed + " values");
        return 0;
    }

    private int switchEndian(int x) {
        ByteBuffer bbuf = ByteBuffer.allocate(32);
        bbuf.order(ByteOrder.LITTLE_ENDIAN);
        bbuf.putInt(x);
        bbuf.order(ByteOrder.BIG_ENDIAN);
        int y = bbuf.getInt(0);
        return y;
    }

    public int toAscii(BufferedWriter outFile) {
        return this.toAscii(outFile, -1);
    }

    public int toAscii(BufferedWriter outFile, int precision) {
        int noDataValue = -9999;
        int lastNoDataValue = -9999;
        double noDataValue_d = -9999.0;
        boolean nullValueNeedsTest = true;
        block6: while (nullValueNeedsTest) {
            nullValueNeedsTest = false;
            for (int i = 0; i < this._data.length; ++i) {
                if (this._data[i] != noDataValue_d) continue;
                nullValueNeedsTest = true;
                noDataValue = noDataValue * 10 - 9;
                noDataValue_d = noDataValue_d * 10.0 + 9.0;
                if (noDataValue <= lastNoDataValue) continue block6;
                noDataValue = -901;
                continue block6;
            }
        }
        if (outFile == null) {
            System.out.println("toAscii: null Writer object passed as argument");
            return -1;
        }
        try {
            outFile.write("ncols         " + this._ncols);
            outFile.write("\nnrows         " + this._nrows);
            outFile.write("\nxllcorner     " + this._llXcoord);
            outFile.write("\nyllcorner     " + this._llYcoord);
            outFile.write("\ncellsize      " + this._cellSize);
            outFile.write("\nNODATA_value  " + noDataValue + "\n");
        }
        catch (IOException ioe) {
            System.out.println("toAscii: error writing header info " + ioe);
            return -1;
        }
        Object doubleFormat = "%f ";
        if (precision > 0) {
            doubleFormat = "%." + precision + "f ";
        }
        for (int j = this._nrows; j > 0; --j) {
            for (int i = 1; i <= this._ncols; ++i) {
                double data = this.getCellValue(i, j);
                try {
                    if (data == -3.4028234663852886E38) {
                        outFile.write(noDataValue + " ");
                        continue;
                    }
                    outFile.write(String.format((String)doubleFormat, data));
                    continue;
                }
                catch (IOException ioe) {
                    System.out.println("toAscii: error writing data at " + j + i + " " + ioe);
                    return -1;
                }
            }
            try {
                outFile.newLine();
                continue;
            }
            catch (IOException ioe) {
                System.out.println("toArc: error writing data newline " + ioe);
                return -1;
            }
        }
        return 0;
    }

    public int toFlt(BufferedWriter hdrWriter, BufferedOutputStream fltStream) {
        int noDataValue = -9999;
        int lastNoDataValue = -9999;
        double noDataValue_d = -9999.0;
        boolean nullValueNeedsTest = true;
        block4: while (nullValueNeedsTest) {
            nullValueNeedsTest = false;
            for (int i = 0; i < this._data.length; ++i) {
                if (this._data[i] != noDataValue_d) continue;
                nullValueNeedsTest = true;
                noDataValue = noDataValue * 10 - 9;
                noDataValue_d = noDataValue_d * 10.0 + 9.0;
                if (noDataValue <= lastNoDataValue) continue block4;
                noDataValue = -901;
                continue block4;
            }
        }
        if (hdrWriter == null || fltStream == null) {
            System.out.println("toFlt: null Writer object passed as argument");
            return -1;
        }
        try {
            hdrWriter.write("ncols         " + this._ncols);
            hdrWriter.write("\nnrows         " + this._nrows);
            hdrWriter.write("\nxllcorner     " + this._llXcoord);
            hdrWriter.write("\nyllcorner     " + this._llYcoord);
            hdrWriter.write("\ncellsize      " + this._cellSize);
            hdrWriter.write("\nNODATA_value  " + noDataValue + "\n");
            hdrWriter.write("\nBYTEORDER  MSBFIRST\n");
        }
        catch (IOException ioe) {
            System.out.println("toFlt: error writing header info " + ioe);
            return -1;
        }
        DataOutputStream fltDataStream = new DataOutputStream(fltStream);
        for (int j = this._nrows; j > 0; --j) {
            for (int i = 1; i <= this._ncols; ++i) {
                double data = this.getCellValue(i, j);
                try {
                    if (data == -3.4028234663852886E38 || data == -3.4028234663852886E38) {
                        fltDataStream.writeFloat(noDataValue);
                        continue;
                    }
                    fltDataStream.writeFloat((float)data);
                    continue;
                }
                catch (IOException ioe) {
                    System.out.println("toFlt: error writing data at " + j + i + " " + ioe);
                    return -1;
                }
            }
        }
        return 0;
    }

    int fromDssGrid(GridInfo inInfo, GridData inData) {
        this._nrows = inInfo.getNumberOfCellsY();
        this._ncols = inInfo.getNumberOfCellsX();
        this._cellSize = inInfo.getCellSize();
        int cellCount = this._nrows * this._ncols;
        this._minXindex = inInfo.getLowerLeftCellX();
        this._minYindex = inInfo.getLowerLeftCellY();
        switch (inInfo.getGridType()) {
            case 410: 
            case 411: 
            case 420: 
            case 421: {
                this._llXcoord = (double)this._minXindex * this._cellSize;
                this._llYcoord = (double)this._minYindex * this._cellSize;
                break;
            }
            default: {
                this._llXcoord = (double)this._minXindex * this._cellSize;
                this._llYcoord = (double)this._minYindex * this._cellSize;
            }
        }
        this._data = new double[this._nrows * this._ncols];
        float[] gridVector = inData.getData();
        for (int i = 0; i < cellCount; ++i) {
            this._data[i] = gridVector[i];
        }
        return 0;
    }

    int toGriddedData(GridInfo outInfo, GridData outData) {
        int dataCnt = this._ncols * this._nrows;
        float[] data = new float[dataCnt];
        for (int i = 0; i < dataCnt; ++i) {
            data[i] = (float)this._data[i];
        }
        outInfo.setCellInfo(this._minXindex, this._minYindex, this._ncols, this._nrows, (float)this._cellSize);
        outData.initGridData(data, outInfo);
        return 0;
    }

    int setCellValue(int col, int row, double value) {
        if (this._data == null) {
            System.out.println("setCellValue: no data buffer");
            return 1;
        }
        if (col > this._ncols || row > this._nrows || col < 1 || row < 1) {
            System.out.println("setCellValue: invalid position (" + row + "," + col + ") max=(" + this._nrows + "," + this._ncols + ")");
            return 1;
        }
        this._data[col - 1 + this._ncols * (row - 1)] = value;
        return 0;
    }

    public double getCellValue(int col, int row) {
        if (col > 0 && col <= this._ncols && row > 0 && row <= this._nrows) {
            return this._data[col + (row - 1) * this._ncols - 1];
        }
        System.out.println("Cell indices (" + col + ", " + row + ") are out of range.");
        return -3.4028234663852886E38;
    }

    public void setCellSize(double size) {
        this._cellSize = size;
    }

    public void setGridSize(int ncols, int nrows) {
        this._ncols = ncols;
        this._nrows = nrows;
    }

    public void setOriginCoords(double xCoord, double yCoord) {
        this._llXcoord = xCoord;
        this._llYcoord = yCoord;
    }

    public void setOriginIndices(int i, int j) {
        System.out.println("origin set to " + i + ", " + j);
        this._minXindex = i;
        this._minYindex = j;
    }

    public void setData(double[] data) {
        this._data = data;
    }

    public void setData(float[] data) {
        if (this._data.length != data.length) {
            this._data = new double[data.length];
        }
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = data[i];
        }
    }

    public double getCellSize() {
        return this._cellSize;
    }

    public int getNumberOfColumns() {
        return this._ncols;
    }

    public int getNumberOfRows() {
        return this._nrows;
    }

    public int getMinXindex() {
        return this._minXindex;
    }

    public int getMinYindex() {
        return this._minYindex;
    }

    public double getLLXcoord() {
        return this._llXcoord;
    }

    public double getLLYcoord() {
        return this._llYcoord;
    }

    private boolean isHeaderLine(String inToken) {
        if (inToken == null || inToken.length() < 1) {
            return true;
        }
        return Character.isLetter(inToken.charAt(0));
    }

    private void newToken(String line) {
        this._startIdx = 0;
        this._endIdx = 0;
        this._tokenLine = line;
    }

    private String nextToken() {
        if (this._tokenLine == null) {
            return null;
        }
        while (this._tokenLine.charAt(this._startIdx) == ' ') {
            ++this._startIdx;
        }
        this._endIdx = this._tokenLine.indexOf(32, this._startIdx);
        if (this._endIdx == -1) {
            if (this._startIdx < this._tokenLine.length()) {
                this._endIdx = this._tokenLine.length();
            } else {
                return null;
            }
        }
        String token = this._tokenLine.substring(this._startIdx, this._endIdx);
        this._startIdx = this._endIdx + 1;
        if (token != null) {
            return token.trim();
        }
        return token;
    }
}

