/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.grid;

import hec.heclib.dss.DssDataType;
import hec.heclib.grid.AlbersInfo;
import hec.heclib.grid.FlatGrid;
import hec.heclib.grid.GridData;
import hec.heclib.grid.GridInfo;
import hec.heclib.grid.GriddedData;
import hec.heclib.grid.HrapInfo;
import hec.heclib.grid.SpecifiedGridInfo;
import hec.heclib.util.HecTime;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;

public class Flt2DssGrid {
    private String _inFileName = "";
    private String _dssFileName = "";
    private String _dssPathName = "";
    private String _gridTypeName = "";
    private int _utmZone = -1;
    private String _utmHemisphere = "";
    private String _dataTypeName = "PER-CUM";
    public DssDataType _dataType = DssDataType.PER_CUM;
    private String _dataUnits = "mm";
    private boolean _use_deflate_compression = false;
    private boolean _useSpecifiedGridInfo = false;
    private boolean _verbose_mode = false;
    private boolean _round = false;
    private int _precision = -1;
    private String _Apart;
    private String _Bpart;
    private String _Cpart;
    private String _Dpart;
    private String _Epart;
    private String _Fpart;
    private HecTime _startTime = new HecTime();
    private HecTime _endTime = new HecTime();

    public Flt2DssGrid() {
    }

    public Flt2DssGrid(String[] args) {
        this();
        this.parseArgs(args);
        this.printArgs();
        this.checkArgs();
    }

    public Flt2DssGrid(String inFileName, String dssFileName, String gridTypeName, String Apart, String Bpart, String Cpart, String Dpart, String Epart, String Fpart, int utmZone, String dataUnits, String dataTypeName) {
        this();
        this._inFileName = inFileName;
        this._dssFileName = dssFileName;
        this._gridTypeName = gridTypeName;
        this._utmZone = utmZone;
        this._Apart = Apart;
        this._Bpart = Bpart;
        this._Cpart = Cpart;
        this._Dpart = Dpart;
        this._Epart = Epart;
        this._Fpart = Fpart;
        this._dataUnits = dataUnits;
        this._dataTypeName = dataTypeName;
    }

    public Flt2DssGrid(String inFileName, String dssFileName, String dssPathName, String gridTypeName, int utmZone, String dataUnits, String dataTypeName) {
        this();
        this._inFileName = inFileName;
        this._dssFileName = dssFileName;
        this._gridTypeName = gridTypeName;
        this._utmZone = utmZone;
        this._dataUnits = dataUnits;
        this._dataTypeName = dataTypeName;
        this.parseDssPath(dssPathName);
    }

    public static void programError(String errorMessage) {
        System.out.println(errorMessage + "\n");
        Flt2DssGrid.printUsage();
        System.exit(0);
    }

    private void setDateTimeFromString(HecTime dtime, String part) {
        if (!part.equals("")) {
            String[] dtArray = part.split(":");
            if (dtArray.length == 2) {
                dtime.set(dtArray[0], dtArray[1]);
            } else {
                Flt2DssGrid.programError("Error: DSS path must include date and time, separated by a colon.");
            }
        }
    }

    public static void printUsage() {
        System.out.println("Usage: Flt2DssGrid\n\tINPUT= input file name\n\tDSSFILE= output DSS file name\n\tPATHNAME= DSS record path name (/a/b/c/d/e/f/)\n\tGRIDTYPE= input grid type (HRAP, SHG, or UTMnn; optional)\n\tZONE = UTM zone number (required for UTM grids)\n\tDTYPE= data type (optional, PER-CUM by default)\n\tDUNITS= data units (optional, mm by default)\n\tCWMSDIR= directory for param.yyyy.mm.dss storage (optional, overrides DSSFILE)\n\tPARAMETER= filename start for param.yyyy.mm.dss storage (optional, required with CWMSDIR)\nOR:\n  Flt2DssGrid BATCH=filename\n    where filename indicates a file containing lines of comma-separated arguments.\n");
    }

    public void parseArgs(String[] args) {
        boolean CWMSout = false;
        String CWMSdir = "";
        Object CWMSparam = "";
        for (int i = 0; i < args.length; ++i) {
            int[] index;
            String[] argArray = args[i].split("=");
            String var = argArray[0];
            if ((var = var.toUpperCase()).startsWith("-H")) {
                Flt2DssGrid.printUsage();
            }
            Object val = "";
            if (argArray.length > 1) {
                val = argArray[1];
            }
            if (var.startsWith("DSS")) {
                if (!((String)val).toUpperCase().endsWith(".DSS")) {
                    val = (String)val + ".dss";
                }
                this._dssFileName = val;
                continue;
            }
            if (var.startsWith("CWMS")) {
                CWMSdir = val;
                CWMSout = true;
                continue;
            }
            if (var.startsWith("PARAM")) {
                CWMSparam = val;
                CWMSout = true;
                continue;
            }
            if (var.startsWith("IN")) {
                this._inFileName = val;
                continue;
            }
            if (var.startsWith("PATH")) {
                this._dssPathName = val;
                this.parseDssPath(this._dssPathName);
                continue;
            }
            if (var.startsWith("GR")) {
                this._gridTypeName = val;
                continue;
            }
            if (var.startsWith("DT")) {
                this._dataTypeName = val;
                continue;
            }
            if (var.startsWith("DU")) {
                this._dataUnits = val;
                continue;
            }
            if (var.startsWith("ZL")) {
                this._use_deflate_compression = true;
                continue;
            }
            if (var.startsWith("PREC")) {
                index = new int[]{0, 0};
                this._round = true;
                try {
                    this._precision = this.getIntFromString((String)val, 0, index);
                }
                catch (NumberFormatException e) {
                    this._round = false;
                    System.out.println("WARNING: Roundoff precision not recognized!");
                    System.out.println("  Values will not be rounded.");
                }
                continue;
            }
            if (var.startsWith("ZO")) {
                index = new int[]{0, 0};
                try {
                    this._utmZone = this.getIntFromString((String)val, 0, index);
                    if (index[1] <= 0) continue;
                    this._utmHemisphere = ((String)val).substring(index[1], index[1] + 1).toUpperCase();
                }
                catch (NumberFormatException e) {
                    this._utmZone = -1;
                }
                continue;
            }
            if (var.startsWith("SP")) {
                this._useSpecifiedGridInfo = true;
                continue;
            }
            if (var.startsWith("V")) {
                this._verbose_mode = true;
                continue;
            }
            System.out.println("WARNING: Argument not recognized!");
            System.out.println("  Argument: " + var);
        }
        if (CWMSout) {
            if (CWMSdir.isEmpty() || ((String)CWMSparam).isEmpty()) {
                Flt2DssGrid.programError("CWMS-style DSS file naming requires both CWMSDIR and PARAMETER to be set.");
            }
            String CWMSfile = CWMSdir + File.separator + (String)CWMSparam;
            String yrmn = "";
            if (this._endTime.isDefined()) {
                yrmn = String.format(".%4d.%02d", this._endTime.year(), this._endTime.month());
            } else if (this._startTime.isDateDefined()) {
                yrmn = String.format(".%4d.%02d", this._startTime.year(), this._startTime.month());
            } else {
                Flt2DssGrid.programError("CWMS-style DSS file naming requires a date in the DSS path.");
            }
            this._dssFileName = CWMSfile.concat(yrmn).concat(".dss");
        }
    }

    void checkArgs() {
        int errcnt = 0;
        if (this._inFileName.equals("")) {
            System.out.println("Error: you must specify an input file (INPUT).");
            ++errcnt;
        }
        if (this._dssFileName.equals("")) {
            System.out.println("Error: you must specify a DSS output file (DSSFILE).");
            ++errcnt;
        }
        if (this._gridTypeName.equals("UTM")) {
            if (this._utmZone < 1 || this._utmZone > 60) {
                System.out.println("Error: UTM zone number must be an integer value between 1 and 60.");
                ++errcnt;
            }
            if (!this._utmHemisphere.equals("N") && !this._utmHemisphere.equals("S")) {
                System.out.println("Error: UTM hemisphere must be either \"N\" or \"S\".");
                ++errcnt;
            }
        }
        if (this._dssPathName.equals("")) {
            System.out.println("Error: you must specify a DSS path (PATHNAME).");
            ++errcnt;
        }
        if (!(this._dataTypeName.equalsIgnoreCase("PER-AVER") || this._dataTypeName.equalsIgnoreCase("PER-CUM") || this._dataTypeName.equalsIgnoreCase("INST-VAL") || this._dataTypeName.equalsIgnoreCase("INST-CUM") || this._dataTypeName.equalsIgnoreCase("FREQ") || this._dataTypeName.equalsIgnoreCase(""))) {
            System.out.println("Error: DTYPE must be one of PER-AVER, PER-CUM, INST-VAL, INST-CUM, or FREQ. The default is PER-CUM.");
            ++errcnt;
        }
        if (errcnt > 0) {
            Flt2DssGrid.programError("Error: missing or incorrect arguments.");
        }
    }

    public void checkDssPath(String pathPart, String name) {
        String message = pathPart.equals("") ? name + " Part: -NULL-" : name + " Part: " + pathPart;
        System.out.println(message);
    }

    public void parseDssPath(String dssPathName) {
        String[] pathArray = dssPathName.split("/");
        if (pathArray.length != 7) {
            System.out.println("Path parts given::");
            for (String p : pathArray) {
                System.out.println(p);
            }
            Flt2DssGrid.programError("Error: DSSPATH must contain six elements separated formatted as/Apart/Bpart/Cpart/Dpart/Epart/Fpart/");
        } else {
            this._Apart = pathArray[1].toUpperCase();
            this._Bpart = pathArray[2].toUpperCase();
            this._Cpart = pathArray[3].toUpperCase();
            this._Dpart = pathArray[4].toUpperCase();
            this._Epart = pathArray[5].toUpperCase();
            this._Fpart = pathArray[6].toUpperCase();
        }
        if (this._Dpart != null && !this._Dpart.equals("")) {
            this.setDateTimeFromString(this._startTime, this._Dpart);
        }
        if (this._Epart != null && !this._Epart.equals("")) {
            this.setDateTimeFromString(this._endTime, this._Epart);
            this._startTime.showTimeAsBeginningOfDay(true);
        }
        System.out.println("DSS Path Parts:");
        this.checkDssPath(this._Apart, "A");
        this.checkDssPath(this._Bpart, "B");
        this.checkDssPath(this._Cpart, "C");
        this.checkDssPath(this._Dpart, "D");
        this.checkDssPath(this._Epart, "E");
        this.checkDssPath(this._Fpart, "F");
        System.out.println("");
    }

    public void printArgs() {
        System.out.println("");
        System.out.println("INPUT:\t\t" + this._inFileName);
        System.out.println("DSSFILE:\t" + this._dssFileName);
        System.out.println("PATHNAME:\t" + this._dssPathName);
        System.out.println("GRIDTYPE:\t" + this._gridTypeName);
        System.out.println("DTYPE:\t\t" + this._dataTypeName);
        System.out.println("DUNITS:\t\t" + this._dataUnits);
        if (this._utmZone != -1) {
            String label = "North";
            if (this._utmHemisphere.equals("S")) {
                label = "South";
            }
            System.out.println("UTM zone:\t\t" + this._utmZone + " " + label);
        }
        System.out.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int load() {
        GridInfo outInfo;
        FlatGrid theGridFromFlt;
        int rv;
        BufferedInputStream fltInputStream;
        BufferedReader hdrFileReader;
        if (this._inFileName == null || this._inFileName.length() < 1) {
            System.out.println("load: null or empty inFileName");
            return -1;
        }
        if (!this._inFileName.endsWith(".flt") && !this._inFileName.endsWith(".bil")) {
            System.out.println("load: input file must have .flt or .bil extension.");
            return -1;
        }
        File fltFile = new File(this._inFileName);
        File hdrFile = new File(this._inFileName.substring(0, this._inFileName.lastIndexOf(46)) + ".hdr");
        try {
            hdrFileReader = new BufferedReader(new FileReader(hdrFile));
        }
        catch (IOException ioe) {
            System.out.println("Cannot open " + hdrFile + " for input.");
            return -1;
        }
        try {
            fltInputStream = new BufferedInputStream(new FileInputStream(fltFile));
        }
        catch (IOException ioe) {
            System.out.println("Cannot open " + fltFile + " for input.");
            return -1;
        }
        this._gridTypeName = this._gridTypeName.toUpperCase();
        if (this._gridTypeName.equals(null)) {
            if (this._Apart.startsWith("SHG")) {
                this._gridTypeName = this._Apart;
            } else if (this._Apart.startsWith("UTM")) {
                this._gridTypeName = "UTM";
            } else if (this._Apart.equals("HRAP")) {
                this._gridTypeName = this._Apart;
            } else {
                Flt2DssGrid.programError("Your grid type is not supported. Make sure either the A part \nor the GRIDTYPE argument is set to HRAP, SHG, UTM, or a supported\nSHG/UTM variant, e.g., SHG500");
            }
        }
        if (this._gridTypeName.startsWith("UTM")) {
            this._useSpecifiedGridInfo = true;
        }
        if (this._dataTypeName.equals("0")) {
            this._dataType = DssDataType.PER_AVER;
        }
        if (this._dataTypeName.equals("1")) {
            this._dataType = DssDataType.PER_CUM;
        }
        if (this._dataTypeName.equals("2")) {
            this._dataType = DssDataType.INST_VAL;
        }
        if (this._dataTypeName.equals("3")) {
            this._dataType = DssDataType.INST_CUM;
        }
        if (this._dataTypeName.equals("4")) {
            this._dataType = DssDataType.FREQ;
        }
        this._dataTypeName = this._dataTypeName.toUpperCase();
        if (this._dataTypeName.equals("PER-AVER")) {
            this._dataType = DssDataType.PER_AVER;
        }
        if (this._dataTypeName.equals("PER-CUM")) {
            this._dataType = DssDataType.PER_CUM;
        }
        if (this._dataTypeName.equals("INST-VAL")) {
            this._dataType = DssDataType.INST_VAL;
        }
        if (this._dataTypeName.equals("INST-CUM")) {
            this._dataType = DssDataType.INST_CUM;
        }
        if (this._dataTypeName.equals("FREQ")) {
            this._dataType = DssDataType.FREQ;
        }
        if (this._startTime == null) {
            this._startTime = new HecTime();
        }
        if (this._endTime == null) {
            this._endTime = new HecTime();
        }
        if (this._Dpart != null && this._Dpart != "") {
            this.setDateTimeFromString(this._startTime, this._Dpart);
        }
        if (this._Epart != null && this._Epart != "") {
            this.setDateTimeFromString(this._endTime, this._Epart);
        }
        if (this._dataType.equals(DssDataType.INVAL)) {
            if (!this._endTime.isDefined()) {
                this._dataType = DssDataType.INST_VAL;
            } else if (this._startTime.isDefined()) {
                this._dataType = DssDataType.PER_CUM;
            } else {
                Flt2DssGrid.programError("A path with an end time (E part) must also \ncontain a start time (D part).");
            }
        }
        if (this._dataType.equals(DssDataType.PER_CUM) || this._dataType.equals(DssDataType.PER_AVER)) {
            if (!this._startTime.isDefined() && this._endTime.isDefined()) {
                Flt2DssGrid.programError("For period-type grids, D and E parts must both be given.");
            }
        } else {
            if (this._startTime.isDefined() && !this._endTime.isDefined()) {
                this._endTime.set(this._startTime);
            }
            if (!this._startTime.equalTo(this._endTime)) {
                Flt2DssGrid.programError("For instantaneous grids, E part must be blank and D part must be start time or blank.");
            }
        }
        if ((rv = (theGridFromFlt = new FlatGrid()).fromFlt(hdrFileReader, fltInputStream)) != 0) {
            rv = theGridFromFlt.fromBil(hdrFileReader, fltInputStream);
        }
        try {
            hdrFileReader.close();
            fltInputStream.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (rv != 0) {
            System.out.println("Input file " + this._inFileName + " does not contain valid grid data. ");
            return -1;
        }
        if (this._gridTypeName.equals("HRAP") || this._gridTypeName.equals("SHG") || this._gridTypeName.startsWith("UTM")) {
            theGridFromFlt.setOriginIndices((int)Math.floor(theGridFromFlt.getLLXcoord() / theGridFromFlt.getCellSize()), (int)Math.floor(theGridFromFlt.getLLYcoord() / theGridFromFlt.getCellSize()));
        } else {
            Flt2DssGrid.programError("Only HRAP, SHG, and UTM grids are supported at this time.");
        }
        this._startTime.showTimeAsBeginningOfDay(true);
        if (this._endTime == null || !this._endTime.isDefined()) {
            this._endTime.set(this._startTime);
            this._endTime.setTimeGranularity(2);
            this._endTime.add(1);
        }
        System.out.println("Start Time: " + this._startTime + "\n  End Time: " + this._endTime + "\n");
        if (this._dataType.equals(DssDataType.PER_CUM) || this._dataType.equals(DssDataType.PER_AVER)) {
            if (!this._startTime.isDefined() || !this._endTime.isDefined()) {
                Flt2DssGrid.programError("For period-type grids, D and E parts must both be given.");
            }
        } else if (this._startTime.isDefined() && !this._endTime.isDefined()) {
            this._endTime.set(this._startTime);
        } else if (!this._startTime.equalTo(this._endTime)) {
            Flt2DssGrid.programError("For instantaneous-type grids, the E part must blank or the same as the D part.");
        }
        GriddedData outGrid = new GriddedData();
        GridData outData = new GridData();
        if (outGrid.setDSSFileName(this._dssFileName, false) != 0) {
            System.out.println("Cannot open DSS file " + this._dssFileName + " for output.");
            return -1;
        }
        if (this._useSpecifiedGridInfo) {
            outInfo = new SpecifiedGridInfo();
            if (this._gridTypeName.equals("HRAP")) {
                ((SpecifiedGridInfo)outInfo).setSpatialReference("HRAP", "PROJCS[\"Stereographic_CONUS_HRAP\",GEOGCS[\"GCS_Sphere_LFM\",DATUM[\"D_Sphere_LFM\",SPHEROID[\"Shpere_LFM\",6371200.0,0.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Stereographic_North_Pole\"],PARAMETER[\"False_Easting\",1909762.5],PARAMETER[\"False_Northing\",7624762.5],PARAMETER[\"Central_Meridian\",-105.0],PARAMETER[\"Standard_Parallel_1\",60.0],UNIT[\"Meter\",1.0]]", 0.0f, 0.0f);
            } else if (this._gridTypeName.equals("SHG")) {
                ((SpecifiedGridInfo)outInfo).setSpatialReference("SHG", "PROJCS[\"USA_Contiguous_Albers_Equal_Area_Conic_USGS_version\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-96.0],PARAMETER[\"Standard_Parallel_1\",29.5],PARAMETER[\"Standard_Parallel_2\",45.5],PARAMETER[\"Latitude_Of_Origin\",23.0],UNIT[\"Meter\",1.0]]", 0.0f, 0.0f);
            } else if (this._gridTypeName.startsWith("UTM")) {
                int centralMeridian = -183 + this._utmZone * 6;
                int falseNorthing = 0;
                if (this._utmHemisphere.equals("S")) {
                    falseNorthing = 10000000;
                }
                ((SpecifiedGridInfo)outInfo).setSpatialReference("UTM" + this._utmZone + this._utmHemisphere, "PROJCS[\"UTM_ZONE_" + this._utmZone + this._utmHemisphere + "_WGS84\",GEOGCS[\"WGS_84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS84\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0],UNIT[\"degree\",0.01745329251994328]],UNIT[\"Meter\",1.0],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"," + centralMeridian + "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_northing\"," + falseNorthing + "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]]", 0.0f, 0.0f);
            }
        } else if (this._gridTypeName.equals("HRAP")) {
            outInfo = new HrapInfo();
        } else if (this._gridTypeName.equals("SHG")) {
            outInfo = new AlbersInfo();
            ((AlbersInfo)outInfo).setProjectionInfo(2, "METERS", 29.5f, 45.5f, -96.0f, 23.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            System.out.println("Invalid GridType " + this._gridTypeName);
            return -1;
        }
        theGridFromFlt.toGriddedData(outInfo, outData);
        outInfo = outData.getGridInfo();
        outInfo.setGridTimes(this._startTime, this._endTime);
        outInfo.setParameterInfo(this._dataUnits, this._dataType.value());
        outGrid.setGriddedPathnameParts(this._Apart, this._Bpart, this._Cpart, this._Fpart);
        if (this._dataType == DssDataType.PER_CUM || this._dataType == DssDataType.PER_AVER) {
            outGrid.setGriddedTimeWindow(this._startTime, this._endTime);
        } else {
            outGrid.setGridTime(this._startTime);
        }
        double cellSize = theGridFromFlt.getCellSize();
        if (this._gridTypeName.equals("HRAP") && cellSize != 4762.5) {
            Flt2DssGrid.programError("Cell size for HRAP grids must be 4762.5 m.\n" + cellSize + " meters is not supported for HRAP.");
        }
        if (this._gridTypeName.equals("SHG") && cellSize != 10000.0 && cellSize != 5000.0 && cellSize != 2000.0 && cellSize != 1000.0 && cellSize != 500.0 && cellSize != 200.0 && cellSize != 100.0 && cellSize != 50.0 && cellSize != 20.0 && cellSize != 10.0) {
            Flt2DssGrid.programError("Cell size " + cellSize + " meters is not supported for SHG.");
        }
        float[] range = new float[]{-3.4028235E38f, 0.0f, 1.0E-7f, 5.0f, 10.0f, 20.0f, 50.0f, 100.0f, 200.0f, 500.0f, 1000.0f, 2000.0f, 5000.0f};
        if (outData.getGridInfo()._dataUnits.toUpperCase().endsWith("F")) {
            range[1] = -40.0f;
            range[2] = -20.0f;
            range[3] = -10.0f;
            range[4] = 0.0f;
            range[5] = 10.0f;
            range[6] = 20.0f;
            range[7] = 32.0f;
            range[8] = 40.0f;
            range[9] = 60.0f;
            range[10] = 80.0f;
            range[11] = 100.0f;
            range[12] = 120.0f;
        }
        if (outData.getGridInfo()._dataUnits.toUpperCase().endsWith("C")) {
            range[1] = -40.0f;
            range[2] = -30.0f;
            range[3] = -20.0f;
            range[4] = -15.0f;
            range[5] = -10.0f;
            range[6] = -5.0f;
            range[7] = 0.0f;
            range[8] = 5.0f;
            range[9] = 10.0f;
            range[10] = 20.0f;
            range[11] = 30.0f;
            range[12] = 40.0f;
        }
        int[] n = outData.getGridInfo()._numberEqualOrExceedingRangeLimit;
        outInfo.setRangeInfo(13, range, n);
        if (this._round) {
            outData.roundValues(this._precision);
        }
        outData.updateStatistics();
        if (this._dataType != DssDataType.PER_CUM || this._use_deflate_compression) {
            outInfo.setCompressionInfo(26, 0, 1.0f, 0.0f);
        } else {
            outInfo.setCompressionInfo(101001, 0, 100.0f, 0.0f);
        }
        try {
            if (outGrid.storeGriddedData(outInfo, outData) != 0) {
                int n2 = -1;
                return n2;
            }
        }
        finally {
            outGrid.close();
        }
        if (this._verbose_mode) {
            int[] gridStat = new int[1];
            outInfo = outGrid.retrieveGriddedData(false, outData, gridStat);
            outInfo.setVerboseMode(true);
            System.out.print(outInfo);
            outData.show(10.0);
        }
        return 0;
    }

    private int getIntFromString(String str, int startAt, int[] index) throws NumberFormatException {
        int index1 = -1;
        int index2 = -1;
        for (int i = startAt; i < str.length(); ++i) {
            if (str.charAt(i) < ':' && str.charAt(i) > '/') {
                if (index1 == -1) {
                    index1 = i;
                }
                index2 = i + 1;
                continue;
            }
            if (index1 > -1) break;
        }
        if (index1 == -1) {
            throw new NumberFormatException("String " + str + " doesn't contain any numbers.");
        }
        if (index.length > 1) {
            index[0] = index1;
            index[1] = index2;
        } else {
            index[0] = 1 + index2 - index1;
        }
        return Integer.parseInt(str.substring(index1, index2));
    }

    private static String[] lineToArgs(String batchLine) {
        String sep = "\\s*,\\s*";
        String[] result = null;
        int eqCount = 0;
        int eqIndex = 0;
        int hashIndex = batchLine.indexOf("#");
        if (hashIndex > -1) {
            batchLine = batchLine.substring(0, hashIndex);
        }
        batchLine = batchLine.trim();
        while (eqIndex != -1) {
            if ((eqIndex = batchLine.indexOf(61, eqIndex + 1)) == -1) continue;
            ++eqCount;
        }
        result = batchLine.split(sep);
        if (result.length != eqCount) {
            return null;
        }
        return result;
    }

    public static int runAsBatch(String[] args) {
        BufferedReader batchFile;
        String batchFileName = null;
        int count = 0;
        int status = 0;
        String[] argsFromBatch = new String[]{""};
        Flt2DssGrid theGrid = null;
        if (args[0].indexOf("=") == -1) {
            System.out.println("batch: no file name given");
            return -1;
        }
        batchFileName = args[0].substring(args[0].indexOf("=") + 1);
        if (batchFileName == null || batchFileName.length() < 1) {
            System.out.println("batch: null or empty inFileName");
            return -1;
        }
        try {
            batchFile = new BufferedReader(new FileReader(batchFileName));
        }
        catch (IOException ioe) {
            System.out.println("Cannot open " + batchFileName + " for input.");
            return -1;
        }
        boolean linesToRead = true;
        String batchLine = null;
        while (linesToRead) {
            try {
                batchLine = batchFile.readLine();
            }
            catch (IOException e) {
                System.out.println("Exception reading from batch file " + batchFileName);
                System.out.println(e.getMessage());
                linesToRead = false;
            }
            if (batchLine == null) {
                linesToRead = false;
                break;
            }
            argsFromBatch = Flt2DssGrid.lineToArgs(batchLine);
            if (argsFromBatch == null || argsFromBatch.length == 0) continue;
            theGrid = new Flt2DssGrid(argsFromBatch);
            status = theGrid.load();
            if (status != 0) {
                System.out.println("Failed to load grid from " + batchFileName + " line:");
                System.out.println(batchLine);
                continue;
            }
            ++count;
        }
        try {
            batchFile.close();
        }
        catch (IOException e) {
            System.out.println("Exception on close of batch file " + batchFileName);
            System.out.println(e.getMessage());
        }
        return count;
    }

    public static void main(String[] args) {
        if (args[0].toUpperCase().startsWith("BAT")) {
            int count = Flt2DssGrid.runAsBatch(args);
            System.out.println("Converted " + count + " files to DSS records.");
        } else {
            Flt2DssGrid f2g = new Flt2DssGrid(args);
            int status = f2g.load();
            if (status != 0) {
                Flt2DssGrid.programError("Failed to load grid from " + f2g._inFileName + ".");
            }
        }
    }
}

