/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.grid;

import hec.heclib.grid.GridInfo;
import hec.heclib.grid.SpecifiedGridInfo;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;

public class GridData
implements Serializable {
    private static final float UNDEFINED_MAX = -2.0E38f;
    private static final float UNDEFINED_MIN = 2.0E38f;
    private static final float UNDEFINED_STORAGE = -1.0E30f;
    float[] _data;
    GridInfo _gridInfo;

    public GridData(GridData gridData) {
        this._gridInfo = GridInfo.copy(gridData.getGridInfo());
        int cellCount = this._gridInfo.getNumberOfCellsX() * this._gridInfo.getNumberOfCellsY();
        this._data = new float[cellCount];
        float[] sourceData = gridData.getData();
        for (int i = 0; i < cellCount; ++i) {
            this._data[i] = sourceData[i];
        }
    }

    public GridData() {
    }

    public GridData(float[] array, GridInfo gridInfo) {
        this._data = array;
        this._gridInfo = gridInfo;
    }

    public float[] getData() {
        return this._data;
    }

    public GridInfo getGridInfo() {
        return this._gridInfo;
    }

    public int initGridData(float[] array, GridInfo gridInfo) {
        this._data = new float[array.length];
        System.arraycopy(array, 0, this._data, 0, array.length);
        this._gridInfo = GridInfo.copy(gridInfo);
        return 0;
    }

    public void show(double ge) {
        this.show(ge, System.out);
    }

    public void show(double ge, PrintStream out) {
        if (this._data == null) {
            return;
        }
        int x = this._gridInfo.getLowerLeftCellX();
        int y = this._gridInfo.getLowerLeftCellY();
        int nx = this._gridInfo.getNumberOfCellsX();
        int ny = this._gridInfo.getNumberOfCellsY();
        out.println("= = = = = Grid Data = = = = =");
        out.println("Grid X base = " + x);
        out.println("Grid Y base = " + y);
        out.println("Grid X size = " + nx);
        out.println("Grid Y size = " + ny);
        out.println("Grid total size = " + nx * ny);
        out.println("Length Data = " + this._data.length);
        out.println("(x,y) = value >> position");
        for (int j = 0; j < ny; ++j) {
            for (int i = 0; i < nx; ++i) {
                int is = j * nx + i;
                float v = this._data[j * nx + i];
                if (!((double)v >= ge)) continue;
                out.println("(" + (i + x) + "," + (j + y) + ") = " + v + " >>" + is);
            }
        }
        out.println("======================================================");
    }

    public double getValueAt(int x, int y) {
        int originX = this._gridInfo._lowerLeftCellX;
        int cellsX = this._gridInfo._numberOfCellsX;
        int extentX = originX + cellsX;
        int originY = this._gridInfo._lowerLeftCellY;
        int cellsY = this._gridInfo._numberOfCellsY;
        int extentY = originY + cellsY;
        if (x < originX || x >= extentX || y < originY || y >= extentY) {
            return -3.4028234663852886E38;
        }
        int k = (y -= originY) * cellsX + (x -= originX);
        if (k >= this._data.length || k < 0) {
            return -3.4028234663852886E38;
        }
        if (this._data[k] == -3.4028235E38f) {
            return -3.4028234663852886E38;
        }
        return this._data[k];
    }

    public int setValueAt(int x, int y, float value) {
        int cellsX = this._gridInfo._numberOfCellsX;
        int cellsY = this._gridInfo._numberOfCellsY;
        int originX = this._gridInfo._lowerLeftCellX;
        int originY = this._gridInfo._lowerLeftCellY;
        if ((x -= originX) >= 0 && x < cellsX && (y -= originY) >= 0 && y < cellsY) {
            int k = y * cellsX + x;
            if (k > this._data.length || k < 0) {
                return -1;
            }
            this._data[k] = value;
            return 0;
        }
        return -1;
    }

    public int setValueAt(int x, int y, double value) {
        if (value == -3.4028234663852886E38) {
            return this.setValueAt(x, y, -3.4028235E38f);
        }
        return this.setValueAt(x, y, (float)value);
    }

    public int updateStatistics() {
        if (this._gridInfo == null) {
            return -1;
        }
        float max = -2.0E38f;
        float min = 2.0E38f;
        float mean = -3.4028235E38f;
        float sum = 0.0f;
        float storeValueForUndefined = -1.0E30f;
        if (this._gridInfo instanceof SpecifiedGridInfo) {
            storeValueForUndefined = ((SpecifiedGridInfo)this._gridInfo)._nullValue;
        }
        int m = this._gridInfo._numberOfRanges;
        float[] range = this._gridInfo._rangeLimitTable;
        int[] count = new int[this._gridInfo._rangeLimitTable.length];
        Arrays.fill(count, 0);
        int numDefined = 0;
        int x = this._gridInfo._numberOfCellsX;
        int y = this._gridInfo._numberOfCellsY;
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                int k = j * x + i;
                try {
                    if (k > this._data.length) continue;
                    if (this._data[k] != -3.4028235E38f && this._data[k] != -3.4028235E38f && this._data[k] != storeValueForUndefined) {
                        ++numDefined;
                        sum += this._data[k];
                        if (this._data[k] > max) {
                            max = this._data[k];
                        }
                        if (this._data[k] < min) {
                            min = this._data[k];
                        }
                        if (Float.isInfinite(this._data[k])) {
                            System.out.println("infinity found at " + k + " " + this._data[k]);
                        }
                    }
                    for (int n = 0; n < m; ++n) {
                        if (!(this._data[k] >= range[n])) continue;
                        int n2 = n;
                        count[n2] = count[n2] + 1;
                    }
                    continue;
                }
                catch (Exception e) {
                    System.out.println("error during updateStatistics. index=" + k + " error " + e);
                    e.printStackTrace();
                    return -1;
                }
            }
        }
        if (numDefined > 0) {
            mean = sum / (float)numDefined;
        }
        this._gridInfo.setDataInfo(max, min, mean);
        this._gridInfo.setRangeInfo(m, range, count);
        this._gridInfo._gridInfoSize = this._gridInfo.getGridInfoSize();
        this._gridInfo._infoSize = this._gridInfo.getInfoSize();
        return 0;
    }

    public int roundValues(int precision) {
        int i;
        float factor = 1.0f;
        float temp = 0.0f;
        if (precision < 0) {
            System.out.println("Rounding precision must be zero or higher.");
            return -1;
        }
        for (i = 0; i < precision; ++i) {
            factor *= 10.0f;
        }
        float storeValueForUndefined = -1.0E30f;
        if (this._gridInfo instanceof SpecifiedGridInfo) {
            storeValueForUndefined = ((SpecifiedGridInfo)this._gridInfo)._nullValue;
        }
        for (i = 0; i < this._data.length; ++i) {
            if (this._data[i] == -3.4028235E38f || this._data[i] == -3.4028235E38f || this._data[i] == storeValueForUndefined) continue;
            this._data[i] = (float)Math.round(this._data[i] * factor) / factor;
        }
        return 0;
    }

    public int getNumberMissing() {
        int cnt = 0;
        if (this._data == null) {
            return cnt;
        }
        for (int i = 0; i < this._data.length; ++i) {
            if (this._data[i] != -9999.0f && (double)this._data[i] != -3.4028234663852886E38) continue;
            ++cnt;
        }
        return cnt;
    }

    public void setData(float[] data) {
        this._data = data;
    }

    public void initGridInfo(GridInfo gridInfo) {
        this._gridInfo = gridInfo;
    }
}

