/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.grid;

import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DssDataType;
import hec.heclib.grid.AlbersInfo;
import hec.heclib.grid.GridInfoFlat;
import hec.heclib.grid.HrapInfo;
import hec.heclib.grid.SpecifiedGridInfo;
import hec.heclib.util.HecTime;
import hec.heclib.util.Heclib;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;
import rma.util.RMAIO;

public class GridInfo
implements Serializable {
    static final int UNDEFINED_PROJECTION_DATUM = 0;
    public static final int NAD_27 = 1;
    public static final int NAD_83 = 2;
    static final int UNDEFINED_COMPRESSION_METHOD = 0;
    static final int PRECIP_2_BYTE = 101001;
    static final int ZLIB_DEFLATE = 26;
    static final int NO_COMPRESSION = 1;
    public static final float GRID_NODATA_VALUE = -3.4028235E38f;
    public static final int DSS7_GRID_STRUCT_VERSION = 100;
    public static final int GRID_STRUCT_VERSION_UNDEFINED = -1;
    int _gridType;
    int _infoSize;
    int _gridInfoSize;
    int _version = 1;
    int gridStructVersion = -1;
    boolean _verbose = false;
    HecTime _startTime = new HecTime();
    HecTime _endTime = new HecTime();
    String _dataUnits = "";
    int _dataType;
    int _lowerLeftCellX;
    int _lowerLeftCellY;
    int _numberOfCellsX;
    int _numberOfCellsY;
    float _cellSize;
    int _compressionMethod;
    int _sizeofCompressedElements;
    float _compressionScaleFactor;
    float _compressionBase;
    float _maxDataValue;
    float _minDataValue;
    float _meanDataValue;
    int _numberOfRanges;
    float[] _rangeLimitTable = new float[20];
    int[] _numberEqualOrExceedingRangeLimit = new int[20];

    public GridInfo() {
        this._infoSize = this._gridInfoSize = 124;
        this._lowerLeftCellX = Integer.MIN_VALUE;
        this._lowerLeftCellY = Integer.MIN_VALUE;
        this._numberOfCellsX = Integer.MIN_VALUE;
        this._numberOfCellsY = Integer.MIN_VALUE;
        this._cellSize = -3.4028235E38f;
        this._compressionMethod = 0;
        this._sizeofCompressedElements = Integer.MIN_VALUE;
        this._compressionScaleFactor = -3.4028235E38f;
        this._compressionBase = -3.4028235E38f;
        this._maxDataValue = -3.4028235E38f;
        this._minDataValue = -3.4028235E38f;
        this._meanDataValue = -3.4028235E38f;
        this._numberOfRanges = 13;
        this._rangeLimitTable[0] = -3.4028235E38f;
        this._rangeLimitTable[1] = 0.0f;
        this._rangeLimitTable[2] = 1.0E-7f;
        this._rangeLimitTable[3] = 5.0f;
        this._rangeLimitTable[4] = 10.0f;
        this._rangeLimitTable[5] = 20.0f;
        this._rangeLimitTable[6] = 50.0f;
        this._rangeLimitTable[7] = 100.0f;
        this._rangeLimitTable[8] = 200.0f;
        this._rangeLimitTable[9] = 500.0f;
        this._rangeLimitTable[10] = 1000.0f;
        this._rangeLimitTable[11] = 2000.0f;
        this._rangeLimitTable[12] = 5000.0f;
    }

    public GridInfo(GridInfo gridInfo) {
        this._gridType = gridInfo._gridType;
        this._infoSize = gridInfo._infoSize;
        this._gridInfoSize = gridInfo._gridInfoSize;
        this._version = gridInfo._version;
        this.gridStructVersion = gridInfo.gridStructVersion;
        this._startTime.set(gridInfo._startTime);
        this._endTime.set(gridInfo._endTime);
        this._dataUnits = gridInfo._dataUnits;
        this._dataType = gridInfo._dataType;
        this._lowerLeftCellX = gridInfo._lowerLeftCellX;
        this._lowerLeftCellY = gridInfo._lowerLeftCellY;
        this._numberOfCellsX = gridInfo._numberOfCellsX;
        this._numberOfCellsY = gridInfo._numberOfCellsY;
        this._cellSize = gridInfo._cellSize;
        this._compressionMethod = gridInfo._compressionMethod;
        this._sizeofCompressedElements = gridInfo._sizeofCompressedElements;
        this._compressionScaleFactor = gridInfo._compressionScaleFactor;
        this._compressionBase = gridInfo._compressionBase;
        this._maxDataValue = gridInfo._maxDataValue;
        this._minDataValue = gridInfo._minDataValue;
        this._meanDataValue = gridInfo._meanDataValue;
        this._numberOfRanges = gridInfo._numberOfRanges;
        int length = gridInfo._rangeLimitTable.length;
        this._rangeLimitTable = new float[length];
        System.arraycopy(gridInfo._rangeLimitTable, 0, this._rangeLimitTable, 0, length);
        length = gridInfo._numberEqualOrExceedingRangeLimit.length;
        this._numberEqualOrExceedingRangeLimit = new int[length];
        System.arraycopy(gridInfo._numberEqualOrExceedingRangeLimit, 0, this._numberEqualOrExceedingRangeLimit, 0, length);
    }

    public static GridInfo copy(GridInfo gridInfo) {
        GridInfo info = null;
        info = gridInfo instanceof AlbersInfo ? new AlbersInfo((AlbersInfo)gridInfo) : (gridInfo instanceof HrapInfo ? new HrapInfo((HrapInfo)gridInfo) : (gridInfo instanceof SpecifiedGridInfo ? new SpecifiedGridInfo((SpecifiedGridInfo)gridInfo) : new GridInfo(gridInfo)));
        return info;
    }

    public void show() {
        this.show(System.out);
    }

    public void show(PrintStream out) {
        this.show(new BufferedWriter(new OutputStreamWriter(out)));
    }

    public void show(BufferedWriter out) {
        RMAIO.fout(out, this.toString());
    }

    public String toString() {
        String temp;
        Object theString = "";
        if (this._verbose) {
            theString = (String)theString + "= = = GridInfo = = =\n";
        }
        if (this._verbose) {
            theString = (String)theString + "GridStruct Version:  " + this.gridStructVersion + "\n";
        }
        if (this._verbose) {
            theString = (String)theString + "GridInfo Version:  " + this._version + "\n";
        }
        switch (this._gridType) {
            case 420: 
            case 421: {
                temp = "ALBERS";
                break;
            }
            case 410: 
            case 411: {
                temp = "HRAP";
                break;
            }
            case 430: 
            case 431: {
                temp = "SPECIFIED SPATIAL REFERENCE SYSTEM";
                break;
            }
            default: {
                temp = "UNDEFINED SPATIAL REFERENCE";
            }
        }
        theString = (String)theString + "Grid Type: " + temp;
        if (this._verbose) {
            theString = (String)theString + " (" + this._gridType + ")";
        }
        theString = (String)theString + "\n";
        if (this._verbose) {
            theString = (String)theString + "Info Size: " + this._infoSize + "\n";
        }
        if (this._verbose) {
            theString = (String)theString + "Grid Info Size: " + this._gridInfoSize + "\n";
        }
        temp = "assumed UTC";
        if (this instanceof SpecifiedGridInfo) {
            temp = ((SpecifiedGridInfo)this)._timeZoneID;
        }
        theString = (String)theString + "Start Time(" + temp + "): " + this._startTime.toString(2) + "\n";
        theString = (String)theString + "End Time(" + temp + "):   " + this._endTime.toString(2) + "\n";
        theString = (String)theString + "Data Units: " + this._dataUnits + "\n";
        if (this._verbose) {
            theString = (String)theString + "Data Type: " + this.getDataTypeName() + " (" + this._dataType + ")\n";
            theString = (String)theString + "Lower Left CellX: " + this._lowerLeftCellX + "\n";
            theString = (String)theString + "Lower Left CellY: " + this._lowerLeftCellY + "\n";
            theString = (String)theString + "Number Of CellsX: " + this._numberOfCellsX + "\n";
            theString = (String)theString + "Number Of CellsY: " + this._numberOfCellsY + "\n";
        } else {
            theString = (String)theString + "Data Type: " + this.getDataTypeName() + "\n";
            theString = (String)theString + "Lower Left Cell: (" + this._lowerLeftCellX + ", " + this._lowerLeftCellY + ")\n";
            theString = (String)theString + "Grid Extents: (" + this._numberOfCellsX + ", " + this._numberOfCellsY + ")\n";
        }
        theString = (String)theString + "Cell Size: " + this._cellSize + "\n";
        switch (this._compressionMethod) {
            case 101001: {
                temp = "PRECIP_2_BYTE";
                break;
            }
            case 26: {
                temp = "ZLIB Deflate";
            }
        }
        if (this._verbose) {
            theString = (String)theString + "Compression Method: " + temp + " (" + this._compressionMethod + ")\n";
        }
        if (this._verbose) {
            theString = (String)theString + "Size of Compressed Elements: " + this._sizeofCompressedElements + "\n";
        }
        if (this._verbose) {
            theString = (String)theString + "Compression Scale Factor: " + this._compressionScaleFactor + "\n";
        }
        if (this._verbose) {
            theString = (String)theString + "Compression Base: " + this._compressionBase + "\n";
        }
        theString = (String)theString + "Max Data Value: " + this._maxDataValue + "\n";
        theString = (String)theString + "Min Data Value: " + this._minDataValue + "\n";
        theString = (String)theString + "Mean Data Value: " + this._meanDataValue + "\n";
        if (this._verbose) {
            theString = (String)theString + "Number Of Ranges: " + this._numberOfRanges + "\n";
            theString = (String)theString + " = = = = = = = = Range Limit Table = = = = = = = =\n";
            theString = (String)theString + "Range\t\t> or =\t\tIncremental Count\n";
            for (int i = 0; i < this._numberOfRanges; ++i) {
                theString = this._rangeLimitTable[i] == -3.4028235E38f || this._rangeLimitTable[i] == -1.0E38f ? (String)theString + "NULL\t\t" : (String)theString + this._rangeLimitTable[i] + "\t\t";
                theString = i < this._numberOfRanges - 1 ? (String)theString + this._numberEqualOrExceedingRangeLimit[i] + "\t\t" + (this._numberEqualOrExceedingRangeLimit[i] - this._numberEqualOrExceedingRangeLimit[i + 1]) + "\n" : (String)theString + this._numberEqualOrExceedingRangeLimit[i] + "\t\t" + this._numberEqualOrExceedingRangeLimit[i] + "\n";
                if (this._numberEqualOrExceedingRangeLimit[i] == 0) break;
            }
        }
        theString = (String)theString + "====================================================\n";
        return theString;
    }

    public void showRanges(BufferedWriter out) {
        RMAIO.fout(out, " = = = Range Limit Table = = =");
        RMAIO.fout(out, " 1:            " + RMAIO.leftJustify(7, String.valueOf(this._rangeLimitTable[1])) + " = " + this._numberEqualOrExceedingRangeLimit[1]);
        for (int i = 1; i < this._numberOfRanges - 1; ++i) {
            RMAIO.fout(out, RMAIO.leftJustify(2, String.valueOf(i + 1)) + ": " + RMAIO.leftJustify(7, String.valueOf(this._rangeLimitTable[i])) + " to " + RMAIO.leftJustify(7, String.valueOf(this._rangeLimitTable[i + 1])) + " = " + this._numberEqualOrExceedingRangeLimit[i]);
        }
        RMAIO.fout(out, "====================================================");
    }

    public int setParameterInfo(String dataUnits, int dataType) {
        this._dataUnits = dataUnits;
        this._dataType = dataType;
        return 0;
    }

    public int setCellInfo(int lowerLeftCellX, int lowerLeftCellY, int numberOfCellsX, int numberOfCellsY, float cellSize) {
        this._lowerLeftCellX = lowerLeftCellX;
        this._lowerLeftCellY = lowerLeftCellY;
        this._numberOfCellsX = numberOfCellsX;
        this._numberOfCellsY = numberOfCellsY;
        this._cellSize = cellSize;
        return 0;
    }

    public void setCompressionMethod(int compressionMethod) {
        this._compressionMethod = compressionMethod;
    }

    public int setCompressionInfo(int compressionMethod, int sizeofCompressedElements, float compressionScaleFactor, float compressionBase) {
        this._compressionMethod = compressionMethod;
        this._sizeofCompressedElements = sizeofCompressedElements;
        this._compressionScaleFactor = compressionScaleFactor;
        this._compressionBase = compressionBase;
        return 0;
    }

    public void setDataType(int type) {
        this._dataType = type;
    }

    public void setMaxDataValue(double max) {
        this._maxDataValue = (float)max;
    }

    public int setDataInfo(float maxDataValue, float minDataValue, float meanDataValue) {
        this._maxDataValue = maxDataValue;
        this._minDataValue = minDataValue;
        this._meanDataValue = meanDataValue;
        return 0;
    }

    public int setRangeInfo(int numberOfRanges, float[] rangeLimitTable, int[] numberEqualOrExceedingRangeLimit) {
        this._numberOfRanges = numberOfRanges;
        if (numberOfRanges > 0) {
            this._rangeLimitTable = new float[numberOfRanges];
            this._numberEqualOrExceedingRangeLimit = new int[numberOfRanges];
            for (int i = 0; i < numberOfRanges; ++i) {
                this._rangeLimitTable[i] = rangeLimitTable[i];
                this._numberEqualOrExceedingRangeLimit[i] = numberEqualOrExceedingRangeLimit[i];
            }
        }
        return 0;
    }

    public int flatSize() {
        if (this._version == 1) {
            return 252;
        }
        return 264;
    }

    public int loadFlatData(GridInfoFlat a) {
        a._gridType = this._gridType;
        a._infoSize = this._infoSize;
        a._gridInfoSize = this._gridInfoSize;
        a._startTime = this._startTime.value();
        a._endTime = this._endTime != null ? this._endTime.value() : Integer.MIN_VALUE;
        Heclib.StringHol(this._dataUnits, this._dataUnits.length(), a._dataUnits);
        a._dataType = this._dataType;
        a._lowerLeftCellX = this._lowerLeftCellX;
        a._lowerLeftCellY = this._lowerLeftCellY;
        a._numberOfCellsX = this._numberOfCellsX;
        a._numberOfCellsY = this._numberOfCellsY;
        a._cellSize = this._cellSize;
        a._compressionMethod = this._compressionMethod;
        a._sizeofCompressedElements = this._sizeofCompressedElements;
        a._compressionScaleFactor = this._compressionScaleFactor;
        a._compressionBase = this._compressionBase;
        a._maxDataValue = this._maxDataValue;
        a._minDataValue = this._minDataValue;
        a._meanDataValue = this._meanDataValue;
        int number = this._numberOfRanges;
        if (number > 20) {
            number = 20;
        }
        a._numberOfRanges = number;
        for (int i = 0; i < number; ++i) {
            a._rangeLimitTable[i] = this._rangeLimitTable[i];
            a._numberEqualOrExceedingRangeLimit[i] = this._numberEqualOrExceedingRangeLimit[i];
        }
        return 0;
    }

    public int convertToGridInfo(GridInfoFlat b) {
        this._infoSize = this._gridInfoSize = 124;
        this._startTime.set(b._startTime);
        this._startTime.showTimeAsBeginningOfDay(true);
        this._endTime.set(b._endTime);
        this._dataUnits = Heclib.holString(b._dataUnits, 12);
        this._dataType = b._dataType;
        this._lowerLeftCellX = b._lowerLeftCellX;
        this._lowerLeftCellY = b._lowerLeftCellY;
        this._numberOfCellsX = b._numberOfCellsX;
        this._numberOfCellsY = b._numberOfCellsY;
        this._cellSize = b._cellSize;
        this._compressionMethod = b._compressionMethod;
        this._sizeofCompressedElements = b._sizeofCompressedElements;
        this._compressionScaleFactor = b._compressionScaleFactor;
        this._compressionBase = b._compressionBase;
        this._maxDataValue = b._maxDataValue;
        this._minDataValue = b._minDataValue;
        this._meanDataValue = b._meanDataValue;
        this._numberOfRanges = b._numberOfRanges;
        for (int i = 0; i < this._numberOfRanges && i < 20; ++i) {
            this._rangeLimitTable[i] = b._rangeLimitTable[i];
            this._numberEqualOrExceedingRangeLimit[i] = b._numberEqualOrExceedingRangeLimit[i];
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GridInfo)) {
            return false;
        }
        GridInfo gi = (GridInfo)obj;
        return this._gridType == gi._gridType && this._infoSize == gi._infoSize && this._gridInfoSize == gi._gridInfoSize && this._dataUnits.equalsIgnoreCase(gi._dataUnits) && this._dataType == gi._dataType && this._lowerLeftCellX == gi._lowerLeftCellX && this._lowerLeftCellY == gi._lowerLeftCellY && this._numberOfCellsX == gi._numberOfCellsX && this._numberOfCellsY == gi._numberOfCellsY && this._cellSize == gi._cellSize;
    }

    public void set(GridInfo gi) {
        this._gridType = gi._gridType;
        this._infoSize = gi._infoSize;
        this._gridInfoSize = gi._gridInfoSize;
        this._dataUnits = gi._dataUnits;
        this._dataType = gi._dataType;
        this._lowerLeftCellX = gi._lowerLeftCellX;
        this._lowerLeftCellY = gi._lowerLeftCellY;
        this._numberOfCellsX = gi._numberOfCellsX;
        this._numberOfCellsY = gi._numberOfCellsY;
        this._cellSize = gi._cellSize;
        this._compressionMethod = gi._compressionMethod;
        this._sizeofCompressedElements = gi._sizeofCompressedElements;
        this._compressionScaleFactor = gi._compressionScaleFactor;
        this._compressionBase = gi._compressionBase;
        this._maxDataValue = gi._maxDataValue;
        this._minDataValue = gi._minDataValue;
        this._meanDataValue = gi._meanDataValue;
        this._numberOfRanges = gi._numberOfRanges;
        this._rangeLimitTable = (float[])gi._rangeLimitTable.clone();
        this._numberEqualOrExceedingRangeLimit = (int[])gi._numberEqualOrExceedingRangeLimit.clone();
    }

    public void setGridTimes(String start, String end) {
        this._startTime = new HecTime(start);
        this._startTime.showTimeAsBeginningOfDay(true);
        this._endTime = new HecTime(end);
    }

    public void setGridTimes(Date start, Date end) {
        this._startTime = new HecTime(start, 0);
        this._startTime.showTimeAsBeginningOfDay(true);
        this._endTime = new HecTime(end, 0);
    }

    public void setGridTimes(HecTime start, HecTime end) {
        this._startTime = new HecTime(start);
        this._startTime.showTimeAsBeginningOfDay(true);
        this._endTime = new HecTime(end);
    }

    public static int getUndefinedProjectionDatum() {
        return 0;
    }

    public int getGridType() {
        return this._gridType;
    }

    public int getCompressionMethod() {
        return this._compressionMethod;
    }

    public int getLowerLeftCellX() {
        return this._lowerLeftCellX;
    }

    public int getLowerLeftCellY() {
        return this._lowerLeftCellY;
    }

    public int getNumberOfCellsX() {
        return this._numberOfCellsX;
    }

    public int getNumberOfCellsY() {
        return this._numberOfCellsY;
    }

    public float getCellSize() {
        return this._cellSize;
    }

    public String getSpatialReferenceSystem() {
        return "";
    }

    public static int getNad27() {
        return 1;
    }

    public static int getNad83() {
        return 2;
    }

    public static int getUndefinedCompressionMethod() {
        return 0;
    }

    public static int getPrecip2Byte() {
        return 101001;
    }

    public static int getZlibDeflate() {
        return 26;
    }

    public static float getGridNodataValue() {
        return -3.4028235E38f;
    }

    public int getInfoSize() {
        return this._infoSize;
    }

    public int getGridInfoSize() {
        return this._gridInfoSize;
    }

    public int getVersion() {
        return this._version;
    }

    public int getSizeOfCompressedElements() {
        return this._sizeofCompressedElements;
    }

    public float getCompressionScaleFactor() {
        return this._compressionScaleFactor;
    }

    public float getCompressionBase() {
        return this._compressionBase;
    }

    public String getStartTime() {
        return this._startTime.toString();
    }

    public String getEndTime() {
        return this._endTime.toString();
    }

    public String getTimePeriod() {
        return this.getStartTime() + " to " + this.getEndTime();
    }

    public float getMaxValue() {
        return this._maxDataValue;
    }

    public float getMinValue() {
        return this._minDataValue;
    }

    public float getMeanValue() {
        return this._meanDataValue;
    }

    public float getMaxDataValue() {
        return this._maxDataValue;
    }

    public float getMinDataValue() {
        return this._minDataValue;
    }

    public float getMeanDataValue() {
        return this._meanDataValue;
    }

    public int getRangeNum() {
        return this._numberOfRanges;
    }

    public float[] getRangeLimitTable() {
        return this._rangeLimitTable;
    }

    public String getDataUnits() {
        return this._dataUnits;
    }

    public void setDataUnits(String dataUnits) {
        this._dataUnits = dataUnits;
    }

    public int getDataType() {
        return this._dataType;
    }

    public String getDataTypeName() {
        DssDataType[] typeArray = DssDataType.getDataTypeArray();
        String dataTypeName = "UNKNOWN";
        if (this._dataType >= 0 && this._dataType < typeArray.length) {
            dataTypeName = typeArray[this._dataType].toString();
        }
        return dataTypeName;
    }

    public void getRange() {
        for (int i = 0; i < this._rangeLimitTable.length; ++i) {
            System.out.println(this._rangeLimitTable[i]);
        }
    }

    public int[] getNumEqual() {
        return this._numberEqualOrExceedingRangeLimit;
    }

    public static void getStartTimeFromPath(String gridPath, HecTime time) {
        GridInfo.getTimeFromPath(gridPath, time, 3);
    }

    public static void getEndTimeFromPath(String gridPath, HecTime time) {
        GridInfo.getTimeFromPath(gridPath, time, 4);
    }

    private static void getTimeFromPath(String gridPath, HecTime time, int loc) {
        if (gridPath == null || gridPath.length() == 0) {
            time.setUndefined();
            return;
        }
        Vector<String> pathNames = DSSPathname.parseDssPath(gridPath);
        if (pathNames == null) {
            time.setUndefined();
            return;
        }
        pathNames.trimToSize();
        String s = pathNames.elementAt(loc).toString();
        int idx = s.indexOf(58);
        if (idx > -1) {
            time.set(s.substring(0, idx), s.substring(idx + 1));
        } else {
            time.setUndefined();
        }
    }

    public void setVerboseMode(boolean verbose) {
        this._verbose = verbose;
    }

    public void setGridType(int gridType) {
        this._gridType = gridType;
    }
}

