/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.grid;

import hec.heclib.util.Heclib;

public class GridInfoFlat {
    int _infoFlatSize;
    int _gridType;
    int _infoSize;
    int _gridInfoSize;
    int _startTime;
    int _endTime;
    int[] _dataUnits = new int[3];
    int _dataType;
    int _lowerLeftCellX;
    int _lowerLeftCellY;
    int _numberOfCellsX;
    int _numberOfCellsY;
    float _cellSize = -3.4028235E38f;
    int _compressionMethod;
    int _sizeofCompressedElements;
    float _compressionScaleFactor = -3.4028235E38f;
    float _compressionBase = -3.4028235E38f;
    float _maxDataValue = -3.4028235E38f;
    float _minDataValue = -3.4028235E38f;
    float _meanDataValue = -3.4028235E38f;
    int _numberOfRanges = 0;
    float[] _rangeLimitTable = new float[20];
    int[] _numberEqualOrExceedingRangeLimit = new int[20];

    public GridInfoFlat() {
        int i;
        this._gridType = Integer.MIN_VALUE;
        this._infoSize = Integer.MIN_VALUE;
        this._gridInfoSize = Integer.MIN_VALUE;
        this._startTime = Integer.MIN_VALUE;
        this._endTime = Integer.MIN_VALUE;
        this._dataType = Integer.MIN_VALUE;
        this._lowerLeftCellX = Integer.MIN_VALUE;
        this._lowerLeftCellY = Integer.MIN_VALUE;
        this._numberOfCellsX = Integer.MIN_VALUE;
        this._numberOfCellsY = Integer.MIN_VALUE;
        this._compressionMethod = Integer.MIN_VALUE;
        this._sizeofCompressedElements = Integer.MIN_VALUE;
        for (i = 0; i < 3; ++i) {
            this._dataUnits[i] = 0;
        }
        for (i = 0; i < 20; ++i) {
            this._rangeLimitTable[i] = 0.0f;
            this._numberEqualOrExceedingRangeLimit[i] = 0;
        }
        this._infoFlatSize = this.size();
    }

    public int size() {
        return 252;
    }

    public void flatten(int[] array) {
        int i;
        int pos = 0;
        array[pos++] = this._infoFlatSize;
        array[pos++] = this._gridType;
        array[pos++] = this._infoSize;
        array[pos++] = this._gridInfoSize;
        array[pos++] = this._startTime;
        array[pos++] = this._endTime;
        array[pos++] = this._dataUnits[0];
        array[pos++] = this._dataUnits[1];
        array[pos++] = this._dataUnits[2];
        array[pos++] = this._dataType;
        array[pos++] = this._lowerLeftCellX;
        array[pos++] = this._lowerLeftCellY;
        array[pos++] = this._numberOfCellsX;
        array[pos++] = this._numberOfCellsY;
        array[pos++] = Float.floatToIntBits(this._cellSize);
        array[pos++] = this._compressionMethod;
        array[pos++] = this._sizeofCompressedElements;
        array[pos++] = Float.floatToIntBits(this._compressionScaleFactor);
        array[pos++] = Float.floatToIntBits(this._compressionBase);
        array[pos++] = Float.floatToIntBits(this._maxDataValue);
        array[pos++] = Float.floatToIntBits(this._minDataValue);
        array[pos++] = Float.floatToIntBits(this._meanDataValue);
        array[pos++] = this._numberOfRanges;
        for (i = 0; i < 20; ++i) {
            array[pos++] = Float.floatToIntBits(this._rangeLimitTable[i]);
        }
        for (i = 0; i < 20; ++i) {
            array[pos++] = this._numberEqualOrExceedingRangeLimit[i];
        }
    }

    public boolean unflatten(int[] array) {
        int i;
        if (array.length < 27) {
            return false;
        }
        int pos = 0;
        this._infoFlatSize = array[pos++];
        this._gridType = array[pos++];
        this._infoSize = array[pos++];
        this._gridInfoSize = array[pos++];
        this._startTime = array[pos++];
        this._endTime = array[pos++];
        this._dataUnits[0] = array[pos++];
        this._dataUnits[1] = array[pos++];
        this._dataUnits[2] = array[pos++];
        this._dataType = array[pos++];
        this._lowerLeftCellX = array[pos++];
        this._lowerLeftCellY = array[pos++];
        this._numberOfCellsX = array[pos++];
        this._numberOfCellsY = array[pos++];
        this._cellSize = Float.intBitsToFloat(array[pos++]);
        this._compressionMethod = array[pos++];
        this._sizeofCompressedElements = array[pos++];
        this._compressionScaleFactor = Float.intBitsToFloat(array[pos++]);
        this._compressionBase = Float.intBitsToFloat(array[pos++]);
        this._maxDataValue = Float.intBitsToFloat(array[pos++]);
        this._minDataValue = Float.intBitsToFloat(array[pos++]);
        this._meanDataValue = Float.intBitsToFloat(array[pos++]);
        this._numberOfRanges = array[pos++];
        if (array.length < pos + 39) {
            return false;
        }
        for (i = 0; i < 20; ++i) {
            this._rangeLimitTable[i] = Float.intBitsToFloat(array[pos++]);
        }
        for (i = 0; i < 20; ++i) {
            this._numberEqualOrExceedingRangeLimit[i] = array[pos++];
        }
        if (this._minDataValue > this._maxDataValue) {
            this._maxDataValue = Float.NEGATIVE_INFINITY;
            this._minDataValue = Float.NEGATIVE_INFINITY;
            this._meanDataValue = Float.NEGATIVE_INFINITY;
        } else {
            if (this._maxDataValue <= -1.0E38f) {
                this._maxDataValue = Float.NEGATIVE_INFINITY;
            }
            if (this._minDataValue <= -1.0E38f) {
                this._minDataValue = Float.NEGATIVE_INFINITY;
            }
            if (this._meanDataValue <= -1.0E38f) {
                this._meanDataValue = Float.NEGATIVE_INFINITY;
            }
        }
        return true;
    }

    public int gridType() {
        return this._gridType;
    }

    protected void show() {
        System.out.println("\n = = = GridInfoFlat = = =");
        System.out.println("infoFlatSize: " + this._infoFlatSize);
        System.out.println("gridType: " + this._gridType);
        System.out.println("infoSize: " + this._infoSize);
        System.out.println("gridInfoSize: " + this._gridInfoSize);
        System.out.println("startTime: " + this._startTime);
        System.out.println("endTime: " + this._endTime);
        String temp = Heclib.holString(this._dataUnits, 12);
        System.out.println("dataUnits: " + temp);
        System.out.println("dataType: " + this._dataType);
        System.out.println("lowerLeftCellX: " + this._lowerLeftCellX);
        System.out.println("lowerLeftCellY: " + this._lowerLeftCellY);
        System.out.println("numberOfCellsX: " + this._numberOfCellsX);
        System.out.println("numberOfCellsY: " + this._numberOfCellsY);
        System.out.println("cellSize: " + this._cellSize);
        System.out.println("compressionMethod: " + this._compressionMethod);
        System.out.println("sizeofCompressedElements: " + this._sizeofCompressedElements);
        System.out.println("compressionScaleFactor: " + this._compressionScaleFactor);
        System.out.println("compressionBase: " + this._compressionBase);
        System.out.println("maxDataValue: " + this._maxDataValue);
        System.out.println("minDataValue: " + this._minDataValue);
        System.out.println("meanDataValue: " + this._meanDataValue);
        System.out.println("numberOfRanges: " + this._numberOfRanges);
        System.out.println("      RangeLimit       numberEqualOrExceedingRangeLimit ");
        for (int i = 0; i < this._numberOfRanges; ++i) {
            System.out.println("  " + i + "   " + this._rangeLimitTable[i] + "   " + this._numberEqualOrExceedingRangeLimit[i]);
        }
        System.out.println("====================================================");
    }
}

