/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.grid;

import hec.heclib.grid.AlbersInfo;
import hec.heclib.grid.GridInfo;
import hec.heclib.grid.GridStructException;
import hec.heclib.grid.HrapInfo;
import hec.heclib.grid.SpecifiedGridInfo;
import hec.io.DataContainer;
import java.io.Serializable;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GridStructContainer
extends DataContainer
implements Cloneable,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(GridStructContainer.class.getName());
    private static final long serialVersionUID = -5193682614335303757L;
    int _type;
    int _version;
    int _structVersion;
    String _dataUnits;
    int _dataType;
    String _dataSource;
    int _lowerLeftCellX;
    int _lowerLeftCellY;
    int _numberOfCellsX;
    int _numberOfCellsY;
    float _cellSize;
    int _compressionMethod;
    int _sizeofCompressedElements;
    float _compressionScaleFactor;
    float _compressionBase;
    float _maxDataValue;
    float _minDataValue;
    float _meanDataValue;
    int _numberOfRanges;
    float[] _rangeLimitTable;
    int[] _numberEqualOrExceedingRangeLimit;
    String _srsName;
    int _srsDefinitionType;
    String _srsDefinition;
    float _xCoordOfGridCellZero;
    float _yCoordOfGridCellZero;
    float _nullValue;
    String _timeZoneID;
    int _timeZoneRawOffset;
    int _isInterval;
    int _isTimeStamped;
    int _storageDataType;
    float[] _data;

    GridStructContainer() {
    }

    public void setCompressionMethod(int compressionMethod) throws GridStructException {
        if (compressionMethod != 1 && compressionMethod != 26) {
            throw new GridStructException("Unsupported Gridded Data Compression");
        }
        this._compressionMethod = compressionMethod;
    }

    private String getAlbersSpatialReferenceSystem(AlbersInfo ginfo) {
        String str = ginfo.getSpatialReferenceSystem();
        String pu = null;
        if (str.equals("")) {
            String datum = "UNDEFINED";
            switch (ginfo.getProjectionDatum()) {
                case 2: {
                    datum = "North_American_1983";
                    break;
                }
                case 1: {
                    datum = "North_American_1927";
                }
            }
            pu = ginfo.getProjectionUnits().equalsIgnoreCase("meters") ? "UNIT[\"" + ginfo.getProjectionUnits() + "\",1.0]]" : "UNIT[\"" + ginfo.getProjectionUnits() + "\",0.0]]";
            return "PROJCS[\"USA_Contiguous_Albers_Equal_Area_Conic_USGS_version\",GEOGCS[\"GCS_" + datum + "\",DATUM[\"D_" + datum + "\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\"," + ginfo.getFalseEasting() + "],PARAMETER[\"False_Northing\"," + ginfo.getFalseNorthing() + "],PARAMETER[\"Central_Meridian\"," + ginfo.getCentralMeridian() + "],PARAMETER[\"Standard_Parallel_1\"," + ginfo.getFirstStandardParallel() + "],PARAMETER[\"Standard_Parallel_2\"," + ginfo.getSecondStandardParallel() + "],PARAMETER[\"Latitude_Of_Origin\"," + ginfo.getLatitudeOfProjectionOrigin() + "]," + pu;
        }
        return str;
    }

    private float getParameter(String param, String srs) {
        String ParamP = "PARAMETER\\[\"" + param + "\",(-?\\d*\\.*\\d+)";
        Pattern pt = Pattern.compile(ParamP);
        Matcher matcher = pt.matcher(srs);
        if (matcher.find()) {
            String match = matcher.group(1);
            try {
                return Float.parseFloat(match);
            }
            catch (Exception e) {
                LOGGER.warning("Error Parsing parameter " + param + " from : + " + srs);
            }
        }
        return 0.0f;
    }

    private void setAlbersSpatialReferenceInfo(AlbersInfo ginfo, String strInfo) {
        String datumP = "DATUM\\[\"D_North_American_19(\\d\\d)";
        Pattern pt = Pattern.compile(datumP);
        Matcher matcher = pt.matcher(strInfo);
        if (matcher.find()) {
            String datumS = matcher.group(1);
            ginfo.setProjectionDatum(0);
            try {
                int datumV = Integer.parseInt(datumS);
                if (datumV == 27) {
                    ginfo.setProjectionDatum(1);
                } else if (datumV == 83) {
                    ginfo.setProjectionDatum(2);
                }
            }
            catch (Exception e) {
                LOGGER.warning("Error Parsing datum from : + " + strInfo);
            }
        }
        ginfo.setFalseEastingAndNorthing(this.getParameter("False_Easting", strInfo), this.getParameter("False_Northing", strInfo));
        ginfo.setCentralMeridian(this.getParameter("Central_Meridian", strInfo));
        ginfo.setStandardParallels(this.getParameter("Standard_Parallel_1", strInfo), this.getParameter("Standard_Parallel_2", strInfo));
        ginfo.setLatitudeOfProjectionOrigin(this.getParameter("Latitude_Of_Origin", strInfo));
        pt = Pattern.compile("UNIT\\[\"(.*?)\"");
        matcher = pt.matcher(strInfo);
        try {
            while (matcher.find()) {
                ginfo.setProjectionUnits(matcher.group(1));
            }
        }
        catch (Exception e) {
            ginfo.setProjectionUnits("UNDEFINED");
        }
    }

    GridStructContainer(GridInfo gridInfo) {
        this._version = gridInfo._version;
        this._type = gridInfo._gridType;
        this._dataUnits = gridInfo._dataUnits;
        this._dataType = gridInfo._dataType;
        this._lowerLeftCellX = gridInfo._lowerLeftCellX;
        this._lowerLeftCellY = gridInfo._lowerLeftCellY;
        this._numberOfCellsX = gridInfo._numberOfCellsX;
        this._numberOfCellsY = gridInfo._numberOfCellsY;
        this._cellSize = gridInfo._cellSize;
        this._compressionMethod = 26;
        this._compressionMethod = 26;
        this._maxDataValue = gridInfo._maxDataValue;
        this._minDataValue = gridInfo._minDataValue;
        this._meanDataValue = gridInfo._meanDataValue;
        this._numberOfRanges = gridInfo._numberOfRanges;
        this._storageDataType = 0;
        if (this._numberOfRanges > 0) {
            this._rangeLimitTable = new float[this._numberOfRanges];
            this._numberEqualOrExceedingRangeLimit = new int[this._numberOfRanges];
            for (int i = 0; i < this._numberOfRanges; ++i) {
                this._rangeLimitTable[i] = gridInfo._rangeLimitTable[i];
                this._numberEqualOrExceedingRangeLimit[i] = gridInfo._numberEqualOrExceedingRangeLimit[i];
            }
        }
        if (gridInfo instanceof HrapInfo) {
            this._dataSource = ((HrapInfo)gridInfo)._dataSource;
            this._srsDefinition = ((HrapInfo)gridInfo).getSpatialReferenceSystem();
            this._xCoordOfGridCellZero = 0.0f;
            this._yCoordOfGridCellZero = 0.0f;
            this._srsDefinitionType = 0;
            this._srsName = "WKT";
            this._timeZoneID = "UTC";
            this._timeZoneRawOffset = 0;
            this._isInterval = 0;
            this._isTimeStamped = 0;
        } else if (gridInfo instanceof AlbersInfo) {
            this._dataSource = "";
            this._srsDefinition = this.getAlbersSpatialReferenceSystem((AlbersInfo)gridInfo);
            this._xCoordOfGridCellZero = ((AlbersInfo)gridInfo).getXCoordOfGridCellZero();
            this._yCoordOfGridCellZero = ((AlbersInfo)gridInfo).getYCoordOfGridCellZero();
            this._srsDefinitionType = 0;
            this._srsName = "WKT";
            this._timeZoneRawOffset = 0;
            this._isInterval = 0;
            this._isTimeStamped = 0;
        } else if (gridInfo instanceof SpecifiedGridInfo) {
            this._dataSource = "";
            this._srsDefinition = ((SpecifiedGridInfo)gridInfo)._srsDefinition;
            this._xCoordOfGridCellZero = ((SpecifiedGridInfo)gridInfo)._xCoordOfGridCellZero;
            this._yCoordOfGridCellZero = ((SpecifiedGridInfo)gridInfo)._yCoordOfGridCellZero;
            this._srsDefinitionType = ((SpecifiedGridInfo)gridInfo)._srsDefinitionType;
            this._srsName = ((SpecifiedGridInfo)gridInfo)._srsName;
            this._timeZoneID = ((SpecifiedGridInfo)gridInfo)._timeZoneID;
            this._timeZoneRawOffset = ((SpecifiedGridInfo)gridInfo)._timeZoneRawOffset;
            this._nullValue = ((SpecifiedGridInfo)gridInfo)._nullValue;
            this._isInterval = ((SpecifiedGridInfo)gridInfo)._isInterval ? 1 : 0;
            this._isTimeStamped = ((SpecifiedGridInfo)gridInfo)._isTimeStamped ? 1 : 0;
        }
    }

    public GridInfo returnGridInfo() {
        GridInfo gridInfo = null;
        if (this._type == 420) {
            gridInfo = new AlbersInfo();
        } else if (this._type == 410) {
            gridInfo = new HrapInfo();
        } else if (this._type == 431 || this._type == 430) {
            gridInfo = new SpecifiedGridInfo();
        }
        gridInfo._gridType = this._type;
        gridInfo._dataUnits = this._dataUnits;
        gridInfo._dataType = this._dataType;
        gridInfo._lowerLeftCellX = this._lowerLeftCellX;
        gridInfo._lowerLeftCellY = this._lowerLeftCellY;
        gridInfo._numberOfCellsX = this._numberOfCellsX;
        gridInfo._numberOfCellsY = this._numberOfCellsY;
        gridInfo._cellSize = this._cellSize;
        gridInfo._compressionMethod = this._compressionMethod;
        gridInfo._sizeofCompressedElements = this._sizeofCompressedElements;
        gridInfo._compressionScaleFactor = this._compressionScaleFactor;
        gridInfo._compressionBase = this._compressionBase;
        gridInfo._maxDataValue = this._maxDataValue;
        gridInfo._minDataValue = this._minDataValue;
        gridInfo._meanDataValue = this._meanDataValue;
        gridInfo._numberOfRanges = this._numberOfRanges;
        if (this._numberOfRanges > 0) {
            gridInfo._rangeLimitTable = new float[this._numberOfRanges];
            gridInfo._numberEqualOrExceedingRangeLimit = new int[this._numberOfRanges];
            for (int i = 0; i < this._numberOfRanges; ++i) {
                gridInfo._rangeLimitTable[i] = this._rangeLimitTable[i];
                gridInfo._numberEqualOrExceedingRangeLimit[i] = this._numberEqualOrExceedingRangeLimit[i];
            }
        }
        if (gridInfo instanceof HrapInfo) {
            ((HrapInfo)gridInfo)._dataSource = this._dataSource;
        } else if (gridInfo instanceof AlbersInfo) {
            this.setAlbersSpatialReferenceInfo((AlbersInfo)gridInfo, this._srsDefinition);
            gridInfo._xCoordOfGridCellZero = this._xCoordOfGridCellZero;
            gridInfo._yCoordOfGridCellZero = this._yCoordOfGridCellZero;
        } else if (gridInfo instanceof SpecifiedGridInfo) {
            this._dataSource = "";
            ((SpecifiedGridInfo)gridInfo)._srsDefinition = this._srsDefinition;
            ((SpecifiedGridInfo)gridInfo)._xCoordOfGridCellZero = this._xCoordOfGridCellZero;
            ((SpecifiedGridInfo)gridInfo)._yCoordOfGridCellZero = this._yCoordOfGridCellZero;
            ((SpecifiedGridInfo)gridInfo)._srsDefinitionType = this._srsDefinitionType;
            ((SpecifiedGridInfo)gridInfo)._srsName = this._srsName;
            ((SpecifiedGridInfo)gridInfo)._timeZoneID = this._timeZoneID;
            ((SpecifiedGridInfo)gridInfo)._timeZoneRawOffset = this._timeZoneRawOffset;
            ((SpecifiedGridInfo)gridInfo)._nullValue = this._nullValue;
            ((SpecifiedGridInfo)gridInfo)._isInterval = this._isInterval == 1;
            ((SpecifiedGridInfo)gridInfo)._isTimeStamped = this._isTimeStamped == 1;
        }
        return gridInfo;
    }

    public void setData(float[] data) {
        this._data = data;
    }

    public float[] getData() {
        return this._data;
    }
}

