/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.grid;

import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DssDataType;
import hec.heclib.grid.AlbersInfo;
import hec.heclib.grid.GridData;
import hec.heclib.grid.GridInfo;
import hec.heclib.grid.GriddedData;
import hec.heclib.grid.HrapInfo;
import hec.heclib.grid.SpecifiedGridInfo;
import hec.heclib.util.HecTime;
import hec.lang.annotation.Scriptable;

@Scriptable
public class GridUtilities {
    static final int[] gridTypes = new int[]{400, 401, 410, 411, 420, 421, 430, 431};

    public static boolean isGridType(int type) {
        for (int i = 0; i < gridTypes.length; ++i) {
            if (type != gridTypes[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean compatibleGrids(GridData grid1, GridData grid2) {
        GridInfo info1 = grid1.getGridInfo();
        GridInfo info2 = grid2.getGridInfo();
        if (info1._cellSize != info2._cellSize) {
            return false;
        }
        if (info1 instanceof HrapInfo) {
            if (info2 instanceof HrapInfo) {
                return true;
            }
            if (info2 instanceof AlbersInfo) {
                return false;
            }
            if (info2 instanceof SpecifiedGridInfo) {
                return true;
            }
        }
        if (info1 instanceof AlbersInfo) {
            AlbersInfo alb1 = (AlbersInfo)info1;
            if (info2 instanceof HrapInfo) {
                return false;
            }
            if (info2 instanceof AlbersInfo) {
                AlbersInfo alb2 = (AlbersInfo)info2;
                if (alb1._xCoordOfGridCellZero != alb2._xCoordOfGridCellZero) {
                    return false;
                }
                if (alb1._yCoordOfGridCellZero != alb2._yCoordOfGridCellZero) {
                    return false;
                }
                if (alb1._centralMeridian != alb2._centralMeridian) {
                    return false;
                }
                if (alb1._firstStandardParallel != alb2._firstStandardParallel) {
                    return false;
                }
                if (alb1._secondStandardParallel != alb2._secondStandardParallel) {
                    return false;
                }
                if (alb1._centralMeridian != alb2._centralMeridian) {
                    return false;
                }
                if (alb1._falseEasting != alb2._falseEasting) {
                    return false;
                }
                if (alb1._falseNorthing != alb2._falseNorthing) {
                    return false;
                }
            }
            if (info1 instanceof SpecifiedGridInfo) {
                SpecifiedGridInfo spec1 = (SpecifiedGridInfo)info1;
                if (info2 instanceof HrapInfo) {
                    return true;
                }
                if (info2 instanceof AlbersInfo) {
                    AlbersInfo alb2 = (AlbersInfo)info2;
                    if (spec1._xCoordOfGridCellZero != alb2._xCoordOfGridCellZero) {
                        return false;
                    }
                    if (spec1._yCoordOfGridCellZero != alb2._yCoordOfGridCellZero) {
                        return false;
                    }
                    return false;
                }
                if (info2 instanceof SpecifiedGridInfo) {
                    SpecifiedGridInfo spec2 = (SpecifiedGridInfo)info2;
                    if (spec1._xCoordOfGridCellZero != spec2._xCoordOfGridCellZero) {
                        return false;
                    }
                    if (spec1._yCoordOfGridCellZero != spec2._yCoordOfGridCellZero) {
                        return false;
                    }
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    public static int storeGridToDss(String dssFileName, String path, GridData theGrid) {
        GriddedData gd = new GriddedData();
        theGrid.updateStatistics();
        gd.setDSSFileName(dssFileName);
        DSSPathname pathname = new DSSPathname(path);
        if (gd.setPathname(path) != 0) {
            return -1;
        }
        GridInfo theInfo = theGrid.getGridInfo();
        DssDataType theType = DssDataType.fromInt(theInfo._dataType);
        if (theType.equals(DssDataType.INST_CUM) || theType == DssDataType.INST_VAL) {
            gd.setGriddedTimeWindow(theInfo._startTime, theInfo._startTime);
            theInfo.setGridTimes(theInfo._startTime, theInfo._startTime);
            HecTime start = new HecTime();
            start.cleanTime();
            start.set(theInfo._startTime);
            start.showTimeAsBeginningOfDay(false);
            String startTime = start.date(104) + ":" + start.hourMinutes();
            gd.setDPart(startTime);
            gd.setEPart("");
        } else if (theType.equals(DssDataType.PER_CUM) || theType == DssDataType.PER_AVER) {
            gd.setGriddedTimeWindow(theInfo._startTime, theInfo._endTime);
        }
        if (pathname.dPart().equals("")) {
            gd.setDPart("");
        }
        if (pathname.ePart().equals("")) {
            gd.setEPart("");
        }
        if (gd.storeGriddedData(theInfo, theGrid) != 0) {
            return -2;
        }
        return 0;
    }

    public static GridData retrieveGridFromDss(String dssFileName, String path, int[] status) {
        GriddedData gd = new GriddedData();
        GridData theGrid = new GridData();
        if (gd.setDSSFileName(dssFileName, true) != 0) {
            status[0] = -1;
            return null;
        }
        if (gd.setPathname(path) != 0) {
            status[0] = -1;
            return null;
        }
        if (!gd.recordExists(path)) {
            status[0] = -2;
            return null;
        }
        if (!GridUtilities.isGridType(gd.recordType(path))) {
            status[0] = -3;
            return null;
        }
        gd.retrieveGriddedData(true, theGrid, status);
        if (status[0] != 0) {
            return null;
        }
        return theGrid;
    }

    public static int setTimeByStart(GridData theGrid, HecTime startTime) {
        GridInfo theInfo = theGrid.getGridInfo();
        DssDataType theType = DssDataType.fromInt(theInfo._dataType);
        if (theType.equals(DssDataType.INST_CUM) || theType == DssDataType.INST_VAL) {
            theInfo.setGridTimes(startTime, startTime);
            return 0;
        }
        if (theType.equals(DssDataType.PER_CUM) || theType == DssDataType.PER_AVER) {
            int gridTimeSpan = theInfo._startTime.computeNumberIntervals(theInfo._endTime, 1);
            HecTime newEndTime = new HecTime(startTime);
            newEndTime.increment(gridTimeSpan, 1);
            theInfo.setGridTimes(startTime, newEndTime);
            return 0;
        }
        return -1;
    }

    public static int setTimeByEnd(GridData theGrid, HecTime endTime) {
        GridInfo theInfo = theGrid.getGridInfo();
        DssDataType theType = DssDataType.fromInt(theInfo._dataType);
        if (theType.equals(DssDataType.INST_CUM) || theType == DssDataType.INST_VAL) {
            theInfo.setGridTimes(endTime, endTime);
            return 0;
        }
        if (theType.equals(DssDataType.PER_CUM) || theType == DssDataType.PER_AVER) {
            int gridTimeSpan = theInfo._startTime.computeNumberIntervals(theInfo._endTime, 1);
            HecTime newStartTime = new HecTime(endTime);
            newStartTime.increment(-1 * gridTimeSpan, 1);
            theInfo.setGridTimes(newStartTime, endTime);
            return 0;
        }
        return -1;
    }

    public static GridData scalarAdd(GridData inGrid, float addend) {
        GridData outGrid = new GridData(inGrid);
        GridInfo inInfo = inGrid.getGridInfo();
        int cellCount = inInfo.getNumberOfCellsX() * inInfo.getNumberOfCellsY();
        float[] valueArray = outGrid.getData();
        for (int i = 0; i < cellCount; ++i) {
            if (valueArray[i] == -3.4028235E38f) continue;
            valueArray[i] = valueArray[i] + addend;
        }
        outGrid.updateStatistics();
        return outGrid;
    }

    public static GridData scalarSubtract(GridData inGrid, float subtrahend) {
        GridData outGrid = new GridData(inGrid);
        GridInfo inInfo = inGrid.getGridInfo();
        int cellCount = inInfo.getNumberOfCellsX() * inInfo.getNumberOfCellsY();
        float[] valueArray = outGrid.getData();
        for (int i = 0; i < cellCount; ++i) {
            if (valueArray[i] == -3.4028235E38f) continue;
            valueArray[i] = valueArray[i] - subtrahend;
        }
        outGrid.updateStatistics();
        return outGrid;
    }

    public static GridData scalarMultiply(GridData inGrid, float factor) {
        GridData outGrid = new GridData(inGrid);
        GridInfo inInfo = inGrid.getGridInfo();
        int cellCount = inInfo.getNumberOfCellsX() * inInfo.getNumberOfCellsY();
        float[] valueArray = outGrid.getData();
        for (int i = 0; i < cellCount; ++i) {
            if (valueArray[i] == -3.4028235E38f) continue;
            valueArray[i] = valueArray[i] * factor;
        }
        outGrid.updateStatistics();
        return outGrid;
    }

    public static GridData scalarDivide(GridData inGrid, float divisor) {
        GridData outGrid = new GridData(inGrid);
        GridInfo inInfo = inGrid.getGridInfo();
        int cellCount = inInfo.getNumberOfCellsX() * inInfo.getNumberOfCellsY();
        float[] valueArray = outGrid.getData();
        for (int i = 0; i < cellCount; ++i) {
            if (valueArray[i] == -3.4028235E38f) continue;
            valueArray[i] = valueArray[i] / divisor;
        }
        outGrid.updateStatistics();
        return outGrid;
    }

    public static GridData subGridExtract(GridData inGrid, int xOrigin, int yOrigin, int xExtent, int yExtent, int[] status) {
        boolean outOfBounds = false;
        Object msg = "";
        if (xOrigin < inGrid.getGridInfo().getLowerLeftCellX()) {
            msg = (String)msg + "X origin of subgrid outside bounds of input grid\n";
            outOfBounds = true;
        }
        if (yOrigin < inGrid.getGridInfo().getLowerLeftCellY()) {
            msg = (String)msg + "Y origin of subgrid outside bounds of input grid\n";
            outOfBounds = true;
        }
        if (xOrigin + xExtent > inGrid.getGridInfo().getLowerLeftCellX() + inGrid.getGridInfo().getNumberOfCellsX()) {
            msg = (String)msg + "Maximum X coordinate of subgrid outside bounds of input grid\n";
            outOfBounds = true;
        }
        if (yOrigin + yExtent > inGrid.getGridInfo().getLowerLeftCellY() + inGrid.getGridInfo().getNumberOfCellsY()) {
            msg = (String)msg + "Maximum Y coordinate of subgrid outside bounds of input grid\n";
            outOfBounds = true;
        }
        if (outOfBounds) {
            msg = ((String)msg).substring(0, ((String)msg).length() - 1);
            status[0] = -1;
            return null;
        }
        GridInfo inInfo = inGrid.getGridInfo();
        GridInfo outInfo = GridInfo.copy(inInfo);
        outInfo.setCellInfo(xOrigin, yOrigin, xExtent, yExtent, inInfo.getCellSize());
        float[] subgridData = new float[xExtent * yExtent];
        int inGridWidth = inInfo.getNumberOfCellsX();
        float[] inGridData = inGrid.getData();
        int xOffset = xOrigin - inGrid.getGridInfo().getLowerLeftCellX();
        int yOffset = yOrigin - inGrid.getGridInfo().getLowerLeftCellY();
        for (int j = 0; j < yExtent; ++j) {
            int sourceRowStartIndex = xOffset + (yOffset + j) * inGridWidth;
            int subRowStartIndex = j * xExtent;
            for (int i = 0; i < xExtent; ++i) {
                subgridData[i + subRowStartIndex] = inGridData[sourceRowStartIndex + i];
            }
        }
        GridData outGrid = new GridData(subgridData, outInfo);
        outGrid.updateStatistics();
        status[0] = 0;
        return outGrid;
    }

    public static GridData mosaic(GridData inGrid1, GridData inGrid2, int[] status) {
        if (!GridUtilities.compatibleGrids(inGrid1, inGrid2)) {
            status[0] = -1;
            return null;
        }
        GridInfo inInfo = inGrid1.getGridInfo();
        GridInfo outInfo = GridInfo.copy(inInfo);
        int[] outExtents = GridUtilities.unionExtent(inGrid1, inGrid2);
        outInfo.setCellInfo(outExtents[0], outExtents[1], outExtents[2], outExtents[3], inInfo.getCellSize());
        float[] mosaicData = new float[outExtents[2] * outExtents[3]];
        int iMin = outExtents[0];
        int iMax = iMin + outExtents[2];
        int jMin = outExtents[1];
        int jMax = jMin + outExtents[3];
        int n = 0;
        for (int j = jMin; j < jMax; ++j) {
            for (int i = iMin; i < iMax; ++i) {
                double val1 = inGrid1.getValueAt(i, j);
                double val2 = inGrid2.getValueAt(i, j);
                mosaicData[n] = val1 == -3.4028234663852886E38 ? (val2 == -3.4028234663852886E38 ? -3.4028235E38f : (float)val2) : (float)val1;
                ++n;
            }
        }
        GridData outGrid = new GridData(mosaicData, outInfo);
        outGrid.updateStatistics();
        return outGrid;
    }

    public static int[] intersectExtent(GridData grid1, GridData grid2) {
        int[] result = new int[]{0, 0, 0, 0};
        if (!GridUtilities.compatibleGrids(grid1, grid2)) {
            return result;
        }
        GridInfo info1 = grid1.getGridInfo();
        GridInfo info2 = grid2.getGridInfo();
        int xll1 = info1._lowerLeftCellX;
        int yll1 = info1._lowerLeftCellY;
        int xur1 = xll1 + info1._numberOfCellsX;
        int yur1 = yll1 + info1._numberOfCellsY;
        int xll2 = info2._lowerLeftCellX;
        int yll2 = info2._lowerLeftCellY;
        int xur2 = xll2 + info2._numberOfCellsX;
        int yur2 = yll2 + info2._numberOfCellsY;
        result[0] = xll1;
        if (xll2 > xll1) {
            result[0] = xll2;
        }
        result[1] = yll1;
        if (yll2 > yll1) {
            result[1] = yll2;
        }
        result[2] = xur1 - result[0];
        if (xur1 > xur2) {
            result[2] = xur2 - result[0];
        }
        result[3] = yur1 - result[1];
        if (yur1 > yur2) {
            result[3] = yur2 - result[1];
        }
        return result;
    }

    public static int[] unionExtent(GridData grid1, GridData grid2) {
        int[] result = new int[]{0, 0, 0, 0};
        if (!GridUtilities.compatibleGrids(grid1, grid2)) {
            return result;
        }
        GridInfo info1 = grid1.getGridInfo();
        GridInfo info2 = grid2.getGridInfo();
        int xll1 = info1._lowerLeftCellX;
        int yll1 = info1._lowerLeftCellY;
        int xur1 = xll1 + info1._numberOfCellsX;
        int yur1 = yll1 + info1._numberOfCellsY;
        int xll2 = info2._lowerLeftCellX;
        int yll2 = info2._lowerLeftCellY;
        int xur2 = xll2 + info2._numberOfCellsX;
        int yur2 = yll2 + info2._numberOfCellsY;
        result[0] = xll1;
        if (xll2 < xll1) {
            result[0] = xll2;
        }
        result[1] = yll1;
        if (yll2 < yll1) {
            result[1] = yll2;
        }
        result[2] = xur1 - result[0];
        if (xur1 < xur2) {
            result[2] = xur2 - result[0];
        }
        result[3] = yur1 - result[1];
        if (yur1 < yur2) {
            result[3] = yur2 - result[1];
        }
        return result;
    }

    public static GridData gridMultiply(GridData grid1, GridData grid2, int[] status) {
        if (!GridUtilities.compatibleGrids(grid1, grid2)) {
            status[0] = -1;
            return null;
        }
        int[] extents = GridUtilities.intersectExtent(grid1, grid2);
        if (extents[2] == 0 && extents[3] == 0) {
            status[0] = -1;
            return null;
        }
        GridInfo info1 = grid1.getGridInfo();
        GridInfo info2 = grid2.getGridInfo();
        GridData outGrid = new GridData(grid1);
        GridInfo outInfo = outGrid.getGridInfo();
        outInfo.setCellInfo(extents[0], extents[1], extents[2], extents[3], info1.getCellSize());
        int nCells = extents[2] * extents[3];
        float[] outVals = new float[nCells];
        int iMin = extents[0];
        int iMax = iMin + extents[2];
        int jMin = extents[1];
        int jMax = jMin + extents[3];
        int n = 0;
        for (int j = jMin; j < jMax; ++j) {
            for (int i = iMin; i < iMax; ++i) {
                double val1 = grid1.getValueAt(i, j);
                double val2 = grid2.getValueAt(i, j);
                outVals[n] = val1 == -3.4028234663852886E38 || val2 == -3.4028234663852886E38 ? -3.4028235E38f : (float)(val1 * val2);
                ++n;
            }
        }
        outGrid.setData(outVals);
        outGrid.updateStatistics();
        status[0] = 0;
        return outGrid;
    }

    public static GridData gridDivide(GridData grid1, GridData grid2, int[] status) {
        if (!GridUtilities.compatibleGrids(grid1, grid2)) {
            status[0] = -1;
            return null;
        }
        int[] extents = GridUtilities.intersectExtent(grid1, grid2);
        if (extents[2] == 0 && extents[3] == 0) {
            status[0] = -1;
            return null;
        }
        GridInfo info1 = grid1.getGridInfo();
        GridInfo info2 = grid2.getGridInfo();
        GridData outGrid = new GridData(grid1);
        GridInfo outInfo = outGrid.getGridInfo();
        outInfo.setCellInfo(extents[0], extents[1], extents[2], extents[3], info1.getCellSize());
        int nCells = extents[2] * extents[3];
        float[] outVals = new float[nCells];
        int iMin = extents[0];
        int iMax = iMin + extents[2];
        int jMin = extents[1];
        int jMax = jMin + extents[3];
        int n = 0;
        for (int j = jMin; j < jMax; ++j) {
            for (int i = iMin; i < iMax; ++i) {
                double val1 = grid1.getValueAt(i, j);
                double val2 = grid2.getValueAt(i, j);
                outVals[n] = val1 == -3.4028234663852886E38 || val2 == -3.4028234663852886E38 ? -3.4028235E38f : (float)(val1 / val2);
                ++n;
            }
        }
        outGrid.setData(outVals);
        outGrid.updateStatistics();
        status[0] = 0;
        return outGrid;
    }

    public static GridData gridAdd(GridData grid1, GridData grid2, int[] status) {
        if (!GridUtilities.compatibleGrids(grid1, grid2)) {
            status[0] = -1;
            return null;
        }
        int[] extents = GridUtilities.intersectExtent(grid1, grid2);
        if (extents[2] == 0 && extents[3] == 0) {
            status[0] = -1;
            return null;
        }
        GridInfo info1 = grid1.getGridInfo();
        GridInfo info2 = grid2.getGridInfo();
        GridData outGrid = new GridData(grid1);
        GridInfo outInfo = outGrid.getGridInfo();
        outInfo.setCellInfo(extents[0], extents[1], extents[2], extents[3], info1.getCellSize());
        int nCells = extents[2] * extents[3];
        float[] outVals = new float[nCells];
        int iMin = extents[0];
        int iMax = iMin + extents[2];
        int jMin = extents[1];
        int jMax = jMin + extents[3];
        int n = 0;
        for (int j = jMin; j < jMax; ++j) {
            for (int i = iMin; i < iMax; ++i) {
                double val1 = grid1.getValueAt(i, j);
                double val2 = grid2.getValueAt(i, j);
                outVals[n] = val1 == -3.4028234663852886E38 || val2 == -3.4028234663852886E38 ? -3.4028235E38f : (float)(val1 + val2);
                ++n;
            }
        }
        outGrid.setData(outVals);
        outGrid.updateStatistics();
        status[0] = 0;
        return outGrid;
    }

    public static GridData gridSubtract(GridData grid1, GridData grid2, int[] status) {
        if (!GridUtilities.compatibleGrids(grid1, grid2)) {
            status[0] = -1;
            return null;
        }
        int[] extents = GridUtilities.intersectExtent(grid1, grid2);
        if (extents[2] == 0 && extents[3] == 0) {
            status[0] = -1;
            return null;
        }
        GridInfo info1 = grid1.getGridInfo();
        GridInfo info2 = grid2.getGridInfo();
        GridData outGrid = new GridData(grid1);
        GridInfo outInfo = outGrid.getGridInfo();
        outInfo.setCellInfo(extents[0], extents[1], extents[2], extents[3], info1.getCellSize());
        int nCells = extents[2] * extents[3];
        float[] outVals = new float[nCells];
        int iMin = extents[0];
        int iMax = iMin + extents[2];
        int jMin = extents[1];
        int jMax = jMin + extents[3];
        int n = 0;
        for (int j = jMin; j < jMax; ++j) {
            for (int i = iMin; i < iMax; ++i) {
                double val1 = grid1.getValueAt(i, j);
                double val2 = grid2.getValueAt(i, j);
                outVals[n] = val1 == -3.4028234663852886E38 || val2 == -3.4028234663852886E38 ? -3.4028235E38f : (float)(val1 * val2);
                ++n;
            }
        }
        outGrid.setData(outVals);
        outGrid.updateStatistics();
        status[0] = 0;
        return outGrid;
    }
}

