/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.grid;

import hec.heclib.dss.HecDataManager;
import hec.heclib.grid.AlbersInfo;
import hec.heclib.grid.AlbersInfoFlat;
import hec.heclib.grid.DataCompression;
import hec.heclib.grid.GridData;
import hec.heclib.grid.GridInfo;
import hec.heclib.grid.GridInfoFlat;
import hec.heclib.grid.GridStructContainer;
import hec.heclib.grid.HrapInfo;
import hec.heclib.grid.HrapInfoFlat;
import hec.heclib.grid.SpecifiedGridInfo;
import hec.heclib.grid.SpecifiedGridInfoFlat;
import hec.heclib.util.HecTime;
import hec.heclib.util.Heclib;
import hec.heclib.util.intContainer;
import hec.heclib.util.shortArrayContainer;
import hec.lang.Const;
import hec.lang.annotation.Scriptable;
import java.io.Serializable;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.util.RMAIO;

@Scriptable
public class GriddedData
extends HecDataManager
implements Serializable {
    private static final Logger _logger = Logger.getLogger(GriddedData.class.getName());
    private boolean _verbose;

    public GriddedData() {
        this._verbose = false;
    }

    public GriddedData(boolean verbose) {
        this._verbose = verbose;
    }

    public void setGriddedPathnameParts(String aPart, String bPart, String cPart, String fPart) {
        this.setAPart(aPart);
        this.setBPart(bPart);
        this.setCPart(cPart);
        this.setFPart(fPart);
    }

    public void printArray(float[] X) {
        Object str = "[";
        float[] fArray = X;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            double x = fArray[i];
            str = (String)str + x + ", ";
        }
        str = ((String)str).substring(0, ((String)str).length() - 2) + "]";
        System.out.println((String)str);
    }

    public String DSSFileName(boolean useDefault) {
        String filename = "";
        filename = useDefault ? this.DSSFileName() : this._fileData.dssFilename();
        return filename;
    }

    public void setGriddedTimeWindow(HecTime start, HecTime end) {
        start.showTimeAsBeginningOfDay(true);
        String startTime = start.date(104) + ":" + start.hourMinutes();
        this.setDPart(startTime);
        if (end != null && end.isDefined()) {
            end.showTimeAsBeginningOfDay(false);
            String endTime = end.date(104) + ":" + end.hourMinutes();
            this.setEPart(endTime);
        }
    }

    public void setGriddedTimeWindow(HecTime start, HecTime end, boolean startOfDay) {
        String endTime;
        start.showTimeAsBeginningOfDay(startOfDay);
        String startTime = start.date(104) + ":" + start.hourMinutes();
        this.setDPart(startTime);
        if (end != null && end.isDefined()) {
            end.showTimeAsBeginningOfDay(startOfDay);
            endTime = end.date(104) + ":" + end.hourMinutes();
            this.setEPart(endTime);
        }
        if (!this.recordExists(this._dssPathname.getPathname())) {
            start.showTimeAsBeginningOfDay(false);
            start.cleanTime();
            startTime = start.date(104) + ":" + start.hourMinutes();
            this.setDPart(startTime);
            if (end != null && end.isDefined()) {
                end.showTimeAsBeginningOfDay(false);
                endTime = end.date(104) + ":" + end.hourMinutes();
                this.setEPart(endTime);
            }
        }
    }

    public void setGridTime(HecTime time) {
        if (time.isDefined()) {
            HecTime myTime = new HecTime(time);
            myTime.showTimeAsBeginningOfDay(false);
            myTime.cleanTime();
            String timeString = myTime.date(104) + ":" + myTime.hourMinutes();
            this.setDPart(timeString);
        } else {
            this.setDPart(" ");
        }
        this.setEPart(" ");
    }

    public void setGridTime(HecTime time, Boolean startOfDay) {
        if (time.isDefined()) {
            HecTime myTime = new HecTime(time);
            myTime.showTimeAsBeginningOfDay(startOfDay);
            myTime.cleanTime();
            String timeString = myTime.date(104) + ":" + myTime.hourMinutes();
            this.setDPart(timeString);
            if (!this.recordExists(this._dssPathname.getPathname())) {
                myTime.showTimeAsBeginningOfDay(false);
                myTime.cleanTime();
                timeString = myTime.date(104) + ":" + myTime.hourMinutes();
                this.setDPart(timeString);
            }
        } else {
            this.setDPart(" ");
        }
        this.setEPart(" ");
    }

    protected boolean isVersion7() {
        int version = Heclib.getLibraryVersion();
        return version > 70700 && this.zinqir("fver") > 70700;
    }

    protected boolean useDSS7GridStruct() {
        return this.isVersion7();
    }

    public int getGridStructVersion() {
        int[] stat = new int[1];
        int[] gridStructVersion = new int[]{0};
        if (this.isVersion7()) {
            intContainer lockThreadToken = new intContainer();
            int[] dssTable = this._fileData.requestAccess(lockThreadToken);
            if (dssTable == null) {
                stat[0] = -4;
                return 0;
            }
            try {
                stat[0] = Heclib.zgridRetrieveVersion(dssTable, this.pathname(), gridStructVersion);
            }
            catch (Throwable ex) {
                _logger.log(Level.SEVERE, "Error occured in Heclib.zgridRetrieveVersion.", ex);
                throw ex;
            }
            finally {
                this._fileData.releaseAccess(lockThreadToken);
            }
            if (stat[0] != 0) {
                return 0;
            }
        }
        return gridStructVersion[0];
    }

    protected int readStructGrids(GridStructContainer gridContainer, boolean retrieveData, int[] status) {
        intContainer lockThreadToken;
        int[] dssTable;
        if (gridContainer.fullName == null || gridContainer.fullName.length() < 3) {
            if (this.dirty()) {
                this.recordType();
            }
            gridContainer.fullName = this._dssPathname.pathname();
        }
        if (gridContainer.fullName == null || gridContainer.fullName.length() < 3) {
            gridContainer.fullName = this._dssPathname.pathname();
        }
        if ((dssTable = this._fileData.requestAccess(lockThreadToken = new intContainer())) == null) {
            status[0] = -4;
            return -4;
        }
        try {
            status[0] = Heclib.zgridRetrieve(dssTable, gridContainer, retrieveData);
        }
        catch (Throwable ex) {
            _logger.log(Level.SEVERE, "Error occured in Heclib.zgridRetrieve.", ex);
            throw ex;
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        if (status[0] != 0) {
            return -1;
        }
        return 0;
    }

    protected int writeStructGrids(GridStructContainer gridContainer) {
        intContainer lockThreadToken;
        int[] dssTable;
        if (gridContainer.fullName == null || gridContainer.fullName.length() < 3) {
            if (this.dirty()) {
                this.recordType();
            }
            gridContainer.fullName = this._dssPathname.pathname();
        }
        if ((dssTable = this._fileData.requestAccess(lockThreadToken = new intContainer())) == null) {
            return -4;
        }
        try {
            int status = Heclib.zgridStore(dssTable, gridContainer);
            if (status == 0) {
                int n = 0;
                return n;
            }
            int n = -1;
            return n;
        }
        catch (Throwable ex) {
            _logger.log(Level.SEVERE, "Error occured in Heclib.zgridStore.", ex);
            throw ex;
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
    }

    protected GridInfo retrieveGriddedContainer(boolean dataWanted, GridData gridData, int[] status) {
        String s2;
        GridStructContainer gridContainer = new GridStructContainer();
        HecTime startTime = null;
        HecTime endTime = null;
        if (this.dPart() != null) {
            try {
                s2 = this.dPart();
                String sDate = s2.substring(0, s2.indexOf(":"));
                String sTime = s2.substring(s2.indexOf(":") + 1);
                startTime = new HecTime(sDate, sTime);
                startTime.showTimeAsBeginningOfDay(true);
            }
            catch (Exception s2) {
                // empty catch block
            }
        }
        if (this.ePart() != null) {
            try {
                s2 = this.ePart();
                String eDate = s2.substring(0, s2.indexOf(":"));
                String eTime = s2.substring(s2.indexOf(":") + 1);
                endTime = new HecTime(eDate, eTime);
            }
            catch (Exception s3) {
                // empty catch block
            }
        }
        this.readStructGrids(gridContainer, dataWanted, status);
        if (status[0] == 0) {
            GridInfo gi = gridContainer.returnGridInfo();
            gi.setGridTimes(startTime, endTime == null ? startTime : endTime);
            gi.gridStructVersion = -gridContainer._structVersion;
            if (gridData != null) {
                if (dataWanted) {
                    gridData.initGridData(gridContainer.getData(), gi);
                } else {
                    gridData.initGridInfo(gi);
                }
            }
            return gi;
        }
        return null;
    }

    public float retrieveUserHeaderNullValue(int[] status) {
        String s2;
        GridStructContainer gridContainer = new GridStructContainer();
        HecTime startTime = null;
        HecTime endTime = null;
        float _nullValue = -3.4028235E38f;
        if (this.dPart() != null) {
            try {
                s2 = this.dPart();
                String sDate = s2.substring(0, s2.indexOf(":"));
                String sTime = s2.substring(s2.indexOf(":") + 1);
                startTime = new HecTime(sDate, sTime);
                startTime.showTimeAsBeginningOfDay(true);
            }
            catch (Exception s2) {
                // empty catch block
            }
        }
        if (this.ePart() != null) {
            try {
                s2 = this.ePart();
                String eDate = s2.substring(0, s2.indexOf(":"));
                String eTime = s2.substring(s2.indexOf(":") + 1);
                endTime = new HecTime(eDate, eTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.readStructGrids(gridContainer, false, status);
        if (status[0] == 0) {
            _nullValue = gridContainer._nullValue;
        }
        return _nullValue;
    }

    public GridInfo retrieveGriddedData() {
        return this.retrieveGriddedData(false, null, new int[1]);
    }

    public GridInfo retrieveGriddedData(boolean dataWanted, GridData gridData, int[] stat) {
        short[] dataCompressed;
        GridInfoFlat gridInfoFlat;
        GridInfo gridInfo;
        int recordType = this.recordType();
        int gridStructVer = this.getGridStructVersion();
        if (gridStructVer >= 100) {
            GridInfo rval = this.retrieveGriddedContainer(dataWanted, gridData, stat);
            return rval;
        }
        if (recordType == 0) {
            if (this._verbose) {
                System.out.println("HEC-DSS Record does not exist.");
                System.out.println("Pathname: " + this.pathname());
            }
            stat[0] = -1;
            return null;
        }
        if (recordType == 410 || recordType == 411) {
            gridInfo = new HrapInfo();
            gridInfoFlat = new HrapInfoFlat();
        } else if (recordType == 420 || recordType == 421) {
            gridInfo = new AlbersInfo();
            gridInfoFlat = new AlbersInfoFlat();
        } else if (recordType == 430 || recordType == 431) {
            gridInfo = new SpecifiedGridInfo();
            gridInfoFlat = new SpecifiedGridInfoFlat();
        } else {
            System.out.println("Unknown grid record type in GriddedData.retrieveGriddedData:");
            System.out.println("Record type: " + recordType + ", should be: 420 or 410 or 430");
            System.out.println("Pathname: " + this.pathname());
            stat[0] = -2;
            return null;
        }
        int[] exists = new int[]{0};
        int[] infoSize = new int[1];
        int[] ndataCompressed = new int[1];
        int[] dummy = new int[1];
        int[] idummy = new int[1];
        short[] sdummy = new short[1];
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            stat[0] = -4;
            return null;
        }
        try {
            Heclib.zreadx(dssTable, this.pathname(), dummy, 0, infoSize, dummy, 0, idummy, dummy, 0, idummy, sdummy, 0, ndataCompressed, 1, exists);
            int gridInfoFlatSize = infoSize[0];
            int[] info = new int[gridInfoFlatSize];
            if (dataWanted) {
                dataCompressed = new short[ndataCompressed[0] * 2];
            } else {
                dataCompressed = sdummy;
                ndataCompressed[0] = 0;
            }
            Heclib.zreadx(dssTable, this.pathname(), info, gridInfoFlatSize, infoSize, dummy, 0, idummy, dummy, 0, idummy, dataCompressed, ndataCompressed[0], ndataCompressed, 1, exists);
            if (exists[0] == 0) {
                Logger logger;
                if (this._verbose) {
                    logger = Logger.getLogger(this.getClass().getName());
                    logger.log(Level.WARNING, "Record does not exist in GriddedData.retrieveGriddedData:");
                    logger.log(Level.WARNING, "Pathname: " + this.pathname());
                }
                stat[0] = -4;
                logger = null;
                return logger;
            }
            boolean unflat = gridInfoFlat.unflatten(info);
            if (!unflat) {
                stat[0] = -5;
                GridInfo gridInfo2 = null;
                return gridInfo2;
            }
        }
        catch (Throwable ex) {
            _logger.log(Level.SEVERE, "Error occured in Heclib.zreadx.", ex);
            throw ex;
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        if (dataWanted && RMAIO.getOSType() != 2) {
            for (int i = 0; i < dataCompressed.length; i += 2) {
                short temp = dataCompressed[i];
                dataCompressed[i] = dataCompressed[i + 1];
                dataCompressed[i + 1] = temp;
            }
        }
        gridInfo.convertToGridInfo(gridInfoFlat);
        int[] sizeXY = new int[1];
        if (dataWanted) {
            int numX = gridInfo._numberOfCellsX;
            int numY = gridInfo._numberOfCellsY;
            sizeXY[0] = numX * numY;
            if (sizeXY[0] < 0) {
                System.out.println("retrieveGriddedData: negative array size " + sizeXY[0]);
                System.out.println("retrieveGriddedData: numX=" + numX + " numY=" + numY);
                return null;
            }
            float[] data = new float[sizeXY[0]];
            DataCompression d = new DataCompression();
            int sizeofCompressedElements = gridInfo._sizeofCompressedElements;
            double compressionScaleFactor = gridInfo._compressionScaleFactor;
            double compressionBase = gridInfo._compressionBase;
            if (gridInfo._maxDataValue == gridInfo._minDataValue & (double)gridInfo._minDataValue < -9.0E37) {
                for (int i = 0; i < sizeXY[0]; ++i) {
                    data[i] = -3.4028235E38f;
                }
            } else if (gridInfo.getCompressionMethod() == 26) {
                if (this._verbose) {
                    System.out.println("Decompressing grid: using ZLIB");
                }
                data = d.zuncompress(dataCompressed, sizeofCompressedElements, data, sizeXY[0]);
                if (gridInfo instanceof SpecifiedGridInfo) {
                    float nullValue = ((SpecifiedGridInfo)gridInfo)._nullValue;
                    for (int i = 0; i < data.length; ++i) {
                        if (data[i] != nullValue) continue;
                        data[i] = -3.4028235E38f;
                    }
                } else {
                    float maxValue = gridInfo.getMaxValue();
                    float minValue = gridInfo.getMinValue();
                    for (int i = 0; i < data.length; ++i) {
                        if (!(data[i] > maxValue) && !(data[i] < minValue)) continue;
                        data[i] = -3.4028235E38f;
                    }
                }
            } else {
                if (this._verbose) {
                    System.out.println("Decompressing grid: using run-length decoding");
                }
                int n = d.uncompress(dataCompressed, sizeofCompressedElements, compressionScaleFactor, compressionBase, data, sizeXY);
            }
            gridInfo.gridStructVersion = gridStructVer;
            gridData.initGridData(data, gridInfo);
        }
        stat[0] = 0;
        return gridInfo;
    }

    public int storeGriddedContainer(GridInfo gridInfo, GridData gridData) {
        GridStructContainer gridContainer = new GridStructContainer(gridInfo);
        gridContainer.setData(gridData._data);
        return this.writeStructGrids(gridContainer);
    }

    public int storeGriddedData(GridInfo gridInfo, GridData gridData) {
        intContainer lockThreadToken;
        int[] dssTable;
        String s2;
        gridData.updateStatistics();
        if (this.useDSS7GridStruct()) {
            return this.storeGriddedContainer(gridInfo, gridData);
        }
        int numX = gridInfo._numberOfCellsX;
        int numY = gridInfo._numberOfCellsY;
        int sizeXY = numX * numY;
        short[] dataCompressed = sizeXY % 2 == 0 ? new short[sizeXY] : new short[sizeXY + 1];
        short szero = 0;
        Arrays.fill(dataCompressed, szero);
        int[] sizeofCompressedElements = new int[1];
        float[] data = gridData._data;
        float storeValueForUndefined = -1.0E30f;
        if (gridInfo instanceof SpecifiedGridInfo) {
            storeValueForUndefined = ((SpecifiedGridInfo)gridInfo)._nullValue;
        }
        for (int i = 0; i < data.length; ++i) {
            if (!Const.isUndefined(data[i])) continue;
            data[i] = storeValueForUndefined;
        }
        float compressionScaleFactor = 100.0f;
        float compressionBase = 0.0f;
        DataCompression d = new DataCompression();
        HecTime startTime = null;
        HecTime endTime = null;
        if (this.dPart() != null) {
            try {
                s2 = this.dPart();
                String sDate = s2.substring(0, s2.indexOf(":"));
                String sTime = s2.substring(s2.indexOf(":") + 1);
                startTime = new HecTime(sDate, sTime);
                startTime.showTimeAsBeginningOfDay(true);
            }
            catch (Exception s2) {
                // empty catch block
            }
        }
        if (this.ePart() != null) {
            try {
                s2 = this.ePart();
                String eDate = s2.substring(0, s2.indexOf(":"));
                String eTime = s2.substring(s2.indexOf(":") + 1);
                endTime = new HecTime(eDate, eTime);
            }
            catch (Exception s3) {
                // empty catch block
            }
        }
        if (gridInfo._compressionMethod == 0) {
            double oneHourInMillis = 3600000.0;
            gridInfo._compressionMethod = gridInfo._version == 1 && startTime != null && endTime != null && gridInfo._compressionMethod == 0 && (double)(endTime.getTimeInMillis() - startTime.getTimeInMillis()) == oneHourInMillis && gridInfo._dataType == 1 ? 101001 : 26;
        }
        if (gridInfo._compressionMethod == 101001) {
            if (this._verbose) {
                System.out.println("Compressing grid: using run-length encoding");
            }
            if (gridInfo._compressionBase != -3.4028235E38f && gridInfo._compressionScaleFactor != -3.4028235E38f) {
                compressionBase = gridInfo._compressionBase;
                compressionScaleFactor = gridInfo._compressionScaleFactor;
            } else {
                int numberOfCompressedValues;
                compressionScaleFactor = 100.0f;
                compressionBase = 0.0f;
                float minValue = gridData._gridInfo._minDataValue;
                float maxValue = gridData._gridInfo._maxDataValue;
                if (minValue < compressionBase) {
                    compressionBase = (float)Math.floor(minValue);
                }
                if ((numberOfCompressedValues = (int)((maxValue - compressionBase) * compressionScaleFactor)) > 32768 && (numberOfCompressedValues = (int)((maxValue - (compressionBase = (float)Math.floor(minValue))) * compressionScaleFactor)) > 32768) {
                    compressionScaleFactor = (float)Math.ceil(32767.0 / (double)(maxValue - minValue));
                }
            }
            d.compress(data, sizeXY, compressionScaleFactor, compressionBase, dataCompressed, sizeofCompressedElements);
            gridInfo.setCompressionInfo(101001, sizeofCompressedElements[0], compressionScaleFactor, compressionBase);
        }
        if (gridInfo._compressionMethod == 26) {
            if (this._verbose) {
                System.out.println("Compressing grid: using ZLIB");
            }
            shortArrayContainer dcContainer = new shortArrayContainer();
            d.zcompress(data, sizeXY, dcContainer, sizeofCompressedElements);
            dataCompressed = dcContainer.array;
            gridInfo.setCompressionInfo(26, sizeofCompressedElements[0], gridInfo._compressionScaleFactor, gridInfo._compressionBase);
        }
        GridInfoFlat gridInfoFlat = null;
        int rType = gridInfo.getGridType();
        if (rType == 420) {
            gridInfoFlat = new AlbersInfoFlat();
            ((AlbersInfo)gridInfo).makeGridInfoFlat((AlbersInfoFlat)gridInfoFlat);
        } else if (rType == 410) {
            gridInfoFlat = new HrapInfoFlat();
            ((HrapInfo)gridInfo).makeGridInfoFlat((HrapInfoFlat)gridInfoFlat);
        } else if (rType == 430) {
            gridInfoFlat = new SpecifiedGridInfoFlat();
            ((SpecifiedGridInfo)gridInfo).makeGridInfoFlat((SpecifiedGridInfoFlat)gridInfoFlat);
        } else {
            return -1;
        }
        int infoFlatSize = gridInfoFlat.size();
        int[] flatten = new int[infoFlatSize];
        gridInfoFlat.flatten(flatten);
        String path = this.pathname();
        int zero = 0;
        int plan = 0;
        int numDataCompressed = (sizeofCompressedElements[0] + 3) / 4;
        if (infoFlatSize % 4 != 0) {
            return -1;
        }
        infoFlatSize /= 4;
        int[] dummy = new int[1];
        int[] status = new int[1];
        int[] exists = new int[1];
        GriddedData.zset("TYPE", "", rType);
        if (RMAIO.getOSType() != 2) {
            int i = 0;
            try {
                for (i = 0; i < dataCompressed.length - 1; i += 2) {
                    short temp = dataCompressed[i];
                    dataCompressed[i] = dataCompressed[i + 1];
                    dataCompressed[i + 1] = temp;
                }
            }
            catch (Exception e) {
                System.out.println("Exception " + e + " i=" + i + " dataCompressed.length=" + dataCompressed.length);
                return -1;
            }
        }
        if ((dssTable = this._fileData.requestAccess(lockThreadToken = new intContainer())) == null) {
            return -4;
        }
        try {
            GriddedData.checkForSevereError();
            Heclib.zwritx(dssTable, path.toUpperCase(), path.length(), flatten, infoFlatSize, dummy, zero, dummy, zero, dataCompressed, numDataCompressed, rType, plan, status, exists);
        }
        catch (Throwable ex) {
            _logger.log(Level.SEVERE, "Error occured in Heclib.zwritx.", ex);
            throw ex;
        }
        finally {
            this._fileData.releaseAccess(lockThreadToken);
        }
        return status[0];
    }
}

