/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.grid;

import hec.heclib.grid.GridInfo;
import hec.heclib.grid.GridInfoFlat;
import hec.heclib.grid.HrapInfoFlat;
import hec.heclib.util.Heclib;
import java.io.BufferedWriter;
import rma.util.RMAIO;

public class HrapInfo
extends GridInfo {
    String _dataSource = "";

    public HrapInfo() {
        this._gridType = 410;
        this._infoSize = this._gridInfoSize + 4;
        this._dataSource = "";
    }

    public HrapInfo(HrapInfo hi) {
        super(hi);
        this._infoSize = this._gridInfoSize + 4;
        this._dataSource = hi._dataSource;
    }

    @Override
    public int convertToGridInfo(GridInfoFlat h1) {
        if (h1.getClass() == HrapInfoFlat.class) {
            return this.convertToGridInfo((HrapInfoFlat)h1);
        }
        return super.convertToGridInfo(h1);
    }

    public int convertToGridInfo(HrapInfoFlat h1) {
        super.convertToGridInfo(h1);
        this._infoSize = this._gridInfoSize + 4;
        this._dataSource = HrapInfo.dataSourceFromIntArray(h1._dataSource);
        return 0;
    }

    private static String dataSourceFromIntArray(int[] data) {
        String rval = "";
        int numBytes = 12;
        if (data.length == 3) {
            rval = Heclib.holString(data, numBytes);
        }
        return rval;
    }

    public int convertToHrapInfo(HrapInfoFlat h1) {
        super.convertToGridInfo(h1);
        this._infoSize = this._gridInfoSize + 4;
        this._dataSource = HrapInfo.dataSourceFromIntArray(h1._dataSource);
        return 0;
    }

    @Override
    public int setCellInfo(int lowerLeftCellX, int lowerLeftCellY, int numberOfCellsX, int numberOfCellsY, float cellSize) {
        super.setCellInfo(lowerLeftCellX, lowerLeftCellY, numberOfCellsX, numberOfCellsY, 4762.5f);
        return 0;
    }

    @Override
    public void show(BufferedWriter out) {
        RMAIO.fout(out, " = = = HrapInfo = = = ");
        RMAIO.fout(out, "Data Source: " + this._dataSource);
        super.show(out);
    }

    @Override
    public String getSpatialReferenceSystem() {
        return "PROJCS[\"Stereographic_CONUS_HRAP\",GEOGCS[\"GCS_Sphere_LFM\",DATUM[\"D_Sphere_LFM\",SPHEROID[\"Shpere_LFM\",6371200.0,0.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Stereographic_North_Pole\"],PARAMETER[\"False_Easting\",1909762.5],PARAMETER[\"False_Northing\",7624762.5],PARAMETER[\"Central_Meridian\",-105.0],PARAMETER[\"Standard_Parallel_1\",60.0],UNIT[\"Meter\",1.0]]";
    }

    @Override
    public String toString() {
        String source = this._dataSource;
        if (source.isEmpty()) {
            source = "NULL";
        }
        Object theString = "\n = = = HrapInfo = = =\n";
        theString = (String)theString + "Data Source: " + source + "\n";
        theString = (String)theString + "=========================================================\n";
        return super.toString() + (String)theString;
    }

    public int setDataSource(String dataSource) {
        this._dataSource = dataSource;
        return 0;
    }

    @Override
    public int flatSize() {
        return super.flatSize() + 12;
    }

    public HrapInfoFlat makeGridInfoFlat(HrapInfoFlat a) {
        super.loadFlatData(a);
        Heclib.StringHol(this._dataSource, this._dataSource.length(), a._dataSource);
        return a;
    }

    public HrapInfoFlat makeGridInfoFlat() {
        HrapInfoFlat a = new HrapInfoFlat();
        super.loadFlatData(a);
        Heclib.StringHol(this._dataSource, this._dataSource.length(), a._dataSource);
        return a;
    }

    public void set(HrapInfo hi) {
        super.set(hi);
        this._dataSource = hi._dataSource;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof HrapInfo)) {
            return false;
        }
        HrapInfo hi = (HrapInfo)obj;
        return hi._dataSource.equals(this._dataSource);
    }
}

