/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.grid;

import hec.heclib.grid.GridInfo;
import hec.heclib.grid.GridInfoFlat;
import hec.heclib.grid.SpecifiedGridInfoFlat;
import hec.heclib.util.Heclib;
import java.io.BufferedWriter;
import rma.util.RMAIO;

public class SpecifiedGridInfo
extends GridInfo {
    static final int SPECIFIED_GRID_INFO_VERSION = 2;
    String _srsName = "";
    int _srsDefinitionType = 0;
    String _srsDefinition = "";
    float _xCoordOfGridCellZero;
    float _yCoordOfGridCellZero;
    float _nullValue;
    String _timeZoneID = "";
    int _timeZoneRawOffset;
    boolean _isInterval;
    boolean _isTimeStamped;

    public SpecifiedGridInfo() {
        this._gridType = 430;
        this._infoSize = this._gridInfoSize + 36;
        this._version = 2;
        this._srsName = "";
        this._srsDefinition = "";
        this._xCoordOfGridCellZero = 0.0f;
        this._yCoordOfGridCellZero = 0.0f;
        this._nullValue = -3.4028235E38f;
        this._timeZoneID = "UTC";
        this._timeZoneRawOffset = 0;
        this._isInterval = true;
        this._isTimeStamped = true;
        this.setCompressionInfo(26, 0, 1.0f, 0.0f);
    }

    public SpecifiedGridInfo(SpecifiedGridInfo si) {
        super(si);
        this._infoSize = this._gridInfoSize + 36;
        this._version = si._version;
        this._srsName = si._srsName;
        this._srsDefinition = si._srsDefinition;
        this._xCoordOfGridCellZero = si._xCoordOfGridCellZero;
        this._yCoordOfGridCellZero = si._yCoordOfGridCellZero;
        this._nullValue = si._nullValue;
        this._timeZoneID = si._timeZoneID;
        this._timeZoneRawOffset = si._timeZoneRawOffset;
        this._isInterval = si._isInterval;
        this._isTimeStamped = si._isTimeStamped;
    }

    @Override
    public int convertToGridInfo(GridInfoFlat s1) {
        if (s1.getClass() == SpecifiedGridInfoFlat.class) {
            return this.convertToGridInfo((SpecifiedGridInfoFlat)s1);
        }
        return super.convertToGridInfo(s1);
    }

    public int convertToGridInfo(SpecifiedGridInfoFlat sif) {
        super.convertToGridInfo(sif);
        this._infoSize = this._gridInfoSize + 36;
        this._version = sif._version;
        this._srsName = Heclib.holString(sif._srsNameAsHol, sif._srsNameLength * 4);
        this._srsDefinitionType = sif._srsDefinitionType;
        this._srsDefinition = Heclib.holString(sif._srsDefinitionAsHol, sif._srsDefinitionLength * 4);
        this._xCoordOfGridCellZero = sif._xCoordinateOfGridCellZero;
        this._yCoordOfGridCellZero = sif._yCoordinateOfGridCellZero;
        this._nullValue = sif._nullValue;
        this._timeZoneID = Heclib.holString(sif._timeZoneIdAsHol, sif._timeZoneIdLength * 4);
        this._timeZoneRawOffset = sif._timeZoneRawOffset;
        this._isInterval = sif._isInterval != 0;
        this._isTimeStamped = sif._isTimeStamped != 0;
        return 0;
    }

    public int convertToSridInfo(SpecifiedGridInfoFlat sif) {
        super.convertToGridInfo(sif);
        this._infoSize = this._gridInfoSize + 36;
        this._version = sif._version;
        this._srsName = Heclib.holString(sif._srsNameAsHol, sif._srsNameLength * 4);
        this._srsDefinitionType = sif._srsDefinitionType;
        this._srsDefinition = Heclib.holString(sif._srsDefinitionAsHol, sif._srsDefinitionLength * 4);
        this._xCoordOfGridCellZero = sif._xCoordinateOfGridCellZero;
        this._yCoordOfGridCellZero = sif._yCoordinateOfGridCellZero;
        this._nullValue = sif._nullValue;
        this._timeZoneID = Heclib.holString(sif._timeZoneIdAsHol, sif._timeZoneIdLength * 4);
        this._timeZoneRawOffset = sif._timeZoneRawOffset;
        this._isInterval = sif._isInterval != 0;
        this._isTimeStamped = sif._isTimeStamped != 0;
        return 0;
    }

    @Override
    public void show(BufferedWriter out) {
        RMAIO.fout(out, this.toString());
    }

    public int setSpatialReference(String srsName, String srsDefinition, float xOrigin, float yOrigin) {
        this._srsName = srsName;
        this._srsDefinition = srsDefinition;
        this._xCoordOfGridCellZero = xOrigin;
        this._yCoordOfGridCellZero = yOrigin;
        return 0;
    }

    @Override
    public String getSpatialReferenceSystem() {
        return this._srsDefinition;
    }

    public float getXCoordOfGridCellZero() {
        return this._xCoordOfGridCellZero;
    }

    public float getYCoordOfGridCellZero() {
        return this._yCoordOfGridCellZero;
    }

    public void setCoordOfGridCellZero(float x, float y) {
        this._xCoordOfGridCellZero = x;
        this._yCoordOfGridCellZero = y;
    }

    @Override
    public int flatSize() {
        int intCount = 11;
        intCount += (int)Math.ceil((double)this._srsName.length() / 4.0);
        intCount += (int)Math.ceil((double)this._srsDefinition.length() / 4.0);
        return super.flatSize() + (intCount += (int)Math.ceil((double)this._timeZoneID.length() / 4.0)) * 4;
    }

    public SpecifiedGridInfoFlat makeGridInfoFlat(SpecifiedGridInfoFlat a) {
        super.loadFlatData(a);
        a._version = this._version;
        a._srsNameLength = (int)Math.ceil((double)this._srsName.length() / 4.0);
        a._srsNameAsHol = new int[a._srsNameLength];
        Heclib.StringHol(this._srsName, this._srsName.length(), a._srsNameAsHol);
        a._srsDefinitionType = this._srsDefinitionType;
        a._srsDefinitionLength = (int)Math.ceil((double)this._srsDefinition.length() / 4.0);
        a._srsDefinitionAsHol = new int[a._srsDefinitionLength];
        Heclib.StringHol(this._srsDefinition, this._srsDefinition.length(), a._srsDefinitionAsHol);
        a._xCoordinateOfGridCellZero = this._xCoordOfGridCellZero;
        a._yCoordinateOfGridCellZero = this._yCoordOfGridCellZero;
        a._nullValue = this._nullValue;
        a._timeZoneIdLength = (int)Math.ceil((double)this._timeZoneID.length() / 4.0);
        a._timeZoneIdAsHol = new int[a._timeZoneIdLength];
        Heclib.StringHol(this._timeZoneID, this._timeZoneID.length(), a._timeZoneIdAsHol);
        a._timeZoneRawOffset = this._timeZoneRawOffset;
        a._isInterval = 0;
        if (this._isInterval) {
            a._isInterval = 1;
        }
        a._isTimeStamped = 0;
        if (this._isTimeStamped) {
            a._isTimeStamped = 1;
        }
        return a;
    }

    public SpecifiedGridInfoFlat makeGridInfoFlat() {
        SpecifiedGridInfoFlat a = new SpecifiedGridInfoFlat();
        super.loadFlatData(a);
        return a;
    }

    public void set(SpecifiedGridInfo si) {
        super.set(si);
        this._version = si._version;
        this._srsName = si._srsName;
        this._srsDefinitionType = si._srsDefinitionType;
        this._srsDefinition = si._srsDefinition;
        this._nullValue = si._nullValue;
        this._timeZoneID = si._timeZoneID;
        this._timeZoneRawOffset = si._timeZoneRawOffset;
        this._isInterval = si._isInterval;
        this._isTimeStamped = si._isTimeStamped;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SpecifiedGridInfo)) {
            return false;
        }
        SpecifiedGridInfo si = (SpecifiedGridInfo)obj;
        if (si._version != this._version) {
            return false;
        }
        if (!si._srsName.equals(this._srsName)) {
            return false;
        }
        if (si._timeZoneRawOffset != this._timeZoneRawOffset) {
            return false;
        }
        if (si._isInterval != this._isInterval) {
            return false;
        }
        if (si._isTimeStamped != this._isTimeStamped) {
            return false;
        }
        return si._cellSize == this._cellSize;
    }

    @Override
    public String toString() {
        String temp = "TRUE";
        Object theString = " = = = SpecifiedGridInfo = = = \n";
        theString = (String)theString + "Spatial Reference: " + this._srsName + "\n";
        if (this._verbose) {
            theString = (String)theString + "Spatial Reference System Definition Type: WKT (" + this._srsDefinitionType + ")\n";
            theString = (String)theString + "Spatial Reference System Definition:\n";
            theString = (String)theString + this.humanizeWktString(this._srsDefinition);
        }
        theString = (String)theString + "X Coordinate of Origin Cell: " + this._xCoordOfGridCellZero + "\n";
        theString = (String)theString + "Y Coordinate of Origin Cell: " + this._yCoordOfGridCellZero + "\n";
        if (this._verbose) {
            theString = (String)theString + "Null value: " + this._nullValue + "\n";
        }
        theString = (String)theString + "Time zone ID: " + this._timeZoneID + "\n";
        theString = (String)theString + "Time zone offset (ms): " + this._timeZoneRawOffset + "\n";
        if (!this._isInterval) {
            temp = "FALSE";
        }
        theString = (String)theString + "Represents an interval value: " + temp + "\n";
        temp = "TRUE";
        if (!this._isTimeStamped) {
            temp = "FALSE";
        }
        theString = (String)theString + "Data has a time stamp: " + temp + "\n";
        theString = (String)theString + "=========================================================";
        return super.toString() + (String)theString;
    }

    private String humanizeWktString(String WktString) {
        int i = 0;
        int fromIndex = 0;
        int toIndex = 0;
        int indentLevel = 1;
        int nextIndentLevel = 1;
        Object humanizedWktString = "";
        toIndex = WktString.indexOf("[", fromIndex);
        toIndex = WktString.indexOf("[", toIndex + 1);
        while (toIndex > 0) {
            toIndex = WktString.lastIndexOf(44, toIndex);
            ++nextIndentLevel;
            for (i = fromIndex; i < toIndex; ++i) {
                char c2 = WktString.charAt(i);
                if (c2 != ']') continue;
                --nextIndentLevel;
            }
            for (i = 0; i < indentLevel; ++i) {
                humanizedWktString = (String)humanizedWktString + "\t";
            }
            humanizedWktString = (String)humanizedWktString + this._srsDefinition.substring(fromIndex, ++toIndex) + "\n";
            fromIndex = toIndex;
            indentLevel = nextIndentLevel;
            toIndex = this._srsDefinition.indexOf("[", fromIndex);
            toIndex = this._srsDefinition.indexOf("[", toIndex + 1);
        }
        for (i = 0; i < indentLevel; ++i) {
            humanizedWktString = (String)humanizedWktString + "\t";
        }
        humanizedWktString = (String)humanizedWktString + this._srsDefinition.substring(fromIndex, this._srsDefinition.length()) + "\n";
        return humanizedWktString;
    }
}

