/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.grid;

import hec.heclib.grid.GridInfoFlat;
import hec.heclib.util.Heclib;
import java.util.logging.Logger;

public class SpecifiedGridInfoFlat
extends GridInfoFlat {
    private static final Logger LOGGER = Logger.getLogger(SpecifiedGridInfoFlat.class.getName());
    int _version = 2;
    int _srsNameLength = 0;
    int[] _srsNameAsHol = null;
    int _srsDefinitionType = 0;
    int _srsDefinitionLength = 0;
    int[] _srsDefinitionAsHol = null;
    float _xCoordinateOfGridCellZero = -901.0f;
    float _yCoordinateOfGridCellZero = -901.0f;
    float _nullValue = -9999.0f;
    int _timeZoneIdLength = 1;
    int[] _timeZoneIdAsHol = new int[this._timeZoneIdLength];
    int _timeZoneRawOffset;
    int _isInterval;
    int _isTimeStamped;

    public SpecifiedGridInfoFlat() {
        String tz = "UTC";
        Heclib.StringHol(tz, tz.length(), this._timeZoneIdAsHol);
        this._timeZoneRawOffset = 0;
        this._isInterval = 1;
        this._isTimeStamped = 1;
    }

    @Override
    public int size() {
        int intCount = 11;
        intCount += this._srsNameLength;
        intCount += this._srsDefinitionLength;
        return super.size() + (intCount += this._timeZoneIdLength) * 4;
    }

    @Override
    public void show() {
        System.out.println("\n = = = SpecifiedGridInfoFlat = = =");
        System.out.println("Version number: " + this._version);
        System.out.println("Spatial Reference: " + Heclib.holString(this._srsNameAsHol, this._srsNameLength));
        System.out.println("X Coord of Origin Cell: " + this._xCoordinateOfGridCellZero);
        System.out.println("Y Coord of Origin Cell: " + this._yCoordinateOfGridCellZero);
        System.out.println("Null value: " + this._nullValue);
        System.out.println("Time zone ID: " + Heclib.holString(this._timeZoneIdAsHol, this._timeZoneIdLength));
        System.out.println("Time zone offset (ms): " + this._timeZoneRawOffset);
        System.out.println(this._isInterval);
        System.out.println(this._isTimeStamped);
        super.show();
    }

    @Override
    public void flatten(int[] array) {
        super.flatten(array);
        int pos = super.size() / 4;
        int i = 0;
        array[pos++] = this._version;
        array[pos++] = this._srsNameLength;
        for (i = 0; i < this._srsNameLength; ++i) {
            array[pos++] = this._srsNameAsHol[i];
        }
        array[pos++] = this._srsDefinitionType;
        array[pos++] = this._srsDefinitionLength;
        for (i = 0; i < this._srsDefinitionLength; ++i) {
            array[pos++] = this._srsDefinitionAsHol[i];
        }
        array[pos++] = Float.floatToIntBits(this._xCoordinateOfGridCellZero);
        array[pos++] = Float.floatToIntBits(this._yCoordinateOfGridCellZero);
        array[pos++] = Float.floatToIntBits(this._nullValue);
        array[pos++] = this._timeZoneIdLength;
        for (i = 0; i < this._timeZoneIdLength; ++i) {
            array[pos++] = this._timeZoneIdAsHol[i];
        }
        array[pos++] = this._timeZoneRawOffset;
        array[pos++] = this._isInterval;
        array[pos++] = this._isTimeStamped;
    }

    @Override
    public boolean unflatten(int[] array) {
        boolean ok = super.unflatten(array);
        if (!ok) {
            return false;
        }
        int pos = super.size() / 4;
        if (pos + 2 >= array.length) {
            return false;
        }
        int i = 0;
        this._version = array[pos++];
        this._srsNameLength = array[pos++];
        if (this._srsNameLength >= array.length) {
            LOGGER.warning("This Grid record appears to be corrupted.");
            return false;
        }
        this._srsNameAsHol = new int[this._srsNameLength];
        for (i = 0; i < this._srsNameLength; ++i) {
            this._srsNameAsHol[i] = array[pos++];
        }
        this._srsDefinitionType = array[pos++];
        this._srsDefinitionLength = array[pos++];
        this._srsDefinitionAsHol = new int[this._srsDefinitionLength];
        for (i = 0; i < this._srsDefinitionLength; ++i) {
            this._srsDefinitionAsHol[i] = array[pos++];
        }
        this._xCoordinateOfGridCellZero = Float.intBitsToFloat(array[pos++]);
        this._yCoordinateOfGridCellZero = Float.intBitsToFloat(array[pos++]);
        this._nullValue = Float.intBitsToFloat(array[pos++]);
        this._timeZoneIdLength = array[pos++];
        for (i = 0; i < this._timeZoneIdLength; ++i) {
            this._timeZoneIdAsHol[i] = array[pos++];
        }
        this._timeZoneRawOffset = array[pos++];
        this._isInterval = array[pos++];
        this._isTimeStamped = array[pos++];
        return true;
    }
}

