/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.util;

import java.awt.Color;
import java.util.StringTokenizer;
import java.util.Vector;

public class ColorBase {
    public static String[] colorNames = new String[]{"Black", "DarkGray", "Gray", "LightGray", "DarkBlue", "Blue", "Purple", "Cyan", "DarkGreen", "Olive", "Green", "DarkRed", "Cardinal", "Red", "Pink", "Magenta", "Orange", "Yellow", "White"};
    public static Color[] colorValues = new Color[]{Color.black, Color.darkGray, Color.gray, Color.lightGray, new Color(0, 0, 168), Color.blue, new Color(174, 0, 174), Color.cyan, new Color(0, 168, 0), new Color(138, 137, 70), Color.green, new Color(168, 0, 0), new Color(210, 60, 48), Color.red, Color.pink, Color.magenta, Color.orange, Color.yellow, Color.white};

    public static String[] getColorNames() {
        return colorNames;
    }

    public static Color[] getColorValues() {
        return colorValues;
    }

    public static Color getColorFromName(String name) {
        for (int i = 0; i < colorNames.length; ++i) {
            if (!name.equalsIgnoreCase(colorNames[i])) continue;
            return colorValues[i];
        }
        return null;
    }

    public static String getNameFromColor(Color color) {
        for (int i = 0; i < colorValues.length; ++i) {
            if (color != colorValues[i]) continue;
            return colorNames[i];
        }
        return null;
    }

    public static int getColorIndex(String name) {
        for (int i = 0; i < colorNames.length; ++i) {
            if (!name.equalsIgnoreCase(colorNames[i])) continue;
            return i;
        }
        return -1;
    }

    public static int getColorIndex(Color color) {
        for (int i = 0; i < colorValues.length; ++i) {
            if (color != colorValues[i]) continue;
            return i;
        }
        return -1;
    }

    public static String getNameFromIndex(int index) {
        if (index >= 0 && index < colorNames.length) {
            return colorNames[index];
        }
        return null;
    }

    public static Color getColorFromIndex(int index) {
        if (index >= 0 && index < colorValues.length) {
            return colorValues[index];
        }
        return null;
    }

    public static void parseSettings(String settings, Vector doubleValues, Vector colors) {
        if (settings == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(settings, ",");
        String previousToken = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Color color = ColorBase.getColorFromName(token);
            if (color != null) {
                try {
                    Double value = Double.valueOf(previousToken);
                    boolean found = false;
                    for (int i = 0; i < doubleValues.size(); ++i) {
                        Double d = (Double)doubleValues.elementAt(i);
                        if (value.compareTo(d) != 0) continue;
                        colors.setElementAt(color, i);
                        found = true;
                        break;
                    }
                    if (!found) {
                        doubleValues.addElement(value);
                        colors.addElement(color);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            previousToken = token;
        }
    }

    public static void parseSettingsString(String settings, Vector settingString, Vector colors, boolean allowDuplicates) {
        if (settings == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(settings, ",");
        String previousToken = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Color color = ColorBase.getColorFromName(token);
            if (color != null) {
                int loc = settingString.indexOf(previousToken);
                if (loc >= 0 && !allowDuplicates) {
                    colors.setElementAt(color, loc);
                } else {
                    settingString.addElement(previousToken);
                    colors.addElement(color);
                }
            }
            previousToken = token;
        }
    }
}

