/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.util;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class EncoderDecoder
implements Serializable {
    protected final String DFL_WRAP_A = "[";
    protected final String DFL_WRAP_B = "]";
    protected String[] m_wrappers = new String[2];
    protected Hashtable m_codeList = new Hashtable();
    protected Hashtable m_decodeList = new Hashtable();
    protected boolean m_offMode = false;
    protected boolean m_offMode_wKey = false;
    protected String m_offModeKey = null;

    public EncoderDecoder() {
        this.add_wrappers(null, null);
    }

    public EncoderDecoder(String wrapA, String wrapB, Vector codes, Vector decodes) {
        this();
        this.add_wrappers(wrapA, wrapB);
        if (!this.fill_HashTable(codes, decodes)) {
            // empty if block
        }
    }

    public EncoderDecoder(String wrapA, String wrapB, String[] codes, String[] decodes) {
        this();
        this.add_wrappers(wrapA, wrapB);
        if (!this.fill_HashTable(codes, decodes)) {
            // empty if block
        }
    }

    public void setOffMode(boolean b) {
        this.m_offMode = b;
        if (b) {
            if (!this.m_decodeList.containsKey(this.wrap("off")) && !this.m_decodeList.containsKey(this.wrap("OFF"))) {
                this.m_decodeList.put(this.wrap("off"), " ");
                this.m_decodeList.put(this.wrap("OFF"), " ");
            }
        } else {
            this.m_decodeList.remove(this.wrap("off"));
            this.m_decodeList.remove(this.wrap("OFF"));
        }
    }

    public void setOffMode(String key) {
        this.m_offMode_wKey = true;
        this.m_offModeKey = key;
    }

    protected void add_wrappers(String a, String b) {
        if (a == null || b == null || a.trim().length() == 0 || b.trim().length() == 0) {
            this.m_wrappers[0] = "[";
            this.m_wrappers[1] = "]";
        } else {
            this.m_wrappers[0] = a;
            this.m_wrappers[1] = b;
        }
    }

    protected boolean fill_HashTable(Vector codes, Vector decodes) {
        int index;
        int numAdded = 0;
        int n = index = codes.size() < decodes.size() ? codes.size() : decodes.size();
        if (index == 0) {
            return false;
        }
        for (int i = 0; i < index; ++i) {
            if (!this.addWithWrapper(codes.elementAt(i).toString(), decodes.elementAt(i).toString())) continue;
            ++numAdded;
        }
        return numAdded >= index;
    }

    protected boolean fill_HashTable(String[] codes, String[] decodes) {
        int numAdded = 0;
        int index = codes.length < decodes.length ? codes.length : decodes.length;
        for (int i = 0; i < index; ++i) {
            if (!this.addWithWrapper(codes[i], decodes[i])) continue;
            ++numAdded;
        }
        return numAdded >= index;
    }

    protected boolean fill_HashTable(String[][] codeNdecode) {
        int numAdded = 0;
        for (int i = 0; i < codeNdecode.length; ++i) {
            if (!this.addWithWrapper(codeNdecode[i][0], codeNdecode[i][1])) continue;
            ++numAdded;
        }
        return numAdded >= codeNdecode.length;
    }

    protected String wrap(String s) {
        StringBuffer sbuf = new StringBuffer(s);
        sbuf.insert(0, this.m_wrappers[0]);
        sbuf.append(this.m_wrappers[1]);
        return sbuf.toString();
    }

    protected boolean addWithWrapper(String code, String decode) {
        boolean c2 = false;
        boolean d = false;
        if (code == null || decode == null || code.trim().length() == 0 || decode.trim().length() == 0) {
            return false;
        }
        c2 = this.m_codeList.put(decode.trim(), this.wrap(code.trim())) == null;
        boolean bl = d = this.m_decodeList.put(this.wrap(code.trim()), decode.trim()) == null;
        return c2 && d;
    }

    public boolean addCodeDecode(String code, String decode) {
        return this.addWithWrapper(code, decode);
    }

    public boolean addCodeDecode(String[] codes, String[] decodes) {
        return this.fill_HashTable(codes, decodes);
    }

    public boolean addCodeDecode(String[][] codeNdecode) {
        return this.fill_HashTable(codeNdecode);
    }

    public void clear() {
        this.m_codeList.clear();
        this.m_decodeList.clear();
        if (this.m_offMode) {
            this.setOffMode(true);
        }
    }

    public String decodeString(String s) {
        boolean index = false;
        int lastIndexa = -1;
        int lastIndexb = -1;
        String searchString = null;
        String codeString = null;
        String replace = null;
        StringBuffer finalString = new StringBuffer();
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        searchString = new String(s.trim());
        while (searchString.length() != 0) {
            lastIndexa = searchString.indexOf(this.m_wrappers[0]);
            if (lastIndexa < 0 || lastIndexa >= searchString.length()) {
                finalString.append(searchString);
                break;
            }
            finalString.append(searchString.substring(0, lastIndexa));
            searchString = searchString.substring(lastIndexa);
            lastIndexb = searchString.indexOf(this.m_wrappers[1]);
            if (lastIndexb <= 0 || lastIndexb >= searchString.length()) {
                finalString.append(searchString);
                break;
            }
            codeString = searchString.substring(1, lastIndexb);
            searchString = searchString.substring(lastIndexb + 1);
            if (this.m_offMode && (codeString.trim().equals("off") || codeString.trim().equals("OFF"))) {
                return (String)this.m_decodeList.get(this.wrap(codeString.trim()));
            }
            replace = (String)this.m_decodeList.get(this.wrap(codeString.trim()));
            if (replace != null) {
                if (this.m_offMode_wKey && this.m_offModeKey != null && this.m_offModeKey.equals(replace)) {
                    return new String(" ");
                }
                finalString.append(replace);
                continue;
            }
            finalString.append(this.wrap(codeString));
        }
        return finalString.toString();
    }

    public String encodeString(String s) {
        int index = 0;
        int i = 0;
        int searchLength = 0;
        String searchString = null;
        String replace = new String();
        StringBuffer finalString = new StringBuffer();
        boolean replaceFound = false;
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        searchString = new String(s.trim());
        searchLength = searchString.length();
        while (i < s.length()) {
            searchString = s.substring(i);
            for (int k = 1; k <= searchString.length(); ++k) {
                String key = searchString.substring(0, k);
                replace = (String)this.m_codeList.get(key);
                if (replace == null || replace.equals(key)) continue;
                finalString.append(replace);
                index = k;
                replaceFound = true;
                break;
            }
            if (!replaceFound) {
                finalString.append(s.charAt(i));
                ++i;
            } else {
                i = index;
                replaceFound = false;
            }
            searchLength = searchString.length();
        }
        return finalString.toString();
    }
}

