/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.util;

import hec.lang.annotation.Scriptable;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class HecDouble
implements Serializable {
    public static final int NO_PRECISION_SET = -1;
    public static final int EXPONENTIAL_NUMBER = -2;
    public static final int NO_VALUE_SET = -3;
    private static DecimalFormatSymbols _symbols = new DecimalFormatSymbols(Locale.getDefault());
    protected int _precision;
    protected double _value;
    protected boolean _showCommas = false;

    public HecDouble() {
        this._precision = -3;
        this._value = -3.4028234663852886E38;
    }

    public HecDouble(String stringValue) {
        this.set(stringValue);
    }

    public HecDouble(double value, int precision) {
        this._value = value;
        this._precision = precision;
    }

    public HecDouble(double value) {
        this._value = value;
        this._precision = -1;
    }

    public HecDouble(HecDouble hecDouble) {
        this._value = hecDouble._value;
        this._precision = hecDouble._precision;
    }

    public int set(String value) {
        try {
            this._value = Double.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            try {
                this._value = new DecimalFormat().parse(value.trim()).doubleValue();
            }
            catch (Exception p) {
                this._value = -3.4028234663852886E38;
                this._precision = -3;
                return -1;
            }
        }
        int decimal = value.indexOf(".");
        this._precision = decimal >= 0 ? (value.indexOf(69) > 0 || value.indexOf(101) > 0 ? -2 : value.trim().length() - decimal - 1) : 0;
        return 0;
    }

    public void set(double value) {
        this._value = value;
        if (value == -3.4028234663852886E38) {
            this._precision = -3;
        } else if (this._precision == -3) {
            this._precision = -1;
        }
    }

    public void set(double value, int precision) {
        this._value = value;
        this._precision = value == -3.4028234663852886E38 ? -3 : precision;
    }

    public void set(HecDouble hecDouble) {
        this._value = hecDouble._value;
        this._precision = hecDouble._precision;
    }

    public void setUndefined() {
        this._precision = -3;
        this._value = -3.4028234663852886E38;
    }

    public int setPrecision(int precision) {
        if (precision > -3 && precision < 10) {
            this._precision = precision;
            return 0;
        }
        return -1;
    }

    public void setSignificantDigits(int sigDigits) {
        this._precision = HecDouble.estimatePrecision(this._value, sigDigits);
    }

    public void setShowCommas(boolean showCommas) {
        this._showCommas = showCommas;
    }

    public boolean getShowCommas() {
        return this._showCommas;
    }

    public static int estimatePrecision(double value, int sigDigits) {
        int precision;
        int size = -6;
        double absValue = Math.abs(value);
        if (absValue == 0.0) {
            size = sigDigits - 2;
        }
        if (absValue > 1.0E-5) {
            size = -5;
        }
        if (absValue > 1.0E-4) {
            size = -4;
        }
        if (absValue > 0.001) {
            size = -3;
        }
        if (absValue > 0.01) {
            size = -3;
        }
        if (absValue > 0.1) {
            size = -1;
        }
        if (absValue > 1.0) {
            size = 0;
        }
        if (absValue > 10.0) {
            size = 1;
        }
        if (absValue > 100.0) {
            size = 2;
        }
        if (absValue > 1000.0) {
            size = 3;
        }
        if (absValue > 10000.0) {
            size = 4;
        }
        if (absValue > 100000.0) {
            size = 5;
        }
        if (absValue > 1000000.0) {
            size = 6;
        }
        if (absValue > 1.0E7) {
            size = 7;
        }
        if ((precision = -(size - sigDigits + 1)) < 0) {
            precision = 0;
        }
        if (size == -6 || size == 7) {
            precision = -1;
        }
        return precision;
    }

    public boolean isDefined() {
        if (this._precision == -3) {
            return false;
        }
        return this._value != -3.4028234663852886E38;
    }

    public String toString() {
        return this.string();
    }

    public String string() {
        if (this.isDefined()) {
            return HecDouble.string(this._value, this._precision, this._showCommas);
        }
        return "";
    }

    public String string(boolean printCommas) {
        return this.string(printCommas, _symbols);
    }

    public String string(String undefinedString) {
        return HecDouble.string(this._value, this._precision, this._showCommas, _symbols, undefinedString);
    }

    public String string(boolean printCommas, DecimalFormatSymbols symbols) {
        if (this.isDefined()) {
            return HecDouble.string(this._value, this._precision, printCommas, symbols);
        }
        return "";
    }

    public String string(int precision, boolean printCommas) {
        if (this.isDefined()) {
            return HecDouble.string(this._value, precision, printCommas);
        }
        return "";
    }

    public static String string(double value, int precision, boolean printCommas) {
        return HecDouble.string(value, precision, printCommas, _symbols);
    }

    public static String string(double value, int precision, boolean printCommas, DecimalFormatSymbols symbols) {
        return HecDouble.string(value, precision, printCommas, symbols, "");
    }

    public static String string(double value, int precision, boolean printCommas, DecimalFormatSymbols symbols, String undefinedString) {
        if (precision == -3) {
            return undefinedString;
        }
        if (precision > 7) {
            precision = -1;
        }
        if (precision == -1) {
            precision = HecDouble.estimatePrecision(value, 5);
        }
        if (precision == -1 || precision == -2) {
            return String.valueOf(value);
        }
        if (value == 0.0) {
            String temp = HecDouble.formatPattern(precision, symbols.getDecimalSeparator());
            return temp;
        }
        Object pattern = printCommas ? "#,###,###,##" + HecDouble.formatPattern(precision) : HecDouble.formatPattern(precision);
        DecimalFormat df = new DecimalFormat((String)pattern, symbols);
        return df.format(value);
    }

    public static String formatPattern(int precision) {
        return HecDouble.formatPattern(precision, '.');
    }

    public static String formatPattern(int precision, char decimalSeparator) {
        String retval = "0";
        if (precision == 0) {
            return retval;
        }
        if (precision == 1) {
            char[] decimal = new char[]{decimalSeparator};
            retval = retval.concat(new String(decimal));
            return retval.concat("0");
        }
        if (precision == 2) {
            char[] decimal = new char[]{decimalSeparator};
            retval = retval.concat(new String(decimal));
            return retval.concat("00");
        }
        if (precision == 3) {
            char[] decimal = new char[]{decimalSeparator};
            retval = retval.concat(new String(decimal));
            return retval.concat("000");
        }
        if (precision == 4) {
            char[] decimal = new char[]{decimalSeparator};
            retval = retval.concat(new String(decimal));
            return retval.concat("0000");
        }
        if (precision == 5) {
            char[] decimal = new char[]{decimalSeparator};
            retval = retval.concat(new String(decimal));
            return retval.concat("00000");
        }
        if (precision == 6) {
            char[] decimal = new char[]{decimalSeparator};
            retval = retval.concat(new String(decimal));
            return retval.concat("000000");
        }
        if (precision == 7) {
            char[] decimal = new char[]{decimalSeparator};
            retval = retval.concat(new String(decimal));
            return retval.concat("0000000");
        }
        return "";
    }

    public double value() {
        return this._value;
    }

    public boolean precisionSet() {
        return this._precision > -1 || this._precision == -2;
    }

    public int precision() {
        return this._precision;
    }

    public void add(double value) {
        this._value += value;
    }

    public void add(HecDouble value) {
        this._value += value.value();
        this._precision = Math.max(value.precision(), this.precision());
    }

    public void subtract(double value) {
        this._value -= value;
    }

    public void subtract(HecDouble value) {
        this._value -= value.value();
        this._precision = Math.max(value.precision(), this.precision());
    }

    public void multiply(double value) {
        this._value *= value;
    }

    public void multiply(HecDouble value) {
        this._value *= value.value();
        this._precision = Math.max(value.precision(), this.precision());
    }

    public void divide(double value) {
        this._value /= value;
    }

    public void divide(HecDouble value) {
        this._value /= value.value();
        this._precision = Math.max(value.precision(), this.precision());
    }

    public boolean equals(HecDouble value) {
        return this.compareTo(value) == 0;
    }

    public boolean lessThan(HecDouble value) {
        return this.compareTo(value) == -1;
    }

    public boolean lessThanEqual(HecDouble value) {
        return this.compareTo(value) <= 0;
    }

    public boolean greaterThan(HecDouble value) {
        return this.compareTo(value) == 1;
    }

    public boolean greaterThanEqual(HecDouble value) {
        return this.compareTo(value) >= 0;
    }

    public boolean equalsWithinTolerance(HecDouble value, double tolerance) {
        return this.compareTo(value, tolerance) == 0;
    }

    public boolean equalsWithinPercent(HecDouble value, double percent) {
        double tolerance = value.value() * percent / 100.0;
        return this.compareTo(value, tolerance) == 0;
    }

    public boolean equal(double value, double tolerance) {
        return this.compareTo(value, tolerance) == 0;
    }

    public boolean lessThan(double value, double tolerance) {
        return this.compareTo(value, tolerance) == -1;
    }

    public boolean lessThanEqual(double value, double tolerance) {
        return this.compareTo(value, tolerance) <= 0;
    }

    public boolean greaterThan(double value, double tolerance) {
        return this.compareTo(value, tolerance) == 1;
    }

    public boolean greaterThanEqual(double value, double tolerance) {
        return this.compareTo(value, tolerance) >= 0;
    }

    public double getTolerances(HecDouble value) {
        int minPrec = value.precision();
        if (this._precision < minPrec) {
            minPrec = this._precision;
        }
        double tol = minPrec >= 0 ? (minPrec == 0 ? 0.5 : (minPrec == 1 ? 0.05 : (minPrec == 2 ? 0.005 : (minPrec == 3 ? 5.0E-4 : (minPrec == 4 ? 5.0E-5 : 0.5 * Math.pow(10.0, -((double)minPrec))))))) : 0.0;
        return tol;
    }

    @Scriptable
    public synchronized int compareTo(HecDouble hecDouble) {
        double tol = this.getTolerances(hecDouble);
        return this.compareTo(hecDouble, tol);
    }

    public synchronized int compareTo(HecDouble hecDouble, double tolerance) {
        double val = hecDouble.value();
        return this.compareTo(val, tolerance);
    }

    public synchronized int compareTo(double val, double tolerance) {
        if (this._value == -3.4028234663852886E38 && val == -3.4028234663852886E38) {
            return 0;
        }
        if (this._value == -3.4028234663852886E38) {
            return -1;
        }
        if (val == -3.4028234663852886E38) {
            return 1;
        }
        if (this._value > val + (tolerance = Math.abs(tolerance))) {
            return 1;
        }
        if (this._value < val - tolerance) {
            return -1;
        }
        return 0;
    }

    public synchronized int compare(double val) {
        return this.compareTo(val);
    }

    @Scriptable
    public synchronized int compareTo(double val) {
        if (this._value == -3.4028234663852886E38 && val == -3.4028234663852886E38) {
            return 0;
        }
        if (this._value == -3.4028234663852886E38) {
            return -1;
        }
        if (val == -3.4028234663852886E38) {
            return 1;
        }
        if (this._value < val) {
            return -1;
        }
        if (this._value > val) {
            return 1;
        }
        return 0;
    }
}

