/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.util;

import hec.heclib.util.HecDouble;
import hec.heclib.util.intContainer;
import java.io.Serializable;

public class HecDoubleArray
implements Serializable {
    private int _numberElements;
    private int _estimatedPrecision;
    private HecDouble[] _values;

    public HecDoubleArray() {
        this._numberElements = 0;
        this._values = null;
        this._estimatedPrecision = -3;
    }

    public HecDoubleArray(int numberElements) {
        if (numberElements > 0) {
            this.setSize(numberElements);
        } else {
            this._numberElements = 0;
            this._values = null;
        }
        this._estimatedPrecision = -3;
    }

    public HecDoubleArray(double[] doubleArray) {
        int numberElements = doubleArray.length;
        if (numberElements > 0) {
            this.setSize(numberElements);
            this.set(doubleArray);
        } else {
            this._numberElements = 0;
            this._values = null;
        }
        this._estimatedPrecision = -3;
    }

    public HecDoubleArray(HecDoubleArray hecDoubleArray) {
        this._numberElements = hecDoubleArray.numberElements();
        if (this._numberElements > 0) {
            this._values = new HecDouble[this._numberElements];
            for (int i = 0; i < this._numberElements; ++i) {
                this._values[i] = new HecDouble(hecDoubleArray._values[i]);
            }
        } else {
            this._values = null;
        }
        this._estimatedPrecision = -3;
    }

    public HecDouble value(int elementNumber) {
        if (elementNumber >= 0 && elementNumber < this._numberElements) {
            return this._values[elementNumber];
        }
        if (elementNumber >= 0 && elementNumber < this._numberElements + 1000) {
            this.resize(elementNumber + 1);
            return this._values[elementNumber];
        }
        HecDouble badValue = new HecDouble();
        badValue.setUndefined();
        return badValue;
    }

    public boolean isDefined() {
        intContainer i = new intContainer();
        return this.isDefined(i);
    }

    public boolean isDefined(int elementNumber) {
        if (this._values != null && elementNumber < this._numberElements) {
            return this._values[elementNumber].isDefined();
        }
        return false;
    }

    public boolean isDefined(intContainer elementNumber) {
        elementNumber.value = 0;
        if (this._values == null || this._numberElements == 0) {
            return false;
        }
        for (int i = 0; i < this._numberElements; ++i) {
            if (!this._values[i].isDefined()) continue;
            elementNumber.value = i;
            return true;
        }
        return false;
    }

    public int numberElements() {
        return this._numberElements;
    }

    public HecDouble element(int index) {
        if (index < 0) {
            return new HecDouble();
        }
        if (index > this._numberElements - 1) {
            this.resize(index + 1);
        }
        return this._values[index];
    }

    public String string(int elementNumber) {
        return this.string(elementNumber, false);
    }

    public String string(int elementNumber, boolean printCommas) {
        if (elementNumber >= this._numberElements || elementNumber < 0) {
            return "";
        }
        if (this._values[elementNumber].precisionSet()) {
            return this._values[elementNumber].string(printCommas);
        }
        if (this._estimatedPrecision == -3) {
            this.estimatePrecision();
        }
        return this._values[elementNumber].string(this._estimatedPrecision, printCommas);
    }

    public int estimatePrecision() {
        return this.estimatePrecision(5);
    }

    public int estimatePrecision(int sigDigits) {
        this._estimatedPrecision = this.precision();
        if (this._estimatedPrecision < 0) {
            double temp = this.absoluteMaximum().value();
            this._estimatedPrecision = HecDouble.estimatePrecision(temp, sigDigits);
        }
        return this._estimatedPrecision;
    }

    public void set(HecDoubleArray hecDoubleArray) {
        this._numberElements = hecDoubleArray.numberElements();
        if (this._numberElements > 0) {
            this._values = new HecDouble[this._numberElements];
            for (int i = 0; i < this._numberElements; ++i) {
                this._values[i] = new HecDouble(hecDoubleArray._values[i]);
            }
        } else {
            this._values = null;
        }
        this._estimatedPrecision = -3;
    }

    public void set(int index, HecDouble hecDouble) {
        if (index < 0) {
            index = 0;
        }
        if (this._numberElements < index) {
            this.setSize(index + 1);
        }
        this._values[index].set(hecDouble);
        if (hecDouble.precision() > this._estimatedPrecision) {
            this._estimatedPrecision = hecDouble.precision();
        }
    }

    public void set(String stringOfNumbers, String delimiter) {
        String[] svals = stringOfNumbers.split(delimiter);
        this.setSize(svals.length);
        for (int i = 0; i < svals.length; ++i) {
            this._values[i].set(svals[i]);
        }
    }

    public void set(int index, double value) {
        if (index < 0) {
            index = 0;
        }
        HecDouble temp = new HecDouble();
        temp.set(value);
        this.set(index, temp);
    }

    public void set(double[] values) {
        int number = values.length;
        this.setSize(number);
        for (int i = 0; i < number; ++i) {
            this._values[i].set(values[i]);
        }
    }

    public int setSize(int numberElements) {
        int i;
        if (numberElements < 1) {
            this._numberElements = 0;
            this._values = null;
            return -1;
        }
        HecDouble[] temp = new HecDouble[numberElements];
        for (i = 0; i < numberElements; ++i) {
            temp[i] = new HecDouble();
            if (i < this._numberElements) {
                temp[i].set(this._values[i]);
                continue;
            }
            temp[i].set(-3.4028234663852886E38);
        }
        this._numberElements = numberElements;
        this._values = new HecDouble[numberElements];
        for (i = 0; i < this._numberElements; ++i) {
            this._values[i] = new HecDouble(temp[i]);
        }
        return 0;
    }

    public int resize(int numberElements) {
        return this.resize(numberElements, 0, 0);
    }

    public int resize(int numberElements, int beginningElement) {
        HecDouble[] temp;
        if (numberElements < 1) {
            this._numberElements = 0;
            if (this._values != null) {
                this._values = null;
            }
            return -1;
        }
        if (beginningElement < 0) {
            beginningElement = 0;
        }
        if ((temp = new HecDouble[numberElements]) == null) {
            return -1;
        }
        int diff = numberElements - this._numberElements;
        if (diff > 0) {
            int y = beginningElement + diff - 1;
            int arrayPos = 0;
            for (int i = 0; i < numberElements; ++i) {
                temp[i] = new HecDouble();
                if ((i < beginningElement || i > y) && arrayPos < this._numberElements) {
                    temp[i].set(this._values[arrayPos]);
                    ++arrayPos;
                    continue;
                }
                temp[i].setUndefined();
            }
        } else {
            int arrayPos = 0;
            for (int i = 0; i < numberElements; ++i) {
                temp[i] = new HecDouble();
                arrayPos = i >= beginningElement ? i - diff : i;
                if (arrayPos < this._numberElements) {
                    temp[i].set(this._values[arrayPos]);
                    continue;
                }
                temp[i].setUndefined();
            }
        }
        this._numberElements = numberElements;
        this._values = temp;
        return 0;
    }

    public int resize(int numberElements, int beginningElementOld, int beginningElementNew) {
        HecDouble[] temp;
        if (numberElements < 1) {
            this._numberElements = 0;
            if (this._values != null) {
                this._values = null;
            }
            return -1;
        }
        if (beginningElementOld < 0) {
            beginningElementOld = 0;
        }
        if (beginningElementNew < 0) {
            beginningElementNew = 0;
        }
        if (beginningElementOld > this._numberElements) {
            beginningElementOld = this._numberElements;
        }
        if (beginningElementNew > numberElements) {
            beginningElementNew = numberElements;
        }
        if ((temp = new HecDouble[numberElements]) == null) {
            return -1;
        }
        int pos = this._numberElements - beginningElementOld + beginningElementNew;
        for (int i = 0; i < numberElements; ++i) {
            temp[i] = new HecDouble();
            if (i >= beginningElementNew && i < pos) {
                int k = beginningElementOld + i - beginningElementNew;
                temp[i].set(this._values[k]);
                continue;
            }
            temp[i].setUndefined();
        }
        this._numberElements = numberElements;
        this._values = temp;
        return 0;
    }

    public int setPrecision(int precision) {
        if (this._values == null || this._numberElements == 0) {
            return -1;
        }
        if (precision < -3 || precision > 9) {
            return -1;
        }
        for (int i = 0; i < this._numberElements; ++i) {
            this._values[i].setPrecision(precision);
        }
        if (precision >= 0) {
            this._estimatedPrecision = precision;
        }
        return 0;
    }

    public int setSignificantDigits(int sigDigits) {
        if (this._values == null || this._numberElements == 0) {
            return -1;
        }
        boolean i = false;
        HecDouble temp = this.absoluteMaximum();
        temp.setSignificantDigits(sigDigits);
        return this.setPrecision(temp.precision());
    }

    public void setUndefined() {
        if (this._values == null || this._numberElements == 0) {
            return;
        }
        for (int i = 0; i < this._numberElements; ++i) {
            this._values[i].setUndefined();
        }
    }

    public double[] getDoubleArray() {
        double[] array = new double[this._numberElements];
        for (int i = 0; i < this._numberElements; ++i) {
            array[i] = this._values[i].value();
        }
        return array;
    }

    public double[] getDoubleArray(int startElement, int lastElement) {
        if (startElement > lastElement) {
            return null;
        }
        double[] array = new double[lastElement - startElement + 1];
        for (int i = startElement; i <= lastElement; ++i) {
            array[i] = i < this._numberElements ? this._values[i].value() : -3.4028234663852886E38;
        }
        return array;
    }

    public int precision() {
        int precision = -1;
        for (int i = 0; i < this._numberElements; ++i) {
            int pre;
            if (this._values[i] == null || (pre = this._values[i].precision()) <= precision) continue;
            precision = pre;
        }
        return precision;
    }

    public HecDouble absoluteMaximum() {
        intContainer i = new intContainer();
        return this.absoluteMaximum(i);
    }

    public HecDouble absoluteMaximum(intContainer elementNumber) {
        HecDouble max = new HecDouble();
        if (!this.isDefined()) {
            return max;
        }
        double amax = Math.abs(this._values[elementNumber.value].value());
        elementNumber.value = this.firstDefined();
        double currMax = -3.4028234663852886E38;
        for (int i = 0; i < this._numberElements; ++i) {
            if (!this._values[i].isDefined() || !(currMax < Math.abs(this._values[i].value()))) continue;
            currMax = Math.abs(this._values[i].value());
            elementNumber.value = i;
        }
        max.set(currMax, this._values[elementNumber.value].precision());
        return max;
    }

    public int firstDefined() {
        for (int i = 0; i < this._numberElements; ++i) {
            if (!this._values[i].isDefined()) continue;
            return i;
        }
        return -1;
    }

    public int lastDefined() {
        for (int i = this._numberElements - 1; i > -1; --i) {
            if (!this._values[i].isDefined()) continue;
            return i;
        }
        return -1;
    }

    public HecDouble maximum() {
        intContainer i = new intContainer();
        return this.maximum(i);
    }

    public HecDouble maximum(intContainer elementNumber) {
        HecDouble max = new HecDouble();
        if (!this.isDefined()) {
            max.setUndefined();
            return max;
        }
        max.set(this._values[this.firstDefined()]);
        elementNumber.value = this.firstDefined();
        for (int i = 0; i < this._numberElements; ++i) {
            if (!this._values[i].isDefined() || !(this._values[i].value() > max.value())) continue;
            max.set(this._values[i]);
            elementNumber.value = i;
        }
        return max;
    }

    public HecDouble minimum() {
        intContainer i = new intContainer();
        return this.minimum(i);
    }

    public HecDouble minimum(intContainer elementNumber) {
        HecDouble min = new HecDouble();
        if (!this.isDefined()) {
            min.setUndefined();
            return min;
        }
        min.set(this._values[this.firstDefined()]);
        elementNumber.value = this.firstDefined();
        for (int i = 0; i < this._numberElements; ++i) {
            if (!this._values[i].isDefined() || !(this._values[i].value() < min.value())) continue;
            min.set(this._values[i]);
            elementNumber.value = i;
        }
        return min;
    }

    public HecDouble average() {
        HecDouble total = new HecDouble(this.sum());
        if (!total.isDefined()) {
            return total;
        }
        int number = this.numberValidElements();
        if (number == 0) {
            total.setUndefined();
            return total;
        }
        total.divide(number);
        return total;
    }

    public HecDouble sum() {
        HecDouble total = new HecDouble();
        if (!this.isDefined()) {
            total.setUndefined();
            return total;
        }
        double all = 0.0;
        for (int i = 0; i < this._numberElements; ++i) {
            if (!this._values[i].isDefined()) continue;
            all += this._values[i].value();
        }
        HecDouble first = new HecDouble(this._values[this.firstDefined()]);
        total.set(all, first.precision());
        return total;
    }

    public HecDouble absoluteMinimum() {
        intContainer i = new intContainer();
        return this.absoluteMinimum(i);
    }

    public HecDouble absoluteMinimum(intContainer elementNumber) {
        HecDouble min = new HecDouble();
        if (!this.isDefined()) {
            min.setUndefined();
            return min;
        }
        double amin = Math.abs(this._values[this.firstDefined()].value());
        elementNumber.value = this.firstDefined();
        for (int i = 0; i < this._numberElements; ++i) {
            if (!this._values[i].isDefined() || !(Math.abs(this._values[i].value()) < amin)) continue;
            amin = Math.abs(this._values[i].value());
            elementNumber.value = i;
        }
        min.set(amin, this._values[this.firstDefined()].precision());
        return min;
    }

    public HecDouble absoluteSum() {
        HecDouble total = new HecDouble();
        if (!this.isDefined()) {
            total.setUndefined();
            return total;
        }
        double all = 0.0;
        for (int i = 0; i < this._numberElements; ++i) {
            if (!this._values[i].isDefined()) continue;
            all += Math.abs(this._values[i].value());
        }
        total.set(all, this._values[this.firstDefined()].precision());
        return total;
    }

    public HecDouble absoluteAverage() {
        HecDouble total = new HecDouble();
        total.set(this.absoluteSum());
        if (!total.isDefined()) {
            total.setUndefined();
            return total;
        }
        int number = this.numberValidElements();
        if (number == 0) {
            total.setUndefined();
            return total;
        }
        total.divide(number);
        return total;
    }

    public int numberValidElements() {
        if (this._values == null || this._numberElements == 0) {
            return 0;
        }
        int number = 0;
        for (int i = 0; i < this._numberElements; ++i) {
            if (!this._values[i].isDefined()) continue;
            ++number;
        }
        return number;
    }

    public int numberMissingElements() {
        return this._numberElements - this.numberValidElements();
    }

    public String toString() {
        return this.toString("\n");
    }

    public String toString(String delim) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._numberElements; ++i) {
            sb.append(this._values[i].toString());
            sb.append(delim);
        }
        return sb.toString();
    }

    public HecDoubleArray merge(HecDoubleArray remote) {
        int i;
        int nLocal = this.numberElements();
        int nRemote = remote.numberElements();
        HecDouble[] temp = new HecDouble[nLocal + nRemote];
        int total = 0;
        int iLocal = 0;
        int iRemote = 0;
        HecDouble localElement = new HecDouble();
        HecDouble remoteElement = new HecDouble();
        while (iLocal < nLocal && iRemote < nRemote) {
            if (iLocal < nLocal) {
                localElement = this.element(iLocal);
            }
            if (iRemote < nRemote) {
                remoteElement = remote.element(iRemote);
            }
            if (localElement.equals(remoteElement)) {
                temp[total++] = localElement;
                ++iLocal;
                ++iRemote;
                continue;
            }
            if (localElement.lessThan(remoteElement)) {
                temp[total++] = localElement;
                ++iLocal;
                continue;
            }
            temp[total++] = remoteElement;
            ++iRemote;
        }
        if (iLocal < nLocal) {
            for (i = iLocal; i < nLocal; ++i) {
                temp[total++] = this.element(i);
            }
        }
        if (iRemote < nRemote) {
            for (i = iRemote; i < nRemote; ++i) {
                temp[total++] = remote.element(i);
            }
        }
        HecDoubleArray merged = new HecDoubleArray(total);
        for (int i2 = 0; i2 < total; ++i2) {
            merged.set(i2, new HecDouble(temp[i2]));
        }
        return merged;
    }

    public int index(double val, boolean ascending) {
        if (this._numberElements == 0) {
            return -1;
        }
        if (val == -3.4028234663852886E38) {
            for (int i = 0; i < this._numberElements; ++i) {
                if (this._values[i].isDefined()) continue;
                return i;
            }
            return -1;
        }
        if (ascending) {
            for (int i = 0; i < this._numberElements; ++i) {
                int compare = this._values[i].compare(val);
                if (compare == 0) {
                    return i;
                }
                if (compare <= 0) continue;
                return -1;
            }
            return -1;
        }
        for (int i = 0; i < this._numberElements; ++i) {
            if (this._values[i].value() != val) continue;
            return i;
        }
        return -1;
    }

    public int index(HecDouble val, boolean ascending) {
        return this.index(val.value(), ascending);
    }
}

