/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.util;

import hec.heclib.util.HecDouble;
import hec.heclib.util.HecDoubleParamData;
import java.io.Serializable;

public class HecDoubleParam
implements Serializable {
    protected HecDouble _value;
    protected String paramName = "";
    public static final String[] UNIT_SYSTEMS = new String[]{"English", "SI"};
    public static final int UNITS_ENGLISH = 0;
    public static final int UNITS_SI = 1;
    protected String _unitSystem;
    protected int _unit;
    protected static final double[] _factors = new double[]{0.0, 1.0, 25.4, 0.3048, 1.609344, 0.09290304, 2.589988, 0.028316847, 1.2335, 0.010933196, 0.028316847, 1.2335};
    protected static final double[][][] _scales = new double[][][]{new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 12.0, 63360.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 5280.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 88.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 88.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 88.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 88.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 88.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 88.0, 1.0}}, new double[][]{{0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0}, {0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0}, {0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0}, {0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0}, {0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0}, {0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0}, {0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0}, {0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0}, {0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0}}};
    public static final String[] FACTORS = new String[]{"INVALID_PARAMETER", "NON_DIMENSIONAL", "LENGTH_SHORT", "LENGTH_MEDIUM", "LENGTH_LONG", "AREA_SMALL", "AREA_LARGE", "VOLUME_SMALL", "VOLUME_LARGE", "VOLUME_PER_AREA", "FLOW_SMALL", "FLOW_LARGE"};
    public static final int INVALID_PARAMETER = 0;
    public static final int NON_DIMENSIONAL = 1;
    public static final int LENGTH_SHORT = 2;
    public static final int LENGTH_MEDIUM = 3;
    public static final int LENGTH_LONG = 4;
    public static final int AREA_SMALL = 5;
    public static final int AREA_LARGE = 6;
    public static final int VOLUME_SMALL = 7;
    public static final int VOLUME_LARGE = 8;
    public static final int VOLUME_PER_AREA = 9;
    public static final int FLOW_SMALL = 10;
    public static final int FLOW_LARGE = 11;

    public HecDoubleParam(String paramName) {
        this.paramName = paramName;
        this._value = new HecDouble();
        this._unit = 1;
        this._unitSystem = "SI";
    }

    public HecDoubleParam(String paramName, HecDouble v, String unitSystem, int unit) {
        this.paramName = paramName;
        this._value = v;
        this._unit = unit;
        this._unitSystem = unitSystem;
    }

    public HecDoubleParam(String paramName, double v, String unitSystem, int unit) {
        this.paramName = paramName;
        this._value = new HecDouble(v);
        this._unit = unit;
        this._unitSystem = unitSystem;
    }

    public int isInRange() {
        HecDoubleParamData data = (HecDoubleParamData)HecDoubleParamData.hecParamDataTable.get(this.paramName);
        double v = this._value.value();
        if (v > data.recMin && v < data.recMax) {
            return 2;
        }
        if (v > data.min && v < data.min) {
            return 1;
        }
        return 0;
    }

    public double getMin() {
        HecDoubleParamData data = (HecDoubleParamData)HecDoubleParamData.hecParamDataTable.get(this.paramName);
        return data.min;
    }

    public double getMax() {
        HecDoubleParamData data = (HecDoubleParamData)HecDoubleParamData.hecParamDataTable.get(this.paramName);
        return data.max;
    }

    public double getRecMin() {
        HecDoubleParamData data = (HecDoubleParamData)HecDoubleParamData.hecParamDataTable.get(this.paramName);
        return data.recMin;
    }

    public double getRecMax() {
        HecDoubleParamData data = (HecDoubleParamData)HecDoubleParamData.hecParamDataTable.get(this.paramName);
        return data.recMax;
    }

    public String getParamName() {
        HecDoubleParamData data = (HecDoubleParamData)HecDoubleParamData.hecParamDataTable.get(this.paramName);
        return data.paramName;
    }

    public void setValue(HecDouble v, String unitSystem, int unit) {
        this._value = v;
        this._unitSystem = unitSystem;
        this._unit = unit;
    }

    public void setValue(HecDouble v, String unitSystem) {
        this._value = v;
        this._unitSystem = unitSystem;
    }

    public void setValue(double v, String unitSystem, int unit) {
        this._value.set("" + v);
        this._unitSystem = unitSystem;
        this._unit = unit;
    }

    public void setValue(String s, double v, String unitSystem, int unit) {
        this.paramName = s;
        this._value.set("" + v);
        this._unitSystem = unitSystem;
        this._unit = unit;
    }

    public void setValue(HecDouble v) {
        this._value = v;
    }

    public void setValue(double v) {
        this._value.set("" + v);
    }

    public void setUnit(int pu) {
        this._unit = pu;
    }

    public void setUnitSystem(String us) {
        this._unitSystem = us;
    }

    public HecDouble getValue(String s) {
        HecDouble hd = new HecDouble(this._value);
        int p = hd.precision();
        if (s.equals(this._unitSystem)) {
            return this._value;
        }
        if (s.equalsIgnoreCase(UNIT_SYSTEMS[0])) {
            hd.divide(_factors[this._unit]);
        } else if (s.equalsIgnoreCase(UNIT_SYSTEMS[0])) {
            hd.multiply(_factors[this._unit]);
        }
        hd.setPrecision(3);
        return hd;
    }

    public HecDouble getValue(int unitsys) {
        return this.getValue(UNIT_SYSTEMS[unitsys]);
    }

    public double getValue() {
        return this._value.value();
    }

    public String getUnitSystem() {
        return this._unitSystem;
    }

    public int getUnit() {
        return this._unit;
    }

    public String toString() {
        Object rs = "";
        rs = (String)rs + this._value + ", " + this._unitSystem + ", " + this._unit;
        return rs;
    }

    public static double translateUnits(double argVal, int unitsize, int inUnitsys, int outUnitsys) {
        String pname = "";
        HecDoubleParam param = new HecDoubleParam(pname, argVal, UNIT_SYSTEMS[inUnitsys], unitsize);
        double val = param.getValue(UNIT_SYSTEMS[outUnitsys]).value();
        return val;
    }

    public static double scaleUnits(double argVal, int inUnitsize, int unitsys, int outUnitsize) {
        String pname = "";
        HecDouble dbl = new HecDouble();
        dbl.set("" + argVal);
        dbl.multiply(_scales[unitsys][inUnitsize][outUnitsize]);
        double val = dbl.value();
        return val;
    }
}

