/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import rma.util.RMAIO;
import rma.util.rmaTokenizer;

public class HecDoubleParamData {
    public double min;
    public double max;
    public double recMin;
    public double recMax;
    public String paramName;
    public static final int INVALID_PARAMETER = 0;
    public static final int NON_DIMENSIONAL = 1;
    public static final int LENGTH_SHORT = 2;
    public static final int LENGTH_MEDIUM = 3;
    public static final int LENGTH_LONG = 4;
    public static final int AREA_SMALL = 5;
    public static final int AREA_LARGE = 6;
    public static final int VOLUME_SMALL = 7;
    public static final int VOLUME_LARGE = 8;
    public static final int VOLUME_PER_AREA = 9;
    public static final int FLOW_SMALL = 10;
    public static final int FLOW_LARGE = 11;
    public static Hashtable hecParamDataTable = null;

    private void initHashTable() {
        hecParamDataTable = new Hashtable();
        try {
            BufferedReader in = new BufferedReader(new FileReader("j:\\apps\\wcds\\base\\hecParamData.rsys"));
            String line = in.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = in.readLine();
                    continue;
                }
                String type = RMAIO.getType(line, "=");
                String param = RMAIO.getParam(line, "=");
                if (type.equals("") || param.equals("")) continue;
                rmaTokenizer token = new rmaTokenizer(param, ",");
                HecDoubleParamData _d = new HecDoubleParamData();
                try {
                    _d.paramName = token.nextToken();
                    _d.min = RMAIO.parseDouble(token.nextToken());
                    _d.max = RMAIO.parseDouble(token.nextToken());
                    _d.recMin = RMAIO.parseDouble(token.nextToken());
                    _d.recMax = RMAIO.parseDouble(token.nextToken());
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                hecParamDataTable.put(type, _d);
                if (type.compareTo("HecDataParam End") != 0) {
                    line = in.readLine();
                    continue;
                }
                break;
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    HecDoubleParamData() {
        this.min = 0.0;
        this.max = 0.0;
        this.recMin = 0.0;
        this.recMax = 0.0;
        this.paramName = "";
        if (hecParamDataTable == null) {
            this.initHashTable();
        }
    }

    HecDoubleParamData(double min, double max, double recMin, double recMax, String paramName) {
        this.min = min;
        this.max = max;
        this.recMin = recMin;
        this.recMax = recMax;
        this.paramName = paramName;
        if (hecParamDataTable == null) {
            this.initHashTable();
        }
    }
}

