/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.util;

import hec.heclib.util.HecDoubleParamData;
import java.io.Serializable;

public class HecIntParam
implements Serializable {
    protected int _value;
    protected String paramName = "";
    protected String _unitSystem;
    protected int _unit;
    protected static final double[] _factors = new double[]{0.0, 1.0, 25.4, 0.3048, 1.609344, 0.09290304, 2.589988, 0.028316847, 1.2335, 0.010933196};

    public HecIntParam(String paramName) {
        this.paramName = paramName;
        this._value = 0;
        this._unit = 0;
        this._unitSystem = "SI";
    }

    public HecIntParam(String paramName, int value, String unitSystem, int unit) {
        this.paramName = paramName;
        this._value = value;
        this._unit = unit;
        this._unitSystem = unitSystem;
    }

    public int isInRange() {
        HecDoubleParamData data = (HecDoubleParamData)HecDoubleParamData.hecParamDataTable.get(this.paramName);
        if ((double)this._value > data.recMin && (double)this._value < data.recMax) {
            return 2;
        }
        if ((double)this._value > data.min && (double)this._value < data.min) {
            return 1;
        }
        return 0;
    }

    public double getMin() {
        HecDoubleParamData data = (HecDoubleParamData)HecDoubleParamData.hecParamDataTable.get(this.paramName);
        return data.min;
    }

    public double getMax() {
        HecDoubleParamData data = (HecDoubleParamData)HecDoubleParamData.hecParamDataTable.get(this.paramName);
        return data.max;
    }

    public double getRecMin() {
        HecDoubleParamData data = (HecDoubleParamData)HecDoubleParamData.hecParamDataTable.get(this.paramName);
        return data.recMin;
    }

    public double getRecMax() {
        HecDoubleParamData data = (HecDoubleParamData)HecDoubleParamData.hecParamDataTable.get(this.paramName);
        return data.recMax;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setValue(int v, String unitSystem, int unit) {
        this._value = v;
        this._unitSystem = unitSystem;
        this._unit = unit;
    }

    public void setValue(String s, int v, String unitSystem, int unit) {
        this.paramName = s;
        this._value = v;
        this._unitSystem = unitSystem;
        this._unit = unit;
    }

    public void setValue(int v) {
        this._value = v;
    }

    public void setUnit(int pu) {
        this._unit = pu;
    }

    public int getValue(String s) {
        int d = -1;
        if (s.equals(this._unitSystem)) {
            return this._value;
        }
        if (s.equals("ENGLISH")) {
            d = (int)((double)this._value / _factors[this._unit]);
        } else if (s.equals("SI")) {
            d = (int)((double)this._value * _factors[this._unit]);
        }
        return d;
    }

    public int getValue() {
        return this._value;
    }

    public String getUnitSystem() {
        return this._unitSystem;
    }

    public int getUnit() {
        return this._unit;
    }

    public String toString() {
        Object rs = "";
        rs = (String)rs + this._value + ", " + this._unitSystem + ", " + this._unit;
        return rs;
    }
}

