/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.util;

import hec.heclib.util.intContainer;
import hec.heclib.util.stringContainer;
import hec.lang.annotation.Scriptable;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Scriptable
public class HecTime
implements Serializable,
Comparable,
Cloneable {
    static final long serialVersionUID = -3231844709616794835L;
    public static final int SECOND_INCREMENT = 0;
    public static final int MINUTE_INCREMENT = 1;
    public static final int HOUR_INCREMENT = 2;
    public static final int DAY_INCREMENT = 3;
    public static final int SECOND_GRANULARITY = 10;
    public static final int MINUTE_GRANULARITY = 11;
    public static final int HOUR_GRANULARITY = 12;
    public static final int DAY_GRANULARITY = 13;
    public static final int UNDEFINED_VALUE = -2147483647;
    private static final int MIN_IN_1_HOUR = 60;
    private static final int MIN_IN_1_DAY = 1440;
    private static final int MIN_IN_7_DAYS = 10080;
    private static final int MIN_IN_10_DAYS = 14400;
    private static final int MIN_IN_15_DAYS = 21600;
    private static final int MIN_IN_30_DAYS = 43200;
    private static final int MIN_IN_YEAR = 525600;
    private static final int JULIAN_BASE_DATE = 693960;
    private static final String[] VALID_MONTHS = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private static final String[] LONG_MONTH_NAMES = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] DAY_NAMES = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static int[] _ymd = new int[3];
    protected int _julian = -2147483647;
    protected int _secondsSinceMidnight = -2147483647;
    protected int _baseGranularity = 1;
    protected boolean _showBeginning = false;
    protected int _defaultDateStyle = 2;
    private static final Pattern _slashDashPattern = Pattern.compile("[./-]");
    private static final Pattern _numericDatePattern = Pattern.compile("\\A[0-9]{1,2}[./-][0-9]{1,2}[./-]-?[0-9]{2,}\\z");
    private static final Pattern _endsWithNumPattern = Pattern.compile("[^0-9]-?[0-9]+\\z");
    private static final Pattern _oneMoreNumPattern = Pattern.compile("[0-9]+");
    private static final Pattern _numColonPattern = Pattern.compile("[^0-9\\:]");
    private static final Pattern _usgsDatePattern = Pattern.compile("\\A-?[0-9]{4,}[-][0-9]{2,2}[-][0-9]{2,2}\\z");
    private static final Pattern _strDateWithDashesPattern = Pattern.compile("\\A[0-9]{1,2}-[a-zA-Z]{3}--?[0-9]{2,}\\z");
    protected static DecimalFormat dfmt2 = new DecimalFormat("00");
    protected static DecimalFormat dfmt4 = new DecimalFormat("0000");

    public HecTime() {
    }

    public HecTime(int timeGranularity) {
        this._baseGranularity = timeGranularity;
    }

    public HecTime(int value, int timeGranularity) {
        this.setTimeIncrement(timeGranularity);
        this.set(value);
    }

    public HecTime(String date, String time) {
        this(date, time, 1);
    }

    public HecTime(String date, String time, int timeGranularity) {
        this._baseGranularity = timeGranularity;
        this.setDate(date);
        this.setTime(time);
    }

    public HecTime(String date) {
        this(date, 1);
    }

    public HecTime(String date, int timeGranularity) {
        this._baseGranularity = timeGranularity;
        this.set(date);
    }

    public HecTime(Date javaDate, int minutesTimezoneOffset) {
        this.set(javaDate, minutesTimezoneOffset);
    }

    public HecTime(Calendar cal) {
        this.set(cal);
    }

    public HecTime(HecTime hecTime) {
        this.set(hecTime);
    }

    public static HecTime fromZonedDateTime(ZonedDateTime zonedDateTime) {
        Instant instant = zonedDateTime.toInstant();
        ZoneId zoneId = zonedDateTime.getZone();
        return HecTime.fromInstant(instant, zoneId);
    }

    public static HecTime fromInstant(Instant instant, ZoneId zoneId) {
        HecTime hecTime = new HecTime();
        int offsetMinutes = (int)TimeUnit.SECONDS.toMinutes(zoneId.getRules().getOffset(instant).getTotalSeconds());
        hecTime.setTimeInMillis(instant.toEpochMilli(), offsetMinutes);
        return hecTime;
    }

    @Deprecated
    public static void setAlwaysShowTimeAsBeginningOfDay(boolean alwaysShowBeginningOfDay) {
    }

    @Deprecated
    public static boolean isAlwaysShowTimeAsBeginningOfDay() {
        return false;
    }

    @Scriptable
    public synchronized void setTimeGranularityInSeconds(int timeGranularityInSeconds) {
        if (timeGranularityInSeconds == 1) {
            this._baseGranularity = 10;
        } else if (timeGranularityInSeconds == 60) {
            this._baseGranularity = 11;
        } else if (timeGranularityInSeconds == 3600) {
            this._baseGranularity = 12;
        } else if (timeGranularityInSeconds == 86400) {
            this._baseGranularity = 13;
        }
    }

    @Scriptable
    public synchronized void setTimeGranularity(int baseGranularity) {
        this._baseGranularity = baseGranularity;
    }

    @Scriptable
    @Deprecated
    public synchronized void setTimeIncrement(int baseGranularity) {
        this.setTimeGranularity(baseGranularity);
    }

    @Scriptable
    public synchronized int getTimeGranularityInSeconds() {
        if (this._baseGranularity == 10) {
            return 1;
        }
        if (this._baseGranularity == 11) {
            return 60;
        }
        if (this._baseGranularity == 12) {
            return 3600;
        }
        if (this._baseGranularity == 13) {
            return 86400;
        }
        return 60;
    }

    @Scriptable
    public synchronized int getTimeGranularity() {
        return this._baseGranularity;
    }

    @Scriptable
    @Deprecated
    public synchronized int getTimeIncrement() {
        return this.getTimeGranularity();
    }

    @Scriptable
    public synchronized void set(int value) {
        if (value == -2147483647) {
            this.setUndefined();
            return;
        }
        intContainer hiSecondsSinceMidnight = new intContainer(this._secondsSinceMidnight);
        intContainer hiJulian = new intContainer(this._julian);
        this.getDaysSecs(value, this._baseGranularity, hiJulian, hiSecondsSinceMidnight);
        this._julian = hiJulian.value;
        if (this._baseGranularity == 0 || this._baseGranularity == 10) {
            this._julian += 25568;
        }
        this._secondsSinceMidnight = hiSecondsSinceMidnight.value;
        this.cleanTime();
    }

    public synchronized void set(int value, int julianBaseDate) {
        this.set(value);
        this._julian += julianBaseDate;
    }

    public synchronized void set(int value, int valueGranularitySeconds, int julianBaseDate) {
        int periodsInDay = 86400 / valueGranularitySeconds;
        int jdate = value / periodsInDay;
        this._secondsSinceMidnight = value - jdate * periodsInDay;
        this._secondsSinceMidnight *= valueGranularitySeconds;
        this._julian = julianBaseDate + jdate;
        this.setTimeGranularityInSeconds(valueGranularitySeconds);
        this.cleanTime();
    }

    public synchronized void setSeconds(long value) {
        intContainer hiSecondsSinceMidnight = new intContainer(this._secondsSinceMidnight);
        intContainer hiJulian = new intContainer(this._julian);
        this.getDaysSecs(value, this._baseGranularity, hiJulian, hiSecondsSinceMidnight);
        this._julian = hiJulian.value;
        if (this._baseGranularity == 0 || this._baseGranularity == 10) {
            this._julian += 25568;
        }
        this._secondsSinceMidnight = hiSecondsSinceMidnight.value;
        this.cleanTime();
    }

    @Scriptable
    public synchronized int set(String date, String time) {
        int retval = this.setDate(date);
        if (retval != 0) {
            return retval;
        }
        if (time.length() != 0) {
            retval = this.setTime(time);
        }
        return retval;
    }

    @Scriptable
    public synchronized int set(String dateAndTime) {
        int error;
        StringTokenizer parser;
        int numberTokens;
        if (dateAndTime == null) {
            this.setUndefined();
            return 0;
        }
        if ((dateAndTime = dateAndTime.toUpperCase().trim()).equals("Undefined")) {
            this.setUndefined();
            return 0;
        }
        if (this.setXML(dateAndTime) == 0) {
            return 0;
        }
        StringBuffer delim = new StringBuffer(" ,;");
        int loc = dateAndTime.lastIndexOf(":");
        if (loc > 0 && loc + 4 < dateAndTime.length()) {
            delim.append(":");
        }
        if ((numberTokens = (parser = new StringTokenizer(dateAndTime, delim.toString())).countTokens()) <= 1) {
            return this.setDate(dateAndTime);
        }
        String str1 = "";
        String str2 = "";
        if (numberTokens == 2) {
            str1 = new String(parser.nextToken());
            str2 = new String(parser.nextToken());
        } else {
            int idx;
            parser = new StringTokenizer(dateAndTime, " ,;");
            numberTokens = parser.countTokens();
            if (numberTokens == 3 && (error = this.setDate(dateAndTime)) == 0) {
                return error;
            }
            String[] parts = new String[numberTokens];
            for (int i = 0; i < numberTokens; ++i) {
                parts[i] = parser.nextToken();
            }
            if (dateAndTime.endsWith("M") && parts.length > 2) {
                idx = dateAndTime.lastIndexOf(parts[parts.length - 2]);
                str1 = dateAndTime.substring(0, idx - 1);
                str2 = dateAndTime.substring(idx);
            } else {
                idx = dateAndTime.lastIndexOf(parts[parts.length - 1]);
                str1 = dateAndTime.substring(0, idx - 1);
                str2 = dateAndTime.substring(idx);
            }
        }
        str1 = str1.trim();
        str2 = str2.trim();
        if (str1.endsWith(";")) {
            str1 = str1.substring(0, str1.length() - 1);
        }
        if (str1.endsWith(",")) {
            str1 = str1.substring(0, str1.length() - 1);
        }
        if (str2.endsWith(";")) {
            str2 = str2.substring(0, str2.length() - 1);
        }
        if (str2.endsWith(",")) {
            str2 = str2.substring(0, str2.length() - 1);
        }
        if (str1.length() >= str2.length()) {
            error = this.setDate(str1);
            if (error != 0) {
                return error;
            }
            error = this.setTime(str2);
        } else {
            error = this.setDate(str2);
            if (error != 0) {
                return error;
            }
            error = this.setTime(str1);
        }
        return error;
    }

    @Scriptable
    public synchronized void set(Date javaDate, int minutesTimezoneOffset) {
        if (javaDate == null) {
            this.setUndefined();
            return;
        }
        long milliseconds = javaDate.getTime();
        this.setTimeInMillis(milliseconds, minutesTimezoneOffset);
    }

    public synchronized void set(Calendar cal) {
        if (cal == null) {
            this.setUndefined();
            return;
        }
        Date jDate = cal.getTime();
        TimeZone tz = cal.getTimeZone();
        int offset = tz.getRawOffset() / 60000;
        if (tz.inDaylightTime(jDate)) {
            offset += tz.getDSTSavings() / 60000;
        }
        this.set(jDate, offset);
    }

    @Scriptable
    public synchronized void set(HecTime hecTime) {
        if (hecTime == null) {
            this.setUndefined();
            return;
        }
        this._julian = hecTime._julian;
        this._secondsSinceMidnight = hecTime._secondsSinceMidnight;
        this._baseGranularity = hecTime._baseGranularity;
        this._showBeginning = hecTime._showBeginning;
        this._defaultDateStyle = hecTime._defaultDateStyle;
    }

    @Scriptable
    public synchronized int setXML(String dateTime) {
        if (dateTime.equals("Undefined")) {
            this.setUndefined();
            return 0;
        }
        try {
            boolean isNegative;
            StringTokenizer strtok = new StringTokenizer(dateTime, "T");
            if (strtok.countTokens() != 2) {
                return -1;
            }
            String dateStr = strtok.nextToken();
            String timeStr = strtok.nextToken();
            Object tzStr = "GMT";
            if (timeStr.length() > 8) {
                tzStr = (String)tzStr + timeStr.substring(8);
                timeStr = timeStr.substring(0, 8);
            }
            if (isNegative = dateStr.startsWith("-")) {
                dateStr = dateStr.substring(1);
            }
            if ((strtok = new StringTokenizer(dateStr, "-")).countTokens() != 3) {
                return -1;
            }
            String valStr = strtok.nextToken();
            if (valStr.length() != 4) {
                return -1;
            }
            int yr = Integer.parseInt(valStr);
            if (isNegative) {
                yr = -yr;
            }
            if ((valStr = strtok.nextToken()).length() != 2) {
                return -1;
            }
            int mon = Integer.parseInt(valStr);
            valStr = strtok.nextToken();
            if (valStr.length() != 2) {
                return -1;
            }
            int day = Integer.parseInt(valStr);
            strtok = new StringTokenizer(timeStr, ":");
            if (strtok.countTokens() != 3) {
                return -1;
            }
            valStr = strtok.nextToken();
            if (valStr.length() != 2) {
                return -1;
            }
            int hr = Integer.parseInt(valStr);
            valStr = strtok.nextToken();
            if (valStr.length() != 2) {
                return -1;
            }
            int min = Integer.parseInt(valStr);
            valStr = strtok.nextToken();
            if (valStr.length() != 2) {
                return -1;
            }
            int sec = Integer.parseInt(valStr);
            if (tzStr == null || ((String)tzStr).equals("Z")) {
                tzStr = "GMT";
            }
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone((String)tzStr));
            calendar.set(yr, mon - 1, day, hr, min, sec);
            this.set(calendar.getTime(), 0);
            this.cleanTime();
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Scriptable
    public synchronized int setDate(String date) {
        int[] jul = new int[1];
        int stat = HecTime.datjul(date, jul);
        if (stat < 0) {
            this.setUndefined();
            return -1;
        }
        this._julian = jul[0];
        this.cleanTime();
        return 0;
    }

    @Scriptable
    public synchronized int setTime(String time) {
        time = time.trim().toUpperCase();
        boolean lpm = false;
        boolean lam = false;
        if (time.endsWith(".")) {
            time = time.substring(0, time.length() - 1);
        }
        if (time.endsWith("A.M")) {
            time = time.substring(0, time.length() - 3).trim();
            lam = true;
        } else if (time.endsWith("AM")) {
            time = time.substring(0, time.length() - 2).trim();
            lam = true;
        } else if (time.endsWith("A")) {
            time = time.substring(0, time.length() - 1).trim();
            lam = true;
        } else if (time.endsWith("P.M")) {
            time = time.substring(0, time.length() - 3).trim();
            lpm = true;
        } else if (time.endsWith("PM")) {
            time = time.substring(0, time.length() - 2).trim();
            lpm = true;
        } else if (time.endsWith("P")) {
            time = time.substring(0, time.length() - 1).trim();
            lpm = true;
        }
        int hour = 0;
        int minute = 0;
        int second = 0;
        boolean err = false;
        int colonIdx = time.indexOf(58);
        if (colonIdx == -1) {
            minute = HecTime.ihm2m(time);
            if (minute < 0) {
                err = true;
            }
        } else if (colonIdx == time.lastIndexOf(58)) {
            String stemp = time.substring(0, colonIdx);
            try {
                hour = Integer.valueOf(stemp);
            }
            catch (NumberFormatException e) {
                err = true;
            }
            stemp = time.substring(colonIdx + 1, time.length());
            try {
                minute = Integer.valueOf(stemp);
            }
            catch (NumberFormatException e) {
                err = true;
            }
        } else {
            String stemp = time.substring(0, colonIdx);
            try {
                hour = Integer.valueOf(stemp);
            }
            catch (NumberFormatException e) {
                err = true;
            }
            stemp = time.substring(colonIdx + 1, time.lastIndexOf(58));
            try {
                minute = Integer.valueOf(stemp);
            }
            catch (NumberFormatException e) {
                err = true;
            }
            stemp = time.substring(time.lastIndexOf(58) + 1, time.length()).trim();
            try {
                second = Integer.valueOf(stemp);
            }
            catch (NumberFormatException e) {
                err = true;
            }
        }
        if (err) {
            this.setUndefined();
            return -2;
        }
        if (lpm && hour < 12) {
            hour += 12;
        }
        if (lam && hour == 12) {
            hour = 0;
        }
        this._secondsSinceMidnight = hour * 3600 + minute * 60 + second;
        this._secondsSinceMidnight -= this._secondsSinceMidnight % this.secondsInIncrement();
        this.cleanTime();
        return 0;
    }

    @Scriptable
    public synchronized void setCurrent() {
        int[] julian = new int[1];
        int[] seconds = new int[1];
        HecTime.systim(julian, seconds);
        this._julian = julian[0];
        this._secondsSinceMidnight = seconds[0] - seconds[0] % this.secondsInIncrement();
        this.cleanTime();
    }

    @Scriptable
    public synchronized void setJulian(int julian) {
        this._julian = julian;
        this.cleanTime();
    }

    @Scriptable
    public synchronized void setYearMonthDay(int year, int month, int day, int minutesSinceMidnight) {
        int julian = HecTime.iymdjl(year, month, day);
        this.setJulian(julian, minutesSinceMidnight, 0);
    }

    @Scriptable
    public synchronized void setYearMonthDay(int year, int month, int day) {
        this._julian = HecTime.iymdjl(year, month, day);
    }

    @Scriptable
    public synchronized void setJulian(int julian, int minutesSinceMidnight) {
        this.setJulian(julian, minutesSinceMidnight, 0);
    }

    @Scriptable
    public synchronized void setJulian(int julian, int minutesSinceMidnight, int secondsSinceMinute) {
        this._julian = julian;
        this._secondsSinceMidnight = minutesSinceMidnight * 60 + secondsSinceMinute;
        this.cleanTime();
    }

    @Scriptable
    public synchronized void setTimeInMillis(long milliseconds) {
        this.setTimeInMillis(milliseconds, 0);
    }

    @Scriptable
    public synchronized void setTimeInMillis(long milliseconds, int minutesTimezoneOffset) {
        long seconds = (milliseconds += (long)(minutesTimezoneOffset * 60000)) / 1000L;
        long days = seconds / 86400L;
        this._julian = (int)days + 25568;
        this._secondsSinceMidnight = (int)(seconds - days * 86400L);
        this.cleanTime();
    }

    @Scriptable
    public synchronized void setUndefined() {
        this._julian = -2147483647;
        this._secondsSinceMidnight = -2147483647;
    }

    @Scriptable
    public synchronized boolean isDefined() {
        if (this._julian == -2147483647) {
            return false;
        }
        if (this._secondsSinceMidnight == -2147483647) {
            return this._baseGranularity == 13 || this._baseGranularity == 3;
        }
        return true;
    }

    public synchronized boolean isDateDefined() {
        return this._julian != -2147483647;
    }

    public synchronized boolean isTimeDefined() {
        return this._secondsSinceMidnight != -2147483647;
    }

    @Scriptable
    public synchronized void showTimeAsBeginningOfDay(boolean showBeginning) {
        this._showBeginning = showBeginning;
    }

    @Scriptable
    public synchronized boolean getShowsTimeAsBeginningOfDay() {
        return this._showBeginning;
    }

    @Scriptable
    public synchronized String date() {
        return this.date(this._defaultDateStyle);
    }

    @Scriptable
    public synchronized String date(int style) {
        if (this._julian == -2147483647 || style == -1000) {
            return "";
        }
        return HecTime.juldat(this.julian(), HecTime.normalizeDateStyle(style % 1000));
    }

    @Scriptable
    public synchronized Date getJavaDate(int minutesTimezoneOffset) {
        long milliseconds = this.isDefined() ? this.getTimeInMillis(minutesTimezoneOffset) : 0L;
        return new Date(milliseconds);
    }

    @Scriptable
    public synchronized String getXMLDateTime(int minutesTimezoneOffset) {
        if (!this.isDefined()) {
            return "";
        }
        Object tzStr = "Z";
        if (this.isTimeDefined() && minutesTimezoneOffset != 0) {
            int oldTimeIncrement = this.getTimeIncrement();
            this.setTimeIncrement(10);
            this.add(minutesTimezoneOffset * 60);
            this.setTimeIncrement(oldTimeIncrement);
            tzStr = dfmt2.format(minutesTimezoneOffset / 60) + ":" + dfmt2.format(Math.abs(minutesTimezoneOffset % 60));
            if (minutesTimezoneOffset > 0) {
                tzStr = "+" + (String)tzStr;
            }
        }
        boolean showBeginning = this.getShowsTimeAsBeginningOfDay();
        this.showTimeAsBeginningOfDay(true);
        Object xmlStr = "";
        if (this.isDateDefined()) {
            xmlStr = (String)xmlStr + dfmt4.format(this.year());
            xmlStr = (String)xmlStr + "-" + dfmt2.format(this.month());
            xmlStr = (String)xmlStr + "-" + dfmt2.format(this.day());
        }
        if (this.isTimeDefined()) {
            xmlStr = (String)xmlStr + "T" + dfmt2.format(this.hour());
            xmlStr = (String)xmlStr + ":" + dfmt2.format(this.minute());
            xmlStr = (String)xmlStr + ":" + dfmt2.format(this.second());
            xmlStr = (String)xmlStr + (String)tzStr;
        }
        this.showTimeAsBeginningOfDay(showBeginning);
        return xmlStr;
    }

    @Scriptable
    public synchronized long getTimeInMillis() {
        return this.getTimeInMillis(0);
    }

    @Scriptable
    public synchronized long getTimeInMillis(int minutesTimezoneOffset) {
        if (!this.isDefined()) {
            return 0L;
        }
        long juls = 0L;
        long secs = 0L;
        if (this.isDateDefined()) {
            juls = this.julian();
        }
        if (this.isTimeDefined()) {
            secs = this.secondsSinceMidnight();
        }
        long seconds = (juls - 25568L) * 86400L + secs;
        long milliseconds = (seconds -= (long)minutesTimezoneOffset * 60L) * 1000L;
        return milliseconds;
    }

    @Scriptable
    public synchronized long getTimeInMillis(Calendar cal) {
        if (!this.isDefined()) {
            return 0L;
        }
        cal.set(this.year(), this.month() - 1, this.day(), this.hour(), this.minute(), this.second());
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public synchronized Instant getInstant(ZoneId zoneId) {
        if (!this.isDefined()) {
            return this.getJavaDate(0).toInstant();
        }
        int hour = this.hour();
        if (hour == 24) {
            hour = 0;
            return LocalDateTime.of(this.year(), this.month(), this.day(), hour, this.minute(), this.second()).plusDays(1L).atZone(zoneId).toInstant();
        }
        return LocalDateTime.of(this.year(), this.month(), this.day(), hour, this.minute(), this.second()).atZone(zoneId).toInstant();
    }

    public synchronized LocalDateTime getLocalDateTime() {
        if (!this.isDefined()) {
            return this.getJavaDate(0).toInstant().atZone(ZoneId.of("UTC")).toLocalDateTime();
        }
        int hour = this.hour();
        if (hour == 24) {
            hour = 0;
            return LocalDateTime.of(this.year(), this.month(), this.day(), hour, this.minute(), this.second()).plusDays(1L);
        }
        return LocalDateTime.of(this.year(), this.month(), this.day(), hour, this.minute(), this.second());
    }

    @Scriptable
    public synchronized long getMinutes() {
        return this.getMinutes(0);
    }

    @Scriptable
    public synchronized long getMinutes(int minutesTimezoneOffset) {
        if (!this.isDefined()) {
            return 0L;
        }
        long juls = 0L;
        long secs = 0L;
        if (this.isDateDefined()) {
            juls = this._julian;
        }
        if (this.isTimeDefined()) {
            secs = this._secondsSinceMidnight;
        }
        long minutes = juls * 1440L + secs / 60L;
        return minutes -= (long)minutesTimezoneOffset;
    }

    @Scriptable
    public synchronized void setMinutes(long minutes) {
        this.setMinutes(minutes, 0);
    }

    @Scriptable
    public synchronized void setMinutes(double minutes) {
        this.setMinutes((long)minutes, 0);
    }

    @Scriptable
    public synchronized void setMinutes(long minutes, int minutesTimezoneOffset) {
        long seconds = (minutes += (long)minutesTimezoneOffset) * 60L;
        long days = seconds / 86400L;
        this._julian = (int)days;
        this._secondsSinceMidnight = (int)(seconds - days * 86400L);
        this.cleanTime();
    }

    @Scriptable
    public synchronized String getTime(boolean withColons) {
        if (!this.isTimeDefined() || this._baseGranularity == 13 || this._baseGranularity == 3) {
            return "";
        }
        int secs = this.secondsSinceMidnight();
        int hr = secs / 3600;
        StringBuffer ctime = new StringBuffer();
        ctime.append(dfmt2.format(hr));
        if (withColons) {
            ctime.append(":");
        }
        if (this._baseGranularity == 12) {
            ctime.append("00");
        } else {
            int min = (secs - hr * 3600) / 60;
            ctime.append(dfmt2.format(min));
            if (this._baseGranularity == 0 || this._baseGranularity == 10 && withColons) {
                ctime.append(":");
                int sec = secs % 60;
                ctime.append(dfmt2.format(sec));
            }
        }
        return ctime.toString();
    }

    @Scriptable
    public synchronized String time() {
        return this.getTime(true);
    }

    @Scriptable
    public synchronized String dateAndTime() {
        return this.dateAndTime(this._defaultDateStyle);
    }

    @Scriptable
    public synchronized String dateAndTime(int style) {
        if (this._baseGranularity == 13 || this._baseGranularity == 3) {
            return this.date(style);
        }
        if (style >= 1000 || !this.isTimeDefined()) {
            return this.date(style);
        }
        if (style == -1000 || !this.isDateDefined()) {
            return this.time();
        }
        return this.date(style) + ", " + this.time();
    }

    @Scriptable
    public synchronized String hourMinutes() {
        return this.getTime(false);
    }

    @Scriptable
    public synchronized int julian() {
        if (this._secondsSinceMidnight == 86400 && this._showBeginning) {
            return this._julian + 1;
        }
        return this._julian;
    }

    @Scriptable
    public synchronized int secondsSinceMidnight() {
        if (!this.isTimeDefined() || this._secondsSinceMidnight == 86400 && this._showBeginning) {
            return 0;
        }
        return this._secondsSinceMidnight;
    }

    @Scriptable
    public synchronized int minutesSinceMidnight() {
        if (this.isTimeDefined()) {
            return this.secondsSinceMidnight() / 60;
        }
        return -2147483647;
    }

    @Scriptable
    public int hoursMinutesSeconds(intContainer hiHours, intContainer hiMinutes, intContainer hiSeconds) {
        if (hiHours != null) {
            hiHours.value = 0;
        }
        if (hiMinutes != null) {
            hiMinutes.value = 0;
        }
        if (hiSeconds != null) {
            hiSeconds.value = 0;
        }
        if (!this.isTimeDefined()) {
            return -1;
        }
        int hr = 0;
        int min = 0;
        int secsSinceMidnight = this.secondsSinceMidnight();
        hr = secsSinceMidnight / 3600;
        min = (secsSinceMidnight - hr * 3600) / 60;
        if (this._baseGranularity < 10) {
            if (this._baseGranularity == 0 && hiSeconds != null) {
                hiSeconds.value = secsSinceMidnight % 60;
            }
            if (hiMinutes != null) {
                hiMinutes.value = min;
            }
            if (hiHours != null) {
                hiHours.value = hr;
            }
        } else {
            switch (this._baseGranularity) {
                case 10: {
                    if (hiSeconds != null) {
                        hiSeconds.value = secsSinceMidnight % 60;
                    }
                }
                case 11: {
                    if (hiMinutes != null) {
                        hiMinutes.value = min;
                    }
                }
                case 12: {
                    if (hiHours != null) {
                        hiHours.value = hr;
                    }
                }
                case 13: {
                    return 0;
                }
            }
        }
        return 0;
    }

    @Scriptable
    public synchronized int yearMonthDay(intContainer hiYear, intContainer hiMonth, intContainer hiDay) {
        if (!this.isDateDefined()) {
            if (hiYear != null) {
                hiYear.value = -1;
            }
            if (hiMonth != null) {
                hiMonth.value = -1;
            }
            if (hiDay != null) {
                hiDay.value = -1;
            }
            return -1;
        }
        int[] ymd = new int[3];
        HecTime.jliymd(this.julian(), ymd);
        if (hiYear != null) {
            hiYear.value = ymd[0];
        }
        if (hiMonth != null) {
            hiMonth.value = ymd[1];
        }
        if (hiDay != null) {
            hiDay.value = ymd[2];
        }
        return 0;
    }

    @Scriptable
    public synchronized int isoDate() {
        if (!this.isDateDefined()) {
            return -1;
        }
        intContainer ic1 = new intContainer();
        intContainer ic2 = new intContainer();
        intContainer ic3 = new intContainer();
        this.yearMonthDay(ic1, ic2, ic3);
        return ic1.value * 10000 + ic2.value * 100 + ic3.value;
    }

    @Scriptable
    public synchronized int isoTime() {
        if (!this.isTimeDefined()) {
            return -1;
        }
        intContainer ic1 = new intContainer();
        intContainer ic2 = new intContainer();
        intContainer ic3 = new intContainer();
        this.hoursMinutesSeconds(ic1, ic2, ic3);
        return ic1.value * 10000 + ic2.value * 100 + ic3.value;
    }

    @Scriptable
    public synchronized int year() {
        intContainer iyr = new intContainer();
        this.yearMonthDay(iyr, null, null);
        return iyr.value;
    }

    @Scriptable
    public synchronized int month() {
        intContainer ic2 = new intContainer();
        this.yearMonthDay(null, ic2, null);
        return ic2.value;
    }

    @Scriptable
    public synchronized int day() {
        intContainer ic = new intContainer();
        this.yearMonthDay(null, null, ic);
        return ic.value;
    }

    @Scriptable
    public synchronized int hour() {
        intContainer ihr = new intContainer();
        this.hoursMinutesSeconds(ihr, null, null);
        return ihr.value;
    }

    @Scriptable
    public synchronized int minute() {
        intContainer ic2 = new intContainer();
        this.hoursMinutesSeconds(null, ic2, null);
        return ic2.value;
    }

    @Scriptable
    public synchronized int second() {
        intContainer ic = new intContainer();
        this.hoursMinutesSeconds(null, null, ic);
        return ic.value;
    }

    @Scriptable
    public synchronized int dayOfYear() {
        if (!this.isDateDefined()) {
            return -1;
        }
        int iyear = this.year();
        int julian = HecTime.iymdjl(iyear, 1, 1);
        return this.julian() - julian + 1;
    }

    @Scriptable
    public synchronized int dayOfWeek() {
        if (!this.isDateDefined()) {
            return -1;
        }
        return HecTime.idaywk(this.julian());
    }

    @Scriptable
    public synchronized String dayOfWeekName() {
        int iday = this.dayOfWeek();
        if (iday > 0) {
            return DAY_NAMES[--iday];
        }
        return "";
    }

    @Scriptable
    public synchronized void setDefaultDateStyle(int defaultDateStyle) {
        this._defaultDateStyle = defaultDateStyle;
    }

    public int getDefaultDateStyle() {
        return this._defaultDateStyle;
    }

    @Scriptable
    public synchronized String toString() {
        return this.dateAndTime(this._defaultDateStyle);
    }

    @Scriptable
    public synchronized String toString(int dateStyle) {
        return this.dateAndTime(dateStyle);
    }

    @Scriptable
    @Deprecated
    public synchronized int timeIncrement() {
        return this._baseGranularity;
    }

    public synchronized int timeGranularity() {
        return this._baseGranularity;
    }

    @Scriptable
    public synchronized int value() {
        int days = this.julian();
        int secs = this.secondsSinceMidnight();
        if (!this.isDefined()) {
            if (this.isDateDefined()) {
                secs = 86400;
            } else if (this.isTimeDefined()) {
                days = 0;
            } else {
                return -2147483647;
            }
        }
        if (this._baseGranularity == 0 || this._baseGranularity == 10) {
            days -= 25568;
        }
        int secsInIncrement = this.secondsInIncrement();
        int incrementsInDay = 86400 / secsInIncrement;
        return days * incrementsInDay + secs / secsInIncrement;
    }

    public static void convertTimeZone(HecTime hecTime, TimeZone fromTimeZone, TimeZone toTimeZone) {
        HecTime.convertTimeZone(hecTime, fromTimeZone, toTimeZone, true);
    }

    public static void convertTimeZone(HecTime hecTime, TimeZone fromTimeZone, TimeZone toTimeZone, boolean respectDST) {
        if (fromTimeZone == null || toTimeZone == null) {
            return;
        }
        if (respectDST && !fromTimeZone.useDaylightTime() && !toTimeZone.useDaylightTime()) {
            respectDST = false;
        }
        int minutesFromTimeZoneOffset = (int)((long)fromTimeZone.getRawOffset() / 60000L);
        int minutesToZoneOffset = (int)((long)toTimeZone.getRawOffset() / 60000L);
        if (respectDST) {
            Date jDate;
            if (fromTimeZone.useDaylightTime()) {
                jDate = hecTime.getJavaDate(minutesFromTimeZoneOffset + 60);
                boolean inDST = fromTimeZone.inDaylightTime(jDate);
                if (!inDST) {
                    jDate = hecTime.getJavaDate(minutesFromTimeZoneOffset);
                }
            } else {
                jDate = hecTime.getJavaDate(minutesFromTimeZoneOffset);
            }
            boolean viewInDST = toTimeZone.inDaylightTime(jDate);
            if (viewInDST) {
                minutesToZoneOffset += 60;
            }
            if (hecTime.timeGranularity() == 0 || hecTime.timeGranularity() == 10) {
                int isecs = hecTime.second();
                hecTime.set(jDate, minutesToZoneOffset);
                hecTime.addSeconds(isecs);
            } else {
                hecTime.set(jDate, minutesToZoneOffset);
            }
        } else {
            int diff = minutesToZoneOffset - minutesFromTimeZoneOffset;
            hecTime.addMinutes(diff);
        }
    }

    public static HecTime convertToTimeZone(int minsSince1900, TimeZone fromTimeZone, TimeZone toTimeZone) {
        HecTime hTime = new HecTime();
        hTime.set(minsSince1900);
        HecTime.convertTimeZone(hTime, fromTimeZone, toTimeZone);
        return hTime;
    }

    public static HecTime convertToTimeZone(HecTime hecTime, TimeZone fromTimeZone, TimeZone toTimeZone) {
        HecTime hTime = new HecTime(hecTime);
        HecTime.convertTimeZone(hTime, fromTimeZone, toTimeZone);
        return hTime;
    }

    @Scriptable
    public synchronized void add(int time) {
        if (!this.isDefined()) {
            return;
        }
        intContainer juls = new intContainer();
        intContainer secs = new intContainer();
        this.getDaysSecs(time, this._baseGranularity, juls, secs);
        this._julian += juls.value;
        this._secondsSinceMidnight += secs.value;
        this.cleanTime();
    }

    public synchronized void addSeconds(int seconds) {
        if (!this.isDefined()) {
            return;
        }
        intContainer juls = new intContainer();
        intContainer secs = new intContainer();
        this.getDaysSecs(seconds, 10, juls, secs);
        this._julian += juls.value;
        this._secondsSinceMidnight += secs.value;
        this.cleanTime();
    }

    public synchronized void addMinutes(int minutes) {
        if (!this.isDefined()) {
            return;
        }
        intContainer juls = new intContainer();
        intContainer secs = new intContainer();
        this.getDaysSecs(minutes, 11, juls, secs);
        this._julian += juls.value;
        this._secondsSinceMidnight += secs.value;
        this.cleanTime();
    }

    public synchronized void addHours(int hours) {
        if (!this.isDefined()) {
            return;
        }
        intContainer juls = new intContainer();
        intContainer secs = new intContainer();
        this.getDaysSecs(hours, 12, juls, secs);
        this._julian += juls.value;
        this._secondsSinceMidnight += secs.value;
        this.cleanTime();
    }

    public synchronized void addDays(int days) {
        if (!this.isDateDefined()) {
            return;
        }
        intContainer juls = new intContainer();
        intContainer secs = new intContainer();
        this.getDaysSecs(days, 13, juls, secs);
        this._julian += juls.value;
        this._secondsSinceMidnight += secs.value;
        this.cleanTime();
    }

    @Scriptable
    public synchronized void add(HecTime time) {
        if (!this.isDefined() || !time.isDefined()) {
            return;
        }
        int julian = this._julian + time.julian();
        int seconds = this._secondsSinceMidnight + time.secondsSinceMidnight();
        this.setJulian(julian, 0, seconds);
    }

    @Scriptable
    public synchronized void subtract(HecTime time) {
        if (!this.isDefined() || !time.isDefined()) {
            return;
        }
        int julian = this._julian - time.julian();
        int seconds = this._secondsSinceMidnight - time.secondsSinceMidnight();
        this.setJulian(julian, 0, seconds);
    }

    @Scriptable
    public synchronized boolean equalTo(HecTime time) {
        return this.compareTimes(time) == 0;
    }

    @Scriptable
    public synchronized boolean notEqualTo(HecTime time) {
        return this.compareTimes(time) != 0;
    }

    @Scriptable
    public synchronized boolean greaterThan(HecTime time) {
        return this.compareTimes(time) > 0;
    }

    @Scriptable
    public synchronized boolean greaterThanEqualTo(HecTime time) {
        return this.compareTimes(time) >= 0;
    }

    @Scriptable
    public synchronized boolean lessThan(HecTime time) {
        return this.compareTimes(time) < 0;
    }

    @Scriptable
    public synchronized boolean lessThanEqualTo(HecTime time) {
        return this.compareTimes(time) <= 0;
    }

    @Scriptable
    public synchronized int compareTimes(HecTime time) {
        int valB;
        int[] timeArray;
        if (this.isDefined()) {
            if (time == null || !time.isDefined()) {
                return 1;
            }
        } else {
            if (time != null && time.isDefined()) {
                return -1;
            }
            return 0;
        }
        int julLocal = this.julian();
        int secondsLocal = this.secondsSinceMidnight();
        int julRemote = time.julian();
        int secondsRemote = time.secondsSinceMidnight();
        if (secondsLocal <= 0 || secondsLocal > 86400) {
            timeArray = new int[]{julLocal, secondsLocal};
            this.cleanTime(timeArray);
            julLocal = timeArray[0];
            secondsLocal = timeArray[1];
        }
        if (secondsRemote <= 0 || secondsRemote > 86400) {
            timeArray = new int[]{julRemote, secondsRemote};
            this.cleanTime(timeArray);
            julRemote = timeArray[0];
            secondsRemote = timeArray[1];
        }
        if (julLocal < julRemote) {
            return -1;
        }
        if (julLocal > julRemote) {
            return 1;
        }
        if (this._baseGranularity == time.timeGranularity()) {
            if (secondsLocal < secondsRemote) {
                return -1;
            }
            if (secondsLocal > secondsRemote) {
                return 1;
            }
            return 0;
        }
        int largerIncrement = Math.max(this._baseGranularity, time.timeGranularity());
        int secsInIncrement = this.secondsInIncrement(largerIncrement);
        int valA = secondsLocal / secsInIncrement;
        if (valA < (valB = secondsRemote / secsInIncrement)) {
            return -1;
        }
        if (valA > valB) {
            return 1;
        }
        return 0;
    }

    @Scriptable
    public synchronized void increment(int numberPeriods, int minutesInPeriod) {
        if (!this.isDefined()) {
            return;
        }
        int[] jul = new int[1];
        int[] min = new int[1];
        HecTime.inctim(minutesInPeriod, numberPeriods, this.julian(), this.minutesSinceMidnight(), jul, min);
        this.setJulian(jul[0], min[0], this.second());
    }

    public synchronized void incrementSecs(int numberPeriods, int secondsInPeriod) {
        if (secondsInPeriod >= 60) {
            int minutesInPeriod = secondsInPeriod / 60;
            this.increment(numberPeriods, minutesInPeriod);
            return;
        }
        int secsChange = numberPeriods * secondsInPeriod;
        this._secondsSinceMidnight += secsChange;
        this.cleanTime();
    }

    @Scriptable
    public synchronized int computeNumberIntervals(HecTime otherTime, int intervalInMins) {
        if (!this.isDefined() || !otherTime.isDefined()) {
            return 0;
        }
        int numberIntervals = HecTime.nopers(intervalInMins, this.julian(), this.minutesSinceMidnight(), otherTime.julian(), otherTime.minutesSinceMidnight());
        return numberIntervals;
    }

    public synchronized int computeNumberIntervalsSecs(HecTime otherTime, int intervalInSecs) {
        int numberIntervals;
        if (!this.isDefined() || !otherTime.isDefined()) {
            return 0;
        }
        if (intervalInSecs >= 86400) {
            int intervalInMins = intervalInSecs / 60;
            numberIntervals = HecTime.nopers(intervalInMins, this.julian(), this.minutesSinceMidnight(), otherTime.julian(), otherTime.minutesSinceMidnight());
        } else {
            long days = otherTime.julian() - this.julian();
            long secs = otherTime.secondsSinceMidnight() - this.secondsSinceMidnight();
            numberIntervals = (int)((days * 86400L + secs) / (long)intervalInSecs);
        }
        return numberIntervals;
    }

    public static int computeNumberIntervals(int startTimeMins, int endTimeMins, int intervalInMins) {
        int numberIntervals;
        boolean negativeInterval = false;
        if (intervalInMins == 0) {
            return 0;
        }
        if (intervalInMins < 0) {
            negativeInterval = true;
            int n = Math.abs(intervalInMins);
        }
        if (intervalInMins <= 1440) {
            numberIntervals = (endTimeMins - startTimeMins) / intervalInMins;
        } else {
            numberIntervals = 0;
            int startJulian = startTimeMins / 1440;
            int startMins = startTimeMins - startJulian * 1440;
            int endJulian = endTimeMins / 1440;
            int endMins = endTimeMins - endJulian * 1440;
            numberIntervals = HecTime.nopers(intervalInMins, startJulian, startMins, endJulian, endMins);
        }
        if (negativeInterval) {
            numberIntervals = -numberIntervals;
        }
        return numberIntervals;
    }

    @Scriptable
    public synchronized void subtract(int time) {
        if (!this.isDefined()) {
            return;
        }
        intContainer juls = new intContainer();
        intContainer secs = new intContainer();
        this.getDaysSecs(time, this._baseGranularity, juls, secs);
        this._julian -= juls.value;
        this._secondsSinceMidnight -= secs.value;
        this.cleanTime();
    }

    public synchronized void subtractSeconds(int seconds) {
        if (!this.isTimeDefined()) {
            return;
        }
        intContainer juls = new intContainer();
        intContainer secs = new intContainer();
        this.getDaysSecs(seconds, 10, juls, secs);
        this._julian -= juls.value;
        this._secondsSinceMidnight -= secs.value;
        this.cleanTime();
    }

    public synchronized void subtractMinutes(int minutes) {
        if (!this.isTimeDefined()) {
            return;
        }
        intContainer juls = new intContainer();
        intContainer secs = new intContainer();
        this.getDaysSecs(minutes, 11, juls, secs);
        this._julian -= juls.value;
        this._secondsSinceMidnight -= secs.value;
        this.cleanTime();
    }

    public synchronized void subtractHours(int hours) {
        if (!this.isTimeDefined()) {
            return;
        }
        intContainer juls = new intContainer();
        intContainer secs = new intContainer();
        this.getDaysSecs(hours, 12, juls, secs);
        this._julian -= juls.value;
        this._secondsSinceMidnight -= secs.value;
        this.cleanTime();
    }

    public synchronized void subtractDays(int days) {
        if (!this.isDateDefined()) {
            return;
        }
        intContainer juls = new intContainer();
        intContainer secs = new intContainer();
        this.getDaysSecs(days, 13, juls, secs);
        this._julian -= juls.value;
        this._secondsSinceMidnight -= secs.value;
        this.cleanTime();
    }

    private synchronized int secondsInIncrement() {
        return this.secondsInIncrement(this._baseGranularity);
    }

    private synchronized int secondsInIncrement(int timeGranularity) {
        switch (timeGranularity) {
            case 3: {
                return 86400;
            }
            case 2: {
                return 3600;
            }
            case 1: {
                return 60;
            }
            case 0: {
                return 1;
            }
            case 13: {
                return 86400;
            }
            case 12: {
                return 3600;
            }
            case 11: {
                return 60;
            }
            case 10: {
                return 1;
            }
        }
        return -1;
    }

    public synchronized void cleanTime() {
        if (this._secondsSinceMidnight == -2147483647 || this._julian == -2147483647) {
            return;
        }
        if (Math.abs(this._secondsSinceMidnight) > 86400) {
            this._julian += this._secondsSinceMidnight / 86400;
            this._secondsSinceMidnight %= 86400;
        }
        if (this._secondsSinceMidnight < 1) {
            --this._julian;
            this._secondsSinceMidnight += 86400;
        }
        int secInc = this.secondsInIncrement(this._baseGranularity);
        int inc = this._secondsSinceMidnight / secInc;
        this._secondsSinceMidnight = inc * secInc;
        if ((this._baseGranularity == 13 || this._baseGranularity == 3) && this._secondsSinceMidnight > 86400) {
            ++this._julian;
            this._secondsSinceMidnight -= 86400;
        }
    }

    protected synchronized void cleanTime(int[] times) {
        if (Math.abs(times[1]) > 86400) {
            times[0] = times[0] + times[1] / 86400;
            times[1] = times[1] % 86400;
        }
        if (times[1] < 1) {
            times[0] = times[0] - 1;
            times[1] = times[1] + 86400;
        }
    }

    private synchronized void getDaysSecs(long time, int timeGranularity, intContainer hiJulian, intContainer hiSecondsSinceMidnight) {
        int secsInIncrement = this.secondsInIncrement(timeGranularity);
        int incrementsInDay = 86400 / secsInIncrement;
        hiJulian.value = (int)(time / (long)incrementsInDay);
        hiSecondsSinceMidnight.value = (int)((time - (long)hiJulian.value * (long)incrementsInDay) * (long)secsInIncrement);
        if (hiSecondsSinceMidnight.value < 1 && hiSecondsSinceMidnight.value != 0 && timeGranularity != 13) {
            --hiJulian.value;
            hiSecondsSinceMidnight.value += 86400;
        }
    }

    @Scriptable
    public synchronized int getIntervalOffset(int intervalMinutes) {
        if (!this.isDefined() || intervalMinutes <= 0) {
            return -1;
        }
        int[] julian = new int[1];
        int[] minutes = new int[1];
        int[] ioffset = new int[1];
        int zero = 0;
        julian[0] = this.julian();
        minutes[0] = this.minutesSinceMidnight();
        HecTime.zofset(julian, minutes, intervalMinutes, zero, ioffset);
        return ioffset[0];
    }

    @Scriptable
    public synchronized void adjustToIntervalOffset(int intervalMinutes, int offset) {
        if (!this.isDefined() || intervalMinutes < 0) {
            return;
        }
        int[] julian = new int[1];
        int[] minutes = new int[1];
        int[] ioffset = new int[1];
        int two = 2;
        julian[0] = this.julian();
        minutes[0] = this.minutesSinceMidnight();
        ioffset[0] = offset;
        HecTime.zofset(julian, minutes, intervalMinutes, two, ioffset);
        this.setJulian(julian[0], minutes[0]);
    }

    @Scriptable
    public static int getTimeWindow(String userLine, HecTime startTime, HecTime endTime) {
        int[] juls = new int[1];
        int[] istime = new int[1];
        int[] jule = new int[1];
        int[] ietime = new int[1];
        int[] status = new int[1];
        juls[0] = startTime.julian();
        istime[0] = startTime.minutesSinceMidnight();
        jule[0] = endTime.julian();
        ietime[0] = endTime.minutesSinceMidnight();
        Object line = userLine;
        int i = ((String)line).indexOf(";");
        if (i > 0 && i < ((String)line).length()) {
            line = userLine.substring(0, i) + " " + userLine.substring(i + 1);
        }
        HecTime.getime((String)line, juls, istime, jule, ietime, status);
        if (status[0] == 0) {
            startTime.setJulian(juls[0], istime[0]);
            endTime.setJulian(jule[0], ietime[0]);
        } else {
            startTime.setUndefined();
            endTime.setUndefined();
        }
        return status[0];
    }

    public static void getime(String line, int[] juls, int[] istime, int[] jule, int[] ietime, int[] status) {
        HecTime.getime(line, juls, istime, jule, ietime, null, status);
    }

    public static void getime(String line, int[] juls, int[] istime, int[] jule, int[] ietime, String tzId, int[] status) {
        if (line == null) {
            throw new RuntimeException("Parameter line is null");
        }
        if (juls == null || juls.length == 0) {
            throw new RuntimeException("Parameter juls is null or zero-length");
        }
        if (istime == null || istime.length == 0) {
            throw new RuntimeException("Parameter istime is null or zero-length");
        }
        if (jule == null || jule.length == 0) {
            throw new RuntimeException("Parameter jule is null or zero-length");
        }
        if (ietime == null || ietime.length == 0) {
            throw new RuntimeException("Parameter ietime is null or zero-length");
        }
        if (status == null || status.length == 0) {
            throw new RuntimeException("Parameter status is null or zero-length");
        }
        int[] iDummy = new int[]{0};
        int[] jul = new int[1];
        boolean isStartDate = false;
        boolean isStartTime = false;
        boolean isStart = false;
        boolean isEndDate = false;
        boolean isCurTime = false;
        boolean isEndField = false;
        boolean isError = false;
        status[0] = 0;
        String locStartEndTime = line.trim().toUpperCase();
        locStartEndTime = locStartEndTime.replaceAll("\\s+", " ");
        locStartEndTime = locStartEndTime.replaceAll(", ", ",");
        locStartEndTime = locStartEndTime.replaceAll(" ", ",");
        int strLength = locStartEndTime.length();
        String[] parsedLine = locStartEndTime.split("[,]");
        int parsedFields = parsedLine.length;
        if (strLength != 0) {
            for (int i = 0; i < parsedFields; ++i) {
                boolean isDate = false;
                if (parsedLine[i].length() == 0) continue;
                isStart = i == 0 || i == 1 && parsedFields > 2;
                if (Pattern.matches("^[BDEST].*", parsedLine[i])) {
                    if (Pattern.matches("^T.*", parsedLine[i])) {
                        isCurTime = true;
                        if (i == 0) {
                            HecTime.systim(juls, istime, true, tzId);
                            isStartDate = true;
                            isStartTime = true;
                        } else {
                            HecTime.systim(jule, ietime, true, tzId);
                            isEndDate = true;
                        }
                    } else if (Pattern.matches("^D.*", parsedLine[i])) {
                        isCurTime = true;
                        if (!isStartDate) {
                            HecTime.systim(juls, iDummy, true, tzId);
                            isStartDate = true;
                        } else {
                            HecTime.systim(jule, iDummy, true, tzId);
                            isEndDate = true;
                        }
                    } else if (Pattern.matches("^[BS].*", parsedLine[i])) {
                        jule[0] = juls[0];
                        ietime[0] = istime[0];
                        isEndDate = true;
                        isStart = false;
                    } else {
                        if (i != 0) {
                            isError = true;
                            break;
                        }
                        if (parsedFields == 1) {
                            if (jule[0] <= 0) {
                                isError = true;
                                break;
                            }
                            juls[0] = jule[0];
                            istime[0] = ietime[0];
                            isStartDate = true;
                            isStartTime = true;
                        } else {
                            isEndField = true;
                            continue;
                        }
                    }
                    iDummy[0] = parsedLine[i].length();
                    if (iDummy[0] == 1) continue;
                    parsedLine[i] = parsedLine[i].substring(1);
                }
                for (int j = 0; j < VALID_MONTHS.length; ++j) {
                    if (!Pattern.matches(".*(" + VALID_MONTHS[j] + ").*", parsedLine[i])) continue;
                    isDate = true;
                    break;
                }
                if (isDate || Pattern.matches(".*/.*", parsedLine[i])) {
                    if (HecTime.datjul(parsedLine[i], jul) == -1) {
                        isError = true;
                        break;
                    }
                    if (!isStartDate) {
                        juls[0] = jul[0];
                        isStartDate = true;
                        continue;
                    }
                    if (!isEndDate) {
                        jule[0] = jul[0];
                        isEndDate = true;
                        continue;
                    }
                    isError = true;
                    break;
                }
                if (Pattern.matches("[0-9:]{1,5}", parsedLine[i])) {
                    iDummy[0] = HecTime.ihm2m(parsedLine[i]);
                    if (iDummy[0] < 0) {
                        isError = true;
                        break;
                    }
                    if (!isStartTime) {
                        istime[0] = iDummy[0];
                        isStartTime = true;
                        continue;
                    }
                    if (i == 1 && isCurTime) {
                        istime[0] = iDummy[0];
                        isStartTime = true;
                        continue;
                    }
                    ietime[0] = iDummy[0];
                    continue;
                }
                if (Pattern.matches(".*[YMDH]$", parsedLine[i])) {
                    char charInterval = parsedLine[i].charAt(parsedLine[i].length() - 1);
                    int interval = charInterval == 'Y' ? 525600 : (charInterval == 'M' ? 43200 : (charInterval == 'D' ? 1440 : 60));
                    if (parsedLine[i].startsWith("+")) {
                        parsedLine[i] = parsedLine[i].substring(1);
                    }
                    iDummy[0] = parsedLine[i].length();
                    if (iDummy[0] <= 1) {
                        isError = true;
                        break;
                    }
                    iDummy[0] = Integer.parseInt(parsedLine[i].substring(0, iDummy[0] - 1));
                    if (isStart) {
                        HecTime.inctim(interval, iDummy[0], juls[0], istime[0], juls, istime);
                        continue;
                    }
                    HecTime.inctim(interval, iDummy[0], jule[0], ietime[0], jule, ietime);
                    continue;
                }
                isError = true;
                break;
            }
            if (isEndField) {
                int[] statusEndField = new int[1];
                HecTime.getime(parsedLine[0], juls, istime, jule, ietime, statusEndField);
                if (statusEndField[0] < 0) {
                    isError = true;
                }
            }
            if (!isError) {
                return;
            }
        }
        status[0] = -1;
        juls[0] = -2147483647;
        jule[0] = -2147483647;
        istime[0] = -1;
        ietime[0] = -1;
    }

    public static int idaywk(int jul) {
        return jul % 7 + 1;
    }

    public static int jliymd(int jul, intContainer year, intContainer month, intContainer day) {
        int[] ymd = new int[3];
        int errorCode = HecTime.jliymd(jul, ymd);
        year.value = ymd[0];
        month.value = ymd[1];
        day.value = ymd[2];
        return errorCode;
    }

    public static int jliymd(int jul, int[] ymd) {
        int jul2;
        int julc = jul + 693960;
        int iyr = (int)((double)julc / 365.2425);
        boolean found = false;
        for (int i = 0; i < 20; ++i) {
            int jul22 = HecTime.iymdjl(iyr, 1, 1);
            if (jul22 > jul) {
                found = true;
                break;
            }
            ++iyr;
        }
        if (!found) {
            return -1;
        }
        int julb = HecTime.iymdjl(--iyr, 1, 1);
        int ja = Math.min(12, (jul - julb + 28) / 28);
        found = false;
        int imon = ja;
        for (int i = ja; i <= 12; ++i) {
            jul2 = HecTime.iymdjl(iyr, i, 1);
            if (jul2 <= jul) continue;
            imon = i;
            found = true;
            break;
        }
        if (found) {
            --imon;
        }
        if (imon <= 0) {
            int iyear = imon / 12 - 1;
            imon += -iyear * 12;
            iyr += iyear;
        }
        jul2 = HecTime.iymdjl(iyr, imon, 1);
        int iday = jul - jul2 + 1;
        ymd[0] = iyr;
        ymd[1] = imon;
        ymd[2] = iday;
        return 0;
    }

    public static int iymdjl(int intYear, int intMonth, int intDay) {
        int numberOfLeapDays;
        int[] NDAY = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        if (intMonth < 1 || intMonth > 12) {
            int iyears = intMonth / 12;
            intYear += iyears;
            if ((intMonth -= iyears * 12) < 1) {
                --intYear;
                intMonth += 12;
            }
        }
        if (intYear > 4) {
            int intYear_1 = intYear - 1;
            numberOfLeapDays = intYear_1 / 4 + intYear_1 / 400 - intYear_1 / 100;
        } else if (intYear > 0) {
            numberOfLeapDays = 1;
        } else {
            int intYear_1 = intYear + 1;
            numberOfLeapDays = intYear_1 / 4 + intYear_1 / 400 - intYear_1 / 100;
        }
        int leapCheck = 0;
        if (HecTime.isLeap(intYear)) {
            if (intYear >= 0) {
                if (intMonth > 2) {
                    leapCheck = 1;
                }
            } else if (intMonth < 3) {
                leapCheck = -1;
            }
        }
        if (intMonth < 1 || intMonth > 12) {
            return -2147483647;
        }
        return intYear * 365 + numberOfLeapDays + NDAY[intMonth - 1] + intDay + leapCheck - 693960;
    }

    public static int yearMonthDayToJulian(int year, int month, int day) {
        int numberOfLeapDays;
        int[] NDAY = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        if (month < 1 || month > 12) {
            int iyears = month / 12;
            year += iyears;
            if ((month -= iyears * 12) < 1) {
                --year;
                month += 12;
            }
        }
        if (year > -1) {
            int intYear_1 = year - 1;
            numberOfLeapDays = intYear_1 / 4 + intYear_1 / 400 - intYear_1 / 100;
        } else {
            int intYear_1 = year + 1;
            numberOfLeapDays = intYear_1 / 4 + intYear_1 / 400 - intYear_1 / 100;
        }
        int leapCheck = 0;
        if (HecTime.isLeap(year)) {
            if (year >= 0) {
                if (month > 2) {
                    leapCheck = 1;
                }
            } else if (month > 2) {
                leapCheck = -1;
            }
        }
        if (month < 1 || month > 12) {
            return -2147483647;
        }
        return year * 365 + numberOfLeapDays + NDAY[month - 1] + day + leapCheck - 693960;
    }

    public static int julianToYearMonthDay(int julian, intContainer year, intContainer month, intContainer day) {
        int imonth;
        int jula;
        int iyear;
        block12: {
            int i;
            block11: {
                int julc = julian + 693960;
                iyear = (int)((double)julc / 365.2425);
                boolean found = false;
                if (iyear > 0) {
                    for (i = 0; i < 100; ++i) {
                        jula = HecTime.yearMonthDayToJulian(iyear, 1, 1);
                        if (jula > julian) {
                            found = true;
                            break;
                        }
                        ++iyear;
                    }
                    if (!found) {
                        return -1;
                    }
                    --iyear;
                } else {
                    for (i = 0; i < 100; ++i) {
                        jula = HecTime.yearMonthDayToJulian(iyear, 1, 1);
                        if (julian >= jula) {
                            found = true;
                            break;
                        }
                        --iyear;
                    }
                    if (!found) {
                        return -1;
                    }
                }
                if (iyear <= -1) break block11;
                int julb = HecTime.yearMonthDayToJulian(iyear, 1, 1);
                int juld = Math.min(12, (julian - julb + 28) / 28);
                found = false;
                imonth = juld;
                for (i = juld; i <= 12; ++i) {
                    jula = HecTime.yearMonthDayToJulian(iyear, i, 1);
                    if (jula <= julian) continue;
                    imonth = i;
                    found = true;
                    break;
                }
                if (!found) break block12;
                --imonth;
                break block12;
            }
            imonth = 0;
            for (i = 12; i >= 0; --i) {
                jula = HecTime.yearMonthDayToJulian(iyear, i, 1);
                if (julian < jula) continue;
                imonth = i;
                break;
            }
        }
        if (imonth <= 0 || imonth > 12) {
            int iyr = imonth / 12 - 1;
            imonth += -iyr * 12;
            iyear += iyr;
        }
        jula = HecTime.yearMonthDayToJulian(iyear, imonth, 1);
        int iday = julian - jula + 1;
        year.value = iyear;
        month.value = imonth;
        day.value = iday;
        return 0;
    }

    public static int addCentury(int intYear) {
        if (intYear <= 100) {
            int currentYear = Calendar.getInstance().get(1);
            int intCurrentCentury = currentYear - currentYear % 100;
            if ((intYear += intCurrentCentury) > currentYear + 10) {
                intYear -= 100;
            } else if (intYear < currentYear - 90) {
                intYear += 100;
            }
            return intYear;
        }
        return -1;
    }

    public static boolean isLeap(int year) {
        boolean logic = false;
        if (year % 400 == 0 || year % 4 == 0 && year % 100 != 0) {
            logic = true;
        }
        return logic;
    }

    public static int maxDay(int year, int month) {
        switch (month) {
            case 2: {
                return HecTime.isLeap(year) ? 29 : 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    public static int datjul(String charDate, int[] julian) {
        int[] ymd = new int[3];
        int errorCode = HecTime.datymd(charDate, ymd);
        if (errorCode == 0) {
            julian[0] = HecTime.iymdjl(ymd[0], ymd[1], ymd[2]);
            return 0;
        }
        julian[0] = -2147483647;
        return -1;
    }

    public static void datjul(String charDate, intContainer julian, intContainer errorCode) {
        int[] jul = new int[1];
        errorCode.value = HecTime.datjul(charDate, jul);
        julian.value = jul[0];
    }

    public static String juldat(int julian, int style) {
        int[] ymd = new int[3];
        int[] iErr = new int[1];
        int i = HecTime.jliymd(julian, ymd);
        return HecTime.ymddat(ymd, style, iErr);
    }

    public static String ymddat(int[] ymd, int style, int[] err) {
        int k;
        String[] month = LONG_MONTH_NAMES;
        DecimalFormat fm2 = new DecimalFormat("00");
        DecimalFormat fm4 = new DecimalFormat("0000");
        if (ymd[1] < 1 || ymd[1] > 12 || ymd[2] < 1 || ymd[2] > 31) {
            err[0] = -1;
            return null;
        }
        err[0] = 0;
        int year = ymd[0];
        if ((style = HecTime.normalizeDateStyle(style)) < 0) {
            String charMonth;
            String charDay;
            String charYear;
            if (style == -13) {
                String charDay2 = fm2.format(ymd[2]);
                String charMonth2 = fm2.format(ymd[1]);
                String charYear2 = fm4.format(ymd[0]);
                String charDate = charYear2 + "-" + charMonth2 + "-" + charDay2;
                return charDate;
            }
            if (style < -100) {
                charYear = fm4.format(year);
                style += 100;
            } else {
                if (year > 100) {
                    year %= 100;
                }
                charYear = fm2.format(year);
            }
            String delimiter = style == -2 || style == -12 ? "-" : "/";
            if (style < -10) {
                charDay = fm2.format(ymd[2]);
                charMonth = fm2.format(ymd[1]);
            } else {
                charDay = Integer.toString(ymd[2]);
                charMonth = Integer.toString(ymd[1]);
            }
            String charDate = charMonth + delimiter + charDay + delimiter + charYear;
            return charDate;
        }
        int jstyle = style;
        int ibstyl = jstyle % 10;
        Object charMonth = month[ymd[1] - 1];
        if (jstyle >= 100) {
            charMonth = ((String)charMonth).toUpperCase();
            jstyle -= 100;
        }
        charMonth = ibstyl > 6 || ibstyl == 1 ? ((String)charMonth).substring(0, 3) + " " : (ibstyl >= 4 ? ((String)charMonth).substring(0, 3) : (String)charMonth + " ");
        String charYear = fm4.format(year);
        if (jstyle >= 10) {
            charYear = charYear.substring(2, 4);
        }
        Object charDay = (k = ibstyl % 3) == 1 && ibstyl > 1 ? fm2.format(ymd[2]) : (k == 2 || ibstyl <= 1 ? Integer.toString(ymd[2]) : "");
        if (ibstyl == 2 || ibstyl == 7 || ibstyl == 8) {
            charDay = (String)charDay + " ";
        }
        String charDate = ibstyl > 1 ? (k != 0 ? (String)charDay + (String)charMonth + charYear : (String)charMonth + (String)charDay + charYear) : (String)charMonth + (String)charDay + ", " + charYear;
        return charDate;
    }

    public static synchronized void datymd(String charDate, intContainer year, intContainer month, intContainer day, intContainer errorCode) {
        HecTime._ymd[0] = year.value;
        HecTime._ymd[1] = month.value;
        HecTime._ymd[2] = day.value;
        errorCode.value = HecTime.datymd(charDate, _ymd);
        year.value = _ymd[0];
        month.value = _ymd[1];
        day.value = _ymd[2];
    }

    public static int datymd(String charDate, int[] ymd) {
        Matcher m;
        int yearLength = 0;
        Object locCharDate = charDate.trim();
        int strLength = ((String)(locCharDate = ((String)locCharDate).replaceAll("\\s+", ""))).length();
        if (strLength > 16 || strLength < 3) {
            return -1;
        }
        if (_slashDashPattern.matcher((CharSequence)locCharDate).find()) {
            if (_usgsDatePattern.matcher((CharSequence)locCharDate).find()) {
                if (((String)locCharDate).startsWith("-")) {
                    locCharDate = "~" + ((String)locCharDate).substring(1);
                }
                String[] fields = _slashDashPattern.split((CharSequence)locCharDate);
                ymd[0] = Integer.parseInt(fields[0].replace("~", "-"));
                ymd[1] = Integer.parseInt(fields[1]);
                if (ymd[1] < 1 || ymd[1] > 12) {
                    return -1;
                }
                ymd[2] = Integer.parseInt(fields[2]);
                if (ymd[2] < 1 || ymd[2] > 31) {
                    return -1;
                }
                return 0;
            }
            if (_numericDatePattern.matcher((CharSequence)locCharDate).find()) {
                if (((String)locCharDate).startsWith("-")) {
                    System.out.println(((String)locCharDate).replaceAll("(^|[./-])-", "$1~"));
                }
                String[] fields = _slashDashPattern.split(((String)locCharDate).replaceAll("(^|[./-])-", "$1~"));
                for (int i = 0; i < fields.length; ++i) {
                    fields[i] = fields[i].replace('~', '-');
                }
                ymd[1] = Integer.parseInt(fields[0]);
                if (ymd[1] < 1 || ymd[1] > 12) {
                    return -1;
                }
                ymd[2] = Integer.parseInt(fields[1]);
                if (ymd[2] < 1 || ymd[2] > 31) {
                    return -1;
                }
                yearLength = fields[2].length();
                ymd[0] = yearLength == 2 ? HecTime.addCentury(Integer.parseInt(fields[2])) : Integer.parseInt(fields[2]);
                return 0;
            }
            if (_strDateWithDashesPattern.matcher((CharSequence)locCharDate).find()) {
                String[] fields = _slashDashPattern.split((CharSequence)locCharDate);
                ymd[1] = Integer.parseInt(fields[2]);
                String mon = fields[1].toUpperCase();
                for (int i = 0; i < 12; ++i) {
                    if (mon.indexOf(VALID_MONTHS[i]) >= 0) {
                        ymd[1] = i + 1;
                        break;
                    }
                    if (i != 11) continue;
                    return -1;
                }
                ymd[2] = Integer.parseInt(fields[0]);
                if (ymd[2] < 1 || ymd[2] > 31) {
                    return -1;
                }
                yearLength = fields[2].length();
                ymd[0] = yearLength == 2 ? HecTime.addCentury(Integer.parseInt(fields[2])) : Integer.parseInt(fields[2]);
                return 0;
            }
        }
        if ((m = _endsWithNumPattern.matcher((CharSequence)locCharDate)).find()) {
            yearLength = m.end() - m.start() - 1;
            strLength = m.start() + 1;
            String s = ((String)locCharDate).substring(strLength, m.end());
            ymd[0] = Integer.parseInt(s);
            if (yearLength == 2) {
                ymd[0] = ymd[0] + 2000;
            }
            if (((String)locCharDate).charAt(strLength - 1) == ':') {
                return -1;
            }
        } else {
            ymd[0] = Calendar.getInstance().get(1);
        }
        ymd[2] = (m = _oneMoreNumPattern.matcher(((String)locCharDate).substring(0, strLength))).find() ? Integer.parseInt(((String)locCharDate).substring(m.start(), m.end())) : 1;
        if (ymd[2] < 1 || ymd[2] > 31) {
            return -1;
        }
        locCharDate = ((String)locCharDate).toUpperCase();
        for (int i = 0; i < 12; ++i) {
            if (((String)locCharDate).indexOf(VALID_MONTHS[i]) >= 0) {
                ymd[1] = i + 1;
                break;
            }
            if (i != 11) continue;
            return -1;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int ihm2m(String time) {
        String tempTime = time.replaceAll("\\s+", "");
        int len = tempTime.length();
        Matcher m = _numColonPattern.matcher(tempTime);
        if (m.find() || len == 0) {
            return -1;
        }
        int hour = 0;
        int minute = 0;
        if (tempTime.indexOf(":") >= 0) {
            String[] fields = tempTime.split(":");
            if (fields.length == 1) {
                hour = Integer.parseInt(fields[0]);
                minute = 0;
            } else {
                if (fields.length != 2) return -1;
                try {
                    hour = Integer.parseInt(fields[0]);
                }
                catch (NumberFormatException e) {
                    hour = 0;
                }
                minute = Integer.parseInt(fields[1]);
            }
        } else {
            if (len > 4) {
                return -1;
            }
            if (len <= 2) {
                hour = 0;
                minute = Integer.parseInt(tempTime);
            } else {
                hour = Integer.parseInt(tempTime.substring(0, len - 2));
                minute = Integer.parseInt(tempTime.substring(len - 2));
            }
        }
        if (hour <= 24 && minute <= 59 && (hour != 24 || minute <= 0)) return hour * 60 + minute;
        return -1;
    }

    public static int inctim(int interval, int unitFlag, int numPeriods, int startJulian, int startTime, intContainer endJulian, intContainer endTime) {
        int[] jul = new int[1];
        int[] min = new int[1];
        if (unitFlag == 1) {
            interval *= 1440;
        }
        HecTime.inctim(interval, numPeriods, startJulian, startTime, jul, min);
        endJulian.value = jul[0];
        endTime.value = min[0];
        return 0;
    }

    public static void inctim(int interval, int numPeriods, int startJulian, int startTime, int[] endJulian, int[] endTime) {
        int time;
        int julian;
        if (endJulian == null || endJulian.length == 0) {
            throw new RuntimeException("Parameter endJulian is null or zero-length");
        }
        if (endTime == null || endTime.length == 0) {
            throw new RuntimeException("Parameter endTime is null or zero-length");
        }
        int[] iymd = new int[3];
        int[] jymd = new int[3];
        int periodsPerYear = 0;
        int daysPerPeriod = 0;
        if (interval == 14400) {
            periodsPerYear = 36;
            daysPerPeriod = 10;
        } else if (interval == 21600) {
            periodsPerYear = 24;
            daysPerPeriod = 15;
        } else if (interval >= 40000 && interval < 45000) {
            periodsPerYear = 12;
        } else if (interval > 520000 && interval < 530000) {
            periodsPerYear = 1;
        }
        if (periodsPerYear == 0) {
            if (interval % 1440 == 0) {
                julian = startJulian + interval / 1440 * numPeriods;
                time = startTime;
            } else {
                int numDays = numPeriods * interval / 1440;
                julian = startJulian + numDays;
                time = startTime + numPeriods * interval - numDays * 1440;
            }
            HecTime.datcln(julian, time, endJulian, endTime);
            time = endTime[0];
            julian = endJulian[0];
        } else {
            boolean isEndOfMonth;
            time = startTime;
            HecTime.jliymd(startJulian, iymd);
            int jjul = startJulian + 1;
            HecTime.jliymd(jjul, jymd);
            int offset = 0;
            if (iymd[1] != jymd[1]) {
                isEndOfMonth = true;
            } else {
                isEndOfMonth = false;
                if (periodsPerYear >= 24) {
                    offset = iymd[2] % daysPerPeriod;
                }
                if (jymd[1] == 2 && jymd[2] == 29 && interval >= 1440) {
                    isEndOfMonth = true;
                }
            }
            jymd[0] = numPeriods / periodsPerYear;
            iymd[0] = iymd[0] + jymd[0];
            int leftOver = 0;
            if (periodsPerYear >= 12) {
                jymd[1] = 12 * numPeriods / periodsPerYear - jymd[0] * 12;
                iymd[1] = iymd[1] + jymd[1];
                if (periodsPerYear > 12 && (leftOver = numPeriods - jymd[1] * periodsPerYear / 12 - jymd[0] * periodsPerYear) < 0) {
                    leftOver += periodsPerYear / 12;
                    iymd[1] = iymd[1] - 1;
                }
            }
            while (true) {
                if (iymd[1] > 12) {
                    iymd[0] = iymd[0] + 1;
                    iymd[1] = iymd[1] - 12;
                    continue;
                }
                if (iymd[1] >= 1) break;
                iymd[0] = iymd[0] - 1;
                iymd[1] = iymd[1] + 12;
            }
            if (periodsPerYear <= 12) {
                if (isEndOfMonth) {
                    iymd[1] = iymd[1] + 1;
                    julian = HecTime.iymdjl(iymd[0], iymd[1], 1) - 1;
                } else {
                    julian = HecTime.iymdjl(iymd[0], iymd[1], iymd[2]);
                }
            } else if (leftOver == 0) {
                if (isEndOfMonth) {
                    iymd[1] = iymd[1] + 1;
                    julian = HecTime.iymdjl(iymd[0], iymd[1], 1) - 1;
                } else {
                    julian = HecTime.iymdjl(iymd[0], iymd[1], iymd[2]);
                }
            } else {
                for (int i = 1; i <= leftOver; ++i) {
                    int numDayMon = HecTime.iymdjl(iymd[0], iymd[1] + 1, 1) - HecTime.iymdjl(iymd[0], iymd[1], 1);
                    if (numDayMon > 30) {
                        numDayMon = 30;
                    }
                    iymd[2] = iymd[2] + daysPerPeriod;
                    if (iymd[2] < numDayMon) continue;
                    iymd[1] = iymd[1] + 1;
                    julian = HecTime.iymdjl(iymd[0], iymd[1], 1) - 1 + offset;
                    if (iymd[2] > 32 && offset == 0) {
                        julian += daysPerPeriod;
                    }
                    HecTime.jliymd(julian, iymd);
                    if (iymd[2] < numDayMon || i == leftOver) continue;
                    iymd[2] = 0;
                    iymd[1] = iymd[1] + 1;
                }
                julian = HecTime.iymdjl(iymd[0], iymd[1], iymd[2]);
            }
        }
        if (time == 0) {
            time = 1440;
        }
        endJulian[0] = --julian;
        endTime[0] = time;
    }

    public static void datcln(int julianIn, int timeIn, int[] julianOut, int[] timeOut) {
        if (timeIn > 1440) {
            julianOut[0] = julianIn + timeIn / 1440;
            timeOut[0] = timeIn % 1440;
        } else if (timeIn < 0) {
            julianOut[0] = julianIn + timeIn / 1440 - 1;
            timeOut[0] = timeIn % 1440 + 1440;
        } else {
            julianOut[0] = julianIn;
            timeOut[0] = timeIn;
        }
        if (timeOut[0] == 0) {
            julianOut[0] = julianOut[0] - 1;
            timeOut[0] = 1440;
        }
    }

    public static void zofset(int[] julian, int[] iTime, int interval, int iFlag, int[] iOffset) {
        int[] jul = new int[1];
        int[] jTime = new int[1];
        int[] iymd = new int[3];
        int[] jymd = new int[3];
        int jOffset = -1;
        HecTime.datcln(julian[0], iTime[0], jul, jTime);
        if (interval <= 1440) {
            jOffset = jTime[0] - interval * (jTime[0] / interval);
        } else if (interval == 10080) {
            jOffset = (HecTime.idaywk(jul[0]) - 1) * 1440 + jTime[0];
            if (jOffset == 10080) {
                jOffset = 0;
            }
        } else {
            HecTime.jliymd(jul[0], iymd);
            HecTime.jliymd(jul[0] + 1, jymd);
            if (jymd[2] == 1 && jTime[0] == 1440) {
                jOffset = 0;
            } else if (interval == 14400) {
                if (iymd[2] >= 30) {
                    iymd[2] = 9;
                }
                jOffset = (iymd[2] % 10 - 1) * 1440 + jTime[0];
            } else if (interval == 21600) {
                if (iymd[2] >= 30) {
                    iymd[2] = 14;
                }
                jOffset = (iymd[2] % 15 - 1) * 1440 + jTime[0];
            } else if (interval == 43200 && (jOffset = (iymd[2] - 1) * 1440 + jTime[0]) > 43200) {
                jOffset = 43200 - (1440 - jTime[0]);
            }
        }
        if (interval == 525600) {
            jOffset = jymd[2] == 1 && jymd[1] == 1 && jTime[0] == 1440 ? 0 : (jul[0] - HecTime.iymdjl(iymd[0], 1, 1)) * 1440 + jTime[0];
        }
        if (jOffset == -1) {
            iOffset[0] = -1;
            return;
        }
        if (iFlag >= 1 && jOffset != 0) {
            if (interval <= 10080) {
                HecTime.datcln(jul[0], jTime[0] + interval - jOffset, julian, iTime);
            } else {
                jTime[0] = 2400;
                iymd[2] = interval == 14400 ? (iymd[2] <= 10 ? 10 : (iymd[2] <= 20 ? 20 : 28)) : (interval == 21600 ? (iymd[2] <= 15 ? 15 : 28) : 28);
                if (interval == 525600) {
                    iymd[1] = 12;
                }
                julian[0] = iymd[2] >= 25 ? HecTime.iymdjl(iymd[0], iymd[1] + 1, 1) - 1 : HecTime.iymdjl(iymd[0], iymd[1], iymd[2]);
                iTime[0] = 1440;
            }
        }
        if (iFlag == 2 && iOffset[0] != 0) {
            if (iOffset[0] > interval) {
                iOffset[0] = -1;
                return;
            }
            if (iOffset[0] < 0) {
                iOffset[0] = -1;
                return;
            }
            HecTime.inctim(interval, -1, julian[0], iTime[0], jul, jTime);
            HecTime.datcln(jul[0], jTime[0] + iOffset[0], julian, iTime);
        }
        if (iFlag != 2) {
            iOffset[0] = jOffset;
        }
    }

    public static int nopers(int interval, int startJulian, int startTime, int endJulian, int endTime) {
        int[] startYmd = new int[3];
        int[] endYmd = new int[3];
        if (interval > 14000) {
            int dummyVariable = HecTime.jliymd(startJulian, startYmd);
            int n = HecTime.jliymd(endJulian, endYmd);
        }
        if (interval == 14400) {
            return (endYmd[0] - startYmd[0]) * 36 + (endYmd[1] - startYmd[1]) * 3 + (endYmd[2] - startYmd[2]) / 8;
        }
        if (interval == 21600) {
            return (endYmd[0] - startYmd[0]) * 24 + (endYmd[1] - startYmd[1]) * 2 + (endYmd[2] - startYmd[2]) / 13;
        }
        if (interval > 40000 && interval < 45000) {
            return (endYmd[0] - startYmd[0]) * 12 + (endYmd[1] - startYmd[1]) + (endYmd[2] - startYmd[2]) / 27;
        }
        if (interval > 520000 && interval < 530000) {
            return endYmd[0] - startYmd[0] + (endYmd[1] - startYmd[1] + (endYmd[2] - startYmd[2]) / 28) / 12;
        }
        int days = endJulian - startJulian;
        int minutes = endTime - startTime;
        return (days * 1440 + minutes) / interval;
    }

    public static int nopers(int interval, int unitFlag, int startJulian, int startTime, int endJulian, int endTime) {
        if (unitFlag == 1) {
            interval *= 1440;
        }
        if (interval == 0) {
            return 0;
        }
        return HecTime.nopers(interval, startJulian, startTime, endJulian, endTime);
    }

    public static void systim(int[] julian, int[] time, boolean useMinutes, String tzId) {
        if (julian == null || julian.length == 0) {
            throw new RuntimeException("Parameter julian is null or zero-length");
        }
        if (time == null || time.length == 0) {
            throw new RuntimeException("Parameter time is null or zero-length");
        }
        ZonedDateTime now = ZonedDateTime.now(tzId == null ? ZoneId.systemDefault() : ZoneId.of(tzId));
        julian[0] = HecTime.iymdjl(now.getYear(), now.getMonthValue(), now.getDayOfMonth());
        time[0] = useMinutes ? now.getHour() * 60 + now.getMinute() : now.getHour() * 3600 + now.getMinute() * 60 + now.getSecond();
    }

    public static void systim(int[] julian, int[] seconds) {
        HecTime.systim(julian, seconds, false, null);
    }

    public static void curtim(int[] julian, int[] minutes) {
        HecTime.systim(julian, minutes, true, null);
    }

    public static int m2ihm(int minutes, stringContainer hourMinutes) {
        if (hourMinutes == null) {
            throw new RuntimeException("Parameter hourMinutes is null");
        }
        if (minutes >= 0 && minutes <= 1440) {
            hourMinutes.string = String.format("%02d%02d", minutes / 60, minutes % 60);
            return Integer.valueOf(hourMinutes.toString());
        }
        hourMinutes.string = "*********";
        return -1;
    }

    public static int ihm2m_2(String hourMinutes) {
        if (hourMinutes == null || hourMinutes.trim().length() == 0) {
            return -1;
        }
        StringBuilder sb = new StringBuilder();
        for (char c2 : hourMinutes.toCharArray()) {
            if (!Character.isDigit(c2)) continue;
            sb.append(c2);
        }
        if (sb.length() == 0) {
            return 0;
        }
        int intVal = Integer.valueOf(sb.toString());
        return 60 * (intVal / 100) + intVal % 100;
    }

    public static int normalizeDateStyle(int style) {
        int validStyle;
        switch (style) {
            case -112: 
            case -111: 
            case -102: 
            case -101: 
            case -13: 
            case -12: 
            case -11: {
                validStyle = style;
                break;
            }
            default: {
                validStyle = style >= -2 && style <= 19 || style >= 100 && style <= 119 ? style : (style < 0 ? (style < -10 ? -11 : -1) : (style < 100 ? 10 + style % 10 : 110 + style % 10));
            }
        }
        return validStyle;
    }

    public int compareTo(Object o) {
        HecTime other = (HecTime)o;
        return this.compareTimes(other);
    }

    public Object clone() {
        HecTime htime = null;
        try {
            htime = (HecTime)super.clone();
            htime._julian = this._julian;
            htime._secondsSinceMidnight = this._secondsSinceMidnight;
            htime._baseGranularity = this._baseGranularity;
            htime._showBeginning = this._showBeginning;
            htime._defaultDateStyle = this._defaultDateStyle;
        }
        catch (Exception ex) {
            return null;
        }
        return htime;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("USAGE: " + HecTime.class.getName() + " [s|m|h|d] value");
            System.err.println("\twhere: [s|m|h|d] represent the time granularity");
            System.err.println("\twhere: value is the return of HecTime value()");
            System.exit(1);
        }
        HecTime time = new HecTime();
        if (args[0].toLowerCase().startsWith("s")) {
            time.setTimeGranularity(0);
        } else if (args[0].toLowerCase().startsWith("m")) {
            time.setTimeGranularity(1);
        } else if (args[0].toLowerCase().startsWith("h")) {
            time.setTimeGranularity(2);
        } else if (args[0].toLowerCase().startsWith("d")) {
            time.setTimeGranularity(3);
        }
        for (int i = 1; i < args.length; ++i) {
            time.set(Integer.parseInt(args[i]));
            System.out.println("main:(" + args[i] + ") Time is " + time.dateAndTime());
        }
        System.exit(0);
    }
}

