/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.util;

import hec.heclib.util.HecTime;
import hec.heclib.util.intContainer;
import java.io.Serializable;
import java.util.TimeZone;

public class HecTimeArray
implements Serializable {
    protected HecTime[] _times;
    protected int _numberElements;
    protected TimeZone _timeZone = null;
    protected TimeZone _viewTimeZone;
    protected boolean _showTimeAsBeginningOfDay;
    protected static TimeZone _globalViewTimeZone = null;

    public HecTimeArray() {
        this._times = null;
        this._numberElements = 0;
        this._viewTimeZone = _globalViewTimeZone;
    }

    public HecTimeArray(int numberElements) {
        this._viewTimeZone = _globalViewTimeZone;
        this.setSize(numberElements);
    }

    public HecTimeArray(int[] times) {
        this._viewTimeZone = _globalViewTimeZone;
        this.set(times);
    }

    public HecTimeArray(int[] times, TimeZone timezone) {
        this._viewTimeZone = _globalViewTimeZone;
        this.set(times, timezone);
    }

    public HecTimeArray(HecTimeArray copyFrom) {
        this._numberElements = copyFrom.numberElements();
        if (this._numberElements > 0) {
            this._times = new HecTime[this._numberElements];
            for (int i = 0; i < this._numberElements; ++i) {
                this._times[i] = new HecTime(copyFrom.elementAt(i));
            }
        } else {
            this._times = null;
        }
        this.setTimeZone(copyFrom.getTimeZone());
        this.setViewTimeZone(copyFrom.getViewTimeZone());
    }

    public static void setGlobalViewTimeZone(TimeZone globalViewTimeZone) {
        _globalViewTimeZone = globalViewTimeZone;
    }

    public static TimeZone getGlobalViewTimeZone() {
        return _globalViewTimeZone;
    }

    public void showTimeAsBeginningOfDay(boolean showTimeAsBeginningOfDay) {
        this._showTimeAsBeginningOfDay = showTimeAsBeginningOfDay;
    }

    public HecTime getTzUnconverted(int elementNumber) {
        return this.elementAt(elementNumber);
    }

    @Deprecated
    public HecTime elementAt(int elementNumber) {
        return this.getTimeInDataTimeZone(elementNumber);
    }

    public HecTime getTimeInDataTimeZone(int elementNumber) {
        if (elementNumber >= 0 && elementNumber < this._numberElements) {
            HecTime hTime = this._times[elementNumber];
            hTime.showTimeAsBeginningOfDay(this._showTimeAsBeginningOfDay);
            return hTime;
        }
        return new HecTime();
    }

    public int set(int[] times, TimeZone timezone) {
        int istat = this.set(times);
        if (istat != 0) {
            return istat;
        }
        this._timeZone = (TimeZone)timezone.clone();
        return istat;
    }

    public boolean convertTimezone(TimeZone toTimeZone, boolean observeDST) {
        if (this._timeZone == null) {
            return false;
        }
        for (int i = 0; i < this._times.length; ++i) {
            HecTime.convertTimeZone(this._times[i], this._timeZone, toTimeZone, observeDST);
        }
        return true;
    }

    @Deprecated
    public HecTime getTzConverted(int elementNumber) {
        return this.element(elementNumber);
    }

    @Deprecated
    public HecTime element(int elementNumber) {
        return this.getTimeInViewTimeZone(elementNumber);
    }

    public HecTime getTimeInViewTimeZone(int elementNumber) {
        if (elementNumber >= 0 && elementNumber < this._times.length) {
            HecTime obj = this._times[elementNumber];
            if (obj != null && obj instanceof HecTime) {
                HecTime hTime = obj;
                hTime.showTimeAsBeginningOfDay(this._showTimeAsBeginningOfDay);
                if (this._timeZone == null || this._viewTimeZone == null) {
                    return hTime;
                }
                hTime = HecTime.convertToTimeZone(hTime, this._timeZone, this._viewTimeZone);
                hTime.showTimeAsBeginningOfDay(this._showTimeAsBeginningOfDay);
                return hTime;
            }
        } else if (elementNumber >= 0 && elementNumber < this._numberElements + 1000) {
            this.resize(elementNumber + 1);
            return this._times[elementNumber];
        }
        HecTime badValue = new HecTime();
        badValue.setUndefined();
        return badValue;
    }

    public void setTzUnconverted(int elementNumber, HecTime value) {
        this.setElementAt(value, elementNumber);
    }

    public void setTzUnconverted(int elementNumber, String dateAndTime) {
        this.setElementAt(new HecTime(dateAndTime), elementNumber);
    }

    public int setTzConverted(int elementNumber, HecTime value) {
        return this.set(elementNumber, value);
    }

    public int setTzConverted(int elementNumber, String dateAndTime) {
        return this.set(elementNumber, new HecTime(dateAndTime));
    }

    public int set(int elementNumber, HecTime value) {
        HecTime hTime;
        if (elementNumber < 0 || elementNumber > this._numberElements) {
            return -1;
        }
        if (this._timeZone == null || this._viewTimeZone == null) {
            this._times[elementNumber] = new HecTime(value);
            return 0;
        }
        this._times[elementNumber] = hTime = HecTime.convertToTimeZone(value, this._viewTimeZone, this._timeZone);
        return 0;
    }

    public int set(int elementNumber, String dateAndTime) {
        if (elementNumber < 0 || elementNumber > this._numberElements) {
            return -1;
        }
        return this.set(elementNumber, new HecTime(dateAndTime));
    }

    public void setElementAt(HecTime time, int index) {
        if (index > this._numberElements - 1) {
            this.resize(index + 1, 0);
        }
        this._times[index] = time;
    }

    public void setElementAt(String dateAndTime, int index) {
        if (index > this._numberElements - 1) {
            this.resize(index + 1, 0);
        }
        this._times[index] = new HecTime(dateAndTime);
    }

    public int set(HecTimeArray array) {
        if (array.numberElements() < 1) {
            this._numberElements = 0;
            this._times = null;
            return -1;
        }
        this._numberElements = array.numberElements();
        this._times = array.timeArray();
        this._timeZone = array.getTimeZone();
        this._viewTimeZone = array.getViewTimeZone();
        return 0;
    }

    public int set(int[] timeArray, int timeGranularitySeconds, int julianBaseDate) {
        if (timeArray.length < 1) {
            this._numberElements = 0;
            this._times = null;
            return -1;
        }
        this.setSize(timeArray.length);
        for (int i = 0; i < this._numberElements; ++i) {
            this._times[i].set(timeArray[i], timeGranularitySeconds, julianBaseDate);
        }
        return 0;
    }

    public int set(int[] timeArray, int julianBaseDate) {
        int status = this.set(timeArray);
        if (julianBaseDate != 0) {
            for (int i = 0; i < this._numberElements; ++i) {
                this._times[i].addDays(julianBaseDate);
            }
        }
        return status;
    }

    public int set(int[] timeArray) {
        int i;
        if (timeArray.length < 1) {
            this._numberElements = 0;
            this._times = null;
            return -1;
        }
        this.setSize(timeArray.length);
        for (int i2 = 0; i2 < this._numberElements; ++i2) {
            this._times[i2].set(timeArray[i2]);
        }
        boolean allZeros = true;
        for (i = 0; i < this._numberElements; ++i) {
            if (timeArray[i] == 0) continue;
            allZeros = false;
            break;
        }
        if (allZeros) {
            for (i = 0; i < this._numberElements; ++i) {
                this._times[i].setUndefined();
            }
        }
        return 0;
    }

    public int[] getIntArray() {
        int[] intArray = new int[this._numberElements];
        for (int i = 0; i < this._numberElements; ++i) {
            intArray[i] = this._times[i].value();
        }
        return intArray;
    }

    public void setUndefined() {
        if (this._times == null || this._numberElements == 0) {
            return;
        }
        for (int i = 0; i < this._numberElements; ++i) {
            this._times[i].setUndefined();
        }
    }

    public int numberElements() {
        return this._numberElements;
    }

    public HecTime[] timeArray() {
        return this._times;
    }

    public int setSize(int numberElements) {
        if (numberElements < 1) {
            this._numberElements = 0;
            this._times = null;
            return -1;
        }
        this._numberElements = numberElements;
        this._times = new HecTime[this._numberElements];
        for (int i = 0; i < this._numberElements; ++i) {
            this._times[i] = new HecTime();
        }
        return 0;
    }

    public int resize(int numberElements) {
        return this.resize(numberElements, 0, 0);
    }

    public int resize(int numberElements, int beginningElement) {
        HecTime[] temp;
        if (numberElements < 1) {
            this._numberElements = 0;
            if (this._times != null) {
                this._times = null;
            }
            return -1;
        }
        if (beginningElement < 0) {
            beginningElement = 0;
        }
        if ((temp = new HecTime[numberElements]) == null) {
            return -1;
        }
        int diff = numberElements - this._numberElements;
        if (diff > 0) {
            int y = beginningElement + diff - 1;
            int arrayPos = 0;
            for (int i = 0; i < numberElements; ++i) {
                temp[i] = new HecTime();
                if ((i < beginningElement || i > y) && arrayPos < this._numberElements) {
                    temp[i].set(this._times[arrayPos]);
                    ++arrayPos;
                    continue;
                }
                temp[i].setUndefined();
            }
        } else {
            int arrayPos = 0;
            for (int i = 0; i < numberElements; ++i) {
                temp[i] = new HecTime();
                arrayPos = i >= beginningElement ? i - diff : i;
                if (arrayPos < this._numberElements) {
                    temp[i].set(this._times[arrayPos]);
                    continue;
                }
                temp[i].setUndefined();
            }
        }
        this._numberElements = numberElements;
        this._times = temp;
        return 0;
    }

    public void resizeWithInterval(int startElement, int numberToAdd, int interval) {
        block5: {
            HecTime startTime = new HecTime();
            if (this._times != null && this._times[0].isDefined()) {
                startTime.set(this._times[0]);
            }
            int begSize = this._numberElements;
            this.resize(begSize + numberToAdd, startElement);
            if (interval <= 0) break block5;
            if (startElement == 0) {
                startTime.increment(-numberToAdd, interval);
                this._times[startElement].set(startTime);
                for (int i = startElement; i < startElement + numberToAdd; ++i) {
                    this._times[i].set(startTime);
                    this._times[i].increment(i, interval);
                }
            } else {
                for (int i = startElement; i < this._times.length; ++i) {
                    this._times[i].set(startTime);
                    this._times[i].increment(i, interval);
                }
            }
        }
    }

    public int resize(int numberElements, int beginningElementOld, int beginningElementNew) {
        HecTime[] temp;
        if (numberElements < 1) {
            this._numberElements = 0;
            if (this._times != null) {
                this._times = null;
            }
            return -1;
        }
        if (beginningElementOld < 0) {
            beginningElementOld = 0;
        }
        if (beginningElementNew < 0) {
            beginningElementNew = 0;
        }
        if (beginningElementOld > this._numberElements) {
            beginningElementOld = this._numberElements;
        }
        if (beginningElementNew > numberElements) {
            beginningElementNew = numberElements;
        }
        if ((temp = new HecTime[numberElements]) == null) {
            return -1;
        }
        int pos = this._numberElements - beginningElementOld + beginningElementNew;
        for (int i = 0; i < numberElements; ++i) {
            temp[i] = new HecTime();
            if (i >= beginningElementNew && i < pos) {
                int k = beginningElementOld + i - beginningElementNew;
                temp[i].set(this._times[k]);
                continue;
            }
            temp[i].setUndefined();
        }
        this._numberElements = numberElements;
        this._times = temp;
        return 0;
    }

    public boolean isDefined() {
        intContainer i = new intContainer();
        return this.isDefined(i);
    }

    public boolean isDefined(intContainer elementNumber) {
        elementNumber.value = 0;
        if (this._times == null || this._numberElements == 0) {
            return false;
        }
        for (int i = 0; i < this._numberElements; ++i) {
            if (!this._times[i].isDefined()) continue;
            elementNumber.value = i;
            return true;
        }
        return false;
    }

    public int index(HecTime time) {
        return this.index(time, false, 0);
    }

    public int index(HecTime time, boolean ascending, int timeInterval) {
        int i;
        int numberPeriods;
        if (this._numberElements == 0) {
            return -1;
        }
        if (!time.isDefined()) {
            for (int i2 = 0; i2 < this._numberElements; ++i2) {
                if (this._times[i2].isDefined()) continue;
                return i2;
            }
            return -1;
        }
        if (timeInterval > 0 && this._times[0].isDefined() && (numberPeriods = this._times[0].computeNumberIntervals(time, timeInterval)) > 0 && numberPeriods < this._numberElements && time.equalTo(this._times[numberPeriods])) {
            return numberPeriods;
        }
        if (ascending) {
            for (i = 0; i < this._numberElements; ++i) {
                int compare = time.compareTimes(this._times[i]);
                if (compare == 0) {
                    return i;
                }
                if (compare >= 0) continue;
                return -1;
            }
            return -1;
        }
        for (i = 0; i < this._numberElements; ++i) {
            if (!time.equalTo(this._times[i])) continue;
            return i;
        }
        return -1;
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public boolean hasTimeZone() {
        return this._timeZone != null;
    }

    public void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
    }

    public void removeTimeZone() {
        this._timeZone = null;
    }

    public TimeZone getViewTimeZone() {
        return this._viewTimeZone;
    }

    public boolean hasViewTimeZone() {
        return this._viewTimeZone != null;
    }

    public void setViewTimeZone(TimeZone timeZone) {
        this._viewTimeZone = timeZone;
    }

    public void removeViewTimeZone() {
        this._viewTimeZone = null;
    }

    public int lastDefined() {
        for (int i = this._numberElements - 1; i > -1; --i) {
            if (!this._times[i].isDefined()) continue;
            return i;
        }
        return -1;
    }

    public HecTime maximum(intContainer elementNumber) {
        if (!this.isDefined(elementNumber)) {
            return new HecTime();
        }
        HecTime max = this._times[elementNumber.value];
        for (int i = 0; i < this._numberElements; ++i) {
            if (!this._times[i].isDefined() || !this._times[i].greaterThan(max)) continue;
            max = this._times[i];
            elementNumber.value = i;
        }
        return max;
    }

    public HecTime minimum(intContainer elementNumber) {
        if (!this.isDefined(elementNumber)) {
            return new HecTime();
        }
        HecTime min = this._times[elementNumber.value];
        for (int i = 0; i < this._numberElements; ++i) {
            if (!this._times[i].isDefined() || !this._times[i].lessThan(min)) continue;
            min = this._times[i];
            elementNumber.value = i;
        }
        return min;
    }

    public int numberDefinedElements() {
        if (this._times == null || this._numberElements == 0) {
            return 0;
        }
        int number = 0;
        for (int i = 0; i < this._numberElements; ++i) {
            if (!this._times[i].isDefined()) continue;
            ++number;
        }
        return number;
    }

    public int numberUndefinedElements() {
        return this._numberElements - this.numberDefinedElements();
    }

    public static String getZoneDisplayString(TimeZone timeZone) {
        String name = timeZone.getDisplayName(false, 0);
        if (name.equals("EST")) {
            return "Eastern Local";
        }
        if (name.equals("CST")) {
            return "Central Local";
        }
        if (name.equals("MST")) {
            return "Mountain Local";
        }
        if (name.equals("PST")) {
            return "Pacific Local";
        }
        return name;
    }

    public synchronized String toString() {
        StringBuffer sbuff = new StringBuffer();
        for (int i = 0; i < this._numberElements; ++i) {
            sbuff.append(i);
            sbuff.append(" ");
            sbuff.append(this._times[i].toString());
            sbuff.append("\n");
        }
        return sbuff.toString();
    }
}

