/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.util;

import hec.heclib.dss.DSSErrorMessage;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecDSSRecordBasics;
import hec.heclib.dss.HecDSSRecordInfo;
import hec.heclib.dss.HecDssCatalog;
import hec.heclib.grid.GridStructContainer;
import hec.heclib.util.HecTime;
import hec.heclib.util.HeclibVersionInfo;
import hec.heclib.util.StringArrayContainer;
import hec.heclib.util.booleanContainer;
import hec.heclib.util.intContainer;
import hec.heclib.util.stringContainer;
import hec.io.ArrayContainer;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TextContainer;
import hec.io.TimeSeriesContainer;
import hec.io.TinContainer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalFactory;

public class Heclib
implements Serializable {
    static final Logger logger;
    static final HeclibVersionInfo SUPPORTED_LIBRARY_VERSION;
    public static final float UNDEFINED_FLOAT = -3.4028235E38f;
    public static final double UNDEFINED_DOUBLE = -3.4028234663852886E38;
    public static final int UNDEFINED_INT = Integer.MIN_VALUE;
    public static final int UNDEFINED_SHORT = Short.MIN_VALUE;
    private static final HeclibVersionInfo versionInfo;
    public static final int DSS_FUNCTION_zopen_ID = 1;
    public static final int DSS_FUNCTION_zclose_ID = 2;
    public static final int DSS_FUNCTION_zset_ID = 3;
    public static final int DSS_FUNCTION_zget_ID = 4;
    public static final int DSS_FUNCTION_zput_ID = 5;
    public static final int DSS_FUNCTION_zgetBuff_ID = 6;
    public static final int DSS_FUNCTION_zputBuff_ID = 7;
    public static final int DSS_FUNCTION_zmemoryGet_ID = 8;
    public static final int DSS_FUNCTION_zmemoryFree_ID = 9;
    public static final int DSS_FUNCTION_zreadDisk_ID = 10;
    public static final int DSS_FUNCTION_zwriteDisk_ID = 11;
    public static final int DSS_FUNCTION_zpermRead_ID = 12;
    public static final int DSS_FUNCTION_zpermCreate_ID = 13;
    public static final int DSS_FUNCTION_zpermWrite_ID = 14;
    public static final int DSS_FUNCTION_zwriteEOF_ID = 15;
    public static final int DSS_FUNCTION_zinit_ID = 16;
    public static final int DSS_FUNCTION_zinitIfltab_ID = 17;
    public static final int DSS_FUNCTION_zlocking_ID = 18;
    public static final int DSS_FUNCTION_znewFileSize_ID = 19;
    public static final int DSS_FUNCTION_zgetFileSpace_ID = 20;
    public static final int DSS_FUNCTION_zcheckKeys_ID = 21;
    public static final int DSS_FUNCTION_zflushToDisk_ID = 22;
    public static final int DSS_FUNCTION_zhash_ID = 23;
    public static final int DSS_FUNCTION_zcheck_ID = 24;
    public static final int DSS_FUNCTION_zreadInfo_ID = 25;
    public static final int DSS_FUNCTION_zcheckMultiUser_ID = 26;
    public static final int DSS_FUNCTION_zreadInternal_ID = 27;
    public static final int DSS_FUNCTION_zwriteInternal_ID = 28;
    public static final int DSS_FUNCTION_zwriteNew_ID = 29;
    public static final int DSS_FUNCTION_zwriteExisting_ID = 30;
    public static final int DSS_FUNCTION_zbinNew_ID = 31;
    public static final int DSS_FUNCTION_zbinUpdate_ID = 32;
    public static final int DSS_FUNCTION_zsetFile_ID = 33;
    public static final int DSS_FUNCTION_zquery_ID = 34;
    public static final int DSS_FUNCTION_zdelete_ID = 35;
    public static final int DSS_FUNCTION_zundelete_ID = 36;
    public static final int DSS_FUNCTION_zcopyFile_ID = 37;
    public static final int DSS_FUNCTION_ztsStoreReg_ID = 38;
    public static final int DSS_FUNCTION_ztsRegStoreBlock_ID = 39;
    public static final int DSS_FUNCTION_ztsStore_ID = 40;
    public static final int DSS_FUNCTION_ztsRetrieve_ID = 41;
    public static final int DSS_FUNCTION_ztsRetrieveReg_ID = 42;
    public static final int DSS_FUNCTION_ztsRegReadBlock_ID = 43;
    public static final int DSS_FUNCTION_ztsWriteBlock_ID = 44;
    public static final int DSS_FUNCTION_ztsTrim_ID = 45;
    public static final int DSS_FUNCTION_ztsStoreIrreg_ID = 46;
    public static final int DSS_FUNCTION_ztsIrregReadBlock_ID = 47;
    public static final int DSS_FUNCTION_ztsIrregMergeBlocks_ID = 48;
    public static final int DSS_FUNCTION_ztsRetrieveIrreg_ID = 49;
    public static final int DSS_FUNCTION_ztsIrregStoreBlock_ID = 50;
    public static final int DSS_FUNCTION_ztsProcessTimes_ID = 51;
    public static final int DSS_FUNCTION_zcatalog_ID = 52;
    public static final int DSS_FUNCTION_zpdStore_ID = 53;
    public static final int DSS_FUNCTION_zpdRetrieve_ID = 54;
    public static final int DSS_FUNCTION_zinquire_ID = 55;
    public static final int DSS_FUNCTION_zsqueeze_ID = 56;
    public static final int DSS_FUNCTION_ztextStore_ID = 57;
    public static final int DSS_FUNCTION_ztextRetrieve_ID = 58;
    public static final int DSS_FUNCTION_zcopyRecord_ID = 59;
    public static final int DSS_FUNCTION_zrename_ID = 60;
    public static final int DSS_FUNCTION_zduplicateRecord_ID = 61;
    public static final int DSS_FUNCTION_zarrayRetrieve_ID = 62;
    public static final int DSS_FUNCTION_zarrayStore_ID = 63;
    public static final int DSS_FUNCTION_zbinaryStore_ID = 64;
    public static final int DSS_FUNCTION_zbinaryRetrieve_ID = 65;
    public static final int DSS_FUNCTION_zcheckHashTable_ID = 66;
    public static final int DSS_FUNCTION_zcheckInfo_ID = 67;
    public static final int DSS_FUNCTION_zcheckLinks_ID = 68;
    public static final int DSS_FUNCTION_zcheckPathnameBins_ID = 69;
    public static final int DSS_FUNCTION_zcheckPathnames_ID = 70;
    public static final int DSS_FUNCTION_zspatialTinStore_ID = 71;
    public static final int DSS_FUNCTION_zspatialTinRetrieve_ID = 72;
    public static final int DSS_FUNCTION_zaliasAdd_ID = 73;
    public static final int DSS_FUNCTION_zaliasRemove_ID = 74;
    public static final int DSS_FUNCTION_zaliasUtil_ID = 75;
    public static final int DSS_FUNCTION_zlocationStore_ID = 76;
    public static final int DSS_FUNCTION_zlocationRetrieve_ID = 77;
    public static final int DSS_FUNCTION_zread_ID = 78;
    public static final int DSS_FUNCTION_zwrite_ID = 79;
    public static final int DSS_FUNCTION_internalUtility_ID = 80;
    public static final int DSS_FUNCTION_ztsAggregate_ID = 81;
    public static final int DSS_FUNCTION_ztsDisaggregate_ID = 82;
    public static final int DSS_FUNCTION_zspatialGridStore_ID = 83;
    public static final int DSS_FUNCTION_zspatialGridRetrieve_ID = 84;
    public static final int DSS_FUNCTION_other_ID = 85;
    public static final int DSS_FUNCTION_javaNativeInterface_ID = 86;
    public static final int MESS_METHOD_GLOBAL_ID = 0;
    public static final int MESS_METHOD_GENERAL_ID = 1;
    public static final int MESS_METHOD_GET_ID = 2;
    public static final int MESS_METHOD_PUT_ID = 3;
    public static final int MESS_METHOD_READ_ID = 4;
    public static final int MESS_METHOD_WRITE_ID = 5;
    public static final int MESS_METHOD_PERM_ID = 6;
    public static final int MESS_METHOD_OPEN_ID = 7;
    public static final int MESS_METHOD_CHECK_ID = 8;
    public static final int MESS_METHOD_LOCKING_ID = 9;
    public static final int MESS_METHOD_TS_READ_ID = 10;
    public static final int MESS_METHOD_TS_WRITE_ID = 11;
    public static final int MESS_METHOD_ALIAS_ID = 12;
    public static final int MESS_METHOD_COPY_ID = 13;
    public static final int MESS_METHOD_UTILITY_ID = 14;
    public static final int MESS_METHOD_CATALOG_ID = 15;
    public static final int MESS_METHOD_FILE_CHECK_ID = 16;
    public static final int MESS_METHOD_JNI_ID = 17;
    public static final int MESS_METHOD_UNDEFINED_ID = 18;
    public static final int MESS_LEVEL_NONE = 0;
    public static final int MESS_LEVEL_CRITICAL = 1;
    public static final int MESS_LEVEL_TERSE = 2;
    public static final int MESS_LEVEL_GENERAL = 3;
    public static final int MESS_LEVEL_USER_DIAG = 4;
    public static final int MESS_LEVEL_INTERNAL_DIAG_1 = 5;
    public static final int MESS_LEVEL_INTERNAL_DIAG_2 = 6;
    public static final boolean onWindows;
    public static final String sysTimeZoneName;
    private static final Map<Integer, String> functionNames;
    private static final Map<Integer, String> dssErrorNames;
    private static final Map<Integer, String> messageLevels;
    private static final Map<Integer, Integer> messageFunctionGroups;

    public static int zerrorDecode(int errorCode, int[] highFunction, int[] lowFunction, int[] dssError, int[] status) throws Exception {
        if (highFunction == null || highFunction.length == 0) {
            throw new Exception("Parameter highFunction is null or zero-length");
        }
        if (lowFunction == null || lowFunction.length == 0) {
            throw new Exception("Parameter lowFunction is null or zero-length");
        }
        if (dssError == null || dssError.length == 0) {
            throw new Exception("Parameter dssError is null or zero-length");
        }
        if (status == null || status.length == 0) {
            throw new Exception("Parameter status is null or zero-length");
        }
        errorCode = Math.abs(errorCode);
        status[0] = errorCode % 100;
        dssError[0] = (errorCode /= 100) % 100;
        lowFunction[0] = (errorCode /= 100) % 100;
        highFunction[0] = (errorCode /= 100) % 100;
        return errorCode / 100;
    }

    public static String getErrorInfo(int errorCode) {
        int severity;
        int[] highFunction = new int[]{0};
        int[] lowFunction = new int[]{0};
        int[] dssError = new int[]{0};
        int[] status = new int[]{0};
        StringBuilder sb = new StringBuilder();
        try {
            severity = Heclib.zerrorDecode(errorCode, highFunction, lowFunction, dssError, status);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error in Heclib.zerrorDecode", e);
            return null;
        }
        sb.append(String.format("zerrorDecode(%d)\n", errorCode)).append(String.format("\tHigh function = %s\n", Heclib.getFunctionFromId(highFunction[0]))).append(String.format("\tLow function  = %s\n", Heclib.getFunctionFromId(lowFunction[0]))).append(String.format("\tDSS Error     = %s\n", Heclib.getDssErrorName(dssError[0]))).append(String.format("\tStatus        = %d\n", status[0]));
        switch (severity) {
            case 1: {
                sb.append("\tSeverity      = INFORMATION\n");
                break;
            }
            case 2: {
                sb.append("\tSeverity      = WARNING\n");
                break;
            }
            case 3: {
                sb.append("\tSeverity      = INVALID_ARGUMENT\n");
                break;
            }
            case 4: {
                sb.append("\tSeverity      = WARNING_NO_append_ACCESS\n");
                break;
            }
            case 5: {
                sb.append("\tSeverity      = WARNING_NO_FILE_ACCESS\n");
                break;
            }
            case 6: {
                sb.append("\tSeverity      = append_ERROR\n");
                break;
            }
            case 7: {
                sb.append("\tSeverity      = READ_ERROR\n");
                break;
            }
            case 8: {
                sb.append("\tSeverity      = CORRUPT_FILE\n");
                break;
            }
            case 9: {
                sb.append("\tSeverity      = MEMORY_ERROR\n");
                break;
            }
            case 0: {
                sb.append("\tSeverity      = NONE\n");
                break;
            }
            default: {
                sb.append("\tSeverity      = UNKNOWN\n");
            }
        }
        return sb.toString();
    }

    public static String getFunctionFromId(int functionId) {
        return functionNames.get(functionId);
    }

    public static String getDssErrorName(int dssError) {
        return dssErrorNames.get(dssError);
    }

    public static String getMessageLevelFromId(int messageLevel) {
        return messageLevels.get(messageLevel);
    }

    public static int getMessageGroupForFunction(int functionID) {
        return messageFunctionGroups.get(functionID);
    }

    public static float[] ints2floats(int[] intArray) {
        float[] floatArray = null;
        if (intArray != null) {
            int size = 4;
            floatArray = new float[intArray.length];
            ByteBuffer buf = ByteBuffer.allocate(size);
            for (int i = 0; i < intArray.length; ++i) {
                buf.putInt(0, intArray[i]);
                floatArray[i] = buf.getFloat(0);
            }
        }
        return floatArray;
    }

    public static int min(int ... vals) {
        int min = Integer.MAX_VALUE;
        if (vals != null) {
            for (int val : vals) {
                if (val >= min) continue;
                min = val;
            }
        }
        return min;
    }

    @Deprecated
    private static synchronized native int Hec_fortranOpen(String var0, int var1);

    @Deprecated
    private static synchronized native int Hec_fortranWrite(String var0, int var1);

    private static synchronized native int Hec_fortranClose(int var0);

    private static synchronized native int Hec_fortranFlush(int var0);

    private static synchronized native int Hec_zgetDssVersion(int[] var0);

    private static synchronized native void Hec_closescratchdsscatalog(int[] var0);

    private static synchronized native void Hec_makedsscatalog(String var0, int[] var1, String var2, int[] var3, int[] var4);

    private static synchronized native int Hec_squeezeDSS(String var0);

    private static synchronized native void Hec_zckmul(int[] var0);

    private static synchronized native void Hec_zflush(int[] var0, int var1);

    private static synchronized native int Hec_zcheckAccessReset(int[] var0, boolean var1, int var2);

    private static synchronized native void Hec_zclose(int[] var0);

    private static synchronized native void Hec_zcheck(int[] var0, String var1, int[] var2, int[] var3, int[] var4);

    private static synchronized native void Hec_zckpnb(int[] var0, int[] var1);

    private static synchronized native void Hec_zcklnk(int[] var0, int[] var1);

    private static synchronized native void Hec_zckpat(int[] var0, int[] var1);

    private static synchronized native String Hec_zcolist(int[] var0, int[] var1, String var2);

    private static synchronized native int Hec_zcorec(int[] var0, int[] var1, String var2, String var3, int[] var4, int var5, int[] var6, int var7);

    private static synchronized native int Hec_zcofil(int[] var0, int[] var1, int[] var2, int var3, int[] var4, int var5);

    private static synchronized native void Hec_zdtype(int[] var0, String var1, int[] var2, int[] var3, stringContainer var4, int[] var5);

    private static synchronized native int Hec_zdelet(int[] var0, String var1);

    private static synchronized native void Hec_zdbmod(int[] var0, long var1, long var3, String var5, int var6);

    private static synchronized native void Hec_zfilst(int[] var0);

    private static synchronized native void Hec_zrecadd(int[] var0, String var1, long[] var2, int[] var3);

    private static synchronized native void Hec_zgtrec(int[] var0, long var1, int var3, int[] var4);

    private static synchronized native void Hec_zget(int[] var0, long var1, int var3, long[] var4);

    private static synchronized native void Hec_zinqir(int[] var0, String var1, stringContainer var2, int[] var3);

    private static synchronized native int Hec_zgetFileVersion(String var0);

    private static synchronized native void Hec_zirbeg(int[] var0, int var1, String var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8);

    private static synchronized native int Hec_zndata(int[] var0, long var1, Vector<String> var3, Vector<Long> var4, Vector<Integer> var5);

    private static synchronized native void Hec_zmaxpart(int[] var0, int[] var1);

    private static synchronized native void Hec_zofset(int[] var0, int[] var1, int var2, int var3, int[] var4);

    private static synchronized native void Hec_zopen(int[] var0, String var1, int[] var2);

    private static synchronized native String Hec_zpath(String var0, String var1, String var2, String var3, String var4, String var5);

    private static synchronized native int Hec_zplist(int[] var0, String var1, int[] var2, stringContainer var3);

    private static native void Hec_zquery(String var0, stringContainer var1, int[] var2);

    private static synchronized native boolean Hec_zrdpat(int[] var0, int[] var1, int[] var2, stringContainer var3, stringContainer var4);

    private static synchronized native void Hec_zreadx(int[] var0, String var1, int[] var2, int var3, int[] var4, int[] var5, int var6, int[] var7, int[] var8, int var9, int[] var10, short[] var11, int var12, int[] var13, int var14, int[] var15);

    private static synchronized native void Hec_zreadxBytes(int[] var0, String var1, int[] var2, int var3, int[] var4, int[] var5, int var6, int[] var7, int[] var8, int var9, int[] var10, byte[] var11, int var12, int[] var13, int var14, int[] var15);

    private static synchronized native int Hec_zrenam(int[] var0, String var1, String var2);

    private static synchronized native void Hec_zrinfo(int[] var0, String var1, int[] var2, int[] var3, stringContainer var4, int[] var5, int[] var6, int[] var7, stringContainer var8, stringContainer var9, stringContainer var10, stringContainer var11, int[] var12, int[] var13, int[] var14, int[] var15, int[] var16);

    private static synchronized native void Hec_zritsc(int[] var0, String var1, int var2, int var3, int var4, int var5, int var6, int[] var7, int[] var8, float[] var9, double[] var10, int var11, int[] var12, int[] var13, int[] var14, int var15, int[] var16, stringContainer var17, stringContainer var18, stringContainer var19, int[] var20, stringContainer var21, double[] var22, int[] var23, int[] var24, int var25, int[] var26);

    private static synchronized native void Hec_zritsx(int[] var0, String var1, int var2, int var3, int var4, int var5, int[] var6, float[] var7, int var8, int[] var9, int[] var10, int[] var11, int var12, int[] var13, stringContainer var14, stringContainer var15, int[] var16, int var17, int[] var18, int var19, int[] var20);

    private static synchronized native void Hec_zritsxd(int[] var0, String var1, int var2, int var3, int var4, int var5, int[] var6, double[] var7, int var8, int[] var9, int[] var10, int[] var11, int var12, int[] var13, stringContainer var14, stringContainer var15, int[] var16, int var17, int[] var18, int var19, int[] var20);

    private static synchronized native void Hec_zrpd(int[] var0, String var1, int[] var2, int[] var3, int[] var4, stringContainer var5, stringContainer var6, stringContainer var7, stringContainer var8, float[] var9, int var10, int[] var11, String[] var12, int var13, booleanContainer var14, int[] var15, int var16, int[] var17, int[] var18);

    private static synchronized native void Hec_zrpdd(int[] var0, String var1, int[] var2, int[] var3, int[] var4, stringContainer var5, stringContainer var6, stringContainer var7, stringContainer var8, double[] var9, int var10, int[] var11, String[] var12, int var13, booleanContainer var14, float[] var15, int var16, int[] var17, int[] var18);

    private static synchronized native void Hec_zrrtsc(int[] var0, String var1, String var2, String var3, int var4, int[] var5, int var6, int[] var7, float[] var8, double[] var9, int[] var10, int var11, int[] var12, stringContainer var13, stringContainer var14, stringContainer var15, int[] var16, int[] var17, int[] var18, stringContainer var19, double[] var20, int[] var21, int[] var22, int[] var23);

    private static synchronized native void Hec_zrrts(int[] var0, String var1, String var2, String var3, int var4, float[] var5, stringContainer var6, stringContainer var7, int[] var8, int[] var9);

    private static synchronized native void Hec_zrrtsx(int[] var0, String var1, String var2, String var3, int var4, float[] var5, int[] var6, int var7, int[] var8, stringContainer var9, stringContainer var10, int[] var11, int var12, int[] var13, int[] var14, int[] var15, int[] var16);

    private static native void Hec_zset(String var0, String var1, int var2);

    private static synchronized native void Hec_zsetfi(int[] var0, String var1, String var2, int var3, int[] var4);

    private static synchronized native void Hec_zsitsc(int[] var0, String var1, int[] var2, float[] var3, double[] var4, int var5, int var6, int var7, int[] var8, int var9, String var10, String var11, double[] var12, int var13, int[] var14, int var15, String var16, int var17, String var18, int var19, int[] var20);

    private static synchronized native void Hec_zspd(int[] var0, String var1, int var2, int var3, int var4, String var5, String var6, String var7, String var8, float[] var9, String[] var10, boolean var11, float[] var12, int var13, int var14, int[] var15);

    private static synchronized native void Hec_zspdd(int[] var0, String var1, int var2, int var3, int var4, String var5, String var6, String var7, String var8, double[] var9, String[] var10, boolean var11, float[] var12, int var13, int var14, int[] var15);

    @Deprecated
    public static synchronized native void Hec_zsrtsc(int[] var0, String var1, String var2, String var3, int var4, int var5, float[] var6, double[] var7, int[] var8, int var9, String var10, String var11, double[] var12, int var13, int[] var14, int var15, String var16, int var17, String var18, int var19, int var20, float var21, int var22, int var23, int var24, int[] var25);

    private static synchronized native void Hec_zstfh(String[] var0, String[] var1, int var2, float[] var3, int var4, int[] var5, int[] var6);

    private static synchronized native void Hec_ztsends(int[] var0, String var1, int var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7);

    private static synchronized native void Hec_ztsinfo(int[] var0, String var1, int[] var2, int[] var3, int[] var4, int[] var5, stringContainer var6, stringContainer var7, int[] var8, int[] var9, int[] var10);

    private static synchronized native void Hec_ztsrange(int[] var0, String var1, int var2, stringContainer var3, stringContainer var4, int[] var5);

    private static synchronized native int Hec_zundel(int[] var0, String var1);

    private static synchronized native void Hec_zustfh(String[] var0, String[] var1, int var2, int[] var3, float[] var4, int var5, int[] var6);

    private static synchronized native void Hec_zwritx(int[] var0, String var1, int var2, int[] var3, int var4, int[] var5, int var6, int[] var7, int var8, short[] var9, int var10, int var11, int var12, int[] var13, int[] var14);

    private static synchronized native void Hec_zwritxBytes(int[] var0, String var1, int var2, int[] var3, int var4, int[] var5, int var6, int[] var7, int var8, byte[] var9, int var10, int var11, int var12, int[] var13, int[] var14);

    private static synchronized native void Hec_zsetMessageLevel(int var0, int var1);

    private static synchronized native int Hec_zgetMessageLevel(int var0);

    private static synchronized native int Hec_ztsRetrieve(int[] var0, TimeSeriesContainer var1, String var2, String var3, String var4, String var5, int var6);

    private static synchronized native int Hec_ztsStore(int[] var0, TimeSeriesContainer var1, int var2);

    private static synchronized native int Hec_zrecInfo(int[] var0, HecDSSRecordInfo var1, String var2, String var3, String var4, String var5);

    private static synchronized native int Hec_zpdStore(int[] var0, PairedDataContainer var1);

    private static synchronized native int Hec_zpdRetrieve(int[] var0, PairedDataContainer var1);

    private static synchronized native int Hec_zarrayRetrieve(int[] var0, ArrayContainer var1);

    private static synchronized native int Hec_zarrayStore(int[] var0, ArrayContainer var1);

    private static synchronized native int Hec_zconvertVersion(String var0, String var1);

    private static synchronized native int Hec_zcatalogFile(int[] var0, String var1, boolean var2, String var3);

    private static synchronized native int Hec_zgetCatalogSortAddresses(int[] var0, long[] var1, int var2);

    private static synchronized native int Hec_zsetCatalogSortAddresses(int[] var0, long[] var1, int var2);

    private static synchronized native void Hec_zsetInterrupt(int var0);

    private static synchronized native long Hec_zlastWriteTime(int[] var0, String var1);

    private static synchronized native long Hec_zlastWriteTimeFile(int[] var0);

    private static synchronized native long Hec_zinquire(int[] var0, String var1);

    private static synchronized native int Hec_zgetRecordBasics(int[] var0, HecDSSRecordBasics var1);

    private static synchronized native int Hec_ztextRetrieve(int[] var0, TextContainer var1);

    private static synchronized native int Hec_ztextStore(int[] var0, TextContainer var1);

    private static synchronized native int Hec_ztinRetrieve(int[] var0, TinContainer var1, boolean var2);

    private static synchronized native int Hec_ztinStore(int[] var0, TinContainer var1);

    private static synchronized native int Hec_zgridRetrieve(int[] var0, GridStructContainer var1, boolean var2);

    private static synchronized native int Hec_zgridRetrieveVersion(int[] var0, String var1, int[] var2);

    private static synchronized native int Hec_zgridStore(int[] var0, GridStructContainer var1);

    private static synchronized native int Hec_zcatalog(int[] var0, HecDssCatalog var1);

    private static synchronized native int Hec_zwhatChangedSetStart(int[] var0, HecDssCatalog var1, String var2, boolean var3);

    private static synchronized native int Hec_zwhatChanged(int[] var0, HecDssCatalog var1);

    private static synchronized native int Hec_zwhatChangedCompare(int[] var0, HecDssCatalog var1, HecDssCatalog var2, String var3, boolean var4);

    private static synchronized native int Hec_zerrorCheck();

    private static synchronized native int Hec_zerrorClear();

    private static synchronized native int Hec_zerrorGet(DSSErrorMessage var0);

    private static synchronized native int Hec_zerrorCode(int[] var0);

    private static synchronized native int Hec_zcheckFile(int[] var0);

    private static synchronized native int Hec_zfileAccessInfo(int[] var0, int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int var6, int[] var7);

    private static synchronized native int Hec_zpathnameListJava(int[] var0, String[] var1, int var2, int var3, int var4, int[] var5, int[] var6, int var7);

    private static synchronized native int Hec_zaliasAdd(int[] var0, String var1, String var2);

    private static synchronized native int Hec_zaliasGetPrimary(int[] var0, String var1, stringContainer var2);

    private static synchronized native int Hec_zaliasRemove(int[] var0, String var1, boolean var2);

    private static synchronized native int Hec_zaliasList(int[] var0, String var1, StringArrayContainer var2);

    private static synchronized native int Hec_zlocationRetrieve(int[] var0, DataContainer var1);

    private static synchronized native int Hec_zlocationStore(int[] var0, DataContainer var1);

    private static synchronized native void Hec_zmessage(int[] var0, String var1);

    public static int getLibraryMajorVersion() {
        return versionInfo.getMajor();
    }

    public static int getLibraryVersion() {
        return versionInfo.getLibraryVersion();
    }

    public static int getLibrarySubVersion() {
        return versionInfo.getSub();
    }

    public static int getLibraryMinorVersion() {
        return versionInfo.getMinor();
    }

    public static synchronized String getLibraryVersionString() {
        return versionInfo.getVersionString();
    }

    @Deprecated
    public static synchronized int zpathnameListJava(int[] ifltab, String[] pathnames, int statusWanted, int typeWantedStart, int typeWantedEnd, int[] startDates, int[] endDates, int pathnameLen) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (pathnames == null || pathnames.length < pathnameLen) {
            throw new RuntimeException("Parameter pathnames is null or shorter than specified length of " + pathnameLen);
        }
        if (startDates == null || startDates.length < pathnameLen) {
            throw new RuntimeException("Parameter startDates is null or shorter than specified length of " + pathnameLen);
        }
        if (endDates == null || endDates.length < pathnameLen) {
            throw new RuntimeException("Parameter endDates is null or shorter than specified length of " + pathnameLen);
        }
        return Heclib.Hec_zpathnameListJava(ifltab, pathnames, statusWanted, typeWantedStart, typeWantedEnd, startDates, endDates, pathnameLen);
    }

    public static synchronized int ztsRetrieve(int[] ifltab, TimeSeriesContainer tsc, String startDate, String startTime, String endDate, String endTime, int retrieveFlag) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (tsc == null) {
            throw new RuntimeException("Parameter tsc is null");
        }
        int status = Heclib.Hec_ztsRetrieve(ifltab, tsc, startDate, startTime, endDate, endTime, retrieveFlag);
        tsc.expandVerticalDatum().clone(tsc);
        return status;
    }

    public static synchronized int ztsStore(int[] ifltab, TimeSeriesContainer tsc, int storageFlag) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (tsc == null) {
            throw new RuntimeException("Parameter tsc is null");
        }
        return Heclib.Hec_ztsStore(ifltab, tsc.collapseVerticalDatum(), storageFlag);
    }

    public static synchronized int zpdStore(int[] ifltab, PairedDataContainer pdc) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (pdc == null) {
            throw new RuntimeException("Parameter pdc is null");
        }
        return Heclib.Hec_zpdStore(ifltab, pdc.collapseVerticalDatum());
    }

    public static synchronized int zpdRetrieve(int[] ifltab, PairedDataContainer pdc) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (pdc == null) {
            throw new RuntimeException("Parameter pdc is null");
        }
        int status = Heclib.Hec_zpdRetrieve(ifltab, pdc);
        pdc.expandVerticalDatum().clone(pdc);
        return status;
    }

    public static synchronized int ztextStore(int[] ifltab, TextContainer textContainer) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (textContainer == null) {
            throw new RuntimeException("Parameter textContainer is null");
        }
        return Heclib.Hec_ztextStore(ifltab, textContainer);
    }

    public static synchronized int ztextRetrieve(int[] ifltab, TextContainer textContainer) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (textContainer == null) {
            throw new RuntimeException("Parameter textContainer is null");
        }
        return Heclib.Hec_ztextRetrieve(ifltab, textContainer);
    }

    public static synchronized int ztinRetrieve(int[] ifltab, TinContainer tinContainer, boolean retrieveData) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (tinContainer == null) {
            throw new RuntimeException("Parameter tinContainer is null");
        }
        return Heclib.Hec_ztinRetrieve(ifltab, tinContainer, retrieveData);
    }

    public static synchronized int ztinStore(int[] ifltab, TinContainer tinContainer) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (tinContainer == null) {
            throw new RuntimeException("Parameter tinContainer is null");
        }
        return Heclib.Hec_ztinStore(ifltab, tinContainer);
    }

    public static synchronized int zgridRetrieve(int[] ifltab, GridStructContainer gridStruct, boolean retrieveData) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (gridStruct == null) {
            throw new RuntimeException("Parameter gridStruct is null");
        }
        return Heclib.Hec_zgridRetrieve(ifltab, gridStruct, retrieveData);
    }

    public static synchronized int zgridRetrieveVersion(int[] ifltab, String path, int[] gridStructVersion) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (gridStructVersion == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter gridStructVersion is null or zero-length");
        }
        return Heclib.Hec_zgridRetrieveVersion(ifltab, path, gridStructVersion);
    }

    public static synchronized int zgridStore(int[] ifltab, GridStructContainer gridStruct) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (gridStruct == null) {
            throw new RuntimeException("Parameter gridStruct is null");
        }
        return Heclib.Hec_zgridStore(ifltab, gridStruct);
    }

    public static synchronized int zcatalog(int[] ifltab, HecDssCatalog catalog) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (catalog == null) {
            throw new RuntimeException("Parameter catalog is null");
        }
        return Heclib.Hec_zcatalog(ifltab, catalog);
    }

    public static synchronized int zwhatChangedSetStart(int[] ifltab, HecDssCatalog dssCatalog, String pathnameWithWild, boolean useCRC) {
        if (versionInfo.getLibraryVersion() < 70306) {
            return -1;
        }
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (dssCatalog == null) {
            throw new RuntimeException("Parameter catalog is null");
        }
        return Heclib.Hec_zwhatChangedSetStart(ifltab, dssCatalog, pathnameWithWild, useCRC);
    }

    public static synchronized int zwhatChanged(int[] ifltab, HecDssCatalog catalog) {
        if (versionInfo.getLibraryVersion() < 70306) {
            return -1;
        }
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (catalog == null) {
            throw new RuntimeException("Parameter catalog is null");
        }
        return Heclib.Hec_zwhatChanged(ifltab, catalog);
    }

    public static synchronized int zwhatChangedCompare(int[] ifltab, HecDssCatalog dssCatalogBefore, HecDssCatalog dssCatalogChanged, String pathWithWild, boolean boolUseCRC) {
        if (versionInfo.getLibraryVersion() < 70306) {
            return -1;
        }
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (dssCatalogBefore == null) {
            throw new RuntimeException("Parameter dssCatalogBefore is null");
        }
        if (dssCatalogChanged == null) {
            throw new RuntimeException("Parameter dssCatalogChanged is null");
        }
        return Heclib.Hec_zwhatChangedCompare(ifltab, dssCatalogBefore, dssCatalogChanged, pathWithWild, boolUseCRC);
    }

    public static synchronized int zerrorCheck() {
        return Heclib.Hec_zerrorCheck();
    }

    public static synchronized int zerrorGet(DSSErrorMessage errorMessage) {
        return Heclib.Hec_zerrorGet(errorMessage);
    }

    public static synchronized int zerrorClear() {
        return Heclib.Hec_zerrorClear();
    }

    public static synchronized int zrecInfo(int[] ifltab, HecDSSRecordInfo recordInfo, String startDate, String startTime, String endDate, String endTime) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (recordInfo == null) {
            throw new RuntimeException("Parameter recordInfo is null");
        }
        return Heclib.Hec_zrecInfo(ifltab, recordInfo, startDate, startTime, endDate, endTime);
    }

    public static synchronized void zsetMessageLevel(int functionGroupID, int levelID) {
        Heclib.Hec_zsetMessageLevel(functionGroupID, levelID);
    }

    public static synchronized int zgetMessageLevel(int functionGroupID) {
        return Heclib.Hec_zgetMessageLevel(functionGroupID);
    }

    public static synchronized int zarrayRetrieve(int[] ifltab, ArrayContainer arrayContainer) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (arrayContainer == null) {
            throw new RuntimeException("Parameter arrayContainer is null");
        }
        return Heclib.Hec_zarrayRetrieve(ifltab, arrayContainer);
    }

    public static synchronized int zarrayStore(int[] ifltab, ArrayContainer arrayContainer) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (arrayContainer == null) {
            throw new RuntimeException("Parameter arrayContainer is null");
        }
        return Heclib.Hec_zarrayStore(ifltab, arrayContainer);
    }

    public static synchronized int zconvertVersion(String nameFrom, String nameTo) {
        return Heclib.Hec_zconvertVersion(nameFrom, nameTo);
    }

    public static synchronized int zcatalogFile(int[] ifltab, String catalogName, boolean sorted, String pathWithWildChars) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        return Heclib.Hec_zcatalogFile(ifltab, catalogName, sorted, pathWithWildChars);
    }

    public static synchronized int zgetCatalogSortAddresses(int[] ifltab, long[] sortAddresses, int sortAddressesLen) {
        if (Heclib.zgetDssFileVersion(ifltab) != 7) {
            return -1;
        }
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (sortAddresses == null || sortAddresses.length < sortAddressesLen) {
            throw new RuntimeException("Parameter sortAddresses is null or is less that the specified length of " + sortAddressesLen);
        }
        return Heclib.Hec_zgetCatalogSortAddresses(ifltab, sortAddresses, sortAddressesLen);
    }

    public static synchronized int zsetCatalogSortAddresses(int[] ifltab, long[] sortAddresses, int sortAddressesLen) {
        if (Heclib.zgetDssFileVersion(ifltab) != 7) {
            return -1;
        }
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (sortAddresses == null || sortAddresses.length < sortAddressesLen) {
            throw new RuntimeException("Parameter sortAddresses is null or is less that the specified length of " + sortAddressesLen);
        }
        return Heclib.Hec_zsetCatalogSortAddresses(ifltab, sortAddresses, sortAddressesLen);
    }

    public static synchronized void zsetInterrupt(int handle) {
        Heclib.Hec_zsetInterrupt(handle);
    }

    public static synchronized void zsetInterrupt() {
        Heclib.Hec_zsetInterrupt(0);
    }

    public static synchronized int zfileAccessInfo(int[] ifltab, int[] accessMode, int[] numberAccesses, int[] numberWriting, int[] pidsArray, int[] modesArray, int arraySize, int[] numberPids) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (accessMode == null || accessMode.length == 0) {
            throw new RuntimeException("Parameter accessMode is null or zero-length");
        }
        if (numberAccesses == null || numberAccesses.length == 0) {
            throw new RuntimeException("Parameter numberAccesses is null or zero-length");
        }
        if (numberWriting == null || numberWriting.length == 0) {
            throw new RuntimeException("Parameter numberWriting is null or zero-length");
        }
        if (pidsArray == null || pidsArray.length < arraySize) {
            throw new RuntimeException("Parameter pidsArray is null or less than specified length of " + pidsArray);
        }
        if (modesArray == null || modesArray.length < arraySize) {
            throw new RuntimeException("Parameter modesArray is null or less than specified length of " + pidsArray);
        }
        if (numberPids == null || numberPids.length == 0) {
            throw new RuntimeException("Parameter numberPids is null or zero-length");
        }
        return Heclib.Hec_zfileAccessInfo(ifltab, accessMode, numberAccesses, numberWriting, pidsArray, modesArray, arraySize, numberPids);
    }

    public static synchronized int zerrorCode(int[] ifltab) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        return Heclib.Hec_zerrorCode(ifltab);
    }

    public static synchronized int zcheckFile(int[] ifltab) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        return Heclib.Hec_zcheckFile(ifltab);
    }

    public static synchronized long zlastWriteTime(int[] ifltab, String pathname) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        return Heclib.Hec_zlastWriteTime(ifltab, pathname);
    }

    public static synchronized long zlastWriteTimeFile(int[] ifltab) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        return Heclib.Hec_zlastWriteTimeFile(ifltab);
    }

    public static synchronized long zinquire(int[] ifltab, String parameter) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        return Heclib.Hec_zinquire(ifltab, parameter);
    }

    public static synchronized int zgetRecordBasics(int[] ifltab, HecDSSRecordBasics recordBasics) {
        if (versionInfo.getLibraryVersion() < 70500) {
            return -1;
        }
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (recordBasics == null) {
            throw new RuntimeException("Parameter recordBasics is null");
        }
        return Heclib.Hec_zgetRecordBasics(ifltab, recordBasics);
    }

    public static synchronized int zaliasAdd(int[] ifltab, String primaryPathname, String aliasPathname) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        return Heclib.Hec_zaliasAdd(ifltab, primaryPathname, aliasPathname);
    }

    public static synchronized int zaliasGetPrimary(int[] ifltab, String aliasPathname, stringContainer primaryPathname) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (primaryPathname == null) {
            throw new RuntimeException("Parameter primaryPathname is null");
        }
        return Heclib.Hec_zaliasGetPrimary(ifltab, aliasPathname, primaryPathname);
    }

    public static synchronized int zaliasRemove(int[] ifltab, String pathname, boolean removeAll) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        return Heclib.Hec_zaliasRemove(ifltab, pathname, removeAll);
    }

    public static synchronized int zaliasList(int[] ifltab, String aliasPathname, StringArrayContainer pathnameList) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (pathnameList == null) {
            throw new RuntimeException("Parameter pathnameList is null");
        }
        return Heclib.Hec_zaliasList(ifltab, aliasPathname, pathnameList);
    }

    public static synchronized int zlocationRetrieve(int[] ifltab, DataContainer dataContainer) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (dataContainer == null) {
            throw new RuntimeException("Parameter pathnameList is dataContainer");
        }
        return Heclib.Hec_zlocationRetrieve(ifltab, dataContainer);
    }

    public static synchronized int zlocationStore(int[] ifltab, DataContainer dataContainer) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (dataContainer == null) {
            throw new RuntimeException("Parameter pathnameList is dataContainer");
        }
        return Heclib.Hec_zlocationStore(ifltab, dataContainer);
    }

    @Deprecated
    public static synchronized int zgetDssVersion(int[] ifltab) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        return Heclib.zgetDssFileVersion(ifltab);
    }

    public static synchronized int zgetDssFileVersion(int[] ifltab) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (ifltab[0] != 6 && ifltab[0] != 7) {
            stringContainer sc = new stringContainer();
            int[] iver = new int[1];
            Heclib.zinqir(ifltab, "VERS", sc, iver);
            return iver[0];
        }
        return ifltab[0];
    }

    public static synchronized int zgetFileVersion(String dssFileName) {
        return Heclib.Hec_zgetFileVersion(dssFileName);
    }

    public static synchronized String getProcessName(int processID) {
        Optional<ProcessHandle> handle = ProcessHandle.of(processID);
        String not_found = "No such process";
        if (handle.isEmpty()) {
            return not_found;
        }
        Optional<String> cmd = handle.get().info().command();
        return cmd.orElse(not_found);
    }

    @Deprecated
    public static String decodeHollerith(int[] ints) {
        StringBuilder sb = new StringBuilder();
        int intCount = ints.length;
        block0: for (int i = 0; i < intCount; ++i) {
            for (int j = 0; j < 4; ++j) {
                int v = ints[i] >> 8 * j & 0xFF;
                if (v == 0) break block0;
                sb.append((char)v);
            }
        }
        return sb.toString();
    }

    @Deprecated
    public static void encodeHollerith(String s, int[] ints) {
        int i;
        if (s == null) {
            throw new RuntimeException("String s must not be null");
        }
        int intCount = ints.length;
        int requiredLength = (s.length() - 1) / 4 + 1;
        if (intCount < requiredLength) {
            throw new RuntimeException(String.format("Required at least %d ints, to encode %d characters, got %d", requiredLength, s.length(), intCount));
        }
        for (i = 0; i < intCount; ++i) {
            ints[i] = 0;
        }
        for (i = 0; i < s.length(); ++i) {
            int j = i / 4;
            int k = i % 4;
            int n = j;
            ints[n] = ints[n] | s.charAt(i) << 8 * k;
        }
    }

    @Deprecated
    public static synchronized String holString(int[] hol, int length) {
        if (hol == null) {
            throw new RuntimeException("Parameter hol is null");
        }
        return Heclib.decodeHollerith(hol);
    }

    @Deprecated
    public static synchronized String holString(float[] hol, int length) {
        if (hol == null) {
            throw new RuntimeException("Parameter hol is null");
        }
        int intCount = (length - 1) / 4 + 1;
        ByteBuffer byteBuffer = ByteBuffer.allocate(hol.length * 4);
        byteBuffer.asFloatBuffer().put(hol);
        int[] intArray = new int[intCount];
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.get(intArray);
        return Heclib.decodeHollerith(intArray);
    }

    @Deprecated
    public static synchronized void StringHol(String str, int length, float[] hol) {
        if (hol == null) {
            throw new RuntimeException("Parameter hol is null");
        }
        int intCount = (length - 1) / 4 + 1;
        ByteBuffer byteBuffer = ByteBuffer.allocate(hol.length * 4);
        byteBuffer.asFloatBuffer().put(hol);
        int[] intArray = new int[intCount];
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.get(intArray);
        Heclib.encodeHollerith(str.substring(0, length), intArray);
        byteBuffer.asIntBuffer().put(intArray);
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.get(hol);
    }

    @Deprecated
    public static synchronized void StringHol(String str, int length, int[] hol) {
        if (hol == null) {
            throw new RuntimeException("Parameter hol is null");
        }
        Heclib.encodeHollerith(str.substring(0, length), hol);
    }

    public static synchronized int fortranOpen(String filename, int unit) {
        return Heclib.Hec_fortranOpen(filename, unit);
    }

    public static synchronized int fortranClose(int unit) {
        return Heclib.Hec_fortranClose(unit);
    }

    public static synchronized int fortranWrite(String string, int unit) {
        if (string == null) {
            return 0;
        }
        return Heclib.Hec_fortranWrite(string, unit);
    }

    public static synchronized int fortranFlush(int unit) {
        return Heclib.Hec_fortranFlush(unit);
    }

    public static synchronized void closescratchdsscatalog(int[] catalogUnit) {
        if (catalogUnit == null || catalogUnit.length == 0) {
            throw new RuntimeException("Parameter catalogUnit is null or zero-length");
        }
        Heclib.Hec_closescratchdsscatalog(catalogUnit);
    }

    @Deprecated
    public static synchronized String getEPartFromInterval(int interval, int[] status) {
        String ePart = DSSPathname.getRegularTsEPartFromInterval(6, interval, status);
        if (ePart.startsWith("~") && status != null && status.length > 0) {
            status[0] = -1;
        }
        return ePart;
    }

    public static synchronized String getDSSEPartFromInterval(int interval, int[] status) {
        String ePart = DSSPathname.getRegularTsEPartFromInterval(7, interval * 60, status);
        if (ePart.startsWith("~") && status != null && status.length > 0) {
            status[0] = -1;
        }
        return ePart;
    }

    public static synchronized void makedsscatalog(String dssFileName, int[] ifltab, String catalogInstructions, int[] numberFound, int[] catalogUnit) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (catalogInstructions == null) {
            throw new RuntimeException("Parameter catalogInstructions is null");
        }
        Heclib.Hec_makedsscatalog(dssFileName, ifltab, catalogInstructions, numberFound, catalogUnit);
    }

    public static synchronized int squeezeDSS(String dssFileName) {
        return Heclib.Hec_squeezeDSS(dssFileName);
    }

    @Deprecated
    public static synchronized void zbegdt(int julian, int interval, int[] year, int[] month, int[] day, int[] block, int DSSVersion) {
        if (year == null || year.length == 0) {
            throw new RuntimeException("Parameter year is null or zero-length");
        }
        if (month == null || month.length == 0) {
            throw new RuntimeException("Parameter month is null or zero-length");
        }
        if (day == null || day.length == 0) {
            throw new RuntimeException("Parameter day is null or zero-length");
        }
        Optional intvl = IntervalFactory.findAnyDss((Predicate)IntervalFactory.equalsMinutes((int)interval));
        if (intvl.isPresent()) {
            int[] blockStartDate = new int[3];
            int[] valueInterval = new int[1];
            int[] valuesPerBlock = new int[1];
            DSSPathname.getTSBlockInfo(((Interval)intvl.get()).getInterval(), julian, blockStartDate, block, valueInterval, valuesPerBlock);
            year[0] = blockStartDate[0];
            month[0] = blockStartDate[1];
            day[0] = blockStartDate[2];
        }
    }

    public static synchronized void zckmul(int[] ifltab) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        Heclib.Hec_zckmul(ifltab);
    }

    public static synchronized void zflush(int[] ifltab, int forceFlush) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        Heclib.Hec_zflush(ifltab, forceFlush);
    }

    public static synchronized int zcheckAccessReset(int[] ifltab, boolean forceReopen, int quiescentTimeMills) {
        if (versionInfo.getLibraryVersion() < 70500) {
            return -1;
        }
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        return Heclib.Hec_zcheckAccessReset(ifltab, forceReopen, quiescentTimeMills);
    }

    public static synchronized void zclose(int[] ifltab) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        Heclib.Hec_zclose(ifltab);
    }

    public static synchronized void zcheck(int[] ifltab, String pathname, int[] numberHeader, int[] numberData, int[] exists) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (numberHeader == null || numberHeader.length == 0) {
            throw new RuntimeException("Parameter numberHeader is null or zero-length");
        }
        if (numberData == null || numberData.length == 0) {
            throw new RuntimeException("Parameter numberData is null or zero-length");
        }
        if (exists == null || exists.length == 0) {
            throw new RuntimeException("Parameter exists is null or zero-length");
        }
        Heclib.Hec_zcheck(ifltab, pathname, numberHeader, numberData, exists);
    }

    public static synchronized void zckpnb(int[] ifltab, int[] nerror) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (nerror == null || nerror.length == 0) {
            throw new RuntimeException("Parameter nerror is null or zero-length");
        }
        Heclib.Hec_zckpnb(ifltab, nerror);
    }

    public static synchronized void zcklnk(int[] ifltab, int[] nerror) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (nerror == null || nerror.length == 0) {
            throw new RuntimeException("Parameter nerror is null or zero-length");
        }
        Heclib.Hec_zcklnk(ifltab, nerror);
    }

    public static synchronized void zckpat(int[] ifltab, int[] nerror) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (nerror == null || nerror.length == 0) {
            throw new RuntimeException("Parameter nerror is null or zero-length");
        }
        Heclib.Hec_zckpat(ifltab, nerror);
    }

    public static synchronized String zcolist(int[] ifltab, int[] filePos, String seedPathname) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (filePos == null || filePos.length == 0) {
            throw new RuntimeException("Parameter filePos is null or zero-length");
        }
        return Heclib.Hec_zcolist(ifltab, filePos, seedPathname);
    }

    @Deprecated
    public static synchronized int zcorec(int[] ifltabFrom, int[] ifltabTo, String pathnameFrom, String pathnameTo, int[] buffer1, int buffer1Size, int[] buffer2, int buffer2Size) {
        return Heclib.zcopyRecord(ifltabFrom, ifltabTo, pathnameFrom, pathnameTo);
    }

    public static synchronized int zcopyRecord(int[] ifltabFrom, int[] ifltabTo, String pathnameFrom, String pathnameTo) {
        if (ifltabFrom == null || ifltabFrom.length == 0) {
            throw new RuntimeException("Parameter ifltabFrom is null or zero-length");
        }
        if (ifltabTo == null || ifltabTo.length == 0) {
            throw new RuntimeException("Parameter ifltabTo is null or zero-length");
        }
        return Heclib.Hec_zcorec(ifltabFrom, ifltabTo, pathnameFrom, pathnameTo, null, 0, null, 0);
    }

    @Deprecated
    public static synchronized int zcofil(int[] ifltabFrom, int[] ifltabTo, int[] buffer1, int buffer1Size, int[] buffer2, int buffer2Size) {
        return Heclib.zcopyFile(ifltabFrom, ifltabTo);
    }

    public static synchronized int zcopyFile(int[] ifltabFrom, int[] ifltabTo) {
        if (ifltabFrom == null || ifltabFrom.length == 0) {
            throw new RuntimeException("Parameter ifltabFrom is null or zero-length");
        }
        if (ifltabTo == null || ifltabTo.length == 0) {
            throw new RuntimeException("Parameter ifltabTo is null or zero-length");
        }
        return Heclib.Hec_zcofil(ifltabFrom, ifltabTo, null, 0, null, 0);
    }

    public static synchronized int zdelet(int[] ifltab, String pathname) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        return Heclib.Hec_zdelet(ifltab, pathname);
    }

    public static synchronized void zdtype(int[] ifltab, String pathname, int[] checkedNumber, int[] exists, stringContainer type, int[] dataType) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (checkedNumber == null || checkedNumber.length == 0) {
            throw new RuntimeException("Parameter checkedNumber is null or zero-length");
        }
        if (exists == null || exists.length == 0) {
            throw new RuntimeException("Parameter exists is null or zero-length");
        }
        if (type == null) {
            throw new RuntimeException("Parameter type is null");
        }
        if (dataType == null || dataType.length == 0) {
            throw new RuntimeException("Parameter dataType is null or zero-length");
        }
        Heclib.Hec_zdtype(ifltab, pathname, checkedNumber, exists, type, dataType);
    }

    public static synchronized void zdbmod(int[] ifltab, long address, long value, String characterValue, int useCharacterValue) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        Heclib.Hec_zdbmod(ifltab, address, value, characterValue, useCharacterValue);
    }

    public static synchronized void zfilst(int[] ifltab) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        Heclib.Hec_zfilst(ifltab);
    }

    @Deprecated
    public static synchronized void zgetInterval(int[] interval, stringContainer ePart, int[] nvals, int[] status) {
        if (interval == null || interval.length == 0) {
            throw new RuntimeException("Parameter interval is null or zero-length");
        }
        if (interval[0] > 0) {
            interval[0] = interval[0] * 60;
        }
        try {
            DSSPathname.getTsIntervalInfo(interval, ePart, nvals, status);
            while (status[0] == 4 && (interval[0] > 0 && interval[0] < 60 || ePart.string.startsWith("~"))) {
                DSSPathname.getTsIntervalInfo(interval, ePart, nvals, status);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (interval[0] > 0) {
            interval[0] = interval[0] / 60;
        }
        ePart.string = ePart.string.toUpperCase().replace("MINUTE", "MIN").replace("1MONTH", "1MON");
    }

    public static synchronized int zrecadd(int[] ifltab, String path, long[] internals) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (internals == null || internals.length == 0) {
            throw new RuntimeException("Parameter internals is null or zero-length");
        }
        int[] status = new int[1];
        Heclib.Hec_zrecadd(ifltab, path, internals, status);
        return status[0];
    }

    @Deprecated
    public static synchronized void zgintl(int[] interval, String ePart, int[] nvals, int[] status) {
        if (interval == null || interval.length == 0) {
            throw new RuntimeException("Parameter interval is null or zero-length");
        }
        stringContainer _ePart = new stringContainer();
        _ePart.string = ePart;
        try {
            DSSPathname.getTsIntervalInfo(interval, _ePart, nvals, status);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (status[0] == 0) {
            interval[0] = interval[0] / 60;
        }
    }

    public static synchronized void zgtrec(int[] ifltab, long address, int numberWords, int[] array) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (array == null || array.length < numberWords) {
            throw new RuntimeException("Parameter array is null or less than specified length of " + numberWords);
        }
        Heclib.Hec_zgtrec(ifltab, address, numberWords, array);
    }

    public static synchronized void zget(int[] ifltab, long address, int numberArray, long[] array) {
        Heclib.Hec_zget(ifltab, address, numberArray, array);
    }

    public static synchronized void zincbk(int[] block, int[] julian, int[] year, int[] month, int[] day) {
        if (block == null || block.length == 0) {
            throw new RuntimeException("Parameter block is null or zero-length");
        }
        if (julian == null || julian.length == 0) {
            throw new RuntimeException("Parameter julian is null or zero-length");
        }
        if (year == null || year.length == 0) {
            throw new RuntimeException("Parameter year is null or zero-length");
        }
        if (month == null || month.length == 0) {
            throw new RuntimeException("Parameter month is null or zero-length");
        }
        if (day == null || day.length == 0) {
            throw new RuntimeException("Parameter day is null or zero-length");
        }
        int increment = block[0] < 0 ? -1 : 1;
        intContainer y = new intContainer();
        intContainer m = new intContainer();
        intContainer d = new intContainer();
        switch (Math.abs(block[0])) {
            case 1: {
                julian[0] = HecTime.yearMonthDayToJulian(year[0], month[0], day[0]) + increment;
                HecTime.julianToYearMonthDay(julian[0], y, m, d);
                year[0] = y.value;
                month[0] = m.value;
                day[0] = d.value;
                julian[0] = HecTime.iymdjl(year[0], month[0], day[0]);
                break;
            }
            case 2: {
                month[0] = month[0] + increment;
                switch (month[0]) {
                    case 0: {
                        year[0] = year[0] - 1;
                        month[0] = 12;
                        break;
                    }
                    case 13: {
                        year[0] = year[0] + 1;
                        month[0] = 1;
                    }
                }
                julian[0] = HecTime.iymdjl(year[0], month[0], day[0]);
                break;
            }
            case 3: {
                year[0] = year[0] + increment;
                julian[0] = HecTime.iymdjl(year[0], month[0], day[0]);
                break;
            }
            case 4: {
                year[0] = year[0] + increment * 10;
                julian[0] = HecTime.iymdjl(year[0], month[0], day[0]);
                break;
            }
            case 5: {
                year[0] = year[0] + increment * 100;
                julian[0] = HecTime.iymdjl(year[0], month[0], day[0]);
            }
        }
    }

    public static synchronized void zinqir(int[] ifltab, String param, stringContainer alpha, int[] number) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (alpha == null) {
            throw new RuntimeException("Parameter alpha is null");
        }
        if (number == null || number.length == 0) {
            throw new RuntimeException("Parameter number is null or zero-length");
        }
        Heclib.Hec_zinqir(ifltab, param, alpha, number);
    }

    @Deprecated
    public static synchronized void zirbeg(int[] ifltab, int julian, String ePart, int[] year, int[] month, int[] day, int[] block, int[] minutesInBlock, int[] incrementBlock) {
        if (year == null || year.length == 0) {
            throw new RuntimeException("Parameter year is null or zero-length");
        }
        if (month == null || month.length == 0) {
            throw new RuntimeException("Parameter month is null or zero-length");
        }
        if (day == null || day.length == 0) {
            throw new RuntimeException("Parameter day is null or zero-length");
        }
        int[] blockStartDate = new int[3];
        DSSPathname.getTSBlockInfo(ePart, julian, blockStartDate, block, null, null);
        year[0] = blockStartDate[0];
        month[0] = blockStartDate[1];
        day[0] = blockStartDate[2];
        if (minutesInBlock != null && minutesInBlock.length > 0) {
            minutesInBlock[0] = 0;
        }
        if (incrementBlock != null && incrementBlock.length > 0) {
            incrementBlock[0] = 0;
        }
    }

    public static synchronized int zndata(int[] ifltab, long startTime, Vector<String> pathnames, Vector<Long> updateTimes, Vector<Integer> recordTypes) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        return Heclib.Hec_zndata(ifltab, startTime, pathnames, updateTimes, recordTypes);
    }

    public static synchronized void zmaxpart(int[] ifltab, int[] maxpart) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (maxpart == null || maxpart.length < 6) {
            throw new RuntimeException("Parameter maxpart is null or less than required length of 6");
        }
        Heclib.Hec_zmaxpart(ifltab, maxpart);
    }

    @Deprecated
    public static synchronized void zofset(int[] julian, int[] minutes, int interval, int flag, int[] offset) {
        if (julian == null || julian.length == 0) {
            throw new RuntimeException("Parameter julian is null or zero-length");
        }
        if (minutes == null || minutes.length == 0) {
            throw new RuntimeException("Parameter minutes is null or zero-length");
        }
        if (offset == null || offset.length == 0) {
            throw new RuntimeException("Parameter offset is null or zero-length");
        }
        HecTime t = new HecTime();
        t.setJulian(julian[0], minutes[0]);
        switch (flag) {
            case 0: {
                offset[0] = DSSPathname.getTSIntervalOffset(t, interval * 60) / 60;
                break;
            }
            case 1: {
                offset[0] = DSSPathname.getTSIntervalOffset(t, interval * 60) / 60;
                HecTime topOfInterval = DSSPathname.getTSTopOfInterval(t, interval * 60, 0);
                if (topOfInterval.lessThan(t)) {
                    topOfInterval = DSSPathname.incrementInterval(topOfInterval, interval * 60, 1);
                }
                julian[0] = topOfInterval.julian();
                minutes[0] = topOfInterval.minutesSinceMidnight();
                break;
            }
            case 2: {
                HecTime topOfInterval = DSSPathname.getTSTopOfInterval(t, interval * 60, offset[0] * 60);
                if (topOfInterval.lessThan(t)) {
                    topOfInterval = DSSPathname.incrementInterval(topOfInterval, interval * 60, 1);
                }
                julian[0] = topOfInterval.julian();
                minutes[0] = topOfInterval.minutesSinceMidnight();
            }
        }
    }

    public static synchronized void zopen(int[] ifltab, String name, int[] status) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (status == null || status.length == 0) {
            throw new RuntimeException("Parameter status is null or zero-length");
        }
        Heclib.Hec_zopen(ifltab, name, status);
    }

    @Deprecated
    public static synchronized String zpath(String aPart, String bPart, String cPart, String dPart, String ePart, String fPart) {
        return DSSPathname.buildPathnameFromParts(aPart, bPart, cPart, dPart, ePart, fPart);
    }

    @Deprecated
    public static synchronized int zplist(int[] ifltab, String instructions, int[] filePos, stringContainer pathname) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (instructions == null) {
            throw new RuntimeException("Parameter instructions is null or zero-length");
        }
        if (filePos == null || filePos.length == 0) {
            throw new RuntimeException("Parameter filePos is null or zero-length");
        }
        if (pathname == null) {
            throw new RuntimeException("Parameter pathname is null");
        }
        return Heclib.Hec_zplist(ifltab, instructions, filePos, pathname);
    }

    public static void zquery(String param, stringContainer alpha, int[] number) {
        if (alpha == null) {
            throw new RuntimeException("Parameter alpha is null");
        }
        if (number == null || number.length == 0) {
            throw new RuntimeException("Parameter number is null or zero-length");
        }
        Heclib.Hec_zquery(param, alpha, number);
    }

    public static synchronized boolean zrdpat(int[] catalogUnit, int[] position, int[] referenceNumber, stringContainer tag, stringContainer pathname) {
        if (catalogUnit == null || catalogUnit.length == 0) {
            throw new RuntimeException("Parameter catalogUnit is null or zero-length");
        }
        if (position == null || position.length == 0) {
            throw new RuntimeException("Parameter position is null or zero-length");
        }
        if (referenceNumber == null || referenceNumber.length == 0) {
            throw new RuntimeException("Parameter referenceNumber is null or zero-length");
        }
        if (tag == null) {
            throw new RuntimeException("Parameter tag is null");
        }
        if (pathname == null) {
            throw new RuntimeException("Parameter pathname is null");
        }
        return Heclib.Hec_zrdpat(catalogUnit, position, referenceNumber, tag, pathname);
    }

    public static synchronized void zreadx(int[] ifltab, String pathname, int[] intheader, int kintheader, int[] nintheader, int[] compheader, int kcompheader, int[] ncompheader, int[] userheader, int kuserheader, int[] nuserheader, short[] data, int kdata, int[] ndata, int plan, int[] found) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (intheader == null || intheader.length < kintheader) {
            throw new RuntimeException("Parameter intheader is null or less than specified length of " + kintheader);
        }
        if (nintheader == null || nintheader.length == 0) {
            throw new RuntimeException("Parameter nintheader is null or zero-length");
        }
        if (compheader == null || compheader.length < kcompheader) {
            throw new RuntimeException("Parameter compheader is null or less than specified length of " + kcompheader);
        }
        if (ncompheader == null || ncompheader.length == 0) {
            throw new RuntimeException("Parameter ncompheader is null or zero-length");
        }
        if (userheader == null || userheader.length < kuserheader) {
            throw new RuntimeException("Parameter userheader is null or less than specified length of " + kuserheader);
        }
        if (nuserheader == null || nuserheader.length == 0) {
            throw new RuntimeException("Parameter nuserheader is null or zero-length");
        }
        if (data == null || data.length < kdata) {
            throw new RuntimeException("Parameter data is null or less than specified length of " + kdata);
        }
        if (ndata == null || ndata.length == 0) {
            throw new RuntimeException("Parameter ndata is null or zero-length");
        }
        if (found == null || found.length == 0) {
            throw new RuntimeException("Parameter found is null or zero-length");
        }
        Heclib.Hec_zreadx(ifltab, pathname, intheader, kintheader, nintheader, compheader, kcompheader, ncompheader, userheader, kuserheader, nuserheader, data, kdata, ndata, plan, found);
    }

    public static synchronized void zreadxBytes(int[] ifltab, String pathname, int[] intheader, int kintheader, int[] nintheader, int[] compheader, int kcompheader, int[] ncompheader, int[] userheader, int kuserheader, int[] nuserheader, byte[] data, int kdata, int[] ndata, int plan, int[] found) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (intheader == null || intheader.length < kintheader) {
            throw new RuntimeException("Parameter intheader is null or less than specified length of " + kintheader);
        }
        if (nintheader == null || nintheader.length == 0) {
            throw new RuntimeException("Parameter nintheader is null or zero-length");
        }
        if (compheader == null || compheader.length < kcompheader) {
            throw new RuntimeException("Parameter compheader is null or less than specified length of " + kcompheader);
        }
        if (ncompheader == null || ncompheader.length == 0) {
            throw new RuntimeException("Parameter ncompheader is null or zero-length");
        }
        if (userheader == null || userheader.length < kuserheader) {
            throw new RuntimeException("Parameter userheader is null or less than specified length of " + kuserheader);
        }
        if (nuserheader == null || nuserheader.length == 0) {
            throw new RuntimeException("Parameter nuserheader is null or zero-length");
        }
        if (data == null || data.length < kdata) {
            throw new RuntimeException("Parameter data is null or less than specified length of " + kdata);
        }
        if (ndata == null || ndata.length == 0) {
            throw new RuntimeException("Parameter ndata is null or zero-length");
        }
        if (found == null || found.length == 0) {
            throw new RuntimeException("Parameter found is null or zero-length");
        }
        Heclib.Hec_zreadxBytes(ifltab, pathname, intheader, kintheader, nintheader, compheader, kcompheader, ncompheader, userheader, kuserheader, nuserheader, data, kdata, ndata, plan, found);
    }

    public static synchronized int zrenam(int[] ifltab, String pathname, String newPathname) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        return Heclib.Hec_zrenam(ifltab, pathname, newPathname);
    }

    public static synchronized void zrinfo(int[] ifltab, String pathname, int[] lexists, int[] recordType, stringContainer recordTypeDescription, int[] ldoubles, int[] lquality, int[] precision, stringContainer recordTag, stringContainer lastWrittenDate, stringContainer lastWrittenTime, stringContainer programName, int[] version, int[] numberData, int[] spaceAllocated, int[] timeSeriesCompression, int[] lpasswordProtected) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (lexists == null || lexists.length == 0) {
            throw new RuntimeException("Parameter lexists is null or zero-length");
        }
        if (recordType == null || recordType.length == 0) {
            throw new RuntimeException("Parameter recordType is null or zero-length");
        }
        if (recordTypeDescription == null) {
            throw new RuntimeException("Parameter recordTypeDescription is null");
        }
        if (ldoubles == null || ldoubles.length == 0) {
            throw new RuntimeException("Parameter ldoubles is null or zero-length");
        }
        if (lquality == null || lquality.length == 0) {
            throw new RuntimeException("Parameter lquality is null or zero-length");
        }
        if (precision == null || precision.length == 0) {
            throw new RuntimeException("Parameter precision is null or zero-length");
        }
        if (recordTag == null) {
            throw new RuntimeException("Parameter recordTag is null");
        }
        if (lastWrittenDate == null) {
            throw new RuntimeException("Parameter lastWrittenDate is null");
        }
        if (lastWrittenTime == null) {
            throw new RuntimeException("Parameter lastWrittenTime is null");
        }
        if (programName == null) {
            throw new RuntimeException("Parameter programName is null");
        }
        if (version == null || version.length == 0) {
            throw new RuntimeException("Parameter version is null or zero-length");
        }
        if (numberData == null || numberData.length == 0) {
            throw new RuntimeException("Parameter numberData is null or zero-length");
        }
        if (spaceAllocated == null || spaceAllocated.length == 0) {
            throw new RuntimeException("Parameter spaceAllocated is null or zero-length");
        }
        if (timeSeriesCompression == null || timeSeriesCompression.length == 0) {
            throw new RuntimeException("Parameter timeSeriesCompression is null or zero-length");
        }
        if (lpasswordProtected == null || lpasswordProtected.length == 0) {
            throw new RuntimeException("Parameter lpasswordProtected is null or zero-length");
        }
        Heclib.Hec_zrinfo(ifltab, pathname, lexists, recordType, recordTypeDescription, ldoubles, lquality, precision, recordTag, lastWrittenDate, lastWrittenTime, programName, version, numberData, spaceAllocated, timeSeriesCompression, lpasswordProtected);
    }

    @Deprecated
    public static synchronized void zritsc(int[] ifltab, String pathname, int startJulian, int startMinutes, int endJulian, int endMinutes, int getDoubles, int[] doublesRead, int[] timeBuffer, float[] floatValues, double[] doubleValues, int maxValues, int[] numberRead, int[] beginJulian, int[] flags, int readFlags, int[] flagsRead, stringContainer units, stringContainer type, stringContainer supplementalInfo, int[] timezoneOffset, stringContainer timezoneName, double[] coordinates, int[] coordinateDescription, int[] coordinatesUsed, int inflag, int[] status) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (doublesRead == null || doublesRead.length == 0) {
            throw new RuntimeException("Parameter doublesRead is null or zero-length");
        }
        if (timeBuffer == null || timeBuffer.length < maxValues) {
            throw new RuntimeException("Parameter timeBuffer is null or less than specified length of " + maxValues);
        }
        if (getDoubles == 0 && (floatValues == null || floatValues.length < maxValues)) {
            throw new RuntimeException("Parameter floatValues is null or less than specified length of " + maxValues);
        }
        if (getDoubles != 0 && (doubleValues == null || doubleValues.length < maxValues)) {
            throw new RuntimeException("Parameter doubleValues is null or less than specified length of " + maxValues);
        }
        if (beginJulian == null || beginJulian.length == 0) {
            throw new RuntimeException("Parameter beginJulian is null or zero-length");
        }
        if (readFlags != 0 && (flags == null || flags.length < maxValues)) {
            throw new RuntimeException("Parameter flags is null or less than specified length of " + maxValues);
        }
        if (flagsRead == null || flagsRead.length == 0) {
            throw new RuntimeException("Parameter flagsRead is null or zero-length");
        }
        if (units == null) {
            throw new RuntimeException("Parameter units is null");
        }
        if (type == null) {
            throw new RuntimeException("Parameter type is null");
        }
        if (supplementalInfo == null) {
            throw new RuntimeException("Parameter supplementalInfo is null");
        }
        if (timezoneOffset == null || timezoneOffset.length == 0) {
            throw new RuntimeException("Parameter timezoneOffset is null or zero-length");
        }
        if (timezoneName == null) {
            throw new RuntimeException("Parameter timezoneName is null");
        }
        if (coordinates == null || coordinates.length == 0) {
            throw new RuntimeException("Parameter coordinates is null or less than required length of 3");
        }
        if (coordinateDescription == null || coordinateDescription.length == 0) {
            throw new RuntimeException("Parameter coordinateDescription is null or less than required length of 3");
        }
        if (coordinatesUsed == null || coordinatesUsed.length == 0) {
            throw new RuntimeException("Parameter coordinatesUsed is null or zero-length");
        }
        if (status == null || status.length == 0) {
            throw new RuntimeException("Parameter status is null or zero-length");
        }
        Heclib.Hec_zritsc(ifltab, pathname, startJulian, startMinutes, endJulian, endMinutes, getDoubles, doublesRead, timeBuffer, floatValues, doubleValues, maxValues, numberRead, beginJulian, flags, readFlags, flagsRead, units, type, supplementalInfo, timezoneOffset, timezoneName, coordinates, coordinateDescription, coordinatesUsed, inflag, status);
    }

    @Deprecated
    public static synchronized void zritsx(int[] ifltab, String pathname, int startJulian, int startMinutes, int endJulian, int endMinutes, int[] timeBuffer, float[] data, int dataSize, int[] numberRead, int[] beginJulian, int[] flags, int readFlags, int[] flagsRead, stringContainer units, stringContainer type, int[] userHead, int maxUserHead, int[] numberHeadRead, int inflag, int[] status) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (timeBuffer == null || timeBuffer.length < dataSize) {
            throw new RuntimeException("Parameter timeBuffer is null or less than specified length of " + dataSize);
        }
        if (numberRead == null || numberRead.length == 0) {
            throw new RuntimeException("Parameter numberRead is null or zero-length");
        }
        if (beginJulian == null || beginJulian.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (readFlags != 0 && (flags == null || flags.length < dataSize)) {
            throw new RuntimeException("Parameter flags is null or less than specified length of " + dataSize);
        }
        if (flagsRead == null || flagsRead.length == 0) {
            throw new RuntimeException("Parameter flagsRead is null or zero-length");
        }
        if (units == null) {
            throw new RuntimeException("Parameter units is null");
        }
        if (type == null) {
            throw new RuntimeException("Parameter type is null");
        }
        if (userHead == null || userHead.length < maxUserHead) {
            throw new RuntimeException("Parameter userHead is null or less than specified length of " + maxUserHead);
        }
        if (numberHeadRead == null || numberHeadRead.length == 0) {
            throw new RuntimeException("Parameter numberHeadRead is null or zero-length");
        }
        if (status == null || status.length == 0) {
            throw new RuntimeException("Parameter status is null or zero-length");
        }
        Heclib.Hec_zritsx(ifltab, pathname, startJulian, startMinutes, endJulian, endMinutes, timeBuffer, data, dataSize, numberRead, beginJulian, flags, readFlags, flagsRead, units, type, userHead, maxUserHead, numberHeadRead, inflag, status);
    }

    @Deprecated
    public static synchronized void zritsxd(int[] ifltab, String pathname, int startJulian, int startMinutes, int endJulian, int endMinutes, int[] timeBuffer, double[] data, int dataSize, int[] numberRead, int[] beginJulian, int[] flags, int readFlags, int[] flagsRead, stringContainer units, stringContainer type, int[] userHead, int maxUserHead, int[] numberHeadRead, int inflag, int[] status) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (timeBuffer == null || timeBuffer.length < dataSize) {
            throw new RuntimeException("Parameter timeBuffer is null or less than specified length of " + dataSize);
        }
        if (numberRead == null || numberRead.length == 0) {
            throw new RuntimeException("Parameter numberRead is null or zero-length");
        }
        if (beginJulian == null || beginJulian.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (readFlags != 0 && (flags == null || flags.length < dataSize)) {
            throw new RuntimeException("Parameter flags is null or less than specified length of " + dataSize);
        }
        if (flagsRead == null || flagsRead.length == 0) {
            throw new RuntimeException("Parameter flagsRead is null or zero-length");
        }
        if (units == null) {
            throw new RuntimeException("Parameter units is null");
        }
        if (type == null) {
            throw new RuntimeException("Parameter type is null");
        }
        if (userHead == null || userHead.length < maxUserHead) {
            throw new RuntimeException("Parameter userHead is null or less than specified length of " + maxUserHead);
        }
        if (numberHeadRead == null || numberHeadRead.length == 0) {
            throw new RuntimeException("Parameter numberHeadRead is null or zero-length");
        }
        if (status == null || status.length == 0) {
            throw new RuntimeException("Parameter status is null or zero-length");
        }
        Heclib.Hec_zritsxd(ifltab, pathname, startJulian, startMinutes, endJulian, endMinutes, timeBuffer, data, dataSize, numberRead, beginJulian, flags, readFlags, flagsRead, units, type, userHead, maxUserHead, numberHeadRead, inflag, status);
    }

    @Deprecated
    public static synchronized void zrpd(int[] ifltab, String cpath, int[] nord, int[] numberOfCurves, int[] ihoriz, stringContainer cunitsX, stringContainer ctypeX, stringContainer cunitsY, stringContainer ctypeY, float[] values, int kvals, int[] numberOfValues, String[] clabel, int klabel, booleanContainer labelsExist, int[] headu, int kheadu, int[] nheadu, int[] istat) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (nord == null || nord.length == 0) {
            throw new RuntimeException("Parameter nord is null or zero-length");
        }
        if (numberOfCurves == null || numberOfCurves.length == 0) {
            throw new RuntimeException("Parameter numberOfCurves is null or zero-length");
        }
        if (ihoriz == null || ihoriz.length == 0) {
            throw new RuntimeException("Parameter ihoriz is null or zero-length");
        }
        if (cunitsX == null) {
            throw new RuntimeException("Parameter cunitsX is null");
        }
        if (ctypeX == null) {
            throw new RuntimeException("Parameter ctypeX is null");
        }
        if (cunitsY == null) {
            throw new RuntimeException("Parameter cunitsY is null");
        }
        if (ctypeY == null) {
            throw new RuntimeException("Parameter ctypeY is null");
        }
        if (values == null || values.length < kvals) {
            throw new RuntimeException("Parameter values is null or less than specified length of " + kvals);
        }
        if (numberOfValues == null || numberOfValues.length == 0) {
            throw new RuntimeException("Parameter numberOfValues is null or zero-length");
        }
        if (klabel > 0 && (clabel == null || clabel.length < klabel)) {
            throw new RuntimeException("Parameter clabel is null or less than specified length of " + klabel);
        }
        if (labelsExist == null) {
            throw new RuntimeException("Parameter labelsExist is null");
        }
        if (kheadu > 0 && (headu == null || headu.length < kheadu)) {
            throw new RuntimeException("Parameter headu is null or less than specified length of " + kheadu);
        }
        if (nheadu == null || nheadu.length == 0) {
            throw new RuntimeException("Parameter nheadu is null or zero-length");
        }
        if (istat == null || istat.length == 0) {
            throw new RuntimeException("Parameter istat is null or zero-length");
        }
        Heclib.Hec_zrpd(ifltab, cpath, nord, numberOfCurves, ihoriz, cunitsX, ctypeX, cunitsY, ctypeY, values, kvals, numberOfValues, clabel, klabel, labelsExist, headu, kheadu, nheadu, istat);
    }

    @Deprecated
    public static synchronized void zrpdd(int[] ifltab, String cpath, int[] nord, int[] numberOfCurves, int[] ihoriz, stringContainer cunitsX, stringContainer ctypeX, stringContainer cunitsY, stringContainer ctypeY, double[] values, int kvals, int[] numberOfValues, String[] clabel, int klabel, booleanContainer labelsExist, float[] headu, int kheadu, int[] nheadu, int[] istat) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (nord == null || nord.length == 0) {
            throw new RuntimeException("Parameter nord is null or zero-length");
        }
        if (numberOfCurves == null || numberOfCurves.length == 0) {
            throw new RuntimeException("Parameter numberOfCurves is null or zero-length");
        }
        if (ihoriz == null || ihoriz.length == 0) {
            throw new RuntimeException("Parameter ihoriz is null or zero-length");
        }
        if (cunitsX == null) {
            throw new RuntimeException("Parameter cunitsX is null");
        }
        if (ctypeX == null) {
            throw new RuntimeException("Parameter ctypeX is null");
        }
        if (cunitsY == null) {
            throw new RuntimeException("Parameter cunitsY is null");
        }
        if (ctypeY == null) {
            throw new RuntimeException("Parameter ctypeY is null");
        }
        if (values == null || values.length < kvals) {
            throw new RuntimeException("Parameter values is null or less than specified length of " + kvals);
        }
        if (numberOfValues == null || numberOfValues.length == 0) {
            throw new RuntimeException("Parameter numberOfValues is null or zero-length");
        }
        if (klabel > 0 && (clabel == null || clabel.length < klabel)) {
            throw new RuntimeException("Parameter clabel is null or less than specified length of " + klabel);
        }
        if (labelsExist == null) {
            throw new RuntimeException("Parameter labelsExist is null");
        }
        if (kheadu > 0 && (headu == null || headu.length < kheadu)) {
            throw new RuntimeException("Parameter headu is null or less than specified length of " + kheadu);
        }
        if (nheadu == null || nheadu.length == 0) {
            throw new RuntimeException("Parameter nheadu is null or zero-length");
        }
        if (istat == null || istat.length == 0) {
            throw new RuntimeException("Parameter istat is null or zero-length");
        }
        Heclib.Hec_zrpdd(ifltab, cpath, nord, numberOfCurves, ihoriz, cunitsX, ctypeX, cunitsY, ctypeY, values, kvals, numberOfValues, clabel, klabel, labelsExist, headu, kheadu, nheadu, istat);
    }

    @Deprecated
    public static synchronized void zrrts(int[] ifltab, String pathname, String startDate, String startTime, int number, float[] data, stringContainer units, stringContainer type, int[] offset, int[] status) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (data == null || data.length < number) {
            throw new RuntimeException("Parameter data is null or less than specified length of " + number);
        }
        if (units == null) {
            throw new RuntimeException("Parameter units is null");
        }
        if (type == null) {
            throw new RuntimeException("Parameter type is null");
        }
        if (offset == null || offset.length == 0) {
            throw new RuntimeException("Parameter offset is null or zero-length");
        }
        if (status == null || status.length == 0) {
            throw new RuntimeException("Parameter status is null or zero-length");
        }
        Heclib.Hec_zrrts(ifltab, pathname, startDate, startTime, number, data, units, type, offset, status);
    }

    @Deprecated
    public static synchronized void zrrtsc(int[] ifltab, String pathname, String startDate, String startTime, int maxNumber, int[] numberRead, int getDoubles, int[] doublesRead, float[] floatValues, double[] doubleValues, int[] flags, int readFlags, int[] flagsRead, stringContainer units, stringContainer type, stringContainer supplementalInfo, int[] offset, int[] compression, int[] timezoneOffset, stringContainer timezoneName, double[] coordinates, int[] coordinateDescription, int[] coordinatesUsed, int[] status) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (doublesRead == null || doublesRead.length == 0) {
            throw new RuntimeException("Parameter doublesRead is null or zero-length");
        }
        if (getDoubles == 0 && (floatValues == null || floatValues.length < maxNumber)) {
            throw new RuntimeException("Parameter floatValues is null or less than specified length of " + maxNumber);
        }
        if (getDoubles != 0 && (doubleValues == null || doubleValues.length < maxNumber)) {
            throw new RuntimeException("Parameter doubleValues is null or less than specified length of " + maxNumber);
        }
        if (readFlags != 0 && (flags == null || flags.length < maxNumber)) {
            throw new RuntimeException("Parameter flags is null or less than specified length of " + maxNumber);
        }
        if (flagsRead == null || flagsRead.length == 0) {
            throw new RuntimeException("Parameter flagsRead is null or zero-length");
        }
        if (units == null) {
            throw new RuntimeException("Parameter units is null");
        }
        if (type == null) {
            throw new RuntimeException("Parameter type is null");
        }
        if (supplementalInfo == null) {
            throw new RuntimeException("Parameter supplementalInfo is null");
        }
        if (offset == null || offset.length == 0) {
            throw new RuntimeException("Parameter offset is null or zero-length");
        }
        if (compression == null || compression.length == 0) {
            throw new RuntimeException("Parameter compression is null or zero-length");
        }
        if (timezoneOffset == null || timezoneOffset.length == 0) {
            throw new RuntimeException("Parameter timezoneOffset is null or zero-length");
        }
        if (timezoneName == null) {
            throw new RuntimeException("Parameter timezoneName is null");
        }
        if (coordinates == null || coordinates.length == 0) {
            throw new RuntimeException("Parameter coordinates is null or less than required length of 3");
        }
        if (coordinateDescription == null || coordinateDescription.length == 0) {
            throw new RuntimeException("Parameter coordinateDescription is null or less than required length of 3");
        }
        if (coordinatesUsed == null || coordinatesUsed.length == 0) {
            throw new RuntimeException("Parameter coordinatesUsed is null or zero-length");
        }
        if (status == null || status.length == 0) {
            throw new RuntimeException("Parameter status is null or zero-length");
        }
        Heclib.Hec_zrrtsc(ifltab, pathname, startDate, startTime, maxNumber, numberRead, getDoubles, doublesRead, floatValues, doubleValues, flags, readFlags, flagsRead, units, type, supplementalInfo, offset, compression, timezoneOffset, timezoneName, coordinates, coordinateDescription, coordinatesUsed, status);
    }

    @Deprecated
    public static synchronized void zrrtsx(int[] ifltab, String pathname, String startDate, String startTime, int number, float[] data, int[] flags, int readFlags, int[] flagsRead, stringContainer units, stringContainer type, int[] userHead, int maxUserHead, int[] numberHeadRead, int[] offset, int[] compression, int[] status) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (data == null || data.length < number) {
            throw new RuntimeException("Parameter data is null or less than specified length of " + number);
        }
        if (readFlags != 0 && (flags == null || flags.length < number)) {
            throw new RuntimeException("Parameter flags is null or less than specified length of " + number);
        }
        if (flagsRead == null || flagsRead.length == 0) {
            throw new RuntimeException("Parameter flagsRead is null or zero-length");
        }
        if (units == null) {
            throw new RuntimeException("Parameter units is null");
        }
        if (type == null) {
            throw new RuntimeException("Parameter type is null");
        }
        if (userHead == null || userHead.length < maxUserHead) {
            throw new RuntimeException("Parameter userHead is null or less than specified length of " + maxUserHead);
        }
        if (numberHeadRead == null || numberHeadRead.length == 0) {
            throw new RuntimeException("Parameter numberHeadRead is null or zero-length");
        }
        if (offset == null || offset.length == 0) {
            throw new RuntimeException("Parameter offset is null or zero-length");
        }
        if (compression == null || compression.length == 0) {
            throw new RuntimeException("Parameter compression is null or zero-length");
        }
        if (status == null || status.length == 0) {
            throw new RuntimeException("Parameter status is null or zero-length");
        }
        Heclib.Hec_zrrtsx(ifltab, pathname, startDate, startTime, number, data, flags, readFlags, flagsRead, units, type, userHead, maxUserHead, numberHeadRead, offset, compression, status);
    }

    public static void zset(String parameter, String alpha, int number) {
        if (alpha == null) {
            throw new RuntimeException("Parameter alpha is null");
        }
        Heclib.Hec_zset(parameter, alpha, number);
    }

    public static synchronized void zsetfi(int[] ifltab, String parameter, String alpha, int number, int[] status) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (alpha == null) {
            throw new RuntimeException("Parameter alpha is null");
        }
        if (status == null || status.length == 0) {
            throw new RuntimeException("Parameter status is null or zero-length");
        }
        Heclib.Hec_zsetfi(ifltab, parameter, alpha, number, status);
    }

    @Deprecated
    public static synchronized void zsitsc(int[] ifltab, String pathname, int[] times, float[] floatValues, double[] doubleValues, int storeDouble, int numberVals, int startDate, int[] flags, int storeFlags, String unitsX, String typeX, double[] coordinates, int numberCoordinates, int[] coordinateDescription, int numbCoordDescription, String supplementaryInfo, int timezoneOffset, String timezoneName, int inFlag, int[] status) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (times == null || times.length < numberVals) {
            throw new RuntimeException("Parameter times is null or less than specified length of " + numberVals);
        }
        if (storeDouble == 0 && (floatValues == null || floatValues.length < numberVals)) {
            throw new RuntimeException("Parameter floatValues is null or less than specified length of " + numberVals);
        }
        if (storeDouble != 0 && (doubleValues == null || doubleValues.length < numberVals)) {
            throw new RuntimeException("Parameter doubleValues is null or less than specified length of " + numberVals);
        }
        if (storeFlags != 0 && (flags == null || flags.length < numberVals)) {
            throw new RuntimeException("Parameter flags is null or less than specified length of " + numberVals);
        }
        if (unitsX == null) {
            throw new RuntimeException("Parameter unitsX is null");
        }
        if (typeX == null) {
            throw new RuntimeException("Parameter typeX is null");
        }
        if (numberCoordinates != 0 && (coordinates == null || coordinates.length < numberCoordinates)) {
            throw new RuntimeException("Parameter doubleValues is null or less than specified length of " + numberCoordinates);
        }
        if (numbCoordDescription != 0 && (coordinateDescription == null || coordinateDescription.length < numbCoordDescription)) {
            throw new RuntimeException("Parameter doubleValues is null or less than specified length of " + numbCoordDescription);
        }
        if (status == null || status.length == 0) {
            throw new RuntimeException("Parameter status is null or zero-length");
        }
        Heclib.Hec_zsitsc(ifltab, pathname, times, floatValues, doubleValues, storeDouble, numberVals, startDate, flags, storeFlags, unitsX, typeX, coordinates, numberCoordinates, coordinateDescription, numbCoordDescription, supplementaryInfo, timezoneOffset, timezoneName, inFlag, status);
    }

    @Deprecated
    public static synchronized void zspd(int[] ifltab, String cpath, int nord, int ncurve, int ihoriz, String cunitsX, String ctypeX, String cunitsY, String ctypeY, float[] values, String[] clabel, boolean label, float[] headu, int nheadu, int iplan, int[] istat) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (cunitsX == null) {
            throw new RuntimeException("Parameter cunitsX is null");
        }
        if (ctypeX == null) {
            throw new RuntimeException("Parameter ctypeX is null");
        }
        if (cunitsY == null) {
            throw new RuntimeException("Parameter cunitsY is null");
        }
        if (ctypeY == null) {
            throw new RuntimeException("Parameter ctypeY is null");
        }
        if (values == null || values.length == 0) {
            throw new RuntimeException("Parameter values is null or zero-length");
        }
        if (label && (clabel == null || clabel.length == 0)) {
            throw new RuntimeException("Parameter clabel is null or zero-length");
        }
        if (nheadu != 0 && (headu == null || headu.length < nheadu)) {
            throw new RuntimeException("Parameter clabel is null or less than specified length of " + nheadu);
        }
        if (istat == null || istat.length == 0) {
            throw new RuntimeException("Parameter istat is null or zero-length");
        }
        Heclib.Hec_zspd(ifltab, cpath, nord, ncurve, ihoriz, cunitsX, ctypeX, cunitsY, ctypeY, values, clabel, label, headu, nheadu, iplan, istat);
    }

    @Deprecated
    public static synchronized void zspdd(int[] ifltab, String cpath, int nord, int ncurve, int ihoriz, String cunitsX, String ctypeX, String cunitsY, String ctypeY, double[] values, String[] clabel, boolean label, float[] headu, int nheadu, int iplan, int[] istat) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (cunitsX == null) {
            throw new RuntimeException("Parameter cunitsX is null");
        }
        if (ctypeX == null) {
            throw new RuntimeException("Parameter ctypeX is null");
        }
        if (cunitsY == null) {
            throw new RuntimeException("Parameter cunitsY is null");
        }
        if (ctypeY == null) {
            throw new RuntimeException("Parameter ctypeY is null");
        }
        if (values == null || values.length == 0) {
            throw new RuntimeException("Parameter values is null or zero-length");
        }
        if (label && (clabel == null || clabel.length == 0)) {
            throw new RuntimeException("Parameter clabel is null or zero-length");
        }
        if (nheadu != 0 && (headu == null || headu.length < nheadu)) {
            throw new RuntimeException("Parameter clabel is null or less than specified length of " + nheadu);
        }
        if (istat == null || istat.length == 0) {
            throw new RuntimeException("Parameter istat is null or zero-length");
        }
        Heclib.Hec_zspdd(ifltab, cpath, nord, ncurve, ihoriz, cunitsX, ctypeX, cunitsY, ctypeY, values, clabel, label, headu, nheadu, iplan, istat);
    }

    public static synchronized void zsrtsc(int[] ifltab, String pathname, String startDate, String startTime, int number, int storeDouble, float[] floatValues, double[] doubleValues, int[] flags, int storeFlags, String units, String type, double[] coordinates, int numberCoordinates, int[] coordinateDescription, int numbCoordDescription, String supplementaryInfo, int timezoneOffset, String timezoneName, int plan, int compression, float baseValue, int baseValueSet, int highDelta, int deltaPrecision, int[] status) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (storeDouble == 0 && (floatValues == null || floatValues.length < number)) {
            throw new RuntimeException("Parameter floatValues is null or less than the specified length of " + number);
        }
        if (storeDouble != 0 && (doubleValues == null || doubleValues.length < number)) {
            throw new RuntimeException("Parameter doubleValues is null or less than the specified length of " + number);
        }
        if (storeFlags != 0 && (flags == null || flags.length < number)) {
            throw new RuntimeException("Parameter flags is null or less than the specified length of " + number);
        }
        if (numberCoordinates != 0 && (coordinates == null || coordinates.length < numberCoordinates)) {
            throw new RuntimeException("Parameter coordinates is null or less than the specified length of " + numberCoordinates);
        }
        if (numbCoordDescription != 0 && (coordinateDescription == null || coordinateDescription.length < numbCoordDescription)) {
            throw new RuntimeException("Parameter coordinateDescription is null or less than the specified length of " + numbCoordDescription);
        }
        if (status == null || status.length == 0) {
            throw new RuntimeException("Parameter status is null or zero-length");
        }
        Heclib.Hec_zsrtsc(ifltab, pathname, startDate, startTime, number, storeDouble, floatValues, doubleValues, flags, storeFlags, units, type, coordinates, numberCoordinates, coordinateDescription, numbCoordDescription, supplementaryInfo, timezoneOffset, timezoneName, plan, compression, baseValue, baseValueSet, highDelta, deltaPrecision, status);
    }

    public static synchronized void zstfh(String[] clabel, String[] citems, int numberItems, float[] header, int headerMax, int[] headerNumber, int[] istat) {
        if (numberItems != 0 && (clabel == null || clabel.length < numberItems)) {
            throw new RuntimeException("Parameter clabel is null or less than the specified length of " + numberItems);
        }
        if (numberItems != 0 && (citems == null || citems.length < numberItems)) {
            throw new RuntimeException("Parameter citems is null or less than the specified length of " + numberItems);
        }
        if (headerMax != 0 && (header == null || header.length < headerMax)) {
            throw new RuntimeException("Parameter header is null or less than the specified length of " + headerMax);
        }
        if (headerNumber == null || headerNumber.length == 0) {
            throw new RuntimeException("Parameter headerNumber is null or zero-length");
        }
        if (istat == null || istat.length == 0) {
            throw new RuntimeException("Parameter istat is null or zero-length");
        }
        Heclib.Hec_zstfh(clabel, citems, numberItems, header, headerMax, headerNumber, istat);
    }

    public static synchronized void zstfh(String[] clabel, String[] citems, int numberItems, int[] header, int headerMax, int[] headerNumber, int[] istat) {
        if (numberItems != 0 && (clabel == null || clabel.length < numberItems)) {
            throw new RuntimeException("Parameter clabel is null or less than the specified length of " + numberItems);
        }
        if (numberItems != 0 && (citems == null || citems.length < numberItems)) {
            throw new RuntimeException("Parameter citems is null or less than the specified length of " + numberItems);
        }
        if (headerMax != 0 && (header == null || header.length < headerMax)) {
            throw new RuntimeException("Parameter header is null or less than the specified length of " + headerMax);
        }
        if (headerNumber == null || headerNumber.length == 0) {
            throw new RuntimeException("Parameter headerNumber is null or zero-length");
        }
        if (istat == null || istat.length == 0) {
            throw new RuntimeException("Parameter istat is null or zero-length");
        }
        Heclib.Hec_zstfh(clabel, citems, numberItems, Heclib.ints2floats(header), headerMax, headerNumber, istat);
    }

    public static synchronized void ztsends(int[] ifltab, String pathname, int searchOption, int[] startJulian, int[] startMinutes, int[] endJulian, int[] endMinutes, int[] lfound) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (startJulian == null || startJulian.length == 0) {
            throw new RuntimeException("Parameter startJulian is null or zero-length");
        }
        if (startMinutes == null || startMinutes.length == 0) {
            throw new RuntimeException("Parameter startMinutes is null or zero-length");
        }
        if (endJulian == null || endJulian.length == 0) {
            throw new RuntimeException("Parameter endJulian is null or zero-length");
        }
        if (endMinutes == null || endMinutes.length == 0) {
            throw new RuntimeException("Parameter endMinutes is null or zero-length");
        }
        if (lfound == null || lfound.length == 0) {
            throw new RuntimeException("Parameter lfound is null or zero-length");
        }
        Heclib.Hec_ztsends(ifltab, pathname, searchOption, startJulian, startMinutes, endJulian, endMinutes, lfound);
    }

    public static synchronized void ztsinfo(int[] ifltab, String pathname, int[] startJulian, int[] startMinutes, int[] endJulian, int[] endMinutes, stringContainer units, stringContainer type, int[] lflags, int[] ldouble, int[] lfound) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (startJulian == null || startJulian.length == 0) {
            throw new RuntimeException("Parameter startJulian is null or zero-length");
        }
        if (startMinutes == null || startMinutes.length == 0) {
            throw new RuntimeException("Parameter startMinutes is null or zero-length");
        }
        if (endJulian == null || endJulian.length == 0) {
            throw new RuntimeException("Parameter endJulian is null or zero-length");
        }
        if (endMinutes == null || endMinutes.length == 0) {
            throw new RuntimeException("Parameter endMinutes is null or zero-length");
        }
        if (units == null) {
            throw new RuntimeException("Parameter units is null");
        }
        if (type == null) {
            throw new RuntimeException("Parameter type is null");
        }
        if (lflags == null || lflags.length == 0) {
            throw new RuntimeException("Parameter lflags is null or zero-length");
        }
        if (ldouble == null || ldouble.length == 0) {
            throw new RuntimeException("Parameter ldouble is null or zero-length");
        }
        if (lfound == null || lfound.length == 0) {
            throw new RuntimeException("Parameter lfound is null or zero-length");
        }
        Heclib.Hec_ztsinfo(ifltab, pathname, startJulian, startMinutes, endJulian, endMinutes, units, type, lflags, ldouble, lfound);
    }

    public static synchronized void ztsrange(int[] ifltab, String pathname, int searchOption, stringContainer firstPath, stringContainer lastPath, int[] numberFound) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (firstPath == null) {
            throw new RuntimeException("Parameter firstPath is null");
        }
        if (lastPath == null) {
            throw new RuntimeException("Parameter lastPath is null");
        }
        if (numberFound == null || numberFound.length == 0) {
            throw new RuntimeException("Parameter numberFound is null or zero-length");
        }
        Heclib.Hec_ztsrange(ifltab, pathname, searchOption, firstPath, lastPath, numberFound);
    }

    public static synchronized int zundel(int[] ifltab, String pathname) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        return Heclib.Hec_zundel(ifltab, pathname);
    }

    public static synchronized void zustfh(String[] clabel, String[] citems, int numberItems, int[] position, float[] header, int headerNumber, int[] istat) {
        if (clabel == null || clabel.length == 0) {
            throw new RuntimeException("Parameter clabel is null or zero-length");
        }
        if (citems == null || citems.length == 0) {
            throw new RuntimeException("Parameter clabel is null or zero-length");
        }
        if (position == null || position.length == 0) {
            throw new RuntimeException("Parameter position is null or zero-length");
        }
        if (header == null || header.length < headerNumber) {
            throw new RuntimeException("Parameter header is null or less than specified length of " + headerNumber);
        }
        if (istat == null || istat.length == 0) {
            throw new RuntimeException("Parameter istat is null or zero-length");
        }
        Heclib.Hec_zustfh(clabel, citems, numberItems, position, header, headerNumber, istat);
    }

    public static synchronized void zustfh(String[] clabel, String[] citems, int numberItems, int[] position, int[] header, int headerNumber, int[] istat) {
        if (clabel == null || clabel.length == 0) {
            throw new RuntimeException("Parameter clabel is null or zero-length");
        }
        if (citems == null || citems.length == 0) {
            throw new RuntimeException("Parameter clabel is null or zero-length");
        }
        if (position == null || position.length == 0) {
            throw new RuntimeException("Parameter position is null or zero-length");
        }
        if (header == null || header.length < headerNumber) {
            throw new RuntimeException("Parameter header is null or less than specified length of " + headerNumber);
        }
        if (istat == null || istat.length == 0) {
            throw new RuntimeException("Parameter istat is null or zero-length");
        }
        Heclib.Hec_zustfh(clabel, citems, numberItems, position, Heclib.ints2floats(header), headerNumber, istat);
    }

    public static synchronized void zwritx(int[] ifltab, String pathname, int nPathname, int[] intheader, int nintheader, int[] compheader, int ncompheader, int[] userheader, int nuserheader, short[] data, int ndata, int type, int plan, int[] status, int[] found) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (intheader == null || intheader.length < nintheader) {
            throw new RuntimeException("Parameter intheader is null or less that specified length of " + nintheader);
        }
        if (ncompheader != 0 && (compheader == null || compheader.length < ncompheader)) {
            throw new RuntimeException("Parameter compheader is null or less that specified length of " + ncompheader);
        }
        if (nuserheader != 0 && (userheader == null || userheader.length < nuserheader)) {
            throw new RuntimeException("Parameter userheader is null or less that specified length of " + nuserheader);
        }
        if (data == null || data.length < ndata) {
            throw new RuntimeException("Parameter data is null or less that specified length of " + ndata);
        }
        if (status == null || status.length == 0) {
            throw new RuntimeException("Parameter status is null or zero-length");
        }
        if (found == null || found.length == 0) {
            throw new RuntimeException("Parameter found is null or zero-length");
        }
        Heclib.Hec_zwritx(ifltab, pathname, nPathname, intheader, nintheader, compheader, ncompheader, userheader, nuserheader, data, ndata, type, plan, status, found);
    }

    public static synchronized void zwritxBytes(int[] ifltab, String pathname, int nPathname, int[] intheader, int nintheader, int[] compheader, int ncompheader, int[] userheader, int nuserheader, byte[] data, int ndata, int type, int plan, int[] status, int[] found) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (intheader == null || intheader.length < nintheader) {
            throw new RuntimeException("Parameter intheader is null or less that specified length of " + nintheader);
        }
        if (ncompheader != 0 && (compheader == null || compheader.length < ncompheader)) {
            throw new RuntimeException("Parameter compheader is null or less that specified length of " + ncompheader);
        }
        if (nuserheader != 0 && (userheader == null || userheader.length < nuserheader)) {
            throw new RuntimeException("Parameter userheader is null or less that specified length of " + nuserheader);
        }
        if (data == null || data.length < ndata) {
            throw new RuntimeException("Parameter data is null or less that specified length of " + ndata);
        }
        if (status == null || status.length == 0) {
            throw new RuntimeException("Parameter status is null or zero-length");
        }
        if (found == null || found.length == 0) {
            throw new RuntimeException("Parameter found is null or zero-length");
        }
        Heclib.Hec_zwritxBytes(ifltab, pathname, nPathname, intheader, nintheader, compheader, ncompheader, userheader, nuserheader, data, ndata, type, plan, status, found);
    }

    public static void zmessage(int[] ifltab, String message) {
        if (ifltab == null || ifltab.length == 0) {
            throw new RuntimeException("Parameter ifltab is null or zero-length");
        }
        if (message == null) {
            throw new RuntimeException("Parameter message is null");
        }
        Heclib.Hec_zmessage(ifltab, message);
    }

    static {
        SUPPORTED_LIBRARY_VERSION = new HeclibVersionInfo("7-IU");
        onWindows = System.getProperty("os.name", "").startsWith("Windows");
        logger = Logger.getLogger(Heclib.class.getName());
        String libraryName = "javaHeclib";
        String libraryFilename = System.mapLibraryName(libraryName);
        try {
            System.loadLibrary(libraryName);
            stringContainer sc = new stringContainer();
            int[] iver = new int[1];
            Heclib.zquery("vers", sc, iver);
            versionInfo = new HeclibVersionInfo(sc.string);
            logger.fine(String.format("Using library %s, version %s", libraryFilename, sc.string));
            if (versionInfo.getLibraryVersion() < SUPPORTED_LIBRARY_VERSION.getLibraryVersion()) {
                String message = String.format("The library %s (version %s) is not compatible with this version of Heclib(java). Please update to the version %s or higher.", libraryFilename, versionInfo.getVersionString(), SUPPORTED_LIBRARY_VERSION);
                logger.severe(message);
                throw new RuntimeException(message);
            }
        }
        catch (UnsatisfiedLinkError e) {
            String libraryPath = System.getProperty("java.library.path");
            logger.severe(String.format("No %s in %s", libraryFilename, libraryPath));
            e.printStackTrace();
            throw e;
        }
        HashMap<Integer, String> _functionNames = new HashMap<Integer, String>();
        _functionNames.put(1, "DSS_FUNCTION_zopen_ID");
        _functionNames.put(2, "DSS_FUNCTION_zclose_ID");
        _functionNames.put(3, "DSS_FUNCTION_zset_ID");
        _functionNames.put(4, "DSS_FUNCTION_zget_ID");
        _functionNames.put(5, "DSS_FUNCTION_zput_ID");
        _functionNames.put(6, "DSS_FUNCTION_zgetBuff_ID");
        _functionNames.put(7, "DSS_FUNCTION_zputBuff_ID");
        _functionNames.put(8, "DSS_FUNCTION_zmemoryGet_ID");
        _functionNames.put(9, "DSS_FUNCTION_zmemoryFree_ID");
        _functionNames.put(10, "DSS_FUNCTION_zreadDisk_ID");
        _functionNames.put(11, "DSS_FUNCTION_zwriteDisk_ID");
        _functionNames.put(12, "DSS_FUNCTION_zpermRead_ID");
        _functionNames.put(13, "DSS_FUNCTION_zpermCreate_ID");
        _functionNames.put(14, "DSS_FUNCTION_zpermWrite_ID");
        _functionNames.put(15, "DSS_FUNCTION_zwriteEOF_ID");
        _functionNames.put(16, "DSS_FUNCTION_zinit_ID");
        _functionNames.put(17, "DSS_FUNCTION_zinitIfltab_ID");
        _functionNames.put(18, "DSS_FUNCTION_zlocking_ID");
        _functionNames.put(19, "DSS_FUNCTION_znewFileSize_ID");
        _functionNames.put(20, "DSS_FUNCTION_zgetFileSpace_ID");
        _functionNames.put(21, "DSS_FUNCTION_zcheckKeys_ID");
        _functionNames.put(22, "DSS_FUNCTION_zflushToDisk_ID");
        _functionNames.put(23, "DSS_FUNCTION_zhash_ID");
        _functionNames.put(24, "DSS_FUNCTION_zcheck_ID");
        _functionNames.put(25, "DSS_FUNCTION_zreadInfo_ID");
        _functionNames.put(26, "DSS_FUNCTION_zcheckMultiUser_ID");
        _functionNames.put(27, "DSS_FUNCTION_zreadInternal_ID");
        _functionNames.put(28, "DSS_FUNCTION_zwriteInternal_ID");
        _functionNames.put(29, "DSS_FUNCTION_zwriteNew_ID");
        _functionNames.put(30, "DSS_FUNCTION_zwriteExisting_ID");
        _functionNames.put(31, "DSS_FUNCTION_zbinNew_ID");
        _functionNames.put(32, "DSS_FUNCTION_zbinUpdate_ID");
        _functionNames.put(33, "DSS_FUNCTION_zsetFile_ID");
        _functionNames.put(34, "DSS_FUNCTION_zquery_ID");
        _functionNames.put(35, "DSS_FUNCTION_zdelete_ID");
        _functionNames.put(36, "DSS_FUNCTION_zundelete_ID");
        _functionNames.put(37, "DSS_FUNCTION_zcopyFile_ID");
        _functionNames.put(38, "DSS_FUNCTION_ztsStoreReg_ID");
        _functionNames.put(39, "DSS_FUNCTION_ztsRegStoreBlock_ID");
        _functionNames.put(40, "DSS_FUNCTION_ztsStore_ID");
        _functionNames.put(41, "DSS_FUNCTION_ztsRetrieve_ID");
        _functionNames.put(42, "DSS_FUNCTION_ztsRetrieveReg_ID");
        _functionNames.put(43, "DSS_FUNCTION_ztsRegReadBlock_ID");
        _functionNames.put(44, "DSS_FUNCTION_ztsWriteBlock_ID");
        _functionNames.put(45, "DSS_FUNCTION_ztsTrim_ID");
        _functionNames.put(46, "DSS_FUNCTION_ztsStoreIrreg_ID");
        _functionNames.put(47, "DSS_FUNCTION_ztsIrregReadBlock_ID");
        _functionNames.put(48, "DSS_FUNCTION_ztsIrregMergeBlocks_ID");
        _functionNames.put(49, "DSS_FUNCTION_ztsRetrieveIrreg_ID");
        _functionNames.put(50, "DSS_FUNCTION_ztsIrregStoreBlock_ID");
        _functionNames.put(51, "DSS_FUNCTION_ztsProcessTimes_ID");
        _functionNames.put(52, "DSS_FUNCTION_zcatalog_ID");
        _functionNames.put(53, "DSS_FUNCTION_zpdStore_ID");
        _functionNames.put(54, "DSS_FUNCTION_zpdRetrieve_ID");
        _functionNames.put(55, "DSS_FUNCTION_zinquire_ID");
        _functionNames.put(56, "DSS_FUNCTION_zsqueeze_ID");
        _functionNames.put(57, "DSS_FUNCTION_ztextStore_ID");
        _functionNames.put(58, "DSS_FUNCTION_ztextRetrieve_ID");
        _functionNames.put(59, "DSS_FUNCTION_zcopyRecord_ID");
        _functionNames.put(60, "DSS_FUNCTION_zrename_ID");
        _functionNames.put(61, "DSS_FUNCTION_zduplicateRecord_ID");
        _functionNames.put(62, "DSS_FUNCTION_zarrayRetrieve_ID");
        _functionNames.put(63, "DSS_FUNCTION_zarrayStore_ID");
        _functionNames.put(64, "DSS_FUNCTION_zbinaryStore_ID");
        _functionNames.put(65, "DSS_FUNCTION_zbinaryRetrieve_ID");
        _functionNames.put(66, "DSS_FUNCTION_zcheckHashTable_ID");
        _functionNames.put(67, "DSS_FUNCTION_zcheckInfo_ID");
        _functionNames.put(68, "DSS_FUNCTION_zcheckLinks_ID");
        _functionNames.put(69, "DSS_FUNCTION_zcheckPathnameBins_ID");
        _functionNames.put(70, "DSS_FUNCTION_zcheckPathnames_ID");
        _functionNames.put(71, "DSS_FUNCTION_zspatialTinStore_ID");
        _functionNames.put(72, "DSS_FUNCTION_zspatialTinRetrieve_ID");
        _functionNames.put(73, "DSS_FUNCTION_zaliasAdd_ID");
        _functionNames.put(74, "DSS_FUNCTION_zaliasRemove_ID");
        _functionNames.put(75, "DSS_FUNCTION_zaliasUtil_ID");
        _functionNames.put(76, "DSS_FUNCTION_zlocationStore_ID");
        _functionNames.put(77, "DSS_FUNCTION_zlocationRetrieve_ID");
        _functionNames.put(78, "DSS_FUNCTION_zread_ID");
        _functionNames.put(79, "DSS_FUNCTION_zwrite_ID");
        _functionNames.put(80, "DSS_FUNCTION_internalUtility_ID");
        _functionNames.put(81, "DSS_FUNCTION_ztsAggregate_ID");
        _functionNames.put(82, "DSS_FUNCTION_ztsDisaggregate_ID");
        _functionNames.put(83, "DSS_FUNCTION_zspatialGridStore_ID");
        _functionNames.put(84, "DSS_FUNCTION_zspatialGridRetrieve_ID");
        _functionNames.put(86, "DSS_FUNCTION_javaNativeInterface_ID");
        _functionNames.put(85, "DSS_FUNCTION_other_ID");
        functionNames = Collections.unmodifiableMap(_functionNames);
        HashMap<Integer, String> _dssErrorNames = new HashMap<Integer, String>();
        _dssErrorNames.put(0, "STATUS_OK");
        _dssErrorNames.put(1, "INVALID_FILE_VERSION");
        _dssErrorNames.put(2, "INCOMPATIBLE_VERSION");
        _dssErrorNames.put(3, "INCOMPATIBLE_VERSION_6");
        _dssErrorNames.put(4, "INVALID_FILE_NAME");
        _dssErrorNames.put(5, "NO_EXCLUSIVE_ACCESS");
        _dssErrorNames.put(6, "UNABLE_TO_ACCESS_FILE");
        _dssErrorNames.put(7, "UNABLE_TO_WRITE_FILE");
        _dssErrorNames.put(8, "UNABLE_TO_CREATE_FILE");
        _dssErrorNames.put(9, "NO_WRITE_PERMISSION");
        _dssErrorNames.put(10, "NO_PERMISSION");
        _dssErrorNames.put(11, "WRITE_ON_READ_ONLY");
        _dssErrorNames.put(12, "INVALID_DSS_FILE");
        _dssErrorNames.put(13, "INVALID_ADDRESS");
        _dssErrorNames.put(14, "INVALID_NUMBER_TO_READ");
        _dssErrorNames.put(15, "INVALID_NUMBER_TO_WRITE");
        _dssErrorNames.put(16, "WRITE_ERROR");
        _dssErrorNames.put(17, "READ_ERROR");
        _dssErrorNames.put(18, "READ_BEYOND_EOF");
        _dssErrorNames.put(19, "INVALID_FILE_HEADER");
        _dssErrorNames.put(20, "TRUNCATED_FILE");
        _dssErrorNames.put(21, "INVALID_HEADER_PARAMETER");
        _dssErrorNames.put(22, "DAMAGED_FILE");
        _dssErrorNames.put(23, "CLOSED_FILE");
        _dssErrorNames.put(24, "EMPTY_FILE");
        _dssErrorNames.put(25, "IFLTAB_CORRUPT");
        _dssErrorNames.put(26, "KEY_CORRUPT");
        _dssErrorNames.put(27, "KEY_VALUE");
        _dssErrorNames.put(28, "KEY3_LOCATION");
        _dssErrorNames.put(29, "CANNOT_LOCK_FILE");
        _dssErrorNames.put(30, "CANNOT_LOCK_EXCLUSIVE");
        _dssErrorNames.put(31, "CANNOT_LOCK_MULTI_USER");
        _dssErrorNames.put(32, "CANNOT_SQUEEZE");
        _dssErrorNames.put(33, "INVALID_BIN_STATUS");
        _dssErrorNames.put(34, "CANNOT_ALLOCATE_MEMORY");
        _dssErrorNames.put(35, "INVALID_PARAMETER");
        _dssErrorNames.put(36, "INVALID_NUMBER");
        _dssErrorNames.put(37, "INCOMPATIBLE_CALL");
        _dssErrorNames.put(38, "NON_EMPTY_FILE");
        _dssErrorNames.put(39, "BIN_SIZE_CONFLICT");
        _dssErrorNames.put(40, "DIFFERENT_RECORD_TYPE");
        _dssErrorNames.put(41, "WRONG_RECORD_TYPE");
        _dssErrorNames.put(42, "NO_UNDELETE_WITH_RECLAIM");
        _dssErrorNames.put(43, "ARRAY_SPACE_EXHAUSTED");
        _dssErrorNames.put(44, "BOTH_NOTE_KINDS_USED");
        _dssErrorNames.put(45, "NO_DATA_GIVEN");
        _dssErrorNames.put(46, "NO_DATA_READ");
        _dssErrorNames.put(47, "NO_TIME_WINDOW");
        _dssErrorNames.put(48, "INVALID_DATE_TIME");
        _dssErrorNames.put(49, "INVALID_INTERVAL");
        _dssErrorNames.put(50, "TIMES_NOT_ASCENDING");
        _dssErrorNames.put(51, "DIFFERENT_PROFILE_NUMBER");
        _dssErrorNames.put(52, "RECORD_DOES_NOT_EXIST");
        _dssErrorNames.put(53, "RECORD_ALREADY_EXISTS");
        _dssErrorNames.put(54, "INVALID_PATHNAME");
        _dssErrorNames.put(55, "INVALID_RECORD_HEADER");
        _dssErrorNames.put(56, "ARRAY_TOO_SMALL");
        _dssErrorNames.put(57, "NOT_OPENED");
        _dssErrorNames.put(58, "FILE_DOES_NOT_EXIST");
        _dssErrorNames.put(59, "FILE_EXISTS");
        _dssErrorNames.put(60, "NULL_PATHNAME");
        _dssErrorNames.put(61, "NULL_FILENAME");
        _dssErrorNames.put(62, "NULL_ARGUMENT");
        _dssErrorNames.put(63, "NULL_ARRAY");
        _dssErrorNames.put(64, "VERTICAL_DATUM_ERROR");
        _dssErrorNames.put(65, "INVALID_F_PART_TAGS");
        _dssErrorNames.put(66, "UNDEFINED_ERROR");
        dssErrorNames = Collections.unmodifiableMap(_dssErrorNames);
        HashMap<Integer, String> _messageLevels = new HashMap<Integer, String>();
        _messageLevels.put(0, "MESS_LEVEL_NONE");
        _messageLevels.put(1, "MESS_LEVEL_CRITICAL");
        _messageLevels.put(2, "MESS_LEVEL_TERSE");
        _messageLevels.put(3, "MESS_LEVEL_GENERAL");
        _messageLevels.put(4, "MESS_LEVEL_USER_DIAG");
        _messageLevels.put(5, "MESS_LEVEL_INTERNAL_DIAG_1");
        _messageLevels.put(6, "MESS_LEVEL_INTERNAL_DIAG_2");
        messageLevels = Collections.unmodifiableMap(_messageLevels);
        HashMap<Integer, Integer> _messageFunctionGroups = new HashMap<Integer, Integer>();
        _messageFunctionGroups.put(1, 7);
        _messageFunctionGroups.put(2, 7);
        _messageFunctionGroups.put(3, 3);
        _messageFunctionGroups.put(4, 2);
        _messageFunctionGroups.put(5, 3);
        _messageFunctionGroups.put(6, 2);
        _messageFunctionGroups.put(7, 3);
        _messageFunctionGroups.put(8, 2);
        _messageFunctionGroups.put(9, 1);
        _messageFunctionGroups.put(10, 4);
        _messageFunctionGroups.put(11, 5);
        _messageFunctionGroups.put(12, 6);
        _messageFunctionGroups.put(13, 6);
        _messageFunctionGroups.put(14, 6);
        _messageFunctionGroups.put(15, 5);
        _messageFunctionGroups.put(16, 1);
        _messageFunctionGroups.put(17, 1);
        _messageFunctionGroups.put(18, 9);
        _messageFunctionGroups.put(19, 1);
        _messageFunctionGroups.put(20, 1);
        _messageFunctionGroups.put(21, 8);
        _messageFunctionGroups.put(22, 5);
        _messageFunctionGroups.put(23, 1);
        _messageFunctionGroups.put(24, 8);
        _messageFunctionGroups.put(25, 4);
        _messageFunctionGroups.put(26, 8);
        _messageFunctionGroups.put(27, 4);
        _messageFunctionGroups.put(28, 5);
        _messageFunctionGroups.put(29, 5);
        _messageFunctionGroups.put(30, 5);
        _messageFunctionGroups.put(31, 1);
        _messageFunctionGroups.put(32, 1);
        _messageFunctionGroups.put(33, 1);
        _messageFunctionGroups.put(34, 1);
        _messageFunctionGroups.put(35, 1);
        _messageFunctionGroups.put(36, 1);
        _messageFunctionGroups.put(37, 13);
        _messageFunctionGroups.put(38, 11);
        _messageFunctionGroups.put(39, 11);
        _messageFunctionGroups.put(40, 11);
        _messageFunctionGroups.put(41, 10);
        _messageFunctionGroups.put(42, 10);
        _messageFunctionGroups.put(43, 10);
        _messageFunctionGroups.put(44, 11);
        _messageFunctionGroups.put(45, 1);
        _messageFunctionGroups.put(46, 11);
        _messageFunctionGroups.put(47, 10);
        _messageFunctionGroups.put(48, 1);
        _messageFunctionGroups.put(49, 10);
        _messageFunctionGroups.put(50, 11);
        _messageFunctionGroups.put(51, 1);
        _messageFunctionGroups.put(52, 15);
        _messageFunctionGroups.put(53, 5);
        _messageFunctionGroups.put(54, 4);
        _messageFunctionGroups.put(55, 1);
        _messageFunctionGroups.put(56, 14);
        _messageFunctionGroups.put(57, 5);
        _messageFunctionGroups.put(58, 4);
        _messageFunctionGroups.put(59, 13);
        _messageFunctionGroups.put(60, 14);
        _messageFunctionGroups.put(61, 13);
        _messageFunctionGroups.put(62, 4);
        _messageFunctionGroups.put(63, 5);
        _messageFunctionGroups.put(64, 5);
        _messageFunctionGroups.put(65, 4);
        _messageFunctionGroups.put(66, 16);
        _messageFunctionGroups.put(67, 16);
        _messageFunctionGroups.put(68, 16);
        _messageFunctionGroups.put(69, 16);
        _messageFunctionGroups.put(70, 16);
        _messageFunctionGroups.put(71, 5);
        _messageFunctionGroups.put(72, 4);
        _messageFunctionGroups.put(73, 12);
        _messageFunctionGroups.put(74, 12);
        _messageFunctionGroups.put(75, 12);
        _messageFunctionGroups.put(76, 5);
        _messageFunctionGroups.put(77, 4);
        _messageFunctionGroups.put(78, 4);
        _messageFunctionGroups.put(79, 5);
        _messageFunctionGroups.put(80, 14);
        _messageFunctionGroups.put(81, 1);
        _messageFunctionGroups.put(82, 1);
        _messageFunctionGroups.put(83, 5);
        _messageFunctionGroups.put(84, 4);
        _messageFunctionGroups.put(85, 18);
        messageFunctionGroups = Collections.unmodifiableMap(_messageFunctionGroups);
        String timeZoneNameToUse = null;
        HashMap<String, String> windowsTimeZoneMap = null;
        if (onWindows) {
            windowsTimeZoneMap = new HashMap<String, String>();
            windowsTimeZoneMap.put("AUS Central Standard Time", "Australia/Darwin");
            windowsTimeZoneMap.put("AUS Eastern Standard Time", "Australia/Sydney");
            windowsTimeZoneMap.put("Afghanistan Standard Time", "Asia/Kabul");
            windowsTimeZoneMap.put("Alaskan Standard Time", "America/Anchorage");
            windowsTimeZoneMap.put("Aleutian Standard Time", "America/Adak");
            windowsTimeZoneMap.put("Altai Standard Time", "Asia/Barnaul");
            windowsTimeZoneMap.put("Arab Standard Time", "Asia/Riyadh");
            windowsTimeZoneMap.put("Arabian Standard Time", "Asia/Dubai");
            windowsTimeZoneMap.put("Arabic Standard Time", "Asia/Baghdad");
            windowsTimeZoneMap.put("Argentina Standard Time", "America/Buenos_Aires");
            windowsTimeZoneMap.put("Astrakhan Standard Time", "Europe/Astrakhan");
            windowsTimeZoneMap.put("Atlantic Standard Time", "America/Halifax");
            windowsTimeZoneMap.put("Aus Central W. Standard Time", "Australia/Eucla");
            windowsTimeZoneMap.put("Azerbaijan Standard Time", "Asia/Baku");
            windowsTimeZoneMap.put("Azores Standard Time", "Atlantic/Azores");
            windowsTimeZoneMap.put("Bahia Standard Time", "America/Bahia");
            windowsTimeZoneMap.put("Bangladesh Standard Time", "Asia/Dhaka");
            windowsTimeZoneMap.put("Belarus Standard Time", "Europe/Minsk");
            windowsTimeZoneMap.put("Bougainville Standard Time", "Pacific/Bougainville");
            windowsTimeZoneMap.put("Canada Central Standard Time", "America/Regina");
            windowsTimeZoneMap.put("Cape Verde Standard Time", "Atlantic/Cape_Verde");
            windowsTimeZoneMap.put("Caucasus Standard Time", "Asia/Yerevan");
            windowsTimeZoneMap.put("Cen. Australia Standard Time", "Australia/Adelaide");
            windowsTimeZoneMap.put("Central America Standard Time", "America/Guatemala");
            windowsTimeZoneMap.put("Central Asia Standard Time", "Asia/Almaty");
            windowsTimeZoneMap.put("Central Brazilian Standard Time", "America/Cuiaba");
            windowsTimeZoneMap.put("Central Europe Standard Time", "Europe/Budapest");
            windowsTimeZoneMap.put("Central European Standard Time", "Europe/Warsaw");
            windowsTimeZoneMap.put("Central Pacific Standard Time", "Pacific/Guadalcanal");
            windowsTimeZoneMap.put("Central Standard Time", "America/Chicago");
            windowsTimeZoneMap.put("Central Standard Time (Mexico)", "America/Mexico_City");
            windowsTimeZoneMap.put("Chatham Islands Standard Time", "Pacific/Chatham");
            windowsTimeZoneMap.put("China Standard Time", "Asia/Shanghai");
            windowsTimeZoneMap.put("Cuba Standard Time", "America/Havana");
            windowsTimeZoneMap.put("Dateline Standard Time", "Etc/GMT+12");
            windowsTimeZoneMap.put("E. Africa Standard Time", "Africa/Nairobi");
            windowsTimeZoneMap.put("E. Australia Standard Time", "Australia/Brisbane");
            windowsTimeZoneMap.put("E. Europe Standard Time", "Europe/Chisinau");
            windowsTimeZoneMap.put("E. South America Standard Time", "America/Sao_Paulo");
            windowsTimeZoneMap.put("Easter Island Standard Time", "Pacific/Easter");
            windowsTimeZoneMap.put("Eastern Standard Time", "America/New_York");
            windowsTimeZoneMap.put("Eastern Standard Time (Mexico)", "America/Cancun");
            windowsTimeZoneMap.put("Egypt Standard Time", "Africa/Cairo");
            windowsTimeZoneMap.put("Ekaterinburg Standard Time", "Asia/Yekaterinburg");
            windowsTimeZoneMap.put("FLE Standard Time", "Europe/Kiev");
            windowsTimeZoneMap.put("Fiji Standard Time", "Pacific/Fiji");
            windowsTimeZoneMap.put("GMT Standard Time", "Europe/London");
            windowsTimeZoneMap.put("GTB Standard Time", "Europe/Bucharest");
            windowsTimeZoneMap.put("Georgian Standard Time", "Asia/Tbilisi");
            windowsTimeZoneMap.put("Greenland Standard Time", "America/Godthab");
            windowsTimeZoneMap.put("Greenwich Standard Time", "Atlantic/Reykjavik");
            windowsTimeZoneMap.put("Haiti Standard Time", "America/Port-au-Prince");
            windowsTimeZoneMap.put("Hawaiian Standard Time", "Pacific/Honolulu");
            windowsTimeZoneMap.put("India Standard Time", "Asia/Calcutta");
            windowsTimeZoneMap.put("Iran Standard Time", "Asia/Tehran");
            windowsTimeZoneMap.put("Israel Standard Time", "Asia/Jerusalem");
            windowsTimeZoneMap.put("Jordan Standard Time", "Asia/Amman");
            windowsTimeZoneMap.put("Kaliningrad Standard Time", "Europe/Kaliningrad");
            windowsTimeZoneMap.put("Korea Standard Time", "Asia/Seoul");
            windowsTimeZoneMap.put("Libya Standard Time", "Africa/Tripoli");
            windowsTimeZoneMap.put("Line Islands Standard Time", "Pacific/Kiritimati");
            windowsTimeZoneMap.put("Lord Howe Standard Time", "Australia/Lord_Howe");
            windowsTimeZoneMap.put("Magadan Standard Time", "Asia/Magadan");
            windowsTimeZoneMap.put("Magallanes Standard Time", "America/Punta_Arenas");
            windowsTimeZoneMap.put("Marquesas Standard Time", "Pacific/Marquesas");
            windowsTimeZoneMap.put("Mauritius Standard Time", "Indian/Mauritius");
            windowsTimeZoneMap.put("Middle East Standard Time", "Asia/Beirut");
            windowsTimeZoneMap.put("Montevideo Standard Time", "America/Montevideo");
            windowsTimeZoneMap.put("Morocco Standard Time", "Africa/Casablanca");
            windowsTimeZoneMap.put("Mountain Standard Time", "America/Denver");
            windowsTimeZoneMap.put("Mountain Standard Time (Mexico)", "America/Mazatlan");
            windowsTimeZoneMap.put("Myanmar Standard Time", "Asia/Rangoon");
            windowsTimeZoneMap.put("N. Central Asia Standard Time", "Asia/Novosibirsk");
            windowsTimeZoneMap.put("Namibia Standard Time", "Africa/Windhoek");
            windowsTimeZoneMap.put("Nepal Standard Time", "Asia/Katmandu");
            windowsTimeZoneMap.put("New Zealand Standard Time", "Pacific/Auckland");
            windowsTimeZoneMap.put("Newfoundland Standard Time", "America/St_Johns");
            windowsTimeZoneMap.put("Norfolk Standard Time", "Pacific/Norfolk");
            windowsTimeZoneMap.put("North Asia East Standard Time", "Asia/Irkutsk");
            windowsTimeZoneMap.put("North Asia Standard Time", "Asia/Krasnoyarsk");
            windowsTimeZoneMap.put("North Korea Standard Time", "Asia/Pyongyang");
            windowsTimeZoneMap.put("Omsk Standard Time", "Asia/Omsk");
            windowsTimeZoneMap.put("Pacific SA Standard Time", "America/Santiago");
            windowsTimeZoneMap.put("Pacific Standard Time", "America/Los_Angeles");
            windowsTimeZoneMap.put("Pacific Standard Time (Mexico)", "America/Tijuana");
            windowsTimeZoneMap.put("Pakistan Standard Time", "Asia/Karachi");
            windowsTimeZoneMap.put("Paraguay Standard Time", "America/Asuncion");
            windowsTimeZoneMap.put("Qyzylorda Standard Time", "Asia/Qyzylorda");
            windowsTimeZoneMap.put("Romance Standard Time", "Europe/Paris");
            windowsTimeZoneMap.put("Russia Time Zone 10", "Asia/Srednekolymsk");
            windowsTimeZoneMap.put("Russia Time Zone 11", "Asia/Kamchatka");
            windowsTimeZoneMap.put("Russia Time Zone 3", "Europe/Samara");
            windowsTimeZoneMap.put("Russian Standard Time", "Europe/Moscow");
            windowsTimeZoneMap.put("SA Eastern Standard Time", "America/Cayenne");
            windowsTimeZoneMap.put("SA Pacific Standard Time", "America/Bogota");
            windowsTimeZoneMap.put("SA Western Standard Time", "America/La_Paz");
            windowsTimeZoneMap.put("SE Asia Standard Time", "Asia/Bangkok");
            windowsTimeZoneMap.put("Saint Pierre Standard Time", "America/Miquelon");
            windowsTimeZoneMap.put("Sakhalin Standard Time", "Asia/Sakhalin");
            windowsTimeZoneMap.put("Samoa Standard Time", "Pacific/Apia");
            windowsTimeZoneMap.put("Sao Tome Standard Time", "Africa/Sao_Tome");
            windowsTimeZoneMap.put("Saratov Standard Time", "Europe/Saratov");
            windowsTimeZoneMap.put("Singapore Standard Time", "Asia/Singapore");
            windowsTimeZoneMap.put("South Africa Standard Time", "Africa/Johannesburg");
            windowsTimeZoneMap.put("South Sudan Standard Time", "Africa/Juba");
            windowsTimeZoneMap.put("Sri Lanka Standard Time", "Asia/Colombo");
            windowsTimeZoneMap.put("Sudan Standard Time", "Africa/Khartoum");
            windowsTimeZoneMap.put("Syria Standard Time", "Asia/Damascus");
            windowsTimeZoneMap.put("Taipei Standard Time", "Asia/Taipei");
            windowsTimeZoneMap.put("Tasmania Standard Time", "Australia/Hobart");
            windowsTimeZoneMap.put("Tocantins Standard Time", "America/Araguaina");
            windowsTimeZoneMap.put("Tokyo Standard Time", "Asia/Tokyo");
            windowsTimeZoneMap.put("Tomsk Standard Time", "Asia/Tomsk");
            windowsTimeZoneMap.put("Tonga Standard Time", "Pacific/Tongatapu");
            windowsTimeZoneMap.put("Transbaikal Standard Time", "Asia/Chita");
            windowsTimeZoneMap.put("Turkey Standard Time", "Europe/Istanbul");
            windowsTimeZoneMap.put("Turks And Caicos Standard Time", "America/Grand_Turk");
            windowsTimeZoneMap.put("US Eastern Standard Time", "America/Indianapolis");
            windowsTimeZoneMap.put("US Mountain Standard Time", "America/Phoenix");
            windowsTimeZoneMap.put("UTC", "Etc/UTC");
            windowsTimeZoneMap.put("UTC+12", "Etc/GMT-12");
            windowsTimeZoneMap.put("UTC+13", "Etc/GMT-13");
            windowsTimeZoneMap.put("UTC-02", "Etc/GMT+2");
            windowsTimeZoneMap.put("UTC-08", "Etc/GMT+8");
            windowsTimeZoneMap.put("UTC-09", "Etc/GMT+9");
            windowsTimeZoneMap.put("UTC-11", "Etc/GMT+11");
            windowsTimeZoneMap.put("Ulaanbaatar Standard Time", "Asia/Ulaanbaatar");
            windowsTimeZoneMap.put("Venezuela Standard Time", "America/Caracas");
            windowsTimeZoneMap.put("Vladivostok Standard Time", "Asia/Vladivostok");
            windowsTimeZoneMap.put("Volgograd Standard Time", "Europe/Volgograd");
            windowsTimeZoneMap.put("W. Australia Standard Time", "Australia/Perth");
            windowsTimeZoneMap.put("W. Central Africa Standard Time", "Africa/Lagos");
            windowsTimeZoneMap.put("W. Europe Standard Time", "Europe/Berlin");
            windowsTimeZoneMap.put("W. Mongolia Standard Time", "Asia/Hovd");
            windowsTimeZoneMap.put("West Asia Standard Time", "Asia/Tashkent");
            windowsTimeZoneMap.put("West Bank Standard Time", "Asia/Hebron");
            windowsTimeZoneMap.put("West Pacific Standard Time", "Pacific/Port_Moresby");
            windowsTimeZoneMap.put("Yakutsk Standard Time", "Asia/Yakutsk");
            windowsTimeZoneMap.put("Yukon Standard Time", "America/Whitehorse");
        }
        try {
            ArrayList<String> commands = new ArrayList<String>();
            if (onWindows) {
                commands.add("tzutil /g");
            } else {
                commands.add("/bin/sh");
                commands.add("-c");
                commands.add("ls -l /etc/localtime | sed \"s:.*zoneinfo/::\"");
            }
            Process p = Runtime.getRuntime().exec(commands.toArray(new String[0]));
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            timeZoneNameToUse = br.readLine();
            br.close();
            p.destroy();
            if (onWindows) {
                timeZoneNameToUse = windowsTimeZoneMap.containsKey(timeZoneNameToUse) ? (String)windowsTimeZoneMap.get(timeZoneNameToUse) : null;
            }
        }
        catch (IOException e) {
            timeZoneNameToUse = null;
        }
        if (timeZoneNameToUse == null) {
            timeZoneNameToUse = System.getProperty("user.timezone");
        }
        if (timeZoneNameToUse == null) {
            timeZoneNameToUse = ZoneId.systemDefault().getId();
        }
        sysTimeZoneName = timeZoneNameToUse;
    }
}

