/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.util;

public class HeclibVersionInfo {
    private final int major;
    private final int sub;
    private final int minor;
    private final int libraryVersion;
    private final String versionString;

    public HeclibVersionInfo(String version) {
        String expression = "(\\d)-([A-Za-z]{2})";
        this.versionString = version;
        if (!version.matches(expression)) {
            this.libraryVersion = 0;
            this.minor = 0;
            this.sub = 0;
            this.major = 0;
        } else {
            this.major = Integer.parseInt(version.substring(0, 1));
            this.sub = HeclibVersionInfo.getVersFromChar(version.charAt(2));
            this.minor = HeclibVersionInfo.getVersFromChar(version.charAt(3));
            this.libraryVersion = this.major * 10000 + this.sub * 100 + this.minor;
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getSub() {
        return this.sub;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getLibraryVersion() {
        return this.libraryVersion;
    }

    private static char getVersChar(int vers) {
        if (vers < 1 || vers > 52) {
            return '@';
        }
        if (vers < 27) {
            return (char)(vers + 64);
        }
        char c2 = (char)(vers - 26 + 96);
        return c2;
    }

    private static int getVersFromChar(char version) {
        int iver = 0;
        if (version < 'A') {
            return 0;
        }
        if (version < '[') {
            iver = version - 64;
        }
        if (version > '[') {
            iver = version - 96 + 26;
        }
        return iver;
    }

    public static String getVersionString(int numericVersion) {
        int major = numericVersion / 10000;
        int sub = (numericVersion - 10000 * major) / 100;
        int minor = numericVersion % 100;
        return String.format("%d-%c%c", major, Character.valueOf(HeclibVersionInfo.getVersChar(sub)), Character.valueOf(HeclibVersionInfo.getVersChar(minor)));
    }

    public String getVersionString() {
        return this.versionString;
    }
}

