/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.util;

import hec.io.Identifier;
import hec.lang.ClientAppCheck;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.util.RMAIO;
import rma.util.RpnFunction;

public class Unit
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(Unit.class.getName());
    public static final String UNDEF = "undef";
    public static final int UNDEF_ID = 0;
    public static final String SI = "SI";
    public static final int SI_ID = 2;
    public static final String ENGLISH = "English";
    public static final int ENGLISH_ID = 1;
    public static final int AS_STORED_ID = 3;
    public static final String AS_STORED = "As Stored";
    public static final String FILEPATH = "config/db/definitions/unitConversions.def";
    public static final String FILEURL = "hec/heclib/util/unitConversions.def";
    private static final NavigableMap<String, NavigableSet<String>> _unitMap = new TreeMap<String, NavigableSet<String>>();
    private static final Map<String, Map<String, ConvFunction>> _unitConvFrom = new HashMap<String, Map<String, ConvFunction>>();
    private static final Map<String, String> _aliasToUnitMap = new HashMap<String, String>();

    public static String[] getUnitSystems() {
        Set unitSystems = _unitMap.keySet();
        String[] retval = new String[unitSystems.size()];
        unitSystems.toArray(retval);
        return retval;
    }

    public static Hashtable<String, String> getUnitsAliasTable() {
        Hashtable<String, String> retval = new Hashtable<String, String>();
        retval.putAll(_aliasToUnitMap);
        return retval;
    }

    public static String[] getUnitTypes() {
        TreeSet unitTypes = new TreeSet();
        _unitMap.forEach((unitSystem, unitSet) -> unitTypes.addAll(unitSet));
        String[] retval = new String[unitTypes.size()];
        unitTypes.toArray(retval);
        return retval;
    }

    public static String[] getUnitsForSystem(String forSys) {
        NavigableSet systemUnits = _unitMap.getOrDefault(forSys, new TreeSet());
        String[] retval = new String[systemUnits.size()];
        systemUnits.toArray(retval);
        return retval;
    }

    public static String[] getUnitsToConvertTo(String fromSys, String fromUnit) {
        UnitType ut = new UnitType(fromSys, fromUnit);
        NavigableSet<String> utTo = Unit.getUnitsToConvertTo(ut);
        String[] retArray = new String[utTo.size()];
        utTo.toArray(retArray);
        return retArray;
    }

    public static RpnFunction getConvFunction(String fromSys, String fromId, String toSys, String toId) {
        UnitType fromUt = new UnitType(fromSys, fromId);
        UnitType toUt = new UnitType(toSys, toId);
        return Unit.getConvFunction(fromUt, toUt);
    }

    public static void load() {
        boolean loadedUnits = false;
        StringBuilder attemptedFilePaths = new StringBuilder();
        int failedCount = 1;
        if (ClientAppCheck.haveClientApp()) {
            Identifier id = null;
            try {
                id = Unit.downloadParameterFile();
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.log(Level.FINE, "Error downloading Parameter file. ", e);
            }
            if (id != null) {
                attemptedFilePaths.append(failedCount++).append(": ").append(id.getPath() + "\n");
                loadedUnits = Unit.loadFromFile(id.getPath());
            } else {
                attemptedFilePaths.append(failedCount++).append(": ").append("Server does not have unitConversion.def file\n");
            }
        }
        if (!loadedUnits) {
            String systemHome = RMAIO.getSystemHomeDirectory();
            if (systemHome != null && systemHome.length() > 0) {
                StringBuilder sb = new StringBuilder(systemHome);
                if (sb.charAt(sb.length() - 1) != '/') {
                    sb.append('/');
                }
                sb.append(FILEPATH);
                attemptedFilePaths.append(failedCount++).append(": ").append(sb.toString() + "\n");
                loadedUnits = Unit.loadFromFile(sb.toString());
            } else {
                attemptedFilePaths.append(failedCount++).append(": ").append("CWMS_HOME undefined will look in heclib.jar file.\n");
            }
        }
        if (!loadedUnits) {
            attemptedFilePaths.append(failedCount++).append(": ").append(FILEURL);
            loadedUnits = Unit.loadFromUrl(FILEURL);
        }
        if (!loadedUnits) {
            String unableToLoadMessage = "Could not load unit definition and conversion file, checked the following paths:\n" + attemptedFilePaths.toString();
            LOGGER.info(unableToLoadMessage);
        }
    }

    public static boolean loadFromUrl(String filepath) {
        boolean retval;
        block14: {
            retval = false;
            if (filepath != null && !filepath.trim().isEmpty()) {
                try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filepath);){
                    if (is == null) break block14;
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                        retval = Unit.loadFromReader(br);
                    }
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.INFO, "Error loading unit definition and conversion file.", ioe);
                }
            }
        }
        return retval;
    }

    public static boolean loadFromFile(String filepath) {
        boolean bl;
        if (filepath == null || filepath.trim().isEmpty()) {
            return false;
        }
        LOGGER.log(Level.FINE, "Unit.loadFromFile: loading from {0}", filepath);
        File file = new File(filepath);
        if (!file.canRead()) {
            LOGGER.log(Level.FINE, "Unable to read unit resource file: {0}", filepath);
            return false;
        }
        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            bl = Unit.loadFromReader(br);
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                String error = String.format("Unable to load unit definition and conversion file: %s", filepath);
                LOGGER.log(Level.INFO, error, e);
                return false;
            }
        }
        br.close();
        return bl;
    }

    public static boolean loadFromReader(BufferedReader br) {
        if (br == null) {
            return false;
        }
        try {
            String line = br.readLine();
            while (line != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("//")) {
                    line = br.readLine();
                    continue;
                }
                if (line.indexOf(62) == -1) {
                    Unit.parseUnitDefinition(line);
                } else {
                    Unit.parseUnitConversion(line);
                }
                line = br.readLine();
            }
            return true;
        }
        catch (IOException exception) {
            LOGGER.log(Level.INFO, "Error loading unit definition and conversion file.", exception);
            return false;
        }
    }

    private static void parseUnitDefinition(String line) {
        StringTokenizer st = new StringTokenizer(line, ";", false);
        if (st.countTokens() >= 2) {
            String system = st.nextToken();
            String type = st.nextToken();
            Unit.addUnit(system, type);
            _aliasToUnitMap.put(type, type);
            while (st.hasMoreTokens()) {
                String alias = st.nextToken();
                _aliasToUnitMap.put(alias, type);
            }
        }
    }

    private static void parseUnitConversion(String line) {
        String fromSys = null;
        String fromType = null;
        String toSys = null;
        String toType = null;
        String func = null;
        double val = Double.NEGATIVE_INFINITY;
        StringTokenizer lineSplit = new StringTokenizer(line, ">", false);
        if (lineSplit.countTokens() >= 2) {
            StringTokenizer toSplit;
            StringTokenizer fromSplit = new StringTokenizer(lineSplit.nextToken(), ";", false);
            if (fromSplit.countTokens() == 2) {
                fromSys = fromSplit.nextToken();
                fromType = fromSplit.nextToken();
            }
            if ((toSplit = new StringTokenizer(lineSplit.nextToken(), ";", false)).countTokens() >= 3) {
                toSys = toSplit.nextToken();
                toType = toSplit.nextToken();
                func = toSplit.nextToken();
                val = RMAIO.parseDouble(func);
            }
        }
        if (fromSys != null && fromType != null && toSys != null && toType != null) {
            if (val != Double.NEGATIVE_INFINITY) {
                Unit.addConvFunction(fromSys, fromType, toSys, toType, val);
            } else {
                Unit.addConvFunction(fromSys, fromType, toSys, toType, func);
            }
        } else {
            LOGGER.log(Level.FINE, "Unit resource file line failed to parse: {0}", line);
        }
    }

    public static void addUnit(String unitSys, String unitId) {
        UnitType ut = new UnitType(unitSys, unitId);
        Unit.addUnit(ut);
    }

    public static boolean doesUnitExist(String unitSys, String unitId) {
        UnitType ut = new UnitType(unitSys, unitId);
        return Unit.doesUnitExist(ut);
    }

    public static void addConvFunction(String fromSys, String fromId, String toSys, String toId, String strFunction) {
        UnitType fromUt = new UnitType(fromSys, fromId);
        UnitType toUt = new UnitType(toSys, toId);
        RpnFunction function = new RpnFunction(strFunction);
        Unit.addConvFunction(fromUt, toUt, function);
    }

    public static void addConvFunction(String fromSys, String fromId, String toSys, String toId, RpnFunction function) {
        UnitType fromUt = new UnitType(fromSys, fromId);
        UnitType toUt = new UnitType(toSys, toId);
        Unit.addConvFunction(fromUt, toUt, function);
    }

    public static void addConvFunction(String fromSys, String fromId, String toSys, String toId, double factor) {
        UnitType fromUt = new UnitType(fromSys, fromId);
        UnitType toUt = new UnitType(toSys, toId);
        StringBuilder sbFunction = new StringBuilder();
        sbFunction.append("Arg 0|");
        sbFunction.append(factor);
        sbFunction.append("|*");
        RpnFunction function = new RpnFunction(sbFunction.toString());
        Unit.addConvFunction(fromUt, toUt, function);
        sbFunction.setLength(0);
        sbFunction.append("Arg 0|");
        sbFunction.append(1.0 / factor);
        sbFunction.append("|*");
        RpnFunction inverseFunction = new RpnFunction(sbFunction.toString());
        Unit.addConvFunction(toUt, fromUt, inverseFunction);
    }

    private static NavigableSet<String> getUnitsToConvertTo(UnitType ut) {
        TreeSet<String> retval = new TreeSet<String>();
        Map<String, ConvFunction> unitConvMap = _unitConvFrom.get(ut.key());
        if (unitConvMap != null) {
            for (ConvFunction convFunction : unitConvMap.values()) {
                retval.add(convFunction.getTo().toString());
            }
        }
        return retval;
    }

    private static RpnFunction getConvFunction(UnitType fromUt, UnitType toUt) {
        RpnFunction rpnFunction;
        ConvFunction convFunction;
        RpnFunction retval = null;
        Map<String, ConvFunction> functionMap = _unitConvFrom.get(fromUt.key());
        if (functionMap != null && (convFunction = functionMap.get(toUt.key())) != null && (rpnFunction = convFunction.getFunction()) != null) {
            retval = new RpnFunction(rpnFunction.getFunctionString());
        }
        return retval;
    }

    private static void addUnit(UnitType unitType) {
        if (!Unit.doesUnitExist(unitType)) {
            String unitSystem = unitType.getUnitSystem();
            NavigableSet unitSet = _unitMap.getOrDefault(unitSystem, new TreeSet());
            unitSet.add(unitType.getUnitId());
            _unitMap.put(unitSystem, unitSet);
            StringBuilder sbFunction = new StringBuilder();
            sbFunction.append("Arg 0|");
            sbFunction.append(1.0);
            sbFunction.append("|*");
            RpnFunction function = new RpnFunction(sbFunction.toString());
            Unit.addConvFunction(unitType, unitType, function);
        }
    }

    private static boolean doesUnitExist(UnitType ut) {
        boolean retval = false;
        String system = ut.getUnitSystem();
        NavigableSet unitTypes = _unitMap.getOrDefault(system, new TreeSet());
        if (unitTypes.contains(ut.getUnitId())) {
            retval = true;
        }
        return retval;
    }

    private static void addConvFunction(UnitType fromUt, UnitType toUt, RpnFunction function) {
        if (!Unit.doesUnitExist(fromUt)) {
            Unit.addUnit(fromUt);
        }
        if (!Unit.doesUnitExist(toUt)) {
            Unit.addUnit(toUt);
        }
        Unit.addConvFunctionBase(fromUt, toUt, function);
    }

    private static void addConvFunctionBase(UnitType fromUt, UnitType toUt, RpnFunction function) {
        Map functionMap = _unitConvFrom.getOrDefault(fromUt.key(), new HashMap());
        ConvFunction cf = new ConvFunction(fromUt, toUt, function);
        functionMap.put(toUt.key(), cf);
        _unitConvFrom.put(fromUt.key(), functionMap);
    }

    private static Identifier downloadParameterFile() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?>[] paramTypes;
        Class<?> appDaddyClass = Class.forName("hec.appInterface.AppDaddy");
        Method getAppMethod = appDaddyClass.getDeclaredMethod("getApp", new Class[0]);
        Object appInstance = getAppMethod.invoke(appDaddyClass, new Object[0]);
        Class<?> appInstanceClass = appInstance.getClass();
        Method getFileMethod = appInstanceClass.getMethod("downLoadParameterFile", paramTypes = null);
        Object fileInstance = getFileMethod.invoke(appInstance, (Object[])null);
        if (fileInstance instanceof Identifier) {
            return (Identifier)fileInstance;
        }
        return null;
    }

    static {
        Unit.load();
    }

    private static final class UnitType
    implements Comparable<Object> {
        private String _unitSystem = null;
        private String _unitId = null;

        private UnitType(String unitSystem, String unitId) {
            this._unitSystem = unitSystem;
            this._unitId = unitId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UnitType)) {
                return false;
            }
            UnitType ut = (UnitType)obj;
            if (!this._unitSystem.equalsIgnoreCase(ut.getUnitSystem())) {
                return false;
            }
            return this._unitId.equalsIgnoreCase(ut.getUnitId());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._unitSystem);
            sb.append(".");
            sb.append(this._unitId);
            return sb.toString();
        }

        private String getUnitSystem() {
            return this._unitSystem;
        }

        private String getUnitId() {
            return this._unitId;
        }

        private String key() {
            String key = this.toString().toUpperCase();
            return key;
        }

        public int hashCode() {
            return Objects.hash(this._unitSystem, this._unitId);
        }

        @Override
        public int compareTo(Object o) {
            int retval = o instanceof UnitType ? this._unitId.compareTo(((UnitType)o).getUnitId()) : this.toString().compareTo(o.toString());
            return retval;
        }
    }

    private static final class ConvFunction {
        private UnitType _fromUt = null;
        private UnitType _toUt = null;
        private RpnFunction _rpnFunction = null;

        private ConvFunction(UnitType from, UnitType to, RpnFunction function) {
            this._fromUt = from;
            this._toUt = to;
            this._rpnFunction = function;
        }

        private UnitType getFrom() {
            return this._fromUt;
        }

        private UnitType getTo() {
            return this._toUt;
        }

        private RpnFunction getFunction() {
            return this._rpnFunction;
        }
    }
}

