/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.util;

import hec.heclib.util.intContainer;
import hec.lang.annotation.Scriptable;
import java.io.Serializable;
import java.util.Arrays;
import rma.util.RMAConst;

public class doubleArrayContainer
implements Serializable {
    public double[] array;
    public int length;

    public doubleArrayContainer() {
        this.array = null;
        this.length = 0;
    }

    public doubleArrayContainer(double[] values) {
        this.array = values;
        this.length = values.length;
    }

    public doubleArrayContainer(int numberElements) {
        this.array = new double[numberElements];
        this.length = numberElements;
    }

    @Scriptable
    public void shiftLeft(int elementPosition) {
        if (elementPosition < 0 || elementPosition >= this.array.length) {
            Arrays.fill(this.array, -2.147483648E9);
            return;
        }
        if (this.array == null) {
            return;
        }
        double[] tempArray = new double[this.array.length];
        System.arraycopy(this.array, elementPosition, tempArray, 0, this.array.length - elementPosition);
        for (int i = tempArray.length - elementPosition; i < tempArray.length; ++i) {
            tempArray[i] = -3.4028234663852886E38;
        }
        System.arraycopy(tempArray, 0, this.array, 0, this.array.length);
        this.length = this.array.length;
    }

    public int setSize(int numberElements) {
        if (numberElements < 1) {
            this.length = 0;
            this.array = null;
            return -1;
        }
        this.length = numberElements;
        this.array = new double[numberElements];
        for (int i = 0; i < numberElements; ++i) {
            this.array[i] = -3.4028234663852886E38;
        }
        return 0;
    }

    @Scriptable
    public int resize(int numberElements) {
        return this.resize(numberElements, 0, 0);
    }

    @Scriptable
    public int resize(int numberElements, int beginningElement) {
        double[] temp;
        if (numberElements < 1) {
            this.length = 0;
            if (this.array != null) {
                this.array = null;
            }
            return -1;
        }
        if (beginningElement < 0) {
            beginningElement = 0;
        }
        if ((temp = new double[numberElements]) == null) {
            return -1;
        }
        int diff = numberElements - this.length;
        if (diff > 0) {
            int y = beginningElement + diff - 1;
            int arrayPos = 0;
            for (int i = 0; i < numberElements; ++i) {
                if ((i < beginningElement || i > y) && arrayPos < this.length) {
                    temp[i] = this.array[arrayPos];
                    ++arrayPos;
                    continue;
                }
                temp[i] = -3.4028234663852886E38;
            }
        } else {
            int arrayPos = 0;
            for (int i = 0; i < numberElements; ++i) {
                arrayPos = i >= beginningElement ? i - diff : i;
                temp[i] = arrayPos < this.length ? this.array[arrayPos] : -3.4028234663852886E38;
            }
        }
        this.length = numberElements;
        this.array = temp;
        return 0;
    }

    @Scriptable
    public int resize(int numberElements, int beginningElementOld, int beginningElementNew) {
        double[] temp;
        if (numberElements < 1) {
            this.length = 0;
            if (this.array != null) {
                this.array = null;
            }
            return -1;
        }
        if (beginningElementOld < 0) {
            beginningElementOld = 0;
        }
        if (beginningElementNew < 0) {
            beginningElementNew = 0;
        }
        if (beginningElementOld > this.length) {
            beginningElementOld = this.length;
        }
        if (beginningElementNew > numberElements) {
            beginningElementNew = numberElements;
        }
        if ((temp = new double[numberElements]) == null) {
            return -1;
        }
        int pos = this.length - beginningElementOld + beginningElementNew;
        for (int i = 0; i < numberElements; ++i) {
            if (i >= beginningElementNew && i < pos) {
                int k = beginningElementOld + i - beginningElementNew;
                temp[i] = this.array[k];
                continue;
            }
            temp[i] = -3.4028234663852886E38;
        }
        this.length = numberElements;
        this.array = temp;
        return 0;
    }

    public void set(int elementNumber, double value) {
        if (elementNumber >= this.length) {
            this.resize(elementNumber + 1);
        }
        this.array[elementNumber] = value;
    }

    public double maximum(intContainer elementNumber) {
        if (!this.isDefined(elementNumber)) {
            return -3.4028234663852886E38;
        }
        double maximum = this.array[elementNumber.value];
        for (int i = elementNumber.value; i < this.length; ++i) {
            if (this.array[i] == -3.4028234663852886E38 || !(this.array[i] > maximum)) continue;
            maximum = this.array[i];
            elementNumber.value = i;
        }
        return maximum;
    }

    public double minimum(intContainer elementNumber) {
        if (!this.isDefined(elementNumber)) {
            return -3.4028234663852886E38;
        }
        double minimum = this.array[elementNumber.value];
        for (int i = elementNumber.value; i < this.length; ++i) {
            if (this.array[i] == -3.4028234663852886E38 || !(this.array[i] < minimum)) continue;
            minimum = this.array[i];
            elementNumber.value = i;
        }
        return minimum;
    }

    @Scriptable
    public double minimum() {
        intContainer ic = new intContainer();
        return this.minimum(ic);
    }

    public double maximum() {
        intContainer ic = new intContainer();
        return this.maximum(ic);
    }

    public boolean isDefined(intContainer elementNumber) {
        elementNumber.value = 0;
        if (this.array == null || this.length == 0) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.array[i] == -3.4028234663852886E38) continue;
            elementNumber.value = i;
            return true;
        }
        return false;
    }

    public boolean isDefined() {
        intContainer ic = new intContainer();
        return this.isDefined(ic);
    }

    public boolean isValidValue() {
        if (this.array == null || this.length == 0) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (!RMAConst.isValidValue(this.array[i])) continue;
            return true;
        }
        return false;
    }
}

