/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.util;

import hec.heclib.util.intContainer;
import hec.lang.annotation.Scriptable;
import java.io.Serializable;
import java.util.Arrays;

public class intArrayContainer
implements Serializable {
    public int[] array;
    public int length;

    public intArrayContainer() {
        this.array = null;
        this.length = 0;
    }

    public intArrayContainer(int[] values) {
        this.array = values;
        this.length = values.length;
    }

    public intArrayContainer(int numberElements) {
        this.array = new int[numberElements];
        this.length = numberElements;
    }

    public intArrayContainer(int numberElements, int initialValue) {
        this.array = new int[numberElements];
        this.length = numberElements;
        for (int i = 0; i < numberElements; ++i) {
            this.array[i] = initialValue;
        }
    }

    public int setSize(int numberElements) {
        if (numberElements < 1) {
            this.length = 0;
            this.array = null;
            return -1;
        }
        this.length = numberElements;
        this.array = new int[numberElements];
        for (int i = 0; i < numberElements; ++i) {
            this.array[i] = Integer.MIN_VALUE;
        }
        return 0;
    }

    public int size() {
        return this.length;
    }

    public int value(int elementNumber) {
        if (elementNumber >= 0 && elementNumber < this.length) {
            return Integer.MIN_VALUE;
        }
        return this.array[elementNumber];
    }

    @Scriptable
    public int resize(int numberElements) {
        return this.resize(numberElements, 0, 0);
    }

    public void shiftLeft(int elementPosition) {
        if (elementPosition < 0 || elementPosition >= this.array.length) {
            Arrays.fill(this.array, Integer.MIN_VALUE);
            return;
        }
        if (this.array == null) {
            return;
        }
        int[] tempArray = new int[this.array.length];
        System.arraycopy(this.array, elementPosition, tempArray, 0, this.array.length - elementPosition);
        for (int i = tempArray.length - elementPosition; i < tempArray.length; ++i) {
            tempArray[i] = Integer.MIN_VALUE;
        }
        this.array = tempArray;
        this.length = this.array.length;
    }

    @Scriptable
    public int resize(int numberElements, int beginningElement) {
        int[] temp;
        if (numberElements < 1) {
            this.length = 0;
            if (this.array != null) {
                this.array = null;
            }
            return -1;
        }
        if (beginningElement < 0) {
            beginningElement = 0;
        }
        if ((temp = new int[numberElements]) == null) {
            return -1;
        }
        int diff = numberElements - this.length;
        if (diff > 0) {
            int y = beginningElement + diff - 1;
            int arrayPos = 0;
            for (int i = 0; i < numberElements; ++i) {
                if ((i < beginningElement || i > y) && arrayPos < this.length) {
                    temp[i] = this.array[arrayPos];
                    ++arrayPos;
                    continue;
                }
                temp[i] = Integer.MIN_VALUE;
            }
        } else {
            int arrayPos = 0;
            for (int i = 0; i < numberElements; ++i) {
                arrayPos = i >= beginningElement ? i - diff : i;
                temp[i] = arrayPos < this.length ? this.array[arrayPos] : Integer.MIN_VALUE;
            }
        }
        this.length = numberElements;
        this.array = temp;
        return 0;
    }

    @Scriptable
    public int resize(int numberElements, int beginningElementOld, int beginningElementNew) {
        int[] temp;
        if (numberElements < 1) {
            this.length = 0;
            if (this.array != null) {
                this.array = null;
            }
            return -1;
        }
        if (beginningElementOld < 0) {
            beginningElementOld = 0;
        }
        if (beginningElementNew < 0) {
            beginningElementNew = 0;
        }
        if (beginningElementOld > this.length) {
            beginningElementOld = this.length;
        }
        if (beginningElementNew > numberElements) {
            beginningElementNew = numberElements;
        }
        if ((temp = new int[numberElements]) == null) {
            return -1;
        }
        int pos = this.length - beginningElementOld + beginningElementNew;
        for (int i = 0; i < numberElements; ++i) {
            if (i >= beginningElementNew && i < pos) {
                int k = beginningElementOld + i - beginningElementNew;
                temp[i] = this.array[k];
                continue;
            }
            temp[i] = Integer.MIN_VALUE;
        }
        this.length = numberElements;
        this.array = temp;
        return 0;
    }

    public int maximum(intContainer elementNumber) {
        if (!this.isDefined(elementNumber)) {
            return Integer.MIN_VALUE;
        }
        int maximum = this.array[elementNumber.value];
        for (int i = elementNumber.value; i < this.length; ++i) {
            if (this.array[i] == Integer.MIN_VALUE || this.array[i] <= maximum) continue;
            maximum = this.array[i];
            elementNumber.value = i;
        }
        return maximum;
    }

    public int minimum(intContainer elementNumber) {
        if (!this.isDefined(elementNumber)) {
            return Integer.MIN_VALUE;
        }
        int minimum = this.array[elementNumber.value];
        for (int i = elementNumber.value; i < this.length; ++i) {
            if (this.array[i] == Integer.MIN_VALUE || this.array[i] >= minimum) continue;
            minimum = this.array[i];
            elementNumber.value = i;
        }
        return minimum;
    }

    public int minimum() {
        intContainer ic = new intContainer();
        return this.minimum(ic);
    }

    public int maximum() {
        intContainer ic = new intContainer();
        return this.maximum(ic);
    }

    @Scriptable
    public boolean isDefined(intContainer elementNumber) {
        elementNumber.value = 0;
        if (this.array == null || this.length == 0) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.array[i] == Integer.MIN_VALUE) continue;
            elementNumber.value = i;
            return true;
        }
        return false;
    }

    public boolean isDefined() {
        intContainer ic = new intContainer(0);
        return this.isDefined(ic);
    }
}

