/*
 * Decompiled with CFR 0.152.
 */
package hec.heclib.util;

import hec.heclib.util.intContainer;
import java.io.Serializable;

public class shortArrayContainer
implements Serializable {
    public short[] array;
    public int length;

    public shortArrayContainer() {
        this.array = null;
        this.length = 0;
    }

    public shortArrayContainer(int numberElements) {
        this.array = new short[numberElements];
        this.length = numberElements;
    }

    public int setSize(int numberElements) {
        if (numberElements < 1) {
            this.length = 0;
            this.array = null;
            return -1;
        }
        this.length = numberElements;
        this.array = new short[numberElements];
        for (int i = 0; i < numberElements; ++i) {
            this.array[i] = Short.MIN_VALUE;
        }
        return 0;
    }

    public int resize(int numberElements) {
        return this.resize(numberElements, 0, 0);
    }

    public int resize(int numberElements, int beginningElement) {
        short[] temp;
        if (numberElements < 1) {
            this.length = 0;
            if (this.array != null) {
                this.array = null;
            }
            return -1;
        }
        if (beginningElement < 0) {
            beginningElement = 0;
        }
        if ((temp = new short[numberElements]) == null) {
            return -1;
        }
        int diff = numberElements - this.length;
        if (diff > 0) {
            int y = beginningElement + diff - 1;
            int arrayPos = 0;
            for (int i = 0; i < numberElements; ++i) {
                if ((i < beginningElement || i > y) && arrayPos < this.length) {
                    temp[i] = this.array[arrayPos];
                    ++arrayPos;
                    continue;
                }
                temp[i] = Short.MIN_VALUE;
            }
        } else {
            int arrayPos = 0;
            for (int i = 0; i < numberElements; ++i) {
                arrayPos = i >= beginningElement ? i - diff : i;
                temp[i] = arrayPos < this.length ? this.array[arrayPos] : Short.MIN_VALUE;
            }
        }
        this.length = numberElements;
        this.array = temp;
        return 0;
    }

    public int resize(int numberElements, int beginningElementOld, int beginningElementNew) {
        short[] temp;
        if (numberElements < 1) {
            this.length = 0;
            if (this.array != null) {
                this.array = null;
            }
            return -1;
        }
        if (beginningElementOld < 0) {
            beginningElementOld = 0;
        }
        if (beginningElementNew < 0) {
            beginningElementNew = 0;
        }
        if (beginningElementOld > this.length) {
            beginningElementOld = this.length;
        }
        if (beginningElementNew > numberElements) {
            beginningElementNew = numberElements;
        }
        if ((temp = new short[numberElements]) == null) {
            return -1;
        }
        int pos = this.length - beginningElementOld + beginningElementNew;
        for (int i = 0; i < numberElements; ++i) {
            if (i >= beginningElementNew && i < pos) {
                int k = beginningElementOld + i - beginningElementNew;
                temp[i] = this.array[k];
                continue;
            }
            temp[i] = Short.MIN_VALUE;
        }
        this.length = numberElements;
        this.array = temp;
        return 0;
    }

    public short maximum(intContainer elementNumber) {
        if (!this.isDefined(elementNumber)) {
            return Short.MIN_VALUE;
        }
        short maximum = this.array[elementNumber.value];
        for (int i = elementNumber.value; i < this.length; ++i) {
            if ((double)this.array[i] == -3.4028234663852886E38 || this.array[i] <= maximum) continue;
            maximum = this.array[i];
            elementNumber.value = i;
        }
        return maximum;
    }

    public short minimum(intContainer elementNumber) {
        if (!this.isDefined(elementNumber)) {
            return Short.MIN_VALUE;
        }
        short minimum = this.array[elementNumber.value];
        for (int i = elementNumber.value; i < this.length; ++i) {
            if ((double)this.array[i] == -3.4028234663852886E38 || this.array[i] >= minimum) continue;
            minimum = this.array[i];
            elementNumber.value = i;
        }
        return minimum;
    }

    public short minimum() {
        intContainer ic = new intContainer();
        return this.minimum(ic);
    }

    public short maximum() {
        intContainer ic = new intContainer();
        return this.maximum(ic);
    }

    public boolean isDefined(intContainer elementNumber) {
        elementNumber.value = 0;
        if (this.array == null || this.length == 0) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if ((double)this.array[i] == -3.4028234663852886E38) continue;
            elementNumber.value = i;
            return true;
        }
        return false;
    }

    public boolean isDefined() {
        intContainer ic = new intContainer();
        return this.isDefined(ic);
    }
}

