/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

import hec.heclib.util.HecTime;
import hec.hecmath.HecMath;
import java.util.Arrays;

public class CyclicAnalysisStatistics {
    public int intervalType = -1;
    public int qualityTest = 0;
    public static final int UNDEFINED = -1;
    public static final int HOURLY = 1;
    public static final int DAILY = 2;
    public static final int MONTHLY = 3;
    public static final int SUB_DAILY = 4;
    public int numberValidValues;
    public int numberRejectedValues;
    public double sum;
    public double mean;
    public double min;
    public double max;
    public double sdev;
    public double p05;
    public double p10;
    public double p25;
    public double p50;
    public double p75;
    public double p90;
    public double p95;
    public double dateAtMax;
    public double dateAtMin;
    protected int _icount;
    protected int[] times;
    protected double[] values;
    private int _timeGranularitySeconds;
    private int _julianBaseDate;

    public CyclicAnalysisStatistics(int interval, int size, int timeGranularitySeconds, int julianBaseDate) {
        this.intervalType = interval;
        this.times = new int[size];
        this.values = new double[size];
        this._icount = 0;
        this._timeGranularitySeconds = timeGranularitySeconds;
        this._julianBaseDate = julianBaseDate;
    }

    public void add(int newTime, double newValue) {
        this.times[this._icount] = newTime;
        this.values[this._icount] = newValue;
        ++this._icount;
    }

    public void computeStatistics() {
        boolean numberValues = false;
        this.numberValidValues = 0;
        this.numberRejectedValues = 0;
        this.sum = 0.0;
        int timeAtMin = 0;
        int timeAtMax = 0;
        this.min = 3.4028234663852886E38;
        this.max = -3.4028234663852886E38;
        double[] sortArray = new double[this._icount];
        for (int i = 0; i < this._icount; ++i) {
            if (!HecMath.isMissing(this.values[i])) {
                sortArray[this.numberValidValues] = this.values[i];
                ++this.numberValidValues;
                this.sum += this.values[i];
                if (this.values[i] < this.min) {
                    this.min = this.values[i];
                    timeAtMin = this.times[i];
                }
                if (!(this.values[i] > this.max)) continue;
                this.max = this.values[i];
                timeAtMax = this.times[i];
                continue;
            }
            ++this.numberRejectedValues;
        }
        if (this.numberValidValues < 1) {
            this.sum = -3.4028234663852886E38;
            this.min = -3.4028234663852886E38;
            this.max = -3.4028234663852886E38;
            this.mean = -3.4028234663852886E38;
            this.sdev = -3.4028234663852886E38;
            this.p05 = -3.4028234663852886E38;
            this.p10 = -3.4028234663852886E38;
            this.p25 = -3.4028234663852886E38;
            this.p50 = -3.4028234663852886E38;
            this.p75 = -3.4028234663852886E38;
            this.p90 = -3.4028234663852886E38;
            this.p95 = -3.4028234663852886E38;
            return;
        }
        double rvalid = this.numberValidValues;
        this.mean = this.sum / rvalid;
        double variance = 0.0;
        for (int i = 0; i < this.numberValidValues; ++i) {
            double diff = sortArray[i] - this.mean;
            variance += diff * diff;
        }
        this.sdev = this.numberValidValues > 1 ? Math.sqrt(variance / (rvalid - 1.0)) : 0.0;
        Arrays.sort(sortArray, 0, this.numberValidValues);
        int idx = 0;
        idx = (int)(0.05 * rvalid + 0.5) - 1;
        idx = Math.max(0, idx);
        this.p05 = sortArray[idx];
        idx = (int)(0.1 * rvalid + 0.5) - 1;
        idx = Math.max(0, idx);
        this.p10 = sortArray[idx];
        idx = (int)(0.25 * rvalid + 0.5) - 1;
        idx = Math.max(0, idx);
        this.p25 = sortArray[idx];
        idx = (int)(0.5 * rvalid + 0.5) - 1;
        this.p50 = sortArray[idx];
        idx = (int)(0.75 * rvalid + 0.5) - 1;
        this.p75 = sortArray[idx];
        idx = (int)(0.9 * rvalid + 0.5) - 1;
        this.p90 = sortArray[idx];
        idx = (int)(0.95 * rvalid + 0.5) - 1;
        this.p95 = sortArray[idx];
        HecTime hecTime = new HecTime(1);
        hecTime.set(timeAtMax, this._timeGranularitySeconds, this._julianBaseDate);
        this.dateAtMax = hecTime.year();
        if (this.intervalType == 1 || this.intervalType == 4) {
            this.dateAtMax += (double)hecTime.month() / 100.0 + (double)hecTime.day() / 10000.0;
        }
        hecTime.set(timeAtMin, this._timeGranularitySeconds, this._julianBaseDate);
        this.dateAtMin = hecTime.year();
        if (this.intervalType == 1 || this.intervalType == 4) {
            this.dateAtMin += (double)hecTime.month() / 100.0 + (double)hecTime.day() / 10000.0;
        }
    }

    public void freeWorkingArrays() {
        this._icount = 0;
        this.times = null;
        this.values = null;
    }
}

