/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

import hec.heclib.dss.DssDataManager;
import hec.heclib.dss.LocalDssDataManager;
import hec.heclib.dss.RemoteDssDataManagerProvider;
import hec.heclib.util.Heclib;
import hec.hecmath.DSSFile;
import hec.lang.ClientAppCheck;
import hec.lang.annotation.Scriptable;
import rma.util.lookup.Lookup;

@Scriptable
public class DSS {
    public DSS() {
    }

    public DSS(boolean remote) {
    }

    @Scriptable
    public static DSSFile open(String filename, String startTime, String endTime) {
        DSSFile dssFile = DSS.open(filename);
        dssFile.setTimeWindow(startTime, endTime);
        return dssFile;
    }

    @Scriptable
    public static DSSFile open(String filename, String timeWindow) {
        DSSFile dssFile = DSS.open(filename);
        dssFile.setTimeWindow(timeWindow);
        return dssFile;
    }

    @Scriptable
    public static DSSFile open(String filename) {
        boolean useRemote = ClientAppCheck.isNetworked();
        return DSS.open(filename, useRemote);
    }

    @Scriptable
    public static DSSFile open(String filename, boolean isRemote) {
        DssDataManager dataManager = null;
        if (isRemote) {
            RemoteDssDataManagerProvider remoteDssDataManagerProvider = (RemoteDssDataManagerProvider)Lookup.getDefault().lookup(RemoteDssDataManagerProvider.class);
            if (remoteDssDataManagerProvider != null) {
                dataManager = remoteDssDataManagerProvider.createRemoteDssDataManager();
            }
            if (dataManager == null) {
                throw new IllegalStateException("Unable to locate Remote Dss Data Manager!");
            }
        } else {
            dataManager = new LocalDssDataManager();
        }
        dataManager.setDSSFileName(filename);
        if (!dataManager.fileOpened()) {
            dataManager.open();
        }
        DSSFile dssFile = new DSSFile(dataManager);
        dssFile.setFilename(filename);
        return dssFile;
    }

    @Scriptable
    public static DSSFile open(String filename, int dssVersion) {
        boolean useRemote = ClientAppCheck.isNetworked();
        DssDataManager dataManager = null;
        if (useRemote) {
            RemoteDssDataManagerProvider remoteDssDataManagerProvider = (RemoteDssDataManagerProvider)Lookup.getDefault().lookup(RemoteDssDataManagerProvider.class);
            if (remoteDssDataManagerProvider != null) {
                dataManager = remoteDssDataManagerProvider.createRemoteDssDataManager();
            }
            if (dataManager == null) {
                throw new IllegalStateException("Unable to locate Remote Dss Data Manager!");
            }
        } else {
            dataManager = new LocalDssDataManager();
        }
        dataManager.setDSSFileName(filename, false, dssVersion);
        if (!dataManager.fileOpened()) {
            dataManager.open();
        }
        DSSFile dssFile = new DSSFile(dataManager);
        dssFile.setFilename(filename);
        return dssFile;
    }

    static {
        Integer i = Integer.getInteger("DSS.MLEVEL");
        if (i != null) {
            Heclib.zset("MLEVEL", "", i);
        }
    }
}

