/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

import hec.heclib.dss.DataReference;
import hec.heclib.dss.DssDataManager;
import hec.heclib.dss.LocalDssDataManager;
import hec.heclib.dss.RemoteDssDataManagerProvider;
import hec.heclib.util.HecTime;
import hec.hecmath.DSSFileException;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.PairedDataMath;
import hec.hecmath.PairedDataMathVertDatum;
import hec.hecmath.TextMath;
import hec.hecmath.TimeSeriesMath;
import hec.hecmath.TimeSeriesMathVertDatum;
import hec.io.DataContainer;
import hec.io.DataContainerTransformer;
import hec.io.HecIoException;
import hec.io.PairedDataContainer;
import hec.io.PairedDataContainerVertDatum;
import hec.io.StreamRatingContainer;
import hec.io.StreamRatingSeriesContainer;
import hec.io.TextContainer;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerVertDatum;
import hec.lang.annotation.Scriptable;
import hec.util.TextUtil;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;
import rma.util.RMAIO;

public class DSSFile {
    protected DssDataManager _dataManager;
    protected String _filename;
    protected String _startTime;
    protected String _endTime;
    protected boolean _trimMissing = true;
    protected int _regularStoreMethod = 0;
    protected int _irregularStoreMethod = 1;

    public DSSFile(DssDataManager dataManager) {
        if (dataManager == null) {
            System.out.println("DSSFile: DataManager can't be null");
            throw new NullPointerException("DataManager can not be null");
        }
        this._dataManager = dataManager;
    }

    @Scriptable
    public void close() {
        if (this._dataManager != null) {
            this._dataManager.close();
        }
    }

    public void forceMultiUserAccess() {
        if (this._dataManager != null) {
            this._dataManager.forceMultiUserAccess();
        }
    }

    public void done() {
        if (this._dataManager != null) {
            this._dataManager.done();
        }
    }

    public boolean isRemote() {
        return this._dataManager.isRemote();
    }

    @Scriptable
    public String getFilename() {
        return this._filename;
    }

    @Scriptable
    public String getStartTime() {
        return this._startTime;
    }

    @Scriptable
    public String getEndTime() {
        return this._endTime;
    }

    @Scriptable
    public boolean getTrimMissing() {
        return this._trimMissing;
    }

    public int getRegularStoreMethod() {
        return this._regularStoreMethod;
    }

    public int getIrregularStoreMethod() {
        return this._irregularStoreMethod;
    }

    public DssDataManager getDataManager() {
        return this._dataManager;
    }

    public int recordsUpdated(long startTime, Vector<String> pathnames, Vector<Long> updateTimes, Vector<Integer> recordTypes) {
        if (this._dataManager == null) {
            return -1;
        }
        this._dataManager.setDSSFileName(this._filename);
        return this._dataManager.recordsUpdated(startTime, pathnames, updateTimes, recordTypes);
    }

    public int recordsUpdated(HecTime startTime, Vector<String> pathnames, Vector<Long> updateTimes, Vector<Integer> recordTypes) {
        if (this._dataManager == null || startTime == null || !startTime.isDefined()) {
            return -1;
        }
        return this._dataManager.recordsUpdated(startTime.getTimeInMillis(), pathnames, updateTimes, recordTypes);
    }

    public int recordsUpdated(String startTime, Vector<String> pathnames, Vector<Long> updateTimes, Vector<Integer> recordTypes) {
        if (this._dataManager == null || startTime == null) {
            return -1;
        }
        HecTime _startTime = new HecTime(startTime);
        if (!_startTime.isDefined()) {
            return -1;
        }
        return this._dataManager.recordsUpdated(_startTime.getTimeInMillis(), pathnames, updateTimes, recordTypes);
    }

    public Vector<String> recordsUpdated(long startTime) {
        Vector<String> pathnames = new Vector<String>();
        int rc = this.recordsUpdated(startTime, pathnames, null, null);
        return pathnames;
    }

    public Vector<String> recordsUpdated(HecTime startTime) {
        Vector<String> pathnames = new Vector<String>();
        int rc = this.recordsUpdated(startTime, pathnames, null, null);
        return pathnames;
    }

    public Vector<String> recordsUpdated(String startTime) {
        Vector<String> pathnames = new Vector<String>();
        int rc = this.recordsUpdated(startTime, pathnames, null, null);
        return pathnames;
    }

    @Scriptable
    public void setFilename(String filename) {
        this._filename = filename = RMAIO.parsePathName(filename);
    }

    @Scriptable
    public void setTimeWindow(String timeWindow) {
        HecTime start = new HecTime();
        HecTime end = new HecTime();
        int stat = HecTime.getTimeWindow(timeWindow, start, end);
        if (stat == 0) {
            this._startTime = start.toString(104);
            this._endTime = end.toString(104);
        } else {
            System.out.println("Invalid time window: " + timeWindow);
        }
    }

    @Scriptable
    public void setTimeWindow(String startTime, String endTime) {
        this._startTime = startTime;
        this._endTime = endTime;
    }

    @Scriptable
    public void setTrimMissing(boolean trimMissing) {
        this._trimMissing = trimMissing;
    }

    public void setRegularStoreMethod(int method) {
        this._regularStoreMethod = method;
    }

    public void setIrregularStoreMethod(int method) {
        this._irregularStoreMethod = method;
    }

    public int duplicateRecords(Vector pathnameList, Vector newPathnameList) {
        this._dataManager.setDSSFileName(this._filename);
        return this._dataManager.duplicateRecords(pathnameList, newPathnameList);
    }

    public int duplicateRecords(String[] pathnameList, String[] newPathnameList) {
        Vector<String> vPathnameList = new Vector<String>(pathnameList.length);
        for (int i = 0; i < pathnameList.length; ++i) {
            vPathnameList.add(pathnameList[i]);
        }
        Vector<String> vNewPathnameList = new Vector<String>(newPathnameList.length);
        for (int i = 0; i < newPathnameList.length; ++i) {
            vNewPathnameList.add(newPathnameList[i]);
        }
        return this.duplicateRecords(vPathnameList, vNewPathnameList);
    }

    public int renameRecords(Vector pathnameList, Vector newPathnameList) {
        this._dataManager.setDSSFileName(this._filename);
        return this._dataManager.renameRecords(pathnameList, newPathnameList);
    }

    public int renameRecords(String[] pathnameList, String[] newPathnameList) {
        Vector<String> vPathnameList = new Vector<String>(pathnameList.length);
        for (int i = 0; i < pathnameList.length; ++i) {
            vPathnameList.add(pathnameList[i]);
        }
        Vector<String> vNewPathnameList = new Vector<String>(newPathnameList.length);
        for (int i = 0; i < newPathnameList.length; ++i) {
            vNewPathnameList.add(newPathnameList[i]);
        }
        return this.renameRecords(vPathnameList, vNewPathnameList);
    }

    public int copyRecordsFrom(String toDSSFilename, Vector pathnameList) {
        DssDataManager toDataManager = null;
        toDataManager = this.isRemote() ? RemoteDssDataManagerProvider.newRemoteDssDataManager() : new LocalDssDataManager();
        toDataManager.setDSSFileName(toDSSFilename);
        toDataManager.setUnit(72);
        this._dataManager.setDSSFileName(this._filename);
        int rc = this._dataManager.copyRecordsFrom(toDataManager, toDSSFilename, pathnameList);
        toDataManager.close();
        return rc;
    }

    public int copyRecordsFrom(String toDSSFilename, String[] pathnameList) {
        Vector<String> vPathnameList = new Vector<String>(pathnameList.length);
        for (int i = 0; i < pathnameList.length; ++i) {
            vPathnameList.add(pathnameList[i]);
        }
        return this.copyRecordsFrom(toDSSFilename, vPathnameList);
    }

    public int copyRecordsInto(String fromDSSFilename, Vector pathnameList) {
        DssDataManager fromDataManager = null;
        fromDataManager = this.isRemote() ? RemoteDssDataManagerProvider.newRemoteDssDataManager() : new LocalDssDataManager();
        fromDataManager.setDSSFileName(fromDSSFilename);
        fromDataManager.setUnit(72);
        this._dataManager.setDSSFileName(this._filename);
        int rc = this._dataManager.copyRecordsInto(fromDataManager, fromDSSFilename, pathnameList);
        fromDataManager.close();
        return rc;
    }

    public int copyRecordsInto(String fromDSSFilename, String[] pathnameList) {
        Vector<String> vPathnameList = new Vector<String>(pathnameList.length);
        for (int i = 0; i < pathnameList.length; ++i) {
            vPathnameList.add(pathnameList[i]);
        }
        return this.copyRecordsInto(fromDSSFilename, vPathnameList);
    }

    public int delete(Vector pathnameList) {
        this._dataManager.setDSSFileName(this._filename);
        return this._dataManager.delete(pathnameList);
    }

    public int delete(String[] pathnameList) {
        Vector<String> vPathnameList = new Vector<String>(pathnameList.length);
        for (int i = 0; i < pathnameList.length; ++i) {
            vPathnameList.add(pathnameList[i]);
        }
        return this.delete(vPathnameList);
    }

    @Scriptable
    public HecMath read(String pathname) throws HecMathException {
        return this.read(pathname, this._startTime, this._endTime, this._trimMissing);
    }

    @Scriptable
    public HecMath read(String pathname, String timeWindow) throws HecMathException {
        this.setTimeWindow(timeWindow);
        return this.read(pathname, this._startTime, this._endTime, this._trimMissing);
    }

    @Scriptable
    public HecMath read(String pathname, String startTime, String endTime) throws HecMathException {
        return this.read(pathname, startTime, endTime, this._trimMissing);
    }

    @Scriptable
    public HecMath read(String pathname, String startTime, String endTime, boolean trimMissing) throws HecMathException {
        String verticalDatumInfo = null;
        String currentVerticalDatum = null;
        Object s = null;
        if (pathname == null || ((String)pathname).length() == 0) {
            s = "Null or empty Pathname specified";
        }
        if (s != null) {
            System.out.println("DSSFile.read: " + (String)s);
            throw new NullPointerException((String)s);
        }
        if (!((String)pathname).endsWith("/")) {
            pathname = (String)pathname + "/";
        }
        this._dataManager.setDSSFileName(this._filename);
        int type = this._dataManager.recordType((String)pathname);
        HecMath mathGuy = null;
        DataReference dataReference = new DataReference((String)pathname, this._filename);
        ArrayList<String> infoParts = null;
        switch (type) {
            case 200: {
                PairedDataContainer pdcontainer = new PairedDataContainer();
                int readRv = this._dataManager.readData(dataReference, pdcontainer);
                if (readRv < 0) {
                    s = "Path not found " + (String)pathname + " rv=" + readRv;
                    System.out.println("DSSFile.read:" + (String)s);
                    throw new DSSFileException((String)s);
                }
                if (pdcontainer.supplementalInfo != null) {
                    infoParts = new ArrayList<String>();
                    StringTokenizer tok = new StringTokenizer(pdcontainer.supplementalInfo, ";");
                    while (tok.hasMoreTokens()) {
                        String item = tok.nextToken();
                        String[] parts = TextUtil.split(item, ":");
                        if (parts.length == 2 && parts[0].equals("verticalDatumInfo")) {
                            try {
                                verticalDatumInfo = TextUtil.uncompress(parts[1], "base64");
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (parts.length == 2 && parts[0].equals("verticalDatum")) {
                            currentVerticalDatum = parts[1];
                            continue;
                        }
                        infoParts.add(item);
                    }
                }
                if (verticalDatumInfo == null) {
                    mathGuy = new PairedDataMath();
                    mathGuy.setData(pdcontainer);
                    break;
                }
                mathGuy = new PairedDataMathVertDatum();
                try {
                    pdcontainer.supplementalInfo = TextUtil.join(";", infoParts.toArray(new String[infoParts.size()]));
                    PairedDataContainerVertDatum pdcontainervd = new PairedDataContainerVertDatum(pdcontainer, new VerticalDatumContainer(verticalDatumInfo));
                    if (currentVerticalDatum != null) {
                        pdcontainervd.forceVerticalDatum(currentVerticalDatum);
                    }
                    mathGuy.setData(pdcontainervd);
                    break;
                }
                catch (VerticalDatumException e) {
                    throw new HecMathException(e);
                }
            }
            case 100: 
            case 110: {
                HecTime start = new HecTime(startTime);
                HecTime end = new HecTime(endTime);
                dataReference.setTimeWindow(start, end);
                TimeSeriesContainer tscontainer = new TimeSeriesContainer();
                int readRv = this._dataManager.readData(dataReference, tscontainer, trimMissing);
                if (readRv < 0) {
                    switch (readRv) {
                        case -1: {
                            break;
                        }
                        case -2: {
                            System.out.println("read:no data found for " + (String)pathname);
                            break;
                        }
                        case -3: {
                            s = "Program error reading " + (String)pathname + " rv=" + readRv;
                            System.out.println("DSSFile.read:" + (String)s);
                            throw new DSSFileException((String)s);
                        }
                    }
                }
                if (tscontainer.supplementalInfo != null) {
                    infoParts = new ArrayList();
                    StringTokenizer tok = new StringTokenizer(tscontainer.supplementalInfo, ";");
                    while (tok.hasMoreTokens()) {
                        String item = tok.nextToken();
                        String[] parts = TextUtil.split(item, ":");
                        if (parts.length == 2 && parts[0].equals("verticalDatumInfo")) {
                            try {
                                verticalDatumInfo = TextUtil.uncompress(parts[1], "base64");
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (parts.length == 2 && parts[0].equals("verticalDatum")) {
                            currentVerticalDatum = parts[1];
                            continue;
                        }
                        infoParts.add(item);
                    }
                }
                if (verticalDatumInfo == null) {
                    mathGuy = new TimeSeriesMath();
                    mathGuy.setData(tscontainer);
                    break;
                }
                mathGuy = new TimeSeriesMathVertDatum();
                try {
                    tscontainer.supplementalInfo = TextUtil.join(";", infoParts.toArray(new String[infoParts.size()]));
                    mathGuy.setData(new TimeSeriesContainerVertDatum(tscontainer, new VerticalDatumContainer(verticalDatumInfo)));
                    if (currentVerticalDatum == null) break;
                    ((TimeSeriesMathVertDatum)mathGuy).forceVerticalDatum(currentVerticalDatum);
                    break;
                }
                catch (VerticalDatumException e) {
                    throw new HecMathException(e);
                }
            }
            case 300: {
                mathGuy = new TextMath();
                TextContainer tc = new TextContainer();
                int readRv = this._dataManager.readData(dataReference, tc);
                if (readRv < 0) {
                    s = "Path not found " + (String)pathname + " rv=" + readRv;
                    System.out.println("DSSFile.read:" + (String)s);
                    throw new DSSFileException((String)s);
                }
                int len = tc.text.length();
                if (tc.text.charAt(0) == '\n' && tc.text.charAt(len - 1) == '\r') {
                    tc.text = tc.text.substring(1, len - 1);
                }
                mathGuy.setData(tc);
                break;
            }
            case -1: {
                s = "Error occurred (rv=-1) while reading path " + (String)pathname;
                System.out.println("DSSFile.read:" + (String)s);
                throw new DSSFileException((String)s);
            }
            default: {
                if (this._dataManager.recordExists((String)pathname)) {
                    s = "unsupported recordType(" + type + ") requested with path " + (String)pathname;
                    System.out.println("DSSFile.read:" + (String)s);
                    throw new UnsupportedOperationException((String)s);
                }
                s = "Path not found " + (String)pathname;
                System.out.println("DSSFile.read:" + (String)s);
                throw new DSSFileException((String)s);
            }
        }
        return mathGuy;
    }

    @Scriptable
    public int write(HecMath mathGuy) throws HecMathException {
        if (mathGuy == null) {
            String s = "Null HecMath Object";
            System.out.println("DSSFile.write:" + s);
            throw new NullPointerException(s);
        }
        boolean writeRv = false;
        this._dataManager.setDSSFileName(this._filename);
        DataContainer dc = mathGuy._dc;
        dc.fileName = this._filename;
        return this.write(dc);
    }

    @Scriptable
    public int write(DataContainerTransformer rating) throws HecMathException {
        DataContainer tc = null;
        try {
            tc = rating.toDataContainer();
            this._dataManager.setDSSFileName(this._filename);
            tc.fileName = this._filename;
            return this.write(tc);
        }
        catch (HecIoException e) {
            throw new HecMathException(e);
        }
    }

    @Scriptable
    public int write(DataContainer dataContainer) throws HecMathException {
        if (dataContainer == null) {
            String s = "Null dataContainer Object";
            System.out.println("DSSFile.write:" + s);
            throw new NullPointerException(s);
        }
        int writeRv = 0;
        if (dataContainer.fileName != null && dataContainer.fileName.length() > 0) {
            this._dataManager.setDSSFileName(dataContainer.fileName);
        } else if (this._filename != null && this._filename.length() > 0) {
            this._dataManager.setDSSFileName(this._filename);
        }
        if (dataContainer instanceof TimeSeriesContainer) {
            TimeSeriesContainer container = (TimeSeriesContainer)dataContainer;
            if (container == null) {
                String s = "TimeSeriesContainer is null";
                System.out.println("DSSFile.write:" + s);
                throw new NullPointerException(s);
            }
            writeRv = this._dataManager.writeData(container, this._regularStoreMethod, this._irregularStoreMethod);
            if (writeRv != 0) {
                String s = "Write failed (rv=" + writeRv + ") for pathname=" + container.fullName;
                System.out.println("DSSFile.write:" + s);
                throw new DSSFileException(s);
            }
        } else if (dataContainer instanceof PairedDataContainer) {
            PairedDataContainer container = (PairedDataContainer)dataContainer;
            if (container == null) {
                String s = "PairedData Container is null";
                System.out.println("DSSFile.write:" + s);
                throw new NullPointerException(s);
            }
            writeRv = this._dataManager.writeData(container);
            if (writeRv != 0) {
                String s = "Write failed (rv=" + writeRv + ") for pathname=" + container.fullName;
                System.out.println("DSSFile.write:" + s);
                throw new DSSFileException(s);
            }
        } else if (dataContainer instanceof StreamRatingContainer) {
            StreamRatingSeriesContainer container = (StreamRatingSeriesContainer)dataContainer;
            if (container == null) {
                String s = "StreamRatingSeriesContainer is null";
                System.out.println("DSSFile.write:" + s);
                throw new NullPointerException(s);
            }
            for (int i = 0; i < container.ratingCount; ++i) {
                String[] parts = container.ratings[i].fullName.split("/");
                container.ratings[i].watershed = parts[1] == null ? "" : parts[1];
                container.ratings[i].location = parts[2];
                container.ratings[i].version = parts[6] == null ? "" : parts[6];
            }
            container.fullName = container.ratings[0].fullName;
            container.watershed = container.ratings[0].watershed;
            container.location = container.ratings[0].location;
            container.version = container.ratings[0].version;
            writeRv = this._dataManager.writeData(container);
            if (writeRv != 0) {
                String s = "Write failed (rv=" + writeRv + ") for pathname=" + container.fullName;
                System.out.println("DSSFile.write:" + s);
                throw new DSSFileException(s);
            }
        } else if (dataContainer instanceof TextContainer) {
            if (dataContainer == null) {
                String s = "TextContainer is null";
                System.out.println("DSSFile.write:" + s);
                throw new NullPointerException(s);
            }
            if (((TextContainer)dataContainer).text == null) {
                String s = "TextContainer has null text";
                System.out.println("DSSFile.write:" + s);
                throw new NullPointerException(s);
            }
            writeRv = this._dataManager.writeData((TextContainer)dataContainer);
            if (writeRv != 0) {
                String s = "Write failed (rv=" + writeRv + ") for pathname=" + dataContainer.fullName;
                System.out.println("DSSFile.write:" + s);
                throw new DSSFileException(s);
            }
        } else {
            String s = "Unsupported HecMath type " + dataContainer.getClass();
            System.out.println("DSSFile.write:" + s);
            throw new IllegalArgumentException(s);
        }
        return writeRv;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Scriptable
    public int write(TimeSeriesMath mathGuy, String storeMethod) throws HecMathException {
        int irregularStoreMethod;
        int regularStoreMethod;
        TimeSeriesContainer tsc;
        int writeRv;
        block11: {
            String _storeMethod;
            block12: {
                block14: {
                    block13: {
                        writeRv = 0;
                        this._dataManager.setDSSFileName(this._filename);
                        if (mathGuy == null) {
                            String s = "Null HecMath Object";
                            System.out.println("DSSFile.write:" + s);
                            throw new NullPointerException(s);
                        }
                        tsc = (TimeSeriesContainer)mathGuy._dc;
                        if (tsc == null) {
                            String s = "TimeSeriesContainer is null";
                            System.out.println("DSSFile.write:" + s);
                            throw new NullPointerException(s);
                        }
                        boolean isRegular = tsc.interval > 0;
                        regularStoreMethod = this._regularStoreMethod;
                        irregularStoreMethod = this._irregularStoreMethod;
                        if (storeMethod == null || storeMethod.length() <= 0) break block11;
                        _storeMethod = storeMethod.toUpperCase();
                        if (!isRegular) break block12;
                        if (!_storeMethod.equals("REPLACE_ALL")) break block13;
                        regularStoreMethod = 0;
                        break block11;
                    }
                    if (!_storeMethod.equals("REPLACE_MISSING_VALUES_ONLY")) break block14;
                    regularStoreMethod = 1;
                    break block11;
                }
                if (_storeMethod.equals("REPLACE_ALL_CREATE")) {
                    regularStoreMethod = 2;
                    break block11;
                } else if (_storeMethod.equals("REPLACE_ALL_DELETE")) {
                    regularStoreMethod = 3;
                    break block11;
                } else {
                    if (!_storeMethod.equals("REPLACE_WITH_NON_MISSING")) {
                        String s = "Invalid regular time series store method: " + storeMethod;
                        System.out.println("DSSFile.write:" + s);
                        throw new DSSFileException(s);
                    }
                    regularStoreMethod = 4;
                }
                break block11;
            }
            if (_storeMethod.equals("MERGE")) {
                irregularStoreMethod = 0;
            } else {
                if (!_storeMethod.equals("DELETE_INSERT")) {
                    String s = "Invalid irregular time series store method: " + storeMethod;
                    System.out.println("DSSFile.write:" + s);
                    throw new DSSFileException(s);
                }
                irregularStoreMethod = 1;
            }
        }
        if ((writeRv = this._dataManager.writeData(tsc, regularStoreMethod, irregularStoreMethod)) != 0) {
            String s = "Write failed (rv=" + writeRv + ") for pathname=" + tsc.fullName;
            System.out.println("DSSFile.write:" + s);
            throw new DSSFileException(s);
        }
        return writeRv;
    }

    @Scriptable
    public Vector getCatalogedPathnames() {
        return this.getCatalogedPathnames(false);
    }

    @Scriptable
    public Vector getCatalogedPathnames(boolean forceNew) {
        return this.getCatalogedPathnames("A=*", forceNew);
    }

    @Scriptable
    public Vector getCatalogedPathnames(String scanString) {
        return this.getCatalogedPathnames(scanString, false);
    }

    @Scriptable
    public Vector searchPathnames(String scanString) {
        Vector<String> pathnameList = new Vector<String>();
        this._dataManager.setDSSFileName(this._filename);
        String _scanString = scanString.toUpperCase();
        boolean scanParts = false;
        int pos = scanString.indexOf("=");
        if (pos >= 1) {
            switch (_scanString.charAt(pos - 1)) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    scanParts = true;
                }
            }
        }
        if (scanParts) {
            this._dataManager.searchDSSPaths(_scanString.replaceAll("\\*", "@").replaceAll("!", "#"), pathnameList);
        } else {
            int nrec = this._dataManager.numberRecords();
            Vector<String> allPathnames = new Vector<String>(nrec);
            this._dataManager.searchDSSPaths(" ", allPathnames);
            _scanString = _scanString.replaceAll("@", "*").replaceAll("\\*", ".*").replaceAll("#", "!");
            boolean negate = _scanString.startsWith("!");
            if (negate) {
                _scanString = _scanString.substring(1);
            }
            for (int i = 0; i < allPathnames.size(); ++i) {
                String pathname = allPathnames.get(i);
                if (!(pathname.matches(_scanString) ^ negate)) continue;
                pathnameList.add(pathname);
            }
        }
        return pathnameList;
    }

    @Scriptable
    public Vector getCatalogedPathnames(String scanString, boolean forceNew) {
        Vector<String> pathnameList = new Vector<String>();
        this._dataManager.setDSSFileName(this._filename);
        this._dataManager.setForceNewCatalog(forceNew);
        String _scanString = scanString.toUpperCase();
        boolean scanParts = false;
        int pos = scanString.indexOf("=");
        if (pos >= 1) {
            switch (_scanString.charAt(pos - 1)) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    scanParts = true;
                }
            }
        }
        if (scanParts) {
            this._dataManager.searchDSSCatalog(_scanString.replaceAll("\\*", "@").replaceAll("!", "#"), pathnameList);
        } else {
            Vector<String> allPathnames = new Vector<String>();
            this._dataManager.searchDSSCatalog(" ", allPathnames);
            _scanString = _scanString.replaceAll("@", "*").replaceAll("\\*", ".*").replaceAll("#", "!");
            boolean negate = _scanString.startsWith("!");
            if (negate) {
                _scanString = _scanString.substring(1);
            }
            for (int i = 0; i < allPathnames.size(); ++i) {
                String pathname = allPathnames.get(i);
                if (!(pathname.matches(_scanString) ^ negate)) continue;
                pathnameList.add(pathname);
            }
        }
        return pathnameList;
    }

    @Scriptable
    public boolean recordExists(String pathname) {
        return this._dataManager.recordExists(pathname);
    }
}

