/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dObject;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.Viewport;
import hec.hecmath.DSS;
import hec.hecmath.DSSFile;
import hec.hecmath.DSSFileException;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.io.DataContainer;
import hec.io.TimeSeriesContainer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import rma.swing.RmaInsets;

public class DSSPlotCompare {
    private String[] _files;
    private int _plotIdx;
    private DSSFile[] _compareFiles;
    private List _catalog;
    private HecMath[] _compareMaths;
    private DSSFile _mainFile;
    private G2dDialog[] _plots;
    private NextDialog _controls;
    private int _lastX = 0;
    private int _lastY = 0;
    private Dimension _screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private int _plotPerPage;
    private boolean _firstTime = true;
    private Dimension _plotSize;

    public DSSPlotCompare(String[] files, String filter) {
        this._files = files;
        this._controls = new NextDialog();
        this.init(filter);
        this._firstTime = false;
    }

    private void init(String pathFilter) {
        if (!this.checkFiles()) {
            System.exit(2);
        }
        this._mainFile = DSS.open(this._files[0]);
        this._compareFiles = new DSSFile[this._files.length - 1];
        for (int i = 0; i < this._files.length - 1; ++i) {
            this._compareFiles[i] = DSS.open(this._files[i + 1]);
        }
        this._catalog = pathFilter != null ? this._mainFile.getCatalogedPathnames(pathFilter, this._firstTime) : this._mainFile.getCatalogedPathnames(this._firstTime);
        if (this._catalog.size() == 0) {
            JOptionPane.showMessageDialog(this._controls, "No paths found matching the filter '" + pathFilter + "'");
        }
        this._plots = new G2dDialog[this._catalog.size()];
        this._compareMaths = new HecMath[this._files.length - 1];
        this._plotIdx = 0;
        this._controls.setTitle(String.valueOf(this._catalog.size() + " Pathnames"));
        if (pathFilter != null) {
            this._controls.setStatus(pathFilter);
        }
        this.showPage();
    }

    private void showPage() {
        if (this._plots == null || this._plots.length == 0) {
            return;
        }
        if (this._plotIdx >= this._plots.length) {
            return;
        }
        int x = this._lastX;
        int y = this._lastY;
        this.showPlot(this._plotIdx);
        while (this._lastY != 50) {
            ++this._plotIdx;
            if (!this.showPlot(this._plotIdx)) break;
            if (!this._firstTime) continue;
            ++this._plotPerPage;
        }
    }

    private void reloadWithNewFilter() {
        this.closeOpenPlots();
        this._lastX = 0;
        this._lastY = 0;
        this._plotIdx = 0;
        this.init(this._controls.getFilter());
    }

    private void nextPage() {
        this.closeOpenPlots();
        this.showPage();
    }

    private void prevPage() {
        this._plotIdx -= this._plotPerPage * 2;
        if (this._plotIdx < 0) {
            this._plotIdx = 0;
        }
        this.closeOpenPlots();
        this.showPage();
    }

    private boolean showPlot(int catalogIdx) {
        G2dObject obj;
        DataContainer dc;
        HecMath mainMath;
        if (catalogIdx < 0 || catalogIdx >= this._plots.length) {
            return false;
        }
        if (this._plots[catalogIdx] != null) {
            this._plots[catalogIdx].setVisible(true);
            this._plots[catalogIdx].toFront();
            return true;
        }
        String pathname = (String)this._catalog.get(catalogIdx);
        try {
            mainMath = this._mainFile.read(pathname);
        }
        catch (HecMathException e) {
            System.out.println("showPlot: failed to load  " + pathname + " Error:" + e);
            return false;
        }
        if (mainMath == null) {
            System.out.println("showPlot:failed to read " + pathname + " from " + this._mainFile.getFilename());
            return false;
        }
        for (int c2 = 0; c2 < this._compareFiles.length; ++c2) {
            try {
                this._compareMaths[c2] = this._compareFiles[c2].read(pathname);
                continue;
            }
            catch (HecMathException e) {
                System.out.println("shotPlot: failed to load " + pathname + " from comparison file " + this._compareFiles[c2].getFilename() + " Error:" + e);
                continue;
            }
            catch (DSSFileException e) {
                System.out.println("showPlot: Error reading " + pathname + " from comparison file " + this._compareFiles[c2].getFilename() + " Error:" + e);
            }
        }
        Vector<Object> dataContainers = new Vector<Object>();
        try {
            dc = mainMath.getData();
            obj = this.setDataContainerName(dc, "(ref)");
            if (obj != null) {
                dataContainers.add(obj);
            } else {
                dataContainers.add(dc);
            }
        }
        catch (HecMathException e) {
            System.out.println("compare: failed get get data from " + pathname + " from " + this._files[0]);
            return false;
        }
        for (int d = 0; d < this._compareMaths.length; ++d) {
            if (this._compareMaths[d] == null) continue;
            try {
                dc = this._compareMaths[d].getData();
                obj = this.setDataContainerName(dc, "(comp" + (d + 1) + ")");
                if (obj != null) {
                    dataContainers.add(obj);
                    continue;
                }
                dataContainers.add(dc);
                continue;
            }
            catch (HecMathException e) {
                System.out.println("compare: failed to get data for " + pathname + " from " + this._compareFiles[d]);
            }
        }
        G2dDialog plot = new G2dDialog(null, "Pathname " + catalogIdx, false, dataContainers);
        plot.setPlotTitleText(pathname);
        plot.setPlotTitleVisible(true);
        plot.setLocation(this._lastX, this._lastY);
        plot.setVisible(true);
        if (this._plotSize != null) {
            plot.setSize(this._plotSize);
        } else if (plot.getWidth() * 2 > this._screenSize.width) {
            this._plotSize = plot.getSize();
            this._plotSize.width = this._screenSize.width / 2;
            this._plotSize.width -= 3;
            double ratio = (double)this._plotSize.width / (double)plot.getWidth();
            this._plotSize.height = (int)((double)this._plotSize.height * ratio);
            if (this._plotSize.height * 2 > this._screenSize.height) {
                this._plotSize.height = this._screenSize.height / 2;
                this._plotSize.height -= 3;
            }
            plot.setSize(this._plotSize);
        }
        Viewport vp = plot.getViewport(0);
        this._lastX += plot.getWidth();
        if (this._lastX + plot.getWidth() > this._screenSize.width) {
            this._lastX = 0;
            this._lastY += plot.getHeight();
            if (this._lastY + plot.getHeight() > this._screenSize.height) {
                this._lastY = 50;
                this._lastY = 50;
            }
        }
        this._plots[catalogIdx] = plot;
        return true;
    }

    private G2dObject setDataContainerName(DataContainer dc, String string) {
        if (dc instanceof TimeSeriesContainer) {
            TimeSeriesContainer tsc = (TimeSeriesContainer)dc;
            TimeSeriesDataSet tsds = new TimeSeriesDataSet(tsc);
            tsds.setName(tsds.getName() + string);
            return tsds;
        }
        return null;
    }

    private boolean checkFiles() {
        for (int i = 0; i < this._files.length; ++i) {
            if (new File(this._files[i]).exists()) continue;
            System.out.println("checkFiles: Failed to find " + this._files[i]);
            return false;
        }
        return true;
    }

    private void bringPlotsToFront() {
        if (this._plots == null) {
            return;
        }
        for (int i = 0; i < this._plots.length; ++i) {
            if (this._plots[i] == null || !this._plots[i].isVisible()) continue;
            this._plots[i].toFront();
        }
    }

    protected void setPlotsIconified(boolean iconified) {
        if (this._plots == null) {
            return;
        }
        int state = iconified ? 1 : 0;
        for (int i = 0; i < this._plots.length; ++i) {
            if (this._plots[i] == null || !this._plots[i].isVisible()) continue;
            this._plots[i].setState(state);
        }
    }

    public static void main(String[] args) {
        String[] files;
        if (args == null || args.length < 2) {
            System.out.println("USAGE: " + DSSPlotCompare.class.getName() + "[-fpathfilter] dssfile compareDssFile [compareDssFile2][...]");
            System.exit(1);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("SetLookAndFeel Error " + e);
        }
        String filter = null;
        if (args[0].startsWith("-f")) {
            filter = args[0].substring(2);
            files = new String[args.length - 1];
            System.arraycopy(args, 1, files, 0, files.length);
        } else {
            files = args;
        }
        new DSSPlotCompare(files, filter);
    }

    public void closeOpenPlots() {
        for (int i = 0; i < this._plots.length; ++i) {
            if (this._plots[i] == null) continue;
            this._plots[i].setVisible(false);
            this._plots[i] = null;
        }
        this._lastX = 0;
        this._lastY = 0;
    }

    private class NextDialog
    extends JFrame {
        private JButton _nextButton;
        private JButton _prevButton;
        private JButton _exitButton;
        private JButton _closeAllButton;
        private JTextField _statusLine;
        protected boolean _bringingToFront;
        protected long _frontTime;

        public NextDialog() {
            this.buildControls();
            this.addListeners();
            this.pack();
            Dimension mySize = this.getSize();
            int ix = (DSSPlotCompare.this._screenSize.width - mySize.width) / 2;
            int iy = DSSPlotCompare.this._screenSize.height - mySize.height;
            this.setLocation(ix, iy);
            this.setVisible(true);
            this.setAlwaysOnTop(true);
        }

        private void buildControls() {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setDefaultCloseOperation(0);
            this._prevButton = new JButton("Prev Page");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5505;
            this.getContentPane().add((Component)this._prevButton, gbc);
            this._nextButton = new JButton("Next Page");
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5505;
            this.getContentPane().add((Component)this._nextButton, gbc);
            this._closeAllButton = new JButton("Close All");
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5505;
            this.getContentPane().add((Component)this._closeAllButton, gbc);
            this._exitButton = new JButton("Quit");
            gbc.gridx = 3;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5505;
            this.getContentPane().add((Component)this._exitButton, gbc);
            this._statusLine = new JTextField();
            this._statusLine.setToolTipText("<html>Enter a filter. Filters look like:<br><i>pathPart</i>=filter*<br> where pathPart can be A,B,C,D,E or F</html>");
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.gridwidth = 4;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.INSETS5505;
            this.getContentPane().add((Component)this._statusLine, gbc);
        }

        private void addListeners() {
            this._nextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DSSPlotCompare.this.nextPage();
                }
            });
            this._prevButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DSSPlotCompare.this.prevPage();
                }
            });
            this._exitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
            this._closeAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DSSPlotCompare.this.closeOpenPlots();
                }
            });
            this._statusLine.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DSSPlotCompare.this.reloadWithNewFilter();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    if (System.currentTimeMillis() < NextDialog.this._frontTime + 1000L) {
                        return;
                    }
                    NextDialog.this._frontTime = System.currentTimeMillis();
                    DSSPlotCompare.this.bringPlotsToFront();
                    NextDialog.this.toFront();
                }

                @Override
                public void windowIconified(WindowEvent e) {
                    DSSPlotCompare.this.setPlotsIconified(true);
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                    DSSPlotCompare.this.setPlotsIconified(false);
                }
            });
        }

        public String getFilter() {
            return this._statusLine.getText();
        }

        public void setStatus(String status) {
            this._statusLine.setText(status);
        }
    }
}

