/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dObject;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.Viewport;
import hec.gfx2d.dss.G2dDssObject;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.PairedDataMath;
import hec.hecmath.TimeSeriesMath;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.util.Vector;

public class DisplayUtilities {
    public static DataContainer createDisplayObject(HecMath dataSet) {
        if (dataSet == null) {
            return null;
        }
        DataContainer dc = null;
        if (dataSet instanceof PairedDataMath) {
            dc = new PairedDataContainer();
        } else if (dataSet instanceof TimeSeriesMath) {
            dc = new TimeSeriesContainer();
        }
        if (dc == null) {
            return null;
        }
        try {
            dataSet.getData(dc);
            return dc;
        }
        catch (HecMathException e) {
            System.err.println("Exception Occurred in DisplayUtilities.createDisplayObject");
            System.err.println(e.getMessage());
            return null;
        }
    }

    public static Viewport getViewport(G2dDialog gfxDlg, HecMath dataSet) {
        if (dataSet == null) {
            return null;
        }
        String path = dataSet.getPath();
        return DisplayUtilities.getViewport(gfxDlg, path);
    }

    public static Viewport getViewport(G2dDialog gfxDlg, String dataSetPath) {
        if (dataSetPath == null) {
            System.out.println("getViewport: no dataSetPath!");
            return null;
        }
        if (gfxDlg == null) {
            System.out.println("getCurve: no G2dDialog!");
        }
        Vector viewPorts = gfxDlg.getViewports();
        for (int i = 0; i < viewPorts.size(); ++i) {
            Viewport v = (Viewport)viewPorts.get(i);
            Vector glyphVector = v.getGlyphVector();
            for (int j = 0; j < glyphVector.size(); ++j) {
                G2dGlyph glyph = (G2dGlyph)glyphVector.get(j);
                G2dObject obj = glyph.getG2dObject();
                if (obj instanceof G2dDssObject) {
                    G2dDssObject dssObj = (G2dDssObject)obj;
                    if (!dssObj.getDSSIdentifer().getDSSPath().equals(dataSetPath)) continue;
                    return v;
                }
                if (!(obj instanceof TimeSeriesDataSet)) continue;
                TimeSeriesDataSet tsds = (TimeSeriesDataSet)obj;
                if (!dataSetPath.equals(tsds._timeSeries.fullName)) continue;
                return v;
            }
        }
        System.out.println("getViewport: failed to find Viewport for curve " + dataSetPath);
        return null;
    }

    public static G2dLine getCurve(G2dDialog gfxDlg, HecMath dataSet) {
        if (dataSet == null) {
            return null;
        }
        String path = dataSet.getPath();
        return DisplayUtilities.getCurve(gfxDlg, path);
    }

    public static G2dLine getCurve(G2dDialog gfxDlg, String dssPath) {
        if (dssPath == null) {
            System.out.println("getCurve: no DSS path!");
            return null;
        }
        if (gfxDlg == null) {
            System.out.println("getCurve: no G2dDialog!");
        }
        Vector viewPorts = gfxDlg.getViewports();
        for (int i = 0; i < viewPorts.size(); ++i) {
            Viewport v = (Viewport)viewPorts.get(i);
            Vector glyphVector = v.getGlyphVector();
            for (int j = 0; j < glyphVector.size(); ++j) {
                G2dGlyph glyph = (G2dGlyph)glyphVector.get(j);
                G2dObject obj = glyph.getG2dObject();
                if (obj instanceof G2dDssObject) {
                    G2dDssObject dssObj = (G2dDssObject)obj;
                    if (!dssObj.getDSSIdentifer().getDSSPath().equals(dssPath)) continue;
                    return glyph.getLine();
                }
                if (!(obj instanceof TimeSeriesDataSet)) continue;
                TimeSeriesDataSet tsds = (TimeSeriesDataSet)obj;
                if (!dssPath.equals(tsds._timeSeries.fullName)) continue;
                return glyph.getLine();
            }
        }
        System.out.println("getCurve: failed to find curve for " + dssPath);
        return null;
    }
}

