/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

import java.util.function.DoubleUnaryOperator;

public final class DoubleArrayUtilities {
    private static final double MONOTONICITYFACTOR = 1.0E-5;

    private DoubleArrayUtilities() {
    }

    public static double interpolatePairedArrays(double xValue, double[] xArray, double[] yArray) {
        int index = DoubleArrayUtilities.binarySearch(xValue, xArray);
        Double retval = DoubleArrayUtilities.interpolate(xValue, xArray[index], yArray[index], xArray[index + 1], yArray[index + 1]);
        return retval;
    }

    public static int binarySearch(double xValue, double[] xArray) {
        int index = xArray[1] - xArray[0] > 0.0 ? DoubleArrayUtilities.binarySearchAscending(xArray, 0, xArray.length - 1, xValue) : DoubleArrayUtilities.binarySearchDescending(xArray, 0, xArray.length - 1, xValue);
        if (index < 0) {
            index = DoubleArrayUtilities.correctIndexForArray(xArray, index);
        }
        return index;
    }

    public static boolean enforceMontonicallyDecreasing(double[] array, int middleIndex) {
        double thisValue;
        int y;
        boolean wasModified = false;
        for (y = middleIndex; y < array.length - 1; ++y) {
            double smaller = array[y + 1];
            thisValue = array[y];
            if (!(smaller >= thisValue)) continue;
            wasModified = true;
            array[y + 1] = thisValue - thisValue * 1.0E-5;
        }
        for (y = middleIndex; y > 0; --y) {
            double larger = array[y - 1];
            thisValue = array[y];
            if (!(larger <= thisValue)) continue;
            wasModified = true;
            array[y - 1] = thisValue + thisValue * 1.0E-5;
        }
        return wasModified;
    }

    public static void enforceMontonicallyIncreasing(double[] array, int middleIndex) {
        double thisValue;
        int y;
        for (y = middleIndex; y < array.length - 1; ++y) {
            double largerValue = array[y + 1];
            thisValue = array[y];
            if (!(largerValue <= thisValue)) continue;
            array[y + 1] = thisValue + thisValue * 1.0E-5;
        }
        for (y = middleIndex; y > 0; --y) {
            double smallerValue = array[y - 1];
            thisValue = array[y];
            if (!(smallerValue >= thisValue)) continue;
            array[y - 1] = thisValue - thisValue * 1.0E-5;
        }
    }

    public static double[] linearInterpolationFill(int numOrdinates, double first, double last) {
        double[] retval = new double[numOrdinates];
        double fraction = (last - first) / (double)(numOrdinates - 1);
        for (int i = 0; i < numOrdinates; ++i) {
            retval[i] = fraction * (double)i + first;
        }
        return retval;
    }

    private static int correctIndexForArray(double[] array, int index) {
        if ((index = -index - 2) < 0) {
            index = 0;
        }
        if (index > array.length - 2) {
            index = array.length - 2;
        }
        return index;
    }

    public static Double interpolate(Double x, Double x1, Double y1, Double x2, Double y2) {
        double xDiff = x2 - x1;
        double yDiff = y2 - y1;
        double slope = yDiff / xDiff;
        return y1 + (x - x1) * slope;
    }

    private static int binarySearchAscending(double[] a, int fromIndex, int toIndex, double value) {
        double key = value;
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            long keyBits;
            int mid = low + high >>> 1;
            double midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            long midBits = Double.doubleToLongBits(midVal);
            if (midBits == (keyBits = Double.doubleToLongBits(key))) {
                return mid;
            }
            if (midBits < keyBits) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    private static int binarySearchDescending(double[] a, int fromIndex, int toIndex, double value) {
        double key = value;
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            long keyBits;
            int mid = low + high >>> 1;
            double midVal = a[mid];
            if (midVal > key) {
                low = mid + 1;
                continue;
            }
            if (midVal < key) {
                high = mid - 1;
                continue;
            }
            long midBits = Double.doubleToLongBits(midVal);
            if (midBits == (keyBits = Double.doubleToLongBits(key))) {
                return mid;
            }
            if (midBits > keyBits) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    public static void arrayTransform(DoubleUnaryOperator function, double[] array) {
        DoubleArrayUtilities.arrayFunctionalFill(function, array, array);
    }

    public static void arrayFunctionalFill(DoubleUnaryOperator function, double[] dataArray, double[] arrayToFill) {
        for (int i = 0; i < arrayToFill.length; ++i) {
            arrayToFill[i] = function.applyAsDouble(dataArray[i]);
        }
    }

    public static double[][] copyArray(double[][] array) {
        double[][] retval = new double[array.length][array[0].length];
        for (int i = 0; i < array.length; ++i) {
            DoubleArrayUtilities.arrayFunctionalFill(DoubleArrayUtilities::noFunction, array[i], retval[i]);
        }
        return retval;
    }

    public static double[] copyArray(double[] array) {
        double[] retval = new double[array.length];
        DoubleArrayUtilities.arrayFunctionalFill(DoubleArrayUtilities::noFunction, array, retval);
        return retval;
    }

    private static double noFunction(Double value) {
        return value;
    }
}

