/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

import hec.hecmath.DoubleArrayBinaryFunction;
import hec.hecmath.DoubleArrayUtilities;
import hec.hecmath.IntBinaryToDoubleFunction;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;

public class DoubleInterpolationTable {
    private double[] _x;
    private double[] _y;
    private double[][] _data;
    private double[] _workingColumn;

    public DoubleInterpolationTable(double[] x, double[] y, double[][] data) {
        this.dataChecks(x, y, data);
        this._x = x;
        this._y = y;
        this._data = data;
        this._workingColumn = new double[this._y.length];
    }

    private void dataChecks(double[] x, double[] y, double[][] data) {
        if (x.length != data.length) {
            throw new IllegalArgumentException("x value array doesn't have same number of elements as the data has columns");
        }
        if (y.length != data[0].length) {
            throw new IllegalArgumentException("y value array doesn't have same number of elements as the data has rows");
        }
        if (!this.isMonotonic(x)) {
            throw new IllegalArgumentException("x value array is not monotonic");
        }
        if (!this.isMonotonic(y)) {
            throw new IllegalArgumentException("x value array is not monotonic");
        }
    }

    private boolean isMonotonic(double[] values) {
        boolean retval = true;
        Double firstDiff = values[1] - values[0];
        if (firstDiff == 0.0) {
            retval = false;
        } else {
            boolean increasing = firstDiff > 0.0;
            for (int i = 2; i < values.length; ++i) {
                Double diff = values[i] - values[i - 1];
                if (!(increasing && diff <= 0.0) && (increasing || !(diff >= 0.0))) continue;
                retval = false;
                break;
            }
        }
        return retval;
    }

    public double[] getXValues() {
        return DoubleArrayUtilities.copyArray(this._x);
    }

    public double[] getYValues() {
        return DoubleArrayUtilities.copyArray(this._y);
    }

    public void functionalTableDefinition(DoubleBinaryOperator function) {
        for (int x = 0; x < this._x.length; ++x) {
            for (int y = 0; y < this._y.length; ++y) {
                this._data[x][y] = function.applyAsDouble(this._x[x], this._y[y]);
            }
        }
    }

    public void enforceMonotonicallyIncreasingColumns(double middleValue) {
        int index = DoubleArrayUtilities.binarySearch(middleValue, this.getYValues());
        for (int x = 0; x < this._x.length; ++x) {
            DoubleArrayUtilities.enforceMontonicallyIncreasing(this._data[x], index);
        }
    }

    public boolean enforceMonotonicallyDecreasingColumns(double middleValue) {
        boolean wasModified = false;
        int index = DoubleArrayUtilities.binarySearch(middleValue, this.getYValues());
        for (int x = 0; x < this._x.length; ++x) {
            wasModified = DoubleArrayUtilities.enforceMontonicallyDecreasing(this._data[x], index) || wasModified;
        }
        return wasModified;
    }

    public void tableDefinition(IntBinaryToDoubleFunction function) {
        for (int x = 0; x < this._x.length; ++x) {
            for (int y = 0; y < this._y.length; ++y) {
                this._data[x][y] = function.applyAsDouble(x, y);
            }
        }
    }

    public void scalarTableTransformation(DoubleUnaryOperator function) {
        for (double[] column : this._data) {
            DoubleArrayUtilities.arrayTransform(function, column);
        }
    }

    public void transformAxis(DoubleUnaryOperator function, Axis axis) {
        double[] array = null;
        if (Axis.X.equals((Object)axis)) {
            array = this._x;
        } else if (Axis.Y.equals((Object)axis)) {
            array = this._y;
        }
        if (array != null) {
            DoubleArrayUtilities.arrayTransform(function, array);
        }
    }

    public void columnSummary(DoubleArrayBinaryFunction function, double[] arrayToFill) {
        if (arrayToFill.length != this._x.length) {
            throw new IllegalArgumentException("Expecting array of size " + this._x.length + " but received " + arrayToFill.length);
        }
        for (int i = 0; i < this._x.length; ++i) {
            arrayToFill[i] = function.apply(this._y, this._data[i]);
        }
    }

    public double getMin() {
        Double retval = Double.MAX_VALUE;
        double[][] dArray = this._data;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] column;
            double[] dArray2 = column = dArray[i];
            int n2 = dArray2.length;
            for (int j = 0; j < n2; ++j) {
                Double value = dArray2[j];
                if (!(value < retval)) continue;
                retval = value;
            }
        }
        return retval;
    }

    public double getMax() {
        Double retval = -1.7976931348623157E308;
        double[][] dArray = this._data;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] column;
            double[] dArray2 = column = dArray[i];
            int n2 = dArray2.length;
            for (int j = 0; j < n2; ++j) {
                Double value = dArray2[j];
                if (!(value > retval)) continue;
                retval = value;
            }
        }
        return retval;
    }

    public double interpolateY(double x, double dataValue) {
        double[] column = this.interpolateColumn(x);
        return DoubleArrayUtilities.interpolatePairedArrays(dataValue, column, this._y);
    }

    private double[] interpolateColumn(double x) {
        int index = DoubleArrayUtilities.binarySearch(x, this._x);
        double[] column = this._x[index] == x ? this._data[index] : this.interpolateColumn(x, index, index + 1);
        return column;
    }

    public double interpolate(double x, double y) {
        double[] column = this.interpolateColumn(x);
        return DoubleArrayUtilities.interpolatePairedArrays(y, this._y, column);
    }

    private double[] interpolateColumn(double x, int column1, int column2) {
        for (int i = 0; i < this._workingColumn.length; ++i) {
            this._workingColumn[i] = DoubleArrayUtilities.interpolate(x, this._x[column1], this._data[column1][i], this._x[column2], this._data[column2][i]);
        }
        return this._workingColumn;
    }

    public static enum Axis {
        X,
        Y;

    }
}

