/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

import hec.data.ParamDouble;
import hec.heclib.dss.DSSPathname;
import hec.hecmath.DSS;
import hec.hecmath.DSSFile;
import hec.hecmath.DSSFileException;
import hec.hecmath.DataSetResults;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.PairedDataMath;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import hec.ui.ProgressListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class DssCompare {
    private static final String LATEST_TIME = "31Dec2099 2400";
    private static final String EARLIEST_TIME = "01Jan1900 0000";
    private static String _referencePathname;
    private String _watershed;
    private String _altName;
    private ProgressListener _progressListener;
    private Set<String> _missingPathsList;
    private static HecMath _referenceHecMath;
    private static HecMath _computedHecMath;
    private static DSSFile _computedDSSFile;
    private static DSSFile _referenceDSSFile;
    private static String _startTime;
    private static String _endTime;
    public static boolean DEBUG;
    private static boolean IS_DATA_CONTAINER;

    public DssCompare() {
    }

    public DssCompare(String watershed, String altName) {
        this._watershed = watershed;
        this._altName = altName;
    }

    public DataSetResults getDataSetResults(String computedFile, String referenceFile, String startTime, String endTime, String dssCompareOutputFile, String[] dsspath, double[] tol) {
        return this.getDataSetResults(computedFile, referenceFile, startTime, endTime, dssCompareOutputFile, dsspath, tol, false, " ", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSetResults writeOutput(String computedFile, String referenceFile, String startTime, String endTime, String dssCompareOutputFile, String[] dsspath, double[] tol, boolean tabulate, String sepChar, boolean printAllResults, boolean isTimeDefined) {
        File tempOut;
        BufferedWriter out = null;
        DataSetResults dsr = null;
        if (startTime != null) {
            _startTime = startTime;
        }
        if (endTime != null) {
            _endTime = endTime;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        dateFormat.format(date);
        DSSFile dssFileReference = DSS.open(referenceFile);
        DSSFile dssFileComputed = DSS.open(computedFile);
        if (dssCompareOutputFile == null) {
            dssCompareOutputFile = this._altName + ".txt";
        }
        if ((tempOut = new File((String)dssCompareOutputFile)).isDirectory() && DEBUG) {
            System.out.println("WARNING:" + tempOut + "is a directory!");
        }
        if (tempOut.exists() && tempOut.isFile()) {
            tempOut.delete();
        }
        List<List<String>> dssReferencePathList = this.getPathnamesList(dssFileReference, dsspath);
        try {
            out = new BufferedWriter(new FileWriter((String)dssCompareOutputFile, true));
            out.write("#Date: " + date);
            out.newLine();
            out.write("#Reference File: " + referenceFile);
            out.newLine();
            out.write("#Compute File: " + computedFile);
            out.newLine();
            if (isTimeDefined) {
                out.write("#Start Time: " + startTime);
                out.newLine();
                out.write("#End Time: " + endTime);
                out.newLine();
            }
            for (int indx = 0; indx < dsspath.length; ++indx) {
                out.newLine();
                out.write("#" + (indx + 1) + ") Dss path parts: " + String.valueOf(dsspath[indx]));
                out.write(sepChar);
                if (dsspath.length != tol.length) {
                    out.write("tolerance: " + String.valueOf(tol[0]));
                    continue;
                }
                out.write("tolerance: " + String.valueOf(tol[indx]));
            }
            out.newLine();
            out.newLine();
            if (this._watershed != null) {
                out.write("Watershed=");
                out.write(this._watershed);
                out.write(sepChar);
            }
            if (this._altName != null) {
                out.write("Alternative=");
                out.write(this._altName);
            }
            out.newLine();
            if (tabulate) {
                out.newLine();
                out.write("Type:");
                out.write(sepChar);
                out.write("Pathname");
                out.write(sepChar);
                out.write("MaxAbsDiff");
                out.write(sepChar);
                out.write("AvgDiff");
                out.write(sepChar);
                out.write("rmsDiff");
                out.newLine();
            }
            dsr = this.computeStats(dssReferencePathList, tol, dssFileReference, dssFileComputed, sepChar, startTime, endTime, tabulate, printAllResults, out);
            if (this._missingPathsList != null) {
                for (String missingPath : this._missingPathsList) {
                    out.write("Missing Path in Computed DSS File: ");
                    out.write(missingPath);
                    out.newLine();
                }
            }
            out.newLine();
            out.write("Summary:");
            out.newLine();
            out.write("Paths Compared=");
            out.write(String.valueOf(dsr.pathsCompared));
            out.newLine();
            out.write("Missing paths=");
            out.write(String.valueOf(dsr.missingDatasetPathsCounter));
            out.newLine();
            out.write("Invalid paths=");
            out.write(String.valueOf(dsr.differentLengthPathsCounter));
            out.newLine();
            out.write("Paths outside of Tolerance=");
            out.write(String.valueOf(dsr.pathsOutOfTolCounter));
            out.newLine();
            out.newLine();
        }
        catch (IOException ioe) {
            if (DEBUG) {
                System.out.println("dssCompareOutputFile: Error accessing dssCompareOutputFile from " + (String)dssCompareOutputFile + " Error:" + ioe);
                ioe.printStackTrace();
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        dssFileReference.close();
        dssFileComputed.close();
        return dsr;
    }

    public DataSetResults getDataSetResults(String computedFile, String referenceFile, String dssCompareOutputFile, String[] dsspath, double[] tol, boolean tabulate, String sepChar, boolean printAllResults) {
        DataSetResults dsr = this.writeOutput(computedFile, referenceFile, null, null, dssCompareOutputFile, dsspath, tol, tabulate, sepChar, printAllResults, false);
        return dsr;
    }

    public DataSetResults getDataSetResults(String computedFile, String referenceFile, String startTime, String endTime, String dssCompareOutputFile, String[] dsspath, double[] tol, boolean tabulate, String sepChar, boolean printAllResults) {
        DataSetResults dsr = this.writeOutput(computedFile, referenceFile, startTime, endTime, dssCompareOutputFile, dsspath, tol, tabulate, sepChar, printAllResults, true);
        return dsr;
    }

    private DataSetResults computeStats(List<List<String>> dssReferencePathList, double[] tol, DSSFile referenceDssFile, DSSFile computedDssFile, String sepChar, String startTime, String endTime, boolean tabulate, boolean printAllResults, BufferedWriter out) {
        DataSetResults dsr = new DataSetResults();
        DataSetResults.ResultsType resultsType = DataSetResults.ResultsType.NO_DIFFERENCE_FOUND;
        for (int indx = 0; indx < tol.length; ++indx) {
            if (dssReferencePathList == null) {
                if (DEBUG) {
                    System.out.println("EmptyMapObjects: Reference Path List is empty");
                }
                if (dsr.getResultSType() == null) {
                    dsr.setResultSType(DataSetResults.ResultsType.NO_DIFFERENCE_FOUND);
                }
                return dsr;
            }
            List<String> dssReferencePaths = dssReferencePathList.get(indx);
            int count = 1;
            for (int j = 0; j < dssReferencePaths.size(); ++j) {
                String dssPathString;
                block37: {
                    String endDateAndTime;
                    String startDateAndTime;
                    block36: {
                        dssPathString = dssReferencePaths.get(j);
                        if (this._progressListener != null) {
                            this._progressListener.progress("Comparing Path " + count++);
                        }
                        if (dssPathString == null) continue;
                        _referenceHecMath = null;
                        _computedHecMath = null;
                        DSSPathname dssPathName = new DSSPathname();
                        dssPathName.setPathname(dssPathString);
                        startDateAndTime = _startTime != null ? _startTime : EARLIEST_TIME;
                        endDateAndTime = _endTime != null ? _endTime : LATEST_TIME;
                        try {
                            _referenceHecMath = referenceDssFile.read(dssPathString, startDateAndTime, endDateAndTime, true);
                            if (!(_referenceHecMath instanceof PairedDataMath) && _referenceHecMath.numberValidValues() <= 2) break block36;
                            _referencePathname = dssPathString;
                            _referenceDSSFile = referenceDssFile;
                        }
                        catch (DSSFileException e) {
                            dsr.setResultSType(DataSetResults.ResultsType.EMPTY_DATASET);
                            System.out.println("DSSFile: Error reading data from " + dssPathString.toString() + "\nError:" + e);
                            if (this._missingPathsList == null) {
                                this._missingPathsList = new HashSet<String>();
                            }
                            this._missingPathsList.add(dssPathString.toString());
                            continue;
                        }
                        catch (HecMathException e) {
                            if (_referenceHecMath == null) continue;
                            dsr.setResultSType(DataSetResults.ResultsType.EMPTY_DATASET);
                            System.out.println("HECMath: Error reading data from " + dssPathString.toString() + "\nError:" + e);
                            e.printStackTrace();
                            continue;
                        }
                    }
                    try {
                        _computedHecMath = computedDssFile.read(dssPathString, startDateAndTime, endDateAndTime, true);
                        if (!(_referenceHecMath instanceof PairedDataMath) && _referenceHecMath.numberValidValues() <= 2) break block37;
                        _computedDSSFile = computedDssFile;
                    }
                    catch (DSSFileException e) {
                        dsr.setResultSType(DataSetResults.ResultsType.MISSING_DATASET);
                        System.out.println("DSSFile: Error reading data from " + dssPathString.toString() + "\nError:" + e);
                        if (this._missingPathsList == null) {
                            this._missingPathsList = new HashSet<String>();
                        }
                        this._missingPathsList.add(dssPathString.toString());
                        continue;
                    }
                    catch (HecMathException e) {
                        if (this._missingPathsList == null) {
                            this._missingPathsList = new HashSet<String>();
                        }
                        this._missingPathsList.add(dssPathString.toString());
                        if (_computedHecMath == null) continue;
                        dsr.setResultSType(DataSetResults.ResultsType.MISSING_DATASET);
                        System.out.println("HECMath: Error reading data from " + dssPathString.toString() + "\nError:" + e);
                        e.printStackTrace();
                        continue;
                    }
                }
                ArrayList<DataSetResults> dataSetResultsList = null;
                try {
                    DataContainer refData = _referenceHecMath.getData();
                    DataContainer computedData = _computedHecMath.getData();
                    if (refData instanceof PairedDataContainer) {
                        double[] tolToUse = new double[]{tol[j]};
                        dataSetResultsList = DssCompare.compareDataSet(refData, computedData, tolToUse);
                    } else {
                        dataSetResultsList = DssCompare.compareDataSet(_referenceHecMath.getData(), _computedHecMath.getData(), tol);
                    }
                }
                catch (HecMathException e) {
                    e.printStackTrace();
                }
                if (dataSetResultsList == null || dataSetResultsList.size() < 1) continue;
                for (DataSetResults dataSetResults : dataSetResultsList) {
                    resultsType = DssCompare.setResultsType(resultsType, dataSetResults.getResultSType());
                    dsr.setResultSType(resultsType);
                    ++dsr.pathsCompared;
                    try {
                        String pathName2;
                        int i;
                        String pathName;
                        String outOfTolPaths;
                        if (dataSetResults.getResultSType() == DataSetResults.ResultsType.DIFFERENCE_OUTSIDE_OF_TOLERANCE && !tabulate) {
                            outOfTolPaths = "Diff:" + sepChar + dssPathString.toString() + sepChar + "MaxAbsDiff=" + String.valueOf(dataSetResults.maxAbsDiff) + sepChar + "AvgDiff=" + String.valueOf(dataSetResults.meanDiff) + sepChar + "rmsDiff=" + String.valueOf(dataSetResults.rootMeanSquareDiff);
                            if (dsr.outOfTolPathsLIST.size() > 0 && !dsr.outOfTolPathsLIST.contains(outOfTolPaths)) {
                                pathName = outOfTolPaths.substring(outOfTolPaths.indexOf("/", outOfTolPaths.indexOf("Diff:" + sepChar)), outOfTolPaths.lastIndexOf("/") + 1);
                                for (i = 0; i < dsr.outOfTolPathsLIST.size() && !(pathName2 = dsr.outOfTolPathsLIST.get(i).substring(dsr.outOfTolPathsLIST.get(i).indexOf("/", dsr.outOfTolPathsLIST.get(i).indexOf("Diff:" + sepChar)), dsr.outOfTolPathsLIST.get(i).lastIndexOf("/") + 1)).equalsIgnoreCase(pathName); ++i) {
                                }
                                dsr.outOfTolPathsLIST.add(outOfTolPaths);
                                ++dsr.pathsOutOfTolCounter;
                                out.write(outOfTolPaths);
                                out.newLine();
                                out.flush();
                                continue;
                            }
                            if (dsr.outOfTolPathsLIST.contains(outOfTolPaths)) continue;
                            dsr.outOfTolPathsLIST.add(outOfTolPaths);
                            ++dsr.pathsOutOfTolCounter;
                            out.write(outOfTolPaths);
                            out.newLine();
                            out.flush();
                            continue;
                        }
                        if (dataSetResults.getResultSType() == DataSetResults.ResultsType.DIFFERENCE_OUTSIDE_OF_TOLERANCE && tabulate) {
                            outOfTolPaths = "Diff:" + sepChar + dssPathString.toString() + sepChar + "MaxAbsDiff=" + String.valueOf(dataSetResults.maxAbsDiff) + sepChar + "AvgDiff=" + String.valueOf(dataSetResults.meanDiff) + sepChar + "rmsDiff=" + String.valueOf(dataSetResults.rootMeanSquareDiff);
                            if (dsr.outOfTolPathsLIST.contains(outOfTolPaths)) continue;
                            if (dsr.outOfTolPathsLIST.size() == 0) {
                                dsr.outOfTolPathsLIST.add(outOfTolPaths);
                                ++dsr.pathsOutOfTolCounter;
                                out.write(outOfTolPaths);
                                out.newLine();
                                out.flush();
                            }
                            pathName = outOfTolPaths.substring(outOfTolPaths.indexOf("/", outOfTolPaths.indexOf("Diff:" + sepChar)), outOfTolPaths.lastIndexOf("/") + 1);
                            for (i = 0; i < dsr.outOfTolPathsLIST.size() && !(pathName2 = dsr.outOfTolPathsLIST.get(i).substring(dsr.outOfTolPathsLIST.get(i).indexOf("/", dsr.outOfTolPathsLIST.get(i).indexOf("Diff:" + sepChar)), dsr.outOfTolPathsLIST.get(i).lastIndexOf("/") + 1)).equalsIgnoreCase(pathName); ++i) {
                                if (pathName2.equalsIgnoreCase(pathName) || i != dsr.outOfTolPathsLIST.size() - 1) continue;
                                dsr.outOfTolPathsLIST.add(outOfTolPaths);
                                ++dsr.pathsOutOfTolCounter;
                                out.write(outOfTolPaths);
                                out.newLine();
                                out.flush();
                            }
                            continue;
                        }
                        if (dataSetResults.getResultSType() == DataSetResults.ResultsType.MISSING_DATASET) {
                            out.write("Missing:");
                            out.write(sepChar);
                            out.write(dssPathString.toString());
                            out.newLine();
                            out.flush();
                            String missingDataSetPaths = "Missing:" + sepChar + dssPathString.toString();
                            dsr.missingDatasetPathsLIST.add(missingDataSetPaths);
                            ++dsr.missingDatasetPathsCounter;
                            continue;
                        }
                        if (dataSetResults.getResultSType() == DataSetResults.ResultsType.DIFFERENCE_WITH_LABELS) {
                            out.write("Different Labels:");
                            out.write(sepChar);
                            out.write(dssPathString.toString());
                            out.newLine();
                            out.flush();
                            String differentLabelsPaths = "Different Labels:" + sepChar + dssPathString.toString();
                            dsr.differentLabelsDatasetPathsLIST.add(differentLabelsPaths);
                            ++dsr.differentLabelsDatasetPathsCounter;
                            continue;
                        }
                        if (dataSetResults.getResultSType() == DataSetResults.ResultsType.INVALID_TOLERANCES) {
                            out.write("Invalid Number of Tolerances:");
                            out.write(sepChar);
                            out.write(dssPathString.toString());
                            out.newLine();
                            out.flush();
                            String invalidTolerancesPaths = "Invalid Number of Tolerances:" + sepChar + dssPathString.toString();
                            dsr.numberOfCurvesWithInvalidTolerancesLIST.add(invalidTolerancesPaths);
                            ++dsr.numberOfCurvesWithInvalidTolerances;
                            continue;
                        }
                        if (dataSetResults.getResultSType() == DataSetResults.ResultsType.DIFFERENT_UNITS) {
                            out.write("Different Units:");
                            out.write(sepChar);
                            out.write(dssPathString.toString());
                            out.newLine();
                            out.flush();
                            String differentUnitsPaths = "Different Units:" + sepChar + dssPathString.toString();
                            dsr.differentUnitsDatasetPathsLIST.add(differentUnitsPaths);
                            ++dsr.differentUnitsDatasetPathsCounter;
                            continue;
                        }
                        if (dataSetResults.getResultSType() == DataSetResults.ResultsType.DIFFERENCE_WITH_NUMBER_OF_CURVES) {
                            out.write("Different Number of Curves");
                            out.write(sepChar);
                            out.write(dssPathString.toString());
                            out.newLine();
                            out.flush();
                            String numberOfCurvesPaths = "Different Number of Curves:" + sepChar + dssPathString.toString();
                            dsr.numberOfCurvesDatasetPathsLIST.add(numberOfCurvesPaths);
                            ++dsr.numberOfCurvesDatasetPathsCounter;
                            continue;
                        }
                        if (dataSetResults.getResultSType() == DataSetResults.ResultsType.DIFFERENT_LENGTHS) {
                            out.write("Different Lengths:");
                            out.write(sepChar);
                            out.write(dssPathString.toString());
                            out.newLine();
                            out.flush();
                            String invalidTSPaths = "Different Lengths:" + sepChar + dssPathString.toString();
                            dsr.differentLengthPathsLIST.add(invalidTSPaths);
                            ++dsr.differentLengthPathsCounter;
                            continue;
                        }
                        if (dataSetResults.getResultSType() == DataSetResults.ResultsType.INVALID_DATA_CONTAINER) {
                            out.write("Invalid Data Containers:");
                            out.write(sepChar);
                            out.write(dssPathString.toString());
                            out.newLine();
                            out.flush();
                            String invalidDataContainersPath = "Invalid Data Containers:" + sepChar + dssPathString.toString();
                            dsr.invalidDataContainerPathsLIST.add(invalidDataContainersPath);
                            ++dsr.invalidDataContainerCounter;
                            continue;
                        }
                        if (dataSetResults.getResultSType() == DataSetResults.ResultsType.DIFFERENCE_WITHIN_TOLERANCE && printAllResults) {
                            out.write("WITHIN:");
                            out.write(sepChar);
                            out.write(dssPathString.toString());
                            out.newLine();
                            out.flush();
                            continue;
                        }
                        if (dataSetResults.getResultSType() != DataSetResults.ResultsType.NO_DIFFERENCE_FOUND || !printAllResults) continue;
                        out.write("NODIFF:");
                        out.write(sepChar);
                        out.write(dssPathString.toString());
                        out.newLine();
                        out.flush();
                    }
                    catch (IOException ioe) {
                        if (!DEBUG) continue;
                        System.out.println("dssCompareOutputFile: Error accessing dssCompareOutputFile Error:" + ioe);
                        ioe.printStackTrace();
                    }
                }
            }
        }
        return dsr;
    }

    private List<List<String>> getPathnamesList(DSSFile targetDssFile, String[] scanStrings) {
        ArrayList<List<String>> dssPathListReference = new ArrayList<List<String>>();
        for (int indx = 0; indx < scanStrings.length; ++indx) {
            if (indx == 0) {
                dssPathListReference.add(targetDssFile.getCatalogedPathnames(scanStrings[0], true));
                continue;
            }
            dssPathListReference.add(targetDssFile.getCatalogedPathnames(scanStrings[indx]));
        }
        return dssPathListReference;
    }

    public static DataSetResults compareDataSet(TimeSeriesContainer referenceDataContainer, TimeSeriesContainer computedDataContainer) {
        double tol = 0.01;
        return DssCompare.compareDataSet(referenceDataContainer.values, computedDataContainer.values, tol);
    }

    public static ArrayList<DataSetResults> compareDataSet(DataContainer referenceDataContainer, DataContainer computedDataContainer, double[] tolerances) {
        IS_DATA_CONTAINER = true;
        if (computedDataContainer instanceof PairedDataContainer && referenceDataContainer instanceof PairedDataContainer) {
            return DssCompare.compareDataSet((PairedDataContainer)referenceDataContainer, (PairedDataContainer)computedDataContainer, tolerances);
        }
        if (computedDataContainer instanceof TimeSeriesContainer && referenceDataContainer instanceof TimeSeriesContainer) {
            ArrayList<DataSetResults> dataSetResultsList = new ArrayList<DataSetResults>();
            dataSetResultsList.add(DssCompare.compareDataSet((TimeSeriesContainer)referenceDataContainer, (TimeSeriesContainer)computedDataContainer, tolerances[0]));
            return dataSetResultsList;
        }
        ArrayList<DataSetResults> dataSetResultsList = new ArrayList<DataSetResults>();
        DataSetResults dsr = new DataSetResults();
        dsr.setResultSType(DataSetResults.ResultsType.INVALID_DATA_CONTAINER);
        dataSetResultsList.add(dsr);
        return dataSetResultsList;
    }

    private static ArrayList<DataSetResults> compareDataSet(PairedDataContainer referencePairedDataContainer, PairedDataContainer computedPairedDataContainer, double[] tolerances) {
        double[] tolerancesToUse;
        ArrayList<DataSetResults> dataSetResultsList = new ArrayList<DataSetResults>();
        String[] computedLabels = computedPairedDataContainer.labels;
        String[] referenceLabels = referencePairedDataContainer.labels;
        String[] computedUnits = computedPairedDataContainer.units;
        String[] referenceUnits = referencePairedDataContainer.units;
        if (tolerances.length == 1) {
            double tol = tolerances[0];
            tolerancesToUse = new double[computedPairedDataContainer.yOrdinates.length + 1];
            Arrays.fill(tolerancesToUse, tol);
        } else {
            tolerancesToUse = tolerances;
        }
        double[] xOrdsComputedValues = computedPairedDataContainer.xOrdinates;
        double[] xOrdsReferenceValues = referencePairedDataContainer.xOrdinates;
        DataSetResults xOrdsDataSetResults = DssCompare.compareDataSet(xOrdsReferenceValues, xOrdsComputedValues, tolerances[0]);
        xOrdsDataSetResults.setName("X Ordinates");
        dataSetResultsList.add(xOrdsDataSetResults);
        if (computedPairedDataContainer.yOrdinates.length != referencePairedDataContainer.yOrdinates.length) {
            DataSetResults dsr = new DataSetResults();
            dsr.setResultSType(DataSetResults.ResultsType.DIFFERENCE_WITH_NUMBER_OF_CURVES);
            dsr.setComputedLength(computedPairedDataContainer.yOrdinates.length);
            dsr.setReferenceLength(referencePairedDataContainer.yOrdinates.length);
            dsr.setName("No Curve");
            dataSetResultsList.add(dsr);
            return dataSetResultsList;
        }
        if (tolerancesToUse.length < 2 && computedPairedDataContainer.yOrdinates != null && computedPairedDataContainer.yOrdinates.length > 0) {
            DataSetResults dsr = new DataSetResults();
            dsr.setResultSType(DataSetResults.ResultsType.INVALID_TOLERANCES);
            dsr.setName("No Curve");
            dataSetResultsList.add(dsr);
            return dataSetResultsList;
        }
        for (int i = 0; i < computedPairedDataContainer.yOrdinates.length; ++i) {
            DataSetResults results = new DataSetResults();
            if (computedLabels != null && referenceLabels != null && computedLabels[i] != null && referenceLabels[i] != null && !computedLabels[i].equals(referenceLabels[i])) {
                results.setResultSType(DataSetResults.ResultsType.DIFFERENCE_WITH_LABELS);
                results.setName("Curve " + i);
                dataSetResultsList.add(results);
                continue;
            }
            if (computedUnits != null && referenceUnits != null && computedUnits[i] != null && referenceUnits[i] != null && !computedUnits[i].equals(referenceUnits[i])) {
                results.setResultSType(DataSetResults.ResultsType.DIFFERENT_UNITS);
                DssCompare.setDSRNameByCurveLabel(results, computedLabels, i);
                dataSetResultsList.add(results);
                continue;
            }
            results = DssCompare.compareDataSet(referencePairedDataContainer.yOrdinates[i], computedPairedDataContainer.yOrdinates[i], tolerancesToUse[i + 1]);
            DssCompare.setDSRNameByCurveLabel(results, computedLabels, i);
            dataSetResultsList.add(results);
        }
        return dataSetResultsList;
    }

    private static void setDSRNameByCurveLabel(DataSetResults results, String[] curveLabels, int curveIndex) {
        if (curveLabels != null) {
            String name = curveLabels[curveIndex];
            if (name != null) {
                results.setName(curveLabels[curveIndex]);
            } else {
                results.setName("Curve " + curveIndex + " (label is null)");
            }
        } else {
            results.setName("Curve " + curveIndex);
        }
    }

    public static DataSetResults compareDataSet(double[] referenceDataArray, double[] computedDataArray, double tolerance) {
        double dx = 0.0;
        double maxAbsDiff = 0.0;
        double meanDiff = 0.0;
        double mnAbsDiff = 0.0;
        double rmsNumerator = 0.0;
        DataSetResults.ResultsType resultsType = DataSetResults.ResultsType.NO_DIFFERENCE_FOUND;
        ParamDouble tolValue = new ParamDouble();
        tolValue.setValue(tolerance);
        int precision = tolValue.getPrecision();
        if (tolerance == 1.0) {
            precision = 0;
        }
        DataSetResults dataSetResults = new DataSetResults();
        if (computedDataArray.length != referenceDataArray.length) {
            if (DEBUG) {
                System.out.println("Arrays are not the same length");
            }
            dataSetResults.setResultSType(DataSetResults.ResultsType.DIFFERENT_LENGTHS);
            dataSetResults.setComputedLength(computedDataArray.length);
            dataSetResults.setReferenceLength(referenceDataArray.length);
            return dataSetResults;
        }
        if (computedDataArray.length == 0 && referenceDataArray.length == 0) {
            if (DEBUG) {
                System.out.println("WARNING: Both Arrays are empty");
            }
            dataSetResults.setResultSType(DataSetResults.ResultsType.NO_DIFFERENCE_FOUND);
            return dataSetResults;
        }
        int numberGood = 0;
        boolean foundMissing = false;
        for (int i = 0; i < computedDataArray.length; ++i) {
            if (i < computedDataArray.length && computedDataArray[i] != -3.4028234663852886E38 && i < referenceDataArray.length && referenceDataArray[i] != -3.4028234663852886E38) {
                if (Double.compare(computedDataArray[i], referenceDataArray[i]) == 0) {
                    dx = 0.0;
                    if (Math.abs(dx) > maxAbsDiff) {
                        maxAbsDiff = Math.abs(dx);
                    }
                    meanDiff += dx;
                    mnAbsDiff += Math.abs(dx);
                    rmsNumerator += dx * dx;
                    ++numberGood;
                    continue;
                }
                double computedValue = computedDataArray[i];
                double referenceValue = referenceDataArray[i];
                dx = computedValue - referenceValue;
                if (DssCompare.isInvalidValue(dx)) {
                    try {
                        if (IS_DATA_CONTAINER && _referenceHecMath != null && _referenceHecMath.getData() != null && _referenceHecMath.getData() instanceof DataContainer) {
                            if (DEBUG) {
                                System.out.println("WARNING: Both reference (" + _computedHecMath.getData() + ") and computed (" + _referenceHecMath.getData() + ") data containers have missing values");
                                System.out.println("Paths: " + _referencePathname);
                            }
                        } else if (DEBUG) {
                            System.out.println("WARNING: Both reference and computed data arrays have missing values");
                        }
                    }
                    catch (HecMathException e) {
                        e.printStackTrace();
                    }
                    if (DssCompare.isInvalidValue(computedValue) && DssCompare.isValidValue(referenceValue)) {
                        dataSetResults.setResultSType(DataSetResults.ResultsType.MISSING_COMPUTED_DATASET);
                    } else {
                        dataSetResults.setResultSType(DataSetResults.ResultsType.MISSING_DATASET);
                    }
                    dataSetResults.maxAbsDiff = -901.0;
                    dataSetResults.meanDiff = -901.0;
                    dataSetResults.rootMeanSquareDiff = -901.0;
                    return dataSetResults;
                }
                if (Math.abs(dx) > maxAbsDiff) {
                    maxAbsDiff = Math.abs(dx);
                }
                meanDiff += dx;
                mnAbsDiff += Math.abs(dx);
                rmsNumerator += dx * dx;
                ++numberGood;
                continue;
            }
            if (RMAConst.isUndefinedValue(referenceDataArray[i]) && RMAConst.isValidValue(computedDataArray[i])) {
                if (IS_DATA_CONTAINER && DEBUG) {
                    System.out.println(_referencePathname + " has undefined value where computed array has valid value");
                }
                dataSetResults.setResultSType(DataSetResults.ResultsType.DIFFERENCE_OUTSIDE_OF_TOLERANCE);
                dataSetResults.maxAbsDiff = -901.0;
                dataSetResults.meanDiff = -901.0;
                dataSetResults.rootMeanSquareDiff = -901.0;
                return dataSetResults;
            }
            if (RMAConst.isUndefinedValue(computedDataArray[i]) && RMAConst.isValidValue(referenceDataArray[i])) {
                if (IS_DATA_CONTAINER && DEBUG) {
                    System.out.println(_referencePathname + " has a value where reference array has undefined value");
                }
                dataSetResults.setResultSType(DataSetResults.ResultsType.DIFFERENCE_OUTSIDE_OF_TOLERANCE);
                dataSetResults.maxAbsDiff = -901.0;
                dataSetResults.meanDiff = -901.0;
                dataSetResults.rootMeanSquareDiff = -901.0;
                return dataSetResults;
            }
            if (!RMAConst.isUndefinedValue(referenceDataArray[i]) || !RMAConst.isUndefinedValue(computedDataArray[i])) continue;
            if (!foundMissing) {
                if (IS_DATA_CONTAINER && DEBUG) {
                    System.out.println("WARNING: Both reference and computed data containers have missing values at " + _referencePathname);
                }
                foundMissing = true;
            }
            if (Math.abs(dx = 0.0) > maxAbsDiff) {
                maxAbsDiff = Math.abs(dx);
            }
            meanDiff += dx;
            mnAbsDiff += Math.abs(dx);
            rmsNumerator += dx * dx;
            ++numberGood;
        }
        try {
            maxAbsDiff = Double.parseDouble(RMAIO.setPrecision2(maxAbsDiff, precision));
        }
        catch (NumberFormatException nfe) {
            maxAbsDiff = 0.0;
        }
        dataSetResults.maxAbsDiff = maxAbsDiff;
        try {
            meanDiff /= (double)numberGood;
            meanDiff = Double.parseDouble(RMAIO.setPrecision2(meanDiff, precision));
        }
        catch (NumberFormatException nfe) {
            meanDiff = 0.0;
        }
        dataSetResults.meanDiff = meanDiff;
        try {
            mnAbsDiff /= (double)numberGood;
            mnAbsDiff = Double.parseDouble(RMAIO.setPrecision2(mnAbsDiff, precision));
        }
        catch (NumberFormatException nfe) {
            mnAbsDiff = 0.0;
        }
        dataSetResults.mnAbsDiff = mnAbsDiff;
        if (!DssCompare.isNumeric(Double.toString(rmsNumerator))) {
            rmsNumerator = 0.0;
        }
        double rootMeanSquareDiff = Math.sqrt(rmsNumerator / (double)numberGood);
        try {
            rootMeanSquareDiff = Double.parseDouble(RMAIO.setPrecision2(rootMeanSquareDiff, precision));
        }
        catch (NumberFormatException nfe) {
            rootMeanSquareDiff = 0.0;
        }
        dataSetResults.rootMeanSquareDiff = rootMeanSquareDiff;
        if (dataSetResults.maxAbsDiff == 0.0 && dataSetResults.meanDiff == 0.0 && dataSetResults.rootMeanSquareDiff == 0.0) {
            resultsType = DssCompare.setResultsType(dataSetResults.getResultSType(), DataSetResults.ResultsType.NO_DIFFERENCE_FOUND);
            dataSetResults.setResultSType(resultsType);
        } else if (dataSetResults.maxAbsDiff <= tolerance && dataSetResults.meanDiff <= tolerance && dataSetResults.rootMeanSquareDiff <= tolerance) {
            resultsType = DssCompare.setResultsType(dataSetResults.getResultSType(), DataSetResults.ResultsType.DIFFERENCE_WITHIN_TOLERANCE);
            dataSetResults.setResultSType(resultsType);
        } else if (dataSetResults.maxAbsDiff > tolerance || dataSetResults.meanDiff > tolerance || dataSetResults.rootMeanSquareDiff > tolerance) {
            resultsType = DssCompare.setResultsType(dataSetResults.getResultSType(), DataSetResults.ResultsType.DIFFERENCE_OUTSIDE_OF_TOLERANCE);
            dataSetResults.setResultSType(resultsType);
        } else {
            resultsType = DssCompare.setResultsType(dataSetResults.getResultSType(), DataSetResults.ResultsType.MISSING_DATASET);
            dataSetResults.setResultSType(resultsType);
        }
        return dataSetResults;
    }

    private static boolean isInvalidValue(double value) {
        return value == -901.0 || value == -901.0 || value == -901.0 || value == -3.4028234663852886E38 || value == -3.4028234663852886E38 || value == Double.NEGATIVE_INFINITY || value == Double.NEGATIVE_INFINITY || value == -9.223372036854776E18 || value == -2.147483648E9 || Double.isNaN(value) || Float.isNaN((float)value) || value == Double.NEGATIVE_INFINITY || value == Double.NEGATIVE_INFINITY || value == Double.POSITIVE_INFINITY || value == Double.POSITIVE_INFINITY;
    }

    private static boolean isValidValue(double value) {
        return !DssCompare.isInvalidValue(value);
    }

    private static DataSetResults compareDataSet(TimeSeriesContainer referenceTSC, TimeSeriesContainer computedTSC, double tol) {
        String computedUnits;
        if (referenceTSC == null || computedTSC == null) {
            DataSetResults dsr = new DataSetResults();
            dsr.setResultSType(DataSetResults.ResultsType.INVALID_DATA_CONTAINER);
            return dsr;
        }
        if (referenceTSC.units != null && computedTSC.units != null && !referenceTSC.units.equals(computedTSC.units)) {
            DataSetResults dsr = new DataSetResults();
            dsr.setResultSType(DataSetResults.ResultsType.DIFFERENT_UNITS);
            return dsr;
        }
        String referenceUnits = referenceTSC.getUnits();
        if (!Objects.equals(referenceUnits, computedUnits = computedTSC.getUnits())) {
            DataSetResults dsr = new DataSetResults();
            dsr.setResultSType(DataSetResults.ResultsType.DIFFERENT_UNITS);
            return dsr;
        }
        if (referenceTSC.values == null) {
            DataSetResults dsr = new DataSetResults();
            dsr.setResultSType(DataSetResults.ResultsType.MISSING_DATASET);
            return dsr;
        }
        if (computedTSC.values == null) {
            DataSetResults dsr = new DataSetResults();
            dsr.setResultSType(DataSetResults.ResultsType.MISSING_COMPUTED_DATASET);
            return dsr;
        }
        return DssCompare.compareDataSet(referenceTSC.values, computedTSC.values, tol);
    }

    private static DataSetResults.ResultsType setResultsType(DataSetResults.ResultsType current, DataSetResults.ResultsType next) {
        if (current == null) {
            current = next;
        } else if (current.ordinal() < next.ordinal()) {
            current = next;
        }
        return current;
    }

    private static boolean isNumeric(String numericString) {
        try {
            Double.parseDouble(numericString);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this._progressListener = progressListener;
    }

    public static void main(String[] args) {
        DssCompare comparator = new DssCompare();
        String[] paths = new String[]{"B=*"};
        String computedFilePath = "C:\\Users\\patrick\\Desktop\\pdc\\Big Guys\\";
        double[] tols = new double[]{0.1};
        comparator.getDataSetResults(computedFilePath + "CC-FRA_50year.dss", computedFilePath + "CC-FRA_50year-Ref.dss", "01Jan1900", "01Jan2016", computedFilePath + "output.txt", paths, tols);
    }

    static {
        DEBUG = false;
        IS_DATA_CONTAINER = false;
    }
}

