/*
 * Decompiled with CFR 0.152.
 */
package hec.hecmath;

import hec.heclib.util.HecTime;
import hec.heclib.util.Heclib;
import hec.hecmath.DurationPeriod;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;

public class DurationAnalysis {
    public static final int PLOT_EXCEEDANCE_HORIZONTAL = 0;
    public static final int PLOT_PROBABILITY_HORIZONTAL = 1;
    public static final int PLOT_LINEAR_VERTICAL = 0;
    public static final int PLOT_LOG_VERTICAL = 1;
    public static final int PLOTTING_POINTS_TRADITIONAL = 0;
    public static final int PLOTTING_POINTS_USER_DEFINED = 1;
    public static final int PLOTTING_POINTS_ALL = 2;
    public static final int BIN_LIMITS_EVEN = 0;
    public static final int BIN_LIMITS_LOG = 1;
    public static final int BIN_LIMITS_USER_DEFINED = 2;
    public int intervalType = -1;
    public int qualityTest = 0;
    protected DurationPeriod[] _durationPeriods;
    protected HecTime[] _startOfPeriods;
    protected HecTime[] _endOfPeriods;
    protected TimeSeriesContainer _tsc = null;
    public static final double[] defaultFrequencies = new double[]{0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 15.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 85.0, 90.0, 95.0, 98.0, 99.0, 99.5, 99.8, 99.9};
    protected int _durationPeriodType;
    protected String _durationInterval;
    protected double[] _plottingPoints;

    public void setDurationPeriodType(String periodTypeStr, int startTime, int endTime, int interval, int timeGranularitySeconds, int julianBaseDate) {
        int periodType = -1;
        if (periodTypeStr.equalsIgnoreCase(DurationPeriod.DURATION_PERIOD_STRINGS[3])) {
            periodType = 3;
        } else if (periodTypeStr.equalsIgnoreCase(DurationPeriod.DURATION_PERIOD_STRINGS[0])) {
            periodType = 0;
        } else if (periodTypeStr.equalsIgnoreCase(DurationPeriod.DURATION_PERIOD_STRINGS[1])) {
            periodType = 1;
        } else if (periodTypeStr.equalsIgnoreCase(DurationPeriod.DURATION_PERIOD_STRINGS[2])) {
            periodType = 2;
        } else {
            return;
        }
        this.setDurationPeriodType(periodType, startTime, endTime, interval, timeGranularitySeconds, julianBaseDate);
    }

    public void setDurationPeriodType(int periodType, int startTime, int endTime, int interval, int timeGranularitySeconds, int julianBaseDate) {
        if (periodType == 0) {
            this._durationPeriods = new DurationPeriod[1];
            this._durationPeriods[0] = new DurationPeriod(0, "01JAN3000", "31DEC3000");
            this._durationPeriods[0].setName("JAN-DEC");
        } else if (periodType == 1) {
            this._durationPeriods = new DurationPeriod[4];
            this._durationPeriods[0] = new DurationPeriod(1, "01JAN", "31MAR");
            this._durationPeriods[1] = new DurationPeriod(1, "01APR", "30JUN");
            this._durationPeriods[2] = new DurationPeriod(1, "01JUL", "30SEP");
            this._durationPeriods[3] = new DurationPeriod(1, "01OCT", "31DEC");
            this._durationPeriods[0].setName("JAN-MAR");
            this._durationPeriods[1].setName("APR-JUN");
            this._durationPeriods[2].setName("JUL-SEP");
            this._durationPeriods[3].setName("OCT-DEC");
        } else if (periodType == 2) {
            this._durationPeriods = new DurationPeriod[12];
            this._durationPeriods[0] = new DurationPeriod(2, "01JAN", "31JAN");
            this._durationPeriods[1] = new DurationPeriod(2, "01FEB", "28FEB");
            this._durationPeriods[2] = new DurationPeriod(2, "01MAR", "31MAR");
            this._durationPeriods[3] = new DurationPeriod(2, "01APR", "30APR");
            this._durationPeriods[4] = new DurationPeriod(2, "01MAY", "31MAY");
            this._durationPeriods[5] = new DurationPeriod(2, "01JUN", "30JUN");
            this._durationPeriods[6] = new DurationPeriod(2, "01JUL", "31JUL");
            this._durationPeriods[7] = new DurationPeriod(2, "01AUG", "31AUG");
            this._durationPeriods[8] = new DurationPeriod(2, "01SEP", "30SEP");
            this._durationPeriods[9] = new DurationPeriod(2, "01OCT", "31OCT");
            this._durationPeriods[10] = new DurationPeriod(2, "01NOV", "30NOV");
            this._durationPeriods[11] = new DurationPeriod(2, "01DEC", "31DEC");
            this._durationPeriods[0].setName("JAN");
            this._durationPeriods[1].setName("FEB");
            this._durationPeriods[2].setName("MAR");
            this._durationPeriods[3].setName("APR");
            this._durationPeriods[4].setName("MAY");
            this._durationPeriods[5].setName("JUN");
            this._durationPeriods[6].setName("JUL");
            this._durationPeriods[7].setName("AUG");
            this._durationPeriods[8].setName("SEP");
            this._durationPeriods[9].setName("OCT");
            this._durationPeriods[10].setName("NOV");
            this._durationPeriods[11].setName("DEC");
        } else if (periodType != 3) {
            return;
        }
        HecTime start = new HecTime();
        HecTime end = new HecTime();
        start.set(startTime, timeGranularitySeconds, julianBaseDate);
        end.set(endTime, timeGranularitySeconds, julianBaseDate);
        int[] stat = new int[1];
        this._durationInterval = Heclib.getEPartFromInterval(interval, stat) + ": " + start.date(104) + "-" + end.date(104);
        this._durationPeriodType = periodType;
        if (this._durationPeriods != null) {
            for (int i = 0; i < this._durationPeriods.length; ++i) {
                this._durationPeriods[i].setInterval(this._durationInterval);
            }
        }
    }

    public void setOtherDefinedDurationPeriods(DurationPeriod[] durationPeriods) {
        this._durationPeriods = durationPeriods;
        this._durationPeriodType = 3;
    }

    public boolean filterTimeSeries(TimeSeriesContainer tsc) {
        this._tsc = tsc;
        int nperiods = this._durationPeriods.length;
        for (int i = 0; i < nperiods; ++i) {
            this._durationPeriods[i].filterTimeSeries(tsc);
        }
        return true;
    }

    public void setPlottingPoints(double[] plottingPoints) {
        this._plottingPoints = plottingPoints;
    }

    public PairedDataContainer[] computeDurationAnalysis(boolean standardMethod, int binDistribution, int numberBins, double[] binLimits, int plottingPointsMethod, double[] userDefinedPoints, int horizontalScale, int verticalScale) {
        double[] plottingPoints = null;
        if (plottingPointsMethod == 0) {
            plottingPoints = defaultFrequencies;
        } else if (userDefinedPoints != null) {
            plottingPoints = userDefinedPoints;
        }
        if (!standardMethod && binLimits == null) {
            boolean useLog = false;
            if (binDistribution == 1) {
                useLog = true;
            }
            if (this._tsc != null && this._tsc.values != null) {
                binLimits = DurationPeriod.computeBinLimits(this._tsc.values, numberBins, useLog);
            } else {
                return null;
            }
        }
        int nperiods = this._durationPeriods.length;
        PairedDataContainer[] results = new PairedDataContainer[nperiods];
        for (int i = 0; i < nperiods; ++i) {
            results[i] = standardMethod ? (plottingPointsMethod == 2 ? this._durationPeriods[i].computeAll() : this._durationPeriods[i].compute(plottingPoints, horizontalScale)) : this._durationPeriods[i].computeBins(binLimits, plottingPoints, horizontalScale);
            results[i].xtype = horizontalScale == 1 ? "PROB" : "";
            results[i].ytype = verticalScale == 1 ? "LOG" : "";
        }
        return results;
    }

    public DurationPeriod[] getDurationPeriods() {
        return this._durationPeriods;
    }

    public int getDurationPeriodType() {
        return this._durationPeriodType;
    }
}

